DECLARE SUB InitBWSB ()
DECLARE SUB PlayMod (ModFile$)
DECLARE SUB UnloadMod ()
DECLARE SUB SetTemp ()
DECLARE SUB SetPal (slot%, r%, g%, B%)
DECLARE SUB ReadPal (slot%, r%, g%, B%)
DECLARE SUB FadeOut (amount)
DECLARE SUB FadeIn (amount)
DECLARE SUB savepal ()
DECLARE SUB Intro ()
DECLARE SUB Pal (FileName$)
DECLARE SUB GameComplete ()
DECLARE SUB AskWhat ()
DECLARE SUB GameOver ()
DECLARE SUB ShowLives ()
DECLARE SUB Teleport (Where$)
DECLARE SUB CheckNumbered ()
DECLARE SUB Page (num%)
DECLARE SUB Help ()
DECLARE SUB HighScore ()
DECLARE SUB Credits ()
DECLARE SUB Delay (Time!)
DECLARE SUB TitleScreen ()
DECLARE SUB FinishLevel ()
DECLARE SUB LoseLife ()
DECLARE SUB Down ()
DECLARE SUB Right ()
DECLARE SUB Left ()
DECLARE SUB PutCar2 ()
DECLARE SUB Up ()
DECLARE SUB PutCar ()
DECLARE SUB ShowMap ()
DECLARE SUB Loadmap (X%)
DECLARE SUB LoadGraphics ()

'$INCLUDE: 'BWSB.BI'
'$INCLUDE: 'GDMTYPE.BI'
'$DYNAMIC
DEFINT A-Z

TYPE MSEConfigFile
	SoundCard     AS INTEGER
	BaseIO        AS INTEGER
	IRQ           AS INTEGER
	DMA           AS INTEGER
	SoundQuality  AS INTEGER
END TYPE

TYPE RegTypeX
	ax AS INTEGER
	bx AS INTEGER
	cx AS INTEGER
	dx AS INTEGER
	bp AS INTEGER
	SI AS INTEGER
	DI AS INTEGER
	Flags AS INTEGER
	ds AS INTEGER
	es AS INTEGER
END TYPE

TYPE RegType
	ax AS INTEGER
	bx AS INTEGER
	cx AS INTEGER
	dx AS INTEGER
	bp AS INTEGER
	SI AS INTEGER
	DI AS INTEGER
	Flags AS INTEGER
END TYPE

DIM SHARED ModHead         AS GDMHeader       'Module Header
DIM SHARED SndDevMSE(6)    AS STRING          'Array of MSE file names
DIM SHARED MSEConfig       AS MSEConfigFile   'Structure of MSE configuration file

DIM SHARED red%(255)
DIM SHARED green%(255)
DIM SHARED blue%(255)
DIM SHARED Sprite%(1050), Mask%(104), TempCheck%(20, 20), Handler%
DIM SHARED MapData$(20), Score$(11), Score!(11), Life%, MusicOn%
DIM SHARED NowScore!, TimeLeft%, BonusFlag%, Stage$, Lastlimit!
DIM SHARED TimeLimit%, Check%, Numbered%, TimeDeath%, TempTile%
DIM SHARED Xa%, Ya%, Xb%, Yb%, Restart%, Level%, LevelNum%
DEFINT A-Z

ON ERROR GOTO Handler

OPEN "check.dat" FOR INPUT AS #1
	INPUT #1, A$
CLOSE #1

IF A$ = "n" THEN
	SHELL "SETUP.EXE"
	OPEN "check.dat" FOR OUTPUT AS #1
		PRINT #1, "y"
	CLOSE #1
END IF

SCREEN 13

LoadGraphics
InitBWSB
PlayMod "music\music1.gdm"
Intro
TitleScreen

RestartLevel:
CALL StopMusic: StopOutput
PlayMod "music\music2.gdm"
Restart% = 0
Loadmap Level%
ShowLives
ShowMap

TimeLeft% = TimeLimit%: TimeFlag% = 0: TempTile% = 1
LOCATE 21, 27: PRINT TimeLeft%
LOCATE 23, 27: PRINT " 6 Seconds."
DO
TimeDeath% = 6

DO
	Start! = TIMER
	IF TimeFlag% = 2 THEN TimeFlag% = 0
		DO
			Key$ = INKEY$
			LOCATE 17, 27: PRINT NowScore!
			IF Key$ = CHR$(0) + "H" AND Yb% > 0 THEN Teleport "Up": Yb% = Yb% - 1: SetTemp: NowScore! = NowScore! + 50: Check% = Check% - 1: Up
			IF Key$ = CHR$(0) + "P" AND Yb% < 19 THEN Teleport "Down": Yb% = Yb% + 1: SetTemp: NowScore! = NowScore! + 50: Check% = Check% - 1: Down
			IF Key$ = CHR$(0) + "M" AND Xb% < 19 THEN Teleport "Right": Xb% = Xb% + 1: SetTemp: NowScore! = NowScore! + 50: Check% = Check% - 1: Right
			IF Key$ = CHR$(0) + "K" AND Xb% > 0 THEN Teleport "Left": Xb% = Xb% - 1: SetTemp: NowScore! = NowScore! + 50: Check% = Check% - 1: Left
			IF Key$ = CHR$(27) THEN Credits
			IF Check% = -1 AND MID$(MapData$(Yb% + 1), Xb% + 1, 1) = "3" AND Numbered% = 0 THEN FinishLevel: GOTO RestartLevel
			IF MID$(MapData$(Yb% + 1), Xb% + 1, 1) = "3" AND Check% <> -1 THEN LoseLife: Restart% = 1
			IF Restart% <> 0 THEN GOTO RestartLevel
		LOOP UNTIL TIMER - Start! >= .5
		IF TimeFlag% = 1 THEN TimeLeft% = TimeLeft% - 1: TimeDeath% = TimeDeath% - 1
		TimeFlag% = TimeFlag% + 1
		LOCATE 21, 27: PRINT TimeLeft%
		LOCATE 23, 27: PRINT TimeDeath%; "Seconds."
		BonusFlag% = 0
		IF TimeLeft% <= 0 THEN LoseLife: GOTO RestartLevel
LOOP UNTIL TimeDeath% = 0

CALL LoseLife: GOTO RestartLevel
LOOP UNTIL INKEY$ = CHR$(27)
Credits

Handler:

CLS
PRINT "An Error Has Accored. Please Contact the Programmer"
Credits

REM $STATIC
SUB AskWhat

LINE (0, 0)-(199, 199), 0, BF
LOCATE 1, 1: PRINT "Input the Stage Name"
PRINT "(4 Letters only)"
WhatThe:
LOCATE 3, 1: INPUT "Stagename "; Stage$
IF LEN(Stage$) <> 4 THEN PRINT "Not a Valid Name": GOTO WhatThe
Stage$ = UCASE$(Stage$)

File = FREEFILE
OPEN "map\" + Stage$ + ".dat" FOR INPUT AS File
	INPUT File, LevelNum%
CLOSE File

END SUB

SUB Credits
CLS

OPEN "black.hs" FOR INPUT AS #5
	FOR I = 1 TO 10
		INPUT #5, Score$(I)
	NEXT I
	FOR I = 1 TO 10
		INPUT #5, Score!(I)
	NEXT I
CLOSE #5

FOR num1 = 1 TO 10
	IF NowScore! > Score!(num1) THEN
		PRINT "You are Number "; num1; " in the Scores!"
		FOR I2% = 10 TO num1
			 Score$(I2%) = Score$(I2% + 1)
			 Score!(I2%) = Score!(I2% + 1)
		NEXT I2%
		INPUT "What is your name (9. Max) "; Score$(num1)
		IF LEN(Score$(num1)) > 9 THEN Score$(num1) = LEFT$(Score$(num1), 9)
		Score!(num1) = NowScore!
		OPEN "black.hs" FOR OUTPUT AS #5
			FOR I = 1 TO 10
				PRINT #5, Score$(I)
			NEXT I
			FOR I = 1 TO 10
				PRINT #5, Score!(I)
			NEXT I
		CLOSE #5
		GOTO ContinueAgain
	END IF
NEXT num1

ContinueAgain:

UnloadMod

SCREEN 0: WIDTH 80
CLS
PRINT "Thanks for playing!"
PRINT
PRINT "This game was programmed by Terry Cavanagh of Dark Legends Software."
PRINT "All Code by Terry Cavanagh, with the exception of the fade routines, which"
PRINT "are William Moores, another member of Dark Legends Software, and the sound "
PRINT "engine, BWSB. Also, although he doesnt know it, Darkdread was a great help"
PRINT "at getting BWSB to work (I examined the source code of Mysterious song.)"
PRINT
PRINT "Thanks very much for playing this game. This game and more like it will"
PRINT "be advailable at our website listed below. To get some information on our"
PRINT "RPG, "; :  COLOR 4: PRINT "Tales Of Utopia, press F1 now"; : COLOR 7: PRINT " ,or otherwise simply press Escape to quit."
PRINT
COLOR 4
PRINT "terrycavanagh@eircom.net"
PRINT "www.darklegends.com"

DO
	Key$ = INKEY$
	IF Key$ = CHR$(0) + ";" THEN
		CLS
		COLOR 15, 4
		PRINT "Tales of Utopia                                                 - Terry Cavanagh"
		COLOR 15, 0
		PRINT
		PRINT "Tales of Utopia will be Dark Legends First Role Playing Game. The plot was made "
		PRINT "long before the idea to make a Role Playing Game was concieved, and trust me,   "
		PRINT "the plot is very good. I will begin Tales Of Utopia right after I've completed  "
		PRINT "this game. I have been considering a fantastic battle engine, it's all just     "
		PRINT "imagination at the moment, but the battles should be the most fun part of the   "
		PRINT "game. Unlike other RPG's, which either use the battle engine concept of a       "
		PRINT "different game or RPG's which make a new and confusing battle engine of their   "
		PRINT "own, Tales of Utopia takes the best bits from games like Bahamut Lagoon, Final  "
		PRINT "Fantasy III and Chrono Trigger to make an original battle system that is as     "
		PRINT "instinctive and regonizable as the classics mentained above. The story, however,"
		PRINT "should be the game's real strong point. There are quite a number of characters, "
		PRINT "all whom have extremly well devolped Plotlines and Backgrounds."
		PRINT
		PRINT "So prepare yourself for an epic classic in the making, pulling Past, Present    "
		PRINT "and Future into one world. Coming soon from Dark Legends Software."
		PRINT
		DO: LOOP UNTIL INKEY$ <> ""
		COLOR 7
	END IF
LOOP UNTIL Key$ <> ""
COLOR 7
END

END SUB

SUB Delay (Time!)

Start! = TIMER

DO: LOOP UNTIL TIMER - Start! >= Time!

END SUB

SUB Down

PutCar2

PUT (Xb% * 10, (Yb% - 1) * 10), Sprite(0), PSET

IF MID$(MapData$(Yb%), Xb% + 1, 1) = "4" THEN
	PUT (Xb% * 10, (Yb% - 1) * 10), Sprite(420), PSET
END IF

IF MID$(MapData$(Yb%), Xb% + 1, 1) = "1" THEN
	MID$(MapData$(Yb%), Xb% + 1, 1) = "0"
END IF

IF MID$(MapData$(Yb%), Xb% + 1, 1) = "9" THEN
	MID$(MapData$(Yb%), Xb% + 1, 1) = "0"
END IF

IF MID$(MapData$(Yb%), Xb% + 1, 1) = "2" THEN
	MID$(MapData$(Yb%), Xb% + 1, 1) = "1"
	PUT (Xb% * 10, (Yb% - 1) * 10), Sprite(105), PSET
END IF

IF MID$(MapData$(Yb%), Xb% + 1, 1) = "5" THEN
	MID$(MapData$(Yb%), Xb% + 1, 1) = "2"
	PUT (Xb% * 10, (Yb% - 1) * 10), Sprite(210), PSET
END IF

IF TempTile% = 6 OR TempTile% = 7 OR TempTile% = 8 THEN
	IF TempTile% = 6 AND Numbered% = 1 THEN Numbered% = 0: GOTO Continue2
	IF TempTile% = 7 AND Numbered% = 2 THEN Numbered% = 1: GOTO Continue2
	IF TempTile% = 8 AND Numbered% = 3 THEN Numbered% = 2: GOTO Continue2
	CALL LoseLife: Restart% = 1
END IF

Continue2:

IF VAL(MID$(MapData$(Yb% + 1), Xb% + 1, 1)) = 0 THEN LoseLife: Restart% = 1

END SUB

DEFSNG A-Z
SUB FadeIn (amount)

FOR c = 1 TO amount
	FOR I% = 0 TO 255
		CALL ReadPal(I%, r%, g%, B%)
		r% = r% + 1: g% = g% + 1: B% = B% + 1
		IF r% > red%(I%) THEN r% = red%(I%)
		IF g% > green%(I%) THEN g% = green%(I%)
		IF B% > blue%(I%) THEN B% = blue%(I%)
		CALL SetPal(I%, r%, g%, B%)
	NEXT
NEXT

END SUB

SUB FadeOut (amount)
savepal
FOR c = 1 TO amount
FOR I% = 0 TO 255
CALL ReadPal(I%, r%, g%, B%)
r% = r% - 1: g% = g% - 1: B% = B% - 1
IF r% < 1 THEN r% = 0
IF g% < 1 THEN g% = 0
IF B% < 1 THEN B% = 0
CALL SetPal(I%, r%, g%, B%)
NEXT
NEXT

END SUB

DEFINT A-Z
SUB FinishLevel


CALL StopMusic: StopOutput
PlayMod "music\music3.gdm"

NowScore! = NowScore! + (100 * TimeLeft%)
LOCATE 17, 27: PRINT NowScore!

LINE (0, 0)-(199, 199), 0, BF
LOCATE 1, 1: PRINT "Level Complete!"
IF Level% + 1 > LevelNum% THEN GameComplete
IF Level% + 1 = LevelNum% THEN PRINT "Final Level!"
PRINT "Level "; Level% + 1
PRINT "Press Space to continue"
DO: LOOP UNTIL INKEY$ = " "
Level% = Level% + 1

END SUB

SUB GameComplete

CALL StopMusic: StopOutput
PlayMod "music\music3.gdm"

PRINT "CONGRATULATIONS!"

DO: LOOP UNTIL INKEY$ <> ""
Credits
END SUB

SUB GameOver

LINE (0, 0)-(199, 199), 0, BF
LOCATE 1, 1: PRINT "You have no lives."
PRINT "Press Space to continue"
DO: LOOP UNTIL INKEY$ = " "

Credits

END SUB

SUB Help

FOR I = 100 TO 5 STEP -5
	Delay .005
	TempX = 0: TempX2 = 199: TempY = 0: TempY2 = 199
	LINE (TempX + I, TempY + I)-(TempX2 - I, TempY2 - I), 0, BF
	LINE (TempX + I, TempY + I)-(TempX2 - I, TempY2 - I), 215, B
NEXT I

PageNum = 1

Refresh2:
Page PageNum

DO
	Key$ = INKEY$
	IF Key$ = CHR$(0) + "M" AND PageNum < 3 THEN PageNum = PageNum + 1: GOTO Refresh2
	IF Key$ = CHR$(0) + "K" AND PageNum > 1 THEN PageNum = PageNum - 1: GOTO Refresh2
LOOP UNTIL Key$ = CHR$(27)

END SUB

SUB HighScore

FOR I = 100 TO 5 STEP -5
	Delay .005
	TempX = 0: TempX2 = 199: TempY = 0: TempY2 = 199
	LINE (TempX + I, TempY + I)-(TempX2 - I, TempY2 - I), 0, BF
	LINE (TempX + I, TempY + I)-(TempX2 - I, TempY2 - I), 215, B
NEXT I

OPEN "black.hs" FOR INPUT AS #5
	FOR I = 1 TO 10
		INPUT #5, Score$(I)
	NEXT I
	FOR I = 1 TO 10
		INPUT #5, Score!(I)
	NEXT I
CLOSE #5

LOCATE 2, 2: PRINT "-----------------------"
LOCATE 3, 2: PRINT "  High Score Records   "
LOCATE 4, 2: PRINT "-----------------------"
FOR I = 1 TO 10
	LOCATE 3 + (I + I), 2: PRINT " "; Score$(I)
	LOCATE 3 + (I + I), 13: PRINT " : "; Score!(I)
NEXT I

DO: LOOP UNTIL INKEY$ <> ""

END SUB

REM $DYNAMIC
SUB InitBWSB

Freemem& = FRE(-1) - 80000
A& = SETMEM(-Freemem&)

SndDevMSE(1) = "GUS"
SndDevMSE(2) = "SB1X"
SndDevMSE(3) = "SB2X"
SndDevMSE(4) = "SBPRO"
SndDevMSE(5) = "SB16"
SndDevMSE(6) = "PAS"

OPEN "mse.cfg" FOR BINARY AS 1
	GET 1, , MSEConfig
CLOSE 1
MusicOn% = MSEConfig.SoundCard

IF MusicOn% = 0 THEN EXIT SUB
MSE$ = SndDevMSE(MSEConfig.SoundCard) + ".MSE"

SELECT CASE MSEConfig.SoundQuality
CASE 0: Ov = 16
CASE 1: Ov = 22
CASE 2: Ov = 45
CASE 3: Ov = 8
END SELECT

ErrorFlag = LoadMSE(MSE$, 0, Ov, 4096, MSEConfig.BaseIO, MSEConfig.IRQ, MSEConfig.DMA)

SELECT CASE ErrorFlag
CASE 0
CASE 1: PRINT "Base I/O address autodetection failure": END
CASE 2: PRINT "IRQ level autodetection failure": END
CASE 3: PRINT "DMA channel autodetection failure": END
CASE 4: PRINT "DMA channel not supported": END
CASE 6: PRINT "Sound device does not respond": END
CASE 7: PRINT "Memory control blocks destroyed": END
CASE 8: PRINT "Insufficient memory for mixing buffers": END
CASE 9: PRINT "Insufficient memory for MSE file": END
CASE 10: PRINT "MSE has invalid identification string (corrupt/non-existant)": END
CASE 11: PRINT "MSE disk read failure": END
CASE 12: PRINT "MVSOUND.SYS not loaded (required for PAS use)": END
CASE ELSE: PRINT "Unknown error on MSE startup" + STR$(ErrorFlag): END
END SELECT

END SUB

REM $STATIC
SUB Intro

Pal "logo.pal"

FOR I = 0 TO 255
	SetPal I, 0, 0, 0
NEXT I

DEF SEG = &HA000
BLOAD "graphics\logo.bsv"
DEF SEG

FadeIn 65
DO: LOOP UNTIL INKEY$ <> ""
FadeOut 65

CLS

END SUB

SUB Left

PutCar2

PUT ((Xb% + 1) * 10, Yb% * 10), Sprite(0), PSET

IF MID$(MapData$(Yb% + 1), Xb% + 2, 1) = "4" THEN
	PUT ((Xb% + 1) * 10, Yb% * 10), Sprite(420), PSET
END IF

IF MID$(MapData$(Yb% + 1), Xb% + 2, 1) = "9" THEN
	MID$(MapData$(Yb% + 1), Xb% + 2, 1) = "0"
END IF

IF MID$(MapData$(Yb% + 1), Xb% + 2, 1) = "1" THEN
	MID$(MapData$(Yb% + 1), Xb% + 2, 1) = "0"
END IF

IF MID$(MapData$(Yb% + 1), Xb% + 2, 1) = "2" THEN
	MID$(MapData$(Yb% + 1), Xb% + 2, 1) = "1"
	PUT ((Xb% + 1) * 10, Yb% * 10), Sprite(105), PSET
END IF

IF MID$(MapData$(Yb% + 1), Xb% + 2, 1) = "5" THEN
	MID$(MapData$(Yb% + 1), Xb% + 2, 1) = "2"
	PUT ((Xb% + 1) * 10, Yb% * 10), Sprite(210), PSET
END IF

IF TempTile% = 6 OR TempTile% = 7 OR TempTile% = 8 THEN
	IF TempTile% = 6 AND Numbered% = 1 THEN Numbered% = 0: GOTO Continue3
	IF TempTile% = 7 AND Numbered% = 2 THEN Numbered% = 1: GOTO Continue3
	IF TempTile% = 8 AND Numbered% = 3 THEN Numbered% = 2: GOTO Continue3
	CALL LoseLife: Restart% = 1
END IF

Continue3:

IF VAL(MID$(MapData$(Yb% + 1), Xb% + 1, 1)) = 0 THEN LoseLife: Restart% = 1

END SUB

DEFSNG A-Z
SUB LoadGraphics

FOR I = 1 TO 10
	X = I
	IF I = 10 THEN X = 0
	A$ = LTRIM$(STR$(X))
	DEF SEG = VARSEG(Sprite%(105 * X))
		BLOAD "graphics\tile" + A$ + ".til", VARPTR(Sprite%(105 * X))
	DEF SEG
NEXT I

DEF SEG = VARSEG(Mask%(0))
	BLOAD "graphics\mask.til", 0
DEF SEG

END SUB

SUB Loadmap (X%)

A$ = LTRIM$(STR$(X%))

OPEN "maps\" + Stage$ + A$ + ".map" FOR INPUT AS #5
	FOR I = 1 TO 20
		INPUT #5, MapData$(I)
	NEXT I
	INPUT #5, TimeLimit%
CLOSE #5

Check% = 0

Numbered% = 0

FOR TempY = 1 TO 20
	FOR TempX = 1 TO 20
		IF MID$(MapData$(TempY), TempX, 1) = "1" THEN Check% = Check% + 1
		IF MID$(MapData$(TempY), TempX, 1) = "2" THEN Check% = Check% + 2
		IF MID$(MapData$(TempY), TempX, 1) = "5" THEN Check% = Check% + 3
		IF MID$(MapData$(TempY), TempX, 1) = "6" THEN Check% = Check% + 1: Numbered% = Numbered% + 1
		IF MID$(MapData$(TempY), TempX, 1) = "7" THEN Check% = Check% + 1: Numbered% = Numbered% + 1
		IF MID$(MapData$(TempY), TempX, 1) = "8" THEN Check% = Check% + 1: Numbered% = Numbered% + 1
	NEXT TempX
NEXT TempY

END SUB

DEFINT A-Z
SUB LoseLife

Life% = Life% - 1
ShowLives
LINE (0, 0)-(199, 199), 0, BF
LOCATE 1, 1: PRINT "You Lose a Life"
PRINT "Press Space to continue"
DO: LOOP UNTIL INKEY$ = " "

END SUB

SUB Page (num)

IF num = 1 THEN
	COLOR 4
	LOCATE 2, 2: PRINT "-----------------------"
	LOCATE 3, 2: PRINT "Help File - Page 1 of 3"
	LOCATE 4, 2: PRINT "-----------------------"
	COLOR 215
	LOCATE 5, 2: PRINT "The Rules of Black Hole"
	LOCATE 6, 2: PRINT "are simple - You must  "
	LOCATE 7, 2: PRINT "navigate your pod      "
	LOCATE 8, 2: PRINT "across the tiles, which"
	LOCATE 9, 2: PRINT "fall behind you as you "
	LOCATE 10, 2: PRINT "walk. If you stay on a "
	LOCATE 11, 2: PRINT "tile for more than 6   "
	LOCATE 12, 2: PRINT "seconds, the tile falls"
	LOCATE 13, 2: PRINT "from under you. There's"
	LOCATE 14, 2: PRINT "some catches. You must "
	LOCATE 15, 2: PRINT "reach the red tile last"
	LOCATE 16, 2: PRINT "and it has to be the   "
	LOCATE 17, 2: PRINT "last tile left on the  "
	LOCATE 18, 2: PRINT "board. Then of couse,  "
	LOCATE 19, 2: PRINT "you have a time limit  "
	LOCATE 20, 2: PRINT "and new , trickier     "
	LOCATE 21, 2: PRINT "blocks as you Progress."
	COLOR 4
	LOCATE 22, 2: PRINT "-----------------------"
	LOCATE 23, 2: PRINT "Left, Right Change page"
	COLOR 215
END IF

IF num = 2 THEN
	COLOR 4
	LOCATE 2, 2: PRINT "-----------------------"
	LOCATE 3, 2: PRINT "Help File - Page 2 of 3"
	LOCATE 4, 2: PRINT "-----------------------"
	COLOR 215
	LOCATE 5, 2: PRINT "The following is a list"
	LOCATE 6, 2: PRINT "of the different tiles."
	LOCATE 7, 2: PRINT "                       "
	LOCATE 8, 2: COLOR 72: PRINT " Blue"; : COLOR 215: PRINT " Must Step on Once"
	LOCATE 9, 2: PRINT "                       "
	LOCATE 10, 2: COLOR 12: PRINT " Green"; : COLOR 215: PRINT "  Step on 2 Times"
	LOCATE 11, 2: PRINT "                       "
	LOCATE 12, 2: COLOR 35: PRINT " Yellow"; : COLOR 215: PRINT " Step on 3 Times"
	LOCATE 13, 2: PRINT "                       "
	LOCATE 14, 2: COLOR 5: PRINT " Red"; : COLOR 215: PRINT "  Must step on Last"
	LOCATE 15, 2: PRINT "                       "
	LOCATE 16, 2: PRINT " White        Teleports"
	LOCATE 17, 2: PRINT "                       "
	LOCATE 18, 2: COLOR 72: PRINT " 1,2,3"; : COLOR 215: PRINT "  Get from 3 to 1"
	LOCATE 19, 2: PRINT "       in countdown    "
	LOCATE 20, 2: PRINT "       order. (3,2,then"
	LOCATE 21, 2: PRINT "       1). V.Important!"
	COLOR 4
	LOCATE 22, 2: PRINT "-----------------------"
	LOCATE 23, 2: PRINT "Left, Right Change page"
	COLOR 215
END IF

IF num = 3 THEN
	COLOR 4
	LOCATE 2, 2: PRINT "-----------------------"
	LOCATE 3, 2: PRINT "Help File - Page 3 of 3"
	LOCATE 4, 2: PRINT "-----------------------"
	COLOR 215
	LOCATE 5, 2: PRINT "Score is obtained by : "
	LOCATE 6, 2: PRINT "                       "
	LOCATE 7, 2: PRINT "100 points for every   "
	LOCATE 8, 2: PRINT "second left when level "
	LOCATE 9, 2: PRINT "is completed.          "
	LOCATE 10, 2: PRINT "                       "
	LOCATE 11, 2: PRINT "50 Points for every    "
	LOCATE 12, 2: PRINT "step you take, + 25    "
	LOCATE 13, 2: PRINT "bonus points if you    "
	LOCATE 14, 2: PRINT "get off the tile       "
	LOCATE 15, 2: PRINT "within half a second.  "
	LOCATE 16, 2: PRINT "                       "
	LOCATE 17, 2: PRINT "Thanks for Playing!    "
	LOCATE 18, 2: PRINT "                       "
	LOCATE 19, 2: PRINT "terrycavanagh@eircom.net" 'I've oversteped here....
	LOCATE 20, 2: PRINT "  www.darklegends.com  "
	LOCATE 21, 2: PRINT "                       "
	COLOR 4
	LOCATE 22, 2: PRINT "-----------------------"
	LOCATE 23, 2: PRINT "Left, Right Change page"
	COLOR 215
END IF

END SUB

SUB Pal (FileName$)

OPEN "graphics\" + FileName$ FOR INPUT AS #5
	FOR I = 0 TO 255
		INPUT #5, red%(I)
		INPUT #5, green%(I)
		INPUT #5, blue%(I)
		OUT &H3C8, I
		OUT &H3C9, red%(I)
		OUT &H3C9, green%(I)
		OUT &H3C9, blue%(I)
	NEXT
CLOSE #5

END SUB

REM $DYNAMIC
SUB PlayMod (ModFile$)

IF MusicOn% = 0 THEN EXIT SUB

TestMOD:
IF LEN(ModFile$) = 0 THEN END
IF INSTR(ModFile$, ".") = 0 THEN ModFile$ = ModFile$ + ".GDM"

IF EmsExist THEN ErrorFlag = 1 ELSE ErrorFlag = 0   'Setup EMS use flag
File = FREEFILE
OPEN ModFile$ FOR BINARY AS File

LoadGDM FILEATTR(File, 2), 0, ErrorFlag, VARSEG(ModHead), VARPTR(ModHead)

SELECT CASE ErrorFlag
CASE 0
CASE 1: SCREEN 0: PRINT "Module is corrupt": 'Z = MultiKey(-2): END
CASE 2: SCREEN 0: PRINT "Could not autodetect module type": 'Z = MultiKey(-2): END
CASE 3: SCREEN 0: PRINT "Bad format ID": 'Z = MultiKey(-2): END
CASE 4: SCREEN 0: PRINT "Out of memory": PRINT FRE(-1): 'Z = MultiKey(-2): END
CASE 5: SCREEN 0: PRINT "Cannot unpack samples": 'Z = MultiKey(-2): END
CASE 6: SCREEN 0: PRINT "AdLib samples not supported": 'Z = MultiKey(-2): END
CASE ELSE: SCREEN 0: PRINT "Unknown Load Error:" + STR$(ErrorFlag): 'Z = MultiKey(-2): END
END SELECT

MusicChannels = 0                      'Start out at zero..
FOR J = 1 TO 32                        'Scan for used music channels
	IF ASC(MID$(ModHead.PanMap, J, 1)) <> &HFF THEN
		MusicChannels = MusicChannels + 1
	END IF
NEXT

OverRate& = StartOutput(MusicChannels + 1, 0)'Start your (sound) engines
StartMusic                                'Revv up the music playing

CLOSE File

END SUB

REM $STATIC
SUB PutCar

PUT (Xb% * 10, Yb% * 10), Sprite(105), PSET
PUT (Xb% * 10, Yb% * 10), Mask%, OR
PUT (Xb% * 10, Yb% * 10), Sprite(105 * 9), AND


END SUB

SUB PutCar2

PUT (Xb% * 10, Yb% * 10), Mask%, OR
PUT (Xb% * 10, Yb% * 10), Sprite(105 * 9), AND

END SUB

SUB ReadPal (slot%, r%, g%, B%)
OUT &H3C7, slot%
r% = INP(&H3C9)
g% = INP(&H3C9)
B% = INP(&H3C9)
END SUB

SUB Right

PutCar2

PUT ((Xb% - 1) * 10, Yb% * 10), Sprite(0), PSET

IF MID$(MapData$(Yb% + 1), Xb%, 1) = "4" THEN
	PUT ((Xb% - 1) * 10, Yb% * 10), Sprite(420), PSET
END IF

IF MID$(MapData$(Yb% + 1), Xb%, 1) = "9" THEN
	MID$(MapData$(Yb% + 1), Xb%, 1) = "0"
END IF

IF MID$(MapData$(Yb% + 1), Xb%, 1) = "1" THEN
	MID$(MapData$(Yb% + 1), Xb%, 1) = "0"
END IF

IF MID$(MapData$(Yb% + 1), Xb%, 1) = "2" THEN
	MID$(MapData$(Yb% + 1), Xb%, 1) = "1"
	PUT ((Xb% - 1) * 10, Yb% * 10), Sprite(105), PSET
END IF

IF MID$(MapData$(Yb% + 1), Xb%, 1) = "5" THEN
	MID$(MapData$(Yb% + 1), Xb%, 1) = "2"
	PUT ((Xb% - 1) * 10, Yb% * 10), Sprite(210), PSET
END IF

IF TempTile% = 6 OR TempTile% = 7 OR TempTile% = 8 THEN
	IF TempTile% = 6 AND Numbered% = 1 THEN Numbered% = 0: GOTO Continue4
	IF TempTile% = 7 AND Numbered% = 2 THEN Numbered% = 1: GOTO Continue4
	IF TempTile% = 8 AND Numbered% = 3 THEN Numbered% = 2: GOTO Continue4
	CALL LoseLife: Restart% = 1
END IF

Continue4:

IF VAL(MID$(MapData$(Yb% + 1), Xb% + 1, 1)) = 0 THEN LoseLife: Restart% = 1

END SUB

DEFSNG A-Z
SUB savepal
FOR I% = 0 TO 255
CALL ReadPal(I%, r%, g%, B%)
red%(I%) = r%
green%(I%) = g%
blue%(I%) = B%
NEXT
END SUB

DEFINT A-Z
SUB SetPal (slot%, r%, g%, B%)
OUT &H3C8, slot%
OUT &H3C9, r%
OUT &H3C9, g%
OUT &H3C9, B%
END SUB

SUB SetTemp

TempTile% = VAL(MID$(MapData$(Yb% + 1), Xb% + 1, 1))

IF NowScore! >= Lastlimit! + 50000 AND Life% < 9 THEN Life% = Life% + 1: ShowLives: Lastlimit! = Lastlimit! + 50000

END SUB

SUB ShowLives

LINE (210, 100)-(310, 110), 19, BF
FOR I = 1 TO Life%
	PUT ((20 + I) * 10, 100), Mask%, OR
	PUT ((20 + I) * 10, 100), Sprite(105 * 9), AND
NEXT I
IF Life% = 0 THEN GameOver

END SUB

SUB ShowMap


FOR Ya% = 0 TO 19 STEP 1
	FOR Xa% = 0 TO 19 STEP 1
		IF VAL(MID$(MapData$(Ya% + 1), Xa% + 1, 1)) = 9 THEN Xb% = Xa%: Yb% = Ya: PutCar: GOTO Skip
		PUT (Xa% * 10, Ya% * 10), Sprite%(VAL(MID$(MapData$(Ya% + 1), Xa% + 1, 1)) * 105), PSET
Skip:
	NEXT Xa%
NEXT Ya%

END SUB

SUB Teleport (Where$)

IF BonusFlag% = 1 THEN NowScore! = NowScore! + 25
BonusFlag% = 1
TimeDeath% = 6

IF UCASE$(Where$) = "UP" THEN
	IF MID$(MapData$(Yb%), Xb% + 1, 1) = "4" THEN
	IF TempTile% = 1 THEN MID$(MapData$(Yb% + 1), Xb% + 1, 1) = "0": PUT (Xb% * 10, Yb% * 10), Sprite(0), PSET
	IF TempTile% = 2 THEN MID$(MapData$(Yb% + 1), Xb% + 1, 1) = "1": PUT (Xb% * 10, Yb% * 10), Sprite(105), PSET
	IF TempTile% = 5 THEN MID$(MapData$(Yb% + 1), Xb% + 1, 1) = "2": PUT (Xb% * 10, Yb% * 10), Sprite(210), PSET
	TempX = Xb% + 1: TempY = Yb%
		FOR I = 1 TO 20
			FOR I2 = 1 TO 20
				TempCheck%(I2, I) = 0
			NEXT I2
		NEXT I
	TempCheck%(TempX, TempY) = 4
		FOR TempY2 = 1 TO 20
			FOR TempX2 = 1 TO 20
				IF TempCheck%(TempX2, TempY2) = 0 THEN
					IF MID$(MapData$(TempY2), TempX2, 1) = "4" THEN
						Yb% = TempY2 - 1: Xb% = TempX2 - 1
					END IF
				END IF
			NEXT TempX2
		NEXT TempY2
	TempCheck%(TempX, TempY) = 0
	END IF
END IF

IF UCASE$(Where$) = "DOWN" THEN
	IF MID$(MapData$(Yb% + 2), Xb% + 1, 1) = "4" THEN
	IF TempTile% = 1 THEN MID$(MapData$(Yb% + 1), Xb% + 1, 1) = "0": PUT (Xb% * 10, Yb% * 10), Sprite(0), PSET
	IF TempTile% = 2 THEN MID$(MapData$(Yb% + 1), Xb% + 1, 1) = "1": PUT (Xb% * 10, Yb% * 10), Sprite(105), PSET
	IF TempTile% = 5 THEN MID$(MapData$(Yb% + 1), Xb% + 1, 1) = "2": PUT (Xb% * 10, Yb% * 10), Sprite(210), PSET
	TempX = Xb% + 1: TempY = Yb% + 2
		FOR I = 1 TO 20
			FOR I2 = 1 TO 20
				TempCheck%(I2, I) = 0
			NEXT I2
		NEXT I
	TempCheck%(TempX, TempY) = 4
		FOR TempY2 = 1 TO 20
			FOR TempX2 = 1 TO 20
				IF TempCheck%(TempX2, TempY2) = 0 THEN
					IF MID$(MapData$(TempY2), TempX2, 1) = "4" THEN
						Yb% = TempY2 - 1: Xb% = TempX2 - 1
					END IF
				END IF
			NEXT TempX2
		NEXT TempY2
	TempCheck%(TempX, TempY) = 0
	END IF
END IF

IF UCASE$(Where$) = "LEFT" THEN
	IF MID$(MapData$(Yb% + 1), Xb%, 1) = "4" THEN
	IF TempTile% = 1 THEN MID$(MapData$(Yb% + 1), Xb% + 1, 1) = "0": PUT (Xb% * 10, Yb% * 10), Sprite(0), PSET
	IF TempTile% = 2 THEN MID$(MapData$(Yb% + 1), Xb% + 1, 1) = "1": PUT (Xb% * 10, Yb% * 10), Sprite(105), PSET
	IF TempTile% = 5 THEN MID$(MapData$(Yb% + 1), Xb% + 1, 1) = "2": PUT (Xb% * 10, Yb% * 10), Sprite(210), PSET
	TempX = Xb%: TempY = Yb% + 1
		FOR I = 1 TO 20
			FOR I2 = 1 TO 20
				TempCheck%(I2, I) = 0
			NEXT I2
		NEXT I
	TempCheck%(TempX, TempY) = 4
		FOR TempY2 = 1 TO 20
			FOR TempX2 = 1 TO 20
				IF TempCheck%(TempX2, TempY2) = 0 THEN
					IF MID$(MapData$(TempY2), TempX2, 1) = "4" THEN
						Yb% = TempY2 - 1: Xb% = TempX2 - 1
					END IF
				END IF
			NEXT TempX2
		NEXT TempY2
	TempCheck%(TempX, TempY) = 0
	END IF
END IF

IF UCASE$(Where$) = "RIGHT" THEN
	IF MID$(MapData$(Yb% + 1), Xb% + 2, 1) = "4" THEN
	IF TempTile% = 1 THEN MID$(MapData$(Yb% + 1), Xb% + 1, 1) = "0": PUT (Xb% * 10, Yb% * 10), Sprite(0), PSET
	IF TempTile% = 2 THEN MID$(MapData$(Yb% + 1), Xb% + 1, 1) = "1": PUT (Xb% * 10, Yb% * 10), Sprite(105), PSET
	IF TempTile% = 5 THEN MID$(MapData$(Yb% + 1), Xb% + 1, 1) = "2": PUT (Xb% * 10, Yb% * 10), Sprite(210), PSET
	TempX = Xb% + 2: TempY = Yb% + 1
		FOR I = 1 TO 20
			FOR I2 = 1 TO 20
				TempCheck%(I2, I) = 0
			NEXT I2
		NEXT I
	TempCheck%(TempX, TempY) = 4
		FOR TempY2 = 1 TO 20
			FOR TempX2 = 1 TO 20
				IF TempCheck%(TempX2, TempY2) = 0 THEN
					IF MID$(MapData$(TempY2), TempX2, 1) = "4" THEN
						Yb% = TempY2 - 1: Xb% = TempX2 - 1
					END IF
				END IF
			NEXT TempX2
		NEXT TempY2
	TempCheck%(TempX, TempY) = 0
	END IF
END IF

END SUB

SUB TitleScreen

Pal "title.pal"

Lastlimit! = 0
Refresh3:

FOR I = 0 TO 255
	SetPal I, 0, 0, 0
NEXT I

DEF SEG = &HA000
	BLOAD "graphics\title.bsv"
DEF SEG

Black$ = "R3 F5 D3 G5 D1 F5 G5 L3 U24 BR12 D24 R7 BR2 U24 R10 D24 U12 L10 BR10 U12 BR13 G6 D12 F6 BR6 U24 D12 E12 BD24 H12"
Hole$ = "D24 U12 R6 U12 D24 BR6 BU4 U16 E4 R4 F4 D16 G4 L4 H4 BR16 BU20 D24 R7 BR3 U24 R12 BD12 BL4 L8 D12 R12"

LINE (200, 0)-(319, 199), 43, BF
LINE (201, 1)-(318, 198), 215, B
LINE (207, 71)-(312, 184), 215, B
DRAW "BM225,10 C215 X" + VARPTR$(Black$)
DRAW "BM230,42 C215 X" + VARPTR$(Hole$)
COLOR 215
LOCATE 10, 27: PRINT "             "
LOCATE 11, 27: PRINT " Programmed  "
LOCATE 12, 27: PRINT " by Terry    "
LOCATE 13, 27: PRINT "  Cavanagh   "
LOCATE 14, 27: PRINT "             "
LOCATE 15, 27: PRINT "   Special   "
LOCATE 16, 27: PRINT "  Thanks to  "
LOCATE 17, 27: PRINT " Matt, Will  "
LOCATE 18, 27: PRINT "  and Svante "
LOCATE 19, 27: PRINT "             "
LOCATE 20, 27: PRINT "   BWSB by   "
LOCATE 21, 27: PRINT "   Edward    "
LOCATE 22, 27: PRINT "   Schunder  "
LOCATE 23, 27: PRINT "             "

LINE (0, 6)-(199, 25), 0, BF
LINE (0, 6)-(199, 6), 215
LINE (0, 25)-(199, 25), 215
LOCATE 2, 1: PRINT "  Dark Legends Software  "
LOCATE 3, 1: PRINT "        Presents"

FadeIn 65

Refreshy:

FOR I = 35 TO 0 STEP -5
	Delay .005
	TempX = 29: TempX2 = 170: TempY = 90: TempY2 = 160
	LINE (TempX + I, TempY + I)-(TempX2 - I, TempY2 - I), 0, BF
	LINE (TempX + I, TempY + I)-(TempX2 - I, TempY2 - I), 215, B
NEXT I

LOCATE 13, 5: PRINT "    START NEW    "
LOCATE 15, 5: PRINT "   HIGH SCORES   "
LOCATE 17, 5: PRINT "      HELP       "
LOCATE 19, 5: PRINT "      EXIT       "

TempX = 13

Refresh1:
COLOR 4
LOCATE TempX, 6: PRINT "": LOCATE TempX, 20: PRINT ""
COLOR 215

DO
	Key$ = INKEY$
	IF Key$ = CHR$(0) + "H" AND TempX > 13 THEN LOCATE TempX, 6: PRINT " ": LOCATE TempX, 20: PRINT " ": TempX = TempX - 2: GOTO Refresh1
	IF Key$ = CHR$(0) + "P" AND TempX < 19 THEN LOCATE TempX, 6: PRINT " ": LOCATE TempX, 20: PRINT " ": TempX = TempX + 2: GOTO Refresh1
	IF Key$ = CHR$(13) OR Key$ = " " THEN GOTO Flag
LOOP UNTIL Key$ = CHR$(27)
Credits

Flag:
IF TempX = 13 THEN GOTO Choose
IF TempX = 15 THEN HighScore: CLS : GOTO Refresh3
IF TempX = 17 THEN Help: CLS : GOTO Refresh3
IF TempX = 19 THEN Credits
GOTO Refresh1

Choose:

FOR I = 35 TO 0 STEP -5
	Delay .005
	TempX = 29: TempX2 = 170: TempY = 90: TempY2 = 160
	LINE (TempX + I, TempY + I)-(TempX2 - I, TempY2 - I), 0, BF
	LINE (TempX + I, TempY + I)-(TempX2 - I, TempY2 - I), 215, B
NEXT I

LOCATE 13, 5: PRINT "      EASY       "
LOCATE 15, 5: PRINT "     MEDIUM      "
LOCATE 17, 5: PRINT "      HARD       "
LOCATE 19, 5: PRINT "     CUSTOM      "

TempX = 13
Refreshx:
COLOR 4
LOCATE TempX, 6: PRINT "": LOCATE TempX, 20: PRINT ""
COLOR 215

DO
	Key$ = INKEY$
	IF Key$ = CHR$(0) + "H" AND TempX > 13 THEN LOCATE TempX, 6: PRINT " ": LOCATE TempX, 20: PRINT " ": TempX = TempX - 2: GOTO Refreshx
	IF Key$ = CHR$(0) + "P" AND TempX < 19 THEN LOCATE TempX, 6: PRINT " ": LOCATE TempX, 20: PRINT " ": TempX = TempX + 2: GOTO Refreshx
	IF Key$ = CHR$(13) OR Key$ = " " THEN GOTO Flagx
LOOP UNTIL Key$ = CHR$(27)
GOTO Refreshy

Flagx:
IF TempX = 13 THEN Stage$ = "EASY": LevelNum% = 10: GOTO Contin
IF TempX = 15 THEN Stage$ = "MEDI": LevelNum% = 10: GOTO Contin
IF TempX = 17 THEN Stage$ = "HARD": LevelNum% = 10: GOTO Contin
IF TempX = 19 THEN AskWhat: GOTO Contin
GOTO Refreshx


Contin:
FadeOut 65
Life% = 5: NowScore! = 0
CLS
Pal "qbasic.pal"

Black$ = "R3 F5 D3 G5 D1 F5 G5 L3 U24 BR12 D24 R7 BR2 U24 R10 D24 U12 L10 BR10 U12 BR13 G6 D12 F6 BR6 U24 D12 E12 BD24 H12"
Hole$ = "D24 U12 R6 U12 D24 BR6 BU4 U16 E4 R4 F4 D16 G4 L4 H4 BR16 BU20 D24 R7 BR3 U24 R12 BD12 BL4 L8 D12 R12"

Level% = 1
COLOR 15
LINE (200, 0)-(319, 199), 19, BF
LINE (201, 1)-(318, 198), 15, B
DRAW "BM225,10 C15 X" + VARPTR$(Black$)
DRAW "BM230,42 C15 X" + VARPTR$(Hole$)
LOCATE 12, 27: PRINT "Lives Left"
LOCATE 16, 27: PRINT " Score:"
LOCATE 17, 27: PRINT NowScore!
LOCATE 20, 27: PRINT "Time Left"
LOCATE 22, 27: PRINT "Tile falls in"
LOCATE 23, 27: PRINT TimeDeath%; "Seconds."
ShowLives

END SUB

REM $DYNAMIC
SUB UnloadMod

IF MusicOn% = 0 THEN EXIT SUB

CLOSE
StopMusic
StopOutput
UnloadModule

END SUB

REM $STATIC
SUB Up

PutCar2

PUT (Xb% * 10, (Yb% + 1) * 10), Sprite(0), PSET

IF MID$(MapData$(Yb% + 2), Xb% + 1, 1) = "4" THEN
	PUT (Xb% * 10, (Yb% + 1) * 10), Sprite(420), PSET
END IF

IF MID$(MapData$(Yb% + 2), Xb% + 1, 1) = "9" THEN
	MID$(MapData$(Yb% + 2), Xb% + 1, 1) = "0"
END IF

IF MID$(MapData$(Yb% + 2), Xb% + 1, 1) = "1" THEN
	MID$(MapData$(Yb% + 2), Xb% + 1, 1) = "0"
END IF

IF MID$(MapData$(Yb% + 2), Xb% + 1, 1) = "2" THEN
	MID$(MapData$(Yb% + 2), Xb% + 1, 1) = "1"
	PUT (Xb% * 10, (Yb% + 1) * 10), Sprite(105), PSET
END IF

IF MID$(MapData$(Yb% + 2), Xb% + 1, 1) = "5" THEN
	MID$(MapData$(Yb% + 2), Xb% + 1, 1) = "2"
	PUT (Xb% * 10, (Yb% + 1) * 10), Sprite(210), PSET
END IF

IF TempTile% = 6 OR TempTile% = 7 OR TempTile% = 8 THEN
	IF TempTile% = 6 AND Numbered% = 1 THEN Numbered% = 0: GOTO Continue5
	IF TempTile% = 7 AND Numbered% = 2 THEN Numbered% = 1: GOTO Continue5
	IF TempTile% = 8 AND Numbered% = 3 THEN Numbered% = 2: GOTO Continue5
	CALL LoseLife: Restart% = 1
END IF

Continue5:

IF VAL(MID$(MapData$(Yb% + 1), Xb% + 1, 1)) = 0 THEN LoseLife: Restart% = 1

END SUB

