'QuickBasic include file for FM.QLB
'programs that use these routines should used the DEFINT A-Z command to
'change the default variable type from float! to integer%

'---setup routines--

DECLARE SUB setupmusic (buffer%())
'setupmusic prepares a buffer that your music will use to play.
'run it once at the very beginning of any program where you want to
'play BAM music. buffer%() is an array that needs to be big enough to
'hold the largest BAM file you will be playing (remeber that an array
'of integers holds 2 bytes per element, so if you DIM musicbuf%(16000)
'you will be able to play any BAM up to 32k. that is a good number, since
'it is the largest file size that either MIDI2BAM.EXE or NOTATE.EXE can
'produce

DECLARE SUB closemusic ()
'run this once at the end of your program. This is the complement to
'setupmusic

DECLARE SUB resetfm ()
'reset the FM chip in your sound card. Call this once right after
'setupmusic.

'---playing routines---

DECLARE SUB loadsong (f$)
'loads a BAM file into memory and starts it playing. f$ is the file name,
'and should be zero-terminated. Example:
'loadsong "MYSONG.BAM"+CHR$(0)

DECLARE SUB stopsong ()
'stop the currently playing song. use it at any time in your program

DECLARE SUB resumesong ()
'restarts the music after you stopped with stopsong

'---volume control---

DECLARE FUNCTION getfmvol ()
'returns the current FM mixer volume. It will be a number between 0 and 15
'on most sound cards, or between 0 and 7 for some older cards

DECLARE SUB setfmvol (BYVAL vol%)
'sets the FM mixer volume to the target volume. vol is a number between
'0 and 15

DECLARE SUB fademusic (BYVAL vol%)
'fades the FM volume towards a target volume.

'---manual control routines---
'If use loadsong() then you do not need any of these manual routines
'You do not need them to play a ready-made BAM file, they are just
'provided for writing BAM utilities

DECLARE SUB FMKeyOn (BYVAL voice%, BYVAL freq%)
'manually turns on voice from 0 to 8, setting its frequency 0 to 127.

DECLARE SUB FMKeyOff (BYVAL voice%)
'manually turns off a voice form 0 to 8.

DECLARE SUB setvoice (BYVAL voice%, inst%())
'set the instrument that a voice uses. inst%() is and array dimentioned
'big enough to hold 11 bytes of instrument data. Example:
'DIM instrument%(6)

DECLARE SUB getvoice (BYVAL voice%, BYVAL index%, ibkfile$, inst%())
'reads an instrument from an IBK file and loads it as the specified voice.
'index% is the number of the instrument in the IBK file.
'inst%() is a buffer big enough to hold 11 bytes like with setvoice()
'The instrument data gets left behind in inst%() so you could save it for
'later use with setvoice().

