	page	59,130
;WAITBEAM.ASM	JUL-20-95
;Routine to wait for the video beam to pass a specified line.
; by Loren Blaney
;
;The 8254 sound timer (timer 2) is used to control the timing of drawing
; on the video screen. Although timer 0, the system timer, could be used,
; timer 2 is used for safety in case timer 0 is set up funny.

cseg	segment dword public 'code'
	assume cs:cseg

;----------------------------------------------------------------------
;Enable or disable interrupts
;	Interrupt(true);
;
	public	Interrupt
Interrupt:
	mov	bp,sp		;point to arguments
	cmp	word ptr [bp+4],0 ;is flag 'true'?
	je	int10		;jump if not
	sti			;enable interrupts
	jmp	short int90
int10:	cli			;disable interrupts
int90:	retf	2		;drop one argument

;----------------------------------------------------------------------
;Read current time from timer 2. Time is ascending.
;	Time:= ReadTime;
;
; The time returned is in ticks Each tick is 1 / 1.19318MHz = 838 ns.
; (Maximum time delay = 32767 ticks = 27.458 ms.)
;
; WARNING: This only works after timer 2 has been synced by the WaitBeam
; routine.
;
	public	ReadTime
ReadTime:
	pop	cx		;save return address
	pop	dx

	call	rdTime
	push	ax

	push	dx		;restore return address
	push	cx
	retf

;----------------------------------------------------------------------
;Time delay.
;	DelayX(Time);
;
; "Time" is the amout of time to delay in ticks. Each tick is
; 1 / 1.19318MHz = 838 ns. Maximum time delay = 32767 ticks = 27.458 ms.
;
; WARNING: This only works after timer 2 has been synced by the WaitBeam
; routine.
;
	public	DelayX
DelayX:
	mov	bp,sp		;point to arguments
	mov	bx,ax		;save time delay in bx
	call	rdTime		;get current time
	add	bx,ax		;add time delay to current time to
dly10:	call	rdTime		; get time to return from this routine
	cmp	[bp+4],ax
	jns	dly10		;signed compares handle wrap around
	retf	2		;drop one argument

;----------------------------------------------------------------------
;Wait for video beam to pass the specified scan line. Line = 0 = top line
; displayed. Sync is a flag that should be set the first time this routine
; is called. Sync should be clear on subsequent calls. If more than 100 calls
; are made with Sync clear then drift might become a problem.
;	WaitBeam(Line, Sync);
;
; Registers destroyed: ax, bx, cx, dx, bp.
;
period	dw	0		;number of ticks between vertical blanks
vbtime	dw	0		;time at start of vertical blank

	public	WaitBeam
WaitBeam:
	pop	dx		;save return address
	pop	cx
	pop	bx		;get Sync
	pop	bp		;get Line
	push	cx		;restore return address
	push	dx
	test	bx,bx		;Sync?
	je	wb30		;jump if not

	cli
	in	al,61h		;disable speaker and enable timer-2 gate
	and	al,0fdh
	or	al,001h
	jmp	short $+2	;delay for I/O
	out	61h,al
	sti

	mov	al,0b4h		;set timer 2 for mode 2, rate generator
	jmp	short $+2
	out	43h,al
	mov	al,0ffh		;set timer for 0ffffh
	jmp	short $+2
	out	42h,al
	jmp	short $+2	;delay
	out	42h,al

;Measure screen period in timer ticks
; Typically = 1/60th second; 1.19MHz / 60 = 19833 ticks
	cli			;interrupts are off for 1/60th second
	call	waitVB		;wait for vertical blank
	call	rdTime		;get timer-2 time
	sti
	mov	bx,ax
	cli
	call	waitVB		;wait for vertical blank
	call	rdTime
	sti
	mov	cs:vbtime,ax	;save time of vertical blank
	sub	ax,bx
	mov	cs:period,ax	;save screen period
	jmp	short wb40

wb30:	mov	ax,cs:vbtime	;calculate time for next vertical blank
	add	ax,cs:period
	mov	cs:vbtime,ax

;Time when beam passes Line = vbtime + Period * (Line + 50) / 525
wb40:	mov	ax,bp		;get Line
	add	ax,50		;lines of vertical blank and drift compensation
	mul	cs:period
	mov	bx,525		;divide by total scan lines (480 are visible)
	div	bx
	add	ax,cs:vbtime	;add time at vertical blank to get
	mov	bx,ax		; time when beam will pass Line

;Wait for beam to pass Line
	call	rdTime
	cmp	bx,ax
	jns	wb40		;signed compares handle wrap around
	retf

;----------------------------------------------------------------------
;Wait for the start of vertical blank
; Destroys al & dx.
;
waitVB:	push	ds		;get port address of CRTC status register
	mov	ax,40h		;(3da or 3ba)
	mov	ds,ax
	mov	dx,ds:[63h]
	add	dl,6
	pop	ds

wvb10:	in	al,dx		;wait for no vertical blank
	and	al,08h
	jne	wvb10
	jmp	short $+2	;delay
wvb15:	in	al,dx		;wait for vertical blank
	and	al,08h
	je	wvb15
wvb90:	ret

;----------------------------------------------------------------------
;Read time from timer 2 and return it in ax.
;
rdTime:	mov	al,80h		;latch counter 2
	out	43h,al
	jmp	short $+2	;delay
	in	al,42h		;read counter 2 latch (low byte 1st)
	mov	ah,al
	jmp	short $+2	;delay
	in	al,42h
	xchg	al,ah
	neg	ax		;use ascending time
	ret

cseg	ends
	end
