'Lost Realms V1.25
'Copyright (c) 1998-1999 XFLARE SOFTWARE

'This game was programmed by Paul Crosland and was
'play-tested by myself and friends. Be sure to view
'the ReadMe file before you start.

DECLARE SUB WATERFADE ()
DECLARE SUB ADVISOR ()
DECLARE SUB DRAWTER (vartype, xdif, ydif)
DECLARE SUB REVISEMAP (revmap)
DECLARE SUB BUILD (S1, S2, S3, S4)
DECLARE SUB CONSTRUCT (newter)
DECLARE SUB BUYUNIT (S1, S2, S3, tertype, S4, S5)
DECLARE SUB MVUNITS ()
DECLARE SUB TITLESCR ()
DECLARE SUB LOADGAME ()
DECLARE SUB SAVEGAME ()
DECLARE SUB LONGVIEW ()
DECLARE SUB MINIMAP ()
DECLARE SUB COMBAT ()
DECLARE SUB CHECKSPOT ()
DECLARE SUB FINDSPOT (tertype)
DECLARE SUB CHGTEXT ()
DECLARE SUB TIRED ()
DECLARE SUB VISION ()
DECLARE SUB COMMANDS ()
DECLARE SUB SCREENSET ()

DIM SHARED texture1(100), texture2(100), grass(100), water(100), mine(100), tree(100)
DIM SHARED soldier1(100), soldier2(100), visible(3600), tower1(100), tower2(100)
DIM SHARED peasant1(100), peasant2(100), curact1(60), curact2(60), hp1(60), hp2(60), maxhp1(60), maxhp2(60)
DIM SHARED terrain(3600), xp(2), yp(2), xcur(2), ycur(2), switch$(2), gold(2), ship1(100), ship2(100)
DIM SHARED constr(100), city1(100), city2(100), food(2), numunits(2), structures(2), totunits(2)
DIM SHARED unitplace1(60), unitplace2(60), action$(2), movement(60), unitype1(60), unitype2(60)
DIM SHARED mvleft$(2), mvright$(2), mvup$(2), mvdown$(2), endturn$(2), curterrain(2)
DIM SHARED farm(100), black(100), scout1(100), scout2(100), lline(270), mark1(60), mark2(60)
DIM SHARED flame1(100), flame2(100), flame3(100), flame4(100), flame5(100), flame6(100)
DIM SHARED port1(100), port2(100), mmap(500), wall(100), message(2), gpturn(2)

TYPE INFOTEXT
   text1 AS STRING * 17
   text2 AS STRING * 17
   text3 AS STRING * 17
   text4 AS STRING * 13
END TYPE

COMMON SHARED pnum, moveunit, curunit, tnum, tnum2, TRUE, FALSE, PATH$
COMMON SHARED xchg, ychg, xpl, ypl, complete, unum2, etnum, victory
COMMON SHARED xpl2, scrscroll, damage, curcol, sel$, unum, wfade
COMMON SHARED bfarm, bport, bcity, leaveship, showmap, effects, scrcol
COMMON SHARED coltime1#, coltime2#, info AS INFOTEXT, mes1$, mes2$, mes3$

SCREEN 9, 0, 0, 0: CLS
COLOR 7: LOCATE 1, 1: PRINT "LOST REALMS V1.25"
LOCATE 2, 1: PRINT "COPYRIGHT 1998-1999 XFLARE SOFTWARE"

RANDOMIZE TIMER
ON ERROR GOTO haltpro

main:

PATH$ = ""
FOR lnum = 1 TO 250
   READ lline(lnum)
NEXT
TRUE = 1: FALSE = 0
effects = TRUE
moveunit = FALSE: scrscroll = FALSE: curcol = 15
showmap = FALSE
FOR pnum = 1 TO 2
   gold(pnum) = 8000
NEXT
xp(1) = 1: yp(1) = 6
xp(2) = 46: yp(2) = 42
OPEN PATH$ + "map.dat" FOR INPUT AS #1
   unum1 = 1: unum2 = 1
   FOR tnum = 1 TO 3600
      INPUT #1, terrain(tnum)
      SELECT CASE terrain(tnum)
         CASE 11
            pl = 1: hp = 12
         CASE 21
            pl = 2: hp = 12
         CASE 12
            pl = 1: hp = 28
         CASE 22
            pl = 2: hp = 28
         CASE 13
            pl = 1: hp = 16
         CASE 23
            pl = 2: hp = 16
         CASE 14
            pl = 1: hp = 44
         CASE 24
            pl = 2: hp = 44
         CASE ELSE
            pl = 0
      END SELECT
      IF pl = 1 THEN
         unitplace1(unum1) = tnum
         curact1(unum1) = 1
         unitype1(unum1) = terrain(tnum)
         maxhp1(unum1) = hp: hp1(unum1) = maxhp1(unum1)
         unum1 = unum1 + 1
      ELSEIF pl = 2 THEN
         unitplace2(unum2) = tnum
         curact2(unum2) = 1
         unitype2(unum2) = terrain(tnum)
         maxhp2(unum2) = hp: hp2(unum2) = maxhp2(unum2)
         unum2 = unum2 + 1
      END IF
      IF pl THEN
         numunits(pl) = numunits(pl) + 1: visible(tnum) = pl
         totunits(pl) = totunits(pl) + 1
      END IF
   NEXT
CLOSE #1

DEF SEG = VARSEG(texture1(0)): BLOAD PATH$ + "texture1.gph", VARPTR(texture1(0))
DEF SEG = VARSEG(texture2(0)): BLOAD PATH$ + "texture2.gph", VARPTR(texture2(0))
DEF SEG = VARSEG(grass(0)): BLOAD PATH$ + "grass.gph", VARPTR(grass(0))
DEF SEG = VARSEG(water(0)): BLOAD PATH$ + "water.gph", VARPTR(water(0))
DEF SEG = VARSEG(tree(0)): BLOAD PATH$ + "tree.gph", VARPTR(tree(0))
DEF SEG = VARSEG(mine(0)): BLOAD PATH$ + "mine.gph", VARPTR(mine(0))
DEF SEG = VARSEG(soldier1(0)): BLOAD PATH$ + "sold1.gph", VARPTR(soldier1(0))
DEF SEG = VARSEG(soldier2(0)): BLOAD PATH$ + "sold2.gph", VARPTR(soldier2(0))
DEF SEG = VARSEG(tower1(0)): BLOAD PATH$ + "tower1.gph", VARPTR(tower1(0))
DEF SEG = VARSEG(tower2(0)): BLOAD PATH$ + "tower2.gph", VARPTR(tower2(0))
DEF SEG = VARSEG(peasant1(0)): BLOAD PATH$ + "pes1.gph", VARPTR(peasant1(0))
DEF SEG = VARSEG(peasant2(0)): BLOAD PATH$ + "pes2.gph", VARPTR(peasant2(0))
DEF SEG = VARSEG(constr(0)): BLOAD PATH$ + "constr.gph", VARPTR(constr(0))
DEF SEG = VARSEG(city1(0)): BLOAD PATH$ + "city1.gph", VARPTR(city1(0))
DEF SEG = VARSEG(city2(0)): BLOAD PATH$ + "city2.gph", VARPTR(city2(0))
DEF SEG = VARSEG(farm(0)): BLOAD PATH$ + "farm.gph", VARPTR(farm(0))
DEF SEG = VARSEG(scout1(0)): BLOAD PATH$ + "scout1.gph", VARPTR(scout1(0))
DEF SEG = VARSEG(scout2(0)): BLOAD PATH$ + "scout2.gph", VARPTR(scout2(0))
DEF SEG = VARSEG(port1(0)): BLOAD PATH$ + "port1.gph", VARPTR(port1(0))
DEF SEG = VARSEG(port2(0)): BLOAD PATH$ + "port2.gph", VARPTR(port2(0))
DEF SEG = VARSEG(ship1(0)): BLOAD PATH$ + "ship1.gph", VARPTR(ship1(0))
DEF SEG = VARSEG(ship2(0)): BLOAD PATH$ + "ship2.gph", VARPTR(ship2(0))
DEF SEG = VARSEG(black(0)): BLOAD PATH$ + "black.gph", VARPTR(black(0))
DEF SEG = VARSEG(wall(0)): BLOAD PATH$ + "wall.gph", VARPTR(wall(0))
DEF SEG = VARSEG(flame1(0)): BLOAD PATH$ + "flame1.gph", VARPTR(flame1(0))
DEF SEG = VARSEG(flame2(0)): BLOAD PATH$ + "flame2.gph", VARPTR(flame2(0))
DEF SEG = VARSEG(flame3(0)): BLOAD PATH$ + "flame3.gph", VARPTR(flame3(0))
DEF SEG = VARSEG(flame4(0)): BLOAD PATH$ + "flame4.gph", VARPTR(flame4(0))
DEF SEG = VARSEG(flame5(0)): BLOAD PATH$ + "flame5.gph", VARPTR(flame5(0))
DEF SEG = VARSEG(flame6(0)): BLOAD PATH$ + "flame6.gph", VARPTR(flame6(0))

CALL TITLESCR: CALL SCREENSET
VIEW (330, 40)-(629, 339), 0, 0
pnum = 1: GOSUB updateunits: REVISEMAP 1: CALL ADVISOR
CALL MINIMAP: CALL COMMANDS

OUT &H3C8, 1: OUT &H3C9, 0: OUT &H3C9, 2: OUT &H3C9, 35
OUT &H3C8, 57: OUT &H3C9, 0: OUT &H3C9, 8: OUT &H3C9, 63
OUT &H3C8, 8: OUT &H3C9, 8: OUT &H3C9, 8: OUT &H3C9, 8
OUT &H3C8, 4: OUT &H3C9, 50: OUT &H3C9, 0: OUT &H3C9, 10
OUT &H3C8, 20: OUT &H3C9, 31: OUT &H3C9, 16: OUT &H3C9, 1

DO
  
   IF pnum = 1 THEN VIEW (10, 40)-(309, 339), , scrcol
   IF pnum = 2 THEN VIEW (330, 40)-(629, 339), , scrcol
   IF sel2$ = "" THEN
      sel$ = INKEY$: sel2$ = INKEY$
   ELSE
      sel$ = sel2$: sel2$ = ""
   END IF
   FOR bnum = 1 TO 10
      bad$ = INKEY$
   NEXT
  
   SELECT CASE UCASE$(sel$)
   CASE mvleft$(pnum), mvright$(pnum), mvup$(pnum), mvdown$(pnum)
      CALL MVUNITS
   CASE action$(pnum)
      IF moveunit THEN
         curcol = 15: moveunit = FALSE: curunit = 0: damage = 0
      ELSEIF moveunit = FALSE AND scrscroll = FALSE THEN
         tnum = (yp(pnum) - 1 + ycur(pnum)) * 60 + xp(pnum) + xcur(pnum)
         IF terrain(tnum) > 10 AND terrain(tnum) < 20 AND pnum = 1 THEN
            FOR unum = 1 TO 60
               IF unitplace1(unum) = tnum THEN
                  curcol = 14: moveunit = TRUE: curunit = unum
                  IF movement(curunit) = 0 THEN curcol = 11
               END IF
            NEXT
         ELSEIF terrain(tnum) > 29 AND terrain(tnum) < 40 AND pnum = 1 THEN
            moveunit = TRUE
            FOR unum = 1 TO 60
               IF unitplace1(unum) = tnum THEN curcol = 11: curunit = unum
            NEXT
         ELSEIF terrain(tnum) > 20 AND terrain(tnum) < 30 AND pnum = 2 THEN
            moveunit = TRUE
            FOR unum = 1 TO 60
               IF unitplace2(unum) = tnum THEN
                   curcol = 14: moveunit = TRUE: curunit = unum
                   IF movement(curunit) = 0 THEN curcol = 11
                   moveunit = TRUE
               END IF
            NEXT
         ELSEIF terrain(tnum) > 39 AND terrain(tnum) < 50 AND pnum = 2 THEN
            moveunit = TRUE
            FOR unum = 1 TO 60
               IF unitplace2(unum) = tnum THEN curcol = 11: curunit = unum
            NEXT
         END IF
      END IF
      CALL CHGTEXT
   CASE switch$(pnum)
      IF pnum = 1 AND unitype1(curunit) = 11 AND movement(curunit) > 0 OR pnum = 2 AND unitype2(curunit) = 21 AND movement(curunit) > 0 THEN
         IF pnum = 1 THEN
            CALL CHECKSPOT
            IF totunits(1) < 60 THEN
               IF gold(1) >= 350 AND curact1(curunit) = 1 THEN
                  curact1(curunit) = 19
               ELSEIF gold(1) >= 1200 AND curact1(curunit) = 19 AND bfarm = 1 THEN
                  curact1(curunit) = 12
               ELSEIF gold(1) >= 2300 AND curact1(curunit) <> 5 AND curact1(curunit) <> 15 AND curact1(curunit) <> 3 THEN
                  curact1(curunit) = 5
               ELSEIF gold(1) >= 3000 AND curact1(curunit) <> 15 AND curact1(curunit) <> 3 AND bport = 1 THEN
                  curact1(curunit) = 15
               ELSEIF gold(1) >= 5000 AND curact1(curunit) <> 3 AND bcity = 1 THEN
                  curact1(curunit) = 3
               ELSE
                  curact1(curunit) = 1
               END IF
            END IF
         ELSEIF pnum = 2 THEN
            CALL CHECKSPOT
            IF totunits(2) < 60 THEN
               IF gold(2) >= 350 AND curact2(curunit) = 1 THEN
                  curact2(curunit) = 19
               ELSEIF gold(2) >= 1200 AND curact2(curunit) = 19 AND bfarm = 1 THEN
                  curact2(curunit) = 12
               ELSEIF gold(2) >= 2300 AND curact2(curunit) <> 5 AND curact2(curunit) <> 15 AND curact2(curunit) <> 3 THEN
                  curact2(curunit) = 5
               ELSEIF gold(2) >= 3000 AND curact2(curunit) <> 15 AND curact2(curunit) <> 3 AND bport = 1 THEN
                  curact2(curunit) = 15
               ELSEIF gold(2) >= 5000 AND curact2(curunit) <> 3 AND bcity = 1 THEN
                  curact2(curunit) = 3
               ELSE
                  curact2(curunit) = 1
               END IF
            END IF
         END IF
      ELSEIF pnum = 1 AND unitype1(curunit) = 32 OR pnum = 2 AND unitype2(curunit) = 42 THEN
         IF gold(1) >= 250 AND curact1(curunit) = 0 AND pnum = 1 AND food(1) - numunits(1) * 100 > 0 AND totunits(1) < 60 THEN
            curact1(curunit) = 7
         ELSEIF gold(2) >= 250 AND curact2(curunit) = 0 AND pnum = 2 AND food(2) - numunits(2) * 100 > 0 AND totunits(2) < 60 THEN
            curact2(curunit) = 7
         ELSEIF pnum = 1 AND curact1(curunit) < 10 THEN
            curact1(curunit) = 0
         ELSEIF pnum = 2 AND curact2(curunit) < 10 THEN
            curact2(curunit) = 0
         END IF
      ELSEIF pnum = 1 AND unitype1(curunit) = 34 OR pnum = 2 AND unitype2(curunit) = 44 THEN
         IF gold(1) >= 500 AND curact1(curunit) = 0 AND pnum = 1 AND food(1) - numunits(1) * 100 > 0 AND totunits(1) < 60 THEN
            curact1(curunit) = 8
         ELSEIF gold(1) >= 900 AND curact1(curunit) = 8 AND pnum = 1 AND food(1) - numunits(1) * 100 > 0 AND totunits(1) < 60 THEN
            curact1(curunit) = 9
         ELSEIF gold(2) >= 500 AND curact2(curunit) = 0 AND pnum = 2 AND food(2) - numunits(2) * 100 > 0 AND totunits(2) < 60 THEN
            curact2(curunit) = 8
         ELSEIF gold(2) >= 900 AND curact2(curunit) = 8 AND pnum = 2 AND food(2) - numunits(2) * 100 > 0 AND totunits(2) < 60 THEN
            curact2(curunit) = 9
         ELSEIF pnum = 1 AND curact1(curunit) < 10 THEN
            curact1(curunit) = 0
         ELSEIF pnum = 2 AND curact2(curunit) < 10 THEN
            curact2(curunit) = 0
         END IF
      ELSEIF pnum = 1 AND unitype1(curunit) = 38 OR pnum = 2 AND unitype2(curunit) = 48 THEN
         IF gold(1) >= 1500 AND curact1(curunit) = 0 AND pnum = 1 AND food(1) - numunits(1) * 100 > 0 AND totunits(1) < 60 THEN
            curact1(curunit) = 17
         ELSEIF gold(2) >= 1500 AND curact2(curunit) = 0 AND pnum = 2 AND food(2) - numunits(2) * 100 > 0 AND totunits(2) < 60 THEN
            curact2(curunit) = 17
         ELSEIF pnum = 1 AND curact1(curunit) = 17 THEN
            curact1(curunit) = 0
         ELSEIF pnum = 2 AND curact2(curunit) = 17 THEN
            curact2(curunit) = 0
         END IF
      ELSEIF pnum = 1 AND unitype1(curunit) = 14 OR pnum = 2 AND unitype2(curunit) = 24 THEN
         IF pnum = 1 AND curact1(curunit) = 18 THEN
            curact1(curunit) = 1
         ELSEIF pnum = 1 AND curact1(curunit) = 1 AND mark1(curunit) > 0 THEN
            curact1(curunit) = 18
         ELSEIF pnum = 2 AND curact2(curunit) = 18 THEN
            curact2(curunit) = 1
         ELSEIF pnum = 2 AND curact2(curunit) = 1 AND mark2(curunit) > 0 THEN
            curact2(curunit) = 18
         END IF
      ELSEIF scrscroll THEN
         scrscroll = FALSE: scrcol = 14
      ELSEIF moveunit = FALSE THEN
         scrscroll = TRUE: scrcol = 11
         CALL MINIMAP
      END IF
      CALL CHGTEXT
   CASE endturn$(pnum)
      CLS
      moveunit = FALSE: curcol = 15: curunit = 0
      IF pnum = 1 THEN
         VIEW (10, 40)-(309, 339), 0, 0: xpl = 44
         pnum = 2
      ELSEIF pnum = 2 THEN
         VIEW (330, 40)-(629, 339), 0, 0: xpl = 4
         pnum = 1
      END IF
      GOSUB updateunits: REVISEMAP 1: CALL ADVISOR
      CALL MINIMAP: CALL COMMANDS
   CASE CHR$(0) + CHR$(59), CHR$(0) + CHR$(60), CHR$(0) + CHR$(61), CHR$(0) + CHR$(62)
      SCREEN 9, 0, 0, 0: VIEW (9, 9)-(630, 340), 0, 11
      IF sel$ = CHR$(0) + CHR$(59) THEN
         LOCATE 13, 31: COLOR 7: PRINT "DO YOU WANT TO EXIT?"
         DO
            sel$ = INKEY$
            IF UCASE$(sel$) = "N" THEN EXIT DO
            IF UCASE$(sel$) = "Y" THEN VIEW (0, 0)-(639, 349), 0, 0: CLEAR : GOTO donepro
         LOOP
      ELSEIF sel$ = CHR$(0) + CHR$(60) THEN
         LOCATE 13, 33: COLOR 7: PRINT "START A NEW GAME?"
         DO
            sel$ = INKEY$
            IF UCASE$(sel$) = "N" THEN EXIT DO
            IF UCASE$(sel$) = "Y" THEN VIEW (0, 0)-(639, 349), 0, 0: CLEAR : GOTO main
         LOOP
      ELSEIF sel$ = CHR$(0) + CHR$(62) THEN
         LOCATE 13, 31: COLOR 7: PRINT "LOAD PREVIOUS GAME?"
         DO
            sel$ = INKEY$
            IF UCASE$(sel$) = "N" THEN EXIT DO
            IF UCASE$(sel$) = "Y" THEN CALL LOADGAME: REVISEMAP 1: CALL MINIMAP: CALL ADVISOR: xpl = xpl2: EXIT DO
         LOOP
      ELSEIF sel$ = CHR$(0) + CHR$(61) THEN
         LOCATE 13, 33: COLOR 7: PRINT "SAVE YOUR GAME?"
         DO
            sel$ = INKEY$
            IF UCASE$(sel$) = "N" THEN EXIT DO
            IF UCASE$(sel$) = "Y" THEN CALL SAVEGAME: EXIT DO
         LOOP
      END IF
      SCREEN 9, 0, 1, 0
   CASE CHR$(0) + CHR$(63)
      IF effects THEN
         effects = FALSE
      ELSE
         effects = TRUE
      END IF
   END SELECT
   SELECT CASE UCASE$(sel$)
   CASE "A" TO "Z"
      code$ = code$ + UCASE$(sel$)
      IF LEN(code$) = 9 THEN code$ = MID$(code$, 2)
      IF INSTR(code$, "FARSIGHT") <> 0 AND showmap = FALSE THEN
         code$ = "": showmap = TRUE
         CALL MINIMAP: REVISEMAP 1
      ELSEIF INSTR(code$, "FARSIGHT") <> 0 AND showmap THEN
         code$ = "": showmap = FALSE
         CALL MINIMAP: REVISEMAP 1
      END IF
   END SELECT
  
   IF pnum = 1 THEN VIEW (490, 40)-(629, 339), 0, 0
   IF pnum = 2 THEN VIEW (170, 40)-(309, 339), 0, 0
   COLOR 2: LOCATE 5, xpl: PRINT info.text1$: LOCATE 7, xpl: PRINT info.text2$
   LOCATE 9, xpl: PRINT info.text3$
   LOCATE 11, xpl: PRINT RTRIM$(info.text4$);
   IF damage > 0 THEN COLOR 13: PRINT " +"; damage: COLOR 2
   IF movement(curunit) > 0 THEN
      LOCATE 13, xpl - 1: PRINT movement(curunit)
   ELSE
      LOCATE 13, xpl: PRINT "NONE"
   END IF
   IF food(pnum) - numunits(pnum) * 100 < 0 THEN
      LOCATE 21, xpl: PRINT food(pnum) - numunits(pnum) * 100
   ELSEIF food(pnum) - numunits(pnum) * 100 >= 0 THEN
      LOCATE 21, xpl - 1: PRINT food(pnum) - numunits(pnum) * 100
   END IF
   LOCATE 23, xpl - 1: PRINT gold(pnum); : COLOR 13: PRINT "+"; gpturn(pnum): COLOR 2
   IF pnum = 1 THEN VIEW (428, 198)-(608, 261), 0, 14
   IF pnum = 2 THEN VIEW (108, 198)-(288, 261), 0, 14
   COLOR 7: LOCATE 16, xpl - 6: PRINT mes1$
   LOCATE 17, xpl - 6: PRINT mes2$
   LOCATE 18, xpl - 6: PRINT mes3$
   IF pnum = 1 THEN VIEW (345, 198)-(408, 261), 0, 10
   IF pnum = 2 THEN VIEW (25, 198)-(88, 261), 0, 10
   PUT (2, 2), mmap, PSET
   LINE (xp(pnum), yp(pnum))-(xp(pnum) + 16, yp(pnum) + 16), 15, B
   coltime2# = TIMER
   IF coltime2# - coltime1# > .25 THEN coltime1# = TIMER: CALL WATERFADE
   IF pnum = 1 THEN VIEW (10, 40)-(309, 339)
   IF pnum = 2 THEN VIEW (330, 40)-(629, 339)
   LINE (xcur(pnum) * 20, ycur(pnum) * 20)-(xcur(pnum) * 20 + 19, ycur(pnum) * 20 + 19), curcol, B
   PCOPY 1, 0

LOOP

updateunits:

unum2 = 0
IF pnum = 1 THEN
   FOR unum = 1 TO 60
      IF unitype1(unum) = 11 AND totunits(1) < 60 AND curact1(unum) > 2 THEN
         IF curact1(unum) = 3 AND gold(1) >= 5000 THEN
            BUILD 4, 5000, 31, 250
         ELSEIF curact1(unum) = 15 AND gold(1) >= 3000 THEN
            BUILD 16, 3000, 37, 200
         ELSEIF curact1(unum) = 5 AND gold(1) >= 2300 THEN
            BUILD 6, 2300, 33, 150
         ELSEIF curact1(unum) = 12 AND gold(1) >= 1200 THEN
            BUILD 13, 1200, 35, 75
         ELSEIF curact1(unum) = 19 AND gold(1) >= 350 THEN
            BUILD 20, 350, 39, 50
         ELSE
            SELECT CASE curact1(unum)
               CASE 3, 15, 5, 12, 19
                  curact1(unum) = 1
            END SELECT
         END IF
      ELSEIF unitype1(unum) = 11 THEN
         curact1(unum) = 1
      ELSEIF unitype1(unum) = 31 THEN
         CONSTRUCT 32
      ELSEIF unitype1(unum) = 33 THEN
         CONSTRUCT 34
      ELSEIF unitype1(unum) = 35 THEN
         CONSTRUCT 36
      ELSEIF unitype1(unum) = 37 THEN
         CONSTRUCT 38
      ELSEIF unitype1(unum) = 39 THEN
         CONSTRUCT 30
      ELSEIF unitype1(unum) = 32 THEN
         IF curact1(unum) = 0 THEN
            gold(1) = gold(1) + 100
         ELSEIF curact1(unum) = 7 AND gold(1) >= 250 AND food(1) / 100 > numunits(1) AND totunits(1) < 60 OR curact1(unum) = 11 THEN
            BUYUNIT 7, 11, 250, 1, 11, 12
         END IF
      ELSEIF unitype1(unum) = 34 THEN
         IF curact1(unum) = 8 AND gold(1) >= 500 AND food(1) / 100 > numunits(1) AND totunits(1) < 60 OR curact1(unum) = 11 THEN
            BUYUNIT 8, 11, 500, 1, 12, 28
         ELSEIF curact1(unum) = 9 AND gold(1) >= 900 AND food(1) / 100 > numunits(1) AND totunits(1) < 60 OR curact1(unum) = 13 THEN
            BUYUNIT 9, 13, 900, 1, 13, 16
         END IF
      ELSEIF unitype1(unum) = 38 THEN
         IF curact1(unum) = 17 AND gold(1) >= 1500 AND food(1) / 100 > numunits(1) AND totunits(1) < 60 OR curact1(unum) = 11 THEN
            BUYUNIT 17, 11, 1500, 2, 14, 44
         END IF
      END IF
      SELECT CASE curact1(unum)
         CASE 1, 2, 14, 18
            curact1(unum) = 1
            SELECT CASE unitype1(unum)
                CASE 11, 12
                  movement(unum) = 5
               CASE 13
                  movement(unum) = 10
               CASE 14
                  movement(unum) = 15
            END SELECT
         CASE 7, 8, 9, 17
            movement(unum) = 0: curact1(unum) = 0
         CASE ELSE
            movement(unum) = 0
      END SELECT
      IF unum2 > 0 THEN movement(unum2) = 5: unum2 = 0
      totunits(1) = structures(1) + numunits(1)
   NEXT
ELSEIF pnum = 2 THEN
   FOR unum = 1 TO 60
      IF unitype2(unum) = 21 AND totunits(2) < 60 AND curact2(unum) > 2 THEN
         IF curact2(unum) = 3 AND gold(2) >= 5000 THEN
            BUILD 4, 5000, 41, 250
         ELSEIF curact2(unum) = 15 AND gold(2) >= 3000 THEN
            BUILD 16, 3000, 47, 200
         ELSEIF curact2(unum) = 5 AND gold(2) >= 2300 THEN
            BUILD 6, 2300, 43, 150
         ELSEIF curact2(unum) = 12 AND gold(2) >= 1200 THEN
            BUILD 13, 1200, 45, 75
         ELSEIF curact2(unum) = 19 AND gold(2) >= 350 THEN
            BUILD 20, 350, 49, 50
         ELSE
            SELECT CASE curact2(unum)
               CASE 3, 15, 5, 12, 19
                  curact2(unum) = 1
            END SELECT
         END IF
      ELSEIF unitype2(unum) = 21 THEN
         curact2(unum) = 1
      ELSEIF unitype2(unum) = 41 THEN
         CONSTRUCT 42
      ELSEIF unitype2(unum) = 43 THEN
         CONSTRUCT 44
      ELSEIF unitype2(unum) = 45 THEN
         CONSTRUCT 46
      ELSEIF unitype2(unum) = 47 THEN
         CONSTRUCT 48
      ELSEIF unitype2(unum) = 49 THEN
         CONSTRUCT 40
      ELSEIF unitype2(unum) = 42 THEN
         IF curact2(unum) = 0 THEN
            gold(2) = gold(2) + 100
         ELSEIF curact2(unum) = 7 AND gold(2) >= 250 AND food(2) / 100 > numunits(2) AND totunits(2) < 60 OR curact2(unum) = 11 THEN
           BUYUNIT 7, 11, 250, 1, 21, 12
         END IF
      ELSEIF unitype2(unum) = 44 THEN
         IF curact2(unum) = 8 AND gold(2) >= 500 AND food(2) / 100 > numunits(2) AND totunits(2) < 60 OR curact2(unum) = 11 THEN
            BUYUNIT 8, 11, 500, 1, 22, 28
         ELSEIF curact2(unum) = 9 AND gold(2) >= 900 AND food(2) / 100 > numunits(2) AND totunits(2) < 60 OR curact2(unum) = 13 THEN
            BUYUNIT 9, 13, 900, 1, 23, 16
         END IF
      ELSEIF unitype2(unum) = 48 THEN
         IF curact2(unum) = 17 AND gold(2) >= 1500 AND food(2) / 100 > numunits(2) AND totunits(2) < 60 OR curact2(unum) = 11 THEN
            BUYUNIT 17, 11, 1500, 2, 24, 44
         END IF
      END IF
      SELECT CASE curact2(unum)
         CASE 1, 2, 14, 18
            curact2(unum) = 1
            SELECT CASE unitype2(unum)
               CASE 21, 22
                  movement(unum) = 5
               CASE 23
                  movement(unum) = 10
               CASE 24
                  movement(unum) = 15
            END SELECT
         CASE 7, 8, 9, 17
            movement(unum) = 0: curact2(unum) = 0
         CASE ELSE
            movement(unum) = 0
      END SELECT
      IF unum2 > 0 THEN movement(unum2) = 5: unum2 = 0
      totunits(2) = structures(2) + numunits(2)
   NEXT
END IF
scrscroll = FALSE: scrcol = 14: damage = 0
IF gold(pnum) > 99900 THEN gold(pnum) = 99900
RETURN

haltpro:
SCREEN 9, 0, 0, 0: COLOR 7
VIEW (0, 0)-(639, 349), 0, 0
LOCATE 1, 1: PRINT "There was an error finding the right directory, or"
LOCATE 2, 1: PRINT "required files have been lost or corrupted."
LOCATE 3, 1: PRINT "Lost Realms will now end."
DO: LOOP UNTIL INKEY$ <> ""
SYSTEM

donepro:
SCREEN 9, 0, 0, 0: COLOR 7
VIEW (0, 0)-(639, 349), 0, 0
LOCATE 1, 1: PRINT "Thank you for playing Lost Realms."
SYSTEM

DATA 1, , , , ,1,1,1,1, ,1,1,1,1, ,1,1,1,1,1
DATA 1, , , , ,1, , ,1, ,1, , , , , , ,1, ,
DATA 1, , , , ,1, , ,1, ,1,1,1,1, , , ,1, ,
DATA 1, , , , ,1, , ,1, , , , ,1, , , ,1, ,
DATA 1,1,1,1, ,1,1,1,1, ,1,1,1,1, , , ,1, ,

DATA 1,1,1,1, ,1,1,1,1, ,1,1,1,1, ,1, , , , ,1,1,1,1,1, ,1,1,1,1
DATA 1, , ,1, ,1, , , , ,1, , ,1, ,1, , , , ,1, ,1, ,1, ,1, , ,
DATA 1,1,1,1, ,1,1,1,1, ,1,1,1,1, ,1, , , , ,1, ,1, ,1, ,1,1,1,1
DATA 1, ,1, , ,1, , , , ,1, , ,1, ,1, , , , ,1, ,1, ,1, , , , ,1
DATA 1, ,1,1, ,1,1,1,1, ,1, , ,1, ,1,1,1,1, ,1, ,1, ,1, ,1,1,1,1

SUB ADVISOR

IF pnum = 1 AND totunits(2) = 0 OR pnum = 2 AND totunits(1) = 0 THEN
   message(pnum) = 8
ELSEIF totunits(pnum) = 0 THEN
   message(pnum) = 10
ELSEIF numunits(pnum) = 0 THEN
   message(pnum) = 9
ELSEIF pnum = 1 AND numunits(2) < 3 OR pnum = 2 AND numunits(1) < 3 THEN
   message(pnum) = 7
ELSE
   city = FALSE: tower = FALSE: port = FALSE
   FOR unum = 1 TO 60
      IF pnum = 1 THEN
         SELECT CASE unitype1(unum)
            CASE 31, 32
               city = TRUE
            CASE 33, 34
               tower = TRUE
            CASE 37, 38
               port = TRUE
         END SELECT
      ELSEIF pnum = 2 THEN
         SELECT CASE unitype2(unum)
            CASE 41, 42
               city = TRUE
            CASE 43, 44
               tower = TRUE
            CASE 47, 48
               port = TRUE
         END SELECT
      END IF
   NEXT
   IF city = FALSE THEN
      message(pnum) = 1
   ELSEIF food(pnum) <= numunits(pnum) * 100 THEN
      message(pnum) = 2
   ELSEIF tower = FALSE THEN
      message(pnum) = 3
   ELSEIF numunits(pnum) < 6 THEN
      message(pnum) = 4
   ELSEIF port = FALSE THEN
      message(pnum) = 5
   ELSE
      message(pnum) = 6
   END IF
END IF

SELECT CASE message(pnum)
   CASE 1
      mes1$ = "LET US FIND A MINE"
      mes2$ = "SO WE MAY BUILD A"
      mes3$ = "CITY AND GET GOLD."
   CASE 2
      mes1$ = "WE MUST CONSTRUCT"
      mes2$ = "FARMS SO WE CAN"
      mes3$ = "FEED OUR TROOPS!"
   CASE 3
      mes1$ = "WE SHOULD BUILD A"
      mes2$ = "TOWER TO BUY"
      mes3$ = "SOLDIERS/SCOUTS."
   CASE 4
      mes1$ = "WE NEED TO BUY MORE"
      mes2$ = "UNITS SO WE CAN"
      mes3$ = "DEFEND OURSELVES."
   CASE 5
      mes1$ = "OUR KINGDOM WILL"
      mes2$ = "CRUSH THE ENEMY BY"
      mes3$ = "BUILDING A PORT!"
   CASE 6
      mes1$ = "OUR MIGHTY ARMY"
      mes2$ = "SHOULD MARCH TO"
      mes3$ = "FACE THE ENEMY!"
   CASE 7
      mes1$ = "THE ENEMY'S DEFENCES"
      mes2$ = "ARE ALMOST DEPLETED."
      mes3$ = "LET'S FINISH THEM!"
   CASE 8
      mes1$ = "THE GREAT ENEMY HAS"
      mes2$ = "AT LAST BEEN"
      mes3$ = "DEFEATED!"
   CASE 9
      mes1$ = "WE ARE COMPLETELY"
      mes2$ = "DEFENCELESS. MAY"
      mes3$ = "GOD HELP US!"
   CASE 10
      mes1$ = "ALL IS LOST..."
      mes2$ = "THERE IS NOTHING"
      mes3$ = "HERE BUT DEATH."
END SELECT

END SUB

SUB BUILD (S1, S2, S3, S4)

IF pnum = 1 THEN
   curact1(unum) = S1: gold(1) = gold(1) - S2: structures(1) = structures(1) + 1
   tnum = unitplace1(unum): terrain(tnum) = S3: unitype1(unum) = S3
   FOR newunum = 1 TO 60
      IF unitplace1(newunum) = 0 AND unitype1(newunum) = 0 THEN
         unitype1(newunum) = 11: hp1(newunum) = hp1(unum): mark1(unum) = newunum
         maxhp1(newunum) = maxhp1(unum): curact1(newunum) = curact1(unum)
         curact1(unum) = 10: hp1(unum) = 0: maxhp1(unum) = S4
         EXIT FOR
      END IF
   NEXT
ELSEIF pnum = 2 THEN
   curact2(unum) = S1: gold(2) = gold(2) - S2: structures(2) = structures(2) + 1
   tnum = unitplace2(unum): terrain(tnum) = S3: unitype2(unum) = S3
   FOR newunum = 1 TO 60
      IF unitplace2(newunum) = 0 AND unitype2(newunum) = 0 THEN
         unitype2(newunum) = 21: hp2(newunum) = hp2(unum): mark2(unum) = newunum
         maxhp2(newunum) = maxhp2(unum): curact2(newunum) = curact2(unum)
         curact2(unum) = 10: hp2(unum) = 0: maxhp2(unum) = S4
         EXIT FOR
      END IF
   NEXT
END IF

END SUB

SUB BUYUNIT (S1, S2, S3, tertype, S4, S5)

IF pnum = 1 THEN
   IF curact1(unum) = S1 THEN curact1(unum) = S2: gold(1) = gold(1) - S3: numunits(1) = numunits(1) + 1
   tnum = unitplace1(unum)
   complete = FALSE: FINDSPOT tertype
   IF complete THEN
      curact1(unum) = 0: unitype1(unum2) = S4
      tnum = unitplace1(unum2): terrain(tnum) = S4
      maxhp1(unum2) = S5: hp1(unum2) = S5: curact1(unum2) = 1
   END IF
ELSEIF pnum = 2 THEN
   IF curact2(unum) = S1 THEN curact2(unum) = S2: gold(2) = gold(2) - S3: numunits(2) = numunits(2) + 1
   tnum = unitplace2(unum)
   complete = FALSE: FINDSPOT tertype
   IF complete THEN
      curact2(unum) = 0: unitype2(unum2) = S4
      tnum = unitplace2(unum2): terrain(tnum) = S4
      maxhp2(unum2) = S5: hp2(unum2) = S5: curact2(unum2) = 1
   END IF
END IF

END SUB

SUB CHECKSPOT

IF tnum > 60 THEN
   xplace = tnum MOD 60
   IF xplace = 0 THEN xplace = 60
ELSE
   xplace = tnum
END IF
bcity = 0: bport = 0: bfarm = 0
xchg = 0: ychg = -60
FOR find = 1 TO 4
  newtnum = tnum + xchg + ychg
  dotask = TRUE
  IF newtnum < 1 OR newtnum > 3600 THEN dotask = FALSE
  IF xplace + xchg < 1 OR xplace + xchg > 60 THEN dotask = FALSE
  IF dotask THEN
     IF visible(newtnum) = pnum OR visible(newtnum) = 3 OR showmap THEN
        SELECT CASE terrain(tnum + xchg + ychg)
           CASE 0
              bcity = 1
           CASE 1
              btower = 1
           CASE 2
              bport = 1
           CASE 3
              bfarm = 1
        END SELECT
     END IF
  END IF
  IF xchg = 0 AND ychg = -60 THEN
     xchg = -1: ychg = 0
  ELSEIF xchg = -1 AND ychg = 0 THEN
     xchg = 1: ychg = 0
  ELSE
     xchg = 0: ychg = 60
  END IF
NEXT

END SUB

SUB CHGTEXT

   IF pnum = 1 THEN
      hp$ = LTRIM$(STR$(hp1(curunit))) + "/" + LTRIM$(STR$(maxhp1(curunit)))
      xpl = 62: curact = curact1(curunit): unitype = unitype1(curunit)
   ELSEIF pnum = 2 THEN
      hp$ = LTRIM$(STR$(hp2(curunit))) + "/" + LTRIM$(STR$(maxhp2(curunit)))
      xpl = 22: curact = curact2(curunit): unitype = unitype2(curunit)
   END IF
   IF hp$ = "0/0" THEN
      info.text3$ = "NONE"
   ELSE
      info.text3$ = hp$
   END IF
   SELECT CASE unitype
   CASE 0
      info.text1$ = "NONE": info.text4$ = "NONE"
   CASE 11, 21
      info.text1$ = "PEASANT": info.text4$ = "1-2"
   CASE 12, 22
      info.text1$ = "SOLDIER": info.text4$ = "2-5"
   CASE 13, 23
      info.text1$ = "SCOUT": info.text4$ = "1-4"
   CASE 14, 24
      info.text1$ = "WARSHIP": info.text4$ = "3-7"
   CASE 31, 41, 32, 42
      info.text1$ = "CITY": info.text4$ = "NONE"
   CASE 33, 43, 34, 44
      info.text1$ = "TOWER": info.text4$ = "NONE"
   CASE 35, 45, 36, 46
      info.text1$ = "FARM": info.text4$ = "NONE"
   CASE 37, 47, 38, 48
      info.text1$ = "PORT": info.text4$ = "NONE"
   CASE 39, 49, 30, 40
      info.text1$ = "WALL": info.text4$ = "NONE"
   END SELECT
  
   SELECT CASE curact
   CASE 0
      info.text2$ = "NONE"
   CASE 1
      info.text2$ = "AWAITING COMMAND"
   CASE 2
      info.text2$ = "RESTING"
   CASE 3
      info.text2$ = "CITY - 5000 GP"
   CASE 5
      info.text2$ = "TOWER - 2300 GP"
   CASE 7
      info.text2$ = "PEASANT - 250 GP"
   CASE 8
      info.text2$ = "SOLDIER - 500 GP"
   CASE 9
      info.text2$ = "SCOUT - 900 GP"
   CASE 10
      info.text2$ = "CONSRUCTION"
   CASE 11, 13
      info.text2$ = "UNIT READY"
   CASE 12
      info.text2$ = "FARM - 1200 GP"
   CASE 14
      info.text2$ = "ANCHORED"
   CASE 15
      info.text2$ = "PORT - 3000 GP"
   CASE 17
      info.text2$ = "WARSHIP - 1500 GP"
   CASE 18
      info.text2$ = "DEPLOY UNIT"
   CASE 19
      info.text2$ = "WALL - 350 GP"
   END SELECT

END SUB

SUB COMBAT

IF pnum = 1 THEN
   FOR eunum = 1 TO 60
      IF unitplace2(eunum) = etnum THEN
         IF unitype1(curunit) = 11 THEN md = 1: rd = 2
         IF unitype1(curunit) = 12 THEN md = 2: rd = 4
         IF unitype1(curunit) = 13 THEN md = 1: rd = 4
         IF unitype1(curunit) = 14 THEN md = 3: rd = 5
         dam = INT(RND * rd) + md
         damage = damage + dam
         hp2(eunum) = hp2(eunum) - dam
         IF hp2(eunum) <= 0 THEN
            IF effects THEN PLAY "MB L30 O1 BAB P5"
            unitplace2(eunum) = 0: terrain(etnum) = 1: victory = TRUE
            IF unitype2(eunum) = 42 THEN gpturn(2) = gpturn(2) - 100
            IF unitype2(eunum) < 30 THEN numunits(2) = numunits(2) - 1
            IF unitype2(eunum) > 29 THEN structures(2) = structures(2) - 1
            IF unitype2(eunum) = 46 THEN food(2) = food(2) - 500
            IF unitype2(eunum) = 24 THEN terrain(etnum) = 2
            IF mark2(eunum) > 0 THEN
               unitplace2(mark2(eunum)) = 0
               numunits(2) = numunits(2) - 1
               unitype2(mark2(eunum)) = 0
            END IF
            unitype2(eunum) = 0
            mark2(eunum) = 0
         ELSE
            IF effects THEN PLAY "MB L35 O1 ACF P5"
         END IF
         EXIT FOR
      END IF
   NEXT
ELSEIF pnum = 2 THEN
   FOR eunum = 1 TO 60
      IF unitplace1(eunum) = etnum THEN
         IF unitype2(curunit) = 21 THEN md = 1: rd = 2
         IF unitype2(curunit) = 22 THEN md = 2: rd = 4
         IF unitype2(curunit) = 23 THEN md = 1: rd = 4
         IF unitype2(curunit) = 24 THEN md = 3: rd = 5
         dam = INT(RND * rd) + md
         damage = damage + dam
         hp1(eunum) = hp1(eunum) - dam
         IF hp1(eunum) <= 0 THEN
            IF effects THEN PLAY "MB L30 O1 BAB P5"
            unitplace1(eunum) = 0: terrain(etnum) = 1: victory = TRUE
            IF unitype1(eunum) = 32 THEN gpturn(1) = gpturn(1) - 100
            IF unitype1(eunum) < 30 THEN numunits(1) = numunits(1) - 1
            IF unitype1(eunum) > 29 THEN structures(1) = structures(1) - 1
            IF unitype1(eunum) = 36 THEN food(1) = food(1) - 500
            IF unitype1(eunum) = 14 THEN terrain(etnum) = 2
            IF mark1(eunum) > 0 THEN
               unitplace1(mark1(eunum)) = 0
               numunits(1) = numunits(1) - 1
               unitype1(mark1(eunum)) = 0
            END IF
            unitype1(eunum) = 0
            mark1(eunum) = 0
         ELSE
            IF effects THEN PLAY "MB L35 O1 ACF P5"
         END IF
         EXIT FOR
      END IF
   NEXT
END IF

END SUB

SUB COMMANDS

IF pnum = 1 THEN
   mvleft$(1) = "S"
   mvright$(1) = "F"
   mvdown$(1) = "D"
   mvup$(1) = "E"
   endturn$(1) = CHR$(27)
   action$(1) = "A"
   switch$(1) = CHR$(9)
ELSEIF pnum = 2 THEN
   mvleft$(2) = CHR$(0) + CHR$(75)
   mvright$(2) = CHR$(0) + CHR$(77)
   mvdown$(2) = CHR$(0) + CHR$(80)
   mvup$(2) = CHR$(0) + CHR$(72)
   endturn$(2) = "-"
   action$(2) = "0"
   switch$(2) = CHR$(13)
END IF

END SUB

SUB CONSTRUCT (newter)

IF pnum = 1 THEN
   hp1(unum) = hp1(unum) + 25
   IF hp1(unum) >= maxhp1(unum) THEN
      hp1(unum) = maxhp1(unum)
      tnum = unitplace1(unum)
      complete = FALSE: FINDSPOT 1
      IF complete THEN
         IF newter = 36 THEN food(1) = food(1) + 500
         IF newter = 32 THEN gpturn(1) = gpturn(1) + 100
         curact1(unum2) = 1
         terrain(tnum) = newter: curact1(unum) = 0
         CALL LONGVIEW
         unitype1(unum) = newter
         tnum = unitplace1(unum2): terrain(tnum) = 11
     END IF
   END IF
ELSEIF pnum = 2 THEN
   hp2(unum) = hp2(unum) + 25
   IF hp2(unum) >= maxhp2(unum) THEN
      hp2(unum) = maxhp2(unum)
      tnum = unitplace2(unum)
      complete = FALSE: FINDSPOT 1
      IF complete THEN
         IF newter = 46 THEN food(2) = food(2) + 500
         IF newter = 42 THEN gpturn(2) = gpturn(2) + 100
         curact2(unum2) = 1
         terrain(tnum) = newter: curact2(unum) = 0
         CALL LONGVIEW
         unitype2(unum) = newter
         tnum = unitplace2(unum2): terrain(tnum) = 21
     END IF
   END IF
END IF

END SUB

SUB DRAWTER (vartype, xdif, ydif)

IF visible(tnum) = pnum OR visible(tnum) = 3 OR showmap THEN
   SELECT CASE vartype
   CASE 0
      PUT (x * 20 + xdif, y * 20 + ydif), mine, PSET
   CASE 1
      PUT (x * 20 + xdif, y * 20 + ydif), grass, PSET
   CASE 2
     PUT (x * 20 + xdif, y * 20 + ydif), water, PSET
   CASE 3
      PUT (x * 20 + xdif, y * 20 + ydif), tree, PSET
   CASE 11
      PUT (x * 20 + xdif, y * 20 + ydif), peasant1, PSET
   CASE 12
      PUT (x * 20 + xdif, y * 20 + ydif), soldier1, PSET
   CASE 16, 34
      PUT (x * 20 + xdif, y * 20 + ydif), tower1, PSET
   CASE 21
      PUT (x * 20 + xdif, y * 20 + ydif), peasant2, PSET
   CASE 22
      PUT (x * 20 + xdif, y * 20 + ydif), soldier2, PSET
   CASE 26, 44
      PUT (x * 20 + xdif, y * 20 + ydif), tower2, PSET
   CASE 31, 41, 45, 47, 39, 33, 43, 35, 37, 49
      PUT (x * 20 + xdif, y * 20 + ydif), constr, PSET
   CASE 32
      PUT (x * 20 + xdif, y * 20 + ydif), city1, PSET
   CASE 42
      PUT (x * 20 + xdif, y * 20 + ydif), city2, PSET
   CASE 36, 46
      PUT (x * 20 + xdif, y * 20 + ydif), farm, PSET
   CASE 13
      PUT (x * 20 + xdif, y * 20 + ydif), scout1, PSET
   CASE 23
      PUT (x * 20 + xdif, y * 20 + ydif), scout2, PSET
   CASE 38
      PUT (x * 20 + xdif, y * 20 + ydif), port1, PSET
   CASE 48
      PUT (x * 20 + xdif, y * 20 + ydif), port2, PSET
   CASE 14
      PUT (x * 20 + xdif, y * 20 + ydif), ship1, PSET
   CASE 24
      PUT (x * 20 + xdif, y * 20 + ydif), ship2, PSET
   CASE 30, 40
      PUT (x * 20 + xdif, y * 20 + ydif), wall, PSET
   END SELECT
ELSEIF visible(tnum) <> pnum THEN
   PUT (x * 20 + xdif, y * 20 + ydif), black, PSET
END IF

END SUB

SUB FINDSPOT (tertype)

xchgmax = 2: xchgmin = -1
FOR testnum = 60 TO 3600 STEP 60
   IF tnum = testnum THEN xchgmax = 1: EXIT FOR
   IF tnum = testnum - 59 THEN xchgmin = 0: EXIT FOR
NEXT

FOR newunum = 1 TO 60
   IF pnum = 1 THEN
      IF unitplace1(newunum) = 0 AND unitype1(newunum) = 0 AND mark1(unum) = 0 OR mark1(unum) = newunum THEN
         xchg = xchgmin: ychg = -60
         FOR find = 1 TO (xchgmax - xchgmin) * 3
            newtnum = tnum + xchg + ychg
            IF newtnum > 0 AND newtnum < 3601 THEN
               IF terrain(newtnum) = tertype THEN
                  unum2 = newunum: mark1(unum) = 0
                  complete = TRUE
                  unitplace1(newunum) = newtnum
                  IF visible(newtnum) = 2 THEN
                     visible(newtnum) = 3
                  ELSEIF visible(newtnum) = 0 THEN
                     visible(tnum + xchg + ychg) = 1
                  END IF
                  EXIT FOR
               END IF
            END IF
            xchg = xchg + 1: IF xchg = xchgmax THEN xchg = xchgmin: ychg = ychg + 60
         NEXT
         EXIT FOR
      END IF
   ELSEIF pnum = 2 THEN
      IF unitplace2(newunum) = 0 AND unitype2(newunum) = 0 AND mark2(unum) = 0 OR mark2(unum) = newunum THEN
         chg = 1: xchg = -1: ychg = -60: chgmax = 9
         FOR find = 1 TO (xchgmax - xchgmin) * 3
            newtnum = tnum + xchg + ychg
            IF newtnum > 0 AND newtnum < 3601 THEN
               IF terrain(newtnum) = tertype THEN
                  unum2 = newunum: mark2(unum) = 0
                  complete = TRUE
                  unitplace2(newunum) = newtnum
                  IF visible(newtnum) = 1 THEN
                     visible(newtnum) = 3
                  ELSEIF visible(newtnum) = 0 THEN
                     visible(newtnum) = 2
                  END IF
                  EXIT FOR
               END IF
            END IF
            xchg = xchg + 1: IF xchg = xchgmax THEN xchg = xchgmin: ychg = ychg + 60
         NEXT
         EXIT FOR
      END IF
   END IF
NEXT

END SUB

SUB LOADGAME

SCREEN 9, 0, 1, 0
OPEN PATH$ + "save.dat" FOR INPUT AS #1
FOR snum = 1 TO 3600
   INPUT #1, visible(snum), terrain(snum)
NEXT
FOR unum = 1 TO 60
   INPUT #1, curact1(unum), curact2(unum), hp1(unum), maxhp1(unum), mark1(unum)
   INPUT #1, hp2(unum), maxhp2(unum), unitplace1(unum), unitplace2(unum), mark2(unum)
   INPUT #1, unitype1(unum), unitype2(unum), movement(unum)
NEXT
INPUT #1, pnum, xpl2, ypl, effects
FOR tpnum = 1 TO 2
   INPUT #1, xp(tpnum), yp(tpnum), xcur(tpnum), ycur(tpnum), gold(tpnum), food(tpnum)
   INPUT #1, numunits(tpnum), structures(tpnum), curterrain(tpnum), totunits(tpnum), gpturn(tpnum)
NEXT
CLOSE #1
moveunit = FALSE: scrscroll = FALSE: showmap = FALSE
curcol = 15: curunit = 0: damage = 0: scrcol = 14
CALL COMMANDS
VIEW (330, 40)-(629, 339), 0, 0
VIEW (10, 40)-(309, 339), 0, 0

END SUB

SUB LONGVIEW

IF tnum > 60 THEN
   xplace = tnum MOD 60
   IF xplace = 0 THEN xplace = 60
ELSE
   xplace = tnum
END IF
IF terrain(tnum) = 34 OR terrain(tnum) = 44 THEN
   xchg = -3: ychg = -180: vnum = 49: xmax = 4: xmin = -3
ELSEIF terrain(tnum) = 32 OR terrain(tnum) = 42 OR terrain(tnum) = 38 OR terrain(tnum) = 48 THEN
   xchg = -2: ychg = -120: vnum = 25: xmax = 3: xmin = -2
ELSEIF terrain(tnum) = 36 OR terrain(tnum) = 46 OR terrain(tnum) = 30 OR terrain(tnum) = 40 THEN
   xchg = -1: ychg = -60: vnum = 9: xmax = 2: xmin = -1
END IF
FOR times = 1 TO vnum
   newtnum = tnum + xchg + ychg
   dotask = TRUE
   IF newtnum < 1 OR newtnum > 3600 THEN dotask = FALSE
   IF xplace + xchg < 1 OR xplace + xchg > 60 THEN dotask = FALSE
   IF pnum = 1 AND dotask THEN
      IF visible(newtnum) = 2 THEN
         visible(newtnum) = 3
      ELSEIF visible(newtnum) = 0 THEN
         visible(newtnum) = 1
      END IF
   ELSEIF pnum = 2 AND dotask THEN
      IF visible(newtnum) = 1 THEN
         visible(newtnum) = 3
      ELSEIF visible(newtnum) = 0 THEN
         visible(newtnum) = 2
      END IF
   END IF
   xchg = xchg + 1: IF xchg = xmax THEN xchg = xmin: ychg = ychg + 60
NEXT

END SUB

SUB MINIMAP

IF pnum = 1 THEN VIEW (345, 198)-(408, 261), 0, 0
IF pnum = 2 THEN VIEW (25, 198)-(88, 261), 0, 0
x = 2: y = 2
FOR tnum2 = 1 TO 3600
   IF visible(tnum2) = pnum OR visible(tnum2) = 3 OR showmap THEN
      SELECT CASE terrain(tnum2)
      CASE 0
         pcol = 14
      CASE 2
         pcol = 9
      CASE 11, 12, 13, 14, 30 TO 39
         pcol = 4
      CASE 21, 22, 23, 24, 40 TO 49
         pcol = 11
      CASE 3
         pcol = 6
      CASE 1
         pcol = 2
      END SELECT
   ELSE
      pcol = 0
   END IF
   PSET (x, y), pcol
   x = x + 1: IF x = 62 THEN x = 2: y = y + 1
NEXT
GET (2, 2)-(61, 61), mmap

END SUB

SUB MVUNITS

boardship = FALSE: leaveship = FALSE
IF UCASE$(sel$) = mvright$(pnum) THEN xdir = 1: ydir = 0: tdir = 1
IF UCASE$(sel$) = mvleft$(pnum) THEN xdir = -1: ydir = 0: tdir = -1
IF UCASE$(sel$) = mvup$(pnum) THEN xdir = 0: ydir = -1: tdir = -60
IF UCASE$(sel$) = mvdown$(pnum) THEN xdir = 0: ydir = 1: tdir = 60

IF scrscroll = FALSE THEN
   REVISEMAP 2
   tnum = (yp(pnum) - 1 + ycur(pnum)) * 60 + xp(pnum) + xcur(pnum)
   dotask = FALSE
   IF xcur(pnum) > 0 AND xdir = -1 OR xcur(pnum) < 14 AND xdir = 1 OR ycur(pnum) > 0 AND ydir = -1 OR ycur(pnum) < 14 AND ydir = 1 THEN dotask = TRUE
   IF xp(pnum) > 1 AND xdir = -1 OR xp(pnum) < 46 AND xdir = 1 OR yp(pnum) > 1 AND ydir = -1 OR yp(pnum) < 46 AND ydir = 1 THEN dotask = TRUE
   IF dotask THEN
      dotask = FALSE
      IF moveunit = FALSE THEN dotask = TRUE
      IF moveunit AND movement(curunit) > 0 THEN
         IF terrain(tnum + tdir) = 1 AND pnum = 1 AND unitype1(curunit) < 14 THEN dotask = TRUE
         IF terrain(tnum + tdir) = 1 AND pnum = 2 AND unitype2(curunit) < 24 THEN dotask = TRUE
         IF terrain(tnum + tdir) = 2 AND pnum = 1 AND unitype1(curunit) = 14 THEN dotask = TRUE
         IF terrain(tnum + tdir) = 2 AND pnum = 2 AND unitype2(curunit) = 24 THEN dotask = TRUE
         IF terrain(tnum + tdir) = 1 AND pnum = 1 AND unitype1(curunit) = 14 AND curact1(curunit) = 18 THEN
            IF visible(tnum + tdir) = 1 OR visible(tnum + tdir) = 3 OR showmap THEN
               dotask = TRUE: curact1(curunit) = 1: prunit = curunit
               curunit = mark1(curunit): mark1(prunit) = 0: damage = 0
               leaveship = TRUE: CALL CHGTEXT
            END IF
         ELSEIF terrain(tnum + tdir) = 1 AND pnum = 2 AND unitype2(curunit) = 24 AND curact2(curunit) = 18 THEN
            IF visible(tnum + tdir) = 2 OR visible(tnum + tdir) = 3 OR showmap THEN
               dotask = TRUE: curact2(curunit) = 1: prunit = curunit
               curunit = mark2(curunit): mark2(prunit) = 0: damage = 0
               leaveship = TRUE: CALL CHGTEXT
            END IF
         ELSEIF terrain(tnum + tdir) = 14 AND pnum = 1 AND unitype1(curunit) <> 14 THEN
            FOR unum = 1 TO 60
               IF unitplace1(unum) = tnum + tdir AND mark1(unum) = 0 THEN dotask = TRUE: EXIT FOR
            NEXT
         ELSEIF terrain(tnum + tdir) = 24 AND pnum = 2 AND unitype2(curunit) <> 24 THEN
            FOR unum = 1 TO 60
               IF unitplace2(unum) = tnum + tdir AND mark2(unum) = 0 THEN dotask = TRUE: EXIT FOR
            NEXT
         END IF
      END IF
      IF dotask THEN
         IF moveunit AND terrain(tnum + tdir) = 1 THEN
            IF leaveship = FALSE THEN PUT (xcur(pnum) * 20, ycur(pnum) * 20), grass, PSET: terrain(tnum) = 1
            IF xcur(pnum) > 0 AND xdir = -1 OR xcur(pnum) < 14 AND xdir = 1 OR ycur(pnum) > 0 AND ydir = -1 OR ycur(pnum) < 14 AND ydir = 1 THEN
               IF pnum = 1 THEN
                  IF curact1(curunit) <> 1 THEN curact1(curunit) = 1: CALL CHGTEXT
                  IF unitype1(curunit) = 11 THEN PUT (xcur(pnum) * 20 + xdir * 20, ycur(pnum) * 20 + ydir * 20), peasant1, PSET
                  IF unitype1(curunit) = 12 THEN PUT (xcur(pnum) * 20 + xdir * 20, ycur(pnum) * 20 + ydir * 20), soldier1, PSET
                  IF unitype1(curunit) = 13 THEN PUT (xcur(pnum) * 20 + xdir * 20, ycur(pnum) * 20 + ydir * 20), scout1, PSET
               ELSEIF pnum = 2 THEN
                  IF curact2(curunit) <> 1 THEN curact2(curunit) = 1: CALL CHGTEXT
                  IF unitype2(curunit) = 21 THEN PUT (xcur(pnum) * 20 + xdir * 20, ycur(pnum) * 20 + ydir * 20), peasant2, PSET
                  IF unitype2(curunit) = 22 THEN PUT (xcur(pnum) * 20 + xdir * 20, ycur(pnum) * 20 + ydir * 20), soldier2, PSET
                  IF unitype2(curunit) = 23 THEN PUT (xcur(pnum) * 20 + xdir * 20, ycur(pnum) * 20 + ydir * 20), scout2, PSET
               END IF
            END IF
         ELSEIF moveunit AND terrain(tnum + tdir) = 2 THEN
            PUT (xcur(pnum) * 20, ycur(pnum) * 20), water, PSET
            IF xcur(pnum) > 0 AND xdir = -1 OR xcur(pnum) < 14 AND xdir = 1 OR ycur(pnum) > 0 AND ydir = -1 OR ycur(pnum) < 14 AND ydir = 1 THEN
               IF pnum = 1 THEN PUT (xcur(pnum) * 20 + xdir * 20, ycur(pnum) * 20 + ydir * 20), ship1, PSET
               IF pnum = 2 THEN PUT (xcur(pnum) * 20 + xdir * 20, ycur(pnum) * 20 + ydir * 20), ship2, PSET
            END IF
            terrain(tnum) = 2
         ELSEIF pnum = 2 AND terrain(tnum + tdir) = 24 AND moveunit OR pnum = 1 AND terrain(tnum + tdir) = 14 AND moveunit THEN
            PUT (xcur(pnum) * 20, ycur(pnum) * 20), grass, PSET
            terrain(tnum) = 1: boardship = TRUE
            IF pnum = 1 THEN mark1(unum) = curunit: unitplace1(curunit) = 0
            IF pnum = 2 THEN mark2(unum) = curunit: unitplace2(curunit) = 0
            curunit = unum: damage = 0: IF movement(unum) = 0 THEN curcol = 11
            CALL CHGTEXT
         END IF
         IF effects AND moveunit THEN PLAY "MB L40 O1 C"
         tnum = tnum + tdir
         IF moveunit AND boardship = FALSE THEN CALL VISION
         curterrain(pnum) = terrain(tnum)
         IF xcur(pnum) > 0 AND xdir = -1 OR xcur(pnum) < 14 AND xdir = 1 OR ycur(pnum) > 0 AND ydir = -1 OR ycur(pnum) < 14 AND ydir = 1 THEN
            xcur(pnum) = xcur(pnum) + xdir: ycur(pnum) = ycur(pnum) + ydir
         ELSEIF xp(pnum) > 1 AND xdir = -1 OR xp(pnum) < 46 AND xdir = 1 OR yp(pnum) > 1 AND ydir = -1 OR yp(pnum) < 46 AND ydir = 1 THEN
            xp(pnum) = xp(pnum) + xdir: yp(pnum) = yp(pnum) + ydir
            REVISEMAP 1
         END IF
      ELSEIF moveunit AND tnum + tdir > 0 AND tnum + tdir < 3601 AND movement(curunit) > 0 THEN
         IF visible(tnum + tdir) = 3 OR visible(tnum + tdir) = pnum OR showmap THEN
            dotask = FALSE
            IF terrain(tnum + tdir) > 20 AND terrain(tnum + tdir) < 30 AND pnum = 1 OR terrain(tnum + tdir) < 20 AND terrain(tnum + tdir) > 10 AND pnum = 2 THEN dotask = TRUE
            IF terrain(tnum + tdir) > 29 AND terrain(tnum + tdir) < 40 AND pnum = 2 OR terrain(tnum + tdir) > 39 AND terrain(tnum + tdir) < 50 AND pnum = 1 THEN dotask = TRUE
            IF dotask THEN
               CALL TIRED: etnum = tnum + tdir: victory = FALSE: CALL COMBAT
               IF xcur(pnum) > 0 AND xdir = -1 OR xcur(pnum) < 14 AND xdir = 1 OR ycur(pnum) > 0 AND ydir = -1 OR ycur(pnum) < 14 AND ydir = 1 THEN
                  IF terrain(tnum + tdir) = 1 THEN
                     PUT (xcur(pnum) * 20 + xdir * 20, ycur(pnum) * 20 + ydir * 20), grass, PSET
                  ELSEIF terrain(tnum + tdir) = 2 THEN
                     PUT (xcur(pnum) * 20 + xdir * 20, ycur(pnum) * 20 + ydir * 20), water, PSET
                  END IF
               END IF
            END IF
         ELSE
            dotask = FALSE
            IF xp(pnum) > 1 AND xdir = -1 OR xp(pnum) < 46 AND xdir = 1 OR yp(pnum) > 1 AND ydir = -1 OR yp(pnum) < 46 AND ydir = 1 THEN dotask = TRUE
            IF xcur(pnum) > 0 AND xdir = -1 OR xcur(pnum) < 14 AND xdir = 1 OR ycur(pnum) > 0 AND ydir = -1 OR ycur(pnum) < 14 AND ydir = 1 THEN dotask = TRUE
            IF dotask THEN
               tnum2 = tnum + tdir
               IF pnum = 1 THEN
                  IF visible(tnum2) = 0 THEN visible(tnum2) = 1
                  IF visible(tnum2) = 2 THEN visible(tnum2) = 3
               ELSEIF pnum = 2 THEN
                  IF visible(tnum2) = 0 THEN visible(tnum2) = 2
                  IF visible(tnum2) = 1 THEN visible(tnum2) = 3
               END IF
               IF xcur(pnum) > 0 AND xdir = -1 OR xcur(pnum) < 14 AND xdir = 1 OR ycur(pnum) > 0 AND ydir = -1 OR ycur(pnum) < 14 AND ydir = 1 THEN
                  xchg = xdir * 20: ychg = ydir * 20: REVISEMAP 3
               END IF
            END IF
         END IF
      END IF
   END IF
ELSEIF scrscroll THEN
   xp(pnum) = xp(pnum) + xdir * 5: yp(pnum) = yp(pnum) + ydir * 5
   IF xp(pnum) < 1 THEN xp(pnum) = 1
   IF xp(pnum) > 46 THEN xp(pnum) = 46
   IF yp(pnum) < 1 THEN yp(pnum) = 1
   IF yp(pnum) > 46 THEN yp(pnum) = 46
   REVISEMAP 1
END IF

END SUB

SUB REVISEMAP (revmap)

IF revmap = 1 THEN
   IF pnum = 1 THEN VIEW (10, 40)-(309, 339), 0, scrcol: xpl = 44
   IF pnum = 2 THEN VIEW (330, 40)-(629, 339), 0, scrcol: xpl = 4
   x = 0: y = 0
   FOR times = 1 TO 225
      tnum = (yp(pnum) - 1 + y) * 60 + xp(pnum) + x
      vartype = terrain(tnum): xdif = x * 20: ydif = y * 20
      DRAWTER vartype, xdif, ydif
      x = x + 1: IF x = 15 THEN x = 0: y = y + 1
   NEXT
   tnum = (yp(pnum) - 1 + ycur(pnum)) * 60 + xp(pnum) + xcur(pnum)
   curterrain(pnum) = terrain(tnum)
   COLOR 7
   LOCATE 5, xpl: PRINT "SELECTED UNIT >>>"
   LOCATE 7, xpl: PRINT "CURRENT STATUS >>"
   LOCATE 9, xpl: PRINT "HIT POINTS >>>>>>"
   LOCATE 11, xpl: PRINT "ATTACK DAMAGE >>>"
   LOCATE 13, xpl: PRINT "REMAINING MOVES >"
   LOCATE 21, xpl: PRINT "CURRENT FOOD >>>>"
   LOCATE 23, xpl: PRINT "GOLD PIECES >>>>>"
   CALL CHGTEXT
ELSEIF revmap = 2 THEN
   vartype = curterrain(pnum)
   xdif = xcur(pnum) * 20: ydif = ycur(pnum) * 20
   DRAWTER vartype, xdif, ydif
ELSEIF revmap = 3 THEN
   vartype = terrain(tnum2)
   xdif = xcur(pnum) * 20 + xchg: ydif = ycur(pnum) * 20 + ychg
   DRAWTER vartype, xdif, ydif
END IF

END SUB

SUB SAVEGAME

OPEN PATH$ + "save.dat" FOR OUTPUT AS #1
x = 0
FOR snum = 1 TO 3600
   IF x < 29 THEN PRINT #1, visible(snum); terrain(snum);
   IF x = 29 THEN PRINT #1, visible(snum); terrain(snum)
   x = x + 1: IF x = 30 THEN x = 0
NEXT
x = 0
FOR unum = 1 TO 60
   PRINT #1, curact1(unum); curact2(unum); hp1(unum); maxhp1(unum); mark1(unum)
   PRINT #1, hp2(unum); maxhp2(unum); unitplace1(unum); unitplace2(unum); mark2(unum)
   IF x < 4 THEN PRINT #1, unitype1(unum); unitype2(unum); movement(unum);
   IF x = 4 THEN PRINT #1, unitype1(unum); unitype2(unum); movement(unum)
   x = x + 1: IF x = 5 THEN x = 0
NEXT
PRINT #1, pnum; xpl; ypl; effects
FOR tpnum = 1 TO 2
   PRINT #1, xp(tpnum); yp(tpnum); xcur(tpnum); ycur(tpnum); gold(tpnum); food(tpnum);
   PRINT #1, numunits(tpnum); structures(tpnum); curterrain(tpnum); totunits(tpnum), gpturn(tpnum)
NEXT
CLOSE #1

END SUB

SUB SCREENSET

SCREEN 9, 0, 1, 0: CLS
x = 0: y = 0
FOR num = 1 TO 544
   PUT (x, y), texture1, PSET
   x = x + 20: IF x = 640 THEN x = 0: y = y + 20
NEXT
x = 0: y = 340
FOR num = 1 TO 32
   PUT (x, y), texture2, PSET
   x = x + 20
NEXT

END SUB

SUB TIRED

movement(curunit) = movement(curunit) - 1
IF movement(curunit) = 0 THEN
   curcol = 11
   IF pnum = 1 THEN
      IF unitype1(curunit) < 14 THEN curact1(curunit) = 2
      IF unitype1(curunit) = 14 THEN curact1(curunit) = 14
   ELSEIF pnum = 2 THEN
      IF unitype2(curunit) < 24 THEN curact2(curunit) = 2
      IF unitype2(curunit) = 24 THEN curact2(curunit) = 14
   END IF
   CALL CHGTEXT
END IF

END SUB

SUB TITLESCR

SCREEN 12: CLS
ftype1 = 1: ftype2 = 1: flook = 1: change = 1
col1 = 40: col3 = 63 + 256 * 10 + 256 * 10

DO
   time1# = TIMER
   PALETTE 0, col4: PALETTE 12, col3
   PALETTE 15, col2: PALETTE 4, col1
   x = 120: y = 100: flook = 1
   FOR lnum = 1 TO 100
      IF lline(lnum) = 1 THEN
         IF flook = 1 THEN
            IF ftype1 = 1 THEN PUT (x, y), flame1, PSET
            IF ftype1 = 2 THEN PUT (x, y), flame2, PSET
            IF ftype1 = 3 THEN PUT (x, y), flame3, PSET
         ELSEIF flook = 2 THEN
            IF ftype1 = 1 THEN PUT (x, y), flame4, PSET
            IF ftype1 = 2 THEN PUT (x, y), flame5, PSET
            IF ftype1 = 3 THEN PUT (x, y), flame6, PSET
         END IF
         ftype1 = ftype1 + 1: IF ftype1 = 4 THEN ftype1 = 1
      END IF
      x = x + 20
      IF x = 520 THEN
         x = 120: y = y + 20
         IF flook = 1 THEN
            flook = 2
         ELSE
            flook = 1
         END IF
      END IF
   NEXT
   x = 20: y = 230: flook = 1
   FOR lnum = 101 TO 250
      IF lline(lnum) = 1 THEN
         IF flook = 1 THEN
            IF ftype2 = 1 THEN PUT (x, y), flame1, PSET
            IF ftype2 = 2 THEN PUT (x, y), flame2, PSET
            IF ftype2 = 3 THEN PUT (x, y), flame3, PSET
         ELSEIF flook = 2 THEN
            IF ftype2 = 1 THEN PUT (x, y), flame4, PSET
            IF ftype2 = 2 THEN PUT (x, y), flame5, PSET
            IF ftype2 = 3 THEN PUT (x, y), flame6, PSET
         END IF
         ftype2 = ftype2 + 1: IF ftype2 = 4 THEN ftype2 = 1
      END IF
      x = x + 20
      IF x = 620 THEN
         x = 20: y = y + 20
         IF flook = 1 THEN
            flook = 2
         ELSE
            flook = 1
         END IF
      END IF
   NEXT
   ftype1 = ftype1 + 1: IF ftype1 = 4 THEN ftype1 = 1
   ftype2 = ftype2 + 1: IF ftype2 = 4 THEN ftype2 = 1
   LOCATE 25, 30: COLOR 15: PRINT "PRESS ENTER TO BEGIN";
   LOCATE 29, 23: COLOR 12: PRINT "COPYRIGHT 1998-1999 XFLARE SOFTWARE";
   IF change = 1 THEN
      col4 = col4 + 65536
      col2 = col2 + 65793 * 2: IF col2 = 30 * 65793 THEN change = 2
   ELSEIF change = 2 THEN
      col4 = col4 - 65536
      col2 = col2 - 65793 * 2: IF col2 = 0 THEN change = 1
   END IF
   DO: time2# = TIMER: LOOP UNTIL time2# - time1# > .05
LOOP UNTIL INKEY$ = CHR$(13)

END SUB

SUB VISION

IF leaveship = FALSE THEN CALL TIRED
IF pnum = 1 THEN
   unitplace1(curunit) = tnum: terrain(tnum) = unitype1(curunit)
   IF visible(tnum) = 0 THEN visible(tnum) = 1
   IF visible(tnum) = 2 THEN visible(tnum) = 3
ELSEIF pnum = 2 THEN
   unitplace2(curunit) = tnum: terrain(tnum) = unitype2(curunit)
   IF visible(tnum) = 0 THEN visible(tnum) = 2
   IF visible(tnum) = 1 THEN visible(tnum) = 3
END IF

END SUB

SUB WATERFADE

OUT &H3C8, 61
FOR chgcol = 0 TO 2
   find = (wfade * 6) + (chgcol * 2) + 1
   newcol = VAL(MID$("000858000235000858001262", find, 2))
   OUT &H3C9, newcol
NEXT
OUT &H3C8, 5
FOR chgcol = 0 TO 2
   find = (wfade * 6) + (chgcol * 2) + 1
   newcol = VAL(MID$("001262000858000235000858", find, 2))
   OUT &H3C9, newcol
NEXT
wfade = wfade + 1: IF wfade = 4 THEN wfade = 0

END SUB

