// This is (c) Peter Binsted 1999
#include "global.h"

void setmode(int mode);
void InitStars(void);
void DrawShip(void);
void EraseShip(void);
void Die(void);

char far *vga = (char far *)0xA0000000L;
Star_t 	stars[400];
Ship_t	CapSpace = {303, 91};

void main(void)
{
	randomize();
	InitStars();
	setmode(0x13);

	PlayGame();

	setmode(0x03);
	return;
}

void InitStars(void)
{
	FILE *fp;

	for (int t = 0; t < NUMSTARS; t++)
	{
		stars[t].x = rand() % 80;
		stars[t].y = rand() % 200;
		stars[t].brightness = rand() % 5;
		stars[t].delaycounter = 0;
	}
	fp = fopen("ship.dat", "rb");
	if (fp == NULL)
		return;
	fread(CapSpace.Frame[0], 1, 256, fp);
	fclose(fp);
	fp = fopen("shipd1.dat", "rb");
	if (fp == NULL)
		return;
	fread(CapSpace.Frame[1], 1, 256, fp);
	fclose(fp);
	fp = fopen("shipd2.dat", "rb");
	if (fp == NULL)
		return;
	fread(CapSpace.Frame[2], 1, 256, fp);
	fclose(fp);
	fp = fopen("shipd3.dat", "rb");
	if (fp == NULL)
		return;
	fread(CapSpace.Frame[3], 1, 256, fp);
	fclose(fp);

	return;
}

void Die(void)
{
	for (int t = 1; t < 4; t++)
	{
		for (int v = 0; v < 16; v++)
			for (int h = 0; h < 16; h++)
				vga[(h + CapSpace.x) + (v + CapSpace.y) * 320] = CapSpace.Frame[t][h + v * 16];
		delay(60);
	}

}

void DrawShip(void)
{
	for (int v = 0; v < 16; v++)
		for (int h = 0; h < 16; h++)
			vga[(h + CapSpace.x) + (v + CapSpace.y) * 320] = CapSpace.Frame[0][h + v * 16];
}

void EraseShip(void)
{
	for (int v = 0; v < 16; v++)
		for (int h = 0; h < 16; h++)
			vga[(h + CapSpace.x) + (v + CapSpace.y) * 320] = 0;
}

void setmode(int mode)
{
	asm {
		mov ax, mode
		int 10h
	}
	return;
}
