' AITIC - Tic Tac Toe with Artificial Intelligence
'
' Programmed by Dominik Kaspar
'
' PS: If it should happen that you WIN the game with the artificial IQ = 100%
'     then please write me how you managed it, so I can "teach" my program
'     another lesson! e-mail: pedok@pop.agri.ch
'
DECLARE SUB EndScreen ()
DECLARE SUB Logo (XPos!, YPos!, Size!, Text$, Colour!, Frame!)
DECLARE SUB Intro ()
DECLARE SUB AdjustIQ ()
DECLARE SUB NewGame ()
DECLARE SUB ButtonPressed (x!, y!, xx!, yy!, c!)
DECLARE SUB Button (x!, y!, xx!, yy!, c!)
DECLARE SUB CheckGameOver ()
DECLARE SUB CheckMoves ()
DECLARE SUB ComputerMoves ()
DECLARE SUB DetectWorkingDir ()
DECLARE SUB DrawBoard ()
DECLARE SUB FontPrint (XPos!, YPos!, Text$, Colour!)
DECLARE SUB LoadFont ()
DECLARE SUB ReallyQuit ()
DECLARE SUB TestCells (p!, q!)

CONST TRUE = 1
CONST FALSE = 0

DIM SHARED Font AS STRING * 30
DIM SHARED FontChar(0 TO 127, 1 TO 5, 1 TO 6) AS INTEGER
DIM SHARED CurDir$

DIM SHARED G(1 TO 3, 1 TO 3)
DIM SHARED F(1 TO 3, 1 TO 3)

DIM SHARED Moves, IQ
DIM SHARED HWon, CWon
DIM SHARED GameOver AS INTEGER
DIM SHARED PlayedGame

CLS
DetectWorkingDir
'CurDir$ = "C:\QB45\AITIC\"
LoadFont

RANDOMIZE TIMER

SCREEN 7
COLOR 14, 1

Intro

CLS
Logo 20, 25, 2, "AITIC", 14, 14
FontPrint 20, 90, "[C] = Computer", 14
FontPrint 20, 100, "      shall begin!", 14
FontPrint 20, 120, "[N] = New Game", 14
FontPrint 20, 140, "[I] = Change IQ", 14
FontPrint 20, 160, "[ESC] = Quit Game", 14

DrawBoard

NewGame
IQ = 100
PlayedGame = 0

SelX = 1: SelY = 1
x = SelX: y = SelY
LINE (95 + x * 50, -25 + y * 50)-(145 + x * 50, 25 + y * 50), 12, B

DO
WaitForKey:
  Key$ = "": DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)
  SelOldX = SelX
  SelOldY = SelY
  SELECT CASE UCASE$(Key$)
    CASE "N": NewGame
    CASE "I": AdjustIQ
              GOTO WaitForKey
    CASE "C":
         IF Moves = 0 THEN
            ComputerMoves
            Moves = Moves + 1
            FontPrint 20, 90, "[C] = Computer", 8
            FontPrint 20, 100, "      shall begin!", 8
            DrawBoard
         END IF
    CASE CHR$(0) + "H": SelY = SelY - 1
                        IF SelY <= 0 THEN SelY = 3
    CASE CHR$(0) + "K": SelX = SelX - 1
                        IF SelX <= 0 THEN SelX = 3
    CASE CHR$(0) + "M": SelX = SelX + 1
                        IF SelX >= 4 THEN SelX = 1
    CASE CHR$(0) + "P": SelY = SelY + 1
                        IF SelY >= 4 THEN SelY = 1
    CASE CHR$(13): IF GameOver = TRUE THEN GOTO WaitForKey
         IF G(SelX, SelY) = 0 THEN
            x = SelX: y = SelY
            ButtonPressed 95 + x * 50, -25 + y * 50, 145 + x * 50, 25 + y * 50, 7
            t = TIMER: DO: LOOP UNTIL TIMER >= t + .2
            Button 95 + x * 50, -25 + y * 50, 145 + x * 50, 25 + y * 50, 7
            LINE (95 + x * 50, -25 + y * 50)-(145 + x * 50, 25 + y * 50), 12, B
            IF G(SelX, SelY) = 0 THEN
               G(SelX, SelY) = 4
               DrawBoard
               CheckMoves
            ELSE
               GOTO WaitForKey
            END IF
         END IF
    CASE CHR$(27): ReallyQuit
                   GOTO WaitForKey
    CASE ELSE: GOTO WaitForKey
  END SELECT

  x = SelOldX: y = SelOldY
  LINE (95 + x * 50, -25 + y * 50)-(145 + x * 50, 25 + y * 50), 7, B
  x = SelX: y = SelY
  LINE (95 + x * 50, -25 + y * 50)-(145 + x * 50, 25 + y * 50), 12, B
 
IF GameOver = TRUE THEN
   PlayedGame = 1
   FontPrint 20, 120, "[N] = New Game", 12
END IF

LOOP

SUB AdjustIQ
    PCOPY 0, 1
    LINE (60, 64)-(260, 140), 0, BF
    LINE (60, 64)-(260, 140), 7, B
    FontPrint 77, 80, "Change the artificial in-", 14
    FontPrint 77, 90, "telligence with the arrow", 14
    FontPrint 77, 100, "keys. Current IQ =", 14

    DO
      IF IQ > 100 THEN IQ = 100
      IF IQ < 0 THEN IQ = 0
      FontPrint 185, 100, STR$(IQ) + "%  ", 14
      LINE (77, 115)-(243, 125), 7, B
      LINE (78, 116)-(242, 124), 0, BF
      IF IQ > 0 THEN LINE (78, 116)-(78 + 164 / 100 * IQ, 124), 4, BF
     
      Key$ = "": DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)
      SELECT CASE Key$
        CASE CHR$(0) + "H": IQ = IQ + 1
        CASE CHR$(0) + "K": IQ = IQ - 10
        CASE CHR$(0) + "M": IQ = IQ + 10
        CASE CHR$(0) + "P": IQ = IQ - 1
        CASE CHR$(27): PCOPY 1, 0: EXIT SUB
        CASE CHR$(13): PCOPY 1, 0: EXIT SUB
      END SELECT
    LOOP
END SUB

SUB Button (x, y, xx, yy, c)
    LINE (x, y)-(xx - 1, yy - 1), 7, B
    LINE (x + 1, y + 1)-(xx - 1, yy - 1), 8, B
    LINE (x + 1, y + 1)-(xx - 2, yy - 2), 15, B
    LINE (x + 2, y + 2)-(xx - 2, yy - 2), 7, B
    LINE (x + 2, y + 2)-(xx - 3, yy - 3), c, BF
END SUB

SUB ButtonPressed (x, y, xx, yy, c)
    LINE (x, y)-(xx, yy), 0, B
    LINE (x, y)-(xx - 1, yy - 1), 8, B
    LINE (x + 1, y + 1)-(xx - 1, yy - 1), 7, B
    LINE (x + 1, y + 1)-(xx - 2, yy - 2), 7, B
    LINE (x + 2, y + 2)-(xx - 2, yy - 2), 15, B
    LINE (x + 2, y + 2)-(xx - 3, yy - 3), c, BF
END SUB

SUB CheckGameOver

FOR x = 1 TO 3
    IF G(x, 1) + G(x, 2) + G(x, 3) = 12 THEN HWon = TRUE
    IF G(x, 1) + G(x, 2) + G(x, 3) = 3 THEN CWon = TRUE
    IF G(1, x) + G(2, x) + G(3, x) = 12 THEN HWon = TRUE
    IF G(1, x) + G(2, x) + G(3, x) = 3 THEN CWon = TRUE
NEXT x

IF G(1, 1) + G(2, 2) + G(3, 3) = 12 THEN HWon = TRUE
IF G(1, 1) + G(2, 2) + G(3, 3) = 3 THEN CWon = TRUE
IF G(3, 1) + G(2, 2) + G(1, 3) = 12 THEN HWon = TRUE
IF G(3, 1) + G(2, 2) + G(1, 3) = 3 THEN CWon = TRUE

END SUB

SUB CheckMoves

FontPrint 20, 90, "[C] = Computer", 8
FontPrint 20, 100, "      shall begin!", 8

CheckGameOver
IF HWon THEN
   GameOver = TRUE
   FontPrint 20, 60, "YOU WON!", 12
   EXIT SUB
END IF

Moves = Moves + 1
IF Moves >= 9 THEN
   GameOver = TRUE
   FontPrint 20, 60, "A DRAW!", 12
   EXIT SUB
END IF

'Turn of computer:
ComputerMoves
DrawBoard

CheckGameOver
IF CWon THEN
   GameOver = TRUE
   FontPrint 20, 60, "YOU LOST!", 12
   EXIT SUB
END IF

Moves = Moves + 1
IF Moves >= 9 THEN
   GameOver = TRUE
   FontPrint 20, 60, "A DRAW!", 12
   EXIT SUB
END IF

END SUB

SUB ComputerMoves

IF (RND * 100) > IQ THEN GOTO RandomCell

'computer must begin:
IF Moves = 0 THEN
   RANDOMIZE TIMER
   G(INT(RND * 3) + 1, INT(RND * 3) + 1) = 1
   EXIT SUB
END IF

ERASE F

'is computer able to make a line of three?
TestCells 2, 1000

'is human player able to make a line of three?
TestCells 8, 400

'is computer able to complete a "corner" or "line of two"?
TestCells 1, 100

'is human player able to complete a "corner" or "line of two"?
TestCells 4, 40

'take the cell in the center:
IF G(2, 2) = 0 THEN
   F(2, 2) = F(2, 2) + 2
END IF

CellX = 0
CellY = 0
CellPoints = 0
AllEqual = 1: ShouldBe = F(1, 1)
FOR x = 1 TO 3
    FOR y = 1 TO 3
        IF F(x, y) > CellPoints THEN
           CellPoints = F(x, y)
           CellX = x
           CellY = y
        END IF
        IF F(x, y) <> ShouldBe AND G(x, y) = 0 THEN
           AllEqual = 0
        END IF
    NEXT y
NEXT x

'important moves:
IF Moves = 1 AND G(2, 2) = 4 THEN
   RANDOMIZE TIMER
   SELECT CASE INT(RND * 4)
          CASE 0: G(1, 1) = 1
          CASE 1: G(1, 3) = 1
          CASE 2: G(3, 1) = 1
          CASE 3: G(3, 3) = 1
   END SELECT
   EXIT SUB
END IF
IF Moves = 3 AND G(2, 2) = 1 THEN
   IF G(1, 1) = 4 AND G(3, 3) = 4 THEN
      G(2, 1) = 1
      EXIT SUB
   ELSEIF G(3, 1) = 4 AND G(1, 3) = 4 THEN
      G(2, 3) = 1
      EXIT SUB
   END IF
END IF

IF AllEqual = 0 THEN
   IF CellPoints THEN
      G(CellX, CellY) = 1
      EXIT SUB
   END IF
END IF

'if no good cell was found then:
RandomCell:
DO
  RANDOMIZE TIMER
  x = INT(RND * 3) + 1
  y = INT(RND * 3) + 1
LOOP UNTIL G(x, y) = 0
G(x, y) = 1

END SUB

SUB DetectWorkingDir

 CurDir$ = ""

 OPEN "AITIC.FNT" FOR RANDOM AS #1 LEN = LEN(Font)
      IF LOF(1) > 0 THEN
         CLOSE #1
         EXIT SUB
      END IF
 CLOSE #1
 KILL "AITIC.FNT"

 PRINT "Detecting working directory...";

 SHELL "CD\"
 SHELL "DIR AITIC.FNT /S /B > AITIC.TMP"

 OPEN "AITIC.TMP" FOR INPUT AS #1

 IF LOF(1) = 0 THEN
    PRINT : PRINT
    PRINT "ERROR: Could not detect working directory."
    PRINT "       There is a file missing (AITIC.FNT)"
    PRINT
    SYSTEM
 END IF

 LINE INPUT #1, CurDir$
 CurDir$ = RTRIM$(LTRIM$(UCASE$(CurDir$)))

 FOR i = 1 TO LEN(CurDir$)
     IF MID$(CurDir$, i, 11) = "AITIC.FNT" THEN
        CurDir$ = UCASE$(LEFT$(CurDir$, i - 1))
        EXIT FOR
     END IF
 NEXT i
 IF RIGHT$(CurDir$, 1) <> "\" THEN CurDir$ = CurDir$ + "\"

 CLOSE #1
 KILL "AITIC.TMP"

 PRINT "OK."

END SUB

SUB DrawBoard

FOR y = 1 TO 3
    FOR x = 1 TO 3
        x1 = 95 + x * 50
        y1 = -25 + y * 50
        x2 = 145 + x * 50
        y2 = 25 + y * 50
        Button x1, y1, x2, y2, 7
        SELECT CASE G(x, y)
               CASE 1: CIRCLE (x1 + 25, y1 + 25), 15, 10
                       CIRCLE (x1 + 25, y1 + 25), 11, 10
                       PSET (x1 + 25 - 13, y1 + 25), 2
                       DRAW "bd2p2,10"
               CASE 4: PSET (x1 + 23, y1 + 25), 12
                       DRAW "c12h9e3f9e9f3g9f9g3h9g9h3e9br2p4,12"
        END SELECT
    NEXT x
NEXT y
LINE (145, 25)-(295, 175), 7, B

END SUB

SUB EndScreen
  SCREEN 0
  WIDTH 80, 25
  COLOR 14, 1
  CLS
  PRINT : PRINT
  PRINT "  ͻ"
  PRINT "   AITIC - TIC TAC TOE with AI "
  PRINT "  ͼ"
  PRINT : PRINT
  IF PlayedGame THEN
     PRINT "  Thank you for playing this QBasic game!"
  ELSE
     PRINT "  Hey! You didn't even try to play the game!"
  END IF
  PRINT : PRINT
  PRINT "  Dominik Kaspar"
  PRINT "  Ahornweg 15"
  PRINT "  5615 Fahrwangen"
  PRINT "  Switzerland"
  PRINT
  PRINT "  e-mail: pedok@pop.agri.ch"
  PRINT : PRINT
  PRINT "  This program is freeware!"
  PRINT "  So you can do whatever you want with it. You can manipulate and change its"
  PRINT "  source code, delete the whole thing, sell it, improve the graphics of it,"
  PRINT "  eat it, distribute it in public and sacrifice it to any god. You are even"
  PRINT "  allowed to pay for it, but please don't pay more than $1.36."
END SUB

SUB FontPrint (XPos, YPos, Text$, Colour!)

 FOR TextPos = 1 TO LEN(Text$)
     FOR x = 1 TO 5
         FOR y = 1 TO 6
             SELECT CASE FontChar(ASC(MID$(Text$, TextPos, 1)), x, y)
               CASE 0: PSET (XPos + x + TextPos * 6 - 7, YPos + y - 1), 1
               CASE 1: PSET (XPos + x + TextPos * 6 - 7, YPos + y - 1), Colour
             END SELECT
         NEXT y
     NEXT x
 NEXT TextPos

END SUB

SUB Intro
i = 0
FOR x = 20 TO 320 STEP 60
    Button x, 20, x + 40, 60, 7
    Button x, 140, x + 40, 180, 7
    i = i + 1
    Logo x + 10, 28, 4, MID$("AITIC", i, 1), 2, 10
NEXT x

FontPrint 128, 80, "Tic Tac Toe", 14
FontPrint 77, 92, "with artificial intelligence", 14
FontPrint 62, 118, "Programmed 1999 by Dominik Kaspar", 14

t = TIMER
DO
  IF TIMER > t + .5 THEN
    Button x + 20, 140, x + 60, 180, 7
    x = INT(RND * 5) * 60
    SELECT CASE INT(RND * 2)
      CASE 0: CIRCLE (x + 40, 160), 15, 10
              CIRCLE (x + 40, 160), 11, 10
              PSET (x + 27, 160), 2
              DRAW "bd2p2,10"
      CASE 1: PSET (x + 37, 160), 12
              DRAW "c12h9e3f9e9f3g9f9g3h9g9h3e9br2p4,12"
    END SELECT
    t = TIMER
  END IF
LOOP UNTIL LEN(INKEY$)
END SUB

SUB LoadFont

 OPEN CurDir$ + "AITIC.FNT" FOR RANDOM AS #1 LEN = LEN(Font)

 IF LOF(1) = 0 THEN
    PRINT "Fatal Error: Couldn't find file AITIC.FNT"
    DO: LOOP UNTIL LEN(INKEY$)
    CLOSE #1
    KILL "AITIC.FNT"
    END
 END IF

 PRINT "Loading Font...";

 FOR rec = 1 TO 127
     GET #1, rec, Font
     x = 0
     y = 1
     FOR CodePos = 1 TO 30
         IF x = 5 THEN x = 0: y = y + 1
         x = x + 1
         FontChar(rec, x, y) = VAL(MID$(Font, CodePos, 1))
     NEXT CodePos
 NEXT rec

 CLOSE #1

 PRINT "OK."

END SUB

SUB Logo (XPos!, YPos!, Size!, Text$, Colour, Frame)

 FOR TextPos = 1 TO LEN(Text$)
     FOR x = 1 TO 5
         FOR y = 1 TO 6
             SELECT CASE FontChar(ASC(MID$(Text$, TextPos, 1)), x, y)
               CASE 1: x1 = XPos + x * Size + TextPos * 6 * Size - 7 * Size
                       y1 = YPos + y * Size - 1 * Size
                       x2 = XPos + x * Size + TextPos * 6 * Size - 7 * Size + Size
                       y2 = YPos + y * Size - 1 * Size + Size
                       LINE (x1, y1)-(x2, y2), Colour, BF
                       LINE (x1, y1)-(x2, y2), Frame, B
             END SELECT
         NEXT y
     NEXT x
 NEXT TextPos

END SUB

SUB NewGame
    GameOver = FALSE
    HWon = 0: CWon = 0
    Moves = 0
    ERASE G

    FontPrint 20, 90, "[C] = Computer", 14
    FontPrint 20, 100, "      shall begin!", 14
    FontPrint 20, 120, "[N] = New Game", 14
    FontPrint 20, 60, SPACE$(20), 12

    DrawBoard
END SUB

SUB ReallyQuit
    PCOPY 0, 2
    LINE (60, 64)-(260, 140), 0, BF
    LINE (60, 64)-(260, 140), 7, B
    FontPrint 77, 81, "Are you sure that you want", 14
    FontPrint 77, 99, "to leave this wonderful", 14
    FontPrint 77, 117, "game (Y/N)?", 14

    Key$ = "": DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)
    IF UCASE$(Key$) = "Y" THEN
       DO
         x = INT(RND * 320)
         y = INT(RND * 200)
         c = POINT(x, y)
         LINE (x, y)-(x + 1, y + 3), c, BF
       LOOP UNTIL LEN(INKEY$)
       EndScreen
       SYSTEM
    END IF
    PCOPY 2, 0
END SUB

SUB TestCells (p, q)

IF G(1, 1) = 0 THEN
   IF G(1, 2) + G(1, 3) = p THEN F(1, 1) = F(1, 1) + q
   IF G(2, 1) + G(3, 1) = p THEN F(1, 1) = F(1, 1) + q
   IF G(2, 2) + G(3, 3) = p THEN F(1, 1) = F(1, 1) + q
END IF

IF G(1, 2) = 0 THEN
   IF G(1, 1) + G(1, 3) = p THEN F(1, 2) = F(1, 2) + q
   IF G(2, 2) + G(3, 2) = p THEN F(1, 2) = F(1, 2) + q
END IF

IF G(1, 3) = 0 THEN
   IF G(1, 1) + G(1, 2) = p THEN F(1, 3) = F(1, 3) + q
   IF G(3, 1) + G(2, 2) = p THEN F(1, 3) = F(1, 3) + q
   IF G(2, 3) + G(3, 3) = p THEN F(1, 3) = F(1, 3) + q
END IF

IF G(2, 1) = 0 THEN
   IF G(1, 1) + G(3, 1) = p THEN F(2, 1) = F(2, 1) + q
   IF G(2, 2) + G(2, 3) = p THEN F(2, 1) = F(2, 1) + q
END IF
 
IF G(2, 2) = 0 THEN
   IF G(1, 1) + G(3, 3) = p THEN F(2, 2) = F(2, 2) + q
   IF G(3, 1) + G(1, 3) = p THEN F(2, 2) = F(2, 2) + q
   IF G(2, 1) + G(2, 3) = p THEN F(2, 2) = F(2, 2) + q
   IF G(1, 2) + G(3, 2) = p THEN F(2, 2) = F(2, 2) + q
END IF
  
IF G(2, 3) = 0 THEN
   IF G(2, 1) + G(2, 2) = p THEN F(2, 3) = F(2, 3) + q
   IF G(1, 3) + G(3, 3) = p THEN F(2, 3) = F(2, 3) + q
END IF
  
IF G(3, 1) = 0 THEN
   IF G(1, 1) + G(2, 1) = p THEN F(3, 1) = F(3, 1) + q
   IF G(1, 3) + G(2, 2) = p THEN F(3, 1) = F(3, 1) + q
   IF G(3, 2) + G(3, 3) = p THEN F(3, 1) = F(3, 1) + q
END IF
                                           
IF G(3, 2) = 0 THEN
   IF G(3, 1) + G(3, 3) = p THEN F(3, 2) = F(3, 2) + q
   IF G(1, 2) + G(2, 2) = p THEN F(3, 2) = F(3, 2) + q
END IF
 
IF G(3, 3) = 0 THEN
   IF G(3, 1) + G(3, 2) = p THEN F(3, 3) = F(3, 3) + q
   IF G(1, 1) + G(2, 2) = p THEN F(3, 3) = F(3, 3) + q
   IF G(1, 3) + G(2, 3) = p THEN F(3, 3) = F(3, 3) + q
END IF
 
END SUB

