DECLARE SUB LoadGame ()
DECLARE SUB SaveGame ()
DECLARE SUB Pause ()
DECLARE SUB CheckRows (Player%)
DECLARE SUB Rotate (Player%)
DECLARE SUB NextBlock (Player%)
DECLARE SUB MoveBlock (XMove%, YMove%, Player%)
DECLARE SUB RemoveBlock (Player%)
DECLARE SUB PutBlock (Player%)
DECLARE SUB LoadConfig ()
DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE SUB NextMidi ()
DECLARE SUB LoadMIDI (FileName$, MIDISegment%, MIDIOffset%)
DECLARE SUB HighScores ()
DECLARE SUB PalGet (Col%, R%, G%, B%)
DECLARE SUB PalSet (Col%, R%, G%, B%)
DECLARE SUB FadePal ()
DECLARE SUB DrawScreen ()
DECLARE SUB PlayMIDI (MIDISegment%, MIDIOffset%)
DECLARE SUB PlayGame ()
DECLARE SUB Again ()
DECLARE SUB CheckHighScore ()
DECLARE FUNCTION BytesRequired& (FileName$)
DECLARE SUB InputName ()
DECLARE SUB SaveHighScores ()
DECLARE SUB Ending ()
DECLARE SUB DisplayNextBlock ()
DECLARE SUB DrawBlock (C%, X1%, Y1%)
DECLARE SUB InternalGetIntVector (IntNum%, segment%, offset%)
DECLARE SUB StopMidi ()
DECLARE FUNCTION InternalBitRead% (Variable%, BitNum%)
DECLARE FUNCTION InternalReadMixer% (Index%)
DECLARE FUNCTION MIDIError$ ()
DECLARE SUB PauseMidi ()
DECLARE SUB ResumeMidi ()
DECLARE FUNCTION TimeMidi! ()

'$DYNAMIC
'$INCLUDE: 'future.bi'
DEFINT A-Z
DIM SHARED MIDI.PLAYTIME AS SINGLE, Midi.Error
DIM SHARED MIDI.Loaded, SBMIDI.INTERRUPT
DIM SHARED SBSIM.INTERRUPT, PAUSED AS SINGLE
DIM SHARED SENSITIVE, Sound.Disabled
DIM SHARED BIT.STORAGE(0 TO 7)

DIM SHARED Block(2), X(2), Y(2), Tim(2) AS SINGLE, Delay(2) AS SINGLE, OldDelay(2) AS SINGLE
DIM SHARED Rows, Blocks, BlockNext, Name$
DIM SHARED Song, SongName$, SongTime AS SINGLE
DIM SHARED BasePort, LenPort, Channel
DIM SHARED Level, StartAgain, FX, Sounds, NotFirstTime

CLS
LoadConfig
Level = 1
a$ = "Starting Tetris version 2.0 (2 players version)"
B$ = "By Future Software"
a$ = a$ + SPACE$(80 - LEN(a$) - LEN(B$)) + B$
COLOR 15, 4: PRINT a$: COLOR 7, 0
PRINT "Loading game..."
IF Sounds = 1 THEN
	PRINT "Checking midi drivers...";
	DriversLoaded SBMIDI, SBSIM
	IF SBMIDI = 0 THEN PRINT "Not found! Please be sure to run SBMIDI.EXE from DOS first!": END
	IF SBSIM = 0 THEN PRINT "Not found! Please be sure to run SBSIM.COM from DOS first!": END
	IF SBMIDI.INTERRUPT = 0 THEN SBMIDI.INTERRUPT = &H80
	IF SBSIM.INTERRUPT = 0 THEN SBSIM.INTERRUPT = &H81
	PRINT "Available!"
	PRINT "Loading midi file...";
		NextMidi
		DIM Midi%(BytesRequired&(SongName$) \ 2)
		LoadMIDI SongName$, VARSEG(Midi%(0)), VARPTR(Midi%(0))
	PRINT "Done!"
END IF
Tim(1) = TIMER: DO: LOOP UNTIL TIMER >= Tim(1) + 1

StartGame:
FOR I = 0 TO 63
	WAIT &H3DA, 8, 8: WAIT &H3DA, 8
	FOR ii = 0 TO 63
		PalGet ii, R, G, B
		IF R > 0 THEN R = R - 1
		IF G > 0 THEN G = G - 1
		IF B > 0 THEN B = B - 1
		PalSet ii, R, G, B
	NEXT ii
NEXT I
ClearKeyBuffer

'ON ERROR GOTO FileNotFound
SCREEN 13: FadePal
Palette.FadeOut
DrawScreen
IF Sounds = 1 THEN PlayMIDI VARSEG(Midi%(0)), VARPTR(Midi%(0))
LoadWAV "fs.wav", 11025
Tim2! = TIMER: DO: LOOP UNTIL TIMER >= Tim2! + 1.5
LoadWAV "bp.wav", 11025

NextBlock 1
NextBlock 2
Tim(1) = TIMER: Delay(1) = 1.5: Tim(2) = TIMER: Delay(2) = 1.5: NotFirstTime = 1
IF INSTR(LCASE$(COMMAND$), "loadgame") THEN LoadGame
Palette.FadeIn
PlayGame

NoSave:
PlayGame
RESUME

FileNotFound:
CLS : PALETTE: SCREEN 0: COLOR 15: LOCATE 1, 1: PRINT "An error has happened. Press any key to end..."
DO: LOOP WHILE INKEY$ = ""
END

REM $STATIC
SUB Again
'Palette.FadeOut
'CLS
'FadePal
X1 = 105: X2 = 242: Y1 = 105: Y2 = 135
LINE (X1 - 9, Y1 - 9)-(X2 + 9, Y2 + 9), 56, B
LINE (X1 - 8, Y1 - 8)-(X2 + 8, Y2 + 8), 55, B
LINE (X1 - 7, Y1 - 7)-(X2 + 7, Y2 + 7), 54, B
LINE (X1 - 6, Y1 - 6)-(X2 + 6, Y2 + 6), 53, B
LINE (X1 - 5, Y1 - 5)-(X2 + 5, Y2 + 5), 52, B
LINE (X1 - 4, Y1 - 4)-(X2 + 4, Y2 + 4), 51, B
LINE (X1 - 3, Y1 - 3)-(X2 + 3, Y2 + 3), 50, B
LINE (X1 - 2, Y1 - 2)-(X2 + 2, Y2 + 2), 49, B
LINE (X1 - 1, Y1 - 1)-(X2 + 1, Y2 + 1), 48, B
LINE (X1, Y1)-(X2, Y2), 47, B
LINE (X1, Y1)-(X2, Y2), 0, BF
LOCATE 15, 15: COLOR 56: PRINT "  Play again?   "
LOCATE 16, 15:           PRINT "      (Y/N)     "
ClearKeyBuffer
DO
Key$ = INKEY$
IF Key$ <> "" THEN
	IF LCASE$(Key$) = "y" THEN StopMidi: EXIT DO ELSE Ending: END
END IF
LOOP

Level = 1: Rows = 0
SCREEN 13: Palette.FadeOut
DrawScreen
IF Sounds = 1 THEN
	NextMidi
	DIM Midi%(BytesRequired&(SongName$) \ 2)
	LoadMIDI SongName$, VARSEG(Midi%(0)), VARPTR(Midi%(0))
	PlayMIDI VARSEG(Midi%(0)), VARPTR(Midi%(0))
END IF
NotFirstTime = 0
NextBlock 1
NextBlock 2
NotFirstTime = 1
Palette.FadeIn
Tim(1) = TIMER: Delay(1) = 1.5: Tim(2) = TIMER: Delay(2) = 1.5
PlayGame
END SUB

FUNCTION BytesRequired& (FileName$)
FF% = FREEFILE
OPEN FileName$ FOR BINARY AS #FF%
	FileLen& = LOF(FF%)
CLOSE FF%
IF FileLen& = 0 THEN KILL FileName$: Midi.Error = 1: EXIT FUNCTION
BytesRequired& = FileLen&
Midi.Error = 0
END FUNCTION

SUB CheckRows (Player)
DIM MoveRow(751), Temp2(12000)
IF Player = 1 THEN
	FOR Y1 = 185 TO 15 STEP -10
		FOR X1 = 15 TO 145 STEP 10
			a = POINT(X1, Y1)
			IF a = 0 THEN GOTO NoRows
		NEXT X1
		RemoveBlock 1
		GET (10, Y1 - 5)-(149, Y1 + 4), MoveRow
		PutBlock 1
		IF Z = 1 THEN
			RemoveBlock 2
			GET (170, 20)-(309, 189), Temp2
			LINE (170, 10)-(309, 189), 0, BF
			PUT (170, 10), Temp2, PSET
			PUT (170, 180), MoveRow, PSET
			IF Y(2) > 10 THEN Y(2) = Y(2) - 10
			PutBlock 2
		ELSE
			Z = 1
		END IF
		WAIT &H3DA, 8, 8: WAIT &H3DA, 8
		RowType = RowType + 1: Rows = Rows + 1
NoRows:
	NEXT Y1
       
	FOR Y1 = 185 TO 15 STEP -10
CheckAgain1:
		FOR X1 = 15 TO 145 STEP 10
			a = POINT(X1, Y1)
			IF a = 0 THEN GOTO NoRows1
		NEXT X1
		LINE (10, Y1 - 5)-(149, Y1 + 4), 0, BF
		FOR a = Y1 - 10 TO 15 STEP -10
			GET (10, a - 5)-(149, a + 4), MoveRow
			LINE (10, a - 5)-(149, a + 4), 0, BF
			PUT (10, a + 5), MoveRow, PSET
		NEXT
		GOTO CheckAgain1
NoRows1:
	NEXT Y1
ELSE
	FOR Y1 = 185 TO 15 STEP -10
		FOR X1 = 175 TO 305 STEP 10
			a = POINT(X1, Y1)
			IF a = 0 THEN GOTO NoRows2
		NEXT X1
		RemoveBlock 2
		GET (170, Y1 - 5)-(309, Y1 + 4), MoveRow
		PutBlock 2
		IF Z = 1 THEN
			RemoveBlock 1
			GET (10, 20)-(149, 189), Temp2
			LINE (10, 10)-(149, 189), 0, BF
			PUT (10, 10), Temp2, PSET
			PUT (10, 180), MoveRow, PSET
			IF Y(1) > 10 THEN Y(1) = Y(1) - 10
			PutBlock 1
		ELSE
			Z = 1
		END IF
		WAIT &H3DA, 8, 8: WAIT &H3DA, 8
		RowType = RowType + 1: Rows = Rows + 1
NoRows2:
	NEXT Y1
      
	FOR Y1 = 185 TO 15 STEP -10
CheckAgain2:
		FOR X1 = 175 TO 305 STEP 10
			a = POINT(X1, Y1)
			IF a = 0 THEN GOTO NoRows3
		NEXT X1
		LINE (170, Y1 - 5)-(309, Y1 + 4), 0, BF
		FOR a = Y1 - 10 TO 15 STEP -10
			GET (170, a - 5)-(309, a + 4), MoveRow
			LINE (170, a - 5)-(309, a + 4), 0, BF
			PUT (170, a + 5), MoveRow, PSET
		NEXT
		GOTO CheckAgain2
NoRows3:
	NEXT Y1
END IF

SELECT CASE RowType
CASE 1: LoadWAV "single.wav", 11025
CASE 2: LoadWAV "double.wav", 11025
CASE 3: LoadWAV "triple.wav", 11025
CASE 4: LoadWAV "tetriss.wav", 11025
END SELECT
IF Rows >= 15 THEN
	Level = Level + 1: Rows = 0
	SELECT CASE Level
	CASE 1: Delay(1) = 1.5: Delay(2) = Delay(1)
	CASE 2: Delay(1) = 1.4: Delay(2) = Delay(1)
	CASE 3: Delay(1) = 1.3: Delay(2) = Delay(1)
	CASE 4: Delay(1) = 1.2: Delay(2) = Delay(1)
	CASE 5: Delay(1) = 1.1: Delay(2) = Delay(1)
	CASE 6: Delay(1) = 1: Delay(2) = Delay(1)
	CASE 7: Delay(1) = .9: Delay(2) = Delay(1)
	CASE 8: Delay(1) = .8: Delay(2) = Delay(1)
	CASE 9: Delay(1) = .7: Delay(2) = Delay(1)
	CASE 10: Delay(1) = .6: Delay(2) = Delay(1)
	CASE 11: Delay(1) = .5: Delay(2) = Delay(1)
	CASE 12: Delay(1) = .4: Delay(2) = Delay(1)
	CASE 13: Delay(1) = .3: Delay(2) = Delay(1)
	CASE 14: Delay(1) = .2: Delay(2) = Delay(1)
	CASE 15: Delay(1) = .1: Delay(2) = Delay(1)
	CASE 16: Delay(1) = 0: Delay(2) = Delay(1)
	END SELECT
END IF
END SUB

SUB DrawBlock (C, XZ, YZ)
LINE (XZ, YZ)-(XZ + 9, YZ + 9), C, BF: LINE (XZ + 1, YZ)-(XZ + 1, YZ + 8), C - 9
LINE (XZ + 2, YZ)-(XZ + 2, YZ + 8), C - 8: LINE (XZ + 3, YZ)-(XZ + 3, YZ + 8), C - 6
LINE (XZ + 4, YZ)-(XZ + 4, YZ + 8), C - 5: LINE (XZ + 5, YZ)-(XZ + 5, YZ + 8), C - 4
LINE (XZ + 6, YZ)-(XZ + 6, YZ + 8), C - 3: LINE (XZ + 7, YZ)-(XZ + 7, YZ + 8), C - 2
LINE (XZ + 8, YZ)-(XZ + 8, YZ + 8), C - 1: LINE (XZ + 9, YZ)-(XZ + 9, YZ + 8), C
LINE (XZ, YZ)-(XZ, YZ + 9), C + 2: LINE (XZ, YZ)-(XZ + 9, YZ), C + 2
END SUB

SUB DrawScreen
LINE (0, 0)-(320, 200), 56, BF
LINE (10, 10)-(149, 189), 0, BF
LINE (170, 10)-(309, 190), 0, BF

X1 = 10: X2 = 149: Y1 = 11: Y2 = 189
LINE (X1 - 9, Y1 - 9)-(X2 + 9, Y2 + 9), 56, B
LINE (X1 - 8, Y1 - 8)-(X2 + 8, Y2 + 8), 55, B
LINE (X1 - 7, Y1 - 7)-(X2 + 7, Y2 + 7), 54, B
LINE (X1 - 6, Y1 - 6)-(X2 + 6, Y2 + 6), 53, B
LINE (X1 - 5, Y1 - 5)-(X2 + 5, Y2 + 5), 52, B
LINE (X1 - 4, Y1 - 4)-(X2 + 4, Y2 + 4), 51, B
LINE (X1 - 3, Y1 - 3)-(X2 + 3, Y2 + 3), 50, B
LINE (X1 - 2, Y1 - 2)-(X2 + 2, Y2 + 2), 49, B
LINE (X1 - 1, Y1 - 1)-(X2 + 1, Y2 + 1), 48, B
LINE (X1, Y1)-(X2, Y2), 47, B

X1 = 170: X2 = 309: Y1 = 11: Y2 = 190
LINE (X1 - 9, Y1 - 9)-(X2 + 9, Y2 + 9), 56, B
LINE (X1 - 8, Y1 - 8)-(X2 + 8, Y2 + 8), 55, B
LINE (X1 - 7, Y1 - 7)-(X2 + 7, Y2 + 7), 54, B
LINE (X1 - 6, Y1 - 6)-(X2 + 6, Y2 + 6), 53, B
LINE (X1 - 5, Y1 - 5)-(X2 + 5, Y2 + 5), 52, B
LINE (X1 - 4, Y1 - 4)-(X2 + 4, Y2 + 4), 51, B
LINE (X1 - 3, Y1 - 3)-(X2 + 3, Y2 + 3), 50, B
LINE (X1 - 2, Y1 - 2)-(X2 + 2, Y2 + 2), 49, B
LINE (X1 - 1, Y1 - 1)-(X2 + 1, Y2 + 1), 48, B
LINE (X1, Y1)-(X2, Y2), 47, B
END SUB

SUB DriversLoaded (SBMIDI%, SBSIM%) STATIC
FF% = FREEFILE
OPEN "DRIVERS.DAT" FOR BINARY AS #FF%
	FileSize& = LOF(FF%)
	IF FileSize& = 0 THEN
		CLOSE FF%: KILL "DRIVERS.DAT": Midi.Error = 1: EXIT SUB
	ELSEIF FileSize& <> 1024 THEN
		CLOSE FF%: Midi.Error = 9: EXIT SUB
	END IF
	REDIM DRIVERDATA$(1 TO 5)
	FOR I% = 1 TO 4
		DRIVERDATA$(I%) = INPUT$(256, #FF%)
	NEXT I%
CLOSE #FF%

SBMIDI% = 0: SBSIM% = 0
FOR I% = &H80 TO &HE1
	InternalGetIntVector I%, segment%, offset%
	IF segment% = 0 AND offset% = 0 THEN GOTO Skip:
	IF SBMIDI% = 0 THEN
		NewSegment% = CVI(MKI$(CVL(MKI$(segment%) + CHR$(0) + CHR$(0)) - &H11&))
		DEF SEG = NewSegment%
		Temp$ = ""
		FOR J% = 1 TO 6
			Temp$ = Temp$ + CHR$(PEEK(271 + J%))
		NEXT
		IF Temp$ = "SBMIDI" THEN SBMIDI% = I%
	END IF
	IF SBSIM% = 0 THEN
		NewSegment% = CVI(MKI$(CVL(MKI$(segment%) + CHR$(0) + CHR$(0)) - &H1&))
		DEF SEG = NewSegment%
		Temp$ = ""
		FOR J% = 1 TO 5
			Temp$ = Temp$ + CHR$(PEEK(274 + J%))
		NEXT
		IF Temp$ = "SBSIM" THEN SBSIM% = I%
	END IF
   
	DEF SEG = segment%
	DRIVERDATA$(5) = ""
	FOR J% = 0 TO 255
		byte% = PEEK(offset% + J%)
		DRIVERDATA$(5) = DRIVERDATA$(5) + CHR$(byte%)
	NEXT J%
	FOR J% = 1 TO 4
		MATCH% = 1
		FOR K% = 0 TO 255
			IF MID$(DRIVERDATA$(J%), K% + 1, 1) <> MID$(DRIVERDATA$(5), K% + 1, 1) THEN
			SELECT CASE K%
			CASE IS = 14, 15, 113, 114, 235, 236:
			CASE ELSE: MATCH% = 0: EXIT FOR
			END SELECT
			END IF
		NEXT K%
		IF MATCH% THEN
			IF J% = 1 THEN SBSIM% = I%
			IF J% <> 1 THEN SBMIDI% = I%
		END IF
		IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	NEXT J%
	IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
Skip:
NEXT I%
Midi.Error = 0
END SUB

SUB Ending
Palette.FadeOut
CLS : SCREEN 0: WIDTH 80, 25: StopMidi
END SUB

SUB FadePal
FOR I = 5 TO 75 STEP 5: m = m + 1: PalSet m, I, I, I: NEXT
FOR I = 5 TO 75 STEP 5: m = m + 1: PalSet m, I, 0, 0: NEXT
FOR I = 5 TO 75 STEP 5: m = m + 1: PalSet m, 0, I, 0: NEXT
FOR I = 5 TO 75 STEP 5: m = m + 1: PalSet m, 0, 0, I: NEXT
FOR I = 5 TO 75 STEP 5: m = m + 1: PalSet m, I, I, 0: NEXT
FOR I = 5 TO 75 STEP 5: m = m + 1: PalSet m, 0, I, I: NEXT
FOR I = 5 TO 75 STEP 5: m = m + 1: PalSet m, I, 0, I: NEXT
PalSet 200, 60, 60, 60
END SUB

FUNCTION InternalBitRead% (Variable%, BitNum%)
VarSegment% = VARSEG(Variable%)
offset% = VARPTR(Variable%)
DEF SEG = VarSegment%
InternalBitRead% = -((PEEK(offset% + BitNum% \ 8) AND 2 ^ (BitNum% MOD 8)) > 0)
DEF SEG
END FUNCTION

SUB InternalBitSet (Variable%, BitNum%, OnOff%)
VarSegment% = VARSEG(Variable%)
offset% = VARPTR(Variable%)
DEF SEG = VarSegment%
IF OnOff% THEN
    POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) OR 2 ^ (BitNum% MOD 8)
ELSE
    POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) AND 255 - 2 ^ (BitNum% MOD 8)
END IF
DEF SEG
END SUB

SUB InternalBitToggle (Variable%, BitNum%)
VarSegment% = VARSEG(Variable%)
offset% = VARPTR(Variable%)
DEF SEG = VarSegment%
POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) XOR 2 ^ (BitNum% MOD 8)
DEF SEG
END SUB

SUB InternalGetIntVector (IntNum%, segment%, offset%) STATIC
IF GetIntVCodeLoaded% = 0 THEN
    asm$ = asm$ + CHR$(&H55)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
    asm$ = asm$ + CHR$(&H8A) + CHR$(&H7)
    asm$ = asm$ + CHR$(&HB4) + CHR$(&H35)
    asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
    asm$ = asm$ + CHR$(&H8C) + CHR$(&HC1)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HDA)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HF)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
    asm$ = asm$ + CHR$(&H89) + CHR$(&H17)
    asm$ = asm$ + CHR$(&H5D)
    asm$ = asm$ + CHR$(&HCB)
    asm$ = asm$ + CHR$(&H34) + CHR$(&H0)
    asm$ = asm$ + CHR$(&H60)
    asm$ = asm$ + CHR$(&H23) + CHR$(&H0)
    GetIntVCodeLoaded% = 1
END IF
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(IntNum%, segment%, offset%, SADD(asm$))
END SUB

FUNCTION InternalReadMixer% (Index%)
OUT SB.BASEPORT + 4, Index%
InternalReadMixer% = INP(SB.BASEPORT + 5)
END FUNCTION

SUB InternalWriteMixer (Index%, Value%)
OUT SB.BASEPORT + 4, Index%
OUT SB.BASEPORT + 5, Value%
END SUB

SUB LoadConfig
OPEN "tetris.ini" FOR INPUT AS #1
INPUT #1, Sounds
INPUT #1, FX
CLOSE
END SUB

SUB LoadGame
ON ERROR GOTO NoSave
CLOSE
OPEN "save2.dat" FOR INPUT AS #1
INPUT #1, Level
INPUT #1, X(1)
INPUT #1, Y(1)
INPUT #1, Block(1)
INPUT #1, Block(1)
INPUT #1, Delay(1)
INPUT #1, X(2)
INPUT #1, Y(2)
INPUT #1, Block(2)
INPUT #1, Block(2)
INPUT #1, Delay(2)
CLOSE
LoadScreen "save2.scr"
ON ERROR GOTO FileNotFound
END SUB

SUB LoadMIDI (FileName$, MIDISegment%, MIDIOffset%) STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN Midi.Error = 4: EXIT SUB
IF INSTR(FileName$, ".") = 0 THEN FileName$ = FileName$ + ".MID"
FF% = FREEFILE
OPEN FileName$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
IF FileLen& = 0 THEN KILL FileName$: Midi.Error = 1: EXIT SUB
IF FileLen& > 65536 THEN Midi.Error = 2: EXIT SUB
FileName$ = FileName$ + CHR$(0)
IF ask$ = "" THEN
	asm$ = asm$ + CHR$(&H1E)
	asm$ = asm$ + CHR$(&H55)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
	asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H3D)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)
	asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HC6)
	asm$ = asm$ + CHR$(&HB4) + CHR$(&H3F)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&HF)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)
	asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HF3)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
	asm$ = asm$ + CHR$(&HB4) + CHR$(&H3E)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
	asm$ = asm$ + CHR$(&H5D)
	asm$ = asm$ + CHR$(&H1F)
	asm$ = asm$ + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)
END IF
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(VARSEG(FileName$), SADD(FileName$), MIDISegment%, MIDIOffset%, &HFFFF, SADD(asm$))
Midi.Error = 0
END SUB

FUNCTION MIDIError$
SELECT CASE Midi.Error
	CASE 0: MIDIError$ = "No error"
	CASE 1: MIDIError$ = "File contains no data"
	CASE 2: MIDIError$ = "File is too large"
	CASE 3: MIDIError$ = "No midi file playing"
	CASE 4: MIDIError$ = "Invalid SBMIDI interrupt"
	CASE 5: MIDIError$ = "Invalid SBSIM interrupt"
	CASE 6: MIDIError$ = "No mixer chip"
	CASE 7: MIDIError$ = "Could not detect sound card"
	CASE 8: MIDIError$ = "Feature unavailable"
	CASE 9: MIDIError$ = "File is corrupt"
	CASE 10: MIDIError$ = "Invalid sound card type"
	CASE ELSE: MIDIError$ = "Unknown error"
END SELECT
END FUNCTION

SUB MoveBlock (XMove, YMove, Player)
IF XMove = -1 THEN
	'Left
	SELECT CASE Block(Player)
	CASE 1: IF POINT(X(Player) - 5, Y(Player) + 5) <> 0 THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 15) THEN EXIT SUB
	CASE 2: IF POINT(X(Player) + 5, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 15) THEN EXIT SUB
	CASE 3: IF POINT(X(Player) + 5, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 5, Y(Player) + 25) THEN EXIT SUB
	CASE 4: IF POINT(X(Player) - 5, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 5, Y(Player) + 25) THEN EXIT SUB
	CASE 5: IF POINT(X(Player) + 5, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 5, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 5, Y(Player) + 25) THEN EXIT SUB
	CASE 6: IF POINT(X(Player) - 5, Y(Player) + 15) THEN EXIT SUB
	CASE 7: IF POINT(X(Player) + 5, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 5, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 5, Y(Player) + 25) THEN EXIT SUB
		IF POINT(X(Player) + 5, Y(Player) + 25) THEN EXIT SUB
	CASE 8: IF POINT(X(Player) + 5, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 25) THEN EXIT SUB
	CASE 9: IF POINT(X(Player) - 5, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 5, Y(Player) + 15) THEN EXIT SUB
	CASE 10: IF POINT(X(Player) - 5, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 5, Y(Player) + 25) THEN EXIT SUB
	CASE 11: IF POINT(X(Player) + 5, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 15) THEN EXIT SUB
	CASE 12: IF POINT(X(Player) - 5, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 15) THEN EXIT SUB
	CASE 13: IF POINT(X(Player) - 5, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 25) THEN EXIT SUB
	CASE 14: IF POINT(X(Player) + 15, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 25) THEN EXIT SUB
	CASE 15: IF POINT(X(Player) + 5, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 25) THEN EXIT SUB
	CASE 16: IF POINT(X(Player) + 5, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 5, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 25) THEN EXIT SUB
	CASE 17: IF POINT(X(Player) - 5, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 25) THEN EXIT SUB
	CASE 18: IF POINT(X(Player) - 5, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 25) THEN EXIT SUB
	CASE 19: IF POINT(X(Player) - 5, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) - 5, Y(Player) + 25) THEN EXIT SUB
	END SELECT
	RemoveBlock Player
	X(Player) = X(Player) - 10
	PutBlock Player
	EXIT SUB
END IF
IF XMove = 1 THEN
	'Right
	SELECT CASE Block(Player)
	CASE 1: IF POINT(X(Player) + 25, Y(Player) + 5) <> 0 THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 15) THEN EXIT SUB
	CASE 2: IF POINT(X(Player) + 25, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 35, Y(Player) + 15) THEN EXIT SUB
	CASE 3: IF POINT(X(Player) + 25, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 25) THEN EXIT SUB
	CASE 4: IF POINT(X(Player) + 35, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 25) THEN EXIT SUB
	CASE 5: IF POINT(X(Player) + 25, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 35, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 25) THEN EXIT SUB
	CASE 6: IF POINT(X(Player) + 45, Y(Player) + 15) THEN EXIT SUB
	CASE 7: IF POINT(X(Player) + 25, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 25) THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 35) THEN EXIT SUB
	CASE 8: IF POINT(X(Player) + 25, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 25) THEN EXIT SUB
	CASE 9: IF POINT(X(Player) + 25, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 35, Y(Player) + 15) THEN EXIT SUB
	CASE 10: IF POINT(X(Player) + 15, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 25) THEN EXIT SUB
	CASE 11: IF POINT(X(Player) + 35, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 15) THEN EXIT SUB
	CASE 12: IF POINT(X(Player) + 35, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 15) THEN EXIT SUB
	CASE 13: IF POINT(X(Player) + 15, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 25) THEN EXIT SUB
	CASE 14: IF POINT(X(Player) + 35, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 35, Y(Player) + 25) THEN EXIT SUB
	CASE 15: IF POINT(X(Player) + 35, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 35, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 35, Y(Player) + 25) THEN EXIT SUB
	CASE 16: IF POINT(X(Player) + 25, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 25) THEN EXIT SUB
	CASE 17: IF POINT(X(Player) + 35, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 35, Y(Player) + 25) THEN EXIT SUB
	CASE 18: IF POINT(X(Player) + 25, Y(Player) + 5) THEN EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 25) THEN EXIT SUB
	CASE 19: IF POINT(X(Player) + 15, Y(Player) + 15) THEN EXIT SUB
		IF POINT(X(Player) + 35, Y(Player) + 25) THEN EXIT SUB
	END SELECT
	RemoveBlock Player
	X(Player) = X(Player) + 10
	PutBlock Player
	EXIT SUB
END IF
CheckDown:
IF YMove = 1 THEN
	'Down
	SELECT CASE Block(Player)
	CASE 1: IF POINT(X(Player) + 5, Y(Player) + 25) <> 0 THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
	CASE 2: IF POINT(X(Player) + 5, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
	CASE 3: IF POINT(X(Player) + 5, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
	CASE 4: IF POINT(X(Player) + 5, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
	CASE 5: IF POINT(X(Player) + 15, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
	CASE 6: IF POINT(X(Player) + 5, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 35, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
	CASE 7: IF POINT(X(Player) + 15, Y(Player) + 45) THEN NextBlock Player: EXIT SUB
	CASE 8: IF POINT(X(Player) + 5, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
	CASE 9: IF POINT(X(Player) + 5, Y(Player) + 15) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
	CASE 10: IF POINT(X(Player) + 5, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
	CASE 11: IF POINT(X(Player) + 5, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 15) THEN NextBlock Player: EXIT SUB
	CASE 12: IF POINT(X(Player) + 5, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 15) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 15) THEN NextBlock Player: EXIT SUB
	CASE 13: IF POINT(X(Player) + 5, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
	CASE 14: IF POINT(X(Player) + 5, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
	CASE 15: IF POINT(X(Player) + 15, Y(Player) + 15) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
	CASE 16: IF POINT(X(Player) + 5, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
	CASE 17: IF POINT(X(Player) + 5, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 25) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
	CASE 18: IF POINT(X(Player) + 5, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 15) THEN NextBlock Player: EXIT SUB
	CASE 19: IF POINT(X(Player) + 5, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 15, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
		IF POINT(X(Player) + 25, Y(Player) + 35) THEN NextBlock Player: EXIT SUB
	END SELECT
	RemoveBlock Player
	Y(Player) = Y(Player) + 10
	PutBlock Player
	Tim(Player) = TIMER
	EXIT SUB
END IF
END SUB

SUB NextBlock (Player)
IF NotFirstTime = 1 THEN
	IF FX = 1 THEN LoadWAV "drop.wav", 11025
	CheckRows Player
END IF
IF BlockNext <> 0 THEN
	Block(Player) = BlockNext
ELSE
	RANDOMIZE TIMER
	Block(Player) = RND * 6 + 1
	SELECT CASE Block(Player)
	CASE 2: Block(Player) = RND * 3 + 2
	CASE 3: Block(Player) = RND * 1 + 6
	CASE 4: Block(Player) = RND * 1 + 8
	CASE 5: Block(Player) = RND * 1 + 10
	CASE 6: Block(Player) = RND * 3 + 12
	CASE 7: Block(Player) = RND * 3 + 16
	END SELECT
END IF
IF Player = 1 THEN
	FOR X1 = 75 TO 105
	IF POINT(X1, 15) THEN
		LoadGif "player1.gif": ClearKeyBuffer: DO: LOOP WHILE INKEY$ = "": Again: Ending: END
	END IF
	NEXT
ELSE
	FOR X1 = 235 TO 265
	IF POINT(X1, 15) THEN
		LoadGif "player2.gif": ClearKeyBuffer: DO: LOOP WHILE INKEY$ = "": Again: Ending: END
	END IF
	NEXT
END IF

IF Player = 1 THEN X(1) = 70 ELSE X(2) = 230
Y(Player) = 10

RANDOMIZE TIMER
BlockNext = RND * 6 + 1
SELECT CASE BlockNext
CASE 2: BlockNext = RND * 3 + 2
CASE 3: BlockNext = RND * 1 + 6
CASE 4: BlockNext = RND * 1 + 8
CASE 5: BlockNext = RND * 1 + 10
CASE 6: BlockNext = RND * 3 + 12
CASE 7: BlockNext = RND * 3 + 16
END SELECT
PutBlock Player
IF Delay(Player) = .001 THEN Delay(Player) = OldDelay(Player)
Tim(Player) = TIMER
END SUB

SUB NextMidi
IF Song = 0 THEN RANDOMIZE TIMER: Song = RND * 8
Song = Song + 1: IF Song = 9 THEN Song = 1
SELECT CASE Song
CASE 1: SongTime = TIMER + 139
CASE 2: SongTime = TIMER + 128
CASE 3: SongTime = TIMER + 130
CASE 4: SongTime = TIMER + 141
CASE 5: SongTime = TIMER + 149
CASE 6: SongTime = TIMER + 145
CASE 7: SongTime = TIMER + 127
CASE 8: SongTime = TIMER + 123
CASE 9: SongTime = TIMER + 149
END SELECT
SongName$ = LTRIM$(STR$(Song) + ".mid")
END SUB

SUB PalGet (Col, R, G, B)
OUT &H3C7, Col: R = INP(&H3C9): G = INP(&H3C9): B = INP(&H3C9)
END SUB

SUB PalSet (Col, R, G, B)
OUT &H3C8, Col: OUT &H3C9, R: OUT &H3C9, G: OUT &H3C9, B
END SUB

SUB Pause
DIM Temp(1500)
Tim2! = TIMER - Tim(1)
Tim3! = TIMER - Tim(2)
IF Sounds = 1 THEN PauseMidi
GET (130, 85)-(190, 115), Temp
LINE (130, 90)-(190, 110), 0, BF

X1 = 140: X2 = 180: Y1 = 95: Y2 = 105
LINE (X1 - 9, Y1 - 9)-(X2 + 9, Y2 + 9), 56, B
LINE (X1 - 8, Y1 - 8)-(X2 + 8, Y2 + 8), 55, B
LINE (X1 - 7, Y1 - 7)-(X2 + 7, Y2 + 7), 54, B
LINE (X1 - 6, Y1 - 6)-(X2 + 6, Y2 + 6), 53, B
LINE (X1 - 5, Y1 - 5)-(X2 + 5, Y2 + 5), 52, B
LINE (X1 - 4, Y1 - 4)-(X2 + 4, Y2 + 4), 51, B
LINE (X1 - 3, Y1 - 3)-(X2 + 3, Y2 + 3), 50, B
LINE (X1 - 2, Y1 - 2)-(X2 + 2, Y2 + 2), 49, B
LINE (X1 - 1, Y1 - 1)-(X2 + 1, Y2 + 1), 48, B
LINE (X1, Y1)-(X2, Y2), 47, B

Font 140, 96, "Pause", 10
DO: LOOP UNTIL INKEY$ <> ""
PUT (130, 85), Temp, PSET
Tim(1) = TIMER - Tim2!
Tim(2) = TIMER - Tim3!
IF Sounds = 1 THEN ResumeMidi
END SUB

SUB PauseMidi STATIC
IF SBSIM.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN Midi.Error = 5: EXIT SUB
IF MIDI.PLAYTIME = 0 THEN
    Midi.Error = 3
    EXIT SUB
END IF
IF asm$ = "" THEN
	asm$ = asm$ + CHR$(&HBB) + CHR$(&H3) + CHR$(&H5)
	asm$ = asm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
	asm$ = asm$ + CHR$(&HCB)
END IF
DEF SEG = VARSEG(asm$)
offset% = SADD(asm$)
CALL ABSOLUTE(offset%)
PAUSED = TimeMidi!
IF PAUSED = 0! THEN PAUSED = .00001
MIDI.PLAYTIME = 0
Midi.Error = 0
END SUB

SUB PlayGame
Start:
DO
	IF TIMER >= Tim(1) + Delay(1) THEN MoveBlock 0, 1, 1: Tim(1) = TIMER
	IF TIMER >= Tim(2) + Delay(2) THEN MoveBlock 0, 1, 2: Tim(2) = TIMER
	a$ = INKEY$: IF a$ <> "" THEN K = ASC(RIGHT$(a$, 1))
	SELECT CASE K
	CASE ASC("S"), ASC("s"): MoveBlock -1, 0, 1
	CASE ASC("D"), ASC("d"): MoveBlock 0, 1, 1
	CASE ASC("F"), ASC("f"): MoveBlock 1, 0, 1
	CASE ASC("E"), ASC("e"): Rotate 1
	CASE ASC("Z"), ASC("z"): IF Delay(1) = .001 THEN GOTO Start
				OldDelay(1) = Delay(1): Delay(1) = .001
	CASE 27: Again: END
	CASE 32: IF Delay(2) = .001 THEN GOTO Start
		OldDelay(2) = Delay(2): Delay(2) = .001
	CASE 59: SaveGame
	CASE 72: Rotate 2
	CASE 75: MoveBlock -1, 0, 2
	CASE 77: MoveBlock 1, 0, 2
	CASE 80: MoveBlock 0, 1, 2
	CASE 112: Pause
	END SELECT
	K = 0
	IF TIMER >= SongTime AND NoSound = 0 THEN
		NextMidi
		REDIM Midi%(BytesRequired&(SongName$) \ 2)
		LoadMIDI SongName$, VARSEG(Midi%(0)), VARPTR(Midi%(0))
		PlayMIDI VARSEG(Midi%(0)), VARPTR(Midi%(0))
	END IF
	IF Midi.Error <> 0 THEN
		a$ = MIDIError$
		CLS : SCREEN 0: WIDTH 80, 25: PALETTE
		LOCATE 1, 1: PRINT "An error has happened: "; a$
		PRINT : PRINT "Press any key to continue..."
		DO: LOOP WHILE INKEY$ = ""
		END
	END IF
LOOP
END SUB

DEFSNG A-Z
'PlayMIDI - Begins playing a MIDI file in the background.
SUB PlayMIDI (MIDISegment%, MIDIOffset%) STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN Midi.Error = 4: EXIT SUB
'Check to see if the MIDI playing code has previously been loaded.
'If not, load it now.
IF asm$ = "" THEN
	'Load the machine codes into a string.
	asm$ = asm$ + CHR$(&H55)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H7)
	asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
	asm$ = asm$ + CHR$(&HBB) + CHR$(&H5) + CHR$(&H0)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
	asm$ = asm$ + CHR$(&H5D)
	asm$ = asm$ + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)
END IF
IF Sound.Disabled = 0 THEN
    'Call the machine language routine to play the music.
    DEF SEG = VARSEG(asm$)
    offset% = SADD(asm$)
    CALL ABSOLUTE(MIDISegment%, MIDIOffset%, offset%)
    'Start the MIDI timer.
    MIDI.PLAYTIME = TIMER
END IF
END SUB

DEFINT A-Z
SUB PutBlock (Player)
SELECT CASE Block(Player)
CASE 1: DrawBlock 55, X(Player), Y(Player): DrawBlock 55, X(Player) + 10, Y(Player)
	DrawBlock 55, X(Player), Y(Player) + 10: DrawBlock 55, X(Player) + 10, Y(Player) + 10
CASE 2: DrawBlock 40, X(Player) + 10, Y(Player): DrawBlock 40, X(Player), Y(Player) + 10
	DrawBlock 40, X(Player) + 10, Y(Player) + 10: DrawBlock 40, X(Player) + 20, Y(Player) + 10
CASE 3: DrawBlock 40, X(Player) + 10, Y(Player): DrawBlock 40, X(Player) + 10, Y(Player) + 10
	DrawBlock 40, X(Player), Y(Player) + 10: DrawBlock 40, X(Player) + 10, Y(Player) + 20
CASE 4: DrawBlock 40, X(Player), Y(Player) + 10: DrawBlock 40, X(Player) + 10, Y(Player) + 10
	DrawBlock 40, X(Player) + 20, Y(Player) + 10: DrawBlock 40, X(Player) + 10, Y(Player) + 20
CASE 5: DrawBlock 40, X(Player) + 10, Y(Player): DrawBlock 40, X(Player) + 10, Y(Player) + 10
	DrawBlock 40, X(Player) + 20, Y(Player) + 10: DrawBlock 40, X(Player) + 10, Y(Player) + 20
CASE 6: DrawBlock 25, X(Player), Y(Player) + 10: DrawBlock 25, X(Player) + 10, Y(Player) + 10
	DrawBlock 25, X(Player) + 20, Y(Player) + 10: DrawBlock 25, X(Player) + 30, Y(Player) + 10
CASE 7: DrawBlock 25, X(Player) + 10, Y(Player): DrawBlock 25, X(Player) + 10, Y(Player) + 10
	DrawBlock 25, X(Player) + 10, Y(Player) + 20: DrawBlock 25, X(Player) + 10, Y(Player) + 30
CASE 8: DrawBlock 10, X(Player) + 10, Y(Player): DrawBlock 10, X(Player), Y(Player) + 10
	DrawBlock 10, X(Player) + 10, Y(Player) + 10: DrawBlock 10, X(Player), Y(Player) + 20
CASE 9: DrawBlock 10, X(Player), Y(Player): DrawBlock 10, X(Player) + 10, Y(Player)
	DrawBlock 10, X(Player) + 10, Y(Player) + 10: DrawBlock 10, X(Player) + 20, Y(Player) + 10
CASE 10: DrawBlock 100, X(Player), Y(Player): DrawBlock 100, X(Player), Y(Player) + 10
	DrawBlock 100, X(Player) + 10, Y(Player) + 10: DrawBlock 100, X(Player) + 10, Y(Player) + 20
CASE 11: DrawBlock 100, X(Player) + 10, Y(Player): DrawBlock 100, X(Player) + 20, Y(Player)
	DrawBlock 100, X(Player) + 10, Y(Player) + 10: DrawBlock 100, X(Player), Y(Player) + 10
CASE 12: DrawBlock 70, X(Player), Y(Player): DrawBlock 70, X(Player) + 10, Y(Player)
	DrawBlock 70, X(Player) + 20, Y(Player): DrawBlock 70, X(Player), Y(Player) + 10
CASE 13: DrawBlock 70, X(Player), Y(Player): DrawBlock 70, X(Player), Y(Player) + 10
	DrawBlock 70, X(Player), Y(Player) + 20: DrawBlock 70, X(Player) + 10, Y(Player) + 20
CASE 14: DrawBlock 70, X(Player) + 20, Y(Player) + 10: DrawBlock 70, X(Player) + 20, Y(Player) + 20
	DrawBlock 70, X(Player) + 10, Y(Player) + 20: DrawBlock 70, X(Player), Y(Player) + 20
CASE 15: DrawBlock 70, X(Player) + 10, Y(Player): DrawBlock 70, X(Player) + 20, Y(Player)
	DrawBlock 70, X(Player) + 20, Y(Player) + 10: DrawBlock 70, X(Player) + 20, Y(Player) + 20
CASE 16: DrawBlock 85, X(Player) + 10, Y(Player): DrawBlock 85, X(Player) + 10, Y(Player) + 10
	DrawBlock 85, X(Player) + 10, Y(Player) + 20: DrawBlock 85, X(Player), Y(Player) + 20
CASE 17: DrawBlock 85, X(Player), Y(Player) + 10: DrawBlock 85, X(Player) + 10, Y(Player) + 10
	DrawBlock 85, X(Player) + 20, Y(Player) + 10: DrawBlock 85, X(Player) + 20, Y(Player) + 20
CASE 18: DrawBlock 85, X(Player), Y(Player): DrawBlock 85, X(Player) + 10, Y(Player)
	DrawBlock 85, X(Player), Y(Player) + 10: DrawBlock 85, X(Player), Y(Player) + 20
CASE 19: DrawBlock 85, X(Player), Y(Player) + 10: DrawBlock 85, X(Player), Y(Player) + 20
	DrawBlock 85, X(Player) + 10, Y(Player) + 20: DrawBlock 85, X(Player) + 20, Y(Player) + 20
END SELECT
END SUB

SUB RemoveBlock (Player)
SELECT CASE Block(Player)
CASE 1: LINE (X(Player), Y(Player))-(X(Player) + 19, Y(Player) + 19), 0, BF
CASE 2: LINE (X(Player), Y(Player) + 10)-(X(Player) + 29, Y(Player) + 19), 0, BF
	LINE (X(Player) + 10, Y(Player))-(X(Player) + 19, Y(Player) + 9), 0, BF
CASE 3: LINE (X(Player) + 10, Y(Player))-(X(Player) + 19, Y(Player) + 29), 0, BF
	LINE (X(Player), Y(Player) + 10)-(X(Player) + 9, Y(Player) + 19), 0, BF
CASE 4: LINE (X(Player), Y(Player) + 10)-(X(Player) + 29, Y(Player) + 19), 0, BF
	LINE (X(Player) + 10, Y(Player) + 20)-(X(Player) + 19, Y(Player) + 29), 0, BF
CASE 5: LINE (X(Player) + 10, Y(Player))-(X(Player) + 19, Y(Player) + 29), 0, BF
	LINE (X(Player) + 20, Y(Player) + 10)-(X(Player) + 29, Y(Player) + 19), 0, BF
CASE 6: LINE (X(Player), Y(Player) + 10)-(X(Player) + 39, Y(Player) + 19), 0, BF
CASE 7: LINE (X(Player) + 10, Y(Player))-(X(Player) + 19, Y(Player) + 39), 0, BF
CASE 8: LINE (X(Player), Y(Player) + 10)-(X(Player) + 9, Y(Player) + 29), 0, BF
	LINE (X(Player) + 10, Y(Player))-(X(Player) + 19, Y(Player) + 19), 0, BF
CASE 9: LINE (X(Player), Y(Player))-(X(Player) + 19, Y(Player) + 9), 0, BF
	LINE (X(Player) + 10, Y(Player) + 10)-(X(Player) + 29, Y(Player) + 19), 0, BF
CASE 10: LINE (X(Player), Y(Player))-(X(Player) + 9, Y(Player) + 19), 0, BF
	LINE (X(Player) + 10, Y(Player) + 10)-(X(Player) + 19, Y(Player) + 29), 0, BF
CASE 11: LINE (X(Player), Y(Player) + 10)-(X(Player) + 19, Y(Player) + 19), 0, BF
	LINE (X(Player) + 10, Y(Player))-(X(Player) + 29, Y(Player) + 9), 0, BF
CASE 12: LINE (X(Player), Y(Player))-(X(Player) + 29, Y(Player) + 9), 0, BF
	LINE (X(Player), Y(Player) + 10)-(X(Player) + 9, Y(Player) + 19), 0, BF
CASE 13: LINE (X(Player), Y(Player))-(X(Player) + 9, Y(Player) + 29), 0, BF
	LINE (X(Player) + 10, Y(Player) + 20)-(X(Player) + 19, Y(Player) + 29), 0, BF
CASE 14: LINE (X(Player), Y(Player) + 20)-(X(Player) + 29, Y(Player) + 29), 0, BF
	LINE (X(Player) + 20, Y(Player) + 10)-(X(Player) + 29, Y(Player) + 19), 0, BF
CASE 15: LINE (X(Player) + 10, Y(Player))-(X(Player) + 19, Y(Player) + 9), 0, BF
	LINE (X(Player) + 20, Y(Player))-(X(Player) + 29, Y(Player) + 29), 0, BF
CASE 16: LINE (X(Player) + 10, Y(Player))-(X(Player) + 19, Y(Player) + 29), 0, BF
	LINE (X(Player), Y(Player) + 20)-(X(Player) + 9, Y(Player) + 29), 0, BF
CASE 17: LINE (X(Player), Y(Player) + 10)-(X(Player) + 29, Y(Player) + 19), 0, BF
	LINE (X(Player) + 20, Y(Player) + 20)-(X(Player) + 29, Y(Player) + 29), 0, BF
CASE 18: LINE (X(Player), Y(Player))-(X(Player) + 9, Y(Player) + 29), 0, BF
	LINE (X(Player) + 10, Y(Player))-(X(Player) + 19, Y(Player) + 9), 0, BF
CASE 19: LINE (X(Player), Y(Player) + 10)-(X(Player) + 9, Y(Player) + 19), 0, BF
	LINE (X(Player), Y(Player) + 20)-(X(Player) + 29, Y(Player) + 29), 0, BF
END SELECT
WAIT &H3DA, 8, 8: WAIT &H3DA, 8
END SUB

SUB ResumeMidi
IF SBSIM.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN Midi.Error = 5: EXIT SUB
IF PAUSED = 0! THEN EXIT SUB
IF asm$ = "" THEN
	asm$ = ""
	asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H5)
	asm$ = asm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
	asm$ = asm$ + CHR$(&HCB)
END IF
DEF SEG = VARSEG(asm$)
offset% = SADD(asm$)
CALL ABSOLUTE(offset%)
MIDI.PLAYTIME = TIMER - PAUSED
PAUSED = 0!
Midi.Error = 0
END SUB

SUB Rotate (Player)
SELECT CASE Block(Player)
CASE 1: EXIT SUB
CASE 2: IF POINT(X(Player) + 15, Y(Player) + 25) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 3: PutBlock Player
CASE 3: IF POINT(X(Player) + 25, Y(Player) + 15) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 4: PutBlock Player
CASE 4: IF POINT(X(Player) + 15, Y(Player) + 5) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 5: PutBlock Player
CASE 5: IF POINT(X(Player) + 5, Y(Player) + 15) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 2: PutBlock Player
CASE 6: IF POINT(X(Player) + 15, Y(Player) + 5) THEN EXIT SUB
	IF POINT(X(Player) + 15, Y(Player) + 25) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 7: PutBlock Player
CASE 7: IF POINT(X(Player) + 5, Y(Player) + 15) THEN EXIT SUB
	IF POINT(X(Player) + 25, Y(Player) + 15) THEN EXIT SUB
	IF POINT(X(Player) + 35, Y(Player) + 15) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 6: PutBlock Player
CASE 8: IF POINT(X(Player) + 5, Y(Player) + 5) THEN EXIT SUB
	IF POINT(X(Player) + 25, Y(Player) + 15) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 9: PutBlock Player
CASE 9: IF POINT(X(Player) + 5, Y(Player) + 15) THEN EXIT SUB
	IF POINT(X(Player) + 5, Y(Player) + 25) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 8: PutBlock Player
CASE 10: IF POINT(X(Player) + 15, Y(Player) + 5) THEN EXIT SUB
	IF POINT(X(Player) + 25, Y(Player) + 5) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 11: PutBlock Player
CASE 11: IF POINT(X(Player) + 5, Y(Player) + 5) THEN EXIT SUB
	IF POINT(X(Player) + 15, Y(Player) + 25) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 10: PutBlock Player
CASE 12: IF POINT(X(Player) + 5, Y(Player) + 25) THEN EXIT SUB
	IF POINT(X(Player) + 15, Y(Player) + 25) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 13: PutBlock Player
CASE 13: IF POINT(X(Player) + 25, Y(Player) + 15) THEN EXIT SUB
	IF POINT(X(Player) + 25, Y(Player) + 25) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 14: PutBlock Player
CASE 14: IF POINT(X(Player) + 15, Y(Player) + 5) THEN EXIT SUB
	IF POINT(X(Player) + 15, Y(Player) + 15) THEN EXIT SUB
	IF POINT(X(Player) + 25, Y(Player) + 5) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 15: PutBlock Player
CASE 15: IF POINT(X(Player) + 5, Y(Player) + 5) THEN EXIT SUB
	IF POINT(X(Player) + 5, Y(Player) + 15) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 12: PutBlock Player
CASE 16: IF POINT(X(Player) + 5, Y(Player) + 15) THEN EXIT SUB
	IF POINT(X(Player) + 25, Y(Player) + 15) THEN EXIT SUB
	IF POINT(X(Player) + 25, Y(Player) + 25) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 17: PutBlock Player
CASE 17: IF POINT(X(Player) + 5, Y(Player) + 5) THEN EXIT SUB
	IF POINT(X(Player) + 15, Y(Player) + 5) THEN EXIT SUB
	IF POINT(X(Player) + 5, Y(Player) + 25) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 18: PutBlock Player
CASE 18: IF POINT(X(Player) + 15, Y(Player) + 25) THEN EXIT SUB
	IF POINT(X(Player) + 25, Y(Player) + 25) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 19: PutBlock Player
CASE 19: IF POINT(X(Player) + 15, Y(Player) + 5) THEN EXIT SUB
	IF POINT(X(Player) + 15, Y(Player) + 15) THEN EXIT SUB
	RemoveBlock Player
	Block(Player) = 16: PutBlock Player
END SELECT
END SUB

SUB SaveGame
CLOSE
OPEN "save2.dat" FOR OUTPUT AS #1
PRINT #1, Level
PRINT #1, X(1)
PRINT #1, Y(1)
PRINT #1, Block(1)
PRINT #1, Block(1)
PRINT #1, Delay(1)
PRINT #1, X(2)
PRINT #1, Y(2)
PRINT #1, Block(2)
PRINT #1, Block(2)
PRINT #1, Delay(2)
CLOSE
SaveScreen "save2.scr"
IF FX = 1 THEN LoadWAV "saved.wav", 11025
END SUB

SUB StopMidi STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN Midi.Error = 4: EXIT SUB
'Stop the music!!
IF asm$ = "" THEN
    asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
    asm$ = asm$ + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT)
    asm$ = asm$ + CHR$(&HCB)
END IF
IF MIDI.PLAYTIME THEN
    DEF SEG = VARSEG(asm$)
    offset% = SADD(asm$)
    CALL ABSOLUTE(offset%)
    Midi.Error = 0
ELSE
    Midi.Error = 3
END IF
'No MIDI file is playing, so reset the timer
MIDI.PLAYTIME = 0
END SUB

FUNCTION TimeMidi!
IF PAUSED > 0! THEN
    TimeMidi! = PAUSED
    Midi.Error = 0
ELSEIF MIDI.PLAYTIME THEN
    CurrentTime! = TIMER
    IF CurrentTime! - MIDI.PLAYTIME < 0 THEN CurrentTime! = 86400 + CurrentTime!
    TimeMidi! = CurrentTime! - MIDI.PLAYTIME
    Midi.Error = 0
ELSE
    Midi.Error = 3
END IF
END FUNCTION

