'  4/4/98
'
'    TF Checkers
'      By: TF Software
'        Copyright 1998, TF Software
'
'  This source code may be modified and changed for personal use. It may NOT
' be sold or modified and then distributed. If you send it to anyone it must
' be sent to them as the original .ZIP file which you recieved it in, with
' no files missing, no extra files, and no change in the current files.
'
'   Note: You need QuickBASIC 4.5 to run this source code.
'
' Email: TFSoft@aol.com
' Web Site: http://www.geocities.com/SiliconValley/Lakes/5357/
'
'  Scroll down until you see a line like this:
'  CHDIR "" '============================================
'  Then enter in the path of this program.
'
'-----Declares-----
DECLARE SUB LastGameScreen ()
DECLARE SUB HoldOn (HowLong#)
DECLARE SUB PlayFile (WavFileName$)
DECLARE SUB GameScreen ()
DECLARE SUB DMAPlay (Segment&, Offset&, Length&, Freq&)
DECLARE SUB MasterVolume (Right%, Left%, Getvol%)
DECLARE SUB SpeakerState (OnOff%)
DECLARE SUB DoAIStuff (WhatX%, WhatY%, WhatToMove%)
DECLARE SUB IntroScreen (ThePicArray() AS LONG)
DECLARE SUB FontCenter (FCX%, FCY%, FCText$, FCChar() AS SINGLE, FcMask() AS SINGLE)
DECLARE SUB ShowGameStuff ()
DECLARE SUB FontMove (MoveText$, HomeX%, HomeY%, EndX%, EndY%, TransX%, TransY%, TheCharArray() AS SINGLE, TheMaskArray() AS SINGLE)
DECLARE SUB DisplayInfo ()
DECLARE SUB InitButtons ()
DECLARE SUB RotateColor ()
DECLARE SUB MainScreen ()
DECLARE SUB AnimateRed (AnimationNumber%, AnimationIndex%)
DECLARE SUB Font (FontX%, FontY%, FontText$, TheCharArray() AS SINGLE, TheMaskArray() AS SINGLE, FontMask%)
DECLARE SUB LoadFont (FontFile$, TheCharArray() AS SINGLE, TheMaskArray() AS SINGLE)
DECLARE SUB DeHighLite (DHNum%)
DECLARE SUB MoveChecker (ChkrNum%)
DECLARE SUB DrawMoves ()
DECLARE SUB EraseBoard ()
DECLARE SUB DetectPossibleChecks (DetectWhat%, DetectNum%)
DECLARE SUB DrawMouse ()
DECLARE SUB PutClip (putx%, puty%, spritewidth%, spriteheight%, thesprite(), spriteoffset%, maskoffset%, masked%, putscreen%)
DECLARE SUB InitBoard ()
DECLARE SUB DrawBoard ()
DECLARE SUB Load2 (This$, ThePic() AS LONG)
DECLARE SUB LoadPalette (PalName$)
DECLARE SUB GetPalette (PalName$)
DECLARE SUB SetColor (COL%, RV%, GV%, BV%)
DECLARE SUB MouseStatus (Lb%, Rb%, xMouse%, yMouse%, div%)
DECLARE SUB MouseRange (X1%, Y1%, X2%, Y2%)
DECLARE SUB MousePut (X%, Y%)
DECLARE SUB MouseHide ()
DECLARE SUB MouseDriver (ax%, bx%, cx%, dx%)
DECLARE SUB MouseShow ()
DECLARE FUNCTION TimConvert$ (TimVal#)
DECLARE FUNCTION DMADone% ()
DECLARE FUNCTION FileLength& (WavFileName$)
DECLARE FUNCTION GetBLASTER% (DMA%, BasePort%, IRQ%)
DECLARE FUNCTION FontLen% (FontString$, TheCharArray() AS SINGLE)
DECLARE FUNCTION DetectRedJumps% (DetectWhat%, DetectNum%)
DECLARE FUNCTION DetectBlkJumps% (DetectWhat%, DetectNum%)
DECLARE FUNCTION DetectBlkMoves% (DetectWhat%, DetectNum%)
DECLARE FUNCTION DetectRedMoves% (DetectWhat%, DetectNum%)
DECLARE FUNCTION DetectClick% (BrdXLoc%, BrdYLoc%, ChkNum%)
DECLARE FUNCTION MouseInit% ()
'-----End Declares-----
'-----Types-----
 TYPE PalType
 PRed AS INTEGER: PGreen AS INTEGER: PBlue AS INTEGER
 END TYPE
   TYPE BoardType
   CType AS INTEGER
   END TYPE
     TYPE CheckerType
     BdX AS INTEGER
     BdY AS INTEGER
     ChkX AS INTEGER
     ChkY AS INTEGER
     ChkType AS INTEGER
     Alive AS INTEGER
     ChkNum AS INTEGER
     END TYPE
       TYPE PlayerType
       PlyrName AS STRING * 10
       Human AS INTEGER
       Turn AS INTEGER
       PlayTimBuf AS DOUBLE
       PlayTim AS DOUBLE
       Diff AS INTEGER
       Wins AS INTEGER
       END TYPE
 TYPE AnimationType
 AnmX AS INTEGER
 AnmY AS INTEGER
 END TYPE
   TYPE ButtonType
   BtX1 AS INTEGER
   BtY1 AS INTEGER
   BtX2 AS INTEGER
   BtY2 AS INTEGER
   END TYPE
'-----End Types-----
'-----Commons-----
COMMON SHARED CheckArray() AS SINGLE, BlkChk() AS CheckerType, RedChk() AS CheckerType
COMMON SHARED BoardX() AS INTEGER, BoardY() AS INTEGER, Board() AS BoardType
COMMON SHARED PossChecks() AS CheckerType, Player() AS PlayerType, PossPoints() AS INTEGER
COMMON SHARED GameState%
COMMON SHARED NumberOfMoves%, NumberOfJumps%
COMMON SHARED StartX%, StartY%, DestX%, DestY%
COMMON SHARED Add() AS AnimationType, ShAdd() AS AnimationType
COMMON SHARED CVal%, CValRot%, CTimer#
COMMON SHARED MyFont() AS SINGLE, MyMask() AS SINGLE
COMMON SHARED MainB() AS ButtonType, SetB() AS ButtonType, OptB() AS ButtonType
COMMON SHARED TempMain$()
COMMON SHARED AnimateFlag%, ShowMoveFlag%, NumOfGames%, TheGameNumber%, PlaySndFlag%
COMMON SHARED BasePort%, LenPort%, Channel%, IRQ%, HaveBlast%
COMMON SHARED TFWav() AS STRING * 32767
COMMON SHARED SoundEvent%
'-----End Commons-----
'$DYNAMIC
'-----Dims-----
DIM SHARED TFWav(1) AS STRING * 32767
DIM SHARED OptB(16) AS ButtonType
DIM SHARED SetB(12) AS ButtonType
DIM SHARED MainB(30) AS ButtonType
DIM SHARED TempMain$(6)
DIM SHARED MyFont(2450) AS SINGLE
DIM SHARED MyMask(2450) AS SINGLE
DIM SHARED ShAdd(120) AS AnimationType
DIM SHARED Add(120) AS AnimationType
DIM SHARED Pal(16) AS PalType
DIM SHARED BoardX(8, 8) AS INTEGER
DIM SHARED BoardY(8, 8) AS INTEGER
DIM SHARED Board(8, 8) AS BoardType
DIM SHARED BlkChk(12) AS CheckerType
DIM SHARED RedChk(12) AS CheckerType
DIM SHARED CheckArray(1172) AS SINGLE
DIM SHARED Cursor(19) AS SINGLE
DIM SHARED PutArray(201) AS SINGLE
DIM SHARED PossChecks(12) AS CheckerType
DIM SHARED PossPoints(12) AS INTEGER
DIM SHARED Player(2) AS PlayerType
'-----End Dims-----
'-----Constants-----
CONST CheckX% = -13, CheckY% = -12
CONST ShadowX% = -12, ShadowY% = -6
CONST KingX% = -13, KingY% = -17
CONST FlatX% = -13, FlatY% = -7
CONST CShadow% = 0
CONST RFlat% = 40, RKingH% = 101, RKing% = 202, RCheck% = 303, RCheckH% = 384
CONST BFlat% = 465, BKingH% = 526, BKing% = 627, BCheck% = 728, BCheckH% = 809
CONST MCheck% = 890, MKing% = 971, MFlat% = 1072, MShadow% = 1133
CONST KingWidth% = 25, KingHeight% = 25
CONST CheckWidth% = 25, CheckHeight% = 20
CONST FlatWidth% = 25, FlatHeight% = 15
CONST ShadowWidth% = 23, ShadowHeight% = 13
'-----End Constants-----
ON ERROR GOTO ErrorHandler
'-----Directory-----
 'CHDIR ""    '================================================================
 'Example: CHDIR "c:\games\checkers"
'-----End Directory-----
'-----Mouse-----
 DEF SEG = &HA000:
 DIM SHARED Mouse$: Mouse$ = SPACE$(57)
   FOR I% = 1 TO 57:  READ a$:  H$ = CHR$(VAL("&H" + a$))
   MID$(Mouse$, I%, 1) = H$: NEXT I%
  DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
  DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
  DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
  DATA 8B,5E,06,89,17,5D,CA,08,00
 RESTORE
ms% = MouseInit%
IF NOT ms% THEN PRINT "No mouse or non-compatible mouse detected.": END
'-----End Mouse-----
'-----Init Board coordinates-----
SqWidth% = (320 / 8) - 1
SqWidth% = SqWidth% - (SqWidth% / 2)
SqHeight% = (200 / 8)
XDef% = 8
 FOR BrdY% = 1 TO 8
  FOR BrdX% = 1 TO 8
   BoardX(BrdX%, BrdY%) = SqWidth% * XDef%
   XDef% = XDef% + 1
  NEXT
  XDef% = XDef% - 9
 NEXT
YDef% = 1
 FOR BrdX% = 1 TO 8
  FOR BrdY% = 1 TO 8
   BoardY(BrdX%, BrdY%) = (SqHeight% / 2) * YDef%
   YDef% = YDef% + 1
  NEXT
  YDef% = YDef% - 7
 NEXT
'-----End init board coordinates-----
'-----Font-----
LoadFont "tfsing.tff", MyFont(), MyMask()
MyFont(4) = 0  'Sets space between letters to 0
'-----End font-----
'-----Load Board Pic and Palette & Intro Screen stuff-----
  LoadPalette "checkbd.pal"
  DIM SHARED ThePic(8000) AS LONG
  SCREEN 7, 0, 1, 0: CLS
   Load2 "checkbd.drw", ThePic()
   PUT (0, 0), ThePic(0), PSET
    Load2 "tf.drw", ThePic()
     IntroScreen ThePic()
      ERASE ThePic
'-----End Load Board Pic and Palette & Intro Screen stuff-----
'-----Load Checker Graphics-----
DEF SEG = VARSEG(CheckArray(0))
BLOAD "chcksing.dat", VARPTR(CheckArray(0))
DEF SEG
'-----End Load Checker Graphics-----
'-----Other Initiations-----
RANDOMIZE TIMER
KEY(1) ON
ON KEY(1) GOSUB GetOut
'-----Make cursor-----
SCREEN 7, 0, 2, 0
LINE (0, 0)-(9, 9), 0, BF
LINE (0, 4)-(8, 4), 7
LINE (4, 0)-(4, 8), 7
PSET (4, 4), 0
GET (0, 0)-(8, 8), Cursor(0)
'-----End Make Cursor-----
'-----Animation-----
DEF SEG = VARSEG(Add(1).AnmX)
 BLOAD "tfcheck.anm", VARPTR(Add(1).AnmX)
DEF SEG
 DEF SEG = VARSEG(ShAdd(1).AnmX)
  BLOAD "tfcheck2.anm", VARPTR(ShAdd(1).AnmX)
 DEF SEG
'-----End Animation-----
'-----Sound-----
HaveB% = 0
 OPEN "setup.dat" FOR INPUT AS #1
 INPUT #1, HaveB%
 CLOSE #1
  IF HaveB% THEN
   HaveBlast% = GetBLASTER(Channel%, BasePort%, IRQ%)' Parses BLASTER environment
   IF HaveBlast% THEN PlaySndFlag% = 1 ELSE PlaySndFlag% = 0
    ResetIt% = ResetDSP%
    SpeakerState 1 'turn the speaker on
    MasterVolume 15, 15, 0 'this cranks the master volume all the way up.
  ELSE
   HaveBlast% = 0
  END IF
'-----End Sound-----
'-----Data-----
Player(1).PlyrName = "Player 1"
Player(2).PlyrName = "Player 2"
 InitButtons
GameState% = 4
Player(1).Turn = 1
Player(2).Turn = 0
 FOR P% = 1 TO 2
  Player(P%).Human = 1
  Player(P%).Diff = 2
 NEXT
AnimateFlag% = 1
ShowMoveFlag% = 1
NumOfGames% = 1
CValRot% = 4: CVal% = 4: CTimer# = TIMER
'-----End Data-----
'-----End Other Initiations-----

StartOfItAll:
 Player(1).Wins = 0
 Player(2).Wins = 0
  MainScreen
  TheGameNumber% = 1

NextGame:
  GameState% = 4
 SCREEN 7, 0, 2, 0: CLS
 SCREEN 7, 0, 3, 0: CLS
  ShowGameStuff
 SCREEN 7, 0, 2, 0
  EraseBoard
  InitBoard
  DrawBoard
 SCREEN 7, 0, 3, 0
  SetColor 3, 0, 0, 0
      
Player(1).PlayTim = 0
Player(2).PlayTim = 0
Player(1).PlayTimBuf = TIMER
Player(2).PlayTimBuf = TIMER
UpTim1# = TIMER
'-----Start of game Loop-----
DO
 PCOPY 2, 3
  MouseStatus Lb%, Rb%, mx%, my%, 2
  Key$ = INKEY$
  DrawMouse
  SELECT CASE GameState% '-----Game States-----
   CASE 4
    DetectPossibleChecks 1, 0
    IF NumberOfMoves% = 0 THEN EXIT DO
    SCREEN 7, 0, 2, 0: EraseBoard: DrawBoard: SCREEN 7, 0, 3, 0
    DisplayInfo
     IF Player(1).Human = 0 AND Player(1).Turn <> 0 OR Player(2).Human = 0 AND Player(2).Turn <> 0 THEN
      GameState% = 6: DoAIStuff BrdX%, BrdY%, DetectNum%
      StartX% = BrdX%: StartY% = BrdY%
     ELSE
      GameState% = GameState% + 1
     END IF
   CASE 5
     ChkClk% = DetectClick(BrdX%, BrdY%, DetectNum%)
     IF ChkClk% = 1 THEN GameState% = GameState% + 1: StartX% = BrdX%: StartY% = BrdY%
   CASE 6
     MoveNum% = DetectNum%
     DetectPossibleChecks 2, DetectNum%
      SCREEN 7, 0, 2, 0: EraseBoard
       DrawBoard
       DisplayInfo
       SCREEN 7, 0, 2, 0
       PCOPY 2, 3: PCOPY 3, 0
        IF ShowMoveFlag% THEN
         DrawMoves
        ELSE
         IF Player(1).Turn THEN SetColor 3, 0, 0, 63
         IF Player(2).Turn THEN SetColor 3, 63, 63, 0
        END IF
      SCREEN 7, 0, 3, 0
     IF Player(1).Human = 0 AND Player(1).Turn <> 0 OR Player(2).Human = 0 AND Player(2).Turn <> 0 THEN
      GameState% = 8: DoAIStuff BrdX%, BrdY%, DetectNum%
      DestX% = BrdX%: DestY% = BrdY%
     ELSE
      GameState% = GameState% + 1
     END IF
   CASE 7
    ChkClk% = DetectClick(BrdX%, BrdY%, DetectNum%)
    IF ChkClk% = 1 THEN GameState% = GameState% + 1: DestX% = BrdX%: DestY% = BrdY%
    IF ChkClk% = -1 THEN
     IF ShowMoveFlag% = 0 THEN SetColor 3, 0, 0, 0
    GameState% = 4
    END IF
   CASE 8
     PlayTimBuf2# = TIMER
     IF Player(1).Turn <> 0 THEN
      Player(1).PlayTim = Player(1).PlayTim + (PlayTimBuf2# - Player(1).PlayTimBuf)
     END IF
     IF Player(2).Turn <> 0 THEN
      Player(2).PlayTim = Player(2).PlayTim + (PlayTimBuf2# - Player(2).PlayTimBuf)
     END IF
    MoveChecker MoveNum%
    IF NumberOfJumps% > 0 THEN GameState% = 9 ELSE GameState% = 12
   CASE 9
    DetectPossibleChecks 2, MoveNum%
    DeHighLite MoveNum%
     IF NumberOfJumps% > 0 THEN
      Player(1).PlayTimBuf = TIMER
      Player(2).PlayTimBuf = TIMER
      GameState% = 6: DetectNum% = MoveNum%: StartX% = DestX%: StartY% = DestY%
     ELSE
      GameState% = 12
     END IF
   CASE 12
     P1T = Player(1).Turn
     P2T = Player(2).Turn
     IF P1T = 0 THEN Player(1).Turn = 1: Player(2).Turn = 0
     IF P2T = 0 THEN Player(2).Turn = 1: Player(1).Turn = 0
      FOR BrdX% = 1 TO 8
       FOR BrdY% = 1 TO 8
        IF Board(BrdX%, BrdY%).CType = RFlat OR Board(BrdX%, BrdY%).CType = BFlat THEN Board(BrdX%, BrdY%).CType = 0
       NEXT
      NEXT
    CVal% = 4: SetColor 3, 0, 0, 0
    Player(1).PlayTimBuf = TIMER
    Player(2).PlayTimBuf = TIMER
    GameState% = 4
  END SELECT            '-----End Game States-----
 
  FOR MB% = 22 TO 22
   IF mx% >= MainB(MB%).BtX1 AND mx% <= MainB(MB%).BtX2 AND my% >= MainB(MB%).BtY1 AND my% <= MainB(MB%).BtY2 THEN
    LINE (MainB(MB%).BtX1, MainB(MB%).BtY1)-(MainB(MB%).BtX2, MainB(MB%).BtY2), 3, B
     IF Lb% THEN
      SELECT CASE MB%
       CASE 22
        GOTO StartOfItAll
      END SELECT
     END IF
   END IF
  NEXT
 
  IF ShowMoveFlag% THEN RotateColor
   UpTim2# = TIMER
   IF UpTim2# - UpTim1# >= 1 THEN
    SCREEN 7, 0, 2, 0
     IF Player(1).Turn <> 0 THEN
      IF GameState% >= 8 THEN PT# = Player(1).PlayTim ELSE PT# = Player(1).PlayTim + (UpTim2# - Player(1).PlayTimBuf)
      PTS$ = TimConvert(PT#)
      Font 0, 10, PTS$, MyFont(), MyMask(), 0
     END IF
     IF Player(2).Turn <> 0 THEN
      IF GameState% >= 8 THEN PT# = Player(2).PlayTim ELSE PT# = Player(2).PlayTim + (UpTim2# - Player(2).PlayTimBuf)
      PTS$ = TimConvert(PT#)
      Font 0, 10, PTS$, MyFont(), MyMask(), 0
     END IF
     UpTim1# = TIMER
    SCREEN 7, 0, 3, 0
   END IF

 PCOPY 3, 0
IF UCASE$(Key$) = "Q" THEN GOTO StartOfItAll
LOOP
'-----End of game loop-----
IF Player(1).Turn <> 0 THEN Player(2).Wins = Player(2).Wins + 1
IF Player(2).Turn <> 0 THEN Player(1).Wins = Player(1).Wins + 1
GameScreen
 IF TheGameNumber% < NumOfGames% THEN
  TheGameNumber% = TheGameNumber% + 1
  GOTO NextGame
 ELSE
  LastGameScreen
  GOTO StartOfItAll
 END IF

ErrorHandler:
SCREEN 12: CLS
TheErr% = ERR
BEEP
SELECT CASE TheErr%
 CASE 53
  COLOR 15: PRINT "Error!": COLOR 7
  PRINT "File not found."
  PRINT "Please make sure all files are in the same directory as the .EXE file."
  PRINT
  PRINT "Press any key to exit..."
 CASE ELSE
  COLOR 15: PRINT "Uh oh!": COLOR 7
  PRINT "An unexpected error has occured."
  PRINT "Press any key to exit."
  PRINT
  PRINT "Write down the error code, the line number,"
  PRINT "and what you were doing when it occured."
  PRINT "Then email me at: TFSoft@aol.com"
  PRINT "Thanks."
  PRINT
  PRINT "Error code: "; TheErr%
  PRINT "Line number of error: "; ERL
END SELECT
DO: LOOP UNTIL INKEY$ <> ""
END
RESUME NEXT

GetOut:
END

REM $STATIC
SUB DrawMouse
MouseStatus Lb%, Rb%, mx%, my%, 2
 IF mx% + 4 > 319 OR my% + 4 > 199 OR mx% - 4 < 0 OR my% - 4 < 0 THEN
  PutClip mx% - 4, my% - 4, 9, 9, Cursor(), 0, 0, 0, 3
 ELSE
  PUT (mx% - 4, my% - 4), Cursor(0), XOR
 END IF
END SUB

SUB EraseBoard
PCOPY 1, 2
Font 270, 185, "Quit", MyFont(), MyMask(), 1
END SUB

DEFINT A-Z
SUB GetPalette (PalName$)
FOR I = 1 TO LEN(PalName$)
What$ = MID$(PalName$, I, 1)
IF What$ = "." THEN PalName$ = MID$(PalName$, 1, I - 1): EXIT FOR
NEXT
PalName$ = LTRIM$(PalName$): PalName$ = RTRIM$(PalName$)
PalName$ = PalName$ + ".PAL"
 OPEN PalName$ FOR OUTPUT AS #1
   FOR C = 0 TO 15
     PCOL = C
     IF PCOL <= 7 THEN PCOL = PCOL:  ELSE PCOL = PCOL + 8
       OUT &H3C7, PCOL
       Pal(C).PRed = INP(&H3C9)
       Pal(C).PGreen = INP(&H3C9)
       Pal(C).PBlue = INP(&H3C9)
       OUT &H3C8, PCOL
    PRINT #1, Pal(C).PRed, Pal(C).PGreen, Pal(C).PBlue
   NEXT
 CLOSE #1
END SUB

DEFSNG A-Z
SUB Load2 (This$, ThePicArray() AS LONG)
DEF SEG = VARSEG(ThePicArray(0))
BLOAD This$, VARPTR(ThePicArray(0))
DEF SEG
END SUB

DEFINT A-Z
SUB LoadPalette (PalName$)
FOR I = 1 TO LEN(PalName$)
What$ = MID$(PalName$, I, 1)
IF What$ = "." THEN PalName$ = MID$(PalName$, 1, I - 1): EXIT FOR
NEXT
PalName$ = LTRIM$(PalName$): PalName$ = RTRIM$(PalName$)
PalName$ = PalName$ + ".PAL"
 OPEN PalName$ FOR INPUT AS #1
   FOR C = 0 TO 15
   PCOL = C
   IF PCOL <= 7 THEN PCOL = PCOL - 1:  ELSE PCOL = PCOL + 7
   INPUT #1, Pal(C).PRed, Pal(C).PGreen, Pal(C).PBlue
   OUT &H3C7, PCOL
   OUT &H3C9, Pal(C).PRed
   OUT &H3C9, Pal(C).PGreen
   OUT &H3C9, Pal(C).PBlue
   OUT &H3C8, PCOL
   NEXT
 CLOSE #1
END SUB

DEFLNG A-Z
SUB MouseDriver (ax%, bx%, cx%, dx%)
  DEF SEG = VARSEG(Mouse$)
  Mouse% = SADD(Mouse$)
  CALL Absolute(ax%, bx%, cx%, dx%, Mouse%)
END SUB

SUB MouseHide
 ax% = 2
 MouseDriver ax%, 0, 0, 0
END SUB

FUNCTION MouseInit%
  ax% = 0
  MouseDriver ax%, 0, 0, 0
  MouseInit% = ax%
END FUNCTION

SUB MousePut (X%, Y%)
  ax% = 4
  cx% = X%
  dx% = Y%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseRange (X1%, Y1%, X2%, Y2%)
  ax% = 7
  cx% = X1%
  dx% = X2%
MouseDriver ax%, 0, cx%, dx%
  ax% = 8
  cx% = Y1%
  dx% = Y2%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseShow
  ax% = 1
  MouseDriver ax%, 0, 0, 0
END SUB

SUB MouseStatus (Lb%, Rb%, xMouse%, yMouse%, div%)
  ax% = 3
  MouseDriver ax%, bx%, cx%, dx%
  Lb% = ((bx% AND 1) <> 0)
  Rb% = ((bx% AND 2) <> 0)
  xMouse% = cx% / div%
  yMouse% = dx%
END SUB

DEFSNG A-Z
SUB PutClip (putx%, puty%, spritewidth%, spriteheight%, thesprite(), spriteoffset%, maskoffset%, masked%, putscreen%)
'-------
IF putx% > 319 OR puty% > 199 THEN EXIT SUB
IF putx% + spritewidth% - 1 < 0 OR puty% + spriteheight% - 1 < 0 THEN EXIT SUB
px% = putx%: py% = puty%
widthoffset% = 0: heightoffset% = 0
'---X---
IF spritewidth% + putx% - 1 > 319 THEN
newwidth% = 319 - putx%
END IF
IF putx% < 0 THEN
widthoffset% = ABS(putx%)
newwidth% = (spritewidth% - 1) + putx%
px% = 0
END IF
IF spritewidth% + putx% - 1 <= 319 AND putx% >= 0 THEN
newwidth% = spritewidth% - 1
END IF
'---Y---
IF spriteheight% + puty% - 1 > 199 THEN
newheight% = 199 - puty%
END IF
IF puty% < 0 THEN
heightoffset% = ABS(puty%)
newheight% = (spriteheight% - 1) + puty%
py% = 0
END IF
IF spriteheight% + puty% - 1 <= 199 AND puty% >= 0 THEN
newheight% = spriteheight% - 1
END IF
'--------
SCREEN 7, 0, 7, 0
PUT (0, 0), thesprite(spriteoffset%), PSET
GET (widthoffset%, heightoffset%)-(newwidth% + widthoffset%, newheight% + heightoffset%), PutArray(0)
IF masked% <> 0 THEN
PUT (0, 0), thesprite(maskoffset%), PSET
GET (widthoffset%, heightoffset%)-(newwidth% + widthoffset%, newheight% + heightoffset%), PutArray(101)
END IF
'-------
SCREEN 7, 0, putscreen%, 0
IF masked% <> 0 THEN
PUT (px%, py%), PutArray(101), AND
PUT (px%, py%), PutArray(0), OR
ELSE
PUT (px%, py%), PutArray(0), XOR
END IF
END SUB

DEFINT A-Z
SUB SetColor (COL%, RV%, GV%, BV%)
PCOL = COL%
IF PCOL <= 7 THEN PCOL = PCOL - 1:  ELSE PCOL = PCOL + 7
OUT &H3C7, PCOL
OUT &H3C9, RV%
OUT &H3C9, GV%
OUT &H3C9, BV%
OUT &H3C8, PCOL
END SUB

