DECLARE SUB PlayFile (WavFileName$)
DECLARE FUNCTION FileLength& (WavFileName$)
DECLARE FUNCTION DMADone% ()
DECLARE FUNCTION ResetDSP% ()
DECLARE SUB MasterVolume (Right%, Left%, Getvol%)
DECLARE SUB WriteDSP (byte%)
DECLARE FUNCTION ReadDSP% ()
DECLARE SUB SpeakerState (OnOff%)
DECLARE SUB DMAPlay (Segment&, Offset&, Length&, Freq&)
DECLARE FUNCTION GetBLASTER% (DMA%, BasePort%, IRQ%)
DECLARE FUNCTION DSPVersion! ()

'-----Types-----
 TYPE PalType
 PRed AS INTEGER: PGreen AS INTEGER: PBlue AS INTEGER
 END TYPE
   TYPE BoardType
   CType AS INTEGER
   END TYPE
     TYPE CheckerType
     BdX AS INTEGER
     BdY AS INTEGER
     ChkX AS INTEGER
     ChkY AS INTEGER
     ChkType AS INTEGER
     Alive AS INTEGER
     ChkNum AS INTEGER
     END TYPE
       TYPE PlayerType
       PlyrName AS STRING * 10
       Human AS INTEGER
       Turn AS INTEGER
       PlayTimBuf AS DOUBLE
       PlayTim AS DOUBLE
       Diff AS INTEGER
       Wins AS INTEGER
       END TYPE
 TYPE AnimationType
 AnmX AS INTEGER
 AnmY AS INTEGER
 END TYPE
   TYPE ButtonType
   BtX1 AS INTEGER
   BtY1 AS INTEGER
   BtX2 AS INTEGER
   BtY2 AS INTEGER
   END TYPE
'-----End Types-----
'-----Commons-----
COMMON SHARED CheckArray() AS SINGLE, BlkChk() AS CheckerType, RedChk() AS CheckerType
COMMON SHARED BoardX() AS INTEGER, BoardY() AS INTEGER, Board() AS BoardType
COMMON SHARED PossChecks() AS CheckerType, Player() AS PlayerType, PossPoints() AS INTEGER
COMMON SHARED GameState%
COMMON SHARED NumberOfMoves%, NumberOfJumps%
COMMON SHARED StartX%, StartY%, DestX%, DestY%
COMMON SHARED Add() AS AnimationType, ShAdd() AS AnimationType
COMMON SHARED CVal%, CValRot%, CTimer#
COMMON SHARED MyFont() AS SINGLE, MyMask() AS SINGLE
COMMON SHARED MainB() AS ButtonType, SetB() AS ButtonType, OptB() AS ButtonType
COMMON SHARED TempMain$()
COMMON SHARED AnimateFlag%, ShowMoveFlag%, NumOfGames%, TheGameNumber%, PlaySndFlag%
COMMON SHARED BasePort%, LenPort%, Channel%, IRQ%, HaveBlast%
COMMON SHARED TFWav() AS STRING * 32767
COMMON SHARED SoundEvent%
'-----End Commons-----
'$DYNAMIC
DIM SHARED TFWav(1) AS STRING * 32767

REM $STATIC
FUNCTION DMADone%
Count% = INP(LenPort%)
Count2% = INP(LenPort%)
Count& = CLNG(Count% + 1) * CLNG(Count2% + 1)
IF (Count& - 1) >= &HFFFF& THEN junk% = INP(DSPDataAvail%): DMADone% = -1
END FUNCTION

SUB DMAPlay (Segment&, Offset&, Length&, Freq&)
' Transfers and plays the contents of the buffer.
IF PlaySndFlag% = 0 THEN EXIT SUB
Length& = Length& - 1
Page% = 0
MemLoc& = Segment& * 16 + Offset&
SELECT CASE Channel%
    CASE 0
       PgPort% = &H87
       AddPort% = &H0
       LenPort% = &H1
       ModeReg% = &H48
    CASE 1
       PgPort% = &H83
       AddPort% = &H2
       LenPort% = &H3
       ModeReg% = &H49
    CASE 2
       PgPort% = &H81
       AddPort% = &H4
       LenPort% = &H5
       ModeReg% = &H4A
    CASE 3
       PgPort% = &H82
       AddPort% = &H6
       LenPort% = &H7
       ModeReg% = &H4B
    CASE ELSE
       EXIT SUB
END SELECT

OUT &HA, &H4 + Channel%
OUT &HC, &H0
OUT &HB, ModeReg%
OUT AddPort%, MemLoc& AND &HFF
OUT AddPort%, (MemLoc& AND &HFFFF&) \ &H100
IF (MemLoc& AND 65536) THEN Page% = Page% + 1
IF (MemLoc& AND 131072) THEN Page% = Page% + 2
IF (MemLoc& AND 262144) THEN Page% = Page% + 4
IF (MemLoc& AND 524288) THEN Page% = Page% + 8
OUT PgPort%, Page%
OUT LenPort%, Length& AND &HFF
OUT LenPort%, (Length& AND &HFFFF&) \ &H100
OUT &HA, Channel%

IF Freq& < 23000 THEN
   TimeConst% = 256 - 1000000 \ Freq&
   WriteDSP &H40
   WriteDSP TimeConst%
   WriteDSP &H14
   WriteDSP (Length& AND &HFF)
   WriteDSP ((Length& AND &HFFFF&) \ &H100)
ELSE
   IF DSPVersion! >= 3 THEN
      TimeConst% = ((65536 - 256000000 \ Freq&) AND &HFFFF&) \ &H100
      WriteDSP &H40
      WriteDSP TimeConst%
      WriteDSP (Length& AND &HFF)
      WriteDSP ((Length& AND &HFFFF&) \ &H100)
      WriteDSP &H91
   ELSE
      PRINT "You need a Sound Blaster with a DSP v3.x+ to play at high speed."
      EXIT SUB
   END IF
END IF
END SUB

SUB DoSNDEvent (SNDNum%)
 SELECT CASE SNDNum%
  CASE 1
   PlayFile "TFWav1.wav"
  CASE 2
   PlayFile "TFWav2.wav"
  CASE 3
   PlayFile "TFWav3.wav"
  CASE 4
   PlayFile "TFWav4.wav"
  CASE 5
   PlayFile "TFWav5.wav"
 END SELECT
END SUB

FUNCTION DSPVersion!
' Gets the DSP version.
WriteDSP &HE1
Temp% = ReadDSP%
Temp2% = ReadDSP%
DSPVersion! = VAL(STR$(Temp%) + "." + STR$(Temp2%))
END FUNCTION

FUNCTION FileLength& (WavFileName$)
 OPEN WavFileName$ FOR BINARY AS #1
  WavLength& = LOF(1) - 44
  IF WavLength& > 32767 THEN WavLength& = 32767
 CLOSE #1
IF WavLength& = 0 THEN KILL WavFileName$
FileLength& = WavLength&
END FUNCTION

FUNCTION GetBLASTER% (DMA%, BasePort%, IRQ%)
' This subroutine parses the BLASTER environment string and returns settings.
IF LEN(ENVIRON$("BLASTER")) = 0 THEN GetBLASTER% = 0: EXIT FUNCTION
FOR Length% = 1 TO LEN(ENVIRON$("BLASTER"))
   SELECT CASE MID$(ENVIRON$("BLASTER"), Length%, 1)
      CASE "A"
        BasePort% = VAL("&H" + MID$(ENVIRON$("BLASTER"), Length% + 1, 3))
      CASE "I"
        IRQ% = VAL(MID$(ENVIRON$("BLASTER"), Length% + 1, 1))
      CASE "D"
        DMA% = VAL(MID$(ENVIRON$("BLASTER"), Length% + 1, 1))
   END SELECT
NEXT
GetBLASTER% = 1
END FUNCTION

SUB MakeWav

WavLen1& = FileLength("tfwav1.wav")
WavLen1& = WavLen1& + 44
 OPEN "tfwav1.wav" FOR BINARY AS #1
  GET #1, 0, TFWav(1) 'Get 32k from file (skip header on WAV)
 CLOSE #1
 OPEN "tfall.wav" FOR BINARY AS #1
  PUT #1, 0, TFWav(1)
 CLOSE #1

END SUB

SUB MasterVolume (Right%, Left%, Getvol%)
OUT BasePort% + 4, &H22
'PRINT BasePort%
IF Getvol% THEN
   Left% = INP(BasePort% + 5) \ 16
   Right% = INP(BasePort% + 5) AND &HF
   EXIT SUB
ELSE
   OUT BasePort% + 5, (Right% + Left% * 16) AND &HFF
END IF
END SUB

SUB PlayFile (WavFileName$)
 TheWavLen& = FileLength(WavFileName$)
 OPEN WavFileName$ FOR BINARY AS #1
  GET #1, 44, TFWav(1) 'Get 32k from file (skip header on WAV)
 CLOSE #1
 TheWavLen& = TheWavLen& - 60
 DMAPlay VARSEG(TFWav(1)), VARPTR(TFWav(1)), TheWavLen&, 11025
END SUB

FUNCTION ReadDSP%
' Reads a byte from the DSP
DO
LOOP UNTIL INP(BasePort% + 14) AND &H80
ReadDSP% = INP(BasePort% + 10)
END FUNCTION

FUNCTION ResetDSP%
' Resets the DSP
OUT BasePort% + 6, 1
FOR Count% = 1 TO 4
   junk% = INP(BasePort% + 6)
NEXT
OUT BasePort% + 6, 0
IF INP(BasePort% + 14) AND &H80 = &H80 AND INP(BasePort% + 10) = &HAA THEN
   ResetDSP% = -1
ELSE
   ResetDSP% = 0
END IF
END FUNCTION

SUB SpeakerState (OnOff%)
' Turns speaker on or off.
IF OnOff% THEN WriteDSP &HD1 ELSE WriteDSP &HD3
END SUB

SUB WriteDSP (byte%)
' Writes a byte to the DSP
DO
LOOP WHILE INP(BasePort% + 12) AND &H80
OUT BasePort% + 12, byte%
END SUB

