' [ The Imperial Space Guard ] 
'                       [ NeoZones Productions ] 
'
'   Welcome to one of my current projects, The Imperial Space Guard. I've made
' space shooters before, but have never been as proud of one as I am now.
' I believe this to be one of the better space shooters there is, and cannot
' wait to begin work on another one that is even better.
'   I strongly believe in giving out source (except maybe on Rpgs with trade
' secrets :P), so that is why you find this .bas file. There is also an .exe
' for those of you that just wanna start playing right away. The tiles for
' this game were made by me in n!Media, I did all of the programming, and my
' good friend Gradius did all of the music and sound effects.
'   There are some neat things to learn from this code if you want, but hey,
' if you don't, that's fine too. See ya on the other side.
'   So you say, 'What's next Neo?' Well, I say, my next space shooter,
' The Imperial Space Guard 2, (working title...), which is 3d, and that's all
' I'll say. I don't want to get your hopes up or something...
'
'
' If you used pkunzip, use -d!
'
' Tek
' neozones@geocities.com
' www.geocities.com/~neozones
'
' This code only has the main sections commented, so there.
' It's choppy in places, but hey, who cares, it works.
'
' [ Following is a small Q & A I tossed together since I'm bored... ] 
'
' Q: This seems to be just level after level, is there more?
' A: Yes, there's around 45 levels, and an endboss (just another super tough
'    guy, heh, and then you win. Oops, ruined it for you. :P
'
' Q: How do I switch between weapons?
' A: Press 1 for laser, 3 for missiles, or 4 to select the Megabomb.
'
' Q: I beat your game, and now I want a challenge, what can I do?
' A: Well, you can try running joki.com, or just running impjoy.bat and you
'    can see how good you are with a joystick... like driving with an elephant
'    on your back, eh? :)
'
' Q: Why did you make this space shooter, I thought you were an rpg guy?
' A: Well, one, the QBasic community has had an rpg overkill lately, and I
'    started this back in the original Md days so I didn't get so bored.
'    I reccomend to you other guys to have a little side project like this.
'
' Q: What  's up with those ghost ships that sometimes come up?
' A: Oh, you mean when you die and fire, and under certain conditions the old
'    ship isn't cleared? Hell, I dunno, some damn bug I can't quite catch,
'    although it used to be worse. Solution: Don't die. :)
'
' Q: What's that empty weapon slot?
' A: Well, it was gonna be a spread shooter, but I decided against it for now,
'    since it would have been a bit tricky to put in. NO, I DON'T SUCK AT
'    CODING, I'm just too lazy. Maybe next time...
'
' Q: Are there any more questions in the Q & A section?
' A: Uhm... nope.
'
' [ Subs ] 
' Some people don't really like subs, but me, I do. Heheh.
'

DEFINT A-Z
'$DYNAMIC

DECLARE SUB About ()
DECLARE SUB AddMessage (Text$)
DECLARE SUB BeginGame ()
DECLARE SUB BookmarkExtra ()
DECLARE SUB BookmarkShow ()
DECLARE SUB BookmarkShowChoice (Choice)
DECLARE SUB Box (Uc, Ur, Lc, Lr)
DECLARE SUB BoxMessage (Message$)
DECLARE SUB CheckEnGone ()
DECLARE SUB ClearShots ()
DECLARE SUB CollisionDetect ()
DECLARE SUB ContinuePlaySong ()
DECLARE SUB DamagePlayer (Amount)
DECLARE SUB DoDelay (DelayType)
DECLARE SUB DoEnemies ()
DECLARE SUB DoEnGone ()
DECLARE SUB DoEnGoneActions ()
DECLARE SUB DoExplose (ShipNum)
DECLARE SUB DoShots ()
DECLARE SUB DoShotsStory ()
DECLARE SUB DuringLevShow (Choice)
DECLARE SUB DuringLevChoices ()
DECLARE SUB Exhaust ()
DECLARE SUB FancyCls (Index)
DECLARE SUB FmpadLPort (AdressReg, BData)
DECLARE SUB FmpInit ()
DECLARE SUB FmpPlayStart (PFileName$)
DECLARE SUB InitLevel ()
DECLARE SUB InitStars ()
DECLARE SUB InitStuff ()
DECLARE SUB InitVars ()
DECLARE SUB IntroScreen ()
DECLARE SUB JumpPoint ()
DECLARE SUB LaunchGame ()
DECLARE SUB LoadBookMark ()
DECLARE SUB LoadFont ()
DECLARE SUB LoadTiles ()
DECLARE SUB MoveDown ()
DECLARE SUB MoveUp ()
DECLARE SUB Options ()
DECLARE SUB PlayerDead ()
DECLARE SUB PlayerShot ()
DECLARE SUB PlaySong (PFileName$)
DECLARE SUB PutText (Text$, c, XCoordinate, YCoordinate, Size)
DECLARE SUB PutText2 (Text$, c, XCoordinate, YCoordinate, Size, Slide)
DECLARE SUB SaveBookmark ()
DECLARE SUB SetFrame (ShowStar)
DECLARE SUB SetupPalette ()
DECLARE SUB SetupScreen ()
DECLARE SUB ShowHealth ()
DECLARE SUB ShowKredits ()
DECLARE SUB ShowLevel ()
DECLARE SUB ShowLives ()
DECLARE SUB ShowOptionStatus ()
DECLARE SUB ShowOptionsChoice (Choice)
DECLARE SUB ShowOutpostChoice (Choice)
DECLARE SUB ShowPlayer ()
DECLARE SUB ShowScore ()
DECLARE SUB ShowSpecialCount ()
DECLARE SUB ShowStars ()
DECLARE SUB ShowWave ()
DECLARE SUB ShowWeapon ()
DECLARE SUB StarMove ()
DECLARE SUB StarOutpost (OutpostIndex)
DECLARE SUB StopPlaySong ()
DECLARE SUB Story ()
DECLARE SUB WaitKey ()
DECLARE FUNCTION Fixed$ (Num)
DECLARE FUNCTION RndNum (Max, Min, Mult)

' [ Type Constructs ] 
' Wow, that'll make the program size bigger. :)
'

TYPE ColourType
 Main     AS INTEGER
 Shadow   AS INTEGER
 Message  AS INTEGER
 Outer    AS INTEGER
 Middle   AS INTEGER
 Inner    AS INTEGER
 Bg       AS INTEGER
 Las1     AS INTEGER
 Hilight  AS INTEGER
END TYPE

TYPE DemoShipType
 x        AS INTEGER
 y        AS INTEGER
 Oldx     AS INTEGER
 Oldy     AS INTEGER
 Angle    AS SINGLE
 ORadius  AS INTEGER
 Basex    AS INTEGER
 Basey    AS INTEGER
END TYPE

TYPE EShipType
 x        AS INTEGER
 XAdj     AS INTEGER
 y        AS INTEGER
 YAdj     AS INTEGER
 Hp       AS INTEGER
 MaxHp    AS INTEGER
 ShotLev  AS INTEGER
 ShipType AS INTEGER
 Count    AS INTEGER
END TYPE

TYPE EShotType
 ShotOn   AS INTEGER
 x        AS INTEGER
 y        AS INTEGER
 Level    AS INTEGER
 DataMark AS INTEGER
END TYPE

TYPE GameDataType
 Movement AS INTEGER
 Action   AS INTEGER
 LevelOn  AS INTEGER
 MusicOp  AS INTEGER
 SoundOp  AS INTEGER
END TYPE
		     
TYPE GenDataType
 CurLevel AS INTEGER
 LevCol   AS INTEGER
 NextLev  AS INTEGER
END TYPE

TYPE PlayerType
 x        AS INTEGER
 y        AS INTEGER
 Lives    AS INTEGER
 Hp       AS INTEGER
 MaxHp    AS INTEGER
 ShotLev  AS INTEGER
 SpredLev AS INTEGER
 Weapon   AS INTEGER
 Missiles AS INTEGER
 Megabomb AS INTEGER
 Kredits  AS INTEGER
 Score    AS LONG
END TYPE

TYPE PShotType
 ShotOn   AS INTEGER
 x        AS INTEGER
 y        AS INTEGER
 Ident    AS INTEGER
 DataMark AS INTEGER
END TYPE

TYPE SpreadType
 SShot    AS INTEGER
 ShotX    AS INTEGER
 ShotY    AS INTEGER
END TYPE

TYPE StarType
 x        AS INTEGER
 y        AS INTEGER
 Speed    AS INTEGER
 Colour   AS INTEGER
END TYPE

TYPE KeyBType
 FLow     AS INTEGER
 FHi      AS INTEGER
 FOct     AS INTEGER
 Location AS INTEGER
END TYPE

TYPE VoiceType
 ScanCode AS INTEGER
 InUse    AS INTEGER
 Delay    AS INTEGER
 RegB0    AS INTEGER
END TYPE

' [ Constants ] 
' Gotta have 'em.
'

CONST True = -1, False = 0
CONST TileDir$ = "images"
CONST Laser = 1, Spread = 2, Missile = 3, Megabomb = 4
CONST Pi = 3.141592654#, DownAmount = 20, TotalVoices = 9
CONST LevelSong$ = "level.fmp", OutpostSong$ = "level.fmp", BossSong$ = "level.fmp", IntroSong$ = "level.fmp"

CONST Stars = 100, MaxPShots = 20, MaxEShots = 10

' Variables to change that affect gameplay:
'      Stars: The number of stars in the starfield; decrease if you have speed
'             problems.
'  MaxPShots: The maximum number of shots that the player can have out at
'             a time. Increase to shoot more.
'  MaxEShots: Max number of shots enemies can have out, altogether, on a
'             single level.
'
' [ Dimensions (Graphics) ] 
' Goodbye memory. :)  Sure, I coulda indexed it, but hey, it ain't broken...
'

DIM SHARED Ship1(201)
DIM SHARED EShip1(103), EShip2(103), EShip3(103), EShip4(103), EShip5(103)
DIM SHARED UpBox(201), DownBox(201), LeftBox(201), RightBox(201)
DIM SHARED Ur(201), Ul(201), Lr(201), Ll(201)
DIM SHARED Urb(201), Ulb(201), Lrb(201), Llb(201)
DIM SHARED Ex1(4), Ex2(4), Ex3(4), Ex4(4), Ex5(4), Ex6(4)
DIM SHARED StatBox(493), Shot1(14), Shot2(14), Shot3(14), Shot4(14)
DIM SHARED Explose1(103), Explose2(103), Explose3(103), Explose4(103)
DIM SHARED Laser1P(13), Laser2P(13), Laser3P(13), Laser4P(13), LaserNs(13)
DIM SHARED Missile1(13), Everik(201), Therces(13)
DIM SHARED Spread1P(13), Spread2P(13), Spread1Ns(13), Spread2Ns(13)
DIM SHARED MissileP(13), MissileNs(13), MegaBombP(13), MegaBombNs(13)
DIM SHARED TempPic(3000)

' [ Dimensions (Variables) ] 
' Regular stuff...
'

DIM SHARED Star(Stars) AS StarType
DIM SHARED Pal(512), CharSet(128, 8, 6), Menu$(1 TO 6)
DIM SHARED Player AS PlayerType, Colour AS ColourType, GameData AS GameDataType
DIM SHARED DemoShip AS DemoShipType, GenData AS GenDataType
DIM SHARED PShot(1 TO MaxPShots) AS PShotType, EShot(1 TO MaxEShots) AS EShotType
DIM SHARED EShip(1 TO 8) AS EShipType
DIM SHARED ExCount, YAd, NumShips, Count, ViewMode
DIM SHARED AdlPortAsm(512), KeyB(128) AS KeyBType, TotalKeys, Voice(9) AS VoiceType, SetOldInstrumentsFlag, CurrentSong$
DIM SHARED KBMatrix(257), CurrentKBMatrix(257), OldKBMatrix(257), Transpose, PlayBuffer&(8192), RecordBuffer&(8192), PlayBufferIndex&, RecordBufferIndex&, RecordDelayCounter&, PlayDelayCounter&, KeyCount&, KeyIndex&, RecordMode, PlayMode

GameData.MusicOp = True                           ' Here so value is constant,
GameData.SoundOp = True                           ' changeable.
ViewMode = 1

' [ Beginning of Program ] 
' Ah, the heart of the program. Pretty small at first glace...
'

CALL InitStuff
CALL ShowLevel

DO
 CALL StarMove
 CALL Exhaust
 CALL DoDelay(1)
 CALL DoShots
 CALL DoEnemies
 CALL CollisionDetect
 CALL ContinuePlaySong

 kbd$ = INKEY$
 IF kbd$ <> "" THEN
  SELECT CASE kbd$
   CASE CHR$(0) + "H"
    GameData.Action = True
    YAd = YAd - 1
    IF YAd = -2 THEN YAd = -1
   CASE CHR$(0) + "P"
    GameData.Action = True
    YAd = YAd + 1
    IF YAd = 2 THEN YAd = 1
   CASE " "
    CALL PlayerShot
   CASE "1"
    Player.Weapon = Laser
    CALL ShowWeapon
   CASE "2"
    IF Player.SpredLev <> 0 THEN
     Player.Weapon = Spread
     CALL ShowWeapon
    END IF
   CASE "3"
    IF Player.Missiles > 0 THEN
     Player.Weapon = Missile
     CALL ShowWeapon
    END IF
   CASE "4"
    IF Player.Megabomb > 0 THEN
     Player.Weapon = Megabomb
     CALL ShowWeapon
    END IF
   CASE CHR$(27)
    CALL DuringLevChoices
  END SELECT
 END IF

 IF GameData.Action = True THEN
  IF YAd = -1 THEN CALL MoveUp
  IF YAd = 1 THEN CALL MoveDown
  IF YAd = 0 THEN GameData.Action = False
 END IF

 IF GenData.NextLev = True THEN CALL DoEnGone

LOOP

' [ End of Program, Start of Data (Levels) ] 
' Simple, maybe primitive, but the job gets done.
'

KeyData:
DATA 0,0,0,0,0,0,0,0,0,0,0,0,21,1,5,27,55,1,5,25,0,0,0,0,114,1,5,22,159,1,5,20,210,1,5,18,0,0,0,0,21,1,6,15,55,1,6,13,0,0,0,0,114,1,6,10,210,1,6,6,238,1,4,29,6,1,5,28,38,1,5,26,74,1,5,24,93,1,5,23,136,1,5,21,184,1,5,19,238,1,5,17,6,1,6,16
DATA 38,1,6,14,74,1,6,12,93,1,6,11,136,1,6,9,184,1,6,7,0,0,0,0,0,0,0,0,21,1,4,39,55,1,4,37,0,0,0,0,114,1,4,34,159,1,4,32,210,1,4,30,0,0,0,0,21,1,5,27,55,1,5,25,93,1,5,23,210,1,4,30,238,1,3,41,159,1,6,8,6,1,4,40,38,1,4,38,74,1,4,36,93,1,4,35
DATA 136,1,4,33,184,1,4,31,238,1,4,29,6,1,5,28,38,1,5,26,74,1,5,24,93,1,5,23,0,0,0,0,0,0,0,0,0,0,0,0,210,1,3,42,-1,-1,-1,-1

AdlPortData:
DATA 85,137,229,80,83,81,82,30,86,6,87,190,6,0,177,4,54,139,26,139,7,54,137,2,70,70,254,201,117,242,22,31,139,86,10,138,70,6,238,185,6,0,236,73,117,252,139,86,12,138,70,8,238,139,86,10,185,35,0,236
DATA 73,117,252,95,7,94,31,90,89,91,88,137,236,93,202,8,-1

LevelData:
DATA 4,2,1,4,3          
DATA 4,2,1,4,3          
DATA 4,2,1,4,3          
DATA 4,2,3,2,2          
DATA 4,1,1,2,2          
DATA 4,2,3,2,2          
DATA 4,1,1,2,2          
DATA 4,2,2,3,2          
DATA 4,1,1,2,2          
DATA 4,1,3,2,2          
DATA 4,2,2,2,2          
DATA 4,1,1,3,2          
DATA 4,2,2,2,2          
DATA 4,1,3,2,2          
DATA 4,2,2,2,2         
Sector2:
DATA 4,2,2,2,2        
DATA 4,2,3,2,2          
DATA 4,1,1,2,2          
DATA 4,1,1,2,2          
DATA 4,2,2,2,2          
DATA 4,1,1,2,2          
DATA 4,2,2,2,2          
DATA 4,1,1,2,2          
DATA 4,2,2,2,2          
DATA 4,1,1,2,2          
DATA 4,2,2,2,2          
DATA 4,1,1,2,2          
DATA 4,1,1,2,2          
DATA 4,2,2,2,2          
Sector3:
DATA 4,2,2,2,2         
DATA 4,2,2,2,2          
DATA 4,1,1,2,2          
DATA 4,2,2,2,2          
DATA 4,2,1,4,3          
DATA 4,2,1,4,3          
DATA 4,3,1,4,3        
DATA 4,1,3,2,2       
DATA 4,1,3,5,2        
DATA 4,1,1,1,1         
DATA 4,2,2,2,2         
DATA 4,3,3,3,3         
DATA 4,4,4,4,4         
DATA 4,1,3,2,2          
DATA 4,2,2,2,2          
DATA 4,5,5,5,5         
DATA 4,1,1,1,1

REM $STATIC
SUB About

CALL SetFrame(True)

PutText2 "The", 31, 40, 16, 1, -1
PutText2 "Imperial Space Guard", 31, -1, 24, 2, -1
PutText2 "brought to you by...", 31, -1, 42, 1, -1

PutText2 " The Imperial Space Guard was programmed by Neo,", 31, 16, 64, 1, -1
PutText2 "who also used n!Media v.05 to fashion the tiles.", 31, 16, 72, 1, -1
PutText2 "Gradius, aka Milo Sedlacek composed the music for", 31, 16, 80, 1, -1
PutText2 "Space Guard, along with the sound effects.", 31, 16, 88, 1, -1
PutText2 " The palette was designed by Gamerx a while back,", 31, 16, 96, 1, -1
PutText2 "and the font was made by Joe Davison, with some", 31, 16, 104, 1, -1
PutText2 "minor modifications by me to give it the gradient", 31, 16, 112, 1, -1
PutText2 "effect.", 31, 16, 120, 1, -1
PutText2 " Thanks for playing the game, why don't you tell", 31, 16, 128, 1, -1
PutText2 "me about the bugs and give me your comments as to", 31, 16, 136, 1, -1
PutText2 "how I could make a better game.", 31, 16, 144, 1, -1
PutText2 "Neo", 31, 16, 160, 1, -1
PutText2 "neozones@geocities.com", 31, 16, 167, 1, -1
PutText2 "www.geocities.com/~neozones", 31, 16, 176, 1, -1

PUT (200, 160), EShip1, PSET

CALL WaitKey

PUT (200, 160), Explose1, PSET
CALL DoDelay(1)
PUT (200, 160), Explose1, PSET
CALL DoDelay(1)
PUT (200, 160), Explose2, PSET
CALL DoDelay(1)
PUT (200, 160), Explose2, PSET
CALL DoDelay(1)
PUT (200, 160), Explose3, PSET
CALL DoDelay(1)
PUT (200, 160), Explose3, PSET
CALL DoDelay(1)
PUT (200, 160), Explose4, PSET
CALL DoDelay(1)
PUT (200, 160), Explose4, PSET
CALL DoDelay(1)

END SUB

SUB AddMessage (Text$)

LINE (13, 20)-STEP(72, 0), 0, BF
GET (14, 20)-STEP(72, 8), StatBox
LINE (14, 20)-STEP(72, 8), 0, BF
PUT (14, 12), StatBox, PSET

IF LEN(Text$) > 12 THEN Text$ = LEFT$(Text$, 12)

PutText Text$, Colour.Message, 14, 20, 1

END SUB

SUB BeginGame

CLS
CALL SetFrame(True)

PUT (50, 140), Everik, PSET
PUT (80, 120), Therces, PSET

PutText2 "The", 31, 40, 16, 1, -1
PutText2 "Imperial Space Guard", 31, -1, 24, 2, -1

PutText2 "Into the shadows of space.", 31, -1, 42, 1, -1

MenuChange = True
OldMenuCount = 1
MenuCount = 1

FOR i = 1 TO 6
 PutText2 Menu$(i), 238, 265, i * 9 + 125, 1, -1
NEXT i

CALL ShowStars

DemoShip.Basex = 60
DemoShip.Basey = 150
GenData.LevCol = 174

DO
 kbd$ = INKEY$
 IF kbd$ <> "" THEN
  SELECT CASE kbd$
   CASE CHR$(0) + "H"
    OldMenuCount = MenuCount
    MenuCount = MenuCount - 1
    IF MenuCount = 0 THEN MenuCount = 6
    MenuChange = True
   CASE CHR$(0) + "P"
    OldMenuCount = MenuCount
    MenuCount = MenuCount + 1
    IF MenuCount = 7 THEN MenuCount = 1
    MenuChange = True
   CASE CHR$(13)
    SELECT CASE MenuCount
     CASE 1
      CALL PlaySong(LevelSong$)
      CALL LaunchGame
      EXIT DO
     CASE 2
      CALL LoadBookMark
      EXIT SUB
     CASE 3
      CALL Story
      CALL BeginGame
      EXIT SUB
     CASE 4
      CALL About
      CALL BeginGame
      EXIT SUB
     CASE 5
      CALL Options
      CALL BeginGame
      EXIT SUB
     CASE 6
      CALL StopPlaySong
      END ' Endgame
    END SELECT
  END SELECT
 END IF

 IF MenuChange = True THEN
  PutText2 Menu$(OldMenuCount), 238, 265, OldMenuCount * 9 + 125, 1, -1
  PutText2 Menu$(MenuCount), 167, 265, MenuCount * 9 + 125, 1, 1
  MenuChange = False
 END IF

 DemoShip.Angle = DemoShip.Angle + 1
 IF DemoShip.Angle = 360 THEN DemoShip.Angle = 0

 Theta! = DemoShip.Angle * (Pi / 180)

 DemoShip.x = DemoShip.Basex + DemoShip.ORadius * COS(Theta!)
 DemoShip.y = DemoShip.Basey - DemoShip.ORadius * SIN(Theta!)

 PSET (DemoShip.Oldx, DemoShip.Oldy), TempCol
 TempCol = POINT(DemoShip.x, DemoShip.y)

 PSET (DemoShip.x, DemoShip.y), GenData.LevCol
 
 DemoShip.Oldx = DemoShip.x
 DemoShip.Oldy = DemoShip.y

 CALL DoDelay(1)

LOOP

CLS
CALL SetupScreen

END SUB

SUB BookmarkExtra

LINE (39, 47)-STEP(241, 0), 172
LINE (39, 47)-STEP(0, 125), 172

FOR i = 1 TO 4
 LINE (279, i * 28 + 21)-STEP(0, 26), 172
 LINE (41, i * 28 + 47)-STEP(239, 0), 172
NEXT i

LINE (41, 171)-STEP(46, 0), 172
LINE (87, 161)-STEP(0, 10), 172

PutText2 "Close", 31, 49, 162, 1, -1

END SUB

SUB BookmarkShow

FOR i = 1 TO 4
 OPEN "imperial.sv" + Fixed$(i) FOR INPUT AS #1
  INPUT #1, LevelOn, CurLevel, Lives, MaxHp, Hp, ShotLev, Weapon, Missiles, Megabombs, Kredits, Score, ViewMode
  PutText2 "Mission: " + Fixed$(LevelOn) + "-" + Fixed$(CurLevel) + ", " + Fixed$(Lives) + " lives. " + Fixed$(Hp) + "/" + Fixed$(MaxHp) + " dam.", 31, 45, i * 28 + 22, 1, -1
  PutText2 "Laser " + Fixed$(ShotLev) + ". Missiles: " + Fixed$(Missiles) + ", Megabombs: " + Fixed$(Megabombs) + ".", 31, 45, i * 28 + 30, 1, -1
  PutText2 "Kredits: " + Fixed$(Kredits) + ". Score: " + Fixed$(CINT(Score)) + "00", 31, 45, i * 28 + 38, 1, -1
 CLOSE
NEXT i

END SUB

SUB BookmarkShowChoice (Choice)

FOR i = 1 TO 4
 LINE (40, i * 28 + 20)-STEP(240, 28), 167, B
NEXT i

LINE (40, 160)-STEP(48, 12), 167, B

SELECT CASE Choice
 CASE 1 TO 4
  LINE (40, Choice * 28 + 20)-STEP(240, 28), Colour.Hilight, B
 CASE 5
  LINE (40, 160)-STEP(48, 12), Colour.Hilight, B
END SELECT

END SUB

SUB Box (Uc, Ur, Lc, Lr)

'LINE (Uc, Ur)-(Lc, Lr), Colour.Outer, B
LINE (Uc + 1, Ur + 1)-(Lc - 1, Lr - 1), Colour.Middle, B
LINE (Uc + 2, Ur + 2)-(Lc - 2, Lr - 2), Colour.Inner, B
LINE (Uc + 3, Ur + 3)-(Lc - 3, Lr - 3), Colour.Middle, B
LINE (Uc + 4, Ur + 4)-(Lc - 4, Lr - 4), Colour.Bg, BF

END SUB

SUB BoxMessage (Message$)

GET (60, 87)-(260, 113), TempPic
CALL Box(60, 87, 260, 113)
PutText2 Message$, 31, -1, 96, 1, -1
CALL WaitKey
PUT (60, 87), TempPic, PSET

END SUB

SUB CheckEnGone

FOR i = 1 TO NumShips
 IF EShip(i).Hp > 0 THEN EXIT SUB
NEXT i

FOR i = 1 TO 7
 CALL DoEnemies
NEXT i

GenData.NextLev = True

END SUB

SUB ClearShots

FOR i = 1 TO MaxPShots
 PShot(i).ShotOn = False
 IF PShot(i).x <> 0 THEN LINE (PShot(i).x - 4, PShot(i).y - 2)-STEP(9, 5), 0, BF
NEXT i

FOR i = 1 TO MaxEShots
 IF EShot(i).ShotOn = True THEN
  EShot(i).ShotOn = False
  IF EShot(i).x <> 0 THEN LINE (EShot(i).x, EShot(i).y - 2)-STEP(7, 5), 0, BF
 END IF
NEXT i

END SUB

SUB CollisionDetect

Collide = False

SSize = 15

FOR i = 1 TO NumShips

IF Player.x + SSize >= EShip(i).x AND Player.x + SSize <= EShip(i).x + SSize THEN
 IF Player.y + SSize >= EShip(i).y AND Player.y + SSize <= EShip(i).y + SSize THEN Collide = True
END IF

IF Player.x >= EShip(i).x AND Player.x < EShip(i).x + SSize THEN
 IF Player.y >= EShip(i).y AND Player.y < EShip(i).y + SSize THEN Collide = True
END IF

NEXT i

IF Collide = True THEN
 Player.Lives = Player.Lives - 1
 Player.Hp = Player.MaxHp
 
 LINE (Player.x, Player.y)-STEP(20, 20), 0, BF

 Player.x = 20
 Player.y = 90
 YAd = 0

 CALL ShowLives
 CALL ShowHealth

 IF Player.Lives < 0 THEN
  CALL PlayerDead
  EXIT SUB
 END IF

 a& = TIMER

 DO
  CALL StarMove
  CALL DoEnemies
  CALL DoShots
  CALL DoDelay(1)
  CALL ContinuePlaySong

  IF TIMER > a& + 1 THEN
   PUT (Player.x, Player.y), Ship1, PSET
   EXIT SUB
  END IF
 LOOP
END IF

END SUB

SUB ContinuePlaySong

IF PlayMode = 0 THEN EXIT SUB
IF GameData.MusicOp = False THEN EXIT SUB

FOR n = 0 TO TotalVoices - 1
 Voice(n).Delay = Voice(n).Delay + 1
 IF Voice(n).Delay > 32000 THEN Voice(n).Delay = 32000
NEXT

DO WHILE KBMatrix(128) > 0
 saveflag = 0
 keycode = KBMatrix(128 + KBMatrix(128))
 originalkeycode = keycode
 KBMatrix(128) = KBMatrix(128) - 1
 IF keycode > 127 THEN
  keycode = keycode - 128
  IF keycode < TotalKeys THEN
   saveflag = 1
   voicenumber = -1
   FOR n = 0 TO TotalVoices - 1
    IF Voice(n).ScanCode = keycode THEN voicenumber = n
   NEXT
   IF voicenumber = -1 THEN GOTO FMPskip2
   byte = Voice(voicenumber).RegB0
   byte = byte AND (255 - 32)
   FmpadLPort &HB0 + voicenumber, byte
   flag = 1
   FOR n = 0 TO TotalVoices - 1
    IF n <> voicenumber THEN
     IF Voice(n).InUse = 1 AND (KeyB(Voice(n).ScanCode).Location = KeyB(Voice(voicenumber).ScanCode).Location) THEN flag = 0
    END IF
   NEXT
   Voice(voicenumber).Delay = 0
   Voice(voicenumber).InUse = 0
  
FMPskip2:
  END IF
  GOTO keyrespondSKIP0
  ELSE
   IF keycode < TotalKeys THEN
    flag = 1
    FOR n = 0 TO TotalVoices - 1
     IF Voice(n).InUse = 1 THEN
      IF Voice(n).ScanCode = keycode THEN flag = 0
     END IF
    NEXT
    IF flag = 1 THEN
     saveflag = 1
     unused = -1
     FOR n = 0 TO TotalVoices - 1
      IF Voice(n).InUse = 0 THEN unused = n
     NEXT
     largest = 0
     IF unused = -1 THEN
      voicenumber = -1
      FOR n = 0 TO TotalVoices - 1
       IF Voice(n).Delay > largest THEN
	largest = Voice(n).Delay
	voicenumber = n
       END IF
      NEXT
     ELSE
      voicenumber = -1
      FOR n = 0 TO TotalVoices - 1
       IF Voice(n).InUse = 0 THEN
	IF Voice(n).Delay > largest THEN
	 largest = Voice(n).Delay
	 voicenumber = n
	END IF
       END IF
       NEXT
      END IF
      Voice(voicenumber).ScanCode = keycode
      Voice(voicenumber).Delay = 0
      Voice(voicenumber).InUse = 1
      scan = Voice(voicenumber).ScanCode
      lobyte = KeyB(scan).FLow
      hibyte = KeyB(scan).FHi
      fr = lobyte + (hibyte * 256)
      FOR n = 0 TO 4
       fr = fr * 1.05946
      NEXT
      ffr = INT(fr)
      lobyte = ffr AND 255
      hibyte = INT(ffr / 256)
      hibyte = hibyte OR ((KeyB(scan).FOct + Transpose) * 4)
      hibyte = hibyte OR 32
      FmpadLPort &HA0 + voicenumber, lobyte
      FmpadLPort &HB0 + voicenumber, hibyte
      Voice(voicenumber).RegB0 = hibyte
     END IF
     GOTO keyrespondSKIP0
    END IF
   END IF
   SELECT CASE keycode
    CASE 74
     saveflag = 1
     Transpose = Transpose - 1
     IF Transpose < -4 THEN Transpose = -4
    CASE 78
     saveflag = 1
     Transpose = Transpose + 1
     IF Transpose > 1 THEN Transpose = 1
   END SELECT
keyrespondSKIP0:
   IF RecordMode = 1 AND saveflag = 1 THEN
    DEF SEG = VARSEG(RecordBuffer&(0))
    POKE RecordBufferIndex&, RecordDelayCounter&
    POKE RecordBufferIndex& + 1, originalkeycode
    DEF SEG
    RecordBufferIndex& = RecordBufferIndex& + 2
    KeyCount& = KeyCount& + 1
    RecordDelayCounter& = 0
   END IF
keyrespondSKIP1:
  LOOP
  FOR n = 0 TO TotalVoices - 1
   IF Voice(n).InUse = 1 THEN
    IF KBMatrix(Voice(n).ScanCode) = 0 THEN
    byte = Voice(n).RegB0
    byte = byte AND (255 - 32)
    FmpadLPort &HB0 + n, byte
    flag = 1
    FOR n2 = 0 TO TotalVoices - 1
     IF n2 <> n THEN
      IF Voice(n2).InUse = 1 AND (KeyB(Voice(n2).ScanCode).Location = KeyB(Voice(n).ScanCode).Location) THEN flag = 0
     END IF
    NEXT
    Voice(n).Delay = 0
    Voice(n).InUse = 0
   END IF
  END IF
 NEXT
 GOSUB fmkeysDOPLAY
 EXIT SUB

fmkeysDOPLAY:
 PlayDelayCounter& = PlayDelayCounter& + 1
BACK0:
 DEF SEG = VARSEG(PlayBuffer&(0))
 IF PlayDelayCounter& >= PEEK(PlayBufferIndex&) THEN
  i = PEEK(PlayBufferIndex& + 1)
  n = KBMatrix(128)
  KBMatrix(n + 129) = i
  KBMatrix(128) = n + 1
  IF i < 128 THEN
   KBMatrix(i) = 1
  ELSE
   KBMatrix(i - 128) = 0
  END IF
  DEF SEG
  KeyIndex& = KeyIndex& + 1
  IF KeyIndex& >= PlayBuffer&(3) THEN PlaySong CurrentSong$
  PlayBufferIndex& = PlayBufferIndex& + 2
  PlayDelayCounter& = 0
  IF PlayMode = 1 THEN GOTO BACK0
 END IF
DEF SEG
RETURN

END SUB

SUB DamagePlayer (Amount)

Player.Hp = Player.Hp - 1

IF Player.Hp < 0 THEN
 Player.Lives = Player.Lives - 1
 Player.Hp = Player.MaxHp
 CALL ShowLives
 CALL ShowHealth
 IF Player.Lives < 0 THEN CALL PlayerDead

 LINE (Player.x, Player.y)-STEP(20, 20), 0, BF

 a& = TIMER
 DO
  CALL StarMove
  CALL DoEnemies
  CALL DoShots
  CALL DoDelay(1)
  CALL ContinuePlaySong
  IF TIMER > a& + 1 THEN
   Player.x = 20
   Player.y = 90
   YAd = 0
   PUT (Player.x, Player.y), Ship1, PSET
   EXIT SUB
  END IF
 LOOP

 EXIT SUB

END IF

LINE (Player.Hp * 13 + 8, 37)-STEP(12, 5), 0, BF

IF Amount > 1 THEN CALL DamagePlayer(Amount - 1)

END SUB

SUB DoDelay (DelayType)

SELECT CASE DelayType
 CASE 1
  WAIT &H3DA, 8
  WAIT &H3DA, 8, 8
END SELECT

END SUB

SUB DoEnemies

FOR i = 1 TO NumShips
 IF EShip(i).Hp <= 0 AND EShip(i).Count > 0 THEN
  CALL DoExplose(i)
 END IF

 IF EShip(i).Hp > 0 THEN
  SELECT CASE EShip(i).ShipType
   CASE 1
    LINE (EShip(i).x, EShip(i).y)-STEP(11, 16), 0, BF
    EShip(i).x = EShip(i).x + EShip(i).XAdj
    EShip(i).y = EShip(i).y + EShip(i).YAdj
    IF EShip(i).x <= 10 THEN EShip(i).x = 320
    IF EShip(i).y <= 51 THEN EShip(i).YAdj = 1
    IF EShip(i).y >= 168 THEN EShip(i).YAdj = -1
    IF EShip(i).x <= 300 THEN
     PUT (EShip(i).x, EShip(i).y), EShip1, PSET
    END IF
   CASE 2
    LINE (EShip(i).x, EShip(i).y)-STEP(11, 16), 0, BF
    EShip(i).x = EShip(i).x + EShip(i).XAdj
    EShip(i).y = EShip(i).y + EShip(i).YAdj
    IF EShip(i).x <= 10 THEN EShip(i).x = 320
    IF EShip(i).y <= 51 THEN EShip(i).YAdj = 1
    IF EShip(i).y >= 168 THEN EShip(i).YAdj = -1
    IF EShip(i).x <= 300 THEN
     PUT (EShip(i).x, EShip(i).y), EShip2, PSET
    END IF
   CASE 3
    LINE (EShip(i).x, EShip(i).y)-STEP(11, 16), 0, BF
    EShip(i).x = EShip(i).x + EShip(i).XAdj
    IF EShip(i).x <= 10 THEN EShip(i).x = 320
    IF EShip(i).x <= 300 THEN
     PUT (EShip(i).x, EShip(i).y), EShip3, PSET
    END IF
   CASE 4
    LINE (EShip(i).x, EShip(i).y)-STEP(11, 16), 0, BF
    EShip(i).y = EShip(i).y + EShip(i).YAdj
    IF EShip(i).y <= 51 THEN EShip(i).YAdj = 1
    IF EShip(i).y >= 168 THEN EShip(i).YAdj = -1
    IF EShip(i).x <= 300 THEN
     PUT (EShip(i).x, EShip(i).y), EShip4, PSET
    END IF
   CASE 5
    LINE (EShip(i).x, EShip(i).y)-STEP(11, 16), 0, BF
    EShip(i).x = EShip(i).x + EShip(i).XAdj
    IF EShip(i).x <= 10 THEN EShip(i).x = 320
    IF EShip(i).x <= 300 THEN
     PUT (EShip(i).x, EShip(i).y), EShip5, PSET
    END IF
  
  END SELECT

 END IF

 Count = Count + 1
 IF Count = 400 THEN
  FOR j = 1 TO NumShips
   IF EShip(j).Hp > 0 AND INT(RND * 2) + 1 = 1 THEN
     FOR k = 1 TO MaxEShots
      IF EShot(k).ShotOn = False THEN
       EShot(k).ShotOn = True
       EShot(k).x = EShip(j).x
       EShot(k).y = EShip(j).y + 8
       SELECT CASE EShip(j).ShipType
	CASE 1
	 EShot(k).DataMark = 3
	CASE 2
	 EShot(k).DataMark = 1
	CASE 3
	 EShot(k).DataMark = 2
	CASE 4
	 EShot(k).DataMark = 4
	CASE 5
	 EShot(k).DataMark = 4
       END SELECT
      
       EXIT FOR
      END IF
     NEXT k
   END IF
  NEXT j

  Count = 0
 END IF

NEXT i

END SUB

SUB DoEnGone

GameData.LevelOn = GameData.LevelOn + 1
SELECT CASE GenData.CurLevel
 CASE 1
  IF GameData.LevelOn = 16 THEN
   CALL ClearShots
   PutText2 "Everik Cleared!", 167, -1, 114, 2, 1
   WHILE INKEY$ <> CHR$(13)
    CALL StarMove
    CALL DoDelay(1)
    CALL Exhaust
    CALL ContinuePlaySong
   WEND
   CALL DoEnGoneActions
  END IF
 CASE 2
  IF GameData.LevelOn = 30 THEN
   CALL ClearShots
   PutText2 "Therces Cleared!", 167, -1, 114, 2, 1
   WHILE INKEY$ <> CHR$(13)
    CALL StarMove
    CALL DoDelay(1)
    CALL Exhaust
    CALL ContinuePlaySong
   WEND
   CALL DoEnGoneActions
  END IF
 CASE 3
  IF GameData.LevelOn = 46 THEN
   CALL ClearShots
   PutText2 "Moonbase Cleared!", 167, -1, 114, 2, 1
   WHILE INKEY$ <> CHR$(13)
    CALL StarMove
    CALL DoDelay(1)
    CALL Exhaust
    CALL ContinuePlaySong
   WEND
   CALL DoEnGoneActions
  END IF
END SELECT

CALL ShowPlayer
CALL InitLevel
CALL ShowLevel

GenData.NextLev = False

END SUB

SUB DoEnGoneActions

GenData.CurLevel = GenData.CurLevel + 1
CALL StopPlaySong
CALL PlaySong(OutpostSong$)
CALL StarOutpost(GenData.CurLevel - 1)
CALL StopPlaySong
CALL FancyCls(1)
CALL LaunchGame
CLS
CALL SetupScreen
CALL PlaySong(LevelSong$)

END SUB

SUB DoExplose (ShipNum)

SELECT CASE EShip(ShipNum).Count
 CASE 0, 1
  PUT (EShip(ShipNum).x, EShip(ShipNum).y), Explose1, PSET
  EShip(ShipNum).Count = EShip(ShipNum).Count + 1
 CASE 2, 3
  PUT (EShip(ShipNum).x, EShip(ShipNum).y), Explose2, PSET
  EShip(ShipNum).Count = EShip(ShipNum).Count + 1
 CASE 4, 5
  PUT (EShip(ShipNum).x, EShip(ShipNum).y), Explose3, PSET
  EShip(ShipNum).Count = EShip(ShipNum).Count + 1
 CASE 6, 7
  PUT (EShip(ShipNum).x, EShip(ShipNum).y), Explose4, PSET
  EShip(ShipNum).Count = EShip(ShipNum).Count + 1
END SELECT

IF EShip(ShipNum).Count = 8 THEN
 EShip(ShipNum).Count = 0
 LINE (EShip(ShipNum).x, EShip(ShipNum).y)-STEP(20, 20), 0, BF
END IF

END SUB

SUB DoShots

FOR i = 1 TO MaxEShots
 IF EShot(i).ShotOn = True THEN
  EShot(i).x = EShot(i).x - (GameData.Movement + 1)
 
  IF EShot(i).x <= 20 THEN
   EShot(i).ShotOn = False
   LINE (EShot(i).x + 3, EShot(i).y - 2)-STEP(5, 5), 0, BF
   GOTO Nei
  END IF
 
  LINE (EShot(i).x + 3, EShot(i).y - 2)-STEP(5, 5), 0, BF
  IF EShot(i).x > 10 AND EShot(i).y > 20 AND EShot(i).x < 300 AND EShot(i).y < 185 THEN
   SELECT CASE EShot(i).DataMark
    CASE 1
     PUT (EShot(i).x, EShot(i).y - 2), Shot1, PSET
    CASE 2
     PUT (EShot(i).x, EShot(i).y - 2), Shot2, PSET
    CASE 3
     PUT (EShot(i).x, EShot(i).y - 2), Shot3, PSET
    CASE 4
     PUT (EShot(i).x, EShot(i).y - 2), Shot4, PSET
    CASE 5
     PUT (EShot(i).x, EShot(i).y - 2), Shot4, PSET
   END SELECT
  END IF

  IF EShot(i).x <= Player.x + 14 AND EShot(i).y > Player.y - 2 AND EShot(i).y < Player.y + 20 THEN
   EShot(i).ShotOn = False
   LINE (EShot(i).x, EShot(i).y - 2)-STEP(7, 5), 0, BF
   CALL DamagePlayer(EShot(i).DataMark)
   PUT (Player.x, Player.y), Ship1, PSET
  END IF
 END IF

Nei:
NEXT i

FOR i = 1 TO MaxPShots
 IF PShot(i).ShotOn = True THEN
  PShot(i).x = PShot(i).x + GameData.Movement

  IF PShot(i).Ident = Missile THEN PShot(i).x = PShot(i).x + 1

  IF PShot(i).x >= 300 THEN
   PShot(i).ShotOn = False
   LINE (PShot(i).x - 4, PShot(i).y - 2)-STEP(5, 5), 0, BF
   GOTO Ni
  END IF

  IF PShot(i).x >= Player.x + 20 THEN
   LINE (PShot(i).x - 4, PShot(i).y - 2)-STEP(5, 5), 0, BF
  END IF
 
 
  SELECT CASE PShot(i).Ident
   CASE Laser
    SELECT CASE Player.ShotLev
     CASE 1
      PUT (PShot(i).x, PShot(i).y - 2), Shot1, PSET
     CASE 2
      PUT (PShot(i).x, PShot(i).y - 2), Shot2, PSET
     CASE 3
      PUT (PShot(i).x, PShot(i).y - 2), Shot3, PSET
     CASE 4
      PUT (PShot(i).x, PShot(i).y - 2), Shot4, PSET
    END SELECT
    CASE Spread
    CASE Missile
     PUT (PShot(i).x, PShot(i).y - 2), Missile1, PSET
    CASE Megabomb
  END SELECT

 END IF
Ni:
NEXT i
FOR j = 1 TO NumShips
 FOR k = 1 TO MaxPShots
  IF EShip(j).Hp > 0 AND PShot(k).ShotOn = True THEN
   IF PShot(k).y >= EShip(j).y AND PShot(k).y <= EShip(j).y + 20 THEN
    IF PShot(k).x + 5 >= EShip(j).x AND PShot(k).x + 15 <= EShip(j).x + 20 THEN
     PShot(k).ShotOn = False
     LINE (PShot(k).x - 3, PShot(k).y - 2)-STEP(7, 5), 0, BF
     SELECT CASE PShot(k).Ident
      CASE Laser
       EShip(j).Hp = EShip(j).Hp - Player.ShotLev
      CASE Spread
       EShip(j).Hp = EShip(j).Hp - Player.SpredLev
      CASE Missile
       EShip(j).Hp = EShip(j).Hp - 10
     END SELECT
    
     IF EShip(j).Hp <= 0 THEN
     
      CALL DoExplose(j)
    
      Comment = RndNum(11, 1, 1)
     
      SELECT CASE Comment
       CASE 1
	AddMessage "Kaboom!"
       CASE 2
	AddMessage "Got 'em!"
       CASE 3
	AddMessage "Splash 1!"
       CASE 4
	AddMessage "Shabang!"
       CASE 5
	AddMessage "Woohoo!"
       CASE 6
	AddMessage "Youch."
       CASE 7
	AddMessage "=:)"
       CASE 8
	AddMessage "Buhbye!"
       CASE 9
	AddMessage "Space junk!"
       CASE 10
	AddMessage "Take that!"
      END SELECT

      Player.Score = Player.Score + EShip(j).MaxHp
      Player.Kredits = Player.Kredits + EShip(j).MaxHp
     
      CALL ShowScore
      CALL CheckEnGone
     END IF
    END IF
   END IF
  END IF
 NEXT k
NEXT j

END SUB

SUB DoShotsStory

FOR i = 1 TO MaxPShots
 IF PShot(i).ShotOn = True THEN
  PShot(i).x = PShot(i).x + GameData.Movement

  IF PShot(i).Ident = Missile THEN PShot(i).x = PShot(i).x + 1

  IF PShot(i).x >= 300 THEN
   PShot(i).ShotOn = False
   LINE (PShot(i).x - 4, PShot(i).y - 2)-STEP(5, 5), 0, BF
   GOTO No
  END IF

  IF PShot(i).x >= Player.x + 20 THEN
   LINE (PShot(i).x - 4, PShot(i).y - 2)-STEP(5, 5), 0, BF
  END IF
 
  SELECT CASE PShot(i).Ident
   CASE Laser
    SELECT CASE Player.ShotLev
     CASE 1
      PUT (PShot(i).x, PShot(i).y - 2), Shot1, PSET
     CASE 2
      PUT (PShot(i).x, PShot(i).y - 2), Shot2, PSET
     CASE 3
      PUT (PShot(i).x, PShot(i).y - 2), Shot3, PSET
     CASE 4
      PUT (PShot(i).x, PShot(i).y - 2), Shot4, PSET
    END SELECT
    CASE Spread
    CASE Missile
     PUT (PShot(i).x, PShot(i).y - 2), Missile1, PSET
    CASE Megabomb
  END SELECT

 END IF
No:
NEXT i

END SUB

SUB DuringLevChoices

CALL Box(110, 80, 210, 120)

PutText2 "Resume Game", 167, -1, 88, 1, 1
PutText2 "Options", 31, -1, 96, 1, -1
PutText2 "Quit to Menu", 31, -1, 104, 1, -1

CurChoice = 1

DO
 kbd$ = INKEY$
 IF kbd$ <> "" THEN
  SELECT CASE kbd$
   CASE CHR$(0) + "H"
    CurChoice = CurChoice - 1
    IF CurChoice = 0 THEN CurChoice = 3
    CALL DuringLevShow(CurChoice)
   CASE CHR$(0) + "P"
    CurChoice = CurChoice + 1
    IF CurChoice = 4 THEN CurChoice = 1
    CALL DuringLevShow(CurChoice)
   CASE CHR$(13)
    SELECT CASE CurChoice
     CASE 1
      LINE (110, 80)-(210, 120), 0, BF
      EXIT SUB
     CASE 2
      SOUND 500, .5
     CASE 3
      CLS
      CALL StopPlaySong
      RESTORE LevelData
      CALL InitVars
      CALL InitStars
      CALL ClearShots
      CALL BeginGame
      EXIT SUB
    END SELECT
  END SELECT
 END IF

 CALL DoDelay(1)
 CALL ContinuePlaySong

LOOP

END SUB

SUB DuringLevShow (Choice)

SELECT CASE Choice
 CASE 1
  PutText2 "Resume Game", 167, -1, 88, 1, 1
  PutText2 "Options", 31, -1, 96, 1, -1
  PutText2 "Quit to Menu", 31, -1, 104, 1, -1
 CASE 2
  PutText2 "Resume Game", 31, -1, 88, 1, -1
  PutText2 "Options", 167, -1, 96, 1, 1
  PutText2 "Quit to Menu", 31, -1, 104, 1, -1
 CASE 3
  PutText2 "Resume Game", 31, -1, 88, 1, -1
  PutText2 "Options", 31, -1, 96, 1, -1
  PutText2 "Quit to Menu", 167, -1, 104, 1, 1
END SELECT

END SUB

SUB Exhaust

ExCount = ExCount + 1

IF ExCount = 5 THEN
 PUT (Player.x, Player.y + 7), Ex1, PSET
ELSEIF ExCount = 10 THEN
 PUT (Player.x, Player.y + 7), Ex2, PSET
ELSEIF ExCount = 15 THEN
 PUT (Player.x, Player.y + 7), Ex3, PSET
ELSEIF ExCount = 20 THEN
 PUT (Player.x, Player.y + 7), Ex4, PSET
ELSEIF ExCount = 25 THEN
 PUT (Player.x, Player.y + 7), Ex5, PSET
ELSEIF ExCount = 30 THEN
 PUT (Player.x, Player.y + 7), Ex6, PSET
 ExCount = 5
END IF

END SUB

SUB FancyCls (Index)

SELECT CASE Index ' 168
 CASE 1
  FOR i = 334 TO 1 STEP -1
   CIRCLE (160, 100), i, 0, , , 2
   CALL DoDelay(1)
  NEXT i
  PSET (160, 100), ClsColour
END SELECT

END SUB

FUNCTION Fixed$ (Num)

Fixed$ = LTRIM$(RTRIM$(STR$(Num)))

END FUNCTION

SUB FmpadLPort (AdressReg, BData)

DEF SEG = VARSEG(AdlPortAsm(0))
p1 = &H389
p2 = &H388
p3 = BData
p4 = AdressReg
CALL ABSOLUTE(p1, p2, p3, p4, 0)
DEF SEG

END SUB

SUB FmpInit

RESTORE KeyData
Index = 0
GOTO FMPINITskip0
DO
KeyB(Index).FLow = a
KeyB(Index).FHi = B
KeyB(Index).FOct = c
KeyB(Index).Location = d
Index = Index + 1
FMPINITskip0:
READ a, B, c, d
LOOP UNTIL a = -1
TotalKeys = Index
RESTORE AdlPortData
DEF SEG = VARSEG(AdlPortAsm(0))
i = VARPTR(AdlPortAsm(0))
GOTO FMPINITskip1
DO
POKE i, Q
i = i + 1
FMPINITskip1:
READ Q
LOOP UNTIL Q = -1
DEF SEG

END SUB

SUB FmpPlayStart (PFileName$)

DEF SEG = VARSEG(PlayBuffer&(0))
BLOAD PFileName$, 0
DEF SEG
poffset& = 0
psegment& = VARSEG(PlayBuffer&(0))
FOR n = 0 TO 244: FmpadLPort n, 0: NEXT
FmpadLPort 1, 32
DEF SEG = psegment&
byte = PEEK(0 + poffset&)
basead = &H20
FmpadLPort basead + 0, byte
FmpadLPort basead + 1, byte
FmpadLPort basead + 2, byte
FmpadLPort basead + 8, byte
FmpadLPort basead + 9, byte
FmpadLPort basead + 10, byte
FmpadLPort basead + 16, byte
FmpadLPort basead + 17, byte
FmpadLPort basead + 18, byte
DEF SEG = psegment&
byte = PEEK(1 + poffset&)
basead = &H20
FmpadLPort basead + 3, byte
FmpadLPort basead + 4, byte
FmpadLPort basead + 5, byte
FmpadLPort basead + 11, byte
FmpadLPort basead + 12, byte
FmpadLPort basead + 13, byte
FmpadLPort basead + 19, byte
FmpadLPort basead + 20, byte
FmpadLPort basead + 21, byte
DEF SEG = psegment&
byte = PEEK(2 + poffset&)
basead = &H40
FmpadLPort basead + 0, byte
FmpadLPort basead + 1, byte
FmpadLPort basead + 2, byte
FmpadLPort basead + 8, byte
FmpadLPort basead + 9, byte
FmpadLPort basead + 10, byte
FmpadLPort basead + 16, byte
FmpadLPort basead + 17, byte
FmpadLPort basead + 18, byte
DEF SEG = psegment&
byte = PEEK(3 + poffset&)
basead = &H40
FmpadLPort basead + 3, byte
FmpadLPort basead + 4, byte
FmpadLPort basead + 5, byte
FmpadLPort basead + 11, byte
FmpadLPort basead + 12, byte
FmpadLPort basead + 13, byte
FmpadLPort basead + 19, byte
FmpadLPort basead + 20, byte
FmpadLPort basead + 21, byte
DEF SEG = psegment&
byte = PEEK(4 + poffset&)
basead = &H60
FmpadLPort basead + 0, byte
FmpadLPort basead + 1, byte
FmpadLPort basead + 2, byte
FmpadLPort basead + 8, byte
FmpadLPort basead + 9, byte
FmpadLPort basead + 10, byte
FmpadLPort basead + 16, byte
FmpadLPort basead + 17, byte
FmpadLPort basead + 18, byte
DEF SEG = psegment&
byte = PEEK(5 + poffset&)
basead = &H60
FmpadLPort basead + 3, byte
FmpadLPort basead + 4, byte
FmpadLPort basead + 5, byte
FmpadLPort basead + 11, byte
FmpadLPort basead + 12, byte
FmpadLPort basead + 13, byte
FmpadLPort basead + 19, byte
FmpadLPort basead + 20, byte
FmpadLPort basead + 21, byte
DEF SEG = psegment&
byte = PEEK(6 + poffset&)
basead = &H80
FmpadLPort basead + 0, byte
FmpadLPort basead + 1, byte
FmpadLPort basead + 2, byte
FmpadLPort basead + 8, byte
FmpadLPort basead + 9, byte
FmpadLPort basead + 10, byte
FmpadLPort basead + 16, byte
FmpadLPort basead + 17, byte
FmpadLPort basead + 18, byte
DEF SEG = psegment&
byte = PEEK(7 + poffset&)
basead = &H80
FmpadLPort basead + 3, byte
FmpadLPort basead + 4, byte
FmpadLPort basead + 5, byte
FmpadLPort basead + 11, byte
FmpadLPort basead + 12, byte
FmpadLPort basead + 13, byte
FmpadLPort basead + 19, byte
FmpadLPort basead + 20, byte
FmpadLPort basead + 21, byte
DEF SEG = psegment&
byte = PEEK(8 + poffset&)
basead = &HE0
FmpadLPort basead + 0, byte
FmpadLPort basead + 1, byte
FmpadLPort basead + 2, byte
FmpadLPort basead + 8, byte
FmpadLPort basead + 9, byte
FmpadLPort basead + 10, byte
FmpadLPort basead + 16, byte
FmpadLPort basead + 17, byte
FmpadLPort basead + 18, byte
DEF SEG = psegment&
byte = PEEK(9 + poffset&)
basead = &HE0
FmpadLPort basead + 3, byte
FmpadLPort basead + 4, byte
FmpadLPort basead + 5, byte
FmpadLPort basead + 11, byte
FmpadLPort basead + 12, byte
FmpadLPort basead + 13, byte
FmpadLPort basead + 19, byte
FmpadLPort basead + 20, byte
FmpadLPort basead + 21, byte
DEF SEG = psegment&
byte = PEEK(10 + poffset&)
basead = &HC0
FmpadLPort basead, byte
FmpadLPort basead + 1, byte
FmpadLPort basead + 2, byte
FmpadLPort basead + 3, byte
FmpadLPort basead + 4, byte
FmpadLPort basead + 5, byte
FmpadLPort basead + 6, byte
FmpadLPort basead + 7, byte
FmpadLPort basead + 8, byte
DEF SEG
DEF SEG = VARSEG(PlayBuffer&(0))
Transpose = PEEK(11) - 4
DEF SEG
IF Transpose < -4 THEN Transpose = -4
IF Transpose > 1 THEN Transpose = 1
PlayMode = 1
KeyIndex& = 0
PlayDelayCounter& = 0
PlayBufferIndex& = 16
IF PlayBuffer&(3) = 0 THEN StopPlaySong

END SUB

SUB InitLevel

CALL ClearShots
CALL ShowPlayer

READ NumShips

'IF NumShips = 100 THEN
' READ BossType
' EXIT SUB
'END IF

FOR i = 1 TO NumShips
 READ EShip(i).ShipType
 EShip(i).x = RndNum(300, 260, 1)
 EShip(i).y = RndNum(167, 51, 1)
 SELECT CASE EShip(i).ShipType
  CASE 1
   EShip(i).XAdj = -2
   EShip(i).YAdj = 1
   EShip(i).Hp = 1
   EShip(i).MaxHp = 1
  CASE 2
   EShip(i).XAdj = -1
   EShip(i).YAdj = 2
   EShip(i).Hp = 2
   EShip(i).MaxHp = 2
  CASE 3
   EShip(i).XAdj = -3
   EShip(i).YAdj = 0
   EShip(i).Hp = 3
   EShip(i).MaxHp = 3
  CASE 4
   EShip(i).XAdj = 0
   EShip(i).YAdj = 3
   EShip(i).Hp = 3
   EShip(i).MaxHp = 3
  CASE 5
   EShip(i).XAdj = -5
   EShip(i).YAdj = 0
   EShip(i).Hp = 100
   EShip(i).MaxHp = 100

 END SELECT
NEXT i

CALL ShowWave

END SUB

SUB InitStars

FOR i = 1 TO Stars
 StarStyle = RndNum(5, 1, 1)
 SELECT CASE StarStyle
  CASE 1
   Star(i).Speed = 7
    Star(i).Colour = 30
    Star(i).x = RndNum(309, 10, 1)
    Star(i).y = RndNum(190, 50, 1)
   CASE 2
    Star(i).Speed = 5
    Star(i).Colour = 25
    Star(i).x = RndNum(309, 10, 1)
    Star(i).y = RndNum(190, 50, 1)
   CASE 3
    Star(i).Speed = 2
    Star(i).Colour = 20
    Star(i).x = RndNum(309, 10, 1)
    Star(i).y = RndNum(190, 50, 1)
   CASE 4
    Star(i).Speed = 1
    Star(i).Colour = 17
    Star(i).x = RndNum(309, 10, 1)
    Star(i).y = RndNum(190, 50, 1)
 END SELECT
NEXT i

END SUB

SUB InitStuff

RANDOMIZE TIMER

CALL LoadFont
CALL IntroScreen

END SUB

SUB InitVars

' Undefined variables: DemoShip.BaseX, DemoShip.BaseY

Colour.Main = 15
Colour.Shadow = 7
Colour.Message = 15
Colour.Outer = 166
Colour.Middle = 167
Colour.Inner = 169
Colour.Bg = 16
Colour.Las1 = 250
Colour.Hilight = 124

Player.x = 20
Player.y = 90
Player.Lives = 3
Player.MaxHp = 15
Player.Hp = 15
Player.ShotLev = 1
Player.Weapon = Laser
Player.Missiles = 20
Player.Megabomb = 1
Player.Kredits = 0
Player.Score = 0

GameData.Movement = 3
GameData.Action = False
GameData.LevelOn = 1
'GameData.MusicOp = True           ' Defined in main section so value remains
'GameData.SoundOp = False          ' constant.

Menu$(1) = " Launch"
Menu$(2) = "   Load"
Menu$(3) = "  Story"
Menu$(4) = "  About"
Menu$(5) = "Options"
Menu$(6) = "   Quit"

DemoShip.ORadius = 25
DemoShip.Oldx = 190
DemoShip.Oldy = 99

GenData.CurLevel = 1

FOR i = 1 TO MaxPShots
 PShot(i).ShotOn = False
NEXT i

RESTORE LevelData

END SUB

SUB IntroScreen

SCREEN 13

SHELL "pload " + TileDir$ + "\mainscrn.pal"
BLOAD TileDir$ + "\mainscrn.mdi"

PutText "Loading...", 184, -1, 180, 1

CALL InitVars
CALL LoadTiles
CALL InitStars
CALL FmpInit
CALL PlaySong(LevelSong$)

LINE (0, 180)-STEP(320, 8), 0, BF
PutText "Done. Press any key.", 184, -1, 180, 1

CALL WaitKey

CALL FancyCls(1)
CALL SetupPalette
CALL BeginGame

END SUB

SUB LaunchGame

CALL SetFrame(True)

PUT (50, 140), Everik, PSET
PUT (80, 120), Therces, PSET

FOR i = 1 TO Stars
 x = RndNum(319, 0, 1)
 y = RndNum(199, 0, 1)
 IF POINT(x, y) = 0 THEN
  SELECT CASE RndNum(5, 1, 1)
   CASE 1
    PSET (x, y), 17
   CASE 2
    PSET (x, y), 20
   CASE 3
    PSET (x, y), 25
   CASE 4
    PSET (x, y), 30
  END SELECT
 END IF
NEXT i

SELECT CASE GenData.CurLevel
 CASE 1
  DemoShip.Basex = 60
  DemoShip.Basey = 150
  GenData.LevCol = 174
  PutText2 "Everik, an ocean planet with a C3 atmosphere,", 31, 24, 24, 1, -1
  PutText2 "making it a very valuable trading outpost in", 31, 24, 32, 1, -1
  PutText2 "this sector. 40 Alik fleets are headed to", 31, 24, 40, 1, -1
  PutText2 "Everik even as we speak. They hope to seize", 31, 24, 48, 1, -1
  PutText2 "control, and essentially hold us at gunpoint.", 31, 24, 56, 1, -1
  PutText2 "You must intercept them. Fly like a bat out of", 31, 24, 64, 1, -1
  PutText2 "hell to make contact on time. Do it for the", 31, 24, 72, 1, -1
  PutText2 "empire, do it for Betan... well, maybe not so", 31, 24, 80, 1, -1
  PutText2 "much Betan, but you get the idea. Just... well", 31, 24, 88, 1, -1
  PutText2 "        try... but dammit don't fail ! Please!", 31, 24, 96, 1, -1
  PutText2 "              You are the last of the Imperial", 31, 24, 104, 1, -1
  PutText2 "                                     fighters!", 31, 24, 112, 1, -1
  PutText2 "                            [ End of Message ]", 31, 24, 120, 1, -1

 CASE 2
  DemoShip.Basex = 80
  DemoShip.Basey = 120
  DemoShip.ORadius = 15
  GenData.LevCol = 70
  PutText2 "We just may have a decent chance with the time", 31, 24, 24, 1, -1
  PutText2 "you have bought us, all is not lost... for the", 31, 24, 32, 1, -1
  PutText2 "moment. There is a star outpost in this sector", 31, 24, 40, 1, -1
  PutText2 "it is Gamma 7, where you weill be able to make", 31, 24, 48, 1, -1
  PutText2 "some repairs and upgrades that will help you", 31, 24, 56, 1, -1
  PutText2 "with your battle. Good luck, and may you take", 31, 24, 64, 1, -1
  PutText2 "the Empire into it's destiny.", 31, 24, 72, 1, -1
  PutText2 "                            [ End of Message ]", 31, 24, 80, 1, -1
 CASE 3
  DemoShip.Basex = 65
  DemoShip.Basey = 155
  DemoShip.ORadius = 15
  GenData.LevCol = 200
  PutText2 "They've assembled a force around the moon of", 31, 24, 24, 1, -1
  PutText2 "Everik! They'll destroy us all if you don't", 31, 24, 32, 1, -1
  PutText2 "come to our aid! Please, please hurry!", 31, 24, 40, 1, -1
  PutText2 "                            [ End of Message ]", 31, 24, 48, 1, -1
CASE 4
  DemoShip.Basex = 160
  DemoShip.Basey = 100
  DemoShip.ORadius = 70
  GenData.LevCol = 167
  PutText2 "You did it! You saved us! You shall forever", 31, 24, 24, 1, -1
  PutText2 "be a figure in the history of our world.", 31, 24, 32, 1, -1
  PutText2 "Although, you need a well earned vacation.", 31, 24, 40, 1, -1
  PutText2 "See ya round.", 31, 24, 48, 1, -1
  PutText2 "                            [ End of Message ]", 31, 24, 56, 1, -1
  WHILE INKEY$ <> CHR$(13)
  WEND
  CLS
  CALL SetFrame(True)
  PutText2 "To:", 167, 24, 24, 1, 1
  PutText2 "    Person that beat the game...", 31, 24, 24, 1, -1
  PutText2 "From:", 167, 24, 32, 1, 1
  PutText2 "      Neo", 31, 24, 32, 1, -1
  PutText2 "Subject:", 167, 24, 40, 1, 1
  PutText2 "         So you beat the game...", 31, 24, 40, 1, -1
  PutText2 " Good job, BUT... this was just my practice.", 31, 24, 56, 1, -1
  PutText2 "I've made few space shooters before, (I", 31, 24, 64, 1, -1
  PutText2 "hope you haven't seen them) :)... heh, but", 31, 24, 72, 1, -1
  PutText2 "this one isn't too bad. It could be better", 31, 24, 80, 1, -1
  PutText2 "though, which is why there will definitely", 31, 24, 88, 1, -1
  PutText2 "be a sequel. :) Don't worry, I'll keep ya", 31, 24, 96, 1, -1
  PutText2 "posted.", 31, 24, 104, 1, -1
  CALL WaitKey
  CALL FancyCls(1)
  END

END SELECT

DO
 kbd$ = INKEY$
 IF kbd$ <> "" THEN
  SELECT CASE kbd$
   CASE CHR$(13)
    EXIT DO
  END SELECT
 END IF

 DemoShip.Angle = DemoShip.Angle + 1
 IF DemoShip.Angle = 360 THEN DemoShip.Angle = 0

 Theta! = DemoShip.Angle * (Pi / 180)

 DemoShip.x = DemoShip.Basex + DemoShip.ORadius * COS(Theta!)
 DemoShip.y = DemoShip.Basey - DemoShip.ORadius * SIN(Theta!)

 PSET (DemoShip.Oldx, DemoShip.Oldy), TempCol
 TempCol = POINT(DemoShip.x, DemoShip.y)

 PSET (DemoShip.x, DemoShip.y), GenData.LevCol

 DemoShip.Oldx = DemoShip.x
 DemoShip.Oldy = DemoShip.y

 CALL DoDelay(1)

LOOP

END SUB

SUB LoadBookMark

CALL SetFrame(False)

PutText2 "Load Bookmark", 31, -1, 16, 2, -1

CurChoice = 1
CALL BookmarkExtra
CALL BookmarkShowChoice(CurChoice)
CALL BookmarkShow

DO
 kbd$ = INKEY$
 IF kbd$ <> "" THEN
  SELECT CASE kbd$
   CASE CHR$(0) + "H"
    CurChoice = CurChoice - 1
    IF CurChoice = 0 THEN CurChoice = 5
    CALL BookmarkShowChoice(CurChoice)
   CASE CHR$(0) + "P"
    CurChoice = CurChoice + 1
    IF CurChoice = 6 THEN CurChoice = 1
    CALL BookmarkShowChoice(CurChoice)
   CASE CHR$(27)
    CurChoice = 5
    CALL BookmarkShowChoice(CurChoice)
   CASE CHR$(13)
    SELECT CASE CurChoice
     CASE 1 TO 4
      OPEN "imperial.sv" + Fixed$(CurChoice) FOR INPUT AS #1
      INPUT #1, GameData.LevelOn, GenData.CurLevel, Player.Lives, Player.MaxHp, Player.Hp, Player.ShotLev, Player.Weapon, Player.Missiles, Player.Megabomb, Player.Kredits, Player.Score, ViewMode
      CLOSE
     
      SELECT CASE GenData.CurLevel
       CASE 2
	RESTORE Sector2
       CASE 3
	RESTORE Sector3
      END SELECT
     
      CALL LaunchGame
      CALL PlaySong(LevelSong$)
      CLS
      CALL SetupScreen
      EXIT SUB

     CASE 5
      CALL BeginGame
      EXIT SUB
    END SELECT
  END SELECT
 END IF
LOOP


END SUB

SUB LoadFont

OPEN "fontdata.dat" FOR INPUT AS #1

FOR i = 1 TO 126
 FOR j = 1 TO 8
  FOR k = 1 TO 6
   INPUT #1, CharSet(i, j, k)
  NEXT k
 NEXT j
NEXT i

CLOSE

END SUB

SUB LoadTiles

CHDIR TileDir$

DEF SEG = VARSEG(Ship1(0)): BLOAD "ship1.mdt", VARPTR(Ship1(0))
DEF SEG = VARSEG(EShip1(0)): BLOAD "eship1.mdt", VARPTR(EShip1(0))
DEF SEG = VARSEG(EShip2(0)): BLOAD "eship2.mdt", VARPTR(EShip2(0))
DEF SEG = VARSEG(EShip3(0)): BLOAD "eship3.mdt", VARPTR(EShip3(0))
DEF SEG = VARSEG(EShip4(0)): BLOAD "eship4.mdt", VARPTR(EShip4(0))
DEF SEG = VARSEG(EShip5(0)): BLOAD "eship5.mdt", VARPTR(EShip5(0))
DEF SEG = VARSEG(Shot1(0)): BLOAD "shot1.mdt", VARPTR(Shot1(0))
DEF SEG = VARSEG(Shot2(0)): BLOAD "shot2.mdt", VARPTR(Shot2(0))
DEF SEG = VARSEG(Shot3(0)): BLOAD "shot3.mdt", VARPTR(Shot3(0))
DEF SEG = VARSEG(Shot4(0)): BLOAD "shot4.mdt", VARPTR(Shot4(0))
DEF SEG = VARSEG(Urb(0)): BLOAD "urb.mdt", VARPTR(Urb(0))
DEF SEG = VARSEG(Ulb(0)): BLOAD "ulb.mdt", VARPTR(Ulb(0))
DEF SEG = VARSEG(Lrb(0)): BLOAD "lrb.mdt", VARPTR(Lrb(0))
DEF SEG = VARSEG(Llb(0)): BLOAD "llb.mdt", VARPTR(Llb(0))
DEF SEG = VARSEG(UpBox(0)): BLOAD "bdown.mdt", VARPTR(UpBox(0))
DEF SEG = VARSEG(DownBox(0)): BLOAD "bup.mdt", VARPTR(DownBox(0))
DEF SEG = VARSEG(RightBox(0)): BLOAD "bleft.mdt", VARPTR(RightBox(0))
DEF SEG = VARSEG(LeftBox(0)): BLOAD "bright.mdt", VARPTR(LeftBox(0))
DEF SEG = VARSEG(Ur(0)): BLOAD "ur.mdt", VARPTR(Ur(0))
DEF SEG = VARSEG(Ul(0)): BLOAD "ul.mdt", VARPTR(Ul(0))
DEF SEG = VARSEG(Lr(0)): BLOAD "lr.mdt", VARPTR(Lr(0))
DEF SEG = VARSEG(Ll(0)): BLOAD "ll.mdt", VARPTR(Ll(0))
DEF SEG = VARSEG(Ex1(0)): BLOAD "ex1.mdt", VARPTR(Ex1(0))
DEF SEG = VARSEG(Ex2(0)): BLOAD "ex2.mdt", VARPTR(Ex2(0))
DEF SEG = VARSEG(Ex3(0)): BLOAD "ex3.mdt", VARPTR(Ex3(0))
DEF SEG = VARSEG(Ex4(0)): BLOAD "ex4.mdt", VARPTR(Ex4(0))
DEF SEG = VARSEG(Ex5(0)): BLOAD "ex5.mdt", VARPTR(Ex5(0))
DEF SEG = VARSEG(Ex6(0)): BLOAD "ex6.mdt", VARPTR(Ex6(0))
DEF SEG = VARSEG(Everik(0)): BLOAD "everik.mdt", VARPTR(Everik(0))
DEF SEG = VARSEG(Therces(0)): BLOAD "therces.mdt", VARPTR(Therces(0))
DEF SEG = VARSEG(Laser1P(0)): BLOAD "_las1.mdt", VARPTR(Laser1P(0))
DEF SEG = VARSEG(Laser2P(0)): BLOAD "_las2.mdt", VARPTR(Laser2P(0))
DEF SEG = VARSEG(Laser3P(0)): BLOAD "_las3.mdt", VARPTR(Laser3P(0))
DEF SEG = VARSEG(Laser4P(0)): BLOAD "_las4.mdt", VARPTR(Laser4P(0))
DEF SEG = VARSEG(LaserNs(0)): BLOAD "_lasns.mdt", VARPTR(LaserNs(0))
DEF SEG = VARSEG(Spread1P(0)): BLOAD "_spread1.mdt", VARPTR(Spread1P(0))
DEF SEG = VARSEG(Spread2P(0)): BLOAD "_spread2.mdt", VARPTR(Spread2P(0))
DEF SEG = VARSEG(Spread1Ns(0)): BLOAD "_spred1n.mdt", VARPTR(Spread1Ns(0))
DEF SEG = VARSEG(Spread2Ns(0)): BLOAD "_spred2n.mdt", VARPTR(Spread2Ns(0))
DEF SEG = VARSEG(MissileP(0)): BLOAD "_missile.mdt", VARPTR(MissileP(0))
DEF SEG = VARSEG(MissileNs(0)): BLOAD "_missns.mdt", VARPTR(MissileNs(0))
DEF SEG = VARSEG(MegaBombP(0)): BLOAD "_megbomb.mdt", VARPTR(MegaBombP(0))
DEF SEG = VARSEG(MegaBombNs(0)): BLOAD "_megbomn.mdt", VARPTR(MegaBombNs(0))
DEF SEG = VARSEG(Missile1(0)): BLOAD "mis01.mdt", VARPTR(Missile1(0))
DEF SEG = VARSEG(Explose1(0)): BLOAD "explose1.mdt", VARPTR(Explose1(0))
DEF SEG = VARSEG(Explose2(0)): BLOAD "explose2.mdt", VARPTR(Explose2(0))
DEF SEG = VARSEG(Explose3(0)): BLOAD "explose3.mdt", VARPTR(Explose3(0))
DEF SEG = VARSEG(Explose4(0)): BLOAD "explose4.mdt", VARPTR(Explose4(0))

CHDIR ".."

END SUB

SUB MoveDown

Player.y = Player.y + GameData.Movement

IF Player.y > 168 THEN
 Player.y = Player.y - GameData.Movement
 YAd = 0
END IF

LINE (Player.x, Player.y - GameData.Movement)-STEP(14, GameData.Movement), 0, BF

CALL ShowPlayer

END SUB

SUB MoveUp

Player.y = Player.y - GameData.Movement

IF Player.y < 51 THEN
 Player.y = Player.y + GameData.Movement
 YAd = 0
END IF

LINE (Player.x, Player.y + 16)-STEP(14, GameData.Movement), 0, BF

CALL ShowPlayer

END SUB

SUB Options

CALL SetFrame(True)

PutText2 "Options", 31, -1, 16, 2, -1

CurChoice = 1

CALL ShowOptionsChoice(CurChoice)
CALL ShowOptionStatus

DO
 kbd$ = INKEY$
 IF kbd$ <> "" THEN
  SELECT CASE kbd$
   CASE CHR$(0) + "H"
    CurChoice = CurChoice - 1
    IF CurChoice = 0 THEN CurChoice = 4
    CALL ShowOptionsChoice(CurChoice)
   CASE CHR$(0) + "P"
    CurChoice = CurChoice + 1
    IF CurChoice = 5 THEN CurChoice = 1
    CALL ShowOptionsChoice(CurChoice)
   CASE CHR$(27)
    CurChoice = 4
    CALL ShowOptionsChoice(CurChoice)
   CASE CHR$(13)
    SELECT CASE CurChoice
     CASE 1
      IF GameData.MusicOp = True THEN GameData.MusicOp = False ELSE IF GameData.MusicOp = False THEN GameData.MusicOp = True
      CALL ShowOptionStatus
     CASE 2
      IF GameData.SoundOp = True THEN GameData.SoundOp = False ELSE IF GameData.SoundOp = False THEN GameData.SoundOp = True
      CALL ShowOptionStatus
     CASE 3
      IF ViewMode = 0 THEN ViewMode = 1 ELSE IF ViewMode = 1 THEN ViewMode = 0
      CALL ShowOptionStatus
     CASE 4
      EXIT SUB
    END SELECT
  END SELECT
 END IF
LOOP

END SUB

SUB PlayerDead

CALL StopPlaySong

CALL ClearShots
CALL SetFrame(True)
CALL InitStars
CALL InitVars

PutText2 "Uh oh. Looks like you just lost any chance of", 31, 24, 24, 1, -1
PutText2 "survival for the Empire. Do ya know what that", 31, 24, 32, 1, -1
PutText2 "means? It means that the universe is doomed.", 31, 24, 40, 1, -1
PutText2 "Good job. Thanks a lot for screwing it up for", 31, 24, 48, 1, -1
PutText2 "everyone else. I hope you're happy with what", 31, 24, 56, 1, -1
PutText2 "you've done.", 31, 24, 64, 1, -1
CALL WaitKey

CALL BeginGame

END SUB

SUB PlayerShot

FOR i = 1 TO MaxPShots
 IF PShot(i).ShotOn = False THEN
  EXIT FOR
 END IF
 IF i = MaxPShots THEN EXIT SUB
NEXT i

PShot(i).ShotOn = True
PShot(i).x = Player.x + 15
PShot(i).y = Player.y + 8

SELECT CASE Player.Weapon
 CASE Laser
  PShot(i).Ident = Laser
 CASE Spread
  PShot(i).Ident = Spread
 CASE Missile
  Player.Missiles = Player.Missiles - 1
  CALL ShowSpecialCount
  PShot(i).Ident = Missile
  IF Player.Missiles = 0 THEN
   Player.Weapon = Laser
   CALL ShowWeapon
  END IF
 CASE Megabomb
  Player.Megabomb = Player.Megabomb - 1
  CALL ShowSpecialCount

  PShot(i).Ident = Megabomb
 
  IF Player.Megabomb = 0 THEN
   Player.Weapon = Laser
   CALL ShowWeapon
  END IF
 
  CALL ClearShots
 
  FOR i = 1 TO NumShips
   IF EShip(i).Hp <> 0 THEN CALL DoExplose(i)
  NEXT i
 
  FOR i = 1 TO NumShips
   EShip(i).Hp = 0
  NEXT i
 
  FOR i = 1 TO 7
   CALL DoEnemies
   CALL DoDelay(1)
  NEXT i
 
  CALL CheckEnGone

END SELECT

END SUB

SUB PlaySong (PFileName$)

CurrentSong$ = PFileName$

FOR i = 0 TO 244
 FmpadLPort i, 0
NEXT i

FOR i = 0 TO TotalVoices - 1
 Voice(i).InUse = 0
 Voice(i).Delay = 0
NEXT i

FOR i = 0 TO 127
 KBMatrix(i) = 0
NEXT i

CALL FmpPlayStart(PFileName$)

END SUB

SUB PutText (Text$, c, XCoordinate, YCoordinate, Size)

YCoordinate = INT(YCoordinate / Size)

IF XCoordinate = -1 THEN XCoordinate = 160 - (LEN(Text$) * 3 * Size)

StartX = XCoordinate

FOR i = 1 TO LEN(Text$)
 B$ = MID$(Text$, i, 1)
 a = ASC(B$)
 FOR j = 1 TO 8
  FOR k = 1 TO 6
   SELECT CASE CharSet(a, j, k)
    CASE 0
     Col = 0
    CASE 1
     Col = c
   END SELECT

   IF Col <> 0 THEN
    LINE (StartX + PixelsRight, (j + YCoordinate) * Size)-(StartX + PixelsRight + (Size - 1), ((j + YCoordinate) * Size) + (Size - 1)), Col, BF
   END IF

   StartX = StartX + Size

  NEXT k

  StartX = XCoordinate

 NEXT j

 PixelsRight = PixelsRight + (6 * Size)

NEXT i

END SUB

SUB PutText2 (Text$, c, XCoordinate, YCoordinate, Size, Slide)

YCoordinate = INT(YCoordinate / Size)

IF XCoordinate = -1 THEN XCoordinate = 160 - (LEN(Text$) * 3 * Size)

OrigC = c

StartX = XCoordinate

FOR i = 1 TO LEN(Text$)
 B$ = MID$(Text$, i, 1)
 a = ASC(B$)
 FOR j = 1 TO 8

  c = c + Slide

  FOR k = 1 TO 6
   SELECT CASE CharSet(a, j, k)
    CASE 0
     Col = 0
    CASE 1
     Col = c
   END SELECT

   IF Col <> 0 THEN
    LINE (StartX + PixelsRight, (j + YCoordinate) * Size)-(StartX + PixelsRight + (Size - 1), ((j + YCoordinate) * Size) + (Size - 1)), Col, BF
   END IF

   StartX = StartX + Size

  NEXT k

  StartX = XCoordinate

 NEXT j

 PixelsRight = PixelsRight + (6 * Size)

c = OrigC

NEXT i

END SUB

FUNCTION RndNum (Max, Min, Mult)

DO
 Num = INT(RND * (Max - Min)) + Min
LOOP UNTIL Num / Mult = INT(Num / Mult)

RndNum = Num

END FUNCTION

SUB SaveBookmark

CALL SetFrame(False)
PutText2 "Save Bookmark", 31, -1, 16, 2, -1

CurChoice = 1

CALL BookmarkShowChoice(CurChoice)
CALL BookmarkExtra
CALL BookmarkShow
DO
 kbd$ = INKEY$
 IF kbd$ <> "" THEN
  SELECT CASE kbd$
   CASE CHR$(0) + "H"
    CurChoice = CurChoice - 1
    IF CurChoice = 0 THEN CurChoice = 5
    CALL BookmarkShowChoice(CurChoice)
   CASE CHR$(0) + "P"
    CurChoice = CurChoice + 1
    IF CurChoice = 6 THEN CurChoice = 1
    CALL BookmarkShowChoice(CurChoice)
   CASE CHR$(27)
    CurChoice = 5
    CALL BookmarkShowChoice(CurChoice)
   CASE CHR$(13)
    SELECT CASE CurChoice
     CASE 1 TO 4
      OPEN "imperial.sv" + Fixed$(CurChoice) FOR OUTPUT AS #1
      PRINT #1, Fixed$(GameData.LevelOn); ","; Fixed$(GenData.CurLevel); ","; Fixed$(Player.Lives); ","; Fixed$(Player.MaxHp); ","; Fixed$(Player.Hp); ","; Fixed$(Player.ShotLev); ","; Fixed$(Player.Weapon); ","; Fixed$(Player.Missiles); ",";  _
Fixed$(Player.Megabomb); ","; Fixed$(Player.Kredits); ","; Fixed$(CINT(Player.Score)); ","; Fixed$(ViewMode)
      CLOSE
      CALL Box(107, 87, 212, 113)
      PutText2 "Bookmark Saved", 31, -1, 96, 1, -1
      DO
       kbd$ = INKEY$
       CALL DoDelay(1)
       CALL ContinuePlaySong
      LOOP WHILE kbd$ = ""
      EXIT SUB
     CASE 5
      EXIT SUB
    END SELECT
  END SELECT
 END IF

 CALL DoDelay(1)
 CALL ContinuePlaySong

LOOP

END SUB

SUB SetFrame (ShowStar)

CLS

FOR i = 1 TO 15
 PUT (i * 20, 0), UpBox, PSET
 PUT (i * 20, 180), DownBox, PSET
NEXT i

FOR i = 1 TO 8
 PUT (0, i * 20), LeftBox, PSET
 PUT (300, i * 20), RightBox, PSET
NEXT i

PUT (0, 180), Llb, PSET
PUT (300, 180), Lrb, PSET
PUT (0, 0), Ulb, PSET
PUT (300, 0), Urb, PSET

IF ShowStar = True THEN CALL ShowStars

END SUB

SUB SetupPalette

DEF SEG = VARSEG(Pal(0))

BLOAD "imperial.pal", 0
i = 0
FOR c = 0 TO 255
 OUT &H3C8, c
 OUT &H3C9, PEEK(i)
 OUT &H3C9, PEEK(i + 1)
 OUT &H3C9, PEEK(i + 2)
 i = i + 4
NEXT

DEF SEG

END SUB

SUB SetupScreen

PUT (0, 0), Ulb, PSET
PUT (20, 0), UpBox, PSET
PUT (40, 0), UpBox, PSET
PUT (60, 0), UpBox, PSET
PUT (80, 0), Urb, PSET
PUT (100, 0), Ulb, PSET
PUT (120, 0), UpBox, PSET
PUT (300, 0), Urb, PSET

PUT (0, 20), Llb, PSET
PUT (20, 20), DownBox, PSET
PUT (40, 20), DownBox, PSET
PUT (60, 20), DownBox, PSET
PUT (80, 20), Lrb, PSET
PUT (100, 20), Llb, PSET
PUT (120, 20), DownBox, PSET
PUT (300, 20), Lrb, PSET

FOR i = 7 TO 14
 PUT (i * 20, 0), UpBox, PSET
 PUT (i * 20, 20), DownBox, PSET
NEXT i

FOR i = 1 TO 15
 PUT (i * 20, 40), UpBox, PSET
NEXT i

IF ViewMode = 1 THEN
 PUT (0, 40), Ulb, PSET
 PUT (0, 180), Llb, PSET
 PUT (300, 180), Lrb, PSET

 FOR i = 1 TO 15
  PUT (i * 20, 180), DownBox, PSET
 NEXT i

 FOR i = 3 TO 8
  PUT (0, i * 20), LeftBox, PSET
 NEXT i

ELSEIF ViewMode = 0 THEN
 PUT (0, 40), UpBox, PSET

END IF

AddMessage "Systems go"

PutText "Score:", Colour.Shadow, 112, 13, 1
PutText "Score:", Colour.Main, 112, 12, 1
PutText " Wave:", Colour.Shadow, 112, 21, 1
PutText " Wave:", Colour.Main, 112, 20, 1

LINE (6, 35)-STEP(0, 9), 164
LINE (6, 35)-STEP(198, 0), 164
LINE (204, 35)-STEP(0, 9), 172
LINE (6, 44)-STEP(198, 0), 172
LINE (7, 36)-STEP(196, 7), 0, BF

FOR i = 1 TO 4
 LINE (i * 11 + 196, 35)-STEP(8, 0), 164
 LINE (i * 11 + 196, 35)-STEP(0, 9), 164
 LINE (i * 11 + 205, 35)-STEP(0, 9), 172
 LINE (i * 11 + 196, 44)-STEP(8, 0), 172
 LINE (i * 11 + 197, 36)-STEP(7, 7), 0, BF
NEXT i

PUT (200, 14), MissileP, PSET
PUT (200, 22), MegaBombP, PSET

PutText "x" + Fixed$(Player.Missiles), 31, 206, 13, 1
PutText "x" + Fixed$(Player.Megabomb), 31, 206, 21, 1

CALL ShowHealth
CALL ShowWeapon
CALL ShowLives
CALL ShowPlayer
CALL ShowScore
CALL ShowSpecialCount
CALL InitLevel

END SUB

SUB ShowHealth

FOR i = 1 TO Player.Hp
 LINE (i * 13 - 5, 37)-STEP(12, 5), i + 159, BF
NEXT i

END SUB

SUB ShowKredits

LINE (11, 120 + DownAmount)-(309, 128 + DownAmount), 0, BF
PutText2 "You currently have " + Fixed$(Player.Kredits) + " kredits.", 31, 50, 120 + DownAmount, 1, -1

END SUB

SUB ShowLevel

PutText "Wave " + Fixed$(GameData.LevelOn), Colour.Shadow, -1, 115, 1
PutText "Wave " + Fixed$(GameData.LevelOn), Colour.Main, -1, 114, 1

DO
 kbd$ = INKEY$
 IF kbd$ <> "" THEN
  SELECT CASE kbd$
   CASE CHR$(13)
    LINE (132, 114)-STEP(72, 8), 0, BF
    EXIT DO
  END SELECT

 END IF

 CALL StarMove
 CALL Exhaust
 CALL DoDelay(1)
 CALL ContinuePlaySong
LOOP

END SUB

SUB ShowLives

IF Player.Lives <= 0 THEN
 LINE (240, 12)-STEP(60, 16), 0, BF
END IF

IF Player.Lives > 0 THEN
 PUT (240, 12), Ship1, PSET
 LINE (260, 12)-STEP(40, 16), 0, BF
END IF

IF Player.Lives > 1 THEN
 PUT (260, 12), Ship1, PSET
 LINE (280, 12)-STEP(17, 16), 0, BF
END IF

IF Player.Lives > 2 THEN
 PUT (280, 12), Ship1, PSET
END IF

LINE (232, 12)-STEP(8, 8), 0, BF

IF Player.Lives > 0 THEN
 PutText Fixed$(Player.Lives), 15, 232, 12, 1
ELSEIF Player.Lives <= 0 THEN
 PutText "0", 15, 232, 12, 2
END IF

END SUB

SUB ShowOptionsChoice (Choice)

SELECT CASE Choice
 CASE 1
  PutText2 "Music", 167, 100, 40, 1, 1
  PutText2 "Sound", 31, 100, 48, 1, -1
  PutText2 " View", 31, 100, 56, 1, -1
  PutText2 "Close", 31, 100, 176, 1, -1
 CASE 2
  PutText2 "Music", 31, 100, 40, 1, -1
  PutText2 "Sound", 167, 100, 48, 1, 1
  PutText2 " View", 31, 100, 56, 1, -1
  PutText2 "Close", 31, 100, 176, 1, -1
 CASE 3
  PutText2 "Music", 31, 100, 40, 1, -1
  PutText2 "Sound", 31, 100, 48, 1, -1
  PutText2 " View", 167, 100, 56, 1, 1
  PutText2 "Close", 31, 100, 176, 1, -1
 CASE 4
  PutText2 "Music", 31, 100, 40, 1, -1
  PutText2 "Sound", 31, 100, 48, 1, -1
  PutText2 " View", 31, 100, 56, 1, -1
  PutText2 "Close", 167, 100, 176, 1, 1
END SELECT

END SUB

SUB ShowOptionStatus

LINE (160, 40)-STEP(80, 24), 0, BF

SELECT CASE GameData.MusicOp
 CASE True
  PutText2 "ON", 31, 160, 40, 1, -1
 CASE False
  PutText2 "OFF", 31, 160, 40, 1, -1
END SELECT

SELECT CASE GameData.SoundOp
 CASE True
  PutText2 "ON", 31, 160, 48, 1, -1
 CASE False
  PutText2 "OFF", 31, 160, 48, 1, -1
END SELECT

SELECT CASE ViewMode
 CASE 0
  PutText2 "Not framed", 31, 160, 56, 1, -1
 CASE 1
  PutText2 "Framed", 31, 160, 56, 1, -1
END SELECT

END SUB

SUB ShowOutpostChoice (Choice)

SELECT CASE Choice
 CASE 1
  PutText2 "Improve Laser", 167, 50, 50 + DownAmount, 1, 1
  PutText2 "Buy Missiles", 31, 50, 58 + DownAmount, 1, -1
  PutText2 "Leave", 31, 50, 98 + DownAmount, 1, -1
 
  LINE (146, 50 + DownAmount)-(309, 90 + DownAmount), 0, BF
 
  SELECT CASE Player.ShotLev
   CASE 1
    PutText2 "Current laser level is 1,", 31, 146, 50 + DownAmount, 1, -1
    PutText2 "upgrade to level 2, 100k", 31, 146, 58 + DownAmount, 1, -1
   CASE 2
    PutText2 "Current laser level is 2,", 31, 146, 50 + DownAmount, 1, -1
    PutText2 "upgrade to level 3, 200k", 31, 146, 58 + DownAmount, 1, -1
   CASE 3
    PutText2 "Current laser level is 3,", 31, 146, 50 + DownAmount, 1, -1
    PutText2 "upgrade to level 4, 300k", 31, 146, 58 + DownAmount, 1, -1
   CASE 4
    PutText2 "Current laser level is 4,", 31, 146, 50 + DownAmount, 1, -1
    PutText2 "cannot upgrade. Get a new", 31, 146, 58 + DownAmount, 1, -1
    PutText2 "ship in the next version", 31, 146, 66 + DownAmount, 1, -1
    PutText2 "of this game. :)", 31, 146, 74 + DownAmount, 1, -1
  END SELECT

 CASE 2
  PutText2 "Improve Laser", 31, 50, 50 + DownAmount, 1, -1
  PutText2 "Buy Missiles", 167, 50, 58 + DownAmount, 1, 1
  PutText2 "Buy Megabomb", 31, 50, 66 + DownAmount, 1, -1
   
  LINE (146, 50 + DownAmount)-(309, 90 + DownAmount), 0, BF
 
  PutText2 "A five missile cluster will", 31, 146, 50 + DownAmount, 1, -1
  PutText2 "cost 100k. Wow, what a", 31, 146, 58 + DownAmount, 1, -1
  PutText2 "ripoff. :)", 31, 146, 66 + DownAmount, 1, -1
 CASE 3
  PutText2 "Buy Missiles", 31, 50, 58 + DownAmount, 1, -1
  PutText2 "Buy Megabomb", 167, 50, 66 + DownAmount, 1, 1
  PutText2 "Repair Ship", 31, 50, 74 + DownAmount, 1, -1
 
  LINE (146, 50 + DownAmount)-(309, 90 + DownAmount), 0, BF

  PutText2 "A SINGLE megabomb will set", 31, 146, 50 + DownAmount, 1, -1
  PutText2 "you back a few paychecks...", 31, 146, 58 + DownAmount, 1, -1
  PutText2 "Muahaha. 300k.", 31, 146, 66 + DownAmount, 1, -1

 CASE 4
  PutText2 "Buy Megabomb", 31, 50, 66 + DownAmount, 1, -1
  PutText2 "Repair Ship", 167, 50, 74 + DownAmount, 1, 1
  PutText2 "Leave", 31, 50, 98 + DownAmount, 1, -1
 
  LINE (146, 50 + DownAmount)-(309, 90 + DownAmount), 0, BF

  PutText2 "We'll repair all the damage", 31, 146, 50 + DownAmount, 1, -1
  PutText2 "to your ship for 50k.", 31, 146, 58 + DownAmount, 1, -1
 CASE 5
  PutText2 "Improve Laser", 31, 50, 50 + DownAmount, 1, -1
  PutText2 "Buy Missiles", 31, 50, 58 + DownAmount, 1, -1
  PutText2 "Buy Megabomb", 31, 50, 66 + DownAmount, 1, -1
  PutText2 "Repair Ship", 31, 50, 74 + DownAmount, 1, -1
  PutText2 "Leave", 167, 50, 98 + DownAmount, 1, 1
 
  LINE (146, 50 + DownAmount)-(309, 90 + DownAmount), 0, BF

  PutText2 "Hey, don't cha all leave", 31, 146, 50 + DownAmount, 1, -1
  PutText2 "now, the funs just startin!", 31, 146, 58 + DownAmount, 1, -1
 
END SELECT

END SUB

SUB ShowPlayer

PUT (Player.x, Player.y), Ship1, PSET
CALL Exhaust

END SUB

SUB ShowScore

LINE (146, 12)-STEP(50, 8), 0, BF
PutText Fixed$(CINT(Player.Score)) + "00", Colour.Main, 146, 13, 1

END SUB

SUB ShowSpecialCount

LINE (212, 13)-STEP(12, 16), 0, BF

PutText "x" + Fixed$(Player.Missiles), 31, 206, 13, 1
PutText "x" + Fixed$(Player.Megabomb), 31, 206, 21, 1

END SUB

SUB ShowStars

FOR i = 1 TO Stars
 x = RndNum(319, 0, 1)
 y = RndNum(199, 0, 1)
 IF POINT(x, y) = 0 THEN
  SELECT CASE RndNum(5, 1, 1)
   CASE 1
    PSET (x, y), 17
   CASE 2
    PSET (x, y), 20
   CASE 3
    PSET (x, y), 25
   CASE 4
    PSET (x, y), 30
  END SELECT
 END IF
NEXT i

END SUB

SUB ShowWave

LINE (146, 21)-STEP(24, 8), 0, BF
PutText Fixed$(GameData.LevelOn), Colour.Main, 146, 21, 1

END SUB

SUB ShowWeapon

SELECT CASE Player.Weapon
 CASE Laser
  SELECT CASE Player.ShotLev
   CASE 1
    PUT (209, 38), Laser1P, PSET
   CASE 2
    PUT (209, 38), Laser2P, PSET
   CASE 3
    PUT (209, 38), Laser3P, PSET
   CASE 4
    PUT (209, 38), Laser4P, PSET
  END SELECT

  SELECT CASE Player.SpredLev
   CASE 1
    PUT (220, 37), Spread1Ns, PSET
   CASE 2
    PUT (220, 37), Spread2Ns, PSET
  END SELECT

  IF Player.Missiles > 0 THEN PUT (231, 37), MissileNs, PSET ELSE LINE (231, 37)-STEP(4, 4), 0, BF
  IF Player.Megabomb > 0 THEN PUT (242, 37), MegaBombNs, PSET ELSE LINE (242, 37)-STEP(4, 4), 0, BF

 CASE Spread
  PUT (209, 38), LaserNs, PSET
 
  SELECT CASE Player.SpredLev
   CASE 1
    PUT (220, 37), Spread1P, PSET
   CASE 2
    PUT (220, 37), Spread2P, PSET
  END SELECT
 
  IF Player.Missiles > 0 THEN PUT (231, 37), MissileNs, PSET ELSE LINE (231, 37)-STEP(4, 4), 0, BF
  IF Player.Megabomb > 0 THEN PUT (242, 37), MegaBombNs, PSET ELSE LINE (242, 37)-STEP(4, 4), 0, BF

 CASE Missile
  PUT (209, 38), LaserNs, PSET
  SELECT CASE Player.SpredLev
   CASE 1
    PUT (220, 37), Spread1Ns, PSET
   CASE 2
    PUT (220, 37), Spread2Ns, PSET
  END SELECT
  PUT (231, 37), MissileP, PSET
  IF Player.Megabomb > 0 THEN PUT (242, 37), MegaBombNs, PSET ELSE LINE (242, 37)-STEP(4, 4), 0, BF

 CASE Megabomb
  PUT (209, 38), LaserNs, PSET
  SELECT CASE Player.SpredLev
   CASE 1
    PUT (220, 37), Spread1Ns, PSET
   CASE 2
    PUT (220, 37), Spread2Ns, PSET
  END SELECT
  IF Player.Missiles > 0 THEN PUT (231, 37), MissileNs, PSET ELSE LINE (231, 37)-STEP(4, 4), 0, BF
  PUT (242, 37), MegaBombP, PSET

END SELECT

END SUB

SUB StarMove

FOR i = 1 TO Stars
 SELECT CASE POINT(Star(i).x, Star(i).y)
  CASE 17, 20, 25, 30
   PSET (Star(i).x, Star(i).y), 0
 END SELECT
 
 Star(i).x = Star(i).x - Star(i).Speed

 IF Star(i).x < 0 THEN Star(i).x = 310
 
 IF POINT(Star(i).x, Star(i).y) = 0 THEN
  PSET (Star(i).x, Star(i).y), Star(i).Colour
 END IF
 
NEXT i

END SUB

SUB StarOutpost (OutpostIndex)

ResetStarOutpost:

CALL SetFrame(True)

PutText2 "Welcome to Star Outpost", 31, -1, 16, 2, -1

SELECT CASE OutpostIndex
 CASE 1
  PutText2 "N-18", 31, -1, 32, 2, -1
 CASE 2
  PutText2 "Gamma 7", 31, -1, 32, 2, -1
 CASE 3
  PutText2 "Hangart 6", 31, -1, 32, 2, -1
END SELECT

CurChoice = 1

PutText2 "Choice:         Description:", 174, 50, 42 + DownAmount, 1, -1

PutText2 "Improve Laser", 167, 50, 50 + DownAmount, 1, 1
PutText2 "Buy Missiles", 31, 50, 58 + DownAmount, 1, -1
PutText2 "Buy Megabomb", 31, 50, 66 + DownAmount, 1, -1
PutText2 "Repair Ship", 31, 50, 74 + DownAmount, 1, -1
PutText2 "Leave", 31, 50, 98 + DownAmount, 1, -1

CALL ShowKredits
PutText2 "Press 'S' to save a bookmark...", 31, 50, 136 + DownAmount, 1, -1

CALL ShowOutpostChoice(CurChoice)

DO
 kbd$ = INKEY$
 IF kbd$ <> "" THEN
  SELECT CASE kbd$
   CASE CHR$(0) + "H"
    CurChoice = CurChoice - 1
    IF CurChoice = 0 THEN CurChoice = 5
    CALL ShowOutpostChoice(CurChoice)
   CASE CHR$(0) + "P"
    CurChoice = CurChoice + 1
    IF CurChoice = 6 THEN CurChoice = 1
    CALL ShowOutpostChoice(CurChoice)
   CASE CHR$(13)
    SELECT CASE CurChoice
     CASE 1
      SELECT CASE Player.ShotLev
       CASE 1
	IF Player.Kredits >= 100 THEN
	 Player.Kredits = Player.Kredits - 100
	 CALL ShowKredits
	 Player.ShotLev = Player.ShotLev + 1
	 CALL BoxMessage("Laser upgraded to level 2")
	ELSE
	 CALL BoxMessage("Not enough kredits!")
	END IF
       CASE 2
	IF Player.Kredits >= 200 THEN
	 Player.Kredits = Player.Kredits - 200
	 CALL ShowKredits
	 Player.ShotLev = Player.ShotLev + 1
	 CALL BoxMessage("Laser upgraded to level 3")
	ELSE
	 CALL BoxMessage("Not enough kredits!")
	END IF
       CASE 3
	IF Player.Kredits >= 300 THEN
	 Player.Kredits = Player.Kredits - 300
	 CALL ShowKredits
	 Player.ShotLev = Player.ShotLev + 1
	 CALL BoxMessage("Laser upgraded to level 4")
	ELSE
	 CALL BoxMessage("Not enough kredits!")
	END IF
       CASE 4
	CALL BoxMessage("Cannot upgrade!")
      END SELECT
     CASE 2
      IF Player.Kredits >= 100 THEN
       Player.Kredits = Player.Kredits - 100
       CALL ShowKredits
       Player.Missiles = Player.Missiles + 5
       CALL BoxMessage("5 missiles purchased")
      ELSE
       CALL BoxMessage("Not enough kredits!")
      END IF
     CASE 3
      IF Player.Kredits >= 300 THEN
       Player.Kredits = Player.Kredits - 300
       CALL ShowKredits
       Player.Megabomb = Player.Megabomb + 1
       CALL BoxMessage("1 megabomb purchased")
      ELSE
       CALL BoxMessage("Not enough kredits!")
      END IF
     CASE 4
      IF Player.Kredits >= 50 THEN
       Player.Kredits = Player.Kredits - 50
       CALL ShowKredits
       Player.Hp = Player.MaxHp
       CALL BoxMessage("Ship repaired")
      ELSE
       CALL BoxMessage("Not enough kredits!")
      END IF
     CASE 5
      CALL StopPlaySong
      EXIT SUB
    END SELECT
   CASE CHR$(27)
    CurChoice = 5
    CALL ShowOutpostChoice(CurChoice)
   CASE "s", "S"
    CALL SaveBookmark
    GOTO ResetStarOutpost
   CASE CHR$(0) + "B"
    Player.Kredits = Player.Kredits + 100
    CALL ShowKredits
  END SELECT
 END IF

 CALL DoDelay(1)
 CALL ContinuePlaySong
LOOP

END SUB

SUB StopPlaySong

PlayMode = 0

FOR i = 0 TO 244
 FmpadLPort i, 0
NEXT i

END SUB

SUB Story

CALL ClearShots

CALL SetFrame(True)

PutText2 " It is the year 2168, and the power of good, the", 31, 16, 16, 1, -1
PutText2 "Empire, is struggling to survive. There were", 31, 16, 24, 1, -1
PutText2 "talks of abandoning, and finding a new home, but", 31, 16, 32, 1, -1
PutText2 "everyone knows, there is no place to go. For the", 31, 16, 40, 1, -1
PutText2 "last four years, a mysterious force has been", 31, 16, 48, 1, -1
PutText2 "slaughtering the empire. There are hardly any", 31, 16, 56, 1, -1
PutText2 "ships left.", 31, 16, 64, 1, -1
PutText2 " Then we made a breakthrough. The great Bashar", 31, 16, 72, 1, -1
PutText2 "got one of the enemy ships. We studied it inside", 31, 16, 80, 1, -1
PutText2 "out, but it still largely remains a mystery to", 31, 16, 88, 1, -1
PutText2 "us. Although, we can navigate it, and we can arm", 31, 16, 96, 1, -1
PutText2 "it with our weapons. We have you to pilot.", 31, 16, 104, 1, -1
PutText2 " This is probably the last of the Empire. But we", 31, 16, 112, 1, -1
PutText2 "shall go down in glory! Go! We will be reunited", 31, 16, 120, 1, -1
PutText2 "someday, be it hell, heaven, or worse.", 31, 16, 128, 1, -1
PutText2 "                              [ End of Message ]", 31, 16, 136, 1, -1

Px = Player.x
Py = Player.y

Player.x = 20
Player.y = 160
PUT (Player.x, Player.y), Ship1, PSET

DO
 CALL Exhaust
 CALL DoDelay(1)
 CALL DoShotsStory
 i = i + 1
 IF i = 50 THEN
  CALL PlayerShot
  i = 0
 END IF

LOOP WHILE INKEY$ = ""

Player.x = Px
Player.y = Py

CALL ClearShots

END SUB

SUB WaitKey

WHILE INKEY$ = ""
WEND

END SUB

