DEFINT A-Z
DIM ip(300, 1), op(300, 1), carx(5), cary(5), chkpoint(500, 1, 1), start(1, 1)
DIM points(1000, 1)
drawing = 1
zoomlev = 1
SCREEN 0: CLS
PRINT "Use of the Track Creator:"
PRINT "Arrow keys       - move 'cursor' one step"
PRINT "Home,Del,End,Pg. - Down move 'cursor' fifty steps"
PRINT "8,4,5,6          - Move View area around"
PRINT "[space]          - To place a section of track"
PRINT "Z                - To finish a stretch of track"
PRINT "F1               - Player car starting position"
PRINT "F2 - F6          - Computer cars starting position"
PRINT "F11/12           - Horizontal/Vertical Checkpoint"
PRINT "F9/10            - Horizontal/Vertical Start line"
PRINT "S/L              - Saves/Loads track"
PRINT "+,-              - Change zoom level"
PRINT "Status at lower screen -"
PRINT "x position          y position"
PRINT "x offset            y offset"
PRINT "zoom level"
PRINT "Place checkpoints in order of passing"
PRINT "Placed cars are always pointing to the right (for now!)"
PRINT "Track is saved as 'CUSTOM.TRK'. Track is always used in the game (for now!)"
PRINT "Current zoom level creates map - so don't leave it as 1 : 1 !!!"
PRINT "NOTE : Standard track is zoomed at 1 : 20"
PRINT "       And it will be overwritten during a save..."
PRINT "Press any key to begin editing!"

DO: LOOP UNTIL INKEY$ <> ""
SCREEN 13

DO
PSET ((x - xo) \ zoomlev, (y - yo) \ zoomlev), under
rds = 0
SELECT CASE INKEY$
CASE CHR$(0) + "H": y = y - 1
CASE CHR$(0) + "M": x = x + 1
CASE CHR$(0) + "P": y = y + 1
CASE CHR$(0) + "K": x = x - 1
                          
CASE CHR$(0) + "G": y = y - 50
CASE CHR$(0) + "Q": x = x + 50
CASE CHR$(0) + "O": y = y + 50
CASE CHR$(0) + "S": x = x - 50

CASE "8": yo = yo - 25: rds = 1: IF yo = -25 THEN yo = 0
CASE "6": xo = xo + 25: rds = 1
CASE "2": yo = yo + 25: rds = 1
CASE "4": xo = xo - 25: rds = 1: IF xo = -25 THEN xo = 0

CASE "-": zoomlev = zoomlev + 1: rds = 1
CASE "+": zoomlev = zoomlev - 1: rds = 1: IF zoomlev = 0 THEN zoomlev = 1

CASE " ": points(tracklength, 0) = x: points(tracklength, 1) = y
tracklength = tracklength + 1
rds = 1

CASE "z": points(tracklength, 0) = -1: points(tracklength, 1) = -1
tracklength = tracklength + 1
rds = 1


CASE "s": GOSUB savetrack: rds = 1
CASE "l": GOSUB LoadTrack: rds = 1

CASE "n": rds = 1: LOCATE 1, 1: INPUT "Track Name:", name$

CASE CHR$(0) + ";": carx(0) = x: cary(0) = y: rds = 1
CASE CHR$(0) + "<": carx(1) = x: cary(1) = y: rds = 1
CASE CHR$(0) + "=": carx(2) = x: cary(2) = y: rds = 1
CASE CHR$(0) + ">": carx(3) = x: cary(3) = y: rds = 1
CASE CHR$(0) + "?": carx(4) = x: cary(4) = y: rds = 1
CASE CHR$(0) + "@": carx(5) = x: cary(5) = y: rds = 1

CASE CHR$(0) + "C":
IF doingchk = 0 THEN
doingchk = 1
chkpoint(curchk, 0, 0) = x
chkpoint(curchk, 0, 1) = y
ELSE
doingchk = 0
chkpoint(curchk, 1, 0) = x
IF chkpoint(curchk, 0, 1) > y THEN tmp = chkpoint(curchk, 0, 1) - 35 ELSE tmp = chkpoint(curchk, 0, 1) + 35
chkpoint(curchk, 1, 1) = tmp
curchk = curchk + 1
rds = 1
END IF

CASE CHR$(0) + "D":
IF doingchkv = 0 THEN
doingchkv = 1
chkpoint(curchk, 0, 0) = x
chkpoint(curchk, 0, 1) = y
ELSE
doingchkv = 0
chkpoint(curchk, 1, 1) = y
IF chkpoint(curchk, 0, 0) > x THEN tmp = chkpoint(curchk, 0, 0) - 35 ELSE tmp = chkpoint(curchk, 0, 0) + 35
chkpoint(curchk, 1, 0) = tmp
curchk = curchk + 1
rds = 1
END IF

CASE CHR$(0) + "":
IF doingstrt = 0 THEN
doingstrt = 1
start(0, 0) = x
start(0, 1) = y
ELSE
doingstrt = 0
start(1, 0) = x
IF start(0, 1) > y THEN tmp = start(0, 1) - 35 ELSE tmp = start(0, 1) + 35
start(1, 1) = tmp
curchk = curchk + 1
rds = 1
END IF

CASE CHR$(0) + "":
IF doingstrt = 0 THEN
doingstrt = 1
start(0, 0) = x
start(0, 1) = y
ELSE
doingstrt = 0
start(1, 1) = y
IF start(0, 0) > x THEN tmp = start(0, 0) - 35 ELSE tmp = start(0, 0) + 35
start(1, 0) = tmp
rds = 1
END IF

CASE "q": LOCATE 1, 1: INPUT "Track Colour:", TrackCol: rds = 1
CASE "w": LOCATE 1, 1: INPUT "Outer Colour:", OuterCol: rds = 1
CASE "e": LOCATE 1, 1: INPUT "Border Colour 1:", BorderCol1: rds = 1
CASE "r": LOCATE 1, 1: INPUT "Border Colour 2:", BorderCol2: rds = 1
CASE "t": LOCATE 1, 1: INPUT "Skid Colour:", SkidCol: rds = 1

END SELECT
IF x < 0 THEN x = 0
IF y < 0 THEN y = 0

DO
IF x - xo \ zoomlev <= -1 THEN x = x + 1: ag = 1:  ELSE ag = 0
LOOP UNTIL ag = 0
DO
IF y - yo \ zoomlev <= -1 THEN y = y + 1: ag = 1:  ELSE ag = 0
LOOP UNTIL ag = 0

IF rds = 1 THEN GOSUB redraw

under = POINT((x - xo) \ zoomlev, (y - yo) \ zoomlev)
PSET ((x - xo) \ zoomlev, (y - yo) \ zoomlev), RND * 15 + 1
LOCATE 20, 1
PRINT name$
PRINT x, y
PRINT xo, yo
PRINT "1 :"; zoomlev
LOOP

redraw:
CLS

FOR l = 0 TO tracklength - 2
IF points(l, 0) <> -1 AND points(l, 1) <> -1 AND points(l + 1, 0) <> -1 AND points(l + 1, 1) <> -1 THEN
LINE ((points(l, 0) - xo) \ zoomlev, (points(l, 1) - yo) \ zoomlev)-((points(l + 1, 0) - xo) \ zoomlev, (points(l + 1, 1) - yo) \ zoomlev), 7
END IF
NEXT

FOR l = 0 TO tracklength - 1
PSET ((points(l, 0) - xo) \ zoomlev, (points(l, 1) - yo) \ zoomlev), 8
NEXT

PSET ((carx(0) - xo) \ zoomlev, (cary(0) - yo) \ zoomlev), 11
FOR l = 1 TO 5
PSET ((carx(l) - xo) \ zoomlev, (cary(l) - yo) \ zoomlev), 12
NEXT
FOR l = 0 TO curchk - 1
LINE ((chkpoint(l, 0, 0) - xo) \ zoomlev, (chkpoint(l, 0, 1) - yo) \ zoomlev)-((chkpoint(l, 1, 0) - xo) \ zoomlev, (chkpoint(l, 1, 1) - yo) \ zoomlev), 14, B, &HAAAA
NEXT
LINE ((start(0, 0) - xo) \ zoomlev, (start(0, 1) - yo) \ zoomlev)-((start(1, 0) - xo) \ zoomlev, (start(1, 1) - yo) \ zoomlev), 4, B, &HAAAA
LINE (309, 179)-(319, 199), BorderCol1, B
LINE (309, 179)-(319, 199), BorderCol2, B, &HF0F0
LINE (310, 180)-(318, 189), TrackCol, BF
LINE (310, 190)-(318, 198), OuterCol, BF
LINE (310, 180)-(318, 198), SkidCol
RETURN

savetrack:
LOCATE 1, 1: INPUT trname$
OPEN "data\" + trname$ + ".trk" FOR OUTPUT AS #1
PRINT #1, tracklength - 1
PRINT #1, zoomlev
FOR l = 0 TO 5
PRINT #1, carx(l)
PRINT #1, cary(l)
NEXT
FOR l = 0 TO tracklength - 1
PRINT #1, points(l, 0)
PRINT #1, points(l, 1)
NEXT
PRINT #1, start(0, 0)
PRINT #1, start(0, 1)
PRINT #1, start(1, 0)
PRINT #1, start(1, 1)
PRINT #1, curchk
FOR l = 0 TO curchk
PRINT #1, chkpoint(l, 0, 0)
PRINT #1, chkpoint(l, 0, 1)
PRINT #1, chkpoint(l, 1, 0)
PRINT #1, chkpoint(l, 1, 1)
NEXT
PRINT #1, name$
PRINT #1, TrackCol
PRINT #1, OuterCol
PRINT #1, BorderCol1
PRINT #1, BorderCol2
PRINT #1, SkidCol
CLOSE #1
PRINT "Saved!!!"
RETURN


LoadTrack:
LOCATE 1, 1: INPUT trname$
OPEN "data\" + trname$ + ".trk" FOR INPUT AS #1
INPUT #1, tracklength
INPUT #1, zoomlev
FOR l = 0 TO 5
INPUT #1, carx(l): INPUT #1, cary(l)
NEXT
FOR l = 0 TO tracklength
INPUT #1, points(l, 0)
INPUT #1, points(l, 1)
NEXT
INPUT #1, start(0, 0)
INPUT #1, start(0, 1)
INPUT #1, start(1, 0)
INPUT #1, start(1, 1)
INPUT #1, curchk
FOR l = 0 TO curchk
INPUT #1, chkpoint(l, 0, 0)
INPUT #1, chkpoint(l, 0, 1)
INPUT #1, chkpoint(l, 1, 0)
INPUT #1, chkpoint(l, 1, 1)
NEXT
INPUT #1, name$
INPUT #1, TrackCol
INPUT #1, OuterCol
INPUT #1, BorderCol1
INPUT #1, BorderCol2
INPUT #1, SkidCol

CLOSE #1
tracklength = tracklength + 1
RETURN


