DEFINT A-Z
DECLARE FUNCTION max (var1, var2)
DECLARE FUNCTION min (var1, var2)

TYPE WireLine
   colour AS INTEGER
   x1 AS SINGLE: y1 AS SINGLE: z1 AS SINGLE
   x2 AS SINGLE: y2 AS SINGLE: z2 AS SINGLE
END TYPE

DIM ip(300, 1), op(300, 1), carx(5), cary(5), chkpoint(500, 1, 1), start(1, 1)
DIM points(1000, 1), tunpoint(100, 1, 1), billpoint(100, 1, 1), lamppoint(100, 1, 1), standspoint(100, 1, 1)
DIM Extras(1000) AS WireLine, jumppoint(100, 1, 1), jumpstat(100, 3), lowline(1000)
drawing = 1
zoomlev = 1
SCREEN 0: CLS
PRINT "Use of the Track Creator:"
PRINT "Arrow keys       - move 'cursor' one step"
PRINT "Home,Del,End,Pg. - Down move 'cursor' fifty steps"
PRINT "8,4,5,6          - Move View area around"
PRINT "[space]          - To place a section of track"
PRINT "Z                - To finish a stretch of track"
PRINT "F1               - Player car starting position"
PRINT "F2 - F6          - Computer cars starting position"
PRINT "F11/12           - Horizontal/Vertical Checkpoint"
PRINT "F9/10            - Horizontal/Vertical Start line"
PRINT "S/L              - Saves/Loads track"
PRINT "+,-              - Change zoom level"
PRINT "Status at lower screen -"
PRINT "x position          y position"
PRINT "x offset            y offset"
PRINT "zoom level"
PRINT "Place checkpoints in order of passing"
PRINT "Placed cars are always pointing to the right (for now!)"
PRINT "Track is saved as 'CUSTOM.TRK'. Track is always used in the game (for now!)"
PRINT "Current zoom level creates map - so don't leave it as 1 : 1 !!!"
PRINT "NOTE : Standard track is zoomed at 1 : 20"
PRINT "       And it will be overwritten during a save..."
PRINT "Press any key to begin editing!"

DO: LOOP UNTIL INKEY$ <> ""
SCREEN 13

DO
PSET ((x - xo) \ zoomlev, (y - yo) \ zoomlev), under
rds = 0
SELECT CASE INKEY$
CASE CHR$(0) + "H": y = y - 1
CASE CHR$(0) + "M": x = x + 1
CASE CHR$(0) + "P": y = y + 1
CASE CHR$(0) + "K": x = x - 1
                          
CASE CHR$(0) + "G": y = y - 50
CASE CHR$(0) + "Q": x = x + 50
CASE CHR$(0) + "O": y = y + 50
CASE CHR$(0) + "S": x = x - 50

CASE "8": yo = yo - 25: rds = 1: IF yo = -25 THEN yo = 0
CASE "6": xo = xo + 25: rds = 1
CASE "2": yo = yo + 25: rds = 1
CASE "4": xo = xo - 25: rds = 1: IF xo = -25 THEN xo = 0

CASE "-": zoomlev = zoomlev + 1: rds = 1
CASE "+": zoomlev = zoomlev - 1: rds = 1: IF zoomlev = 0 THEN zoomlev = 1

CASE " ": points(tracklength, 0) = x: points(tracklength, 1) = y: lowline(tracklength) = 0
tracklength = tracklength + 1
rds = 1

CASE "/": points(tracklength, 0) = x: points(tracklength, 1) = y: lowline(tracklength) = 1
tracklength = tracklength + 1
rds = 1


CASE "z": points(tracklength, 0) = -1: points(tracklength, 1) = -1
tracklength = tracklength + 1
rds = 1


CASE "s": GOSUB savetrack: rds = 1
CASE "l": GOSUB LoadTrack: rds = 1

CASE "n": rds = 1: LOCATE 1, 1: INPUT "Track Name:", name$

CASE CHR$(0) + ";": carx(0) = x: cary(0) = y: rds = 1
CASE CHR$(0) + "<": carx(1) = x: cary(1) = y: rds = 1
CASE CHR$(0) + "=": carx(2) = x: cary(2) = y: rds = 1
CASE CHR$(0) + ">": carx(3) = x: cary(3) = y: rds = 1
CASE CHR$(0) + "?": carx(4) = x: cary(4) = y: rds = 1
CASE CHR$(0) + "@": carx(5) = x: cary(5) = y: rds = 1

CASE CHR$(0) + "C":
IF doingchk = 0 THEN
doingchk = 1
chkpoint(curchk, 0, 0) = x
chkpoint(curchk, 0, 1) = y
ELSE
doingchk = 0
chkpoint(curchk, 1, 0) = x
IF chkpoint(curchk, 0, 1) > y THEN tmp = chkpoint(curchk, 0, 1) - 35 ELSE tmp = chkpoint(curchk, 0, 1) + 35
chkpoint(curchk, 1, 1) = tmp
curchk = curchk + 1
rds = 1
END IF

CASE CHR$(0) + "D":
IF doingchkv = 0 THEN
doingchkv = 1
chkpoint(curchk, 0, 0) = x
chkpoint(curchk, 0, 1) = y
ELSE
doingchkv = 0
chkpoint(curchk, 1, 1) = y
IF chkpoint(curchk, 0, 0) > x THEN tmp = chkpoint(curchk, 0, 0) - 35 ELSE tmp = chkpoint(curchk, 0, 0) + 35
chkpoint(curchk, 1, 0) = tmp
curchk = curchk + 1
rds = 1
END IF

CASE CHR$(0) + "":
IF doingstrt = 0 THEN
doingstrt = 1
start(0, 0) = x
start(0, 1) = y
ELSE
doingstrt = 0
start(1, 0) = x
IF start(0, 1) > y THEN tmp = start(0, 1) - 35 ELSE tmp = start(0, 1) + 35
start(1, 1) = tmp
curchk = curchk + 1
rds = 1
END IF

CASE CHR$(0) + "":
IF doingstrt = 0 THEN
doingstrt = 1
start(0, 0) = x
start(0, 1) = y
ELSE
doingstrt = 0
start(1, 1) = y
IF start(0, 0) > x THEN tmp = start(0, 0) - 35 ELSE tmp = start(0, 0) + 35
start(1, 0) = tmp
rds = 1
END IF

CASE "q": LOCATE 1, 1: INPUT "Track Colour:", TrackCol: rds = 1
CASE "w": LOCATE 1, 1: INPUT "Outer Colour:", OuterCol: rds = 1
CASE "e": LOCATE 1, 1: INPUT "Border Colour 1:", BorderCol1: rds = 1
CASE "r": LOCATE 1, 1: INPUT "Border Colour 2:", BorderCol2: rds = 1
CASE "t": LOCATE 1, 1: INPUT "Skid Colour:", SkidCol: rds = 1

CASE "y":
IF doingtun = 0 THEN
doingtun = 1
tunpoint(curtun, 0, 0) = x
tunpoint(curtun, 0, 1) = y
ELSE
doingtun = 0
tunpoint(curtun, 1, 0) = x
tunpoint(curtun, 1, 1) = y
curtun = curtun + 1
rds = 1
END IF

CASE "u":
IF doingbill = 0 THEN
doingbill = 1
billpoint(curbill, 0, 0) = x
billpoint(curbill, 0, 1) = y
ELSE
doingbill = 0
billpoint(curbill, 1, 0) = x
billpoint(curbill, 1, 1) = y
curbill = curbill + 1
rds = 1
END IF

CASE "i":
IF doinglamp = 0 THEN
doinglamp = 1
lamppoint(curlamp, 0, 0) = x
lamppoint(curlamp, 0, 1) = y
ELSE
doinglamp = 0
lamppoint(curlamp, 1, 0) = x
lamppoint(curlamp, 1, 1) = y
curlamp = curlamp + 1
rds = 1
END IF

CASE "o":
IF doingstands = 0 THEN
doingstands = 1
standspoint(curstands, 0, 0) = x
standspoint(curstands, 0, 1) = y
ELSE
doingstands = 0
standspoint(curstands, 1, 0) = x
standspoint(curstands, 1, 1) = y
curstands = curstands + 1
rds = 1
END IF

CASE "p":
IF doingjump = 0 THEN
doingjump = 1
jumppoint(curjump, 0, 0) = x
jumppoint(curjump, 0, 1) = y
ELSE
doingjump = 0
jumppoint(curjump, 1, 0) = x
jumppoint(curjump, 1, 1) = y
INPUT "height 1 :", jumpstat(curjump, 0)
INPUT "height 2 :", jumpstat(curjump, 1)
IF (jumppoint(curjump, 0, 0) < jumppoint(curjump, 1, 0) AND jumppoint(curjump, 0, 1) < jumppoint(curjump, 1, 1)) OR (jumppoint(curjump, 1, 0) > jumppoint(curjump, 0, 0) AND jumppoint(curjump, 1, 1) > jumppoint(curjump, 0, 1)) THEN
jumpstat(curjump, 3) = 0
jumpstat(curjump, 2) = ATN((jumpstat(curjump, 1) - jumpstat(curjump, 0)) / (jumppoint(curjump, 1, 0) - jumppoint(curjump, 0, 0))) * 57.2958
ELSE
BEEP
jumpstat(curjump, 3) = 1
jumpstat(curjump, 2) = ATN((jumpstat(curjump, 1) - jumpstat(curjump, 0)) / (jumppoint(curjump, 1, 1) - jumppoint(curjump, 0, 1))) * 57.2958
END IF
curjump = curjump + 1
rds = 1

END IF


END SELECT
IF x < 0 THEN x = 0
IF y < 0 THEN y = 0

DO
IF x - xo \ zoomlev <= -1 THEN x = x + 1: ag = 1:  ELSE ag = 0
LOOP UNTIL ag = 0
DO
IF y - yo \ zoomlev <= -1 THEN y = y + 1: ag = 1:  ELSE ag = 0
LOOP UNTIL ag = 0

IF rds = 1 THEN GOSUB redraw

under = POINT((x - xo) \ zoomlev, (y - yo) \ zoomlev)
PSET ((x - xo) \ zoomlev, (y - yo) \ zoomlev), RND * 15 + 1
LOCATE 20, 1
PRINT name$
PRINT x, y
PRINT xo, yo
PRINT "1 :"; zoomlev
LOOP

redraw:
CLS

FOR l = 0 TO tracklength - 2
IF points(l, 0) <> -1 AND points(l, 1) <> -1 AND points(l + 1, 0) <> -1 AND points(l + 1, 1) <> -1 THEN
IF lowline(l + 1) = 0 THEN clr = 7 ELSE clr = 5
LINE ((points(l, 0) - xo) \ zoomlev, (points(l, 1) - yo) \ zoomlev)-((points(l + 1, 0) - xo) \ zoomlev, (points(l + 1, 1) - yo) \ zoomlev), clr
END IF
NEXT

FOR l = 0 TO tracklength - 1
PSET ((points(l, 0) - xo) \ zoomlev, (points(l, 1) - yo) \ zoomlev), 8
NEXT

PSET ((carx(0) - xo) \ zoomlev, (cary(0) - yo) \ zoomlev), 11
FOR l = 1 TO 5
PSET ((carx(l) - xo) \ zoomlev, (cary(l) - yo) \ zoomlev), 12
NEXT
FOR l = 0 TO curchk - 1
LINE ((chkpoint(l, 0, 0) - xo) \ zoomlev, (chkpoint(l, 0, 1) - yo) \ zoomlev)-((chkpoint(l, 1, 0) - xo) \ zoomlev, (chkpoint(l, 1, 1) - yo) \ zoomlev), 14, B, &HAAAA
NEXT
FOR l = 0 TO curtun - 1
LINE ((tunpoint(l, 0, 0) - xo) \ zoomlev, (tunpoint(l, 0, 1) - yo) \ zoomlev)-((tunpoint(l, 1, 0) - xo) \ zoomlev, (tunpoint(l, 1, 1) - yo) \ zoomlev), 1 , B, &HAAAA
NEXT

FOR l = 0 TO curbill - 1
LINE ((billpoint(l, 0, 0) - xo) \ zoomlev, (billpoint(l, 0, 1) - yo) \ zoomlev)-((billpoint(l, 1, 0) - xo) \ zoomlev, (billpoint(l, 1, 1) - yo) \ zoomlev), 12
NEXT
FOR l = 0 TO curlamp - 1
LINE ((lamppoint(l, 0, 0) - xo) \ zoomlev, (lamppoint(l, 0, 1) - yo) \ zoomlev)-((lamppoint(l, 1, 0) - xo) \ zoomlev, (lamppoint(l, 1, 1) - yo) \ zoomlev), 7
CIRCLE ((lamppoint(l, 1, 0) - xo) \ zoomlev, (lamppoint(l, 1, 1) - yo) \ zoomlev), 1, 14, , , 1
NEXT
FOR l = 0 TO curstands - 1
LINE ((standspoint(l, 0, 0) - xo) \ zoomlev, (standspoint(l, 0, 1) - yo) \ zoomlev)-((standspoint(l, 1, 0) - xo) \ zoomlev, (standspoint(l, 1, 1) - yo) \ zoomlev), 6, B
NEXT

FOR l = 0 TO curjump - 1
LINE ((jumppoint(l, 0, 0) - xo) \ zoomlev, (jumppoint(l, 0, 1) - yo) \ zoomlev)-((jumppoint(l, 1, 0) - xo) \ zoomlev, (jumppoint(l, 1, 1) - yo) \ zoomlev), 9, B
NEXT

LINE ((start(0, 0) - xo) \ zoomlev, (start(0, 1) - yo) \ zoomlev)-((start(1, 0) - xo) \ zoomlev, (start(1, 1) - yo) \ zoomlev), 4, B, &HAAAA
LINE (309, 179)-(319, 199), BorderCol1, B
LINE (309, 179)-(319, 199), BorderCol2, B, &HF0F0
LINE (310, 180)-(318, 189), TrackCol, BF
LINE (310, 190)-(318, 198), OuterCol, BF
LINE (310, 180)-(318, 198), SkidCol


RETURN

savetrack:
LOCATE 1, 1: INPUT trname$
OPEN "data\" + trname$ + ".t3d" FOR OUTPUT AS #1
PRINT #1, tracklength - 1
PRINT #1, zoomlev
FOR l = 0 TO 5
PRINT #1, carx(l)
PRINT #1, cary(l)
NEXT
FOR l = 0 TO tracklength - 1
PRINT #1, points(l, 0)
PRINT #1, points(l, 1)
NEXT
PRINT #1, start(0, 0)
PRINT #1, start(0, 1)
PRINT #1, start(1, 0)
PRINT #1, start(1, 1)
PRINT #1, curchk
FOR l = 0 TO curchk
PRINT #1, chkpoint(l, 0, 0)
PRINT #1, chkpoint(l, 0, 1)
PRINT #1, chkpoint(l, 1, 0)
PRINT #1, chkpoint(l, 1, 1)
NEXT
PRINT #1, name$
PRINT #1, TrackCol
PRINT #1, OuterCol
PRINT #1, BorderCol1
PRINT #1, BorderCol2
PRINT #1, SkidCol

PRINT #1, curtun
FOR l = 0 TO curtun - 1
PRINT #1, tunpoint(l, 0, 0)
PRINT #1, tunpoint(l, 0, 1)
PRINT #1, tunpoint(l, 1, 0)
PRINT #1, tunpoint(l, 1, 1)
NEXT

PRINT #1, curbill
FOR l = 0 TO curbill - 1
PRINT #1, billpoint(l, 0, 0)
PRINT #1, billpoint(l, 0, 1)
PRINT #1, billpoint(l, 1, 0)
PRINT #1, billpoint(l, 1, 1)
NEXT

PRINT #1, curlamp
FOR l = 0 TO curlamp - 1
PRINT #1, lamppoint(l, 0, 0)
PRINT #1, lamppoint(l, 0, 1)
PRINT #1, lamppoint(l, 1, 0)
PRINT #1, lamppoint(l, 1, 1)
NEXT

PRINT #1, curstands
FOR l = 0 TO curstands - 1
PRINT #1, standspoint(l, 0, 0)
PRINT #1, standspoint(l, 0, 1)
PRINT #1, standspoint(l, 1, 0)
PRINT #1, standspoint(l, 1, 1)
NEXT

PRINT #1, curjump
FOR l = 0 TO curjump - 1
PRINT #1, jumppoint(l, 0, 0)
PRINT #1, jumppoint(l, 0, 1)
PRINT #1, jumppoint(l, 1, 0)
PRINT #1, jumppoint(l, 1, 1)
PRINT #1, jumpstat(l, 0)
PRINT #1, jumpstat(l, 1)
PRINT #1, jumpstat(l, 2)
PRINT #1, jumpstat(l, 3)
NEXT

GOSUB doextras

FOR lp = 0 TO 1000
PRINT #1, lowline(lp)
NEXT

CLOSE #1
PRINT "Saved!!!"
RETURN


LoadTrack:
LOCATE 1, 1: INPUT trname$
OPEN "data\" + trname$ + ".t3d" FOR INPUT AS #1
INPUT #1, tracklength
INPUT #1, zoomlev
FOR l = 0 TO 5
INPUT #1, carx(l): INPUT #1, cary(l)
NEXT
FOR l = 0 TO tracklength
INPUT #1, points(l, 0)
INPUT #1, points(l, 1)
NEXT
INPUT #1, start(0, 0)
INPUT #1, start(0, 1)
INPUT #1, start(1, 0)
INPUT #1, start(1, 1)
INPUT #1, curchk
FOR l = 0 TO curchk
INPUT #1, chkpoint(l, 0, 0)
INPUT #1, chkpoint(l, 0, 1)
INPUT #1, chkpoint(l, 1, 0)
INPUT #1, chkpoint(l, 1, 1)
NEXT
INPUT #1, name$
INPUT #1, TrackCol
INPUT #1, OuterCol
INPUT #1, BorderCol1
INPUT #1, BorderCol2
INPUT #1, SkidCol

INPUT #1, curtun
FOR l = 0 TO curtun - 1
INPUT #1, tunpoint(l, 0, 0)
INPUT #1, tunpoint(l, 0, 1)
INPUT #1, tunpoint(l, 1, 0)
INPUT #1, tunpoint(l, 1, 1)
NEXT

INPUT #1, curbill
FOR l = 0 TO curbill - 1
INPUT #1, billpoint(l, 0, 0)
INPUT #1, billpoint(l, 0, 1)
INPUT #1, billpoint(l, 1, 0)
INPUT #1, billpoint(l, 1, 1)
NEXT

INPUT #1, curlamp
FOR l = 0 TO curlamp - 1
INPUT #1, lamppoint(l, 0, 0)
INPUT #1, lamppoint(l, 0, 1)
INPUT #1, lamppoint(l, 1, 0)
INPUT #1, lamppoint(l, 1, 1)
NEXT

INPUT #1, curstands
FOR l = 0 TO curstands - 1
INPUT #1, standspoint(l, 0, 0)
INPUT #1, standspoint(l, 0, 1)
INPUT #1, standspoint(l, 1, 0)
INPUT #1, standspoint(l, 1, 1)
NEXT

INPUT #1, curjump
FOR l = 0 TO curjump - 1
INPUT #1, jumppoint(l, 0, 0)
INPUT #1, jumppoint(l, 0, 1)
INPUT #1, jumppoint(l, 1, 0)
INPUT #1, jumppoint(l, 1, 1)
INPUT #1, jumpstat(l, 0)
INPUT #1, jumpstat(l, 1)
INPUT #1, jumpstat(l, 2)
INPUT #1, jumpstat(l, 3)
NEXT
INPUT #1, blha
FOR lp = 0 TO blha * 7 + 7
INPUT #1, jnk
NEXT
FOR lp = 0 TO 1000
INPUT #1, lowline(lp)
NEXT

CLOSE #1
tracklength = tracklength + 1
RETURN

doextras:
nex = 0
FOR lp = 0 TO curjump - 1
   x1 = jumppoint(lp, 0, 0): x2 = jumppoint(lp, 1, 0)
   y1 = jumppoint(lp, 0, 1): y2 = jumppoint(lp, 1, 1)
   Extras(nex).x1 = x1: Extras(nex).y1 = y1: Extras(nex).z1 = 0
   Extras(nex).x2 = x1: Extras(nex).y2 = y2: Extras(nex).z2 = 0: Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).x1 = x1: Extras(nex).y1 = y2: Extras(nex).z1 = 0
   Extras(nex).x2 = x2: Extras(nex).y2 = y2: Extras(nex).z2 = 0: Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).x1 = x2: Extras(nex).y1 = y2: Extras(nex).z1 = 0
   Extras(nex).x2 = x2: Extras(nex).y2 = y1: Extras(nex).z2 = 0: Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).x1 = x2: Extras(nex).y1 = y1: Extras(nex).z1 = 0
   Extras(nex).x2 = x1: Extras(nex).y2 = y1: Extras(nex).z2 = 0: Extras(nex).colour = 4: nex = nex + 1
 
   IF jumpstat(lp, 3) = 0 THEN
   Extras(nex).x1 = x1: Extras(nex).y1 = y1: Extras(nex).z1 = jumpstat(lp, 0)
   Extras(nex).x2 = x2: Extras(nex).y2 = y1: Extras(nex).z2 = jumpstat(lp, 1): Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).x1 = x2: Extras(nex).y1 = y1: Extras(nex).z1 = jumpstat(lp, 1)
   Extras(nex).x2 = x2: Extras(nex).y2 = y2: Extras(nex).z2 = jumpstat(lp, 1): Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).x1 = x2: Extras(nex).y1 = y2: Extras(nex).z1 = jumpstat(lp, 1)
   Extras(nex).x2 = x1: Extras(nex).y2 = y2: Extras(nex).z2 = jumpstat(lp, 0): Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).x1 = x1: Extras(nex).y1 = y1: Extras(nex).z1 = jumpstat(lp, 0)
   Extras(nex).x2 = x1: Extras(nex).y2 = y2: Extras(nex).z2 = jumpstat(lp, 0): Extras(nex).colour = 4: nex = nex + 1
 
   Extras(nex).x1 = x1: Extras(nex).y1 = y1: Extras(nex).z1 = jumpstat(lp, 0)
   Extras(nex).x2 = x1: Extras(nex).y2 = y1: Extras(nex).z2 = 0: Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).x1 = x1: Extras(nex).y1 = y2: Extras(nex).z1 = jumpstat(lp, 0)
   Extras(nex).x2 = x1: Extras(nex).y2 = y2: Extras(nex).z2 = 0: Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).x1 = x2: Extras(nex).y1 = y1: Extras(nex).z1 = jumpstat(lp, 1)
   Extras(nex).x2 = x2: Extras(nex).y2 = y1: Extras(nex).z2 = 0: Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).x1 = x2: Extras(nex).y1 = y2: Extras(nex).z1 = jumpstat(lp, 1)
   Extras(nex).x2 = x2: Extras(nex).y2 = y2: Extras(nex).z2 = 0: Extras(nex).colour = 4: nex = nex + 1
 
   ELSE
   BEEP
   Extras(nex).y1 = y1: Extras(nex).x1 = x1: Extras(nex).z1 = jumpstat(lp, 0)
   Extras(nex).y2 = y2: Extras(nex).x2 = x1: Extras(nex).z2 = jumpstat(lp, 1): Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).y1 = y2: Extras(nex).x1 = x1: Extras(nex).z1 = jumpstat(lp, 1)
   Extras(nex).y2 = y2: Extras(nex).x2 = x2: Extras(nex).z2 = jumpstat(lp, 1): Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).y1 = y2: Extras(nex).x1 = x2: Extras(nex).z1 = jumpstat(lp, 1)
   Extras(nex).y2 = y1: Extras(nex).x2 = x2: Extras(nex).z2 = jumpstat(lp, 0): Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).y1 = y1: Extras(nex).x1 = x1: Extras(nex).z1 = jumpstat(lp, 0)
   Extras(nex).y2 = y1: Extras(nex).x2 = x2: Extras(nex).z2 = jumpstat(lp, 0): Extras(nex).colour = 4: nex = nex + 1

   Extras(nex).y1 = y1: Extras(nex).x1 = x1: Extras(nex).z1 = jumpstat(lp, 0)
   Extras(nex).y2 = y1: Extras(nex).x2 = x1: Extras(nex).z2 = 0: Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).y1 = y1: Extras(nex).x1 = x2: Extras(nex).z1 = jumpstat(lp, 0)
   Extras(nex).y2 = y1: Extras(nex).x2 = x2: Extras(nex).z2 = 0: Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).y1 = y2: Extras(nex).x1 = x1: Extras(nex).z1 = jumpstat(lp, 1)
   Extras(nex).y2 = y2: Extras(nex).x2 = x1: Extras(nex).z2 = 0: Extras(nex).colour = 4: nex = nex + 1
   Extras(nex).y1 = y2: Extras(nex).x1 = x2: Extras(nex).z1 = jumpstat(lp, 1)
   Extras(nex).y2 = y2: Extras(nex).x2 = x2: Extras(nex).z2 = 0: Extras(nex).colour = 4: nex = nex + 1
   END IF
NEXT
compulse = nex


FOR lp = 0 TO curtun - 1
 
   IF (tunpoint(lp, 0, 0) < tunpoint(lp, 1, 0) AND tunpoint(lp, 0, 1) < tunpoint(lp, 1, 1)) OR (tunpoint(lp, 1, 0) > tunpoint(lp, 0, 0) AND tunpoint(lp, 1, 1) > tunpoint(lp, 0, 1)) THEN
      x1 = min(tunpoint(lp, 0, 0), tunpoint(lp, 1, 0)): x2 = max(tunpoint(lp, 0, 0), tunpoint(lp, 1, 0))
      y1 = min(tunpoint(lp, 0, 1), tunpoint(lp, 1, 1)): y2 = max(tunpoint(lp, 0, 1), tunpoint(lp, 1, 1))
      Extras(nex).x1 = x1: Extras(nex).y1 = y1: Extras(nex).z1 = 0
      Extras(nex).x2 = x1: Extras(nex).y2 = y1 - 10: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x1: Extras(nex).y1 = y1 - 10: Extras(nex).z1 = 0
      Extras(nex).x2 = x1: Extras(nex).y2 = y1 - 10: Extras(nex).z2 = 50: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x1: Extras(nex).y1 = y1 - 10: Extras(nex).z1 = 50
      Extras(nex).x2 = x1: Extras(nex).y2 = y2 + 10: Extras(nex).z2 = 50: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x1: Extras(nex).y1 = y2 + 10: Extras(nex).z1 = 50
      Extras(nex).x2 = x1: Extras(nex).y2 = y2 + 10: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x1: Extras(nex).y1 = y2 + 10: Extras(nex).z1 = 0
      Extras(nex).x2 = x1: Extras(nex).y2 = y2: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x1: Extras(nex).y1 = y2: Extras(nex).z1 = 0
      Extras(nex).x2 = x1: Extras(nex).y2 = y2: Extras(nex).z2 = 40: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x1: Extras(nex).y1 = y2: Extras(nex).z1 = 40
      Extras(nex).x2 = x1: Extras(nex).y2 = y1: Extras(nex).z2 = 40: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x1: Extras(nex).y1 = y1: Extras(nex).z1 = 40
      Extras(nex).x2 = x1: Extras(nex).y2 = y1: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1

      Extras(nex).x1 = x2: Extras(nex).y1 = y1: Extras(nex).z1 = 0
      Extras(nex).x2 = x2: Extras(nex).y2 = y1 - 10: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x2: Extras(nex).y1 = y1 - 10: Extras(nex).z1 = 0
      Extras(nex).x2 = x2: Extras(nex).y2 = y1 - 10: Extras(nex).z2 = 50: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x2: Extras(nex).y1 = y1 - 10: Extras(nex).z1 = 50
      Extras(nex).x2 = x2: Extras(nex).y2 = y2 + 10: Extras(nex).z2 = 50: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x2: Extras(nex).y1 = y2 + 10: Extras(nex).z1 = 50
      Extras(nex).x2 = x2: Extras(nex).y2 = y2 + 10: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x2: Extras(nex).y1 = y2 + 10: Extras(nex).z1 = 0
      Extras(nex).x2 = x2: Extras(nex).y2 = y2: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x2: Extras(nex).y1 = y2: Extras(nex).z1 = 0
      Extras(nex).x2 = x2: Extras(nex).y2 = y2: Extras(nex).z2 = 40: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x2: Extras(nex).y1 = y2: Extras(nex).z1 = 40
      Extras(nex).x2 = x2: Extras(nex).y2 = y1: Extras(nex).z2 = 40: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x2: Extras(nex).y1 = y1: Extras(nex).z1 = 40
      Extras(nex).x2 = x2: Extras(nex).y2 = y1: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1

      Extras(nex).x1 = x1: Extras(nex).y1 = y1: Extras(nex).z1 = 0
      Extras(nex).x2 = x2: Extras(nex).y2 = y1: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x1: Extras(nex).y1 = y1 - 10: Extras(nex).z1 = 0
      Extras(nex).x2 = x2: Extras(nex).y2 = y1 - 10: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x1: Extras(nex).y1 = y1 - 10: Extras(nex).z1 = 50
      Extras(nex).x2 = x2: Extras(nex).y2 = y1 - 10: Extras(nex).z2 = 50: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x1: Extras(nex).y1 = y2 + 10: Extras(nex).z1 = 50
      Extras(nex).x2 = x2: Extras(nex).y2 = y2 + 10: Extras(nex).z2 = 50: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x1: Extras(nex).y1 = y2 + 10: Extras(nex).z1 = 0
      Extras(nex).x2 = x2: Extras(nex).y2 = y2 + 10: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x1: Extras(nex).y1 = y2: Extras(nex).z1 = 0
      Extras(nex).x2 = x2: Extras(nex).y2 = y2: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x1: Extras(nex).y1 = y2: Extras(nex).z1 = 40
      Extras(nex).x2 = x2: Extras(nex).y2 = y2: Extras(nex).z2 = 40: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).x1 = x1: Extras(nex).y1 = y1: Extras(nex).z1 = 40
      Extras(nex).x2 = x2: Extras(nex).y2 = y1: Extras(nex).z2 = 40: Extras(nex).colour = 8: nex = nex + 1
   ELSE
      x1 = min(tunpoint(lp, 0, 0), tunpoint(lp, 1, 0)): x2 = max(tunpoint(lp, 0, 0), tunpoint(lp, 1, 0))
      y1 = min(tunpoint(lp, 0, 1), tunpoint(lp, 1, 1)): y2 = max(tunpoint(lp, 0, 1), tunpoint(lp, 1, 1))
  
      Extras(nex).y1 = y1: Extras(nex).x1 = x1: Extras(nex).z1 = 0
      Extras(nex).y2 = y1: Extras(nex).x2 = x1 - 10: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y1: Extras(nex).x1 = x1 - 10: Extras(nex).z1 = 0
      Extras(nex).y2 = y1: Extras(nex).x2 = x1 - 10: Extras(nex).z2 = 50: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y1: Extras(nex).x1 = x1 - 10: Extras(nex).z1 = 50
      Extras(nex).y2 = y1: Extras(nex).x2 = x2 + 10: Extras(nex).z2 = 50: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y1: Extras(nex).x1 = x2 + 10: Extras(nex).z1 = 50
      Extras(nex).y2 = y1: Extras(nex).x2 = x2 + 10: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y1: Extras(nex).x1 = x2 + 10: Extras(nex).z1 = 0
      Extras(nex).y2 = y1: Extras(nex).x2 = x2: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y1: Extras(nex).x1 = x2: Extras(nex).z1 = 0
      Extras(nex).y2 = y1: Extras(nex).x2 = x2: Extras(nex).z2 = 40: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y1: Extras(nex).x1 = x2: Extras(nex).z1 = 40
      Extras(nex).y2 = y1: Extras(nex).x2 = x1: Extras(nex).z2 = 40: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y1: Extras(nex).x1 = x1: Extras(nex).z1 = 40
      Extras(nex).y2 = y1: Extras(nex).x2 = x1: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
                
      Extras(nex).y1 = y2: Extras(nex).x1 = x1: Extras(nex).z1 = 0
      Extras(nex).y2 = y2: Extras(nex).x2 = x1 - 10: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y2: Extras(nex).x1 = x1 - 10: Extras(nex).z1 = 0
      Extras(nex).y2 = y2: Extras(nex).x2 = x1 - 10: Extras(nex).z2 = 50: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y2: Extras(nex).x1 = x1 - 10: Extras(nex).z1 = 50
      Extras(nex).y2 = y2: Extras(nex).x2 = x2 + 10: Extras(nex).z2 = 50: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y2: Extras(nex).x1 = x2 + 10: Extras(nex).z1 = 50
      Extras(nex).y2 = y2: Extras(nex).x2 = x2 + 10: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y2: Extras(nex).x1 = x2 + 10: Extras(nex).z1 = 0
      Extras(nex).y2 = y2: Extras(nex).x2 = x2: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y2: Extras(nex).x1 = x2: Extras(nex).z1 = 0
      Extras(nex).y2 = y2: Extras(nex).x2 = x2: Extras(nex).z2 = 40: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y2: Extras(nex).x1 = x2: Extras(nex).z1 = 40
      Extras(nex).y2 = y2: Extras(nex).x2 = x1: Extras(nex).z2 = 40: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y2: Extras(nex).x1 = x1: Extras(nex).z1 = 40
      Extras(nex).y2 = y2: Extras(nex).x2 = x1: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
                                     
      Extras(nex).y1 = y1: Extras(nex).x1 = x1: Extras(nex).z1 = 0
      Extras(nex).y2 = y2: Extras(nex).x2 = x1: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y1: Extras(nex).x1 = x1 - 10: Extras(nex).z1 = 0
      Extras(nex).y2 = y2: Extras(nex).x2 = x1 - 10: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y1: Extras(nex).x1 = x1 - 10: Extras(nex).z1 = 50
      Extras(nex).y2 = y2: Extras(nex).x2 = x1 - 10: Extras(nex).z2 = 50: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y1: Extras(nex).x1 = x2 + 10: Extras(nex).z1 = 50
      Extras(nex).y2 = y2: Extras(nex).x2 = x2 + 10: Extras(nex).z2 = 50: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y1: Extras(nex).x1 = x2 + 10: Extras(nex).z1 = 0
      Extras(nex).y2 = y2: Extras(nex).x2 = x2 + 10: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y1: Extras(nex).x1 = x2: Extras(nex).z1 = 0
      Extras(nex).y2 = y2: Extras(nex).x2 = x2: Extras(nex).z2 = 0: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y1: Extras(nex).x1 = x2: Extras(nex).z1 = 40
      Extras(nex).y2 = y2: Extras(nex).x2 = x2: Extras(nex).z2 = 40: Extras(nex).colour = 8: nex = nex + 1
      Extras(nex).y1 = y1: Extras(nex).x1 = x1: Extras(nex).z1 = 40
      Extras(nex).y2 = y2: Extras(nex).x2 = x1: Extras(nex).z2 = 40: Extras(nex).colour = 8: nex = nex + 1
   END IF
NEXT
FOR lp = 0 TO curlamp - 1
   x1 = lamppoint(lp, 0, 0): x2 = lamppoint(lp, 1, 0)
   y1 = lamppoint(lp, 0, 1): y2 = lamppoint(lp, 1, 1)
   Extras(nex).x1 = x1 + 1.5: Extras(nex).y1 = y1: Extras(nex).z1 = 0
   Extras(nex).x2 = x1: Extras(nex).y2 = y1 + 1.5: Extras(nex).z2 = 0: Extras(nex).colour = 7: nex = nex + 1
   Extras(nex).x1 = x1: Extras(nex).y1 = y1 + 1.5: Extras(nex).z1 = 0
   Extras(nex).x2 = x1 - 1.5: Extras(nex).y2 = y1: Extras(nex).z2 = 0: Extras(nex).colour = 7: nex = nex + 1
   Extras(nex).x1 = x1 - 1.5: Extras(nex).y1 = y1: Extras(nex).z1 = 0
   Extras(nex).x2 = x1: Extras(nex).y2 = y1 - 1.5: Extras(nex).z2 = 0: Extras(nex).colour = 7: nex = nex + 1
   Extras(nex).x1 = x1: Extras(nex).y1 = y1 - 1.5: Extras(nex).z1 = 0
   Extras(nex).x2 = x1 + 1.5: Extras(nex).y2 = y1: Extras(nex).z2 = 0: Extras(nex).colour = 7: nex = nex + 1

   Extras(nex).x1 = x1 + 1.5: Extras(nex).y1 = y1: Extras(nex).z1 = 0
   Extras(nex).x2 = x1 + 1: Extras(nex).y2 = y1: Extras(nex).z2 = 50: Extras(nex).colour = 7: nex = nex + 1
   Extras(nex).x1 = x1: Extras(nex).y1 = y1 + 1.5: Extras(nex).z1 = 0
   Extras(nex).x2 = x1: Extras(nex).y2 = y1 + 1: Extras(nex).z2 = 50: Extras(nex).colour = 7: nex = nex + 1
   Extras(nex).x1 = x1 - 1.5: Extras(nex).y1 = y1: Extras(nex).z1 = 0
   Extras(nex).x2 = x1 - 1: Extras(nex).y2 = y1: Extras(nex).z2 = 50: Extras(nex).colour = 7: nex = nex + 1
   Extras(nex).x1 = x1: Extras(nex).y1 = y1 - 1.5: Extras(nex).z1 = 0
   Extras(nex).x2 = x1: Extras(nex).y2 = y1 - 1: Extras(nex).z2 = 50: Extras(nex).colour = 7: nex = nex + 1

   Extras(nex).x1 = x2: Extras(nex).y1 = y2: Extras(nex).z1 = 55
   Extras(nex).x2 = x1 + 1: Extras(nex).y2 = y1: Extras(nex).z2 = 50: Extras(nex).colour = 7: nex = nex + 1
   Extras(nex).x1 = x2: Extras(nex).y1 = y2: Extras(nex).z1 = 55
   Extras(nex).x2 = x1: Extras(nex).y2 = y1 + 1: Extras(nex).z2 = 50: Extras(nex).colour = 7: nex = nex + 1
   Extras(nex).x1 = x2: Extras(nex).y1 = y2: Extras(nex).z1 = 55
   Extras(nex).x2 = x1 - 1: Extras(nex).y2 = y1: Extras(nex).z2 = 50: Extras(nex).colour = 7: nex = nex + 1
   Extras(nex).x1 = x2: Extras(nex).y1 = y2: Extras(nex).z1 = 55
   Extras(nex).x2 = x1: Extras(nex).y2 = y1 - 1: Extras(nex).z2 = 50: Extras(nex).colour = 7: nex = nex + 1
        
   Extras(nex).x1 = x2: Extras(nex).y1 = y2 - 2: Extras(nex).z1 = 55
   Extras(nex).x2 = x2 + 2: Extras(nex).y2 = y2 - 2: Extras(nex).z2 = 55: Extras(nex).colour = 14: nex = nex + 1
   Extras(nex).x1 = x2 + 2: Extras(nex).y1 = y2 - 2: Extras(nex).z1 = 55
   Extras(nex).x2 = x2 + 2: Extras(nex).y2 = y2 + 2: Extras(nex).z2 = 55: Extras(nex).colour = 14: nex = nex + 1
   Extras(nex).x1 = x2 + 2: Extras(nex).y1 = y2 + 2: Extras(nex).z1 = 55
   Extras(nex).x2 = x2: Extras(nex).y2 = y2 + 2: Extras(nex).z2 = 55: Extras(nex).colour = 14: nex = nex + 1
   Extras(nex).x1 = x2: Extras(nex).y1 = y2 + 2: Extras(nex).z1 = 55
   Extras(nex).x2 = x2: Extras(nex).y2 = y2 - 2: Extras(nex).z2 = 55: Extras(nex).colour = 14: nex = nex + 1
NEXT

FOR lp = 0 TO curbill - 1
   x1 = billpoint(lp, 0, 0): x2 = billpoint(lp, 1, 0)
   y1 = billpoint(lp, 0, 1): y2 = billpoint(lp, 1, 1)
   colr = (lp \ 2 MOD 15) + 1
   Extras(nex).x1 = x1: Extras(nex).y1 = y1: Extras(nex).z1 = 0
   Extras(nex).x2 = x1: Extras(nex).y2 = y1: Extras(nex).z2 = 30: Extras(nex).colour = 6: nex = nex + 1
   Extras(nex).x1 = x2: Extras(nex).y1 = y2: Extras(nex).z1 = 0
   Extras(nex).x2 = x2: Extras(nex).y2 = y2: Extras(nex).z2 = 30: Extras(nex).colour = 6: nex = nex + 1
   Extras(nex).x1 = x1: Extras(nex).y1 = y1: Extras(nex).z1 = 28
   Extras(nex).x2 = x2: Extras(nex).y2 = y2: Extras(nex).z2 = 28: Extras(nex).colour = colr: nex = nex + 1
   Extras(nex).x1 = x1: Extras(nex).y1 = y1: Extras(nex).z1 = 10
   Extras(nex).x2 = x2: Extras(nex).y2 = y2: Extras(nex).z2 = 10: Extras(nex).colour = colr: nex = nex + 1
   Extras(nex).x1 = x2: Extras(nex).y1 = y2: Extras(nex).z1 = 10
   Extras(nex).x2 = x2: Extras(nex).y2 = y2: Extras(nex).z2 = 28: Extras(nex).colour = colr: nex = nex + 1
   Extras(nex).x1 = x1: Extras(nex).y1 = y1: Extras(nex).z1 = 10
   Extras(nex).x2 = x1: Extras(nex).y2 = y1: Extras(nex).z2 = 28: Extras(nex).colour = colr: nex = nex + 1
NEXT
PRINT #1, nex
PRINT #1, compulse

CLS
FOR lp = 0 TO nex
PRINT #1, Extras(lp).x1
PRINT #1, Extras(lp).x2
PRINT #1, Extras(lp).y1
PRINT #1, Extras(lp).y2
PRINT #1, Extras(lp).z1
PRINT #1, Extras(lp).z2
PRINT #1, Extras(lp).colour

x1# = (Extras(lp).y1 / (1 + Extras(lp).x1 / 150)) + 160
y1# = (Extras(lp).z1 / (1 + Extras(lp).x1 / 150)) + 100

x2# = (Extras(lp).y2 / (1 + Extras(lp).x2 / 150)) + 160
y2# = (Extras(lp).z2 / (1 + Extras(lp).x2 / 150)) + 100
LOCATE 1, 1: PRINT Extras(lp).x1; Extras(lp).x2; Extras(lp).y1; Extras(lp).y2; Extras(lp).z1; Extras(lp).z2
LINE (x1#, y1#)-(x2#, y2#), Extras(lp).colour
NEXT
SLEEP
RETURN

FUNCTION max (var1, var2)
IF var2 > var1 THEN max = var2 ELSE max = var1
END FUNCTION

FUNCTION min (var1, var2)
IF var2 < var1 THEN min = var2 ELSE min = var1

END FUNCTION

