#include <malloc.h>
#include <stdlib.h>

typedef unsigned int word;
typedef unsigned char byte;

void setmode(byte mode);
void plot(word x, word y, byte colour);
void fastclear(byte colour);
void fastcleararea(byte colour, word x, word y, word length, word height);
void setcolour(word number, byte red,byte green, byte blue);
void putwall(byte *data,word height,word length,word x,word y);
byte *makemidwall(byte *data,word height, word length);
byte *makemidleftwall(byte *data,word height, word length);
byte *makemidrightwall(byte *data,word height, word length);
byte *makefrontleftwall(byte *data,word height, word length);
byte *makefrontrightwall(byte *data,word height, word length);
byte *makefarwall(byte *data,word height, word length);
byte *makefarrightwall(byte *data,word height, word length);
byte *makefarleftwall(byte *data,word height, word length);
byte *makeleftperwall(byte *data,word height, word length);
byte *makerightperwall(byte *data,word height, word length);
byte *stretchleft(byte *data, word height, word length);
byte *stretchright(byte *data, word height, word length);

void setmode(byte mode)
{
  asm mov ah,0
  asm mov al,mode
  asm int 0x10

}

void plot(word x, word y, byte colour)
{
  asm mov ax,0x0a000
  asm mov es,ax
  asm mov bx,y
  asm mov ax,320
  asm mul bx
  asm mov bx,x
  asm add ax,bx
  asm mov di,ax
  asm mov al,colour
  asm stosb
}

void fastclear(byte colour)
{
  asm mov ax,0x0a000
  asm mov es,ax
  asm xor di,di
  asm mov cx,64000
  asm mov al,colour
  asm rep stosb
}

void fastcleararea(byte colour, word x, word y, word length, word height)
{
  asm mov ax,0x0a000
  asm mov es,ax
  asm xor di,di
  asm mov bx,y
  asm mov ax,320
  asm mul bx
  asm mov bx,x
  asm add ax,bx
  asm mov di,ax
  asm mov ax,320
  asm mov bx,length
  asm sub ax,bx
  asm mov bx,ax
  asm mov dx,height
  asm mov al,colour
  myloop:
  asm mov cx,length
  asm rep stosb
  asm dec dx
  asm add di,bx
  asm cmp dx,0
  asm jnz myloop
}

void setcolour(word number, byte red,byte green, byte blue)
{
  asm mov ax,0x1010
  asm mov bx,number
  asm mov ch,green
  asm mov cl,blue
  asm mov dh,red
  asm int 0x010
}

void putwall(byte *data,word height,word length,word x,word y)
{
  word i,j;

  for(i=0;i<height;i++)
	for(j=0;j<length;j++)
		{
		plot(x+j,y+i,*data);
		data++;
		}
}

byte *makemidwall(byte *data,word height, word length)
{
  word i,j;
  byte *temp;

  if((temp = (byte *) malloc ((height/2)*(length/2)))==NULL) exit(1);
  for(i=0;i<height/2;i++)
	{
	for(j=0;j<length/2;j++)
		{
		temp[(i*length/2)+j] = data[(i*length*2)+(2*j)];
		}
	}
  return temp;
}

byte *makefarwall(byte *data,word height, word length)
{
  word i,j;
  byte *temp;

  if((temp = (byte *) malloc ((height/4)*(length/4)))==NULL) exit(1);
  for(i=0;i<height/4;i++)
	{
	for(j=0;j<length/4;j++)
		{
		temp[(i*length/4)+j] = data[(i*length*4)+(4*j)];
		}
	}
  return temp;
}

byte *makefrontrightwall(byte *data,word height, word length)
{

  word i,j;
  byte *temp;

  if((temp = (byte *) malloc ((height)*(length/3)))==NULL) exit(1);
  for(i=0;i<height;i++)
	{
	for(j=0;j<length/3;j++)
		{
		temp[(i*length/3)+j] = data[(i*length)+j];
		}
	}
  return temp;

}

byte *makefrontleftwall(byte *data,word height, word length)
{

  word i,j;
  byte *temp;

  if((temp = (byte *) malloc ((height)*(length/3)))==NULL) exit(1);
  for(i=0;i<height;i++)
	{
	for(j=0;j<length/3;j++)
		{
		temp[(i*length/3)+j] = data[((i+1)*length)+(j-length/3)];
		}
	}
  return temp;

}

byte *makemidleftwall(byte *data,word height, word length)
{

  word i,j;
  byte *temp;

  if((temp = (byte *) malloc ((height/2)*(length/6)))==NULL) exit(1);
  for(i=0;i<height/2;i++)
	{
	for(j=0;j<length/3;j++)
		{
		temp[(i*length/6)+j] = data[((i+1)*length*2)+(j-length/6)];
		}
	}
  return temp;

}


byte *makemidrightwall(byte *data,word height, word length)
{

  word i,j;
  byte *temp;

  if((temp = (byte *) malloc ((height/2)*(length/6)))==NULL) exit(1);
  for(i=0;i<height/2;i++)
	{
	for(j=0;j<length/6;j++)
		{
		temp[(i*length/6)+j] = data[(i*length*2)+(2*j)];
		}
	}
  return temp;

}

byte *makefarleftwall(byte *data,word height, word length)
{

  word i,j;
  byte *temp;

  if((temp = (byte *) malloc ((height/3)*(length/9)))==NULL) exit(1);
  for(i=0;i<height/4;i++)
	{
	for(j=0;j<length/12;j++)
		{
		temp[(i*length/12)+j] = data[((i+1)*length*4)+(j-length/12)];
		}
	}
  return temp;

}


byte *makefarrightwall(byte *data,word height, word length)
{

  word i,j;
  byte *temp;

  if((temp = (byte *) malloc ((height/3)*(length/9)))==NULL) exit(1);
  for(i=0;i<height/4;i++)
	{
	for(j=0;j<length/12;j++)
		{
		temp[(i*length/12)+j] = data[(i*length*4)+(4*j)];
		}
	}
  return temp;

}

byte *makeleftperwall(byte *data,word height, word length)
{
  byte *temp;
  byte *temp2;
  word i,j;
  word store;

  store = (height-(length/2))/2;
  if((temp = (byte *) malloc (height*store))==NULL) exit(1);
  if((temp2 = (byte *) malloc (height*store))==NULL) exit(1);


  for(i=0;i<height/4;i++)
    for(j=0;j<store;j++)
     {
     temp[(i*store)+j]=1;
     temp[((i+(3*height/4))*store)+j]=1;
     }

  for(i=height/4;i<3*height/4;i++)
    for(j=0;j<store;j++)
	{
	temp[(i*store)+j] = data[((i-store)*height*2)+4*j];
	}

   for(i=0;i<height/2;i++)
	   for(j=0;j<store;j++)
	{
	temp2[j+((height/2)+i)*store] =
		 temp[j+((height/2)+(i*store/((height/2)-j)))*store];
	temp2[j+((height/2)-1-i)*store] =
		 temp[j+((height/2)-(i*store/((height/2)-j)))*store];
	}
   return temp2;
}

byte *makerightperwall(byte *data,word height, word length)
{
  byte *temp;
  byte *temp2;
  word i,j;
  word store;

  store = (height-(length/2))/2;
  if((temp = (byte *) malloc (height*store))==NULL) exit(1);
  if((temp2 = (byte *) malloc (height*store))==NULL) exit(1);


  for(i=0;i<height/4;i++)
    for(j=0;j<store;j++)
     {
     temp[(i*store)+j]=1;
     temp[((i+(3*height/4))*store)+j]=1;
     }

  for(i=height/4;i<3*height/4;i++)
    for(j=0;j<store;j++)
	{
	temp[(i*store)+j] = data[((i-store)*height*2)+4*j];
	}

   for(i=0;i<height/2;i++)
	   for(j=store;j>0;j--)
	{
	temp2[store-j+((height/2)+i)*store] =
		 temp[j+((height/2)+(i*store/((height/2)-j)))*store];
	temp2[store-j+((height/2)-1-i)*store] =
		 temp[j+((height/2)-(i*store/((height/2)-j)))*store];
	}
   return temp2;
}

byte *stretchleft(byte *data, word height, word length)
{
  byte *temp,*temp2;
  word store,htob,i,j;

  htob = height*4/3;
  store = (htob-height)/2;

  if((temp=(byte *)malloc(htob*store))==NULL) exit(1);
  if((temp2=(byte *)malloc(htob*store))==NULL) exit(1);

  for(i=0;i<store;i++)
    for(j=0;j<store;j++)
     {
     temp[(i*store)+j]=6;
     temp[((i+height+store)*store)+j]=2;
     }

  for(i=0;i<height;i++)
    for(j=0;j<store;j++)
	{
	temp[((i+store)*store)+j] = data[(i*length)+2*j];
	}
  return temp;

 /*  for(i=0;i<height;i++)
	   for(j=store;j>0;j--)
	{
	temp2[store-j+((height)+i)*store] =
		 temp[j+((height)+(i*store*3/((height*4)-j)))*store];
	temp2[store-j+((height)-1-i)*store] =
		 temp[j+((height)-(i*store/((height)-j)))*store];
	}

    return temp2;
   */
}

byte *stretchright(byte *data, word height, word length)
{
  byte *temp,*temp2;
  word store,htob,i,j;

  htob = height*4/3;
  store = (htob-height)/2;

  if((temp=(byte *)malloc(htob*store))==NULL) exit(1);
  if((temp2=(byte *)malloc(htob*store))==NULL) exit(1);

  for(i=0;i<store;i++)
    for(j=0;j<store;j++)
     {
     temp[(i*store)+j]=6;
     temp[((i+height+store)*store)+j]=2;
     }

  for(i=0;i<height;i++)
    for(j=0;j<store;j++)
	{
	temp[((i+store)*store)+j] = data[(i*length)+2*j];
	}
  return temp;

}

