DECLARE SUB drawborder ()
DECLARE SUB addbigtrees ()
DECLARE SUB addstaticsprite (px%, py%, pz%, pframe%)
DECLARE SUB loadtlu ()
DECLARE SUB tilevanish (px%, py%)
DECLARE SUB collidemariotiles ()
DECLARE SUB clearsprites ()
DECLARE SUB addmariosprite ()
DECLARE SUB addsprite (px%, py%, pz%, pframe%, pflip%)
DECLARE SUB addsprites ()
DECLARE SUB init ()
DECLARE SUB playgame ()
DECLARE SUB minlimit (pint%, pmin%)
DECLARE SUB limitcamera ()
DECLARE SUB domario ()
DECLARE SUB docamera ()
DECLARE SUB initmario ()
DECLARE SUB initlevel ()
DECLARE SUB exitgame ()
DECLARE SUB cleanup ()
DECLARE SUB initvariables ()
DECLARE SUB docoins ()
DECLARE SUB saveold ()
DECLARE SUB maxlimit (pint%, pmax%)
DECLARE SUB dosnow ()
DECLARE SUB initstatussprites ()
DECLARE SUB initsnowflakes ()
DECLARE SUB addstatussprite (px%, py%, pframe%)
DECLARE SUB loadimx ()
DECLARE SUB onkb ()
DECLARE SUB offkb ()
DECLARE SUB loadpalette ()
DECLARE SUB loadlevel ()
DECLARE SUB loadtiles ()
DECLARE SUB drawscreen ()
DECLARE SUB inittilelookup ()
DECLARE SUB loadassembly ()
CLS
SCREEN 13

'Define files
CONST MAXIMXFILES = 10
DIM SHARED imxfile$(MAXIMXFILES)
DIM SHARED levelfile$, tilefile$, palfile$, imxfile$, asmfile1$, asmfile2$
DIM SHARED tlufile1$
levelfile$ = "ice.lev"
tilefile$ = "ice.til"
palfile$ = "nintendo.pal"
asmfile1$ = "ngrafix.rtn"
asmfile2$ = "keyb2.rtn"
tlufile1$ = "mario.tlu"
imxfile$(0) = "level1.imx"
imxfile$(1) = "hero.imx"

'Define constants
CONST SNOWON = 1
CONST MAXSTATICSPRITES = 100
CONST MAXDYNAMICSPRITES = 100
CONST MAXSTATUSSPRITES = 200
CONST COINROTATEDELAY = 12
CONST MARIOXSPEEDFRICTION = .08
CONST MARIOYSPEEDFRICTION = .02
CONST MARIOXACCEL = .15
CONST GRAVITY = .1
CONST JUMPHEIGHT = 5
CONST JUMPBUTTON = 72
CONST MARIODUCKDELAY = 8
CONST DUCKSLIDESPEEDFACTOR = 2

'Define types
TYPE spritetype
  x AS INTEGER
  z AS INTEGER
  y AS INTEGER
  frame AS INTEGER
  colourtable AS INTEGER
  flip AS INTEGER
END TYPE

TYPE statusspritetype
  x AS INTEGER
  y AS INTEGER
  z AS INTEGER
  frame AS INTEGER
  colourtable AS INTEGER
  flip AS INTEGER
END TYPE

TYPE mariotype
  x AS SINGLE
  y AS SINGLE
  dx AS SINGLE
  dy AS SINGLE
  oldx AS SINGLE
  oldy AS SINGLE
  z AS INTEGER
  frame AS INTEGER
  flip AS INTEGER
  walkframe AS SINGLE
  duckcountdown AS INTEGER
  mode AS INTEGER            '0 = walk   1 = jump   2 = duck
  slideairflag AS INTEGER
END TYPE

'Define globals
DIM SHARED ngrafixrtn%(2048)
DIM SHARED tiles%(32766)
DIM SHARED level%(6000), levelxsize%, levelysize%
DIM SHARED imx%(10000)
DIM SHARED camerax%, cameray%
DIM SHARED tilelookup%(255)
DIM SHARED staticsprite(MAXSTATICSPRITES) AS spritetype
DIM SHARED sprite(MAXDYNAMICSPRITES) AS spritetype
DIM SHARED statussprite(MAXSTATUSSPRITES) AS statusspritetype
DIM SHARED doublebuffer%(2560)
DIM SHARED spritestream%((MAXSTATICSPRITES + MAXDYNAMICSPRITES + MAXSTATUSSPRITES) * 8)
DIM SHARED totalstaticsprites%, totalsprites%, totalstatussprites%
DIM SHARED pal%(512)
DIM SHARED kbcontrol%(128), kbmatrix%(128), keyboardonflag%
DIM SHARED oldcamerax%, oldcameray%
DIM SHARED dosnowdelay%, dosnowdelay2%
DIM SHARED coinspincountdown%, coinframe%, coinanimdelta%
DIM SHARED char AS STRING * 1
DIM SHARED tlu%(256)
DIM SHARED mariotilepattern%

'Game variables
'Mario variables
DIM SHARED mario AS mariotype
DIM SHARED oldjumpbutton%

init
playgame
exitgame

SUB addbigtrees
addstaticsprite -5, 267, 1, 4
addstaticsprite 5, 267, -1, 4
addstaticsprite -15, 267, -1, 4

addstaticsprite 125, 299, 1, 4


addstaticsprite 450, 235, -1, 4
addstaticsprite 465, 235, 1, 4
addstaticsprite 470, 235, -2, 4
addstaticsprite 483, 235, -1, 4
addstaticsprite 490, 235, 1, 4

addstaticsprite 526, 251, 1, 4
addstaticsprite 626, 331, 1, 4

END SUB

SUB addmariosprite
addsprite INT(mario.x), INT(mario.y), mario.z, mario.frame, mario.flip
END SUB

SUB addsprite (px%, py%, pz%, pframe%, pflip%)
i% = totalsprites%
IF i% >= MAXDYNAMICSPRITES THEN EXIT SUB
sprite(i%).x = px%
sprite(i%).y = py%
sprite(i%).z = pz%
sprite(i%).frame = pframe%
sprite(i%).flip = pflip%
totalsprites% = i% + 1
END SUB

SUB addsprites
addmariosprite
END SUB

SUB addstaticsprite (px%, py%, pz%, pframe%)
i% = totalstaticsprites%
IF i% >= MAXSTATICSPRITES THEN EXIT SUB
staticsprite(i%).x = px%
staticsprite(i%).y = py%
staticsprite(i%).z = pz%
staticsprite(i%).frame = pframe%
totalstaticsprites% = i% + 1
END SUB

SUB addstatussprite (px%, py%, pframe%)
i% = totalstatussprites%
IF i% >= MAXSTATUSSPRITES THEN EXIT SUB
statussprite(i%).x = px%
statussprite(i%).y = py%
statussprite(i%).frame = pframe%
totalstatussprites% = i% + 1
END SUB

SUB cleanup
offkb
END SUB

SUB clearsprites
totalsprites% = 0
END SUB

SUB collidemariotiles
x = mario.x
y = mario.y
dx = mario.dx
dy = mario.dy
ox = mario.oldx
oy = mario.oldy
x1% = x
y1% = y
x2% = x1% + 15
y2% = y1%
x3% = x2%
y3% = y1% + 15
x4% = x1%
y4% = y3%
i1% = ((y1% \ 16)) * levelxsize% + ((x1% \ 16))
i2% = ((y2% \ 16)) * levelxsize% + ((x2% \ 16))
i3% = ((y3% \ 16)) * levelxsize% + ((x3% \ 16))
i4% = ((y4% \ 16)) * levelxsize% + ((x4% \ 16))
DEF SEG = VARSEG(level%(0))
t1% = PEEK(VARPTR(level%(0)) + i1%)
t2% = PEEK(VARPTR(level%(0)) + i2%)
t3% = PEEK(VARPTR(level%(0)) + i3%)
t4% = PEEK(VARPTR(level%(0)) + i4%)
DEF SEG
l1% = tlu%(t1%) AND 1
l2% = tlu%(t2%) AND 1
l3% = tlu%(t3%)
l4% = tlu%(t4%)
IF l3% = 2 AND dy > 0 THEN
  l3% = 1
ELSE
  l3% = l3% AND 1
END IF
IF l4% = 2 AND dy > 0 THEN
  l4% = 1
ELSE
  l4% = l4% AND 1
END IF
byte% = l1% + l2% + l2% + l3% + l3% + l3% + l3% + l4% + l4% + l4% + l4% + l4% + l4% + l4% + l4%
SELECT CASE byte%
CASE 1
  IF ox \ 16 = x \ 16 THEN
    y = (y AND &HFFF0) + 16
    dy = 0
  ELSE
    x = (x AND &HFFF0) + 16
    dx = 0
  END IF
CASE 2
  IF (ox + 15) \ 16 = x \ 16 + 1 THEN
    y = (y AND &HFFF0) + 16
    dy = 0
  ELSE
    x = (x AND &HFFF0)
    dx = 0
  END IF
CASE 4
  IF (((ox + 15) \ 16) = (x \ 16 + 1)) OR (x < ox) THEN
    y = (y AND &HFFF0) + 1
    dy = 0
  ELSE
    x = (x AND &HFFF0)
    dx = 0
  END IF
CASE 8
  IF (ox \ 16 = x \ 16) OR (ox < x) THEN
    y = (y AND &HFFF0) + 1
    dy = 0
  ELSE
    x = (x AND &HFFF0) + 16
    dx = 0
  END IF
CASE 3
y = (y AND &HFFF0) + 16
dy = 0
CASE 6
x = (x AND &HFFF0)
dx = 0
CASE 12
y = (y AND &HFFF0) + 1
dy = 0
CASE 9
x = (x AND &HFFF0) + 16
dx = 0
CASE 7
x = (x AND &HFFF0)
dx = 0
y = (y AND &HFFF0) + 16
dy = 0
CASE 14
x = (x AND &HFFF0)
dx = 0
y = (y AND &HFFF0) + 1
dy = 0
CASE 13
x = (x AND &HFFF0) + 16
dx = 0
y = (y AND &HFFF0) + 1
dy = 0
CASE 11
x = (x AND &HFFF0) + 16
dx = 0
y = (y AND &HFFF0) + 16
dy = 0
CASE 10
IF x < oldx THEN
  x = (x AND &HFFF0) + 16
  dx = 0
  y = (y AND &HFFF0) + 16
  dy = 0
ELSE
  x = (x AND &HFFF0)
  dx = 0
  y = (y AND &HFFF0) + 1
  dy = 0
END IF
CASE 5
IF x < oldx THEN
  x = (x AND &HFFF0) + 16
  dx = 0
  y = (y AND &HFFF0) + 1
  dy = 0
ELSE
  x = (x AND &HFFF0)
  dx = 0
  y = (y AND &HFFF0) + 16
  dy = 0
END IF
END SELECT
mario.x = x
mario.y = y
mario.dx = dx
mario.dy = dy
mario.oldx = ox
mario.oldy = oy
'Pick up coins
FOR i% = 0 TO 3
  SELECT CASE i%
    CASE 0
      t% = t1%
      x% = x1%
      y% = y1%
    CASE 1
      t% = t2%
      x% = x2%
      y% = y2%
    CASE 2
      t% = t3%
      x% = x3%
      y% = y3%
    CASE 3
      t% = t4%
      x% = x4%
      y% = y4%
  END SELECT
  SELECT CASE t%
    CASE 11
      tilevanish x%, y%
  END SELECT
NEXT
mariotilepattern% = byte%
END SUB

SUB docamera
camerax% = INT(mario.x) - 72
cameray% = INT(mario.y) - 42
limitcamera
END SUB

SUB docoins
c% = coinspincountdown%
c% = c% - 1
IF c% <= 0 THEN
  c% = COINROTATEDELAY
  f% = coinframe%
  f% = f% + coinanimdelta%
  IF f% > 2 OR f% < 0 THEN
    coinanimdelta% = -coinanimdelta%
    f% = f% + coinanimdelta%
    f% = f% + coinanimdelta%
  END IF
  tilelookup%(11) = f% + 11
  coinframe% = f%
END IF
coinspincountdown% = c%
END SUB

DEFINT C
SUB domario
x = mario.x
y = mario.y
dx = mario.dx
dy = mario.dy
IF kbmatrix%(77) THEN dx = dx + MARIOXACCEL
IF kbmatrix%(75) THEN dx = dx - MARIOXACCEL
f = MARIOXSPEEDFRICTION
IF mario.mode = 2 OR mario.slideairflag = 1 THEN f = f / DUCKSLIDESPEEDFACTOR
dx = dx - dx * f
dy = dy + GRAVITY
dy = dy - dy * MARIOYSPEEDFRICTION
x = x + dx
y = y + dy
mario.x = x
mario.y = y
mario.dx = dx
mario.dy = dy
collidemariotiles
IF kbmatrix%(JUMPBUTTON) = 1 THEN
  IF (mariotilepattern% AND 12) > 0 THEN
    IF oldjumpbutton% = 0 THEN
      mario.dy = -JUMPHEIGHT
      mario.mode = 1
    END IF
  END IF
END IF
IF (mariotilepattern% AND 12) > 0 THEN
  IF mario.mode > 0 THEN
    mario.mode = 0
    mario.slideairflag = 0
    mario.duckcountdown = MARIODUCKDELAY
  END IF
  w = mario.walkframe
  w = w + ABS(mario.dx) / 10
  IF w >= 4 THEN w = w - 4
  SELECT CASE INT(w)
    CASE 0
      f% = 64
    CASE 1
      f% = 65
    CASE 2
      f% = 64
    CASE 3
      f% = 66
  END SELECT
  mario.walkframe = w
  mario.frame = f%
  c = mario.duckcountdown
  IF c > 0 THEN
    c = c - 1
    mario.frame = 68
  END IF
  mario.duckcountdown = c
  IF kbmatrix%(80) THEN
    mario.frame = 68
    mario.mode = 2
  END IF
ELSE
  IF mario.mode = 2 THEN
    mario.dy = -.5
    mario.slideairflag = 1
  END IF
  mario.mode = 1
  mario.frame = 67
END IF
mario.flip = 0
SELECT CASE mario.dx
  CASE IS < 0: mario.flip = 1
END SELECT
oldjumpbutton% = kbmatrix%(JUMPBUTTON)
IF mario.y > (levelysize% * 16) THEN exitgame
IF mario.x < 0 THEN mario.x = 0
IF mario.y < 0 THEN mario.y = 0
END SUB

DEFSNG C
SUB dosnow
l0% = dosnowdelay%
l0% = l0% - 1
IF l0% <= 0 THEN l0% = 2
dosnowdelay% = l0%
l2% = dosnowdelay2%
l2% = l2% - 1
IF l2% <= 0 THEN l2% = 1
dosnowdelay2% = l2%

FOR i% = 0 TO 23
  x% = statussprite(i%).x
  y% = statussprite(i%).y
  d% = 0
  SELECT CASE statussprite(i%).frame
    CASE 0
      d% = 1
    CASE 1
      IF l2% = 1 THEN d% = 1
    CASE 2
      IF l0% = 2 THEN d% = 1
  END SELECT
  x% = x% + d% + (oldcamerax% - camerax%)
  y% = y% + d% + (oldcameray% - cameray%)
  IF x% > 160 THEN x% = -8
  IF y% > 100 THEN y% = -8
  IF x% < -8 THEN x% = 160
  IF y% < -8 THEN y% = 100
  statussprite(i%).x = x%
  statussprite(i%).y = y%
NEXT
EXIT SUB

END SUB

SUB drawborder
LINE (0, 0)-(319, 199), 144, BF
LINE (79, 49)-(240, 150), 150, B
END SUB

SUB drawscreen
ngrafixrtn%(4) = levelxsize%
ngrafixrtn%(5) = camerax%
ngrafixrtn%(6) = cameray%
ngrafixrtn%(11) = totalstaticsprites%
ngrafixrtn%(14) = totalsprites%
ngrafixrtn%(17) = totalstatussprites%
WAIT &H3DA, 8
WAIT &H3DA, 8, 8
DEF SEG = VARSEG(ngrafixrtn%(0))
CALL absolute(&H600)
DEF SEG
clearsprites
END SUB

SUB exitgame
cleanup
SCREEN 0
WIDTH 80, 25
COLOR 7, 0
CLS
PRINT "Merry Christmas!!!"
SYSTEM
END SUB

SUB imxDOC
'frame range    description
'0-63           background / foreground sprites
'64-            mario
END SUB

SUB init
RANDOMIZE 3
loadassembly
inittilelookup
loadpalette
loadlevel
loadtiles
loadimx
loadtlu
drawborder
initstatussprites
initvariables
onkb
END SUB

SUB initlevel
coinanimdelta% = 1
END SUB

SUB initmario
mario.x = 50
mario.y = 288
mario.z = 0
mario.frame = 64
mario.flip = 0
mario.walkframe = 0
mario.mode = 0
mario.slideairflag = 1
END SUB

SUB initsnowflakes
FOR i% = 0 TO 23
  x% = INT(RND * 160)
  y% = INT(RND * 100)
  f% = INT(RND * 4)
  SELECT CASE f%
    CASE 0
      f% = 0
    CASE 1
      f% = 1
    CASE 2
      f% = 2
    CASE 3
      f% = 2
  END SELECT
  addstatussprite x%, y%, f%
NEXT
END SUB

SUB initstatussprites
IF SNOWON THEN initsnowflakes
END SUB

SUB inittilelookup
FOR i% = 0 TO 255
tilelookup%(i%) = i%
NEXT
END SUB

SUB initvariables
initmario
initlevel
END SUB

SUB limitcamera
x% = camerax%
y% = cameray%
minlimit x%, 0
minlimit y%, 0
maxlimit x%, (levelxsize% * 16) - 160
maxlimit y%, (levelysize% * 16) - 100
camerax% = x%
cameray% = y%
END SUB

SUB loadassembly
'Load graphics engine
DEF SEG = VARSEG(ngrafixrtn%(0))
BLOAD asmfile1$, 0
i& = 0
n& = VARSEG(tiles%(0)): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
n& = VARPTR(tiles%(0)): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
n& = VARSEG(level%(0)): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
n& = VARPTR(level%(0)): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
i& = i& + 6
n& = VARSEG(tilelookup%(0)): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
n& = VARPTR(tilelookup%(0)): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
n& = VARSEG(staticsprite(0).x): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
n& = VARPTR(staticsprite(0).x): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
i& = i& + 2
n& = VARSEG(sprite(0).x): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
n& = VARPTR(sprite(0).x): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
i& = i& + 2
n& = VARSEG(statussprite(0).x): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
n& = VARPTR(statussprite(0).x): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
i& = i& + 2
n& = VARSEG(doublebuffer%(0)): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
n& = VARPTR(doublebuffer%(0)): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
n& = VARSEG(spritestream%(0)): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
n& = VARPTR(spritestream%(0)): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
i& = i& + 2
n& = VARSEG(imx%(0)): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
n& = VARPTR(imx%(0)): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
DEF SEG
'Load keyboard interrupt
DEF SEG = VARSEG(kbcontrol%(0))
BLOAD asmfile2$, 0
i& = 16
n& = VARSEG(kbmatrix%(0)): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
n& = VARPTR(kbmatrix%(0)): l& = n& AND 255: h& = (n& AND &HFF00) \ 256: POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
DEF SEG
END SUB

SUB loadimx
n% = 0
imx%(0) = 0
'Count frames
DO WHILE imxfile$(n%) <> ""
  OPEN imxfile$(n%) FOR BINARY ACCESS READ AS #1
  GET #1, 8, t%
  imx%(0) = imx%(0) + t%
  CLOSE #1
  n% = n% + 1
LOOP
n% = 0
frame% = 0
'Load frames
DEF SEG = VARSEG(imx%(0))
i& = VARPTR(imx%(0)) + 16 + imx%(0) * 2
DO WHILE imxfile$(n%) <> ""
  OPEN imxfile$(n%) FOR BINARY ACCESS READ AS #1
  fi& = 8
  GET #1, fi&, t%
  fi& = fi& + 16
  fi2& = fi& + t% * 2
  FOR n2% = 1 TO t%
    GET #1, fi&, offset%
    fi& = fi& + 2
    fi2& = offset%
    fi2& = fi2& * 2
    fi2& = fi2& + 8
    GET #1, fi2&, xs%
    fi2& = fi2& + 2
    GET #1, fi2&, ys%
    fi2& = fi2& + 2
    xs% = xs% \ 8
    l% = xs% * ys%
    imx%(8 + frame%) = i& \ 2
    POKE i&, (xs% * 8) AND 255
    POKE i& + 1, (xs% * 8) \ 256
    i& = i& + 2
    POKE i&, ys% AND 255
    POKE i& + 1, ys% \ 256
    i& = i& + 2
    FOR n3% = 1 TO l%
      GET #1, fi2&, char
      POKE i&, ASC(char)
      fi2& = fi2& + 1
      i& = i& + 1
    NEXT
    IF (i& AND 1) THEN i& = i& + 1
    frame% = frame% + 1
  NEXT
  CLOSE #1
  n% = n% + 1
LOOP
DEF SEG
END SUB

SUB loadlevel
DEF SEG = VARSEG(level%(0))
BLOAD levelfile$, VARPTR(level%(0))
DEF SEG
levelxsize% = 160
levelysize% = 24
END SUB

SUB loadpalette
DEF SEG = VARSEG(pal%(0))
i& = VARPTR(pal%(0))
BLOAD palfile$, i&
FOR c% = 0 TO 255
OUT &H3C8, c%
OUT &H3C9, PEEK(i&)
OUT &H3C9, PEEK(i& + 1)
OUT &H3C9, PEEK(i& + 2)
i& = i& + 3
NEXT
DEF SEG
END SUB

SUB loadtiles
DEF SEG = VARSEG(tiles%(0))
BLOAD tilefile$, VARPTR(tiles%(0))
DEF SEG
END SUB

SUB loadtlu
DEF SEG = VARSEG(tlu%(0))
i& = VARPTR(tlu%(0))
BLOAD tlufile1$, i&
FOR n% = 0 TO 255
  q% = PEEK(i& + 255 - n%)
  POKE 510 - (n% * 2), q%
  POKE 511 - (n% * 2), 0
NEXT
DEF SEG
END SUB

SUB maxlimit (pint%, pmax%)
IF pint% > pmax% THEN pint% = pmax%
END SUB

SUB minlimit (pint%, pmin%)
IF pint% < pmin% THEN pint% = pmin%
END SUB

SUB offkb
IF keyboardonflag% = 0 THEN EXIT SUB
keyboardonflag% = 0
DEF SEG = VARSEG(kbcontrol%(0))
CALL absolute(3)
DEF SEG
END SUB

SUB onkb
IF keyboardonflag% THEN EXIT SUB
keyboardonflag% = 1
DEF SEG = VARSEG(kbcontrol%(0))
CALL absolute(0)
DEF SEG
END SUB

SUB playgame
addbigtrees
docamera
GOTO skip0
DO
  domario
  docamera
  IF SNOWON THEN dosnow
  docoins
  addsprites
  drawscreen
skip0:
  saveold
LOOP UNTIL kbmatrix%(1)
END SUB

SUB saveold
oldcamerax% = camerax%
oldcameray% = cameray%
mario.oldx = mario.x
mario.oldy = mario.y
END SUB

SUB statusDOC
'Sprite #
'0-23    snow flake
END SUB

SUB tilevanish (px%, py%)
x% = (px% \ 16)
y% = (py% \ 16)
i& = y%
i& = i& * levelxsize%
i& = i& + x%
DEF SEG = VARSEG(level%(0))
POKE i& + VARPTR(level%(0)), 0
DEF SEG
END SUB

