typedef struct pauls_sprite
{
	int	x1,y1;														/* top left coords of sprite image */
	int	x2,y2;													/* bottom right coords of sprite on screen */
	int	width, height;
	int	orx,ory;
	uchar	*data;
	uchar	*depthq;
}PHD_SPRITE;



#define SPRITE_CLIP_HORIZONTAL 		320
#define SPRITE_CLIP_VERTICAL			GSCRYHT




void	phd_scaled_sprite( PHD_SPRITE *spr )
{
	int		x1,y1,x2,y2;
	int 	xdif;
	int		u,ustart,uadd;
	int		vstart,vadd,pixadd;
	uchar	*pixptr,*dqptr;
	uchar	*ssptr,*slptr;
	uchar	pix;

	x1 = spr->x1;
	y1 = spr->y1;
	x2 = spr->x2;
	y2 = spr->y2;

	if ( x2<=x1 || y2<=y1 ||
		 x2<=0 || y2<=0 ||
		 x1>=SPRITE_CLIP_HORIZONTAL || y1>=SPRITE_CLIP_VERTICAL )
			return;

	dqptr = spr->depthq;

	// Uadd = ((width<<16)-256) / (y2-y1);
	// Vadd = ((height<<16)-256) / (y2-y1);

	vadd = (int)((spr->height<<8)/(y2-y1) );		  // Extract Width of Sprite
	uadd = (int)((spr->width<<8)/(x2-x1) );          // Extract Height of Sprite
	ssptr = spr->data;                                // Pointer to Sprite Data

	ustart = vstart = 0;
	if ( x1<0 )						// Clip On Screen Coordinates..
	{
		ustart -= uadd*x1;
		x1 = 0;
	}
	if ( y1<0 )
	{
		vstart = -vadd*y1;
		y1 = 0;
	}
	if ( x2>SPRITE_CLIP_HORIZONTAL )
		x2 = SPRITE_CLIP_HORIZONTAL;
	if ( y2>SPRITE_CLIP_VERTICAL )
		y2 = SPRITE_CLIP_VERTICAL;


	x2 -= x1;
	y2 -= y1;

	pixptr = scr_ptr + y1*320 + x1;
	pixadd = 320 - x2;

	for ( ;y2>0; y2-- )
	{
		slptr = ssptr + ((vstart>>16)<<8);           // Use DepthQ
		u = ustart;                                  // LookUp Draw....
		for ( xdif=x2; xdif>0; xdif-- )
		{
			if (  ( pix=*(slptr+(u>>16)) )  )
				*(pixptr) = *(dqptr + pix );
			u += uadd;
			pixptr++;
		}
		pixptr += pixadd;
		vstart += vadd;
	}
}

