/*******************************************************************
 *
 *    DESCRIPTION: Converts Big texture map files to small ones
 *
 *    AUTHOR: John Kirkland
 *
 *    HISTORY:	11/9/95 started
 *				12/9/95 moddded
 *
 *******************************************************************/

/** include files **/

#include <io.h>
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>

/** local definitions **/

#define uchar unsigned char
#define ushort unsigned short
#define uint unsigned int

enum types {
	SOL = 0,
	RAG,
  	XPS,
   	XPAS,
    ANIM
};
#define MAX_TEXTURES 64
#define TEXTURE_LEN 64*64

/* default settings */

/** external functions **/

/** external data **/

/** internal functions **/

void main(int argc, char *argv[]);
void sort_walls(int n, char *argv[]);

/** public data **/

/** private data **/


typedef struct destructinfo
{
	uchar	originalwall;
	uchar	destroyedVersion;
}DESTRUCTINFO;



DESTRUCTINFO 	solidDestruct[32] =
/** Solids */
{
		0,21, 	1,21, 	2,21, 	3,21, 	4,21, 	5,21, 	6,21, 	7,21,
		12,20,	13,21,	14,21,	19,21,	20,22,	21,22,	22,22,	23,23,
		24,23,	25,23,	26,24,	27,24,	28,24,	47,21,	48,21,	49,21,
		50,21, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99
};


DESTRUCTINFO 	raggedDestruct[32] =
/** Raggeds */
{
		0,21, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99,
		99,99, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99,
		99,99, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99,
		99,99, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99
};


DESTRUCTINFO 	transymDestruct[32] =
/** Transym */
{
		0,1,		2,3,		4,5,		6,16,		7,17,		8,18,		9,18,		10,19,
		12,25,	13,26,	99,99, 	99,99, 	99,99, 	99,99, 	99,99, 	99,99,
		99,99,	99,99,	99,99,	99,99,	99,99,	99,99,	99,99,	99,99,
		99,99,	99,99,	99,99,	99,99,	99,99,	99,99,	99,99,	99,99
};


uint solid_texture_offsets[64];
uint ragged_texture_offsets[64];
uint xps_texture_offsets[64];
uint xpas_texture_offsets[64];
uint anim_texture_offsets[64];

/** public functions **/

/** private functions **/

void main(int argc, char *argv[])
{
	uint joinflag = 0;
	int n = 1;
	uchar *nptr, c;

	printf("\n3DO Util.\n");

	if ( argc < 2 )
	{
		printf("\nError.\n");
		printf("Try WALLSORT [filename] \n");
		exit(-1);
	}

	if (argc > 2)
	{
		while (n<argc)
		{
			nptr = argv[n++];
			if (*nptr++ == '-')
			{
				c = *nptr++;
				c = toupper(c);

				switch (c)
				{
					default:
						break;
				}
			}
		}
		--n;
	}

	switch (joinflag)
	{
		case 0:
			sort_walls(n, argv);
			break;
		default:
			break;
	}

	exit(0);
}

void sort_walls(int n, char *argv[])
{
	/* general purpose vars */
	uint flen, texture_flen;
	int i, j;

	/* handles */
	int texture_handle, pls_handle, ato_handle, handle;

	/* data pointers */

	uchar *texture_buffer, *pls_buffer, *ato_buffer, *new_texture_buffer, *use_new_texture_buffer;
	uchar *use_pls_buffer, *use_ato_buffer, *ptr;
	uint *uint_ptr, *uint_ptr1;

	/* vars to deal with texture gfx data */

	uchar *solid_ptr, *ragged_ptr, *xp_sym_ptr, *xp_asym_ptr;		//pointers to txm type data
	uint use_new_texture_offset;

	/* vars to deal with pls data */

	ushort *wall_ptr, num_points, num_walls;

	/* vars to deal with anim texture data */

	uint num_anims, num_anim_frames, *anim_ptr;


	/* New ATO file data */

	uint new_ato[12];
	uint ato_count = 0;
	uint total_anims = 0;

	/* filename data */

	uchar walls_filename[20] = {"WALLS.TXM"};
	uchar ato_filename[20] = {"WALLS.ATO"};
	uchar pls_filename[256];

	/* texture type data */

	uint texture_type;
	uint texture_num, texture_use;

	/* end of auto vars */

	for (i=0; i<MAX_TEXTURES;  i++)
	{
		solid_texture_offsets[i] = 0xffffffff;
		ragged_texture_offsets[i] = 0xffffffff;
		xps_texture_offsets[i] = 0xffffffff;
		xpas_texture_offsets[i] = 0xffffffff;
		anim_texture_offsets[i] = 0xffffffff;
	}

	for (i=0; i<12; i++)
	{
		new_ato[i] = 0;
	}

	printf("\nWall sorter.\n");

	/* Section to load in WALLS.TXM file */

	printf("Opening file %s for input\n", walls_filename);


	texture_handle = open(walls_filename, O_RDONLY | O_BINARY);

	if ( texture_handle == -1 )
	{
		printf("\nCannot open %s for Input!\n", walls_filename);
		exit(-1);
	}
	flen = filelength(texture_handle);
	texture_flen = flen;


	if ( (texture_buffer = (uchar *)malloc(flen)) == NULL )
	{
		printf("\nArrghhhh.......Memory Grief(Texture buffer)!!!\n");
	}

	read(texture_handle, texture_buffer, filelength(texture_handle));
	close(texture_handle);


	/* Section to load in .PLS file	*/

	strcpy(pls_filename, argv[n]);

	sprintf(pls_filename, "%s.pls", argv[n]);

	printf("Opening file %s for input\n", pls_filename);

	pls_handle = open(pls_filename, O_RDONLY | O_BINARY);
	if ( pls_handle == -1 )
	{
		printf("\nCannot open %s for Input!\n", pls_filename);
		exit(-1);
	}
	flen = filelength(pls_handle);
	if ( (pls_buffer = (uchar *)malloc(flen)) == NULL )
	{
		printf("\nArrghhhh.......Memory Grief(PLS buffer)!!!\n");
	}
	use_pls_buffer = pls_buffer;

	read(pls_handle, pls_buffer, filelength(pls_handle));
	close(pls_handle);



	/* Section to load in .ATO file	*/

	printf("Opening file %s for input\n", ato_filename);

	ato_handle = open(ato_filename, O_RDONLY | O_BINARY);
	if ( ato_handle == -1 )
	{
		printf("\nCannot open %s for Input!\n", ato_filename);
		exit(-1);
	}
	flen = filelength(ato_handle);
	if ( (ato_buffer = (uchar *)malloc(flen)) == NULL )
	{
		printf("\nArrghhhh.......Memory Grief(ATO buffer)!!!\n");
	}
	use_ato_buffer = ato_buffer;

	read(ato_handle, ato_buffer, filelength(ato_handle));
	close(ato_handle);

	anim_ptr = (uint *)ato_buffer;
	num_anims = *anim_ptr++;


	/* section to init pointers to texture data */

	uint_ptr = (uint *)texture_buffer;

	solid_ptr = texture_buffer + *uint_ptr++;
	ragged_ptr = texture_buffer + *uint_ptr++;
	xp_sym_ptr = texture_buffer + *uint_ptr++;
	xp_asym_ptr = texture_buffer + *uint_ptr;

	/* section to init offsets to texture data */

	uint_ptr = (uint *)texture_buffer;

	/* section to init pointer to wall data */

	wall_ptr = (ushort *)pls_buffer;		// point to base of pls file
	num_points = *wall_ptr++;					// after this wall_ptr points to base of point data
	wall_ptr += (num_points * 2);	// move wall_ptr to number of walls

	num_walls = *wall_ptr++;					// after this wall_ptr points to the wall data




	for (i=0; i<num_walls; i++)
	{
		wall_ptr++;
		wall_ptr++;

		texture_num = (uint)*wall_ptr++;
		texture_type = texture_num & 0x07;
		texture_num &= 0x1ff;		// mask out height & flip stuff
		texture_num >>= 3;			// shift down texture number

		texture_use = texture_num;

		switch (texture_type)
		{
			case SOL:
				solid_texture_offsets[texture_num] = texture_num;
				break;

			case RAG:
				ragged_texture_offsets[texture_num] = texture_num;
				break;

			case XPS:
				xps_texture_offsets[texture_num] = texture_num;
				break;

			case XPAS:
				xpas_texture_offsets[texture_num] = texture_num;
				break;

			case ANIM:
				if (anim_texture_offsets[texture_num] == 0xffffffff)
				{
					total_anims++;
				}
				anim_texture_offsets[texture_num] = texture_num;
				break;

			default:
				break;

		}


	}



	/*Check if you need to include destroyed versions of textures */

	/* Solid wall check */

	for ( i=0; i<32; i++ )
	{
		if ( solidDestruct[i].originalwall!=99 )
		{
			if ( solid_texture_offsets[solidDestruct[i].originalwall]!=0xffffffff )
			{
				xps_texture_offsets[solidDestruct[i].destroyedVersion] = solidDestruct[i].destroyedVersion;
			}
		}
		else
			break;
	}


	/** Ragged wall check */

	for ( i=0; i<32; i++ )
	{
		if ( raggedDestruct[i].originalwall!=99 )
		{
			if ( ragged_texture_offsets[raggedDestruct[i].originalwall]!=0xffffffff )
			{
				xps_texture_offsets[raggedDestruct[i].destroyedVersion] = raggedDestruct[i].destroyedVersion;
			}
		}
		else
			break;
	}



	/** Tran sym wall check */

	for ( i=0; i<32; i++ )
	{
		if ( transymDestruct[i].originalwall!=99 )
		{
			if ( xps_texture_offsets[transymDestruct[i].originalwall]!=0xffffffff )
			{
				xps_texture_offsets[transymDestruct[i].destroyedVersion] = transymDestruct[i].destroyedVersion;
			}
		}
		else
			break;
	}



	/** Tran asym wall check */

	if ( xpas_texture_offsets[0]!=0xffffffff )
	{
		xpas_texture_offsets[1]=1;
	}





	/* section dealing with writing out new TAB file from acquired info */

	if ( (new_texture_buffer = (uchar *)malloc(texture_flen)) == NULL )
	{
		printf("\nArrghhhh.......Memory Grief(New Texture buffer)!!!\n");
	}
	use_new_texture_buffer = new_texture_buffer;

	uint_ptr = (uint *)new_texture_buffer;

	use_new_texture_offset = 0x24;

	use_new_texture_buffer += use_new_texture_offset;

	{
		uint numsolids = 0;
		uint numragged = 0;
		uint numxps = 0;
		uint numxpas = 0;
		uint numanimtot = 0;

		*uint_ptr++ = use_new_texture_offset;		// copy down used solid textures
		for (i=0; i<MAX_TEXTURES; i++ )
		{
			if (solid_texture_offsets[i] != 0xffffffff)
			{
				printf("Solid texture %d used\n",i);
				numsolids++;
				ptr = solid_ptr + i*TEXTURE_LEN;	//point to data
				solid_texture_offsets[i] = use_new_texture_offset;
				for (j=0; j<TEXTURE_LEN; j++ )		//copy data to new buffer
				{
					*use_new_texture_buffer++ = *ptr++;
					use_new_texture_offset++;
				}
			}
		}

		*uint_ptr++ = use_new_texture_offset;		// copy down used ragged textures
		for (i=0; i<MAX_TEXTURES; i++ )
		{
			if (ragged_texture_offsets[i] != 0xffffffff)
			{
				printf("Ragged texture %d used\n",i);
				numragged++;
				ptr = ragged_ptr + i*TEXTURE_LEN;	//point to data
				ragged_texture_offsets[i] = use_new_texture_offset;
				for (j=0; j<TEXTURE_LEN; j++ )		//copy data to new buffer
				{
					*use_new_texture_buffer++ = *ptr++;
					use_new_texture_offset++;
				}
			}
		}

		*uint_ptr++ = use_new_texture_offset;		// copy down used transparent sym textures
		for (i=0; i<MAX_TEXTURES; i++ )
		{
			if (xps_texture_offsets[i] != 0xffffffff)
			{
				printf("Tran sym texture %d used\n",i);
				numxps++;
				ptr = xp_sym_ptr + i*TEXTURE_LEN;	//point to data
				xps_texture_offsets[i] = use_new_texture_offset;
				for (j=0; j<TEXTURE_LEN; j++ )		//copy data to new buffer
				{
					*use_new_texture_buffer++ = *ptr++;
					use_new_texture_offset++;
				}
			}
		}

		*uint_ptr++ = use_new_texture_offset;		// copy down used transparent asym textures
		for (i=0; i<MAX_TEXTURES; i++ )
		{
			if (xpas_texture_offsets[i] != 0xffffffff)
			{
				printf("Tran asym texture %d used\n",i);
				numxpas++;
				ptr = xp_asym_ptr + i*TEXTURE_LEN;	//point to data
				xpas_texture_offsets[i] = use_new_texture_offset;
				for (j=0; j<TEXTURE_LEN; j++ )		//copy data to new buffer
				{
					*use_new_texture_buffer++ = *ptr++;
					use_new_texture_offset++;
				}

			}
		}

		for (i=0; i<MAX_TEXTURES; i++ )
		{
			if (anim_texture_offsets[i] != 0xffffffff)
			{
				printf("Animating texture %d used\n",i);
				anim_texture_offsets[i] = use_new_texture_offset;
				new_ato[ato_count+1] = use_new_texture_offset;
				uint_ptr1 = anim_ptr;				// point to base of .ATO file + 4bytes (skipping num of anim textures)
				uint_ptr1 += i;					// make uint_ptr1 point to the offset of the data in the TXM file
				ptr = texture_buffer + *uint_ptr1;	// make ptr ppoint to the base of the animating data
				num_anim_frames = *(uint_ptr1 + num_anims);		// get number of frames in the anim
				new_ato[ato_count+total_anims+1] = num_anim_frames;
				ato_count++;
				numanimtot += num_anim_frames;
				for (j=0; j<TEXTURE_LEN*num_anim_frames; j++ )		//copy data to new buffer
				{
					*use_new_texture_buffer++ = *ptr++;
					use_new_texture_offset++;
				}
			}
		}
		new_ato[0] = total_anims;

		*uint_ptr++ = numsolids;
		*uint_ptr++ = numragged;
		*uint_ptr++ = numxps;
		*uint_ptr++ = numxpas;
		*uint_ptr++ = numanimtot;

		/*-----------------05/12/95 12:12-------------------
		 write out the number of textures in each group that
		 are used.
		--------------------------------------------------*/

		printf("Number of solids:%d\n",numsolids);
		printf("Number of raggeds:%d\n",numragged);
		printf("Number of transparent symetrical:%d\n",numxps);
		printf("Number of transparent asymetrical:%d\n",numxpas);
		printf("Number of animating:%d\n",numanimtot);


	}

	sprintf(pls_filename, "%s.ato", argv[n]);


	printf("Opening file %s for output\n", pls_filename);

	handle = open(pls_filename, O_RDWR | O_CREAT | O_BINARY | O_TRUNC,
						S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP);
	if ( handle == -1 )
	{
		printf("\nCannot open %s for Output!\n", pls_filename);
		exit(-1);
	}

	write(handle, &new_ato[0], 44);
	close(handle);



	sprintf(pls_filename, "%s.txm", argv[n]);

	printf("Opening file %s for output\n", pls_filename);

	handle = open(pls_filename, O_RDWR | O_CREAT | O_BINARY | O_TRUNC,
						S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP);
	if ( handle == -1 )
	{
		printf("\nCannot open %s for Output!\n", pls_filename);
		exit(-1);
	}

	write(handle, new_texture_buffer, use_new_texture_offset);
	close(handle);

	sprintf(pls_filename, "%s.tab", argv[n]);
	printf("Opening file %s for output\n", pls_filename);

	handle = open(pls_filename, O_RDWR | O_CREAT | O_BINARY | O_TRUNC,
						S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP);
	if ( handle == -1 )
	{
		printf("\nCannot open %s for Output!\n", pls_filename);
		exit(-1);
	}

	write(handle, &solid_texture_offsets[0], MAX_TEXTURES * sizeof(uint));
	write(handle, &ragged_texture_offsets[0], MAX_TEXTURES * sizeof(uint));
	write(handle, &xps_texture_offsets[0], MAX_TEXTURES * sizeof(uint));
	write(handle, &xpas_texture_offsets[0], MAX_TEXTURES * sizeof(uint));
	write(handle, &anim_texture_offsets[0], MAX_TEXTURES * sizeof(uint));
	close(handle);

	free(texture_buffer);
	free(pls_buffer);
	free(ato_buffer);


	printf("\nDone!\n");
}

