#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <string.h>

/*-----------------14/11/95 10:46-------------------
 constants
--------------------------------------------------*/
#define TRUE									1
#define FALSE									0

#define MAX_NAME_LENGTH				48

typedef unsigned int	uint;
typedef unsigned char	uchar;
typedef unsigned short ushort;

typedef	struct header_info
{
	uint	size;
	uint	offset;
	char	filename[MAX_NAME_LENGTH];
}HEADER_INFO;


/*-----------------14/11/95 10:45-------------------
 prototypes
--------------------------------------------------*/

void	create_wad_file(void);
void	interpret_arguments(int argc, char *argv[]);
void	save_wad_file(void);




/*-----------------14/11/95 10:46-------------------
 globals
--------------------------------------------------*/

char	infilename[256];
char	outfilename[256];
char	infofilename[256];

FILE	*infile;
FILE	*outfile;
FILE	*infofile=NULL;


HEADER_INFO	headerBlock[256];				/** Header can cater for 256 entries **/
char	databuffer[1024*1024*4];			/** Can have upto 4 meg contained in the wadder - totally excessive **/
uint	numFiles;
uint	currentFile;
uint	currentOffset;
uint	totalLength;
char	*dataptr;
uint	headerSize;
int		padding=FALSE;
int		info=FALSE;
int		fileinfo=FALSE;
int		totalPadding=0;


void	main(int argc, char **argv)
{
	/* check if there are enough arguments */
	if ( argc<2 )
	{
		printf("Error - need file name\n");
		exit(0);
	}

	interpret_arguments(argc, argv);


	printf("Creating wad file %s using source file %s\n", outfilename, infilename);

	if ( (infile=fopen(infilename, "r"))==NULL )
	{
		printf("Error - couldn't open source file : %s\n",infilename);
		exit(0);
	}

	if ( (outfile=fopen(outfilename, "wb"))==NULL )
	{
		printf("Error - couldn't create wadfile file : %s\n",outfilename);
		exit(0);
	}

	/** clear out the data buffer **/
	memset(databuffer, 0, sizeof(databuffer));

	if ( fileinfo )
	{
		if ( (infofile=fopen(infofilename,"w"))==NULL )
		{
			printf("Doh! couldn't open info file '%s' for writing", infofilename);
		}
	}

	create_wad_file();							/** creates the header name block and also builds up the offset information **/

	save_wad_file();

	fclose(infile);
	fclose(outfile);

	if ( info )
	{
		printf("Number of files:%d\n", numFiles);
		printf("Total length of data:%d bytes\n",totalLength);
		printf("Total padding:%d bytes\n", totalPadding);
	}

	if ( fileinfo )
	{
		fprintf(infofile,"Stats for wad file %s:\n",outfilename);
		fprintf(infofile,"Number of files:%d\n", numFiles);
		fprintf(infofile,"Total length of data:%d bytes\n",totalLength);
		fprintf(infofile,"Total padding:%d bytes\n", totalPadding);
	}

	if ( fileinfo && infofile!=NULL )
	{
		fclose(infofile);
	}

	printf("Done.\n");
}





void	create_wad_file(void)
{
	char	filenamebuffer[256];

	numFiles = 0;
	currentFile = 0;
	currentOffset = 0;
	dataptr = databuffer;
	totalLength = 0;
	headerSize = 0;



	fgets(filenamebuffer, 255, infile);
	while ( !feof(infile) )
	{
		if( !(add_to_wad_file(filenamebuffer)) )
		{
			printf("Error - couldn't add %s to wad file", filenamebuffer);
			exit(0);
		}
		fgets(filenamebuffer, 255, infile);
	}
}




int		add_to_wad_file(char *filename)
{
	int	fileHandle, filelen;
	char	*tmp;
	int	paddAmount=0;


	tmp = strtok(filename,"\n");

	fileHandle=open(filename, O_BINARY|O_RDONLY);

	if ( fileHandle==-1 ) 		/* open data file as a read only binary file */
	{
		printf("couldn't open %s:errno(%d)\n", filename, errno);
		return (0);
	}

	if ( strlen(filename) > MAX_NAME_LENGTH )
	{
		printf("Filename is too long to go into header info\n");
		return(0);

	}

	filelen = filelength(fileHandle);

	headerBlock[currentFile].offset = currentOffset;
	headerBlock[currentFile].size	= filelen;
	sprintf(headerBlock[currentFile].filename,
					"%s", filename);



	if ( info )
	{
		printf("file:%s\n offset:%d\n size:%d\n",filename, currentOffset, filelen);
	}
	if ( fileinfo )
	{
		fprintf(infofile, "file:%s\n offset:%d\n size:%d\n",filename, currentOffset, filelen);
	}

	currentOffset+=filelen;
	totalLength+=filelen;

	paddAmount=0;
	if ( padding ) 	/** if padding then make sure all offsets are on long word boundaries **/
	{
		while ( currentOffset&3 )
		{
			currentOffset++;
			totalLength++;
			paddAmount++;
		}
	}

	if ( info )
	{
		printf(" padding:%d\n\n",paddAmount);
	}
	if ( fileinfo )
	{
		fprintf(infofile, " padding:%d\n\n",paddAmount);
	}

	read( fileHandle, dataptr, filelen);
	dataptr+=(filelen+paddAmount);

	close(fileHandle);

	currentFile++;
	numFiles++;

	headerSize += sizeof(HEADER_INFO);

	totalPadding+=paddAmount;

	return (1);
}



void	save_wad_file(void)
{
	fwrite(&numFiles, sizeof(uint), 1, outfile);
	fwrite(&totalLength, sizeof(uint), 1, outfile);
	fwrite(headerBlock, sizeof(HEADER_INFO), numFiles, outfile);
	fwrite(databuffer, sizeof(char), totalLength, outfile);
}




void	interpret_arguments(int argc, char *argv[])
{
	int	n;
	int	argUsed=0;
	char	tempOutName[256];

	for ( n=1; n<argc; n++ )
	{
		if ( (argv[n][0]=='/') || (argv[n][0]=='-') )	/* check for switch */
		{
			switch ( argv[n][1] )
			{
				case 'h':
				case 'H':
				case '?':
					/** help switch - displays help page */
					printf("Usage: wadder filename [output directory] [switches]\n");
					printf("	-p	: padds out each internal file to a long word boundary\n");
					printf("	-i	: displays information on wadd data\n");
					printf("	-f	: saves out information on wadd data\n");
					exit(0);
					break;

				case 'p':
				case 'P':
					/** turns word alligning/packing on **/
					padding=TRUE;
					break;

				case 'i':
				case 'I':
					/** displays information **/
					info=TRUE;
					break;

				case 'f':
					/** sends information to a file **/
					fileinfo = TRUE;
					break;



				default:
					printf("Error - unrecognised switch.");
			}
		}
		else
		{
			if ( argUsed==0 ) /* Get source file name */
			{
				argUsed++;
				/* get the source file name of the wad file */
				sprintf(infilename, "%s.txt", argv[n]);
				sprintf(outfilename, "%s.shk", argv[n]);
				sprintf(infofilename, "%s.inf", argv[n]);
			}
			else
			{
				argUsed++;
				/* get output directory for source file */
				sprintf(tempOutName, "%s\\%s", argv[n], outfilename);
				sprintf(outfilename,"%s",tempOutName);
			}
		}
	}


	if ( argUsed<=0 )
	{
		printf("Error - have no source file name");
	}
	else
	{

	}

}

