#include <stdio.h>
#include <stdlib.h>

#include "chuck.h"
#include "e_global.h"
#include "walldraw.h"
#ifdef MEMCHK
#include <memcheck.h>
#endif




// take_this_out
extern int useAssembly;

#define NETWORK_TANK_CHANGE_COLOUR		254

static short	*netptr;

static int		hostageFlag;
static int		netoff;
static int		drawAwall;
static int		flippon;
static int		transparent = 0;
static int		t_scale;
static int		rotorNetoff;
static int		rotors;
static int		rotorsInfront, rotorsBehind;
static uchar	shifter;
static uchar	tshade;

static	ushort	rotObjResize[] =
{
	3, /* shell */
	2, /* player tank */
	2, /* enemy tank */
	2, /* battle tank	*/
	2, /* afv  */
	2, /* apc  */
	1, /* gunboat  */
	2, /* gun employment  */
	2, /* allied truck  */
	2, /* enemy truck  */
	3, /* hostage 1  */
	3, /* hostage 2  */
	2, /* e_heli  */
	2, /* e_gunship  */
	2, /* NETWORK TANK */
	2, /* Player helicoter (911) */
	2, /* Player plane (smartbomb */
	0, /* dummy */
	2, /* sams */
	2  /* asms */
};


uchar		pdepthChanges[]=
{
	COCKPIT_RED,
	COCKPIT_GREEN,
	COCKPIT_WHITE,
	COCKPIT_BLACK,
	COCKPIT_YELLOW,
	COCKPIT_PURPLE,
	COCKPIT_GREY,
	COCKPIT_BROWN
};

uchar	weapon_useable;

extern int ptrans;

#define END_POINTER		0 //NULL


/********************************************************/
/** Prototypes */

void draw_bullet(void);


/********************************************************/

void sprite(void)
{
	int	fxsize, i;
	uchar 	*gr_addr=NULL;
	short	tank_sy,tank_on,networkTank;

	for (i=0;i<64;i++)
		tp[i].visible = -1;

	tp_off = 0;

	rotate();				  	/* Setup X,Z,ALT positions and angle for positioning of sprites. */

	_setup_transform();

	//sprite_origin();												/* 'C' version */
	_sprite_origin();													/* 386 version */

 	nxt_ptr = ll[1].next; 										/* Set nxt_ptr to point to next entry in link list. */

	for (;;)			 														/* Eternal loop. */
	{
		if (nxt_ptr -> next == END_POINTER)		  /* Reached end of link list ? */
		 	break;

	 	rotorsInfront = rotorsBehind = rotors = networkTank = hostageFlag =	tank_on = weapon_useable = FALSE;

		netoff = (fxsize=nxt_ptr -> def) >> 6;	/* Offset into net for first frame of rotating object */

		drawAwall = flippon = transparent = 0;

		if	(netoff < ROTATING_OBJECT_TAG)			/* Floor object? */
		{
			netptr = net_info;										/* Setup pointer to sprite info. */
			shifter = 2;
 			gr_addr = graphics;										/* Setup correct graphics address. */
			netoff--;
		}
		else
		{
			if ( netoff < FX_SPRITE_TAG ) 				/* Rotating object ? */
			{
				netoff-= ROTATING_OBJECT_TAG;

				if ( (netoff==HOSTAGE_1) || (netoff==HOSTAGE_2) )
				{
					hostageFlag=TRUE;
				}
				else
				{
					/** set up colouring of network tanks here */
					if ( netoff==NETWORK_TANK )
					{
						networkTank = TRUE;
						set_network_tank_colr( (nxt_ptr->pl>>8)&0xf );
					}
					else
					if ( (netoff == E_HELICOPTER) || (netoff == E_GUNSHIP) )
					{
						rotors = TRUE;
					}

				}

				shifter = rotObjResize[netoff];			/* sprite scaling factor */

				gr_addr = mob_graphics[netoff];			/* Setup correct graphics address - points to moving object graphics */
				netptr = mob_net_info[netoff];


				get_rotation_frame();


			}
			else
			{
				if(netoff == BULLET_TAG)										/* Bullet? */
				{
					draw_bullet();
 					nxt_ptr = nxt_ptr->next;									/* And move onto the next object in draw list */
 					continue;
				}
				else if ( netoff >= WALL_TAG ) 							/* A wall ? */
				{
					drawAwall=TRUE;
				}
				else
				{																						/* An FX sprite */
					netoff -= FX_SPRITE_TAG;

					shifter = fxsize & 0x7;
					transparent = netoff & TRANSPARENT_SPRITE;
					flippon	= netoff & FLIPPED_SPRITE;

					netoff >>=2;

					netptr = fx_net_info;
					gr_addr = fx_graphics;
  			}
  		}
		}

 		t_scale = (nxt_ptr -> sz) << 3;
		t_scale <<= shifter;

		if ( drawAwall )
		{
			draw_the_fucking_wall(nxt_ptr -> pl);					/* Well, fairly self explanatory. */
																										/* (pl in this case is used to indicate which wall is to be drawn) */
			nxt_ptr = nxt_ptr ->	next;						/* And move onto the next object in draw list */
			continue;
		}
		else if ((nxt_ptr->pl & 0xff) == TANK_TAG)
		{
	  	if (pl.cWeapon == WMAIN_GUN)
	  	{
				tank_sy = nxt_ptr->sy - (0x180000 / t_scale); /* Get screen Y. */
 				if (nxt_ptr->sx >= 0 && nxt_ptr->sx < 320 && tank_sy >= 0 && tank_sy < 128) /* Mid point on screen. */
				{
					tank_on = 1;
					enemyTanks[(nxt_ptr->pl) >> 8].dist_from_player = nxt_ptr->sz; /* Get distance from player. */
					enemyTanks[(nxt_ptr->pl) >> 8].sx = nxt_ptr->sx; /* Get screen X. */
					enemyTanks[(nxt_ptr->pl) >> 8].sy = tank_sy;

					if (tp_off < 64)
					{
						tp[tp_off].scr_off = nxt_ptr->sx + (tank_sy * NSCR_WIDTH); /* SEAN - byte offset. */
						tp[tp_off].type = TANK_TAG;
						tp[tp_off].index = (nxt_ptr->pl) >> 8;
						tp[tp_off].visible = 0;
						tp_off++;
					}
				}
			}
		}
		else if ((nxt_ptr->pl & 0xff) == HELI_TAG)
		{
			if (pl.cWeapon == WSAMS || pl.cWeapon == WCHAIN_GUN)
 			{
				tank_sy = nxt_ptr->sy + (0x100000 / t_scale); /* Get screen Y. */
 				if (nxt_ptr->sx >= 0 && nxt_ptr->sx < 320 && tank_sy >= 0 && tank_sy < 128) /* Mid point on screen. */
				{
					tank_on = 1;
 					helicopters[(nxt_ptr->pl) >> 8].dist_from_player = nxt_ptr->sz; /* Get distance from player. */
					helicopters[(nxt_ptr->pl) >> 8].sx = nxt_ptr->sx; /* Get screen X. */
					helicopters[(nxt_ptr->pl) >> 8].sy = tank_sy;

					if (tp_off < 64)
					{
						tp[tp_off].scr_off = nxt_ptr->sx + (tank_sy * NSCR_WIDTH);
						tp[tp_off].type = HELI_TAG;
						tp[tp_off].index = (nxt_ptr->pl) >> 8;
						tp[tp_off].visible = 0;
						tp_off++;
					}
				}
			}
		}
		else if ((nxt_ptr->pl & 0xff) == GUN_EMPL_TAG)	/* Gun emplacement? */
		{
		  if (pl.cWeapon == WCHAIN_GUN)
 			{
				tank_sy = nxt_ptr->sy - (0x100000 / t_scale); /* Get screen Y. */
 				if (nxt_ptr->sx >= 0 && nxt_ptr->sx < 320 && tank_sy >= 0 && tank_sy < 128) /* Mid point on screen. */
				{
					tank_on = 1;
					gunempls[(nxt_ptr->pl) >> 8].dist_from_player = nxt_ptr->sz; /* Get distance from player. */
					gunempls[(nxt_ptr->pl) >> 8].sx = nxt_ptr->sx; /* Get screen X. */
					gunempls[(nxt_ptr->pl) >> 8].sy = tank_sy;

					if (tp_off < 64)
					{
						tp[tp_off].scr_off = nxt_ptr->sx + (tank_sy * NSCR_WIDTH);
						tp[tp_off].type = GUN_EMPL_TAG;
						tp[tp_off].index = (nxt_ptr->pl) >> 8;
						tp[tp_off].visible = 0;
						tp_off++;
					}
				}
			}
		}

		if (t_scale>0x5ffff)
			tshade = 7;
		else if (t_scale > 0x40000)
			tshade = (t_scale & 0x1c000) >> 14;
		else
			tshade = 32;

		sprite_y_clip=GSCRYHT;



		if ( rotors && rotorsBehind )
		{
			scale_sprite(nxt_ptr->sx, nxt_ptr->sy, t_scale>>1, rotorNetoff, tshade, flippon, TRUE, (uchar*)gr_addr, (uchar*)netptr);
		}

		if ( networkTank )
		{
			network_tank_scale_sprite(nxt_ptr->sx, nxt_ptr->sy, t_scale, netoff, tshade, flippon, transparent, (uchar*)gr_addr, (uchar*)netptr);
		}
		else
			scale_sprite(nxt_ptr->sx, nxt_ptr->sy, t_scale, netoff, tshade, flippon, transparent, (uchar*)gr_addr, (uchar*)netptr);


		if ( rotors && rotorsInfront )
		{
			scale_sprite(nxt_ptr->sx, nxt_ptr->sy, t_scale>>1, rotorNetoff, tshade, flippon, TRUE, (uchar*)gr_addr, (uchar*)netptr);
		}

		if (tank_on)	/* SEAN - draws targeting pixel here !!!!!! */
 			*(currentScreen + nxt_ptr->sx + (tank_sy * NSCR_WIDTH)) = BULLET_COL;

		nxt_ptr = nxt_ptr ->	next;	 						/* Do next sprite. */
	}


	reset_point_check_list();
}


/**************************************************************/

#ifdef PC_VERSION
void	set_network_tank_colr(char colr)
{
	int 	i;
	char	*cdepth;

	colr = pdepthChanges[colr&7];

	cdepth = pdepths;

	cdepth += NETWORK_TANK_CHANGE_COLOUR;

	for ( i=0; i<8; i++ )
	{
		*cdepth = colr;
		cdepth+=0x100;
	}
}
#endif



/**************************************************************/


void draw_bullet(void)
{
	struct	bullets	*bull_ptr;

	if ((nxt_ptr->pl & 0xff) == PL_BULLET_TAG)
		bull_ptr = &pl_bullets[nxt_ptr->pl >> 8];
	else
		bull_ptr = &en_bullets[nxt_ptr->pl >> 8];

	spnt.x = (bull_ptr->x - ((bull_ptr->speed >> 4) * ((int)sintab[bull_ptr->dir]))) >> 16;
	spnt.y = (bull_ptr->y - (bull_ptr->yvel<<1)) >> 16;
	spnt.z = (bull_ptr->z - ((bull_ptr->speed >> 4) * ((int)sintab[bull_ptr->dir + 512]))) >> 16;

	_rot_single_point(&spnt);

	if (spnt.z >= 32)
		line_draw(spnt.x,spnt.y,nxt_ptr->sx,nxt_ptr->sy,BULLET_COL);
}


/**************************************************************/



void	get_rotation_frame()
{
	int		px, pz, ex, ez, pe_ang, en_ang, ang_diff;
	int		def_org;
	short	plh,pll;

	TANK 						*tank_ptr;
	TANK 						*heli_ptr;
	SHELL_DATA 			*shell_ptr;
	GUN_BOAT 				*gb_ptr;
	GUN_EMPLACEMENT	*ge_ptr;
	HOSTAGE					*hostage_ptr;
	struct	sams		*sam_ptr;

	plh = (nxt_ptr->pl >> 8) & 0xff;
	pll = nxt_ptr->pl & 0xff;

	if (pll == TANK_TAG)
	{
		tank_ptr = &enemyTanks[plh];
		ex = (int)((tank_ptr->x) >> 16);
		ez = (int)((tank_ptr->z) >> 16);
		def_org = tank_ptr->def;
		en_ang = tank_ptr->angle;
	}
	else if (pll == HELI_TAG)
	{
		heli_ptr = &helicopters[plh];
		ex = (int)((heli_ptr->x) >> 16);
		ez = (int)((heli_ptr->z) >> 16);
		en_ang = heli_ptr->angle;
	}
	else if (pll == GUN_EMPL_TAG)
	{
		ge_ptr = &gunempls[plh];
		ex = (int)((ge_ptr->x) >> 16);
		ez = (int)((ge_ptr->z) >> 16);
		def_org = E_GUNEMPL;
		en_ang = ge_ptr->angle;
	}
	else if (pll == PL_SHELL_TAG)
	{
		shell_ptr = &playerShells[plh];
		ex = (int)((shell_ptr->x) >> 16);
		ez = (int)((shell_ptr->z) >> 16);
		def_org = SHELL;
		en_ang = shell_ptr->direction;
	}
	else if (pll == EN_SHELL_TAG)
	{
		shell_ptr = &enemyShells[plh];
		ex = (int)((shell_ptr->x) >> 16);
		ez = (int)((shell_ptr->z) >> 16);
		def_org = SHELL;
		en_ang = shell_ptr->direction;
	}
	else if (pll == SAM_TAG)
	{
		sam_ptr = &sam[plh];
		ex = (int)((sam_ptr->x) >> 16);
		ez = (int)((sam_ptr->z) >> 16);
		def_org = SHELL;
		en_ang = sam_ptr->dir;
	}
	else if (pll == GUNBOAT_TAG)
	{
		gb_ptr = &gunboats[plh];
		ex = (int)((gb_ptr->x) >> 16);
		ez = (int)((gb_ptr->z) >> 16);
		def_org = ENEMY_GUNBOAT;
		en_ang = gb_ptr->angle;
	}
	else// if ( pll == HOSTAGE_TAG )
	{
		hostage_ptr = hostages + plh;
		ex = (int)((hostage_ptr->x) >> 16);
		ez = (int)((hostage_ptr->z) >> 16);
		def_org = HOSTAGE_1;
		en_ang = hostage_ptr->angle;
	}

	px = (int)(pl.x>>16);
	pz = (int)(pl.z>>16);

	ang_diff = phd_atan((px - ex),(pz - ez)) & 0x7ff;

	if (plh == targ.index && pll == targ.type)
	{
		glob1 = en_ang;
		//glob2 = nxt_ptr->sz;
	}

	pe_ang = ((en_ang - ang_diff + 0x400) >> 5);

	netoff = pe_ang & 0x3f;


	if(netoff>32)
	{
		flippon=1;
		netoff=64-netoff;
	}

	if ( rotors )
	{
		if ( netoff>=0 && netoff<16 )
		{
			rotorsInfront=TRUE;
		}
		else
		if ( netoff>=16 && netoff<=32  )
		{
			rotorsBehind=TRUE;
		}

		rotorNetoff = netoff + 33;

		if ( passFlag )
		{
			rotorNetoff+=33;
		}
	}


	if ( hostageFlag )
	{
		pe_ang = ((en_ang - ang_diff + 0x400) >> 8);
		netoff = pe_ang & 0x7;

		if ( netoff>4 )
		{
			netoff=8-netoff;
		}

		netoff *= 5;

		if ( hostage_ptr->frame<5 ) 			// rotating frames when still
		{
			netoff += hostage_ptr->frame;
		}
		else
			netoff = hostage_ptr->frame + 20;
	}
}








