#ifndef SMACKH
#define SMACKH

#include "rad.h"

RCSTART

#define SMACKVERSION "2.0e"

typedef struct SmackSumTag {
  u32 TotalTime;         // total time
  u32 MS100PerFrame;     // MS*100 per frame (100000/MS100PerFrame=Frames/Sec)
  u32 TotalOpenTime;     // Time to open and prepare for decompression
  u32 TotalFrames;       // Total Frames displayed
  u32 SkippedFrames;     // Total number of skipped frames
  u32 TotalBlitTime;     // Total time spent blitting
  u32 TotalReadTime;     // Total time spent reading 
  u32 TotalDecompTime;   // Total time spent decompressing
  u32 TotalReadSpeed;    // Total io speed (bytes/second)
  u32 SlowestFrameTime;  // Slowest single frame time
  u32 Slowest2FrameTime; // Second slowest single frame time
  u32 SlowestFrameNum;   // Slowest single frame number
  u32 Slowest2FrameNum;  // Second slowest single frame number
  u32 AverageFrameSize;  // Average size of the frame
  u32 HighestMemAmount;  // Highest amount of memory allocated
} SmackSum;

typedef struct SmackTag {
  u32 Version;           // SMK2 only right now
  u32 Width;             // Width (1 based, 640 for example)
  u32 Height;            // Height (1 based, 480 for example)
  u32 Frames;            // Number of frames (1 based, 100 = 100 frames)
  u32 MSPerFrame;        // Frame Rate
  u32 FlicType;          // bit 0 set=ring frame
  u32 LargestInTrack[7]; // Largest single size for each track
  u32 tablesize;         // Size of the init tables
  u32 codesize;          // Compression info   
  u32 absize;            // ditto
  u32 detailsize;        // ditto
  u32 typesize;          // ditto
  u32 TrackType[7];      // high byte=0x80-Comp,0x40-PCM data,0x20-16 bit,0x10-stereo
  u32 extra;             // extra value (should be zero)
  u32 NewPalette;        // set to one if the palette changed
  u32 CurPalette;        // 1=first palette, 2=second palette
  u8  Col1[772];         // first palette
  u8  Col2[772];         // second palette          
  u32 FrameNum;          // Frame Number to be displayed
  u32 InBufSize;         // size of the buffer allocated for inbuf
  u32 ExtraBuf;          // size used for extra amount
  u32 LastRectx;         // Rect set in from SmackToBufferRect (X coord)
  u32 LastRecty;         // Rect set in from SmackToBufferRect (Y coord)
  u32 LastRectw;         // Rect set in from SmackToBufferRect (Width)
  u32 LastRecth;         // Rect set in from SmackToBufferRect (Height)
  u32 OpenFlags;         // flags used on open
  u32 LeftOfs;           // Left Offset used in SmackTo
  u32 TopOfs;            // Top Offset used in SmackTo
} Smack;              

#define SmackHeaderSize(smk) ((((u8*)&((smk)->extra))-((u8*)(smk)))+4)

//=======================================================================
#define SMACKPRELOADALL  32L   // Preload the entire animation
#define SMACKNOSKIP      64L   // Don't skip frames if falling behind
#define SMACKSIMULATE   128L   // Simulate the speed (call SmackSim first)
#define SMACKFILEHANDLE 256L   // Use when passing in a file handle
#define SMACKTRACK1     512L   // Play audio track 1
#define SMACKTRACK2    1024L   // Play audio track 2
#define SMACKTRACK3    2048L   // Play audio track 3
#define SMACKTRACK4    4096L   // Play audio track 4
#define SMACKTRACK5    8192L   // Play audio track 5
#define SMACKTRACK6   16384L   // Play audio track 6
#define SMACKTRACK7   32768L   // Play audio track 7
#define SMACKTRACKS (SMACKTRACK1|SMACKTRACK2|SMACKTRACK3|SMACKTRACK4|SMACKTRACK5|SMACKTRACK6|SMACKTRACK7)

#define SMACKAUTOEXTRA 0xffffffffL // NOT A FLAG! - Use as extrabuf param 
//=======================================================================
  
#define SMACKSURFACEFAST     0
#define SMACKSURFACESLOW     1
#define SMACKSURFACEDIRECT   2


Smack PTR4* RADEXPLINK SmackOpen(char PTR4* name,u32 flags,u32 extrabuf);
u16  RADEXPLINK SmackDoFrame(Smack PTR4* smk);
void RADEXPLINK SmackNextFrame(Smack PTR4* smk);
u16  RADEXPLINK SmackWait(Smack PTR4* smk);
void RADEXPLINK SmackClose(Smack PTR4* smk);

void RADEXPLINK SmackVolume(Smack PTR4* smk, u32 trackflag,u16 left,u16 right);    

void RADEXPLINK SmackSummary(Smack PTR4* smk,SmackSum PTR4* sum);

u16  RADEXPLINK SmackSoundInTrack(Smack PTR4* smk,u32 trackflags);
u16  RADEXPLINK SmackSoundOnOff(Smack PTR4* smk,u16 on);

void RADEXPLINK SmackToScreen(Smack PTR4* smk,u32 left,u32 top,u32 BytesPS,u16 PTR4* WinTbl,u32 SetBank);
void RADEXPLINK SmackToBuffer(Smack PTR4* smk,u32 left,u32 top,u32 destwidth,u32 destheight,void PTR4* buf,u16 Reversed);
u16  RADEXPLINK SmackToBufferRect(Smack PTR4* smk, u16 SmackSurface);

void RADEXPLINK SmackGoto(Smack PTR4* smk,u32 frame);
void RADEXPLINK SmackColorRemap(Smack PTR4* smk,void PTR4* remap,u16 colors,u16 paltype);
void RADEXPLINK SmackColorTrans(Smack PTR4* smk,void PTR4* trans);
void RADEXPLINK SmackFrameRate(Smack PTR4* smk,u32 forcerate);
void RADEXPLINK SmackSimulate(u32 sim);

u32  RADEXPLINK SmackGetTrackData(Smack PTR4* smk,void PTR4* dest,u32 trackflag);

void RADEXPLINK SmackSoundCheck();

//======================================================================
#ifdef __RADWIN__

  #define INCLUDE_MMSYSTEM_H
  #include "windows.h"
  #include "windowsx.h"

  void RADEXPLINK SmackGet(Smack PTR4* smk,void PTR4* dest);

  #define SmackTimerSetup()
  #define SmackTimerDone()
  #define SmackTimerRead timeGetTime

  //=======================================================================
  #define SMACKAUTOBLIT        0
  #define SMACKFULL320X240BLIT 1
  #define SMACKFULL320X200BLIT 2
  #define SMACKSTANDARDBLIT    3
  #define SMACKVFWBLIT         4 
  #define SMACKWINGBLIT        5
  #define SMACKDCIBLIT         6

  #define WM_SMACKACTIVATE WM_USER+0x5678

  typedef struct SmackBufTag {
    u32 Reversed;             // 1 if the buffer is upside down
    u32 SurfaceType;          // SMACKSURFACExxxx defines
    u32 BlitType;             // SMACKxxxxBLIT defines
    u32 FullScreen;           // 1 if full-screen
    u32 Width;
    u32 Height;
    u32 Zoomed;
    u32 ZWidth;
    u32 ZHeight;
    u32 DispColors;           // colors on the screen
    u32 MaxPalColors;         // total possible colors in palette (usually 256)
    u32 PalColorsInUse;       // Used colors in palette (usually 236)
    u32 StartPalColor;        // first usable color index (usually 10)
    u32 EndPalColor;          // last usable color index (usually 246)
 
    void PTR4* Buffer;
    void PTR4* DIBRestore;
    u32 OurBitmap;
    u32 OrigBitmap;
    u32 OurPalette;
    u32 WinGDC;
    u32 FullFocused;
    u32 ParentHwnd;
    u32 OldParWndProc;
    u32 OldDispWndProc;
    u32 DispHwnd;
    #ifdef __WINDOWS_386__
      u32 WinGBufHandle;
    #endif
    RGBQUAD DIBPalette[256];
  } SmackBuf;

  char PTR4* RADEXPLINK SmackBufferString(char PTR4* dest,WORD BlitType);
  SmackBuf PTR4* RADEXPLINK SmackBufferOpen(  HWND wnd, WORD BlitType, WORD width, WORD height, WORD ZoomW, WORD ZoomH );
  u16  RADEXPLINK SmackBufferBlit( SmackBuf PTR4* sbuf, HDC dc, WORD hwndx, WORD hwndy, WORD subx, WORD suby, WORD subw, WORD subh );
  void RADEXPLINK SmackBufferNewPalette( SmackBuf PTR4* sbuf, void PTR4* pal );
  u16  RADEXPLINK SmackBufferSetPalette( SmackBuf PTR4* sbuf );
  u16  RADEXPLINK SmackBufferFocused( SmackBuf PTR4* sbuf);
  void RADEXPLINK SmackBufferClose( SmackBuf PTR4* sbuf );

  void RADEXPLINK SmackBufferClear( SmackBuf PTR4* destbuf, u8 color);
  void RADEXPLINK SmackBufferToBuffer( SmackBuf PTR4* destbuf, WORD destx, WORD desty, SmackBuf PTR4* sourcebuf,WORD sourcex,WORD sourcey,WORD sourcew,WORD sourceh);
  void RADEXPLINK SmackBufferToBufferTrans( SmackBuf PTR4* destbuf, WORD destx, WORD desty, SmackBuf PTR4* sourcebuf,WORD sourcex,WORD sourcey,WORD sourcew,WORD sourceh,WORD TransColor);
  void RADEXPLINK SmackBufferFromScreen( SmackBuf PTR4* destbuf, HWND hw, WORD x, WORD y);
  void RADEXPLINK SmackBufferCopyPalette( SmackBuf PTR4* destbuf, SmackBuf PTR4* sourcebuf, u16 remap);

  void RADEXPLINK SmackBufferGet( SmackBuf PTR4* sbuf, void PTR4* dest);
  //=======================================================================

#else
  u8 RADEXPLINK LowSoundDriverLoaded();
  u8 RADEXPLINK LowSoundDriverLoad(char PTR4* cfgfilename);
  u8 RADEXPLINK LowSoundDriverUnload();
  void RADEXPLINK LowSoundShutDown();
  
  void cdecl SmackTimerSetup();
  u32  cdecl SmackTimerRead();
  void cdecl SmackTimerDone();

  void cdecl SetSmackAILDigDriver(void* dd,u32 MaxTimerSpeed);//Miles's AIL
  void cdecl SetSmackSOSHandle(u16 SmackHandle,u32 MaxTimerSpeed);//HMI's SOS
  void cdecl SetSmackSOS4Handle(u16 SmackHandle,u32 MaxTimerSpeed);//HMI's SOS
#endif

RCEND

#endif
