#include "headers.h"
#include "chuck.h"
#include "walldraw.h"
#include "e_global.h"
#include "rshock.h"
#include "shock.h"

#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"


#include "enemlogc.h"


#define CD_POLL_FACTOR	60
#define MAX_SONGS				6
#define SNAME_LENGTH		32




#define MISSION_REWARD				7000
#define ARMOUR_WARNING_LEVEL	0x100


//#define TEST_SOUND_FX

/*************************************************************/
int	soundPitchUsed;

#ifdef TEST_SOUND_FX
#define MAX_TEST_FX 41
int	selectedSound=0;
int	canPlayTest=TRUE;
int	canrePlayTest=TRUE;
char	fxInfo[256]="No fx";
#endif


/* Mission objective variables */

ushort	*objectivData=NULL;
ushort	objectiveType;
ushort	*objectiveBuildings;
ushort	numObjectiveEnemies;
ushort	numObjectiveBuildings;
ushort	numObjectiveBuildingsLeft;
ushort	objectiveAchieved;
ushort	convoyCompleted;
ushort	convoyDestroyed;
ushort	numHostages;
ushort	numHostagesCollected;
ushort	numHostagesLeft;
ushort	gotoRendezvous;
int			debounce;
int			messageAnimCounter=0;




// take_this_out
void	display_enemy_data(void);
void	print_cheat_stats(void);


extern	int		showEnemyStats;
extern	int 	showStatType;
extern	int		currentEnemyStats;
extern 	uint 	followPosition=FALSE;
int	statLimits[4] = { MAX_ENEMY_TANKS, MAX_HELICOPTERS, MAX_GUN_EMPLS, MAX_GUN_BOATS };


extern	int	normalCD;
extern 	FILE *targetBuildings;
FILE		*targetBuildings;
extern 	char	destroyedBuildingstring[];
extern 	int varalt;
extern 	char	msgStr[256];
int			collisionsOn=TRUE;
extern	int	forcedgame;
char		ignoreHits=FALSE;
/////////////////


extern GAME_IOSTRUCT	game_data;
extern ushort	currentIgnoreValue;
extern int depthCueTrigger;
extern int frame_off;
extern int total_emssize;




void	check_4_exit(void);


int		firstPass;
int		fadeTime;

void my_main(void)
{
	/************************
	* VARIABLE DECLARATIONS *
	************************/

	int		frames;
	int 	i;
	int		cdPollCounter=0;
	uchar	*palptr;
	int		escapedNotPressed = TRUE;
	int		testMess=0;

	debug_msg("Entered my_main()\n\n");

	totalMalloced = 0;

	initialise_level();

	debug_msg("Level loaded and initialised.\n");

	firstPass = TRUE;

	fadeTime = 0;

	while(game_on)
	{
		vbls = frames = Sync();

		passFlag ^= TRUE;

		glob1=glob4=0;

 		if ( drawCockpit )
		{
			redraw_cockpit();						/* If switched from map mode to normal then have to redraw panel */
		}
		else
		if ( drawMapScreen )
		{
			redraw_mapscreen();     		/* If switched from game mode to mapmode then have to draw map screen */
		}

		if ( mapmode )
		{
			_dump_map_screen();
		}
		else
		{
			draw_game_screen();
		}

		flash_palette();							/* Flash due to very close explosions */

		adjust_engine();

		on_off ^= 1;

		if (vbls>8)
			vbls=8;											/* Set maximum VBLS to 4. */

		//get_detectable_enemies();
		//get_bullet_detectable_enemies();

		for (i=vbls;i>0;i--)				/* Compensate for speed of machine */
		{
			if ( fadeTime < FADEPOINT )
			{
				fadeTime++;
			}

			if ( messageLength )
			{
				messageLength--;
			}

			msgFlash++;

			messageAnimCounter++;

			currentIgnoreValue++;			/* Update the ignore value, so that all tanks are checked for tank/tank collisions the first time round */

			if ( setoptions )
			{
				set_options();
			}
			else
			{
				if ( (crollData!=NULL) && (*crollData == 0xffff) )
				{
					set_exit_game(ENDGAME_QUIT);
					game_data.missstatus = MISSION_FAILED;
					break;
				}

				get_detectable_enemies();

				player_control();

				animate_wall_textures();	/* Animate the wall textures, no shit ... */

				anim_sprs();							/* Animate sprites. */

				if ( airSupportTriggerd )
				{
					nine_air_support();
				}

				#ifndef TEST_SOUND_FX
				move_sprs(); 							/* Move sprites. */
				#endif

				if ( pl.armour <= ARMOUR_WARNING_LEVEL )
				{
					play_armour_warning_sound();
				}

				do_weapons_1();
			}
		}

		update_message_window();

		if ( mapmode )
		{
			draw_map();
		}
		else
		{
			/** SWITCH SCREENS **/

			if ( bufferId )
			{
				currentScreen = p1screen+(VIEWPORT_TOP*NSCR_WIDTH);
				previousScreen = p2screen;
			}
			else
			{
				currentScreen = p2screen;
				previousScreen = p1screen+(VIEWPORT_TOP*NSCR_WIDTH);
			}

			bufferId^=TRUE;

			scr_ptr = currentScreen;								/* Setup draw screen. */

			pan_offset=(511 - ((camera_angle >> 1 ) & 0x1ff ))&0x1ff;
			reflect_offset=reflect_map+pan_offset;

			scr_ptr = currentScreen + (SCREEN_HORIZON_LEVEL*NSCR_WIDTH);

			do_floor();													/* Setup TVB and draw floor. */

			scr_ptr = currentScreen;

			_draw_background(pan_offset);

			setup_mobs(); 										/* Setup sprite positions and scale values. */

			sprite();	 										/* Draw sprites and walls. */

			process_visible_enemies();	/* SEAN - remove this for Saturn and Playstation. Routine in 'weapons.c' */

			draw_panel_bits();

			do_weapons_2();


			//slap any debug printing shite here
			if ( showStats )
			{
				print(10,32,"frames:%d  pos[%03d,%03d]  attacking tanks:%d",frames, pl.x>>24, pl.z>>24, numAttacking);
				print(10,62,"Message time:%d",messageLength);
				print(10,42,"CHAIN GUN:%d",game_data.cgunupg);
//				print_cheat_stats();
			}

			#ifdef TEST_SOUND_FX
			_print_string(10,32,fxInfo,SINGLE_COLOURED_PRINT);
			#endif
		}

		check_objective();



// take_this_out /////////////////////////////////
//

		#ifdef TEST_SOUND_FX
		ifkey ( K_UP )
		{
			if ( canPlayTest )
			{
				selectedSound++;
				if ( selectedSound>=MAX_TEST_FX )
				{
					selectedSound=0;
				}
				play_selected_sound();
				canPlayTest=FALSE;
			}
		}
		else
			canPlayTest=TRUE;

		ifkey ( K_LEFT )
		{
			if ( canrePlayTest )
			{
				play_selected_sound();
				canrePlayTest=FALSE;
			}
		}
		else
			canrePlayTest=TRUE;

		#endif

		ifkey( K_RET )
		{
			if ( !debounce )
			{
				showEnemyStats^=TRUE;
				debounce = 4;
			}
		}

		ifkey( K_UP )
		{
			if ( !debounce && showEnemyStats )
			{
				currentEnemyStats++;
				if ( currentEnemyStats >= statLimits[showStatType] )
				{
					currentEnemyStats=0;
				}
				debounce = 4;
			}
		}

		ifkey( K_DOWN )
		{
			if ( !debounce && showEnemyStats )
			{
				currentEnemyStats--;
				if ( currentEnemyStats <0  )
				{
					currentEnemyStats=statLimits[showStatType]-1;
				}
				debounce = 4;
			}
		}

		ifkey( K_RIGHT )
		{
			if ( !debounce && showEnemyStats )
			{
				showStatType++;
				if ( showStatType==4 )
				{
					showStatType = 0;
				}
				debounce = 4;
			}
		}


		ifkey( K_HOME)
		{
			followPosition = TRUE;
		}
		else
			followPosition = FALSE;

		ifkey(K_F5 )
		{
			ignoreHits=TRUE;
		}

		ifkey(K_F6)
		{
			ignoreHits=FALSE;
		}

		ifkey(K_F2)
		{
			trippy=1;
		}

		ifkey(K_F3)
		{
			trippy=2;
		}

		ifkey(K_F4)
		{
			trippy=0;
		}

		ifkey(K_F7)
		{
			tintColour++;
			tintColour&=0xff;
		}

		ifkey(K_F8)
		{
			/*-----------------05/12/95 14:24-------------------
			 print out all the stats of the enemies to the debug file
			--------------------------------------------------*/
			display_enemy_data();
		}

		ifkey(K_F9)
		{
			if ( (!messagePlaying ) )
			{
				start_message(testMess);
				testMess++;
				if ( testMess>=MAX_CHARACTER_MESSAGES )
				{
					testMess=0;
				}
			}
		}

		ifkey(K_F10)
		{
			if ( !debounce )
			{
				game_data.cgunupg++;
				if ( game_data.cgunupg>4 )
				{
					game_data.cgunupg=0;
				}
				playerChainReset = (enemyShellDelays[PLAYER_TANK]>>3) - (game_data.cgunupg);
				debounce = 4;
			}
		}


		ifkey(K_F12)	// Saves out a screen shot in neo format
		{
			photo();
		}
//////////////////////////////////////////////////

		if (debounce)
			debounce--;


		ifkey(K_ESC)
		{
			if ( escapedNotPressed )
			{
				if ( mapmode )				// go back into main game screen if in mapmode
				{
					drawCockpit = TRUE;
					draw_weapon_display(pl.cWeapon);
					draw_armour_display();
					mapmode=FALSE;
				}
				else
				if ( setoptions )			// already in options page
				{
					setoptions=FALSE;
					if ( optionSettings[MUSIC_OPTION] )
					{
						CDResume();
					}
					start_engine();
				}
				else									// go into options page
				{
					SoundStopAllSamples();
					CDStop();
					setoptions=TRUE;
				}
				escapedNotPressed = FALSE;
			}
		}
		else
			escapedNotPressed = TRUE;



		#ifdef CD_VERSION
	 	if ( normalCD )
		{
			if ( cdPollCounter==0 )
			{
				CDLoop();
				cdPollCounter=CD_POLL_FACTOR;
			}
			else
				cdPollCounter--;
		}
		#endif

		firstPass = FALSE;
	}

	CDStop();

	debug_msg("** total memory alloced for mission %d = %d bytes",game_data.mission, totalMalloced);


	/** normal game death effect */

	if ( endgameStatus==ENDGAME_KILLED )
	{
		for ( i=0, palptr=flashpal; i<256; i++ )
		{
			*palptr++=62; 	/* White flash */
			*palptr++=62;
			*palptr++=63;
		}

		stop_engine_sound();
		play_death_sound();

		fade_to_pal(4,flashpal);
		wait_fade();
		for ( i=0, palptr=flashpal; i<256; i++ )
		{
			*palptr++=10; 	/* Red fade */
			*palptr++=3;
			*palptr++=3;
		}

		fade_to_pal(48,flashpal);
		wait_fade();

		game_data.missstatus=TANK_DESTROYED;
	}
	else
		game_data.missstatus=MISSION_FAILED;


	/** return appropriate values to the menu **/

	if ( objectiveAchieved && endgameStatus==ENDGAME_COMPLETED )
	{
		game_data.money+=MISSION_REWARD;
		game_data.missstatus=MISSION_SUCC;
	}

	/* Update the game_data structure */

	game_data.armlev = pl.max_armour>>8;
	game_data.armint = pl.armour>>5;
	game_data.money += moneyCollected;
	game_data.perc_host = 0;
	game_data.perc_trucks = 0;
//	game_data.nairtarg_dest = 0;

	game_data.hitacc = (numShotsFired) ? ((((numShotsHit*100)<<16)/numShotsFired) >> 16) : 0;

	switch ( objectiveType )
	{
		case DESTROY_ALL_ENEMIES_OBJECTIVE:
			game_data.perc_obj = (((game_data.perc_obj*100)<<16)/totalObjectiveEnemies)>>16;
			break;

		case DESTROY_BUILDINGS_OBJECTIVE:
			game_data.perc_obj = (((game_data.perc_obj*100)<<16)/numObjectiveBuildings)>>16;
			break;

		case RESCUE_HOSTAGE_OBJECTIVE:
			game_data.perc_host = (((numHostagesCollected*100)<<16)/numHostages) >> 16;
			game_data.perc_obj = 0;				/* no objectives destroyed */
			break;

		case DESTROY_CONVOY_OBJECTIVE:
			game_data.perc_obj = 0;				/* no objectives destroyed */
			game_data.perc_trucks = 0;
			break;

		case PROTECT_CONVOY_OBJECTIVE:
			game_data.perc_obj = 0;				/* no objectives destroyed */
			game_data.perc_trucks = 0;
			break;
	}

 	cleanup_after_level();

	debug_msg("Left my_main()\n\n");
}

/************************************************************************/


/************************************************************************/
/************************************************************************/
/************************************************************************/
/************************************************************************/







#ifdef TEST_SOUND_FX


void	play_selected_sound(void)
{
	GUN_EMPLACEMENT tgunempl;

	tgunempl.shellDelayCount=0;
	tgunempl.burstCount=0;
	tgunempl.chaingunSound=0;
	tgunempl.exist=TRUE;
	tgunempl.x = pl.x; tgunempl.z = pl.z;

	switch ( selectedSound )
	{
		case 0:
			shell_explosion_sound(pl.x, pl.z);
			sprintf(fxInfo, "shell_explosion_sound:%d",soundPitchUsed);
			break;

		case 1:
			player_hit_sound(0x100);
			sprintf(fxInfo, "player_hit_sound:%d",soundPitchUsed);
			break;

		case 2:
			fire_shell_sound(&pl);
			sprintf(fxInfo, "fire_shell_sound:%d",soundPitchUsed);
			break;

		case 3:
			enemy_destroyed_sound(2,pl.x, pl.z);
			sprintf(fxInfo, "enemy_destroyed_sound:%d",soundPitchUsed);
			break;

		case 4:
			chaingun_sound(&pl);
			sprintf(fxInfo, "chaingun_sound:%d",soundPitchUsed);
			break;

		case 5:
			gunempl_chaingun_sound(&tgunempl);
			sprintf(fxInfo, "gunempl_chaingun_sound:%d",soundPitchUsed);
			break;

		case 6:
			enemy_hit_sound(pl.x, pl.z, 0x180);
			sprintf(fxInfo, "enemy_hit_sound:%d",soundPitchUsed);
			break;

		case 7:
			reload_sample();
			sprintf(fxInfo, "reload_sample:%d",soundPitchUsed);
			break;

		case 8:
			play_launch_sam_sound();
			sprintf(fxInfo, "play_launch_sam_sound:%d",soundPitchUsed);
			break;

		case 9:
			play_fence_crunch_sound();
			sprintf(fxInfo, "play_fence_crunch_sound:%d",soundPitchUsed);
			break;

		case 10:
			play_picked_up_collectable_sound();
			sprintf(fxInfo, "play_picked_up_collectable_sound:%d",soundPitchUsed);
			break;


		case 11:
			play_armour_warning_sound();
			sprintf(fxInfo,"play_armour_warning_sound:%d",soundPitchUsed);
			break;

		case 12:
		play_crunch_sound();
		sprintf(fxInfo,"play_crunch_sound:%d",soundPitchUsed);
		break;

		case 13:
		stop_turret_moving_sound();
		sprintf(fxInfo,"stop_turret_moving_sound:%d",soundPitchUsed);
		break;

		case 14:
		play_death_sound();
		sprintf(fxInfo,"play_death_sound:%d",soundPitchUsed);
		break;

		case 15:
		start_turret_moving_sound();
		sprintf(fxInfo,"start_turret_moving_sound:%d",soundPitchUsed);
		break;

		case 16:
		play_click_sound();
		sprintf(fxInfo,"play_click_sound:%d",soundPitchUsed);
		break;

		case 17:
		play_turret_locked_sound();
		sprintf(fxInfo,"play_turret_locked_sound:%d",soundPitchUsed);
		break;

		case 18:
		normal_building_explosion_snd(pl.x>>16, pl.z>>16);
		sprintf(fxInfo,"normal_building_explosion_snd:%d",soundPitchUsed);
		break;

		case 19:
		large_building_explosion_snd(pl.x>>16, pl.z>>16);
		sprintf(fxInfo,"large_building_explosion_snd:%d",soundPitchUsed);
		break;

		case 20:
		small_building_explosio_snd(pl.x>>16, pl.z>>16);
		sprintf(fxInfo,"small_building_explosio_snd:%d",soundPitchUsed);
		break;

		case 21:
		fuel_tank_explosion_snd(pl.x>>16, pl.z>>16);
		sprintf(fxInfo,"fuel_tank_explosion_snd:%d",soundPitchUsed);
		break;

		case 22:
		reset_message_status();
		start_message(0);
		sprintf(fxInfo,"message 0:%d",soundPitchUsed);
		break;

		case 23:
		reset_message_status();
		start_message(1);
		sprintf(fxInfo,"message 1:%d",soundPitchUsed);
		break;

		case 24:
		reset_message_status();
		start_message(2);
		sprintf(fxInfo,"message 2:%d",soundPitchUsed);
		break;

		case 25:
		reset_message_status();
		start_message(3);
		sprintf(fxInfo,"message 3:%d",soundPitchUsed);
		break;

		case 26:
		reset_message_status();
		start_message(4);
		sprintf(fxInfo,"message 4:%d",soundPitchUsed);
		break;

		case 27:
		reset_message_status();
		start_message(5);
		sprintf(fxInfo,"message 5:%d",soundPitchUsed);
		break;

		case 28:
		reset_message_status();
		start_message(6);
		sprintf(fxInfo,"message 6:%d",soundPitchUsed);
		break;

		case 29:
		reset_message_status();
		start_message(7);
		sprintf(fxInfo,"message 7:%d",soundPitchUsed);
		break;

		case 30:
		reset_message_status();
		start_message(8);
		sprintf(fxInfo,"message 8:%d",soundPitchUsed);
		break;

		case 31:
		reset_message_status();
		start_message(9);
		sprintf(fxInfo,"message 9:%d",soundPitchUsed);
		break;

		case 32:
		reset_message_status();
		start_message(10);
		sprintf(fxInfo,"message 10:%d",soundPitchUsed);
		break;

		case 33:
		reset_message_status();
		start_message(11);
		sprintf(fxInfo,"message 11:%d",soundPitchUsed);
		break;

		case 34:
		reset_message_status();
		start_message(12);
		sprintf(fxInfo,"message 12:%d",soundPitchUsed);
		break;

		case 35:
		reset_message_status();
		start_message(13);
		sprintf(fxInfo,"message 13:%d",soundPitchUsed);
		break;

		case 36:
		reset_message_status();
		start_message(14);
		sprintf(fxInfo,"message 14:%d",soundPitchUsed);
		break;

		case 37:
		reset_message_status();
		start_message(15);
		sprintf(fxInfo,"message 15:%d",soundPitchUsed);
		break;

		case 38:
		reset_message_status();
		start_message(16);
		sprintf(fxInfo,"message 16:%d",soundPitchUsed);
		break;

		case 39:
		reset_message_status();
		start_message(17);
		sprintf(fxInfo,"message 17:%d",soundPitchUsed);
		break;

		case 40:
		reset_message_status();
		start_message(18);
		sprintf(fxInfo,"message 18:%d",soundPitchUsed);
		break;

	}
}



#endif

