/*-----------------10/07/95 12:38-------------------

Scan the Shellshock map files (estimate ram useage for maps if we prestore flips/rotates)

--------------------------------------------------*/


#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <dos.h>

/* PROTOTYPES */

struct iffdat	scan_iff(char *iff_pointer, char *pal_pointer);
void		grab_iff(char *iff_pointer, char *raw_pointer, struct iffdat idat);

void		force_bitplanes(char *raw_address, char *dest_address, struct iffdat idat);
void		force_bytepp(char *raw_address, char *dest_address, struct iffdat idat);

int 		make_iff(char *raw_srce, char *pal_source, char *iff_address, int width, int height, int plen, int planes);
void		make_bp(char *raw_srce, int plen, int planes, char *bp_pointers[8]);
int 		doline(char *raw_srce, char *iff_dest, int bw);
int 		do_term(char *iff_stash1, int data2, int phase);
int 		round_word(int value);
int 		round_long(int value);
int 		round_16(int value);
void		stash_byte(char *address, int value);
void		stash_word(char *address, int value);
void		stash_long(char *address, int value);
short int	grabword(char *iff_pointer);
void		stash_id(char *address, char *id_array);
int 		check_id(char *iff_pointer, char *id_array);
int 		find_id(char *iff_pointer, char *id_array, int search_size);
long int	find_length(char filename[]);
void		save_file(char filename[], char address[], int size);
void		load_file(char filename[], char address[], int size);
char *		allocate_ram( int size );
void		clearbuf(char *address, int size);
void		set_screen_mode(int fanny);
int 		get_screen_mode(void);
void		fill_screen(char val);
void		set_palette(char *palptr, int firstreg, int numcols);

#define		SCREEN_AREA 0xa000    			/* screen address */
#define		SCREEN_LIN_ADDR ((SCREEN_AREA) << 4)
#define		SCREEN_SIZE (320*200)


/* GLOBAL VARIABLES */

char		palbuffer[768];				/* 768 bytes palbuffer */

char		form_array[4]={'F','O','R','M'};	/* FORM */
char		ilbm_array[4]={'I','L','B','M'};	/* ILBM */
char		bmhd_array[4]={'B','M','H','D'};	/* BMHD */
char		cmap_array[4]={'C','M','A','P'};	/* CMAP */
char		body_array[4]={'B','O','D','Y'};	/* BODY */
char		pbm_array[4]={'P','B','M',' '};		/* PBM  */

char		palette_data[256*3];

char		iffname[]="text?.lbm";
char		psxname[]="text?.dat";
char		infoname[]="textures.inf";

char		palfname[]="wallpal.dat";



int			tabbuf[8][64];


struct texlook
{
		short		tnum;										/* text page number */
		short 	u;											/* xoffset */
		short 	v;											/* yoffset */
		short 	dummy;
};

struct texlook	tlook[8][64];		 	/* texture lookup table! */



struct		iffdat					/* struct "iffdat" (used by scaniff) */
{
short int	error;					/* error flag */
short int	truewidth;				/* true width */
short int	width;					/* width */
short int	height;					/* height */
short int	planes; 				/* planes */
short int	masking;				/* masking flag */
short int	byterun;				/* compression flag */
short int	bytesperrow;				/* bytes per row */
short int	mode;					/* mode 0=ilbm / 1=pbm */
int 		oneplane;				/* size of one bitplane */
int		picsize;   				/* picture size */
};


int		rawformat = 1;	   			/* 0=planes / 1=byte per pixel */


FILE		*fileptr;	   			/* File pointer variable */


char	*solid_adr;
char	*ragged_adr;
char	*trans_adr;
char	*transa_adr;
char	*anim_adr;

char	*rotatebuf;					/* rotate buffer for texture */
char	*flipbuf;						/* flip buffer for texture */


int	num_solid;
int	num_ragged;
int	num_trans;
int	num_transa;
int	num_anims;

int	total_textures;
int num_tpages;

int	txtcnt;
int	iffsize;

char		*txmbuf;					/* pointer to TXM file buffer */
char		*psxbuf;					/* pointer to PSX TEXTURE BUFFER */


char		*atobuf;					/* ato buffer */




int	current_walltype;
int	current_count;



get_animating_textures(char *anim_adr,int numframes);





/*********************************************************************/
/**** MAIN **** */
/*********************************************************************/

void			main(void)
{
char	loadfilename[512];


char 	*original_blks_buf;				/* original blocks data */
char	*mapbuffer;								/* map buffer (128k) */
char	*tagbuf;									/* block tag buffer (2048 bytes) */
char	*fliptabs;								/* flip tables (16k) */


char	*blkdatabuf;							/* destination PSX blocks */
char	*psxlookbuf;							/* destination PSX block lookup table */



int	used;
int	mapcnt;
int	worst;


int	thesize;



/** allocate 16k for flip tables **/
	fliptabs = allocate_ram(0x04000);
/** load flip tables **/
	load_file("c:\\shok\\sgraphix\\data\\lookup.tab",fliptabs,0x04000);

/** allocate 256k for original blocks **/
	original_blks_buf = allocate_ram(0x040000);
/** load original blocks */
	load_file("c:\\shok\\sgraphix\\floors\\floor.pc",original_blks_buf,0x040000);



/** allocate a 128k buffer for the map buffer **/
	mapbuffer = allocate_ram(0x020000);
/** allocate a 2k buffer for map block tags **/
	tagbuf = allocate_ram(2048);

/** allocate a 512k buffer for NEW PSX blocks **/
	blkdatabuf = allocate_ram(0x080000);

/** allocate a (2048*8) byte buffer for block offsets **/
	psxlookbuf = allocate_ram(2048*8);






	worst = 0;



	for ( mapcnt=0; mapcnt<26; mapcnt++ )
	{

		clearbuf(blkdatabuf,0x080000);				/* clear psx blocks buffer */
		clearbuf(psxlookbuf,2048*8);					/* clear psx blocks lookup buffer */



 		clearbuf(mapbuffer,0x020000);					/* clear map buffer */
 		clearbuf(tagbuf,2048);								/* clear tag buffer */


/** load the map file **/
 		sprintf(loadfilename,"c:\\shok\\slevels\\floor_%02d.fmp",mapcnt);
		load_file(loadfilename,mapbuffer,0x020000);


/** scan me up bitch! **/
 		used = scan_the_map(mapbuffer,tagbuf,original_blks_buf,fliptabs,blkdatabuf,psxlookbuf);


		if ( used > worst )
			worst=used;





		printf("number of blocks used in map %d = %d... RAM USEAGE = %d bytes\n",mapcnt,used,used*1024);


/** save psx lookup table **/
 		sprintf(loadfilename,"c:\\shok\\slevels\\floor_%02d.tab",mapcnt);
		save_file( loadfilename,psxlookbuf,(2048*8) );

/** save psx blocks **/
 		sprintf(loadfilename,"c:\\shok\\slevels\\floor_%02d.pc",mapcnt);

		thesize = used*1024;
		if ( thesize < 0x040000 )
			thesize = 0x040000;

		save_file(loadfilename,blkdatabuf,thesize );
	}

	printf("\n\nWorst ram useage of blocks = %d bytes\n\n",worst*1024);

	free(fliptabs);
	free(tagbuf);
	free(mapbuffer);

}


/** this routine runs through the map and tags used blocks in *tags **/

int	scan_the_map(char *map,char *tags,char *pcblks, char *fliptabs,char *psxblks, char *psxlook)
{
int	 cnt;
int		numused;
short *mapme;
short	blkno;


	numused = 0;

	mapme = (short *)map;


	for ( cnt=0; cnt<(256*256); cnt++ )
	{
		blkno = *(mapme++);
		blkno = blkno>>3;
		blkno = blkno & 2047;

		if ( *(tags+blkno) == 0 )
		{
			*(tags+blkno) = 1;

			stash_this_block(blkno,numused,pcblks,fliptabs,psxblks,psxlook);

			numused++;
		}
	}
	return(numused);
};





/** this routine stashes the block in the new blocks buffer **/
/** & also stashes offset in psxlookup */

void			stash_this_block(int oldblk, int newblk, char *pcblks, char *fliptabs,char *psxblks, char *psxlook)
{

char *source;
short *flip_table;
char *destbuf;

int *lookup;

int	xcnt,ycnt;
short	blkoff;
char	data;



	source = pcblks + ((oldblk&255)*1024);					/* address of source block data */

	fliptabs = fliptabs + ((oldblk>>8)*2048);				/* address of flip table to use */
	flip_table = (short *)fliptabs;

	destbuf = psxblks;
	destbuf = destbuf + (newblk*1024);							/* address of destination block buffer */

	psxlook = psxlook + (oldblk*8);
	lookup = (int *)psxlook;												/* address of lookup for block */

	for ( ycnt=0; ycnt<32; ycnt++ )
	{

		for ( xcnt=0; xcnt<32; xcnt++ )
 		{

			blkoff = *( flip_table+ (xcnt+(ycnt*32)) );							/* get source data offset */
 			data = *(source + blkoff);										/* get source byte */

			*(destbuf++) = data;															/* stash a byte of block data */
		}

	}

	*(lookup++) = (newblk*1024);											/* stash offset for block in psxlookup */
	*(lookup) = 0x044454c20;		/* stash "del " */


	return;
};





/*********************
************************************************/
/* SCANIFF(iffdata_address,palettestash_address) - returns "iffdat" struct */
/*********************************************************************/
/* updated to handle ILBM or PBM modes (see grabiff) June 16th 1994! */

struct iffdat	scan_iff(char *iff_pointer, char *pal_pointer)

{

int		i;	  			/* COUNTER VARIABLE */
int		offset;	  			/* OFFSET VARIABLES */
short int	numcols;

struct iffdat	idat;

	if ( check_id(iff_pointer,form_array) )		/* look for FORM */
		{
		printf("ERROR - Unable to find FORM\n"); /* ERROR */
		idat.error=1;
		return(idat);
		}

	iff_pointer += 8; 				/* skip 8 bytes */

	idat.mode=0;	  				/* SET mode zero ("ILBM") */

	if ( check_id(iff_pointer,ilbm_array) )		/* look for ILBM */
		{

		idat.mode=1;				/* SET mode one ("PBM ") */

		if ( check_id(iff_pointer,pbm_array) )	/* look for PBM */
			{
			printf("ERROR - Unable to find ILBM OR PBM\n"); /* ERROR */
			idat.error=1;
			return(idat);
			}

		}

	iff_pointer += 4;   				/* skip 4 bytes */

	if ( check_id(iff_pointer,bmhd_array) )		/* look for BMHD */
		{
		printf("ERROR - Unable to find BMHD\n"); /* ERROR */
		idat.error=1;
		return(idat);
		}

	iff_pointer += 8;   				/* skip 8 bytes */

	idat.width = grabword(iff_pointer);		/* get width.w */
	idat.height = grabword(iff_pointer+2);		/* get height.w */

	idat.truewidth = idat.width;

	iff_pointer += 8;   				/* skip 8 bytes */

	idat.planes = (short int) *(iff_pointer++);	/* get numplanes.w */


	if ( idat.planes > 8 )
		{
		printf("ERROR - too many bitplanes\n");	/* ERROR */
		idat.error=1;
		return(idat);
		}


	idat.masking = (short int) *(iff_pointer++);	/* get masking.w */
	idat.byterun = (short int) *(iff_pointer++);	/* get byterun.w */

	iff_pointer++;	    				/* skip a byte */

	numcols = (1<<idat.planes);			/* calc number of colours */

	offset = find_id(iff_pointer,cmap_array,40);
	if ( offset == -1)
		{
		printf("ERROR - Unable to find CMAP\n"); /* ERROR */
		idat.error=1;
		return(idat);
		}

	iff_pointer += (offset+8);				/* skip offset+8 bytes */


	for (i=0; i<(numcols*3); i++)
		{
		*(pal_pointer++) = *(iff_pointer++);	/* get palette in buffer */
		}

	idat.bytesperrow = ((idat.width+15)/8)&~1;		/* calc bytes per row */
	idat.oneplane = (idat.bytesperrow*idat.height);	/* calc size of one plane */
	idat.picsize = (idat.planes*idat.oneplane);		/* calc picture size */


	offset = find_id(iff_pointer,body_array,4000);
	if ( offset == -1 )
		{
		printf("ERROR - Unable to find BODY\n"); /* ERROR */
		idat.error=1;
		return(idat);
		}

	iff_pointer += (offset+8);				/* skip offset+8 bytes */

	if (idat.mode==1)
		{
		idat.width = round_word(idat.width);	/* round width to 2 (even) */
		}
	else
		{
		idat.width = round_16(idat.width);	 	/* round width to 16 */
		}

	return(idat);							/* Everything is funky! */

}

/*********************************************************************/
/* GRAB_IFF(iffdata_address,rawdata_address,nextline,nextplane) */
/*********************************************************************/
/* Updated to handle ILBM or PBM modes - June 16th 1994  */
/* updated to always convert to bitplanes - June 17th 1994 */

void		grab_iff(char *iff_pointer, char *raw_pointer, struct iffdat idat)

{

char		*raw_stash;

char		*raw_pointer1; 				/* RAWPOINTER STASH #1 */
char		*raw_pointer2; 				/* RAWPOINTER STASH #2 */
char		repbyte=0;    				/* DEPACK REPEAT BYTE */
char		command=0;   				/* DEPACK COMMAND BYTE */
int 		offset;				   	/* OFFSET VARIABLE */
int 		hcnt;				   	/* HEIGHT COUNTER */
int 		pcnt;				   	/* PLANE COUNTER */
int 		bout;				   	/* BYTES OUT (depacker) */
int 		i;				   	/* COUNTER VARIABLE */

int		bpl;
int		pll;

int		if_nextline;
int		if_nextplane;


	if_nextline = idat.bytesperrow;
	if_nextplane = idat.oneplane;


	raw_stash = raw_pointer;

	if (idat.mode == 0)				/* ILBM OR PBM DEPACK? */
		{
		bpl = idat.bytesperrow;	 		/* bytes per line for depack */
		pll = idat.planes;	 		/* loop amount for planes */
		}
	else
		{
		bpl = idat.width;	 		/* width of pic (byte per pix) */
		pll = 1;							/* 1 plane (byte per pix) */
		}

	offset = find_id(iff_pointer,body_array,6000);	/* find BODY */
	if ( offset == -1 )
		{
		printf("ERROR - Unable to find BODY\n"); /* ERROR */
		exit(0);
		}
	iff_pointer += (offset+8);				/* skip offset+8 bytes */


	for (hcnt=0; hcnt<idat.height; hcnt++)
		{
		raw_pointer2=raw_pointer;			/* stash raw_pointer */

		for (pcnt=0; pcnt<pll; pcnt++)
			{
			raw_pointer1=raw_pointer;		/* stash raw_pointer */


			if (idat.byterun==0)			/* Byterun? */
				{
				for (i=0; i<bpl; i++)
					{
					*(raw_pointer++) = *(iff_pointer++);	/* copy line of data */
	 				}
				}
			else
				{

				bout=0;
				while (bout != bpl)				/* Bytes out same as bytes per row? */
					{

					command = *(iff_pointer++);	/* Get a byte of IFF data (command) */

					if ( command <= 127 )	/* Greater or equal? */
						{
						command++;
						while ( command != 0 )
							{
							*(raw_pointer++) = *(iff_pointer++); /* literal copy */
							bout++;
							command--;
							}
						continue;				/* continue loop */
						}

					if (command == 128)
						{
						continue;
						}

					repbyte = *(iff_pointer++);

					command = ((0-command)&255);
					command++;

					while (command != 0)
						{
						*(raw_pointer++) = repbyte;	/* do repeats */
						bout++;
						command--;
	 					}
					continue;

					} /* END OF WHILE (IN DEPACK LOOP) */

				} 							/* END OF ELSE */

			if (idat.mode==0)
				{
				raw_pointer = (raw_pointer1+if_nextplane);
				}

			}								/* END OF PLANES LOOP */

		if (idat.mode==0)
			{
			raw_pointer = (raw_pointer2+if_nextline);
			}


		}									/* END OF HEIGHT LOOP */


	return;

}



/**************************************************************/
/*** FORCE_BITPLANES (convert byte-per-pixel to bitplanes!) ***/
/**************************************************************/

void		force_bitplanes(char *raw_address, char *dest_address, struct iffdat idat)
{

char		*dest_stash;
char		*raw_stash;
char		*temp_address;
char		data;
int			pcnt;
int			wcnt;
int			i2;

	dest_stash = dest_address;	     		/* stash dest_address */
	raw_stash = raw_address;	      		/* stash raw_address */


	for (wcnt=0; wcnt<idat.oneplane; wcnt++)
		{

		i2=7;					/* bit position = 7 */

		do
			{

			data = *(raw_address++);  	/* get a byte of data */

			for (pcnt=0; pcnt<8; pcnt++)
				{
				if ( data & (1<<pcnt) )	/* is bit set? */
					{
					temp_address = ( dest_address + (pcnt*(idat.oneplane)) );
					*(temp_address) = ( *(temp_address) | ( 1<<i2 ) );
					}
				}

			i2--;				/* decrement bit position */

			}

		while ( i2 >= 0 );

		dest_address++;

		}


	return;								/* outta here! */
}


/**************************************************************/
/* FORCE_BYTEPP (BITPLANES to BYTE PER PIXEL!) */
/**************************************************************/

void		force_bytepp(char *raw_address, char *dest_address, struct iffdat idat)
{

char		*dest_stash;
char		*raw_stash;
char		data;
int		pcnt;
int		i2;

int		pixelval;
int		cnt;

	dest_stash = dest_address;				/* stash dest_address */
	raw_stash = raw_address;					/* stash raw_address */


	for (cnt=0; cnt<idat.oneplane; cnt++)

		{

		i2=7;									/* bit position = 7 */

		do
			{

			pixelval = 0;							/* pixel starts at zero */
			for (pcnt=0; pcnt<idat.planes; pcnt++)
				{
				data = *raw_address;				/* grab bitplane data */
				if ( data & (1<<i2) )				/* is bit set? */
					{
					pixelval += (1<<pcnt);			/* set correct col bit */
					}
				raw_address += idat.oneplane;			/* next bitplane please */
				}


			raw_address -= (idat.oneplane*idat.planes);
			*(dest_address++) = pixelval;				/* stash pixel */

			i2--;

			}

		while (i2 >= 0);

		raw_address++;								/* next byte */


		}

	return;								/* outta here! */
}



/*********************************************************************/
/* Compressed IFF saver! Started - 13th June 1994 (11:25am) */
/*********************************************************************/
/* Seems to be working ok at 14th June 1994 15:14pm! (sweet!) */
/* Header is coming together at 16:36pm */
/* reckon it's a goer...! at 17:19pm (we like that!) */
/* Fixed length! (rounded to long) June 15th 9:40am (keen) */
/* neatened up a tad 11:18 (not 100% tho..!) */

int		make_iff(char *raw_srce, char *pal_source, char *iff_address, int width, int height, int plen, int planes)
{

struct		iff_header					/* struct "iff_header"	*/
{
char		h_form[4];					/* "FORM" ID in header	*/
char		h_tfl[4];				     	/* file length (long)	*/
char		h_ilbm[4];					/* "ILBM" ID in header  */
char		h_bmhd[4];					/* "BMHD" ID in header 	*/
char		h_head1[4];					/* header len (long)	*/
char		h_pwidth1[2];					/* Pixel Width (word)  	*/
char		h_pheight1[2];					/* Pixel Height (word) 	*/
char		h_unknown1[4];					/* UNKNOWN1 (long)     	*/
char		h_planes[1];	  				/* num planes (byte)	*/
char		h_masking[1];					/* masking flag (byte)	*/
char		h_compression[1];				/* compression (byte)	*/
char		h_unknown2[1];					/* UNKNOWN2 (byte)     	*/
char		h_unknown3[4];					/* UNKNOWN3 (long $101?)*/
char		h_pwidth2[2];					/* Pixel Width (word)	*/
char		h_pheight2[2];					/* Pixel Height (word)	*/
char		h_cmap[4];					/* "CMAP" ID in header	*/

	}		header = {0};				/* HEADER DATA (CLEARED)*/


char		*bp_pointers[8];				/* pointers to bitplanes */
char		*iff_dest;					/* IFF dest buffer */
char		*header_address;				/* header address */
char		*body_address;					/* BODY address */

int		bw;		   				/* Byte width of a line */
int	     	pcnt;						/* bitplane loop counter */
int	     	hcnt;						/* height loop counter */
int	     	line_offset;					/* line offset variable */
int	     	psize;						/* size of a packed line */
int	     	bodysize;	   				/* size of BODY data */
int	     	hlen;						/* header length variable */
int	     	ncols;						/* number of cols */
int	     	filesize;	   				/* filesize */
int	     	i;		   				/* loop counter var */

	printf("\nMaking IFF data...");


	line_offset = 0;
	width = round_16(width);					/* round width upto 16 */


	bw = width/8;							/* calc byte width */

	make_bp(raw_srce, plen, planes, bp_pointers); /* make bitplane pointers */


	iff_dest = iff_address+sizeof(header);		/* buffer address + header */

	ncols = (1<<planes);					/* calc number of colours */
	stash_long(iff_dest,ncols*3);				/* stash palette length */

	iff_dest += 4;							/* skip 4 bytes */
	for (i=0; i<ncols*3; i++)
		{
		*(iff_dest++) = *(pal_source++)<<2;		/* copy palette data! */
		}

	body_address = iff_dest;					/* stash address of BODY */

	stash_id(iff_dest,body_array);			/* stash "BODY" ID */
	iff_dest += 8;							/* skip 8 bytes */


	for (hcnt=0; hcnt<height; hcnt++)	   		/* loop for height */
		{

		for (pcnt=0; pcnt<planes; pcnt++)		/* loop for planes */
			{
			raw_srce = bp_pointers[pcnt];		/* get bitplane address */
			raw_srce += line_offset;			/* add line offset */
			psize = doline(raw_srce, iff_dest, bw); /* PACK ME! */
			iff_dest += psize;
			}

		line_offset += bw;					/* add line length */

		}

	bodysize = ((iff_dest-body_address)-8);		/* calc size of body */
	bodysize = round_long(bodysize);	 	/* round size upto long */
	stash_long ( body_address+4, bodysize );	/* Stash BODYSIZE */

	stash_id(header.h_form,form_array);		/* stash "FORM" ID */

	filesize = (iff_dest - iff_address);		/* calc size of file */
	filesize = round_long(filesize);	 	/* round size upto long */
	stash_long(header.h_tfl,(filesize-8));		/* stash filesize in header*/

	stash_id(header.h_ilbm,ilbm_array);		/* stash "ILBM" ID */
	stash_id(header.h_bmhd,bmhd_array);		/* stash "BMHD" ID */

	hlen = (header.h_cmap - header.h_pwidth1);	/* calc size of header */
	stash_long(header.h_head1,hlen);	 	/* stash header length */

	stash_word(header.h_pwidth1,width);		/* Stash WIDTH1.w */
	stash_word(header.h_pheight1,height);		/* Stash HEIGHT1.w */
	stash_long(header.h_unknown1,0);	 	/* unknown1 is $0.l */
	stash_byte(header.h_planes,planes);		/* stash planes.b */
	stash_byte(header.h_masking,0);			/* stash masking.b */
	stash_byte(header.h_compression,1);		/* stash compression.b */
	stash_byte(header.h_unknown2,0);	 	/* unknown2 is $0.b */
	stash_long(header.h_unknown3,0x101);		/* unknown3 is $101.l */
	stash_word(header.h_pwidth2,width);		/* Stash WIDTH2.w */
	stash_word(header.h_pheight2,height);		/* Stash HEIGHT2.w */
	stash_id(header.h_cmap,cmap_array);		/* stash "CMAP" ID */

	header_address = (char*) &header;   		/* setup header pointer */
	iff_dest = iff_address;	     			/* setup iff pointer */

	for (i=0; i<sizeof(header); i++)
		{
		*(iff_dest++) = *(header_address++);	/* copy header data */
		}

	printf("OK!\n");

	return(filesize);			 	/* return (with filesize) */

}


/*********************************************************************/
/** make_bp(raw_address,plane_len,bitplane_pointers  **/
/*********************************************************************/

void		make_bp(char *raw_srce, int plen, int planes, char *bp_pointers[8])

{

int			i;

	for (i=0; i<planes; i++)
		{
		bp_pointers[i] = raw_srce;			/* stash bitplane pointer */
		raw_srce += plen;					/* next bitplane */
		}

	return;
}

/****************************************/
/* Crunch a single scanline of RAW data */
/****************************************/


int		doline(char *raw_srce, char *iff_dest, int bw)
{

char		*endofline;				/* pointer to end of line */
char		*iff_stash1;
char		*raw_stash1;
char		*stash;					/* used to calc IFFDEST on exit */

int		phase;
int		data;
int		data1;
int		data2;
int		i;


	stash=iff_dest;

	endofline = (raw_srce+bw);
	phase=1;
	data2=0;

	while (raw_srce != endofline)
		{

		raw_stash1=raw_srce;				/* stash raw_srce */
		data = *(raw_stash1++);				/* get a byte of RAW */

		if ( (data != *(raw_stash1++)) || (data != *(raw_stash1++)) || (raw_stash1 >= endofline) )
			{

		 	if (phase==1)
				{
				iff_stash1=iff_dest;		/* stash address for later */
				*(iff_dest++)=0;			/* and drop a zero */
				data2=0;
				phase=0;
				}

			*(iff_dest++)=(char)data;		/* stash unpacked byte */
			raw_srce++;
			data2++;
			continue;

			}

		phase = do_term(iff_stash1,data2,phase); /* terminate sequence */

		for (i=0; i<bw; i++)
			{
			if ( (data != *(raw_stash1++)) )	/* another repeat? */
				{
				break;					/* No, so break loop */
				}
			}

		raw_stash1--;

		if ( raw_stash1 >= endofline )		/* Did we go past eol? */
			{
			raw_stash1 = (endofline);
			}

		data1 = (raw_stash1-raw_srce)-1;		/* calc repeat length */
		data1 = ( (0-data1)&255 );			/* negate repeat length */

		*(iff_dest++) = (char)data1;			/* stash repeated length */
		*(iff_dest++) = (char)data;			/* stash repeat byte */

		raw_srce = raw_stash1;
		phase = 1;
		continue;							/* CONTINUE with loop */

		}

	phase = do_term(iff_stash1,data2,phase);	/* terminate sequence */

	return(iff_dest-stash);					/* return packed length */

}

/*********************************************************/
/* terminate sequence of uncrunched bytes (if necessary) */
/*********************************************************/

int			do_term(char *iff_stash1, int data2, int phase)
{

	if (phase==0)
		{
		data2--;							/* calc num unpacked bytes */
		*(iff_stash1)=(char)data2;			/* stash it (over zero) */
		phase=1;
		}

	return(phase);
}


/**************/
/* ROUND_WORD */
/**************/


int			round_word(int value)

{

	if ( value != (value&~1) )				/* Is VALUE word aligned? */
		{
		value = ((value&~1)+2);				/* it is now!! */
		}

	return(value);
}



/**************/
/* ROUND_LONG */
/**************/


int			round_long(int value)

{

	if ( value != (value&~3) )				/* Is VALUE long aligned? */
		{
		value = ((value&~3)+4);				/* it is now!! */
		}

	return(value);
}


/************/
/* ROUND_16 */
/************/


int			round_16(int value)

{

	if ( value != (value&~15) )				/* Is VALUE 16 aligned? */
		{
		value = ((value&~15)+16);			/* it is now!! */
		}

	return(value);
}









/*********************************************************************/
/*** STASH_BYTE(value,address) ***/
/*********************************************************************/

void		stash_byte(char *address, int value)

{
	*(address) = ((value)&255);				/* stash bits 0-7	*/
	return;
}

/*********************************************************************/
/*** STASH_WORD(value,address) ***/
/*********************************************************************/

void		stash_word(char *address, int value)

{
	*(address++) = ((value>>8)&255);			/* stash bits 8-15	*/
	*(address) = ((value)&255);				/* stash bits 0-7	*/
	return;
}

/*********************************************************************/
/*** STASH_LONG(value,address) ***/
/*********************************************************************/

void		stash_long(char *address, int value)

{
	*(address++) = ((value>>24)&255);			/* stash bits 24-31	*/
	*(address++) = ((value>>16)&255);			/* stash bits 16-23	*/
	*(address++) = ((value>>8)&255);			/* stash bits 8-15	*/
	*(address) = ((value)&255);				/* stash bits 0-7	*/
	return;
}



/*********************************************************************/
/*** GRAB_WORD(iff_pointer) ***/
/*********************************************************************/

short int	grabword(char *iff_pointer)

{
	return( (*(iff_pointer)<<8) + *(iff_pointer+1) );

}



/*********************************************************************/
/* STASH_ID(char *address, char *id_array) */
/*********************************************************************/

void		stash_id(char *address, char *id_array)

{

int			i;

	for (i=0; i<4; i++)
		{
		*(address+i) = *(id_array+i);			/* copy id_array */
		}

	return;
}




/*********************************************************************/
/*** CHECK_ID(iff_pointer,id_pointer) ***/
/*********************************************************************/


int			check_id(char *iff_pointer, char *id_array)

{

int			i;
int			error=0;


	for (i=0; i<4; i++)
		{
		if ( *(id_array+i) != *(iff_pointer+i) )
			{
			error=1;
			}
		}

	return(error);

}


/*********************************************************************/
/** FIND_ID(iff_pointer,id_array,search_size) **/
/*********************************************************************/

int			find_id(char *iff_pointer, char *id_array, int search_size)

{

int			flag;						/* FLAG VARIABLE */
int			offset = -1;					/* OFFSET */

	do
		{
		offset++;							/* increment offset */

		flag = ( check_id((iff_pointer+(offset*2)),id_array) ); /* look for ID */
		}

	while ( (flag == 1) && (offset != search_size) );	/* found id? searched? */

	offset *= 2;							/* offset *2 */

	if ( flag==1 )							/* Did we find ID? */
		{
		offset = -1;						/* ERROR - ID NOT FOUND */
		}

	return(offset);

}


/*********************************************************************/
/* find_length - Finds the length of a file */
/*********************************************************************/

long int		find_length(char filename[])

{

int			handle;
long int		filelen=-1;

	handle = open( filename, O_RDONLY | O_BINARY );
	if( handle != -1)
		{
		filelen = ( filelength(handle) );
		close ( handle );
		}
	return ( filelen );
}

/*********************************************************************/
/* save_file - Saves a file (filename,address,size) */
/*********************************************************************/


void		save_file(char filename[], char address[], int size)

{

int 		handle;
int			size_written=0;

	handle = open(filename,O_WRONLY|O_CREAT|O_TRUNC|O_BINARY, S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP);

	if (handle!=-1)
		{
		size_written=write(handle, address, size);

		if (size_written!=size)
			{
			printf("\nError writing file \"%s\" - Only wrote %d bytes\n",filename,size_written);
			}
		else
			{
			printf("\nSaved file \"%s\" (%d bytes)\n",filename,size_written);
			}

		close ( handle );
		}
	else
		{
		printf("Error opening file \"%s\" for save\n",filename);
		}

}

/*********************************************************************/
/* load_file - Loads a file (filename, address, max size) */
/*********************************************************************/


void		load_file(char filename[], char address[], int size)

{

int			handle;
int			size_read;

	if ((handle = open (filename,O_RDONLY|O_BINARY)) != -1)
		{
		size_read=read(handle,address,size);
		if (size_read==-1)
			{
			printf("Error reading file \"%s\"\n",filename);
			}
		else
			{
//			printf("Loaded file \"%s\" (%d bytes)\n",filename,size_read);
			}
		close ( handle );
		}
	else
		{
		printf("Error opening file \"%s\" for load\n",filename);
		}
}


/***************************************************************************/
/* Allocate_ram(size) - << just allocates ram and returns the pointer! */
/***************************************************************************/
/* Yo DEL! always prototype functions that return addresses..??! */


char *		allocate_ram( int size )
{

char 		*mem;

	mem = (char*)malloc( size );					/* allocate ram */

	if ( mem == NULL )							/* did we get it? */
		{
		printf("Failed to allocate $%0x bytes of RAM!\n",size);
		exit(0);
		}

	clearbuf(mem,size);							/* clear buffer */

	return( mem );								/* return ram address */

}


/*********************************************************************/
/** clearbuf(address,size) **/
/*********************************************************************/


void		clearbuf(char *address, int size)
{
int			i;


	for (i=0; i<size; i++)
		{
		*(address++) = 0;					/* fill buffer with 0's */
		}

	return;
}




/*************************/
/* Display picture matey */
/*************************/
/* Lovely! */
/* twatted code so it only displays TRUEWIDTH 11:04am 28/06/94 */



void	display_picture(char *rawbuffer, struct iffdat idat)

{

int		modestash;
char   		*screenptr;			/* screen pointer */


int		screen_extra=0;
int		bitmap_extra=0;

int		widthcount;
int		heightcount;
int		i;
int		hcnt;

int		widthdif;

	modestash = get_screen_mode();			/* stash old GFX mode */
	set_screen_mode(0x13);	  			/* MODE $13 for DEL! */

	set_palette(palbuffer,0,256);			/* Need a palette? */

	fill_screen(41);


	widthdif = (idat.width - idat.truewidth);	/* get width difference */
	bitmap_extra = widthdif;     			/* skip crap (semi-mask!) */
	widthcount = idat.truewidth;  			/* grab width */
	if (widthcount > 320 )	      			/* bigger than 320? */
		{
		bitmap_extra += (widthcount-320);  	/* calc bitmap_extra */
		widthcount = 320;		   	/* width is 320 max! */
		}
	if (widthcount < 320 )			   	/* less than 320? */
		{
		screen_extra = (320-widthcount);   	/* grab screen_extra */
		}


	heightcount = idat.height;		   	/* Grab height */
	if ( heightcount > 200 )		   	/* bigger than 200? */
		{
		heightcount = 200;		   	/* clip height to 200 */
		}


    screenptr = (char *)SCREEN_LIN_ADDR;		/* setup screen address */


	for (hcnt=0; hcnt<heightcount; hcnt++ )		/* do YLOOP */
		{

		for ( i=0; i<widthcount; i++ )		/* do XLOOP */
			{
			*(screenptr++) = *(rawbuffer++);	/* copy bitmap data */
			}

		screenptr += screen_extra;	  	/* add screen extra */
		rawbuffer += bitmap_extra;	  	/* add bitmap extra */

		}

	delay(4000);				  	/* WATCH THAT PICTURE! */

	set_screen_mode(modestash);		  	/* restore old GFX mode */

	return;
}


/**********************/
/**** SETMODE(num) ****/
/**********************/

void		set_screen_mode(int fanny)
{

union	REGS	r;
struct	SREGS	sr;


	r.x.eax = 0x40;
	sr.ds = r.x.eax;
	r.h.ah = 0x00;		 	/* Function number ($0=setmode) */
	r.h.al = fanny;			/* Mode number in AL */
	int386( 0x10, &r, &r );


	return;
}



/**********************/
/****** GETMODE! ******/
/**********************/

int		get_screen_mode(void)
{

union	REGS		r;

	r.h.ah = 0x0f;				/* Function number ($f=getmode) */
	int386( 0x10, &r, &r );



	return( (int)r.x.eax );
}




/************************************/
/* FILL_SCREEN (what a top routine) */
/************************************/

void		fill_screen(char val)

{
char		*ptr;
int			i;

    /* Set the pointer to the screen's linear address */

    ptr = (char *)SCREEN_LIN_ADDR;
    for( i = 0; i < SCREEN_SIZE; i++ )
		{
		*ptr++ = val;
   		}

}


/***************/
/* set_palette */
/***************/


void	set_palette(char *palptr, int firstreg, int numcols)

{

union	REGS  	r;


int   	i;
char	*ptr1;


	ptr1 = palptr;

	for (i=0; i<(numcols*3); i++)
		{
		*(ptr1) = ( *(ptr1)>>2 );	/* shift palette to use 6 bits */
		ptr1++;
		}

	r.h.ah = 0x10;		 		/* Function no ($10=palette cack) */
	r.h.al = 0x12;		 		/* Function no ($12=update cols) */
	r.x.ebx = firstreg;	 		/* first register */
	r.x.ecx = numcols;	 		/* number of colours */
	r.x.edx = (int)palptr;	 		/* DX points to palette */

	int386( 0x10, &r, &r );			/* Go Go BIOS! */

	return;
}









