#include "headers.h"
#include "chuck.h"
#include "shock.h"
#include "e_global.h"

static	int xadder[9] = {-256,0,256,-256,0,256,-256,0,256};
static	int zadder[9] = {-256,-256,-256,0,0,0,256,256,256};
int		newdir,blockhit;
short p1dest,p2dest;

int plyr_det()
{
	uchar *map_ptr;
	uchar *block[9];

	int tdx,tdz,dx,dz,obj_x,obj_z,i;
	int map_x,map_z;
	int tpx,tpz,ret;
	int rad;
	short	diff,objs_hit,map_val;
	short	pnothit;

	pnothit = 1;

	tpx = (int) (pl.x >> 16) & 0xffff;
	tpz = (int) (pl.z >> 16) & 0xffff;

	map_ptr = obj_map;
	map_ptr += (tpx >> 8) + (tpz & 0xff00);

	map_x = (tpx & 0xff00) + 0x80;
	map_z = (tpz & 0xff00) + 0x80;

	block[0] = (map_ptr-257);
	block[1] = (map_ptr-256);			//  -----
	block[2] = (map_ptr-255);			// |0|1|2|
	block[3] = (map_ptr-1);		  	// |-|-|-|
	block[4] = (map_ptr);			  	// |3|P|5|	Player is on block 4.
	block[5] = (map_ptr+1);		  	// |-|-|-|
	block[6] = (map_ptr+255);			// |6|7|8|
	block[7] = (map_ptr+256);			//  -----
	block[8] = (map_ptr+257);

	objs_hit = 0;

	for (i=0;i<9;i++)
	{
		if ((*block[i]) && det_tabs[region][((*block[i]) - 1) << 1])
		{
			rad = det_tabs[region][((*block[i]) - 1) << 1];
			obj_x = map_x + xadder[i];
			obj_z = map_z + zadder[i];

 			dx = tdx = tpx - obj_x;
 			dz = tdz = tpz - obj_z;

			rad *= rad;
			dx *= dx;
			dz *= dz;

			if ((dx+dz) < (rad + 0x20000))
			{
				map_val = det_tabs[region][(((*block[i]) - 1) << 1)+1];
				blockhit = i;

				p2dest = phd_atan((int)(tpx - obj_x),(int)(tpz - obj_z)) & 0x7ff;
				p1dest = (p2dest+0x400) & 0x7ff;

				if (pl.speed < 0)
				{
					if (p2dest >= 0 && p2dest < 0x400)
						newdir = (pl.dir+0x100) & 0x7ff;
					else
						newdir = (pl.dir-0x100) & 0x7ff;
				}
				else
				{
					if (p2dest >= 0 && p2dest < 0x400)
						newdir = (pl.dir-0x100) & 0x7ff;
					else
						newdir = (pl.dir+0x100) & 0x7ff;
			 	}

				diff = p2dest - pl.dir;

				if (diff > 1024)
					diff -= 2048;
				else if (diff < -1024)
					diff += 2048;

 				if (map_val & DET_SOLID)
 				{
					objs_hit++;
					if (abs(diff) > 128 && objs_hit <= 1)
					{
						ret = get_newdir(p1dest,newdir);

						if (ret == -1)
						{
							pl.x = pl.oldx;
 		 	 				pl.z = pl.oldz;

							if(pl.speed > (pl.top_speed >> 2))
							{
								tiltvel = pl.speed >> 3;
								objhitcnt = tiltvel >> 1;
							}
							pl.speed = 0;
							pl.dir = pl.angle;
						}
						else
						{
							if (check_next_pos())
							{
								pl.x = pl.oldx;
			 	 				pl.z = pl.oldz;

 								if(pl.speed > (pl.top_speed >> 2))
								{
									tiltvel = pl.speed >> 3;
									objhitcnt = tiltvel >> 1;
								}
								pl.speed = 0;
								pl.dir = pl.angle;
							}
							else
							{
								pl.x = pl.oldx;
			 	 				pl.z = pl.oldz;

 								pl.x += ((int)sintab[p1dest]<<5);
 								pl.z += ((int)sintab[p1dest+512]<<5);

								pl.dir = newdir;
 								pl.speed -= pl.speed>>3;

								diff = pl.angle - pl.dir;
								if (diff > 1024)
									diff -= 2048;
								else if (diff < -1024)
									diff += 2048;

								if(pl.speed>=0)
								{
									if (diff < -1)
									{
										pl.angle++;
									}
									else if (diff > 1)
									{
										pl.angle--;
									}
								}
								else
								{
									if (diff < -1)
									{
										pl.angle--;
									}
									else if (diff > 1)
									{
										pl.angle++;
									}
								}
								pl.angle&=0x7ff;
								pl.dir = pl.angle;
							}
						}
					}
					else
					{
						pl.x = pl.oldx;
						pl.z = pl.oldz;

						if(pl.speed > (pl.top_speed >> 2))
						{
							tiltvel = pl.speed >> 3;
							objhitcnt = tiltvel >> 1;
						}

						pl.speed = 0;
						pl.dir = pl.angle;
					}
					pnothit = 0;
 				}
				else if (map_val & DET_TANK_D)
 				{
					if (i==4)
					{
						if((pl.speed < (pl.top_speed >> 2)) || (map_val & DET_SHELL_D))
							pl.speed >>= 1;
						else
							pl.speed -= pl.speed >> 3; 	/* Reduce speed. */


						*block[i] = map_val >> 8;			/* Replace/remove object with whatever. */

						if ( map_val & DET_SHELL_D )  // play a crunch sound
						{
							play_crunch_sound();
						}
					}
 				}
				else if (map_val & DET_PICKUP)
 				{
					*block[i] = 0;	/* Replace block with whatever. */
					get_floor_pickup(i);
 				}
	 		}
		}
	}

	return (pnothit);
}

int get_newdir(short dest,short plyr2dir)
{
	int	diff;

	diff = pl.dir - plyr2dir;

	if (diff > 1024)
		diff -= 2048;
	else if (diff < -1024)
		diff += 2048;

	if ((diff > -1280 && diff < -768) || (diff > 768 && diff < 1280))
		return (-1);	/* Head on? */

	diff = pl.dir - dest;

	if (diff > 1024)
		diff -= 2048;
	else if (diff < -1024)
		diff += 2048;

	diff >>= 2;
	newdir = (pl.dir - diff) & 0x7ff;
	return(1);

}


int check_next_pos()
{
	uchar *map_ptr;
	uchar *block[9];

	int dx,dz,obj_x,obj_z,i;
	int map_x,map_z;
	int tpx,tpz;
	int rad,diff;
	short map_val;

 	tpx = ((pl.x + (sintab[p1dest]<<5)) >> 16) & 0xffff;
 	tpz = ((pl.z + (sintab[p1dest+512]<<5)) >> 16) & 0xffff;

	map_ptr = obj_map;
	map_ptr += (tpx >> 8) + (tpz & 0xff00);

	map_x = (tpx & 0xff00) + 0x80;
	map_z = (tpz & 0xff00) + 0x80;

	block[0] = (map_ptr-257);
	block[1] = (map_ptr-256);			//  -----
	block[2] = (map_ptr-255);			// |0|1|2|
	block[3] = (map_ptr-1);		  	// |-|-|-|
	block[4] = (map_ptr);			  	// |3|P|5|	Player is on block 4.
	block[5] = (map_ptr+1);		  	// |-|-|-|
	block[6] = (map_ptr+255);			// |6|7|8|
	block[7] = (map_ptr+256);			//  -----
	block[8] = (map_ptr+257);

	for (i=0;i<9;i++)
	{
		if ((*block[i]) && det_tabs[region][((*block[i]) - 1) << 1])
		{
			rad = det_tabs[region][((*block[i]) - 1) << 1];
			obj_x = map_x + xadder[i];
			obj_z = map_z + zadder[i];

 			dx = tpx - obj_x;
 			dz = tpz - obj_z;

			rad *= rad;
			dx *= dx;
			dz *= dz;

			if (((dx+dz) < (rad + 0x40000)) && i != blockhit)
			{
				map_val = det_tabs[region][(((*block[i]) - 1) << 1)+1];
 				if (map_val & DET_SOLID)
				{
					diff = pl.angle - (phd_atan((int)(tpx - obj_x),(int)(tpz - obj_z)) & 0x7ff);
					if (diff < -1024)
						diff += 2048;
					else if (diff > 1024)
						diff -= 2048;

					if (pl.speed < 0 && diff > 256 && diff < -256)
						return(1);
					else if (pl.speed > 0 && diff < 256 && diff > -256)
						return(1);
				}
			}
		}
	}
	return (0);
}


/**********************************************************/



void shell_det(SHELL_DATA *shellptr, int maxshells)
{
	int	i,ftype;

	for (i=0;i<maxshells;i++,shellptr++)
	{
		if (shellptr->fired)
		{
			if(glob1 = ftype = check_shell(shellptr->x,shellptr->y,shellptr->z, 0))	/* Check only block which shell is over. */
			{
				shellptr->fired = 0;
				trigger_explosion(AIR_EXPLOSION, (POSITION*)&(shellptr->x), NULL);
				if ( ftype>=9 )
				{
					trigger_fragments(12, (POSITION*)&(shellptr->x), TREE_FRAGMENTS);
					trigger_shroom((POSITION*)&(shellptr->x), SMALL_SHROOM);
				}
				else
					trigger_fragments(4, (POSITION*)&(shellptr->x), METAL_FRAGMENTS);

					shell_explosion_sound(shellptr->x, shellptr->z);

			}
		}
	}
}


/**********************************************************/


int check_shell(uint	x, int y, uint	z, int allblocks)
{
	uchar *map_ptr;
	uchar *block[9];
	int		floorObjType;
	int		dx,dz,i;
	int		obj_x,obj_z;
	int 	map_x,map_z;
	int 	tpx,tpz;
	int 	rad,radadd;
	short map_val;
	int		startblk, endblk;

	if ( y>=0 )
	{
		return (0);
	}

 	tpx = (x >> 16) & 0xffff;
 	tpz = (z >> 16) & 0xffff;

	map_ptr = obj_map;
	map_ptr += (tpx >> 8) + (tpz & 0xff00);

	map_x = (tpx & 0xff00) + 0x80;
	map_z = (tpz & 0xff00) + 0x80;

	block[0] = (map_ptr-257);
	block[1] = (map_ptr-256);			//  -----
	block[2] = (map_ptr-255);			// |0|1|2|
	block[3] = (map_ptr-1);		  	// |-|-|-|
	block[4] = (map_ptr);			  	// |3|P|5|	Player is on block 4.
	block[5] = (map_ptr+1);		  	// |-|-|-|
	block[6] = (map_ptr+255);			// |6|7|8|
	block[7] = (map_ptr+256);			//  -----
	block[8] = (map_ptr+257);


	if (allblocks)
	{
		startblk = 0;
		endblk = 9;
		radadd = 0x40000;
	}
	else
	{
		startblk = 4;
		endblk = 5;
		radadd = 0x900;
	}

	for (i=startblk;i<endblk;i++)
	{
		if ((*block[i]) && det_tabs[region][((*block[i]) - 1) << 1])
		{
			rad = det_tabs[region][((*block[i]) - 1) << 1];
			obj_x = map_x + xadder[i];
			obj_z = map_z + zadder[i];

 			dx = tpx - obj_x;
 			dz = tpz - obj_z;

			rad *= rad;
			dx *= dx;
			dz *= dz;

			if ((dx + dz) < (rad + radadd))
			{
				map_val = det_tabs[region][(((*block[i]) - 1) << 1)+1];
				if (allblocks) /* Checking for shell explosion. */
				{
					if (map_val & DET_EXP)
					{
						*block[i] = map_val >> 8;
						/* MANSOOR - TRIGGER EFFECT SPRITES HERE !!! */
					}
				}
				else
				{
					if (map_val & DET_SHELL_D)
					{
						floorObjType = *block[i];
						*block[i] = map_val >> 8;
						return(floorObjType);
						/* MANSOOR - TRIGGER EFFECT SPRITES HERE !!! */
					}
				}
			}
		}
	}
	return (0);
}
