#include <stdlib.h>
#include <stdio.h>
#include <memcheck.h>
#ifdef MEMCHK #include memcheck.h #endif

/**********************************************************************************
 *				Draw Wall Thingy With Optional Perspective
 *
 *********************************************************************************/

	int	polybuff[320][5];

#define WB_Y_TXT_ADD	0
#define	WB_X_TXT		1
#define	WB_Y_SCREEN		2
#define	WB_HEIGHT		3
#define WB_Y_TXT		4

#define	MIN_PERSPECTIVE	8						// Minimum width of at which perspective horizontal scaling is used

int		windowxmax=319;
int   windowymax=;


void	draw_wall( int x1, int x2,		// X1 and X2
				   int y1t, int y1b,				// y1 top/bottom
				   int y2t, int y2b,        // y2 top/bottom
				   char *txtptr,					 	// pointer to texture
				   int txtw, int txth,			// width,height
				   int perspec )


{
	int 	xScale,sx,n;
	int		cScale;	   									// Scaling factor for each vertical collumn
	int		cyt,yAddt,cyb,yAddb;				// Used to work out top and bottom of walls
	int		deltaX;			 								// difference in x (width)
	int		ttop,tbot,strtScale; 				// Actual top and bottom positions of wall collumn after clipping
	int 	ctop,cbot;									// Gradient of top intersection line
	int		vpx,dv,dadd,dvn;						// Vanishing point x
	int		Mp,Cp;

	int		perScale = 1;								// Flag indicating use of perspective horizontal scaling


	perScale = perspec;


	if ( x2<0 || x1>windowxmax )    	// if off screen exit
		return;

	if ( y1b<=y1t )										// Early-Out errors
		return;
	if ( y2b<=y2t )
		return;
	if ( x1>x2 )											// Not visible - facing other way
		return;

	deltaX = x2-x1+1; 			   				// Xdif+1
	cyt = (y1t<<16) + 0x8000;					// Fractional y pos for top of wall
	cyb = (y1b<<16) + 0x8000;					// Fractional y pos for Bottom of wall
	yAddt = ((y2t-y1t)<<16)/deltaX;		// make sure ydif is
	yAddb = ((y2b-y1b)<<16)/deltaX;

	txtw--;                           // dec texture width prevents overrun
	xScale = (txtw<<16)/deltaX;				// Normal linear horizontal step
 	if( deltaX < MIN_PERSPECTIVE )
		perScale=0;											// Use Linear scaling



	/*-----------------13/01/95 11:53-------------------
	 Horizontal perspective scaling calculations
	--------------------------------------------------*/

	if ( perScale )	{									// is perspective shite on...
		if( yAddt==yAddb ) 							// if gradients same then
			perScale=0;										// Use linear scaling.
		else
		{
			ctop = cyt - yAddt*x1;
			cbot = cyb - yAddb*x1;
			vpx=(cbot-ctop)/(yAddt-yAddb);// Vanishing point x;

			if ( vpx>x1 )
			{
				dv = vpx-x1;                // distance to vanishing point
				dvn = vpx-x2;               // nearer distance to v.point
				dadd = -1;                  // vanishing point to right
			}
			else
			{
				dv = x1-vpx;
				dvn = x2-vpx;
				dadd = 1;                   // vanishing point to left
			}
			Mp=(txtw*dv*dvn)/(dvn-dv);
			Cp=txtw-(Mp/dv);
			if( ( (Mp/dvn+Cp) !=0) || ( (Mp/dv+Cp) !=txtw) )
				perScale=0;
		}
	}                                	// End Perspective shite


	if ( x1>=0 )
	{         												// clip to left hand edge
		sx = 0;
	}
	else
	{
		cyt -= yAddt * x1;             	// modify top and bottom coords
		cyb -= yAddb * x1;
		sx  = -(xScale * x1);           // modify texture X pos
		dv -= dadd * x1;
		x1 = 0;                         // make Xleft=0
	}
	if ( x2>windowxmax ) 							// clip to right hand side of
		x2=windowxmax;                	// window

	deltaX = x2-x1;
	for ( n=0; n<=deltaX; n++,dv+=dadd)
	{
		tbot = (cyb>>16);
 		ttop = (cyt>>16);								// get the Y values...

		if( tbot-ttop )									// For some reason sometimes get a divide by zero error
 			cScale = (txth<<16)/(tbot-ttop);// Vertical scalling for current collumn
		else
			cScale=0x10000;								// (1<<16);

		strtScale=0;
		if( ttop<0 )
		{																// Clip top edge
			strtScale = -cScale*ttop; 		// Make note of start of source data in collumn if clipped
			ttop = 0;
		}

		if( tbot>windowymax )						// Clip bottom edge
			tbot = windowymax;						// make bottom End of Screen

		if ( tbot<0 )
			ttop = 0;											// if both off top make height neg.
		if ( ttop>windowymax ) 					// if both off bottom make height neg.
			tbot = 0;




		if ( perScale )
		{               								// Find Column using perspective
			sx = txtw-(Mp/dv+Cp);
			polybuff[n][WB_X_TXT] = (sx<<8) + (int)(txtptr);
		}
		else
		{                          			// Find Column without perspective
 			polybuff[n][WB_X_TXT] = ((sx>>16)<<8) + (int)(txtptr);
			sx += xScale;
		}

		polybuff[n][WB_Y_TXT_ADD] = cScale;// entry Scale
		polybuff[n][WB_Y_SCREEN] = ttop;   // Y top
		polybuff[n][WB_HEIGHT] = tbot-ttop;// height
		polybuff[n][WB_Y_TXT] = strtScale; // start point in texture<<16

		cyt += yAddt;
		cyb += yAddb;
	}
	_dump_wall_buffer( x1, deltaX, polybuff );// now output the wall
}





void	draw_location(int plx, int plz)
{
	int		n;
	int	tx,tz;
	static	char mclr=1;
	static	char mdirn=1;


	tx=abs(plx);
	tz=abs(plz);

	for(n=0;n<64;n++)
		{
		p1screen[n]=0;
		p1screen[n+63*320]=mclr;

		p1screen[n*320]=0;
		p1screen[n*320+63]=mclr;
		}

	p1screen[tx/2+(320*(tz/2))]=mclr;


	mclr+=mdirn;
	if (  mclr==14)
	{
		mclr=12;
		mdirn=(char)-1;
	}
	else
	if ( mclr==0 )
	{
		mclr=2;
		mdirn=1;
	}

}

