#include "headers.h"

#include "chuck.h"
#include "e_global.h"
#include "enemlogc.h"

#ifdef PC_VERSION
#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"
#endif




/*-----------------09/10/95 11:00-------------------
 This file contains the logic for both 911 air
 air support and 911 air rescue.
 Mansoor Nusrat.
--------------------------------------------------*/


/***********************************************************/
/** CONSTANTS AND DEFINITIONS **/


#define ASM_YVEL						0x20

#define MAX_ASM_TURN_RATE		0X20
#define MIN_ASM_TURN_RATE		2
#define ASM_SPEED						0Xc0


enum { INCOMING_911, LEAVING_911 };
enum { ASM_TRACKING, ASM_HEADLESS };

/***********************************************************/
/** module globals **/


static	ASM		refAsm;

static	uint		nineTargetx1;
static	uint		nineTargetz1;
static	uint		nineTargetx2;
static	uint		nineTargetz2;
static 	ushort	asmsLaunched;
static	ushort	nineMode;
ushort	asmsAlive = 0;

/***********************************************************/
/** prototypes **/

void	launch_asms(void);
void	upadate_asms(void);
void	check_asms(void);


/***********************************************************/

void	init_nine_air_support(void)
{
	/* */
	asmsAlive = FALSE;

	nineMode = INCOMING_911;

	/* Setup start coordinated of 911 */
	nine.x = (pl.x>0x80000000) ? 0 : (0xff<<24);
	nine.y = -0x800;
	nine.z = (pl.z>0x80000000) ? 0 : (0xff<<24);

	/* Setup 911 flight path */
	nine.angle = phd_atan((nine.x>>16) - (pl.x>>16), (nine.z>>16) - (pl.z>>16) ) &0x7ff;
	nine.speed = 0x4000;

	/** make all the ASM's available */
	memset(asms, 0, sizeof(ASMS)*MAX_ASMS);

	/* Flag to pull the 911 logic in */
	airSupportTriggerd = TRUE;

	game_data.airsupp = FALSE; // Note that you have used the air support
}


/***********************************************************/


void	nine_air_support(void)
{
	int	relx, relz, sqrtdist;

	switch ( nineMode )
	{
		case INCOMING_911:
			nine.angle = phd_atan((nine.x>>16) - (pl.x>>16), (nine.z>>16) - (pl.z>>16) ) &0x7ff;
			nine.x += (nine.speed>>7) * ((int)sintab[nine.angle]);
			nine.z += (nine.speed>>7) * ((int)sintab[nine.angle+512]);

			relx = abs(((uint)nine.x>>16) - ((uint)pl.x>>16));
			relz = abs(((uint)nine.z>>16) - ((uint)pl.z>>16));

			if ( relx > relz )
			{
				sqrtdist = relx + (relz>>1);
			}
			else
			{
				sqrtdist = relz + (relx>>1);
			}

			if ( sqrtdist <= 0x4000 )
			{
				start_message(NINE_MSG1);												/* 911 acknowledgement */
				launch_asms();
				nineMode=LEAVING_911;
			}
			break;


		case LEAVING_911:
			nine.x += (nine.speed>>7) * ((int)sintab[nine.angle]);
			nine.z += (nine.speed>>7) * ((int)sintab[nine.angle+512]);

			if ( nine.x>=0x7f000000 || nine.x<=0x1000000 )
			{
				if ( nine.z>=0x7f000000 || nine.z<=0x1000000 )
				{
					if ( !asmsAlive )
					{
						airSupportTriggerd = FALSE;
					}
				}
			}
			break;
	}


	if ( asmsLaunched )
	{
		update_asms();
	}

}



/***********************************************************/


void	launch_asms(void)
{
	int	n;
	TANK	*ttank;
	ASM	*casm;
	int	tx, tz, tx1, tx2, tz1, tz2;



	refAsm.x = refAsm.ox = nine.x;
	refAsm.z = refAsm.oz = nine.z;
	refAsm.y = nine.y;
	refAsm.angle = nine.angle;
	refAsm.fired = TRUE;

	casm = asms;

	asmsLaunched = TRUE;

	asmsAlive = FALSE;

	/** set up target zone **/

	tx = (uint)(pl.x>>16);
	tz = (uint)(pl.z>>16);

	tx2 = ( tx1 = tx - 0x2000 ) + 0x4000 ;
	tz2 = ( tz1 = tz - 0x2000 ) + 0x4000 ;

	if ( tx1 < 0 ) tx1 = 0;
	if ( tx2 > 0xffff ) tx2 = 0xffff;

	if ( tz1 < 0 ) tz1 = 0;
	if ( tz2 > 0xffff ) tz2 = 0xffff;

	nineTargetx1 = tx1<<16;
	nineTargetx2 = tx2<<16;

	nineTargetz1 = tz1<<16;
	nineTargetz2 = tz2<<16;


	/** check for enemy tanks in target area */

	for ( n=0, ttank=enemyTanks; n<MAX_ENEMY_TANKS; n++, ttank++ )
	{
		if ( asmsAlive >= MAX_ASMS )					/* Launhed all the asms */
		{
			return ;
		}

		if ( ttank->def &&
				 ttank->def != ALLIED_TRUCK &&
				 ttank->x>=nineTargetx1 &&
				 ttank->x<=nineTargetx2 &&
				 ttank->z>=nineTargetz1 &&
				 ttank->z<=nineTargetz2  )
		{
			*casm = refAsm;             					/* Found a viable target */
			casm->targetTank = ttank;             /* Note what the target is */
			casm->otx = ttank->x;									/* Record old positions of tanks */
			casm->otz = ttank->z;
			asmsAlive++;
			casm++;
		}
	}
}


/***********************************************************/


#define ASM_Y_VEL		64

void	update_asms(void)
{
	int	n;
	ASM	*casm;
	uint	ctx, ctz;
	int		cty;


	for ( n=0, casm=asms; n<MAX_ASMS; n++, casm++ )
	{
		if ( casm->fired )
		{
			casm->ox = casm->x;
			casm->oz = casm->z;

			// is target tank still alive ?
			if ( casm->targetTank->def && casm->targetTank->def!=REGENERATE_OBJECT )
			{
				// yes
				casm->otx = ctx = casm->targetTank->x;
				casm->otz = ctz = casm->targetTank->z;
				cty = -0x100; 	// aim for top of tanks
			}
			else
			{
				// no
				ctx = casm->otx;
				ctz = casm->otz;
				cty = 100;		// aim for below ground
			}

			/** update y position **/

			if ( casm->y < cty )
			{
				casm->y+=ASM_Y_VEL;
			}

			/** get angle to target **/

			casm->angle = phd_atan((casm->x>>16) - (ctx>>16), (casm->z>>16) - (ctz>>16) ) &0x7ff;

			/** update x and z positions **/

			casm->x += ASM_SPEED * ((int)sintab[casm->angle]);
			casm->z += ASM_SPEED * ((int)sintab[casm->angle+512]);

			if ( char_anim&4 )
			{
				trigger_fx_sprite(TRAIL_SMOKE, casm->ox, casm->y, casm->oz, FALSE, TRANSPARENT_SPRITE, LARGE_SPRITE, FALSE);
			}
		}
	}

	check_asms();

}






