#ifndef NEXTRA
#define NEXTRA

#include "headers.h"
#include "\tanx\list2.h"
#include "\tanx\objects.h"
#include "\tanx\setnet2.h"
#include "\tanx\playnet.h"
#include "shock.h"
#include "rshock.h"
#include "netinit.h"
#include "ncollect.h"
#include "damage.h"
#include "texto.h"
#include "teleport.h"
#include "iff.h"
#include "frontend.h"
#include "frglobs.h"
#include "frontdef.h"
#include "coolz.h"


/*This features all the shock-specific network code which
	isn't in shock.c*/


#define MAX_PLAYER_COLLECTABLES 5


#define HIT_DAMAGE 6
/**************************************************************/
/*DEBUGGING STUFF                                             */


/*************************************************************/


enum NMOB_TYPES {NMOB_EMPTY=0,NMOB_SHELL,NMOB_EXPLODE};


/*Used in object transmission to detect which type has been
	destroyed*/


enum DESTROY_TYPES
{
	DT_INDESTRUCTABLE= 1+255,
	DT_WALL,
	DT_FLOOR,
	DT_CRUSH,
	DT_FLOORCRUSH,
	DT_HUTANKDEATH
};


extern uint FULL_MONTY;


/*Nice li'l universal game loop count*/
extern uint GAME_LOOPS;


extern int FLOOR_DAMAGE_PAKS;
extern int WALLGROUP_DAMAGE_PAKS;
extern int UNIWALL_DAMAGE_PAKS;

/*Colour Cycling of diagnostic text*/
extern int add_txt_col;



/**************************************************************

								globals used in SHOCK.C

 **************************************************************/
#define NET_ARMOUR 24
#define NET_DAMAGE 6



enum STATPAK_TYPES
{
	FRIGID= 0,
	SP_CHLEV,
	SP_AUTOMESS,
	SP_ENDGAME
};


/*Transmitted tank status*/
enum TANK_STATUS
{
	NORMAL_JOE=0,
	EXPLODING,
	WORLDING,/*RECEIVING WORLD, or waiting to do so*/
	CHANGE_LEVEL,
	COOLING, /*In the COOL ZONE, ie BETWEEN LEVELS*/
};



enum TANK_G_STATUS
{
	SADSAP= 0,
	RADAR_INVISIBLE= 1<<0,
	INVISIBILITY= 1<<1,
	STINKING_O_SHIT= 1<<2
};


#define EXPLOSION_MAX 400


/*Parameters which define the death effect*/
typedef struct
{
	int TIME; /*Current stage of explosion, init= 0*/
	int DUR; /*No of frames of duration*/
	int DUR_UP; /*Duration of upwards leap*/
	int DUR_WHITE;/*Duration of whiteout*/
	int GRAVITY;

	int JUMP_HEIGHT;/*Negative y*/

	int IVEL;  /*Initial upwards velocity of tank*/
	int XVEL; /*X Velocity while exploding*/
	int ZVEL; /*Z velocity while exploding*/
	int SPIN; /*Rate of spin while exploding*/

	int YPOS;
	int XPOS;

}DEATH_PARAMS;


extern DEATH_PARAMS dth;



/*Player explosion data, not for transmission.
 	Used for comparison with transmitted version */
enum EXPLOSION_STATUS
{
	E_STABLE,
	E_EXPLODING=1<<0
};


/*determines if player quitting game entirely. 'game_on now
	represents player's temporary death*/
extern char net_on;


/*-----------------13/09/95 20:54-------------------
	BULLSHIT FUCKAHS fer GLOBAL HARMONY
--------------------------------------------------*/


/*************************************************************


							 		S T R U C T U R E S

 *************************************************************/
/*************************************************************/

/*I didn't wanna hafta do this- but here it is...*/

/*Now, at each call of COMMUNICATE, have to -
...copy local's TANK {x,y,z,angle} into NET_TANK  before send
...copy remote's NET_TANK {x,y,z,angle} into TANK after receive
*/

/*Have to ensure TANKS list AND NET_TANKS are consistent with
	playerList*/


extern int rec_destructos;
extern int send_destructos;;


/*TANK_HEADER is x,y,z,angle */
#define TANK_HSIZ 16
#define NTANK_MAINSZ (5*sizeof (int) +2*sizeof (char)) +sizeof (COMM_PART)

typedef struct
{
	/*The initial chunk of TANK data is for transmission*****/
	/*	ntanks[myID] is sent, ntanks[..otherplayers] are received*/

	/*Soor's Original stuff*/
	uint 		x;               		      /* Actual position of tank : X, */
	int		 	y;	 									    /* Y, */
	uint 		z;	 									  	/* Z. */

	uint		angle;						      	/* direction tank is trying to go in (view direction) */

	/*Network Stuff, but game-specific*/
	int marks;
	char killer; /*A -total- pain having to put this in*/

	char STATUS;		/*NORMAL, HIT, EXPLODING, etc */
	char G_STATUS;  /*More TRIVIAL effects*/

	/*Stuff only used by DM network software, non-game specific*/
	/*HIT is now in here*/
	COMM_PART comm;

	/*Spare shit, for mobs etc*/
	char buffer[300];


	/**************This final part isn't transmitted************/

	NET_INFO net;
	short E_STATUS; /*compared with STATUS*/


}NET_TANK;




/*Transmitted version of mob, specifically shells at t'mo*/
typedef struct
{
	uint x;
	int y;
	uint z;
	int ang;

	/*This can have values NMOB_SHELL, _EMPTY, _EXPLODE*/
	ushort def;

}NMOB;



/*************************************************************


				               G L O B A L S

 *************************************************************/
/*************************************************************/

extern int i,j;

/*Stuff for SHOCK.c */

extern int ALL_SHELLS;

/*pointers into enemyTank list*/
extern TANK *ENEMY_LIST_BASE, *FIRST_CPU_ENEMY;

/*Allow partitioning of enemy shell list*/
extern int MAX_CPU_ENEMY_SHELLS, MAX_ALL_ENEMY_SHELLS;


/*Players own tank entry points to pl*/
extern TANK *tanks[MAX_PLAYERS];

/*crack*/
extern NET_TANK *ntanks[MAX_PLAYERS];

extern NET_TANK nwtanks[MAX_PLAYERS];


/*tanks[] entries for remote players point here*/
extern TANK *human_enemy_tanks;



/*************************************************************
									     	SHOCK.C
 ************************************************************/

extern SHELL_DATA *enemyShellPart[MAX_PLAYERS];

#define POSSIBLE_START_POSITIONS 10

#define RADAR_TILE_RADIUS 60

extern char shellkillx,shellkillz;

extern int debounce;

/*************************************************************
								     	collide.c
 *************************************************************/

/*Is shell termination explosion to be transmitted?*/
extern char EXPLOSION_TRANSMITTER;


extern char HIT_BITS; /*player's hit_bits, one for each enemy*/

/*whether destruction info should be transmitted*/
extern char 		SEND_DESTRUCTION;
extern int			cWallType;
extern int			cDetectType;
extern int			cWallTexture;
extern int			cWallHeight;
extern int			cDestroyable;



/*YAWP! Forward decl for collide.c*/

/*This might turn out to be surplus to requirements*/
void detect_human_enemy_tankhit (void);

/*Destroy a group given info from remote tank*/
void	remote_destroy_group(WALL_DATA *grpWall);


void	damage_tank(TANK *damagedTank, int	damageVal);

void	destroy_texture(WALL_DATA *detwall);

void	crush_texture(WALL_DATA *cwall);


/**************************************************************
													weapons.c
 **************************************************************/

/*Index after most recent shellslot to be freed*/
extern char SHELLSLOT_SEARCH;




/**************************************************************
									n e t e x t r a . c
 **************************************************************/

/*transmitting destruction info */

void WALLDESTRUCTO_TO_OUTPUT_BUFFER (WALL_DATA *detwall);

void OBJECTDESTRUCTO_TO_OUTPUT_BUFFER (SHELL_DATA *shellptr);

void CRUSHDESTRUCTO_TO_OUTPUT_BUFFER (WALL_DATA *detwall);

void FLOORCRUSHDESTRUCTO_TO_OUTPUT_BUFFER (ushort block);

/*Jeeziz! Bodgy little way of saying one tank killed the others*/
void HUMANTANKDEATH_TO_OUTPUT_BUFFER (char murderer,char murderee);



/*Reads the REMOBJ info from the input buffer, converts it to
 the appropriate entity, and calls the approp. function to
 destroy the fackah! */

void destructo (OBJ_REM *tRemObj);

/*Blah, Blah, destroy object(if any) at position */
/*analagous to 'shell.det' in plyr_det.c */
/*check_shell does the object destruction*/

void	remote_destroy_block(POSITION	*explpos);



/*************************************************************


										F U N C T I O N S

 *************************************************************/
/*************************************************************/





/**************************************************************

										   MOVEANIM.C

 **************************************************************/

/*Sets up mobs used in network game */

void nv_setup_mobs (void);

/*Put Remote Human Players into the mob list*/

void get_human_enemy_tanks(void);




/**************************************************************

					   			 ENEMY SHELLS

 **************************************************************/


/*Puts local player's shell data into nMob format before
	transmission */
void shellsToNmobs (void);


/*Takes remote player's shell data from nMob format and places
	it in enemyShells list. */

void nMobsToShells (int plr);





/**************************************************************

													COLLIDE.C

 *************************************************************/


/*This might turn out to be surplus to requirements*/
void detect_human_enemy_tankhit (void);

/*MARK player shell in transmission buffer as EXPLODING */
void SHELL_EXPLODE_REMOTE (char i, short eType);


/**************************************************************

									      	 INITLEV.C

 *************************************************************/

#define NUMBER_OF_REGIONS 20

extern char regionList[NUMBER_OF_REGIONS][8];

extern int missionRegion[];






/**************************************************************

							    			UTILS.C

 *************************************************************/


void	draw_netgame_screen(void);


/**************************************************************

										 		DAMAGE.C

 *************************************************************/

int wallStatus (WALL_DATA *aWall);


//#define OSCREEN_SIZE 320*110
#define OSCREEN_SIZE 1
/*Holds dissolving screen*/
extern uchar oscreen [OSCREEN_SIZE];
extern int dissolveFrame;

void dissolve();
void dissolve2();

void fire_tank (void);


extern void MYGAME_CHANGES (void);


/**************************************************************

														SHOCK.C

 **************************************************************/

void NETWORK_DIAGNOSTICS (void);
extern char digit[20];
extern int target; /*The tank you've targetted*/
void	reset_message_status(void);
void net_main (void);

/**************************************************************

									W E A P O N S . C

 *************************************************************/

extern char NET_WEAPONS (TANK *tank);

void fire_shell (TANK *tank);


/**************************************************************

										U T I L S . C

 *************************************************************/

/*Update tank attributes based on pickups*/
void update_pickups(void);


/**************************************************************

												PLYR_DET.C


 *************************************************************/

int check_shell(uint	x, int y, uint	z, int allblocks);


/**************************************************************

												COOL ZONE

 *************************************************************/

extern char LEAVING_GAME;




/**************************************************************

										KILL FREQUENCY UPDATE

 *************************************************************/


#define KILL_FREQ_INTERVAL 3600

extern int KILL_FREQ_COUNT;
extern int KILL_FREQ_TOGGLE;
extern ushort RECORDED_MARKS[MAX_PLAYERS];


void RECORD_MARKS (void);

void KILL_FREQUENCY_UPDATE (void);



#endif




