#include "headers.h"

#include "shell.h"
#include "chuck.h"
#include "shock.h"
#include "e_global.h"


#ifdef MEMCHK
#include <memcheck.h>
#endif




uchar*	get_sprite_graphics_address(int sprnum, int netnum, uchar *gdata, short *netdata, short *sprwidth, short *sprheight, short *xoff, short *yoff);


#define 	NUM_SOLID_TEXTURES			52
#define 	NUM_RAGGED_TEXTURES			13
#define 	NUM_TRANSYM_TEXTURES		27
#define 	NUM_TRANASYM_TEXTURES		18
#define 	NUM_ANIMATING_TEXTURES	5


#define kB					*1024

extern SETUP	game_setup;



void mg_setup(void)
{
	int		i;
	char	*txtptr;
	char	*crptr;

	init_cheat_checks();

	p1screen=(uchar*)game_setup.scrn_ptr;    /* Pointer to screen */

	/*-----------------27/09/95 12:46-------------------
	Load in the text messages
	--------------------------------------------------*/

	if (waddStatus==build_wadds)
	{
		open_wad_file("basic.txt");
	}
	else
	if (waddStatus==load_wadds)
	{
		basic_wadd_pointer = open_wad_file("wadds\\basic.shk");
	}

	debug_msg("Starting mg_setup()");
	textfile = load_wad_file("text\\messages.txt", NULL);
	txtptr = strtok(textfile, " ,");

	debug_msg("Load in text");
	for ( i=0; i<MAX_MENU_TXT_MESSAGES; i++ ) /* Get a line at a time out of the text data */
	{
		messageStringPos[i][0] = atoi(txtptr);	/* Get x and y pos of the string */
		txtptr = strtok(NULL, " ,");
		messageStringPos[i][1] = atoi(txtptr);
		txtptr = strtok(NULL, "\n");
		messageStringList[i]=txtptr;						/* Get start of the string and store in the menu string table */
		crptr=strchr(messageStringList[i], 13); /* Replace carraige return characters with string terminators */
		if ( crptr!=NULL )
		{
			*crptr=0;
		}
		txtptr = strtok(NULL, ",\n");
	}

	for ( i=0; i<MAX_INGAME_MESSAGES; i++ )
	{
		ingameText[i] = txtptr;
		crptr=strchr(ingameText[i], 13); 				/* Replace carraige return characters with string terminators */
		if ( crptr!=NULL )
		{
			*crptr=0;
		}
		txtptr = strtok(NULL, "\n");
	}

	for ( i=0; i<MAX_CHARACTER_MESSAGES; i++ )/* Text of the in game character speech */
	{
		characterText[i] = txtptr;
		crptr=strchr(characterText[i], 13); 	 	/* Replace carraige return characters with string terminators */
		if ( crptr!=NULL )
		{
			*crptr=0;
		}
		txtptr = strtok(NULL, "\n");
	}
	debug_msg("Text loaded - whoopee shit");





	/*-----------------25/11/95 18:09-------------------
	 setup the option variables
	-----------------25/11/95 18:09-------------------*/
	debug_msg("Setting up options");
	optionSettings[SOUND_OPTION] = SoundIsDIGIEnabled();		/* sound option value */
	optionSettings[MUSIC_OPTION] = TRUE; 										// assume the cd is playing music in game
	optionSettings[SOUND_VOLUME_OPTION] = 32;								// mid value for the sound
	optionSettings[MUSIC_TRK_OPTION] = 2;										// the ingame music track
	optionSettings[SATURATION_OPTION] = 32;						// the original gamma values
	optionSettings[VALUE_OPTION] = 32;						// the original gamma values

	/*-----------------29/09/95 10:53-------------------
	 Load in the 'video' sprites
	--------------------------------------------------*/
debug_msg("Load in video sprites");
	video_graphics = load_wad_file("sgraphix\\kokpit\\video.pcd", NULL);
	video_net = (short*)load_wad_file("sgraphix\\kokpit\\video.net", NULL);


	/* Animating texture frame data */

debug_msg("Get ato data");
	animTxtrData=load_wad_file("sgraphix\\walls\\walls.ato", NULL); 		/* Load in the animating texture offsets - only the frame limit numbers are used */
	numAnims=(unsigned int)*(unsigned int*)animTxtrData;
	animTxtrOffs=animTxtrData+1;
	numAnimFrames=animTxtrOffs + numAnims;


debug_msg("allocate some arrays");
	/* Ex arrays */
	enemyTanks = (TANK*)get_mem(sizeof(TANK) * MAX_ENEMY_TANKS);

	gunempls = (GUN_EMPLACEMENT*)get_mem(sizeof(GUN_EMPLACEMENT) * MAX_GUN_EMPLS );

	gunboats = (GUN_BOAT*)get_mem(sizeof(GUN_BOAT) * MAX_GUN_BOATS);

	helicopters = (TANK*)get_mem(sizeof(TANK) * MAX_HELICOPTERS);

	hostages = (HOSTAGE*)get_mem(sizeof(HOSTAGE) * MAX_HOSTAGES);

	enemyTankCtrl = (ENEMY_TANK_CTRL*)get_mem(sizeof(ENEMY_TANK_CTRL) * MAX_ENEMY_TANKS);

	enemyHeliCtrl = (ENEMY_TANK_CTRL*)get_mem(sizeof(ENEMY_TANK_CTRL) * MAX_HELICOPTERS);

	gunboatCtrl = (ENEMY_TANK_CTRL*)get_mem(sizeof(ENEMY_TANK_CTRL) * MAX_CONVOY_BOATS);

	playerShells = (SHELL_DATA *)get_mem(sizeof(SHELL_DATA) * MAX_PLAYER_SHELLS);

	enemyShells = (SHELL_DATA*)get_mem(sizeof(SHELL_DATA) * MAX_ENEMY_SHELLS);

	pl_bullets = (struct bullets*)get_mem(sizeof(struct	bullets) * (MAX_PLAYER_SHELLS << 2));

	en_bullets = (struct bullets*)get_mem(sizeof(struct	bullets) * (MAX_ENEMY_SHELLS << 2));

	fxSprites = (FX_SPRITE*)get_mem( sizeof(FX_SPRITE) * MAX_FX_SPRITES);

	fragments = (FRAGMENT_DATA*)get_mem( sizeof(FRAGMENT_DATA) * MAX_FRAGMENTS);

	delayedFX= (DELAYED_FX*)get_mem( sizeof(DELAYED_FX) * MAX_DELAYED_FX_SLOTS);

	asms = (ASM*)get_mem( sizeof(ASM) * MAX_ASMS );

	ll = (LINKLIST*)get_mem( sizeof(LINKLIST) * 512 );

	mob = (MOBS*)get_mem( sizeof(MOBS) * 256 );

/****************/
debug_msg("Allocate some more arrays");

	animating_txtr_data=(ANIM_TXTR_DATA*)get_mem(10*sizeof(ANIM_TXTR_DATA));	/* Holds the current frame of each type of animating texture */

 	pdepths=(uchar *)get_mem(2kB);					/* Object depth cueing table (network tank dq table) */

//	net_info=(short *)get_mem(4kB);					/* Sprite net info for static floor objects */
//
//	graphics=(uchar *)get_mem(32kB);				/* Static floor object sprites. */

	draw_line_tb=(uchar *)get_mem(9kB);			/* Code buffers for expanding sprite routines */
	draw_line1=(uchar *)get_mem(9kB);				/* Code buffers for expanding sprite routines */
	draw_line2=(uchar *)get_mem(9kB);

	p2screen=(uchar*)get_mem(SCREEN_BUFFER_SIZE);

	yline_tab=(ushort *)get_mem(256*4);

	yoff_tab=(ulong *)get_mem(256*4);

	obrange=0x2000;

	tiny_font = current_font = load_wad_file("sgraphix\\data\\small.fon", NULL);
	medium_font = load_wad_file("sgraphix\\data\\medium.fon",NULL);

debug_msg("Load in the panel graphics");
	panel_display_graphics=load_wad_file("sgraphix\\kokpit\\panel.pcd", NULL);
	panel_display_net=load_wad_file("sgraphix\\kokpit\\panel.net", NULL);

	compass_data = get_sprite_graphics_address(COMPASS_DISPLAY, 0, panel_display_graphics, panel_display_net, NULL, NULL, NULL, NULL);
	radar_ring_data = get_sprite_graphics_address(RADAR_RINGS, 0, panel_display_graphics, panel_display_net, NULL, NULL, NULL, NULL);

	turret_angle_data = get_sprite_graphics_address(22, 0, panel_display_graphics, panel_display_net, NULL, NULL, NULL, NULL);

	cmprPanelTop = load_wad_file("sgraphix\\kokpit\\toppanel.cmp", NULL);
	cmprPanelBottom = load_wad_file("sgraphix\\kokpit\\botpanel.cmp", NULL);
	cmprTacmap = load_wad_file("sgraphix\\kokpit\\tacmap.cmp", NULL);


debug_msg("Load in the explosion sprites");
	/* Load in explosions and other fx sprites */
	fx_graphics	=	load_wad_file("sgraphix\\gobjects\\explode.pcd", NULL);
	fx_net_info	= load_wad_file("sgraphix\\gobjects\\explode.net",	NULL);

debug_msg("Initialise the net and pcd pointers");
	for ( i=0; i<MAX_ROTATING_OBJECTS; i++ )
	{
		mob_net_info[i]=NULL;
		mob_graphics[i]=NULL;
	}

debug_msg("Load in some more sprite files");
	/* Load in projectile graphix */
	mob_graphics[SHELL]=load_wad_file("sgraphix\\tanx\\shell.pcd", NULL);
	mob_net_info[SHELL]=load_wad_file("sgraphix\\tanx\\shell.net", NULL);

	mob_graphics[SAMS]=load_wad_file("sgraphix\\tanx\\sam.pcd",NULL);
	mob_net_info[SAMS]=load_wad_file("sgraphix\\tanx\\sam.net",NULL);

	mob_graphics[ASMS]=load_wad_file("sgraphix\\tanx\\asm.pcd",NULL);
	mob_net_info[ASMS]=load_wad_file("sgraphix\\tanx\\asm.net",NULL);


	on_off = 0;

	/* Flip and rotate translation table for floordraw */
	flip_lookup = load_wad_file("sgraphix\\data\\lookup.tab", NULL);



	/* Load in the wall collision and destruction information */
	wdetect_info[0].detectType = load_wad_file("sgraphix\\walls\\solid.cdt", NULL);
	wdetect_info[0].destructInfo = (DESTRUCT_INFO	*)((char*)(wdetect_info[0].detectType + NUM_SOLID_TEXTURES));
	wallHitPoints[0] = load_wad_file("data\\solid.hit", NULL);

	wdetect_info[1].detectType = load_wad_file("sgraphix\\walls\\ragged.cdt", NULL);
	wdetect_info[1].destructInfo = (DESTRUCT_INFO	*)((char*)(wdetect_info[1].detectType + NUM_RAGGED_TEXTURES));
	wallHitPoints[1] = load_wad_file("data\\ragged.hit", NULL);

	wdetect_info[2].detectType = load_wad_file("sgraphix\\walls\\transym.cdt", NULL);
	wdetect_info[2].destructInfo = (DESTRUCT_INFO	*)((char*)(wdetect_info[2].detectType + NUM_TRANSYM_TEXTURES));
	wallHitPoints[2] = load_wad_file("data\\transym.hit", NULL);

	wdetect_info[3].detectType = load_wad_file("sgraphix\\walls\\tranasym.cdt", NULL);
	wdetect_info[3].destructInfo = (DESTRUCT_INFO	*)((char*)(wdetect_info[3].detectType + NUM_TRANASYM_TEXTURES));
	wallHitPoints[3] = load_wad_file("data\\tranasym.hit", NULL);

	wdetect_info[4].detectType = load_wad_file("sgraphix\\walls\\animate.cdt", NULL);
	wdetect_info[4].destructInfo = (DESTRUCT_INFO	*)((char*)(wdetect_info[4].detectType + NUM_ANIMATING_TEXTURES));
	wallHitPoints[4] = load_wad_file("data\\animate.hit", NULL);

debug_msg("Load in tacmap palette");
	/** Load in the tactical map palette */
	tacpal = load_wad_file("sgraphix\\kokpit\\tacmap.pal", NULL);
	for ( i=0; i<768; i++ ) 	/* Needs shifting down */
	{
		tacpal[i]>>=2;
	}
	tacpal[0] = tacpal[1] = tacpal[2] = 0;

debug_msg("Set up the tank characteristics");
	/* Tank specification information */
 	td[PLAYER_TANK].pre_accel = 192;
	td[PLAYER_TANK].accelr = 64;
	td[PLAYER_TANK].accelc = 4;
	td[PLAYER_TANK].maxturn = 28;
	td[PLAYER_TANK].top_speed = 0x600;
	td[PLAYER_TANK].top_brake = 24;
	td[PLAYER_TANK].trak_grip = 72;

 	td[ENEMY_TANK].pre_accel = 192;
 	td[ENEMY_TANK].accelr = 64;
 	td[ENEMY_TANK].accelc = 4;
 	td[ENEMY_TANK].maxturn = 28;		 				/* Player tank setup. */
 	td[ENEMY_TANK].top_speed = 0x600;
 	td[ENEMY_TANK].top_brake = 24;
 	td[ENEMY_TANK].trak_grip = 72;

 	td[AMOURED_FIGHTER].pre_accel = 112;		/* The bigger the number the slower the acceleration to 1/4 speed. */
 	td[AMOURED_FIGHTER].accelr = 32; 				/* The bigger the number the slower the acceleration from 1/4 to full speed. */
 	td[AMOURED_FIGHTER].accelc = 20;				/* The bigger the number the quicker the acceleration. */
 	td[AMOURED_FIGHTER].maxturn = 40;				/* Bigger = quicker. */
 	td[AMOURED_FIGHTER].top_speed = 0x780;
 	td[AMOURED_FIGHTER].top_brake = 40;
 	td[AMOURED_FIGHTER].trak_grip = 104;

 	td[BATTLE_TANK].pre_accel = 200;
  td[BATTLE_TANK].accelr = 64;
 	td[BATTLE_TANK].accelc = 2;
 	td[BATTLE_TANK].maxturn = 24;
 	td[BATTLE_TANK].top_speed = 0X5e0;
 	td[BATTLE_TANK].top_brake = 32;
 	td[BATTLE_TANK].trak_grip = 72;

 	td[ENEMY_APC].pre_accel = 192;
  td[ENEMY_APC].accelr = 176;
 	td[ENEMY_APC].accelc = 3;
 	td[ENEMY_APC].maxturn = 28;
 	td[ENEMY_APC].top_speed = 0X500;
 	td[ENEMY_APC].top_brake = 64;
 	td[ENEMY_APC].trak_grip = 72;

 	td[ALLIED_TRUCK].pre_accel = 192;
 	td[ALLIED_TRUCK].accelr = 64;
 	td[ALLIED_TRUCK].accelc = 4;
 	td[ALLIED_TRUCK].maxturn = 28;		 			/* Player tank setup. */
 	td[ALLIED_TRUCK].top_speed = 0x600;
 	td[ALLIED_TRUCK].top_brake = 24;
 	td[ALLIED_TRUCK].trak_grip = 72;

 	td[ENEMY_TRUCK].pre_accel = 192;
 	td[ENEMY_TRUCK].accelr = 64;
 	td[ENEMY_TRUCK].accelc = 4;
 	td[ENEMY_TRUCK].maxturn = 28;		 				/* Player tank setup. */
 	td[ENEMY_TRUCK].top_speed = 0x600;
 	td[ENEMY_TRUCK].top_brake = 24;
 	td[ENEMY_TRUCK].trak_grip = 72;

/* Engine upgrades. */
	eu[0].accelr 		= 0;
	eu[0].accelc 		= 0;
	eu[0].maxturn 	= 0;
	eu[0].top_speed = 0;
	eu[0].pre_accel = 0;

	eu[1].accelr 		= -8;
	eu[1].accelc 		= 1;
	eu[1].maxturn 	= -1;
	eu[1].top_speed = 64;
	eu[1].pre_accel = 16;

	eu[2].accelr 		= -16;
	eu[2].accelc 		= 2;
	eu[2].maxturn 	= -2;
	eu[2].top_speed = 128;
	eu[2].pre_accel = 32;

 	eu[3].accelr 		= -28;
	eu[3].accelc 		= 3;
	eu[3].maxturn 	= -3;
	eu[3].top_speed = 256;
	eu[3].pre_accel = 48;

 	eu[4].accelr 		= -44;
	eu[4].accelc 		= 4;
	eu[4].maxturn 	= -4;
	eu[4].top_speed = 512;
	eu[4].pre_accel = 64;

	/* Track upgrades. */
	tu[0].trak_grip = 0;
	tu[0].pre_accel = 0;
	tu[0].maxturn 	= 0;
	tu[0].top_speed = 0;
	tu[0].top_brake = 0;

	tu[1].trak_grip = 8;
	tu[1].pre_accel = -16;
	tu[1].maxturn 	= 1;
	tu[1].top_speed = -32;
	tu[1].top_brake = 1;

	tu[2].trak_grip = 16;
	tu[2].pre_accel = -32;
	tu[2].maxturn 	= 2;
	tu[2].top_speed = -48;
	tu[2].top_brake = 2;

 	tu[3].trak_grip = 32;
	tu[3].pre_accel = -64;
	tu[3].maxturn 	= 4;
	tu[3].top_speed = -64;
	tu[3].top_brake = 4;

 	tu[4].trak_grip = 56;
	tu[4].pre_accel = -128;
	tu[4].maxturn 	= 8;
	tu[4].top_speed = -96;
	tu[4].top_brake = 8;

	close_wad_file();

	debug_msg("mg_setup done");
}





