#include "headers.h"
#include "chuck.h"
#include "walldraw.h"
#include "e_global.h"
#include "rshock.h"
#include "shock.h"

#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"

#include "enemlogc.h"

#define MySoundPlaySample(a,b,c,d) SoundPlaySample(a,b,c,d);soundPitchUsed=c
extern 	int	soundPitchUsed;


/*************************************************************************/

/*-----------------29/09/95 11:02-------------------
 The in game video message variables
 --------------------------------------------------*/


#define CHARACTER_MESSAGE_LENGTH	20

#define MESSAGE_QUEUE_LENGTH 	16
#define NINE_PITCH						26
#define DG_PITCH							26
#define EARSHOT_PITCH					26
#define DTOUR_PITCH						66
#define CHARACTER_VOLUME			0X5000

short	messagePlaying=FALSE;
short	messageFrame=0;
KOKPIT_MESSAGE	*currentMessage;
dword speechSampleHandle;
short	speechPlaying=FALSE;
short	messageLength;



KOKPIT_MESSAGE	kokpitMessageList[MAX_CHARACTER_MESSAGES] =
{
	VIDEO_MESSAGE, NINE_SEQUENCE, NINE_SPCH1, LOW_PRIORITY, NINE_PITCH, 0,
	VIDEO_MESSAGE, NINE_SEQUENCE, NINE_SPCH2, LOW_PRIORITY,	NINE_PITCH, 1,
	VIDEO_MESSAGE, NINE_SEQUENCE, NINE_SPCH1, LOW_PRIORITY,	NINE_PITCH, 2,				// DECKED
	VIDEO_MESSAGE, NINE_SEQUENCE, NINE_SPCH2, LOW_PRIORITY, NINE_PITCH, 3,        // DECKED

	SPEECH_ONLY_MESSAGE, 0, DT_SPCH1, HIGH_PRIORITY, DTOUR_PITCH, 4,
	SPEECH_ONLY_MESSAGE, 0, DT_SPCH2, HIGH_PRIORITY, DTOUR_PITCH, 5,
	SPEECH_ONLY_MESSAGE, 0, DT_SPCH3, HIGH_PRIORITY, DTOUR_PITCH, 6,
	SPEECH_ONLY_MESSAGE, 0, DT_SPCH4, HIGH_PRIORITY, DTOUR_PITCH, 7,
	SPEECH_ONLY_MESSAGE, 0, DT_SPCH5, HIGH_PRIORITY, DTOUR_PITCH, 8,
	SPEECH_ONLY_MESSAGE, 0, DT_SPCH6, HIGH_PRIORITY, DTOUR_PITCH, 9,
	SPEECH_ONLY_MESSAGE, 0, DT_SPCH7, HIGH_PRIORITY, DTOUR_PITCH, 10,
	SPEECH_ONLY_MESSAGE, 0, DT_SPCH7, HIGH_PRIORITY, DTOUR_PITCH, 10,

	VIDEO_MESSAGE, EARSHOT_SEQUENCE, ERSHOT_SPCH1, LOW_PRIORITY, EARSHOT_PITCH, 12,
	VIDEO_MESSAGE, EARSHOT_SEQUENCE, ERSHOT_SPCH2, LOW_PRIORITY, EARSHOT_PITCH, 13,
	VIDEO_MESSAGE, EARSHOT_SEQUENCE, ERSHOT_SPCH3, LOW_PRIORITY, EARSHOT_PITCH, 14,
	VIDEO_MESSAGE, EARSHOT_SEQUENCE, ERSHOT_SPCH4, MEDIUM_PRIORITY, EARSHOT_PITCH, 15,
	VIDEO_MESSAGE, EARSHOT_SEQUENCE, ERSHOT_SPCH4, MEDIUM_PRIORITY, EARSHOT_PITCH, 16,

//	VIDEO_MESSAGE, DOGTAG_SEQUENCE, DG_SPCH1, HIGH_PRIORITY, DG_PITCH, 17,
	VIDEO_MESSAGE, DOGTAG_SEQUENCE, DG_SPCH2, HIGH_PRIORITY, DG_PITCH, 17,
	VIDEO_MESSAGE, DOGTAG_SEQUENCE, DG_SPCH2, HIGH_PRIORITY, DG_PITCH, 18,
};



uchar	canPlayMessage[MAX_CHARACTER_MESSAGES] =
{
	TRUE,
	TRUE,
	TRUE,
	TRUE,

	TRUE,
	TRUE,
	TRUE,
	TRUE,
	TRUE,
	TRUE,
	TRUE,
	TRUE,

	TRUE,
	TRUE,
	TRUE,
	TRUE,
	TRUE,

	TRUE,
	TRUE
};



uchar	messageLengths[] =
{
	90,  		//		0
	107,		//    1
	159,		//    2
	219,		//    3

	219,		//    4
	72,			//    5
	105,		//    6
	102,		//    7
	93,     //    8
	117,    //    9
	106,    //    10
	63,     //    11

	97,     //    12
	107,    //    13
	124,    //    14
	122,    //    15
	176,    //    16

	254,   	//    17
	254    	//    18

};


void	reset_message_status(void)
{
	memset(canPlayMessage, 1, MAX_CHARACTER_MESSAGES);

	messageAnimCounter = 0;
	messagePlaying = speechPlaying = FALSE;
}



int	start_message(int	msgId)
{
	KOKPIT_MESSAGE *newMessage;

	newMessage = kokpitMessageList+msgId;

	messageLength=messageLengths[msgId];

	if ( !canPlayMessage[msgId] )
	{
		return (FALSE);
	}
	else
	{
		canPlayMessage[msgId]=FALSE;
	}

	if ( messagePlaying )
	{
		if ( newMessage->priority < currentMessage->priority )
		{
			return (FALSE);			/* Message not played */
		}
		else
		if ( (newMessage->priority >= currentMessage->priority) && speechPlaying )
		{
			/* Have to stop the previous message sample */
			SoundStopSample(speechSampleHandle);
			speechPlaying = FALSE;
		}
	}

	/* Start off the new message */
	messagePlaying = TRUE;
	messageFrame = 0;
	currentMessage = kokpitMessageList + msgId;
	speechPlaying=FALSE;

	return (TRUE);
}


/*************************************************************************/


void	update_message_window(void)
{
  int objtxtx, objtxty;

  objtxtx = 27;
  objtxty = 168;

 	scr_ptr = p1screen;


	if ( !mapmode )
	{
		_clear_block(objtxtx, objtxty, 64, 24);
	}

	/* If no video message is being then display the current objective stats */

  if ( ((!messagePlaying)||(messagePlaying && currentMessage->msgType!=VIDEO_MESSAGE)) && !mapmode)
  {
  	txt_print_colr = P_GREEN3;

    	switch(objectiveType)
    	{
    		case DESTROY_ALL_ENEMIES_OBJECTIVE:
    			_print_string(objtxtx, objtxty, ingameText[DESTROY_HOSTILES_TXT], SINGLE_COLOURED_PRINT);
  				objtxty+=8;
    			if ( numObjectiveEnemies )
    			{
 	  				sprintf(gentempString,"%s%02d", ingameText[TARGETS_LEFT_TXT] ,numObjectiveEnemies&63);
    				_print_string(objtxtx,objtxty, gentempString, SINGLE_COLOURED_PRINT);
    			}
    			else
    				_print_string(objtxtx,objtxty,ingameText[RENDEZVOUS_MSG_TXT], SINGLE_COLOURED_PRINT);
    			break;


    		case DESTROY_BUILDINGS_OBJECTIVE:
    			_print_string(objtxtx, objtxty, ingameText[DESTROY_COMPOUNDS_TXT1], SINGLE_COLOURED_PRINT);
  				objtxty+=8;
    			if ( numObjectiveBuildingsLeft )
    			{
    				sprintf(gentempString,"%s%02d", ingameText[TARGETS_LEFT_TXT],numObjectiveBuildingsLeft);
    				_print_string(objtxtx,objtxty,gentempString, SINGLE_COLOURED_PRINT);
    			}
    			else
    				_print_string(objtxtx,objtxty, ingameText[RENDEZVOUS_MSG_TXT], SINGLE_COLOURED_PRINT);
    			break;


    		case RESCUE_HOSTAGE_OBJECTIVE:
    			_print_string(objtxtx, objtxty, ingameText[HOSTAGE_RESCUE_TXT], SINGLE_COLOURED_PRINT);
  				objtxty+=8;
    			if ( numHostagesLeft )
    			{
    				sprintf(gentempString,"%s%02d", ingameText[HOSTAGEES_LEFT_TXT], numHostagesLeft);
    				_print_string(objtxtx,objtxty,gentempString, SINGLE_COLOURED_PRINT);
    			}
    			else
    				_print_string(objtxtx,objtxty,ingameText[RENDEZVOUS_MSG_TXT], SINGLE_COLOURED_PRINT);
    			break;


    		case DESTROY_CONVOY_OBJECTIVE:
    			_print_string(objtxtx, objtxty, ingameText[DESTROY_CONVOY_TXT], SINGLE_COLOURED_PRINT);
  				objtxty+=8;
    			if ( totalConvoyMembers==0 )
    			{
    				_print_string(objtxtx,objtxty, ingameText[RENDEZVOUS_MSG_TXT], SINGLE_COLOURED_PRINT);
    			}
					else
					{
						sprintf(gentempString, "%s%02d", ingameText[TARGETS_LEFT_TXT], totalConvoyMembers);
    				_print_string(objtxtx, objtxty, gentempString, SINGLE_COLOURED_PRINT);
					}

    			break;


    		case PROTECT_CONVOY_OBJECTIVE:
    			_print_string(objtxtx, objtxty, ingameText[PROTECT_CONVOY_TXT], SINGLE_COLOURED_PRINT);
    			break;


			}
  }


	/* Display video part of message */
	if ( messagePlaying && currentMessage->msgType==VIDEO_MESSAGE )
	{
		if ( !mapmode )
		{
			put_images(objtxtx,	objtxty, (currentMessage->videoSequence*VIDEO_SEQUENCE_FRAMES)+messageFrame, (uchar*)video_graphics, (uchar*)video_net );
		}

		if ( messageAnimCounter>4 )
		{
			messageAnimCounter=0;

			messageFrame++;
			if ( messageFrame>=VIDEO_SEQUENCE_FRAMES )
			{
				/* Start off the speech when the character is facing you */

				if ( !speechPlaying )
				{
					speechSampleHandle = MySoundPlaySample(currentMessage->speechSequence,	set_actual_volume(CHARACTER_VOLUME), currentMessage->speechPitch,	SOUND_CENTRE);
					speechPlaying = TRUE;
				}

				messageFrame=VIDEO_SEQUENCE_FRAMES-2;
			}
		}
	}

	if ( SoundIsDIGIEnabled() )
	{
		/* Check if speech part of message is still playing */
		if ( messagePlaying && speechPlaying && !SoundSampleIsPlaying(speechSampleHandle) )
		{
			messagePlaying=FALSE;
			speechPlaying=FALSE;
			update_available_messages(currentMessage->messageText);
		}
	}
	else
	{
		/* check if message has reached end according to timer */
		if ( messagePlaying && speechPlaying && !messageLength )
		{
			messagePlaying=FALSE;
			speechPlaying=FALSE;
			update_available_messages(currentMessage->messageText);
		}
	}

	/*Start off the speech if a speech only message */
	if ( messagePlaying && currentMessage->msgType==SPEECH_ONLY_MESSAGE && !speechPlaying )
	{
		speechSampleHandle = MySoundPlaySample(currentMessage->speechSequence,	set_actual_volume(CHARACTER_VOLUME), currentMessage->speechPitch,	SOUND_CENTRE);
		speechPlaying = TRUE;
	}

}




void	update_available_messages(int	msgid)
{
	switch ( msgid )
	{
		case EAR_MSG1:
			canPlayMessage[EAR_MSG2]=canPlayMessage[EAR_MSG3]=TRUE;
			break;

		case EAR_MSG2:
			canPlayMessage[EAR_MSG3]=canPlayMessage[EAR_MSG1]=TRUE;
			break;

		case EAR_MSG3:
			canPlayMessage[EAR_MSG2]=canPlayMessage[EAR_MSG1]=TRUE;
			break;

		case DTOUR_MSG1:
			canPlayMessage[DTOUR_MSG2]=canPlayMessage[DTOUR_MSG3]=TRUE;
			canPlayMessage[DTOUR_MSG4+rand()%3]=TRUE;
			break;

		case DTOUR_MSG2:
			canPlayMessage[DTOUR_MSG3]=TRUE;
			canPlayMessage[DTOUR_MSG4+rand()%3]=TRUE;
			break;

		case DTOUR_MSG3:
			canPlayMessage[DTOUR_MSG1]=TRUE;
			canPlayMessage[DTOUR_MSG4+rand()%3]=TRUE;
			break;

		case DTOUR_MSG4:
			canPlayMessage[DTOUR_MSG5]=TRUE;
			canPlayMessage[DTOUR_MSG1+rand()%3]=TRUE;
			break;

		case DTOUR_MSG5:
			canPlayMessage[DTOUR_MSG6]=TRUE;
			canPlayMessage[DTOUR_MSG1+rand()%3]=TRUE;
			break;

		case DTOUR_MSG6:
			canPlayMessage[DTOUR_MSG4]=TRUE;
			canPlayMessage[DTOUR_MSG1+rand()%3]=TRUE;
			break;

		case DTOUR_MSG7:
			canPlayMessage[DTOUR_MSG8]=TRUE;
			break;

		case DTOUR_MSG8:
			canPlayMessage[DTOUR_MSG7]=TRUE;
			break;

	}
}
