#include "headers.h"

#include "shell.h"
#include "chuck.h"
#include "shock.h"
#include "e_global.h"
#include "enemlogc.h"

#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"

#ifdef MEMCHK
#include <memcheck.h>
#endif




/**************************************************************/
// external declarations

extern	int		showEnemyStats;
extern	int		currentEnemyStats;



extern uchar	overrideDevice;
extern	int		normalCD;
extern 	FILE 	*targetBuildings;
extern	FILE	*targetBuildings;
extern	int		saveBuildingInfo;
extern 	char	destroyedBuildingstring[];
extern 	int	 	varalt;
extern 	char	msgStr[256];
extern	int		collisionsOn;
extern	int		forcedgame;
extern	char	ignoreHits;




/**************************************************************/
/* Constants and definitions */

#define 	TANK_BRAKE_RATE		0x20
#define 	MAX_TRAK_GRIP			0
#define 	MIN_TRAK_GRIP			8

#define 	ENEMY_TANK_ARMOUR_LEVEL			0x2ff
#define 	BATTLE_TANK_ARMOUR_LEVEL		0X5ff
#define 	AFV_ARMOUR_LEVEL						0Xff
#define 	APC_ARMOUR_LEVEL						0xff
#define 	TRUCK_ARMOUR_LEVEL					0x80

#define 	MAX_TREE_TEXTURES							8
#define 	TRANSPARENT_ASYMETRICAL_WALL	3

enum { REGN_A_CLEAR=0, REGN_A_OVERCAST, REGN_A_STORMY, REGN_A_NIGHT,
			 REGN_C_CLEAR, REGN_C_OVERCAST, REGN_C_STORMY,
			 REGN_D1_CLEAR, REGN_D2_CLEAR,
			 REGN_D1_OVERCAST, REGN_D2_OVERCAST,
			 REGN_D1_STORMY, REGN_D2_STORMY,
			 REGN_D_NIGHT, REGN_D_FOG,
			 REGN_E_CLEAR,
			 REGN_F_CLEAR,
			 REGN_F_OVERCAST,
			 REGN_F1_STORMY,
			 REGN_F2_SANDSTORM };

enum { REGN_A_SPR=0, REGN_C_SPR, REGN_D1_SPR, REGN_D2_SPR, REGN_E_SPR, REGN_F_SPR };

/**************************************************************/
/* Extern declarations */


/**************************************************************/
/* Globals for this file */



static 	int i;


int	missionNumber;


int	missionRegion[MAX_MISSIONS] =
	{
		REGN_A_CLEAR,						// 0 - COVER DISK MISSION
		REGN_D1_CLEAR,					// 1
		REGN_E_CLEAR,           // 2
		REGN_C_CLEAR,           // 3
		REGN_A_NIGHT,           // 4
		REGN_A_OVERCAST,        // 5
		REGN_E_CLEAR,           // 6
		REGN_E_CLEAR,           // 7
		REGN_C_OVERCAST,        // 8
		REGN_A_NIGHT,           // 9
		REGN_A_CLEAR,           // 10
		REGN_D_FOG,             // 11
		REGN_A_CLEAR,           // 12
		REGN_A_CLEAR,           // 13
		REGN_A_CLEAR,           // 14
		REGN_C_STORMY,          // 15
		REGN_C_OVERCAST,        // 16
		REGN_F2_SANDSTORM,      // 17
		REGN_F_CLEAR,           // 18
		REGN_F1_STORMY,         // 19
		REGN_D2_OVERCAST,       // 20
		REGN_D2_STORMY,         // 21
		REGN_D_NIGHT,           // 22
		REGN_F_CLEAR,           // 23
		REGN_F2_SANDSTORM,      // 24
		REGN_F_OVERCAST         // 25
	};




char	regionList[NUMBER_OF_REGIONS][8] =
	{
		"AC",       // 0
		"AO",       // 1
		"AS",       // 2
		"AN",				// 3
		"CC",       // 4
		"CO",       // 5
		"CS",       // 6
		"DC1",      // 7
		"DC2",      // 8
		"DO1",      // 9
		"DO2",      // 10
		"DS1",      // 11
		"DS2",      // 12
		"DN",       // 13
		"DF",       // 14
		"EC",       // 15
		"FC",       // 16
		"FO",       // 17
		"FS1",      // 18
		"FS2",			// 19
	};




enum	{ SPR_REGN_A, SPR_REGN_C, SPR_REGN_D1, SPR_REGN_D2, SPR_REGN_E, SPR_REGN_F };


uchar	regionNumber[] =
{
	SPR_REGN_A, 	// 0 - COVER DISK MISSION
	SPR_REGN_D1, 	// 1
	SPR_REGN_E,   // 2
	SPR_REGN_C,   // 3
	SPR_REGN_A,   // 4
	SPR_REGN_A,   // 5
	SPR_REGN_E,   // 6
	SPR_REGN_E,   // 7
	SPR_REGN_C,   // 8
	SPR_REGN_A,   // 9
	SPR_REGN_A,   // 10
	SPR_REGN_D1,  // 11
	SPR_REGN_A,   // 12
	SPR_REGN_A,   // 13
	SPR_REGN_A,   // 14
	SPR_REGN_C,   // 15
	SPR_REGN_C,   // 16
	SPR_REGN_F,   // 17
	SPR_REGN_F,   // 18
	SPR_REGN_F,   // 19
	SPR_REGN_D2,  // 20
	SPR_REGN_D2,  // 21
	SPR_REGN_D2,  // 22
	SPR_REGN_F,   // 23
	SPR_REGN_F,   // 24
	SPR_REGN_F    // 25
};


char	spriteRegionList[NUMBER_OF_REGIONS][8] =
{
	"SPRS_A",
	"SPRS_A",
	"SPRS_A",
	"SPRS_A",
	"SPRS_C",
	"SPRS_C",
	"SPRS_C",
	"SPRS_D1",
	"SPRS_D2",
	"SPRS_D1",
	"SPRS_D2",
	"SPRS_D1",
	"SPRS_D2",
	"SPRS_D2",
	"SPRS_D1",
	"SPRS_E",
	"SPRS_F",
	"SPRS_F",
	"SPRS_F",
	"SPRS_F"
};




short	enemyHitpoints[MAX_MISSIONS][MAX_ROTATING_OBJECTS] =
{
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0Xdf, 0Xdf, 0, 0, 0X7f, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 0  */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 1  */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 2  */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 3  */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 4  */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 5  */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 6  */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 7  */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 8  */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 9  */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 10 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 11 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 12 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 13 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 14 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 15 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 16 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 17 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 18 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 19 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 20 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 21 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 22 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 23 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF, /* level 24 */
	 0, 0, 0X1FF, 0X3FF, 0XFF, 0X1FF, 0X2FF, 0X10, 0XdF, 0XdF, 0, 0, 0X7F, 0XFF, 0XFF, 0X1FF, 0X1FF  /* level 25 */
};




ushort	rendezvousPoints[MAX_MISSIONS][2] =
{
	 41, 48,	/* Mission 0  */
	235, 92,  /* Mission 1  */
	201,174,  /* Mission 2  */
	235,190,  /* Mission 3  */
	235, 96,  /* Mission 4  */
	235, 80,  /* Mission 5  */
	 57,207,  /* Mission 6  */
	153,101,  /* Mission 7  */
	235, 47,  /* Mission 8  */
	 20,164,  /* Mission 9  */
	  9,045,  /* Mission 10 */
	217,  9,  /* Mission 11 */
	224,047,  /* Mission 12 */
	212,158,  /* Mission 13 */
	235,210,	/* Mission 14 */
	 85,223,  /* Mission 15 */
	111,154,  /* Mission 16 */
	227, 48,  /* Mission 17 */
	203,237,  /* Mission 18 */
	 96, 90,  /* Mission 19 */
	141,228,  /* Mission 20 */
	20,20,		/* Mission 21 */
	142,235,  /* Mission 22 */
	186, 51,  /* Mission 23 */
	 10,187, 	/* Mission 24 */
	  7,224   /* Mission 25 */
};





short	enemyShellDelays[MAX_ROTATING_OBJECTS] =
{
	0,			/* */
	50, 		/* PLAYER */
	100,    /* ENEMY TANK */
	120,    /* BATTLE TANK */
	80,     /* AMOURED FIGHTER */
	50,     /* APC */
	35,    	/* GUN BOAT */
	20,     /* GUN EMPL */
	0,      /* TRUCK */
	0,      /* TRUCK */
	0,      /* HOSTAGE */
	0,      /* HOSTAGE */
	50,     /* HELICOPTER */
	50,     /* GUNSHIP */
	0,      /* RADAR */
	20,     /* PLYR HELI */
	10      /* PLYR PLANE */
};



short	enemyShellDamage[MAX_ROTATING_OBJECTS] =
{
	0,			/* */
	0X100, 	/* PLAYER */
	0X70,   /* ENEMY TANK */
	0X110,  /* BATTLE TANK */
	0X50,   /* AMOURED FIGHTER */
	8,     	/* APC */
	0x10,  	/* GUN BOAT */
	4,     	/* GUN EMPL */
	0,      /* TRUCK */
	0,      /* TRUCK */
	0,      /* HOSTAGE */
	0,      /* HOSTAGE */
	0x10,   /* HELICOPTER */
	0x18,   /* GUNSHIP */
	0,      /* RADAR */
	0,     	/* PLYR HELI */
	0x80    /* PLYR PLANE */
};



short	enemyShellRanges[MAX_ROTATING_OBJECTS] =
{
	0,					/* */
	0X2000, 		/* PLAYER */
	0X2000,     /* ENEMY TANK */
	0X2600,     /* BATTLE TANK */
	0X1f00,     /* AMOURED FIGHTER */
	0x1000,     /* APC */
	0x3000,     /* GUN BOAT */
	0x2000,     /* GUN EMPL */
	0,  		    /* TRUCK */
	0,      		/* TRUCK */
	0,      		/* HOSTAGE */
	0,      		/* HOSTAGE */
	0x4000,     /* HELICOPTER */
	0x4000,     /* GUNSHIP */
	0,      		/* RADAR */
	0,     			/* PLYR HELI */
	0x100      	/* PLYR PLANE */

};




short	enemyShellSpeed[MAX_ROTATING_OBJECTS] =
{
	0,				/* */
	0Xe00, 		/* PLAYER */
	0Xa00,    /* ENEMY TANK */
	0Xa00,    /* BATTLE TANK */
	0Xd00,    /* AMOURED FIGHTER */
	0xb00,    /* APC */
	0xf00,    /* GUN BOAT */
	0XF00,    /* GUN EMPL */
	0,      	/* TRUCK */
	0,      	/* TRUCK */
	0,      	/* HOSTAGE */
	0,      	/* HOSTAGE */
	0xf00,    /* HELICOPTER */
	0xf00,    /* GUNSHIP */
	0xe00,   	/* RADAR */
	0,     		/* PLYR HELI */
	0x80      /* PLYR PLANE */

};



uint	spriteRegionNumber[NUMBER_OF_REGIONS] =
{
	REGN_A_SPR, 	REGN_A_SPR, 	REGN_A_SPR, 	REGN_A_SPR,
	REGN_C_SPR, 	REGN_C_SPR, 	REGN_C_SPR,
	REGN_D1_SPR, 	REGN_D2_SPR, 	REGN_D1_SPR, 	REGN_D2_SPR, 	REGN_D1_SPR, 	REGN_D2_SPR, 	REGN_D2_SPR, 	REGN_D1_SPR,
	REGN_E_SPR,
	REGN_F_SPR, 	REGN_F_SPR, 	REGN_F_SPR, 	REGN_F_SPR
};




char	enemyLoadNames[MAX_ROTATING_OBJECTS][12] =
{
	"SHELL",
	"PLAYER",
	"ETANK",
	"BTANK",
	"EFIGHTER",
	"E_APC",
	"EGUNBOAT",
	"EGEM",
	"PTRUCK",
	"ETRUCK",
	"HOST1",
	"HOST2",
	"E_HELI",
	"GUNSHIP",
	"player"
};


uchar	treeTextureList[] =
{
	9,10,12,13,14,15,16,17
};


/**************************************************************/
/* Prototypes */

void	load_level(void);
void	load_enemies(void);
void	add_to_convoy(int memberIndex, int convoyType, ushort convoyNumber);
void	set_tank_defs(TANK *defTank, int defType);



/**************************************************************/

unsigned int	tempSize;






void initialise_level(void)
{
	CDStop();

	#ifdef PC_VERSION
	reset_cheat_checks();
	#endif

	glob2=0;

	if (forcedgame>game_data.mission) game_data.mission = forcedgame;


// take_this_out
	/*-----------------17/10/95 23:05-------------------
	 Rolling demo initialisation
	--------------------------------------------------*/
	if ( recordRollingDemo )
	{
		sprintf(rollingDemoFilename,"c:rdemo_%02d.rol", game_data.mission);
		rollingDemoFile = fopen(rollingDemoFilename, "wb");
		fwrite(&game_data.mission, sizeof(short), 1, rollingDemoFile);		/* Write out the mission number to the rolling demo file */
		crollData = NULL;
	}
	else
	if ( rollingDemo )
	{
		sprintf(rollingDemoFilename,"c:rdemo_%02d.rol", game_data.mission);
		crollData = rollingDemoData = load_file(rollingDemoFilename, NULL);
		game_data.mission = *crollData++;
	}
////////////////


	region = regionNumber[game_data.mission];

	SoundSetMasterVolume(optionSettings[SOUND_VOLUME_OPTION]<<9);

	setoptions=checkExitGame=FALSE;

	memset(blackpal,0,768);

	fade_to_pal(10, blackpal);
	memset(MCGA_RAM, 0, 320*200);
	memset(p1screen, 0, 320*200);
	memset(p2screen, 0, SCREEN_BUFFER_SIZE);

	missionNumber = game_data.mission;

	scr_height = 64;

	exit_game = 0;

	optionItem = 0;

	/* Setup tank parameters - and control variables */



	// reset the asms (if any)
	memset(asms, 0, sizeof(ASM)*MAX_ASMS);



	airSupportTriggerd = FALSE;

	cinp.mType = game_data.ctrldev;

	if ( overrideDevice )
	{
		cinp.mType=overrideDevice-1;
	}

	moneyCollected = 0;

	gotoRendezvous = objectiveAchieved = FALSE;

	switch ( cinp.mType )
	{
		case normal_control:
			cinp.movement.normal_ctrl.pan_left = game_data.normksetup[NK_LEFT];
			cinp.movement.normal_ctrl.pan_right = game_data.normksetup[NK_RIGHT];
			cinp.movement.normal_ctrl.acclr = game_data.normksetup[NK_ACCELERATE];
			cinp.movement.normal_ctrl.declr = game_data.normksetup[NK_REVERSE];
			cinp.fire = game_data.normksetup[NK_FIRE];
			cinp.select = game_data.normksetup[NK_SELECT];
			cinp.target = game_data.normksetup[NK_RESELETTARG];
			cinp.tactical = game_data.normksetup[NK_TACTICAL];
			cinp.tleft = game_data.normksetup[NK_ROTATETURR_LEFT];
			cinp.tright = game_data.normksetup[NK_ROTATETURR_RIGHT];
			cinp.tcentre = game_data.normksetup[NK_CENTERTURR];
			break;

		case tank_control:
			cinp.movement.tank_ctrl.left_track_forward = game_data.dualksetup[DK_LTRACK_FORWARD];
			cinp.movement.tank_ctrl.left_track_back = game_data.dualksetup[DK_LTRACK_FORWARD];
			cinp.movement.tank_ctrl.right_track_forward = game_data.dualksetup[DK_RTRACK_FORWARD];
			cinp.movement.tank_ctrl.right_track_back = game_data.dualksetup[DK_RTRACK_BACK];
			cinp.fire = game_data.dualksetup[DK_FIRE];
			cinp.select = game_data.dualksetup[DK_SELECT];
			cinp.target = game_data.dualksetup[DK_RESELETTARG];
			cinp.tactical = game_data.dualksetup[DK_TACTICAL];
			cinp.tleft = game_data.normksetup[DK_ROTATETURR_LEFT];
			cinp.tright = game_data.normksetup[DK_ROTATETURR_RIGHT];
			cinp.tcentre = game_data.normksetup[DK_CENTERTURR];
			break;

		case joy_control:
			break;
	}

	game_data.nstructs_dest =
	game_data.nairtarg_dest =
	game_data.ngrdtarg_dest =
	game_data.perc_trucks 	=
	game_data.perc_host			=
	game_data.perc_obj			=
	game_data.crates_coll		=
	game_data.hitacc				= 0;

//	memset(convoyData, 0, sizeof(convoyData) );

	load_level();

	load_level_samples(game_data.mission);

	#ifdef PC_VERSION
	/*-----------------17/11/95 15:23-------------------
	 setup up the double buffer pointers
	--------------------------------------------------*/
	currentScreen = p1screen+((VIEWPORT_TOP)*NSCR_WIDTH);
	previousScreen = scr_ptr = currentScreen;
	bufferId=0;
	#endif


	paused = debounce = 0;

// Take_this_out
	collisionsOn = TRUE;
////////////////
	animate_wall_textures();

	game_on = TRUE;

	draw_weapon_display(pl.cWeapon);
	draw_armour_display();
	mapmode = FALSE;

	vbls = 4;

	drawMapScreen = FALSE;

	start_engine();
	initialise_turret_sound();

	game_data.missstatus=TANK_DESTROYED; 	/* Assume that the player doesn't make it */

	messageId = msgFlash = 0;							/* Reset the message system */

	flashValue=0;

	//redraw_cockpit();

	make_night_palette();

	turn_on_lights();

	fade_to_pal(127,palette);

//take_this_out
gameSong=2;
///////////////

	optionSettings[MUSIC_TRK_OPTION] = game_data.music-1;

	play_me_a_song(optionSettings[MUSIC_TRK_OPTION]);


	objectiveX = rendezvousPoints[game_data.mission][0]<<24;
	objectiveZ = rendezvousPoints[game_data.mission][1]<<24;

	numShotsFired = numShotsHit = 0;

	reset_message_status();

	memset(tp, 0, sizeof(struct target_points)*128);
	targ.locked = FALSE;
	targ.x = targ.dest_x = 160;
	targ.y = targ.dest_y = 64;

	trippy = FALSE;

	alt = sink_add = pl.y = 0;

	numAttacking=0;			// the number of tanks initially attacking

	drawCockpit = TRUE;


}





void load_level(void)
{
	char	loadfilename[256];
	char	*regionName;
	char	*spriteRegionName;
	uint	*headerInfo;
	uint	*tempPtr;

	setcol(BLACK);

	showObjectiveDirn=FALSE;

	debug_msg("Mission %d:",missionNumber);


	if (waddStatus==build_wadds)
	{
		sprintf(loadfilename,"level_%02d.txt", missionNumber);
		open_wad_file(loadfilename);
	}
	else
	if (waddStatus==load_wadds)
	{
		sprintf(loadfilename,"wadds\\level_%02d.shk", missionNumber);
		level_wadd_pointer = open_wad_file(loadfilename);
	}

	debug_msg("\nwad opened.\n");

	block_data = load_wad_file("sgraphix\\floors\\floor.pc", NULL);

	/***************************************************/
	/* General level data - backgrounds, palettes etc. */

	regionName = regionList[missionRegion[missionNumber]] ;
	spriteRegionName = spriteRegionList[missionRegion[missionNumber]];
	spriteRegionUsed = spriteRegionNumber[missionRegion[missionNumber]];

	/* Load in the background file */
	sprintf(loadfilename, "SLEVELS\\HOR_%s.DAT", regionName);
	back_map = load_wad_file(loadfilename, NULL);

	/* Load in the reflection file */
	sprintf(loadfilename, "slevels\\ref_%s.dat", regionName);
	reflect_map = load_wad_file(loadfilename, NULL);

	/* Load in the game palette */
	sprintf(loadfilename, "sgraphix\\data\\%s.pal", regionName);
	palette = load_wad_file(loadfilename, NULL);
	convert_pal();
	palette[0]=palette[1]=palette[2]=0;
	memcpy(originalPal, palette, 768);

	/* Load in the interpolation table */
	sprintf(loadfilename, "sgraphix\\data\\%s.int", regionName);
	interpol_tab = load_wad_file(loadfilename, NULL);

	/* Load in the depth cue table */
	sprintf(loadfilename, "sgraphix\\data\\%s.dep", regionName);
	odepths = load_wad_file(loadfilename, NULL);

	/* Load in sprite objects for specified region */
	sprintf(loadfilename,"sgraphix\\gobjects\\%s.pcd", spriteRegionName);
	graphics = load_wad_file(loadfilename, NULL);

	sprintf(loadfilename,"sgraphix\\gobjects\\%s.net", spriteRegionName);
	net_info = load_wad_file(loadfilename, NULL);

	for ( i=0; i<numAnims; i++ )
	{
	 	animating_txtr_data[i].currFrame=animating_txtr_data[i].frmCnt=0;
	 	animating_txtr_data[i].frmRate=8;
	}


	/**************************************************/
	/* Level specific data */

	/* Load in the line of sight map */
	sprintf(loadfilename, "slevels\\sight_%02d.los", missionNumber);
	los_map = load_wad_file(loadfilename, NULL);

	sprintf(loadfilename, "slevels\\sight_%02d.qdt", missionNumber);
	qdt_map = load_wad_file(loadfilename, NULL);

	/*-----------------21/02/95 16:20-------------------
	Load in wall data
	--------------------------------------------------*/
	/** Wall textures and translation tables */

	/* Wall textures must be loaded onto a long word boundary
	   Because the 1st 32 bytes are treated as 8 long words */

	sprintf(loadfilename, "slevels\\walls_%02d.txm", missionNumber);
	tempPtr=(uint*)load_wad_file(loadfilename, NULL); /* Load in the textures */
	wallTextures=(uchar *)tempPtr; /* Attempt to load onto a page boundary  */

	sprintf(loadfilename, "slevels\\walls_%02d.tab", missionNumber);
	txmtrans=load_wad_file(loadfilename, NULL); /* Load in the animating texture offsets */

	sprintf(loadfilename, "slevels\\walls_%02d.pls", missionNumber);
	wallData = load_wad_file(loadfilename, NULL);

	sprintf(loadfilename, "slevels\\walls_%02d.wgp", missionNumber);
	destroyableBuildingList = load_wad_file(loadfilename, NULL);

	numPoints=wallData[0];
	wallPoints=(POINT_DATA*)((ushort*)(wallData+1));
	numSfcs=wallData[numPoints*2+1];
	destroyableBuildingGroups = destroyableBuildingList + numSfcs;

	wallSfcs=(WALL_DATA*)((ushort*)(wallData+numPoints*2+2));
	wallMids=(POINT_DATA*)((ushort*)(wallData + numPoints*2 + 2 + numSfcs*3));

	debug_msg("allocate some buffers for the level:\n");

	workPoints=(WORKING_POINT*)get_mem( (sizeof(WORKING_POINT) * numPoints) );
	workPointsCheck=(char*)get_mem( (((numPoints/POINT_RESET_BLOCK_SIZE)+1)*POINT_RESET_BLOCK_SIZE));
	wallHitList=(short*)get_mem( (sizeof(ushort) * numSfcs) );

	_fast_memset(workPointsCheck, currentCheckVal, numPoints);		/* Reset the check list */
	currentCheckVal=2;

	generate_z_index();

	/*-----------------28/11/95 12:21-------------------
	 initialise the hit points for the walls
	--------------------------------------------------*/
	for ( i=0; i<numSfcs; i++ )
	{
		wallHitList[i] = wallHitPoints[(wallSfcs+i)->wallType&7][(((wallSfcs+i)->wallType)>>3)&63];
	}

	sprintf(loadfilename, "slevels\\floor_%02d.fmp", missionNumber);
	floor_map = load_wad_file(loadfilename, NULL);

	sprintf(loadfilename, "slevels\\obj_%02d.obj", missionNumber);
	obj_map = load_wad_file(loadfilename, NULL);

	/*-----------------02/08/95 22:44-------------------
	 Load in enemy tank control data
	--------------------------------------------------*/

	sprintf(loadfilename, "slevels\\cont_%02d.ecn", missionNumber);
	etank_ctrl_data = (ushort*)load_wad_file(loadfilename, NULL);

	headerInfo = (uint*)etank_ctrl_data;

	catch_index = etank_ctrl_data + headerInfo[0];
	catch_data	= etank_ctrl_data + headerInfo[1];
	waypt_index	= etank_ctrl_data + headerInfo[2];
	waypt_data	= etank_ctrl_data + headerInfo[3];
	link_data		= etank_ctrl_data + headerInfo[4];

	TankWayptChkList = get_mem((headerInfo[5])); /* headerInfo[5] = number of wayppoints */
	HeliWayptChkList = get_mem((headerInfo[5])); /* headerInfo[5] = number of wayppoints */

	memset(TankWayptChkList, 0, headerInfo[5]);
	memset(HeliWayptChkList, 0, headerInfo[5]);

	/*-----------------27/04/95 10:56-------------------
	 Setup level variables
	--------------------------------------------------*/

	memset(&pl,0,sizeof(TANK));

	weaponsAvailable[WMAIN_GUN] = TRUE;
	weaponsAvailable[WCHAIN_GUN] = TRUE;
	weaponsAvailable[WSAMS] = game_data.nsams;
	weaponsAvailable[W911B] = game_data.airsupp;

	if ( fullArmourMent )
	{
		weaponsAvailable[WSAMS] = game_data.nsams = 4;
		weaponsAvailable[W911B] = TRUE;
		game_data.trkupg = 4;
		game_data.engupg = 4;
		game_data.relupg = 4;
		game_data.tarupg = 4;
		game_data.cgunupg = 4;
	}

	weaponsAvailable[W911A] = FALSE;

	track_upg = game_data.trkupg;
	engine_upg = game_data.engupg;

	pl.def = PLAYER_TANK;

	pl.speed = 0;

	pl.shellDelayCount = 0;

 	pl.accelr =	td[PLAYER_TANK].accelr + eu[engine_upg].accelr;
	pl.accelc =	td[PLAYER_TANK].accelc + eu[engine_upg].accelc;

	/* Upgrade tracks. (Value = track_upg) */
	pl.trak_grip = td[PLAYER_TANK].trak_grip + tu[track_upg].trak_grip;
	pl.top_brake = td[PLAYER_TANK].top_brake + tu[track_upg].top_brake;

	/* Effects of both pickups. */
	pl.maxturn = td[PLAYER_TANK].maxturn + eu[engine_upg].maxturn + tu[track_upg].maxturn;
	pl.pre_accel = td[PLAYER_TANK].pre_accel + eu[engine_upg].pre_accel + tu[track_upg].pre_accel;
	pl.top_speed = td[PLAYER_TANK].top_speed + eu[engine_upg].top_speed + tu[track_upg].top_speed;

	pl.max_armour = game_data.armlev<<8;
	pl.armour = game_data.armint<<5;

	pl.shellDamage = 0x100;
	pl.shellSpeed = 0Xe00;
	playerChainReset = (enemyShellDelays[PLAYER_TANK]>>3) - (game_data.cgunupg);
	playerChainCount = 0;
	pl.shellDelay = enemyShellDelays[PLAYER_TANK]-(game_data.relupg<<3);
	pl.shellRange = enemyShellRanges[PLAYER_TANK];
	pl.sqrObjDetval = objectDetectSizes[PLAYER_TANK];
	pl.sqrObjDetval *= pl.sqrObjDetval;
	pl.sqrWallDetval = pl.sqrObjDetval;
	pl.sqrObjDetval <<= 1;

	pl.collData = &playerDetectdata;
	pl.possWallCollisions = pl.possObjCollisions = 0;

	alt = pl.y = 0;

	pl.cWeapon = WMAIN_GUN;

	pl.flying = FALSE;

	tiltLev = NO_PITCH;

	load_enemies();

	/* Load the mission objective data */
	sprintf(loadfilename, "slevels\\misn_%02d.dat", missionNumber);
	objectivData = load_wad_file(loadfilename, NULL);

	objectiveType = *objectivData;

	if ( objectiveType == DESTROY_BUILDINGS_OBJECTIVE )
	{
		numBtargets = *(objectivData+2);
		objectiveBuildings = objectivData+3;
		numObjectiveBuildingsLeft = numObjectiveBuildings = *(objectivData+1);	/* Get the number of buildings to destroy */
		buildingTargetList = objectiveBuildings + (numObjectiveBuildingsLeft<<1);

		for ( i=0; i<numSfcs; i++ )																							/* note which buildings are target buildings */
		{
			if( objective_building(i) )
			{
				wallHitList[i]|=OBJECTIVE_BUILDING_TAG;
				debug_msg("txtr %d belongs to objective building.\n",i);
			}
		}
	}

	for ( i=0; i<numSfcs; i++ ) 	/** NOTE WHICH WALLS ARE TREES */
	{
		if ( ((wallSfcs+i)->wallType & 0x3)==TRANSPARENT_ASYMETRICAL_WALL )
		{
			int	q;
			int	txtrNum;

			txtrNum=(((wallSfcs+i)->wallType)>>3)&0x3f;
			for ( q=0; q<MAX_TREE_TEXTURES; q++ )
			{
				if ( txtrNum==treeTextureList[q] )
				{
					wallHitList[i]|=TREE_TAG; 	// note this is a tree wall
					break;
				}
			}
		}
	}


	for (i=0;i<256;i++)
	{
		mob[i].m_plyr = 0;
		mob[i].m_def = 0xffff;
	}

	memset(playerShells, 0, sizeof(SHELL_DATA)*MAX_PLAYER_SHELLS);
	memset(enemyShells, 0, sizeof(SHELL_DATA)*MAX_ENEMY_SHELLS);
	memset(pl_bullets, 0, sizeof(struct bullets) * (MAX_PLAYER_SHELLS<<2) );
	memset(en_bullets, 0, sizeof(struct bullets) * (MAX_ENEMY_SHELLS<<2) );

	memset(fragments, 0, sizeof(FRAGMENT_DATA)*MAX_FRAGMENTS);
	memset(fxSprites, 0, sizeof(FX_SPRITE)*MAX_FX_SPRITES );
	memset(delayedFX, 0, sizeof(DELAYED_FX)*MAX_DELAYED_FX_SLOTS );

	memset(drawFlags, 1, MAX_DRAW_FLAGS ); /* All components of the control panel have to be drawn initially */

	ll[255].prev=(struct linklist*)0;		/* Setup last entry in link list. */
	ll[255].next=(struct linklist*)0;

	cam_dist = 100;//160;

	/* Clear screen. */
	_fast_memset((char*)VIDEO_START_ADRESS, 0, 320*200);												/* naughty - not very portable like. */
	_fast_memset((char*)p1screen, 0, 320*200);

	close_wad_file();

}



/******************************************************************/



ushort	*tankloadbuffer;


void	load_enemies(void)
{
	TANK 		*ctank, *cheli;
	ENEMY_TANK_CTRL	*ctankectrl, *cheliectrl;
	GUN_EMPLACEMENT *cgunempl;
	GUN_BOAT *cgunboat;
	HOSTAGE	 *chostage;
	uint		i;
	ushort	*eptr;
	ushort	numEnemies;
	ushort	enemyCtr;
	ushort	ctankIndex;
	ushort	cgunboatIndex;
	ushort	cheliIndex;
	ushort	cgunboatCtrlIndex;
	char		loadfilename[128];

	/* Reset objective enemy data */
	numObjectiveEnemies = 0;

	/* Reset previous enemy data */
	memset(mob_load_flags, 0, MAX_ROTATING_OBJECTS);

	memset(enemyTanks, 0, sizeof(TANK) * MAX_ENEMY_TANKS);
	memset(gunempls, 0, sizeof(GUN_EMPLACEMENT) * MAX_GUN_EMPLS);
	memset(gunboats, 0, sizeof(GUN_BOAT) *MAX_GUN_BOATS);
	memset(helicopters, 0, sizeof(TANK) * MAX_HELICOPTERS);
	memset(hostages, 0, sizeof(HOSTAGE) * MAX_HOSTAGES);

	memset(enemyTankCtrl, 0, sizeof(ENEMY_TANK_CTRL) * MAX_ENEMY_TANKS );
	memset(enemyHeliCtrl, 0, sizeof(ENEMY_TANK_CTRL) * MAX_HELICOPTERS );
	memset(gunboatCtrl, 0, sizeof(ENEMY_TANK_CTRL) * MAX_CONVOY_BOATS );

	memset(convoyData, 0XFF, sizeof(CONVOY_DATA)*MAX_CONVOYS);

	memset(attackData, 0, sizeof(ATTACKING_TANK_DATA) * MAX_ATTACKING_TANKS);

	totalConvoyMembers = 0;


	#ifdef PC_VERSION
	#ifndef FLOPPY_VERSION
	/*A TEMPORARY DNETWORK ADDITION****************/
	if (nDef.flags)
	{
		return;
	}
	#endif
	#endif



	/* Load in the mission enemies */
	sprintf(loadfilename, "slevels\\enemy_%02d.enm", missionNumber);
	tankloadbuffer=(ushort*)load_wad_file(loadfilename, NULL);

	ctank = enemyTanks;
	cgunempl = gunempls;
	cgunboat = gunboats;
	cheli = helicopters;
	chostage = hostages;

	eptr = tankloadbuffer;

	eptr++;	/* Skip the filetype indicator */

	numEnemies = *eptr++;

	eptr++;	/* skip the object type */

	/* Get player tank position */
	pl.x = ((int)(*(ushort*)eptr++)<<16);
	pl.z = ((int)(*(ushort*)eptr++)<<16);


	/* Get player tank angle */
	camera_angle = pl.angle = pl.dir = (0x7ff-(*eptr++))&0x7ff;
	turret_angle = 0;
	turretVelocity = 0;
	turretCentering = 0;

	pl.chaingunHeat = 0;
	otargLocked = FALSE;
	reset_chaingun_count((&pl));
	armourDisplayColour=ARMOUR_OK_COLOUR;

	enemyCtr = 0;
	ctankIndex = 0;
	cgunboatIndex = 0;
	cgunboatCtrlIndex = 0;
	cheliIndex = 0;
	numHostagesCollected = numHostages = 0;

	while (enemyCtr < numEnemies )
	{
		int	gunboatPathUsed;
		switch ( *eptr )
		{
			case ENEMY_TANK:
				*ctank = pl;
				ctank->armour = ctank->max_armour = enemyHitpoints[missionNumber][*eptr];
				ctank->shellDelay = enemyShellDelays[*eptr];
				ctank->shellDamage = enemyShellDamage[*eptr];
				ctank->shellSpeed = enemyShellSpeed[*eptr];
				ctank->shellRange = enemyShellRanges[*eptr];
				ctank->sqrObjDetval = objectDetectSizes[*eptr];
				ctank->sqrObjDetval *= ctank->sqrObjDetval;
				ctank->sqrWallDetval = ctank->sqrObjDetval;
				ctank->sqrObjDetval <<= 1;

				ctank->def = ENEMY_TANK;

				set_tank_defs(ctank, *eptr);
				eptr++;
				ctank->x = (*eptr++)<<16;
				ctank->z = (*eptr++)<<16;
				ctank->angle = ctank->dir = (0x7ff-(*eptr++))&0x7ff;
				ctank->ectrl = enemyTankCtrl + ctankIndex; /* Setup pointer to the enemy logic data - fuck me this is messy */

				ctankectrl=ctank->ectrl;

				ctankectrl->regenerate = *eptr++;
				ctankectrl->restricted = *eptr++;
				ctankectrl->pathUsed = *eptr++;

				if ( ctankectrl->regenerate )	/*Setup regeneration info */
				{
					ctankectrl->regenerateId=ctank->def;
					ctankectrl->regenx = ctank->x>>16;
					ctankectrl->regenz = ctank->z>>16;
					ctankectrl->regenAng = ctank->angle;
					ctankectrl->regenCount = MAX_REGENERATIONS;
				}
				else
				{
					numObjectiveEnemies++;
					ctank->objectiveTarget = TRUE;
				}

 				if ( ctankectrl->restricted )
				{
					ctankectrl->rx1 = *eptr++;
					ctankectrl->rz1 = *eptr++;
					ctankectrl->rx2 = *eptr++;
					ctankectrl->rz2 = *eptr++;
				}

				ctank++;
				ctankIndex++;

				mob_load_flags[ENEMY_TANK] = 1;
				break;


			case BATTLE_TANK:
				*ctank = pl;
				ctank->armour = ctank->max_armour = enemyHitpoints[missionNumber][*eptr];
				ctank->shellDelay = enemyShellDelays[*eptr];
				ctank->shellDamage = enemyShellDamage[*eptr];
				ctank->shellSpeed = enemyShellSpeed[*eptr];
				ctank->shellRange = enemyShellRanges[*eptr];
				ctank->sqrObjDetval = objectDetectSizes[*eptr];
				ctank->sqrObjDetval *= ctank->sqrObjDetval;
				ctank->sqrWallDetval = ctank->sqrObjDetval;
				ctank->sqrObjDetval <<= 1;

				ctank->def = BATTLE_TANK;
				set_tank_defs(ctank, *eptr);

				eptr++;
				ctank->x = (*eptr++)<<16;
				ctank->z = (*eptr++)<<16;
				ctank->angle = ctank->dir = (0x7ff-(*eptr++))&0x7ff;
				ctank->ectrl = enemyTankCtrl + ctankIndex; 	/* Setup pointer to the enemy logic data - fuck me this is messy */

				ctankectrl=ctank->ectrl;

				ctankectrl->regenerate = *eptr++;
				ctankectrl->restricted = *eptr++;
				ctankectrl->pathUsed = *eptr++;

				if ( ctankectrl->regenerate )								/*	Setup regeneration info */
				{
					ctankectrl->regenerateId=ctank->def;
					ctankectrl->regenx = ctank->x>>16;
					ctankectrl->regenz = ctank->z>>16;
					ctankectrl->regenAng = ctank->angle;
					ctankectrl->regenCount = MAX_REGENERATIONS;
				}
				else
				{
					numObjectiveEnemies++;
					ctank->objectiveTarget = TRUE;
				}


 				if ( ctankectrl->restricted )
				{
					ctankectrl->rx1 = *eptr++;
					ctankectrl->rz1 = *eptr++;
					ctankectrl->rx2 = *eptr++;
					ctankectrl->rz2 = *eptr++;
				}

				ctank++;
				ctankIndex++;

				mob_load_flags[BATTLE_TANK] = 1;
				break;



			case AMOURED_FIGHTER:
				*ctank = pl;
				ctank->armour = ctank->max_armour = enemyHitpoints[missionNumber][*eptr];
				ctank->shellDelay = enemyShellDelays[*eptr];
				ctank->shellDamage = enemyShellDamage[*eptr];
				ctank->shellSpeed = enemyShellSpeed[*eptr];
				ctank->shellRange = enemyShellRanges[*eptr];
				ctank->def = AMOURED_FIGHTER;
				ctank->sqrObjDetval = objectDetectSizes[*eptr];
				ctank->sqrObjDetval *= ctank->sqrObjDetval;
				ctank->sqrWallDetval = ctank->sqrObjDetval;
				ctank->sqrObjDetval <<= 1;

				set_tank_defs(ctank, *eptr);

				eptr++;
				ctank->x = (*eptr++)<<16;
				ctank->z = (*eptr++)<<16;
				ctank->angle = ctank->dir = (0x7ff-(*eptr++))&0x7ff;
				ctank->ectrl = enemyTankCtrl + ctankIndex; /* Setup pointer to the enemy logic data - fuck me this is messy */

				ctankectrl=ctank->ectrl;

				ctankectrl->iq = SMART;
				ctankectrl->regenerate = *eptr++;
				ctankectrl->restricted = *eptr++;
				ctankectrl->pathUsed = *eptr++;

				if ( ctankectrl->regenerate )	/*Setup regeneration info */
				{
					ctankectrl->regenerateId=ctank->def;
					ctankectrl->regenx = ctank->x>>16;
					ctankectrl->regenz = ctank->z>>16;
					ctankectrl->regenAng = ctank->angle;
					ctankectrl->regenCount = MAX_REGENERATIONS;
				}
				else
				{
					numObjectiveEnemies++;
					ctank->objectiveTarget = TRUE;
				}

 				if ( ctankectrl->restricted )
				{
					ctankectrl->rx1 = *eptr++;
					ctankectrl->rz1 = *eptr++;
					ctankectrl->rx2 = *eptr++;
					ctankectrl->rz2 = *eptr++;
				}

				ctank++;
				ctankIndex++;

				mob_load_flags[AMOURED_FIGHTER] = 1;
				break;



			case ENEMY_APC:
				*ctank = pl;
				ctank->armour = ctank->max_armour = enemyHitpoints[missionNumber][*eptr];
				ctank->shellDelay = enemyShellDelays[*eptr];
				ctank->shellDamage = enemyShellDamage[*eptr];
				ctank->shellSpeed = enemyShellSpeed[*eptr];
				ctank->shellRange = enemyShellRanges[*eptr];
				ctank->sqrObjDetval = objectDetectSizes[*eptr];
				ctank->sqrObjDetval *= ctank->sqrObjDetval;
				ctank->sqrWallDetval = ctank->sqrObjDetval;
				ctank->sqrObjDetval <<= 1;
				reset_chaingun_count(ctank);

				ctank->def = ENEMY_APC;
				set_tank_defs(ctank, *eptr);

				eptr++;
				ctank->x = (*eptr++)<<16;
				ctank->z = (*eptr++)<<16;
				ctank->angle = ctank->dir = (0x7ff-(*eptr++))&0x7ff;
				ctank->ectrl = enemyTankCtrl + ctankIndex; /* Setup pointer to the enemy logic data - fuck me this is messy */
				ctank->cWeapon = WCHAIN_GUN;

				ctankectrl=ctank->ectrl;

				ctankectrl->regenerate = *eptr++;
				ctankectrl->restricted = *eptr++;
				ctankectrl->pathUsed = *eptr++;

				if ( ctankectrl->regenerate )	/* Setup regeneration info */
				{
					ctankectrl->regenerateId=ctank->def;
					ctankectrl->regenx = ctank->x>>16;
					ctankectrl->regenz = ctank->z>>16;
					ctankectrl->regenAng = ctank->angle;
					ctankectrl->regenCount = MAX_REGENERATIONS;
				}
				else
				{
					numObjectiveEnemies++;
					ctank->objectiveTarget = TRUE;
				}

 				if ( ctankectrl->restricted )
				{
					ctankectrl->rx1 = *eptr++;
					ctankectrl->rz1 = *eptr++;
					ctankectrl->rx2 = *eptr++;
					ctankectrl->rz2 = *eptr++;
				}

				ctank++;
				ctankIndex++;

				mob_load_flags[ENEMY_APC] = 1;
				break;



			case E_GUNEMPL:
				cgunempl->armour = enemyHitpoints[missionNumber][*eptr];
				cgunempl->exist = TRUE;
				eptr++;
				cgunempl->x = (*eptr++)<<16;		/* Get position */
				cgunempl->z = (*eptr++)<<16;
 				cgunempl->angle = cgunempl->startangle = (0x7ff-(*eptr++))&0x7ff;

				eptr++;				/* skip regenerate data */
				i=*eptr++; 		/* get restriction flag */
				eptr++; 			/* skip path flag */

				if ( i )
				{
					eptr+=4;		/* skip restriction data*/
				}

				numObjectiveEnemies++;

				cgunempl->shellDelayCount = 0;

				cgunempl++;

				mob_load_flags[E_GUNEMPL] = 1;
				break;




			case ENEMY_GUNBOAT:
				cgunboat->armour = enemyHitpoints[missionNumber][*eptr];
				cgunboat->exist = TRUE;
				eptr++;
				cgunboat->x = (*eptr++)<<16;		/* Get position */
				cgunboat->z = (*eptr++)<<16;
				cgunboat->angle = (0x7ff-(*eptr++))&0x7ff;

				eptr++;											  	/* skip regenerate data */
				i = *eptr++;  									/* skip restriction flag */
				gunboatPathUsed=*eptr++ ;  			/* check for convoy data */

 				if ( i )												/** skip restriction data if included */
				{
					eptr+=4;
				}

				if ( gunboatPathUsed )
				{
					cgunboat->ectrl = gunboatCtrl + cgunboatCtrlIndex;
					init_gunboat(cgunboat);
					cgunboat->ectrl->pathUsed = gunboatPathUsed;
					add_to_convoy(cgunboatIndex, GUNBOAT_CONVOY, gunboatPathUsed-1);
					cgunboatCtrlIndex++;
				}
				else
					cgunboat->ectrl = NULL;


				cgunboat++;
				cgunboatIndex++;

				mob_load_flags[ENEMY_GUNBOAT] = 1;
				break;



			case ALLIED_TRUCK:
				*ctank = pl;
				ctank->armour = ctank->max_armour = enemyHitpoints[missionNumber][*eptr];
				ctank->def = ALLIED_TRUCK;
				ctank->sqrObjDetval = objectDetectSizes[*eptr];
				ctank->sqrObjDetval *= ctank->sqrObjDetval;
				ctank->sqrWallDetval = ctank->sqrObjDetval;
				ctank->sqrObjDetval <<= 1;

				eptr++;
				ctank->x = (*eptr++)<<16;
				ctank->z = (*eptr++)<<16;
				ctank->angle = ctank->dir = (0x7ff-(*eptr++))&0x7ff;
				ctank->ectrl = enemyTankCtrl + ctankIndex; /* Setup pointer to the enemy logic data - fuck me this is messy */

				ctankectrl=ctank->ectrl;

				eptr++;				/* skip regenerate data - TRUCKS don't regenerate whatever*/
				i=*eptr++; 		/* get restriction flag */
				ctankectrl->pathUsed = *eptr++;

				if ( i )
				{
					eptr+=4;		/*skip restriction data - its a convoy */
				}

				if ( ctankectrl->pathUsed )
				{
					add_to_convoy(ctankIndex, TRUCK_CONVOY, ctankectrl->pathUsed-1);
				}

				ctank++;
				ctankIndex++;

				mob_load_flags[ALLIED_TRUCK] = 1;
				break;



			case ENEMY_TRUCK:
				*ctank = pl;
				ctank->armour = ctank->max_armour = enemyHitpoints[missionNumber][*eptr];
				ctank->def = ENEMY_TRUCK;
				ctank->sqrObjDetval = objectDetectSizes[*eptr];
				ctank->sqrObjDetval *= ctank->sqrObjDetval;
				ctank->sqrWallDetval = ctank->sqrObjDetval;
				ctank->sqrObjDetval <<= 1;

				eptr++;
				ctank->x = (*eptr++)<<16;
				ctank->z = (*eptr++)<<16;
				ctank->angle = ctank->dir = (0x7ff-(*eptr++))&0x7ff;
				ctank->ectrl = enemyTankCtrl + ctankIndex; /* Setup pointer to the enemy logic data - fuck me this is messy */

				ctankectrl=ctank->ectrl;

				eptr++;				/* skip regenerate data - TRUCKS don't regenerate whatever*/
				i=*eptr++; 		/* get restriction flag */
				ctankectrl->pathUsed = *eptr++;

				if ( i )
				{
					eptr+=4;	/*skip restriction data - its a convoy */
				}

				if ( ctankectrl->pathUsed )
				{
					add_to_convoy(ctankIndex, TRUCK_CONVOY, ctankectrl->pathUsed - 1);
				}

				ctank++;
				ctankIndex++;

				mob_load_flags[ENEMY_TRUCK] = 1;
				break;



			case E_HELICOPTER:
				*cheli = pl;																/* For the moment */
				cheli->armour = cheli->max_armour = enemyHitpoints[missionNumber][*eptr];
				cheli->shellDelay = enemyShellDelays[*eptr];
				cheli->shellDamage = enemyShellDamage[*eptr];
				cheli->shellSpeed = enemyShellSpeed[*eptr];
				cheli->shellRange = enemyShellRanges[*eptr];
				cheli->cWeapon = WCHAIN_GUN;
				cheli->sqrObjDetval = objectDetectSizes[*eptr];
				cheli->sqrObjDetval *= ctank->sqrObjDetval;
				cheli->sqrWallDetval = ctank->sqrObjDetval;
				cheli->sqrObjDetval <<= 1;


				cheli->def = E_HELICOPTER;
				eptr++;

				cheli->x = (*eptr++)<<16;
				cheli->z = (*eptr++)<<16;
				cheli->y = HELICOPTER_ALTITUDE;

				cheli->angle = cheli->dir = (0x7ff-(*eptr++))&0x7ff;

				cheli->ectrl = enemyHeliCtrl + cheliIndex; 	/* Setup pointer to the enemy logic data - fuck me this is messy */

				cheliectrl=cheli->ectrl;

				cheliectrl->regenerate = *eptr++;
				eptr++;
				eptr++;

				cheliectrl->regenerateId=cheli->def;
				cheliectrl->regenx = cheli->x>>16;
				cheliectrl->regenz = cheli->z>>16;
				cheliectrl->regenAng = cheli->angle;
				cheliectrl->regenCount = MAX_REGENERATIONS;

				cheliectrl->rx1 = *eptr++;									/*Setup the trigger zone vars */
				cheliectrl->rz1 = *eptr++;
				cheliectrl->rx2 = *eptr++;
				cheliectrl->rz2 = *eptr++;

				cheli->flying = FALSE;

				cheli++;
				cheliIndex++;

				mob_load_flags[E_HELICOPTER] = 1;
				break;




			case E_GUNSHIP:
				*cheli = pl;																/* For the moment */
				cheli->armour = cheli->max_armour = enemyHitpoints[missionNumber][*eptr];
				cheli->shellDelay = enemyShellDelays[*eptr];
				cheli->shellDamage = enemyShellDamage[*eptr];
				cheli->shellSpeed = enemyShellSpeed[*eptr];
				cheli->shellRange = enemyShellRanges[*eptr];
				cheli->cWeapon = WCHAIN_GUN;
				cheli->sqrObjDetval = objectDetectSizes[*eptr];
				cheli->sqrObjDetval *= cheli->sqrObjDetval;
				cheli->sqrWallDetval = cheli->sqrObjDetval;
				cheli->sqrObjDetval <<= 1;

				cheli->def = E_GUNSHIP;
				eptr++;

				cheli->x = (*eptr++)<<16;
				cheli->z = (*eptr++)<<16;
				cheli->y = HELICOPTER_ALTITUDE;

				cheli->angle = cheli->dir = (0x7ff-(*eptr++))&0x7ff;

				cheli->ectrl = enemyHeliCtrl + cheliIndex; 	/* Setup pointer to the enemy logic data - fuck me this is messy */

				cheliectrl=cheli->ectrl;

				cheliectrl->regenerate = *eptr++;
				eptr++;
				eptr++;

				cheliectrl->regenerateId=cheli->def;
				cheliectrl->regenx = cheli->x>>16;
				cheliectrl->regenz = cheli->z>>16;
				cheliectrl->regenAng = cheli->angle;
				cheliectrl->regenCount = MAX_REGENERATIONS;

				cheliectrl->rx1 = *eptr++;									/*Setup the trigger zone vars */
				cheliectrl->rz1 = *eptr++;
				cheliectrl->rx2 = *eptr++;
				cheliectrl->rz2 = *eptr++;

				cheli->flying = FALSE;

				cheli++;
				cheliIndex++;

				mob_load_flags[E_GUNSHIP] = 1;
				break;



			case HOSTAGE_1:
				chostage->def = HOSTAGE_1;
				eptr++;
				chostage->x=(*eptr++)<<16;
				chostage->z=(*eptr++)<<16;
				chostage->angle = *eptr++;
				chostage->mode=HOSTAGE_STANDING;
				chostage->frame=0;
				chostage->anim = HOSTAGE_STANDING_ANIM;

				eptr++;
				i=*eptr++;
				eptr++;
				if ( i )
				{
					eptr++;
					eptr++;
					eptr++;
					eptr++;
				}

				numHostages++;
				mob_load_flags[HOSTAGE_1] = 1;
				chostage++;
				break;


			case HOSTAGE_2:
				chostage->def = HOSTAGE_2;
				eptr++;
				chostage->x=(*eptr++)<<16;
				chostage->z=(*eptr++)<<16;
				chostage->angle = *eptr++;
				chostage->mode=HOSTAGE_STANDING;
				chostage->frame=0;
				chostage->anim = HOSTAGE_STANDING_ANIM;

				eptr++;
				i=*eptr++;
				eptr++;

				if ( i )
				{
					eptr++;
					eptr++;
					eptr++;
					eptr++;
				}

				numHostages++;
				mob_load_flags[HOSTAGE_2] = 1;
				chostage++;
				break;


			default:
				eptr++;// def
				eptr++;// x
				eptr++;// z
				eptr++;// angle
				eptr++;// regenerate
				i=*eptr++; // restricted
				eptr++;//pathUsed


				if ( i ) // restrict data
				{
					eptr++;
					eptr++;
					eptr++;
					eptr++;
				}
		}


		enemyCtr++;
	}
	totalObjectiveEnemies=numObjectiveEnemies;

	/* Set up pointers to the enemy tank logic data */
	for ( i=0; i<MAX_ENEMY_TANKS; i++ )
	{
		/* Initialise the tank logic variables */
		init_tank_control(enemyTanks+i);
	}


	for ( i=0; i<MAX_HELICOPTERS; i++ )
	{
		init_tank_control(helicopters+i);
	}


	for ( i=ENEMY_TANK; i<MAX_ROTATING_OBJECTS; i++ )
	{
		if ( mob_load_flags[i] )
		{
			sprintf(loadfilename,"sgraphix\\tanx\\%s.pcd",enemyLoadNames[i]);
			mob_graphics[i] = load_wad_file(loadfilename, NULL);
			sprintf(loadfilename,"sgraphix\\tanx\\%s.net",enemyLoadNames[i]);
			mob_net_info[i] = load_wad_file(loadfilename, NULL);
		}
	}

	targ.max_xvel = targ.max_yvel = 1 + game_data.tarupg;
	targ.x = 161;
	targ.y = 64;

	sprintf(loadfilename, "slevels\\enemy_%02d.pth", missionNumber);
	pathBuffer=(ushort*)load_wad_file(loadfilename, NULL);

	numPaths = *pathBuffer;
	pathOffsets = pathBuffer+1;
	pathData = pathBuffer+1+numPaths;

	numAttackingHelicopters = 0;

	convoyCompleted = convoyDestroyed = FALSE;

	numHostagesLeft = numHostages;

	debug_msg("\nEnemy info\n*********************\n");
	debug_msg("Total number of enemies load for mission %d=%d",game_data.mission, enemyCtr);
	debug_msg("ground vehicles = %d",ctankIndex);
	debug_msg("gunboats = %d", cgunboatIndex);
	debug_msg("Gunboats in convoy = %d",cgunboatCtrlIndex);
	debug_msg("Helicopters = %d", cheliIndex);
	debug_msg("Hostages = %d",numHostages);
	debug_msg("Gun employments = %d",(cgunempl - gunempls));
	debug_msg("\n\n");
}



/**************************************************************/



void	add_to_convoy(int memberIndex, int convoyType, ushort convoyNumber)
{
	CONVOY_DATA *cConvoy;

	cConvoy = convoyData + convoyNumber;

	cConvoy->convoyType = convoyType;


	if ( cConvoy->numMembers==NULL_ID )				/*First one in the convoy - therefore its the leader */
	{
		cConvoy->numMembers = 0;
		cConvoy->currentTarget = 1;

  	switch ( convoyType )
  	{
  		case TRUCK_CONVOY:
  			(enemyTanks+memberIndex)->ectrl->convoyLeader=TRUE;
  			break;

  		case GUNBOAT_CONVOY:
				(gunboats+memberIndex)->ectrl->convoyLeader=TRUE;
  			break;
  	}
	}

	cConvoy->members[cConvoy->numMembers++] = memberIndex;
	cConvoy->initMembers = cConvoy->numMembers;

	totalConvoyMembers++;

	sam[0].fired = 0;
	sam[1].fired = 0;
	sam[2].fired = 0;
	sam[3].fired = 0;
	target_no = change_target = 0;
}



void	set_tank_defs(TANK *defTank, int defType)
{
 	defTank->accelr =	td[defType].accelr;
	defTank->accelc =	td[defType].accelc;

	defTank->trak_grip = td[defType].trak_grip;
	defTank->top_brake = td[defType].top_brake;

	defTank->maxturn = td[defType].maxturn;
	defTank->pre_accel = td[defType].pre_accel;
	defTank->top_speed = td[defType].top_speed;
}



/*Free up all memory claimed by a level, so another can be
	started*/
void	cleanup_after_level(void)
{
	CDStop();

	if ( waddStatus==load_wadds )
	{
		// free up all the wad data

		free_mem(level_wadd_pointer);
	}
	else
	{
		// free up all the loaded files

		free_mem(block_data);

		free_mem((char*)back_map);

		free_mem((char*)reflect_map);

		free_mem(palette);

		free_mem(interpol_tab);

		free_mem(odepths);

		free_mem(graphics);

		free_mem(net_info);

		free_mem(los_map);

		free_mem(qdt_map);

		free_mem((char*)wallTextures);

		free_mem((char*)txmtrans);

		free_mem(wallData);

		free_mem(destroyableBuildingList);

		free_mem(floor_map);

		free_mem(obj_map);

		free_mem(etank_ctrl_data);

		free_mem(objectivData);

		#ifdef PC_VERSION
		#ifndef FLOPPY_VERSION
		if (!nDef.flags)
		{
			free_mem(tankloadbuffer);
		}
		#endif
		#endif



		for ( i=ENEMY_TANK; i<MAX_ROTATING_OBJECTS; i++ )
		{
			if ( mob_graphics[i]!=NULL )
			{
				free_mem((char*)mob_graphics[i]);
				free_mem((char*)mob_net_info[i]);
				mob_graphics[i]=NULL;
				mob_net_info[i]=NULL;
			}
		}
	}

	/************************************/
	/* Free up the level allocated data */
	/************************************/

	/** Free the wall data */
	free_mem((char*)workPoints);
	free_mem((char*)workPointsCheck);
	free_mem((char*)wallHitList);

	/** Free up the enemy control data - control nets etc. */
	free_mem(TankWayptChkList);
	free_mem(HeliWayptChkList);

	fade_to_pal(16, blackpal);
	wait_fade();

	memset(MCGA_RAM, 0, 320*200);
	memset(p1screen, 0, 320*200);

	SoundStopAllSamples();
	SoundFreeSamples();

	/*-----------------17/10/95 23:05-------------------
	 Rolling demo cleanup
	--------------------------------------------------*/

	if ( recordRollingDemo )
	{
		i=0xffffffff;
		fwrite(&i, sizeof(short), 1, rollingDemoFile);
		fclose(rollingDemoFile);
	}
	else
	if ( rollingDemo )
	{
		free_mem( rollingDemoData );
	}
}
