#include  "typedefs.h"
#include "frontend.h"
#include "iff.h"
#include <stdio.h>
#include "frontdef.h"

#ifdef PC_VERSION

#include "shell.h"
#include "types.h"
#include "rad.h"
#include "smack.h"
#include "dosext.h"
#include "radmal.i"
#include "svga.h"

#else

typedef struct
	{
	short	sc_width,sc_height;
	short	mx_sense,my_sense,ms_dthresh;
	void		*scrn_ptr;
	short	col_mode;
	short	dump_x,dump_y,dump_width,dump_height;
	}
	SETUP;

int mx,my;

SETUP game_setup;

#include "headers.h" /* Platform specific header files */
#include "chuck.h"

#endif



int decomp_iff(char *file_buf, int len)
{

	int	c;
	char	*ptr=NULL;

	ps.type = 0;

	c=find("PBM ", file_buf, len);		/* byte of bit plane? */
	if (c != -1)
		ps.type = 255;							/* not a PBM file */

	if	((c=find("FORM", file_buf, len)) < 0)	/* IFF? */
		return(0);

	if	((c=find("ILBM", file_buf, len)) < 0)	/* raster IFF? */
		if (ps.type == 0)					/* not PBM or ILBM */
			return(0);

	if	((c=find("BMHD", file_buf, len)) < 0)	/* find header data */
		return(0);

	else
		{
		ptr = file_buf+c;								/* point to header struct */

		if	((c=do_header(ptr)) == NULL)
			return(0);
		}

	if	((c=find("CMAP", file_buf, len)) < 0)	/* find cmap data */
		return(0);
	else
		{
		ptr = file_buf+c;								/* point to cmap struct */

		if	((c=do_cmap(ptr)) == NULL)
			return(0);
		}

	if	((c=find("BODY", file_buf, len)) < 0)	/* find body data */
		return(0);
	else
		{
		ptr = file_buf+c;								/* point to body struct */

		if	((c=do_body(ptr)) == NULL)
			return(0);
		}

	return(-1);
}

/****************************************************************************/

long
find(char str[], char buf[], int len)
{
	int	i,j = 0;

	for	(i=0; i <= len; i++)
		{
		if	(str[j] == '\0')
			return(i);					/* found string */

		if	(str[j] != buf[i])
			{
			if	(j != 0)
				i--,j=0;
			}

		else
			j++;
		}

	return(-1);
}

/****************************************************************************/

int
do_header(char *ptr)
{

	long		chunk;
//	char		*clr;
	struct 	iff_bmhd *p;

	chunk	= getlong(ptr);
	ptr += 4;

	p	=	(IFF_BMHD *)ptr;

	ps.mask	= (*p).iff_mask;
	ps.comp	= (*p).iff_comp;
	ps.d		= (*p).iff_nplanes;
	ps.w		= getword((char *)&p->iff_w);
	ps.w 		= (ps.w+1)/2*2;
	ps.h		= getword((char *)&p->iff_h);

	if ((ps.ptr = (char *)AllocMem(ps.w*ps.h)) == NULL)
		return(0);

//	clr	=	ps.ptr;

//	for (i = 0; i <= (ps.w * ps.h); i++)
//		*clr++ = 0;

	return(chunk);
}

/****************************************************************************/

int
do_cmap(char *ptr)
{

	long		chunk;
	int		i;
	char		*cols = &ps.pal;

	chunk = getlong(ptr);
	ptr += 4;

	for	(i = 0; i < chunk; i++)
		cols[i] = ptr[i]>>2;

	return(chunk);
}

/****************************************************************************/

int
do_body(char *ptr)
{

	long		chunk;

	chunk = getlong(ptr);
	ptr += 4;

		if (ps.type == 0)
			{
			if	(ps.comp != 0)
				decomp_planes(ptr);
			else
				raw_planes(ptr);
			}
		else
			if	(ps.comp != 0)
				decomp_bytes(ptr);
			else
				raw_bytes(ptr);

	return(chunk);
}

/****************************************************************************/

void
decomp_planes(char *ptr)
{

	int	d, h;
	char	*tmp = malloc(ps.w);
	char	*scrn = ps.ptr;

	ps.w = ((ps.w+15)&-1-15);		/* divisible by bytes */

	for	(h = 0; h < ps.h; h++)
		{
		for	(d = 0; d < ps.d; d++)
			{
			ptr = decomp_row(ptr, scrn, ps.w/8);
			scrn += ps.w/8;			/* decomp bit plane NOT bytes */
			}
		if	(ps.mask == 1)
			ptr = decomp_row(ptr, tmp, ps.w/8);	/* skip mask bit plane */
		}

	bit_byte(tmp);
	free(tmp);

	return;
}

/****************************************************************************/

char	*
decomp_row(char *ptr, char *scrn, int w)
{
	int	c;

	while	(w > 0)
		{
		c = *ptr++;

		if	(c >= 0 && c <= 127)
//			for (c += 1; c != 0; c--)
//				*scrn++ = *ptr++, w--;

//******** optimised by dave 4-12-95 **************

			  {memcpy(scrn,ptr,c+1);
				w-=c+1;
			 	scrn+=c+1;
				ptr+=c+1;
			  }


//******** optimised by dave 4-12-95 **************

		else if (c != 128)
			{
			 memset(scrn,*ptr++,256-c+1);
			 scrn+=256-c+1;
			 w-=(256-c+1);
			}

//			for (c = (256-c)+1, f = *ptr++; c != 0; c--)
//				*scrn++ = f, w--;
		}

	return(ptr);
}

/****************************************************************************/


void
bit_byte(char *tmp)
{

	short	c;
	int	i, j;
	char	*p, *src=ps.ptr;

	for (i = 0; i < ps.h; i++)
		{
		p = tmp;										/* point to tmp array */

		for (j = 0; j < (ps.w/8); j++)
			{
			*p++=(c=(grab_byte(src, 7)) >> 7);
			*p++=(c=(grab_byte(src, 6)) >> 6);
			*p++=(c=(grab_byte(src, 5)) >> 5);
			*p++=(c=(grab_byte(src, 4)) >> 4);
			*p++=(c=(grab_byte(src, 3)) >> 3);
			*p++=(c=(grab_byte(src, 2)) >> 2);
			*p++=(c=(grab_byte(src, 1)) >> 1);
			*p++=(c=(grab_byte(src, 0)) >> 0);
			*src++;
			}

		p = tmp;										/* point to tmp array */
		src -= (ps.w/8);
		for (j = 0; j < ps.w; j++)
			*src++ = *p++;							/* copy tmp array back to scrn */
		}

	return;
}

/****************************************************************************/

short
grab_byte(char *src, int bit)
{

	short	b,c=0,d;

	b		=	1<<bit;

	d		=	*((src) + ((ps.w/8)*7)) & b;
	c		=	(c << 1) | d;
	d		=	*((src) + ((ps.w/8)*6)) & b;
	c		=	(c << 1) | d;
	d		=	*((src) + ((ps.w/8)*5)) & b;
	c		=	(c << 1) | d;
	d		=	*((src) + ((ps.w/8)*4)) & b;
	c		=	(c << 1) | d;
	d		=	*((src) + ((ps.w/8)*3)) & b;
	c		=	(c << 1) | d;
	d		=	*((src) + ((ps.w/8)*2)) & b;
	c		=	(c << 1) | d;
	d		=	*((src) + ((ps.w/8)*1)) & b;
	c		=	(c << 1) | d;
	d		=	*src & b;
	c		=	(c << 1) | d;

	return(c);
}
/****************************************************************************/

void
raw_planes(char *ptr)
{

	char	*tmp = malloc(ps.w);
	int	d, h, w;
	char	*scrn = ps.ptr;

	ps.w = (((ps.w+7)/8)*8);		/* divisible by bytes */

	for	(h = 0; h < ps.h; h++)
		{
		for	(d = 0; d < ps.d; d++)
			{
			for (w = 0; w < (ps.w/8); w++)
				*scrn++ = *ptr++;
			}
		if	(ps.mask == 1)
//			for (w = 0; w < (ps.w/8); w++)
//				*scrn++ = *ptr++;
				ptr += ps.w/8;
		}

	bit_byte(tmp);
	free(tmp);

	return;
}

/****************************************************************************/

long
getlong(char *ptr)
{
	return	((ptr[0]<<24)|(ptr[1]<<16)|(ptr[2]<<8)|(ptr[3]));
}

/****************************************************************************/

short
getword(char *ptr)
{
	return	((ptr[0]<<8)|(ptr[1]));
}

/****************************************************************************/

void
decomp_bytes(char *ptr)
{

	int	h;

	char	*scrn = ps.ptr;
	char	*tmp = malloc(ps.w);

	for	(h = 0; h < ps.h; h++)
		{
		ptr = decomp_row(ptr, scrn, ps.w);
		scrn += ps.w;

		if	(ps.mask == 1)
			ptr = decomp_row(ptr, tmp, ps.w);	/* skip mask */
		}

	free(tmp);

	return;
}

/****************************************************************************/

void
raw_bytes(char *ptr)
{

	int	h, w;
	char	*scrn = ps.ptr;

	for	(h = 0; h < ps.h; h++)
		{
		for (w = 0; w < ps.w; w++)
			*scrn++ = *ptr++;

		if	(ps.mask == 1)
//			for (w = 0; w < ps.w; w++)
//				*scrn++ = *ptr++;
				ptr += ps.w;
		}

	return;
}

/****************************************************************************/

void
swaplong(char *ptr)
{
	char	a,b,c,d;

	a = ptr[0];
	b = ptr[1];
	c = ptr[2];
	d = ptr[3];

	ptr[3] = a;
	ptr[2] = b;
	ptr[1] = c;
	ptr[0] = d;

	return;
}

/****************************************************************************/

void
swapword(char *ptr)
{
	char	a,b;

	a = ptr[0];
	b = ptr[1];

	ptr[1] = a;
	ptr[0] = b;

	return;
}

