/**************************************************************************


 	Program			:			Shellshock front end
 	Programmer		:			David Long
	Date				:
	Last modified	:

	Comments			:
	Notes				:			See pc.c,frmain.c


***************************************************************************/


#include "iff.h"
#include <stdio.h>
#include "typedefs.h"
#include "frontend.h"

#ifdef PC_VERSION

#include "shell.h"
#include "types.h"
#include "rad.h"
#include "smack.h"
#include "dosext.h"
#include "radmal.i"
#include "svga.h"
#include "timer.h"

#else

#include "headers.h" /* Platform specific header files */
#include "chuck.h"

#endif

#include "frontdef.h"
#include "frglobs.h"

#ifdef PC_VERSION
char packbuff[SCREEN_WIDTH*SCREEN_HEIGHT];
#else
char *packbuff = (char *)block_data;
#endif


int sfactor=1;
int mindex;

/************************************************************************/
/********************                               *********************/
/********************         MENU FUNCTIONS        *********************/
/********************                               *********************/
/************************************************************************/

		/*****************************************************
		 *																	  *
		 *			Menu selection using the mouse				  *
		 *			(pc only)											  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


#ifdef PC_VERSION

short menu_mousetest(MENU *m)
{int i,xs;

 if(mbut&1)
	{
	 for(i=0;i<m->nitems;i++)
		{
		 if(!(m->items[i].flags & DISABLED) )
			{
    	 	 if(m->items[i].flags & SELECTORBOX)
				xs=m->items[i].x-24;
 	 	 	 else
				xs=m->items[i].x;
       	 if( mx>=xs && mx< m->items[i].x+stringlen(m->items[i].txt[game_data.lang]) )
		   	{if(my>=m->items[i].y && my<m->items[i].y+8)
					return i;
				}
			}
   	}
	}
 return -1;
}

#endif

		/*****************************************************
		 *																	  *
		 *			Menu selection handler							  *
		 *			Udates current menu item						  *
		 *																	  *
		 *			Returns:												  *
		 *				returns menu item selected or -1;		  *
		 *																	  *
		 *****************************************************/


/******************* MODIFIED 22-1 ***************************/

int menu_selector(MENU *m)
{int i;

 if(!(m->flags&LOCKOUTUSER))
  {switch(ctrlval)
  	 {
		case CTRL_UP:
			do	
	  			{if(--m->curritem<0)
	  				m->curritem=m->nitems-1;
				}while(m->items[m->curritem].flags&DISABLED);
	  		return -1;
		case CTRL_DOWN:
	  		do		
				{if(++m->curritem==m->nitems)
	  				m->curritem=0;
				}while(m->items[m->curritem].flags&DISABLED);
	  		return -1;
		case CTRL_SELECT:
#ifdef CON_VER
	  	   return m->curritem;
#endif

#ifdef PC_VERSION

   		i=menu_mousetest(m);
   		if(i>=0)
				{m->curritem=i;
	 	 		return i;
				}
			else
   			if(!(mbut&1))
					{
		 			 key=0;
					 return m->curritem;
					}
			return -1;
#endif
	 }
  }
 return -1;
}

/**************************************************************/



		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Draw a menu 										  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void print_menu(MENU *m)
{int i;
 uchar c,*s;

 set_col(252);

/* print title */

 if(m->title)
 	sprint(m->title[game_data.lang],m->tx,m->ty);

 for(i=0;i<m->nitems;i++)
	{
	 	 if(i==m->curritem)
			set_col(255);
		 else if(m->items[i].flags&DISABLED)
			set_col(248);
		 else
			set_col(253);
	 sprint(m->items[i].txt[game_data.lang],m->items[i].x,m->items[i].y);
	 if(m->items[i].flags & SELECTORBOX)
		{
	 	 print_char(m->items[i].x-23,m->items[i].y,1);
	 	 print_char(m->items[i].x-15,m->items[i].y,m->items[i].flags&SELECTED?2:0);
	    print_char(m->items[i].x- 7,m->items[i].y,3);
		}


#ifdef PC_VERSION

    if(m->items[i].key)
		{c=*m->items[i].key;
    	 if(c)
			{
	 	 	set_col(i==m->curritem ? 255:253);
		 	if(c==K_WAITINPUT)
	    		print_char(m->items[i].x+170,m->items[i].y,'?');
		 	else if(c==K_UNDEF)
	    		print_char(m->items[i].x+170,m->items[i].y,' ');

		 	else
	    		{
			 	if(c>=128)
			 		c-=128;
			 	s=asckeyconv[c-1];
			 	sprint(s,m->items[i].x+170,m->items[i].y);
				}
			}
		}
#endif

	}
}


/************************************************************************/
/********************                               *********************/
/********************         MISC. FUNCTIONS       *********************/
/********************                               *********************/
/************************************************************************/


/************************** MEMORY ALLOCATION  *************************/


		/*****************************************************
		 *																	  *
		 *																	  *
		 *			 Intialise memory alloctaion					  *
		 *			 See FreeAll()										  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void InitMemAlloc()
{
#ifdef PC_VERSION
 mempool_p=(char *)malloc(MEMPOOLSIZE); 				/* allocate block and clear */
#else
 mempool_p=(char *)0x200000L;
#endif
 memset(mempool_p,0,MEMPOOLSIZE);
 mempoolend_p=mempool_p; 						/* init ptrs */
 memres=memused=0;
}
  		/*****************************************************
		 *																	  *
		 *			CD routines											  *
		 *																	  *
		 *																	  *
		 *****************************************************/

void PlayCDTrack(int track)
{
 CDPlay(track);
 cdtrack=track;
 cdstarttime=read_60hztimer();
}

void CDLoopCheck()
{
 if(!cdtrack)
	return;
 if( (read_60hztimer()-cdstarttime)>tracktimes[cdtrack] )
	PlayCDTrack(cdtrack);
}

void StopCDMusic()
{
 CDStop();
 cdtrack=0;
}



  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Get some memory									  *
		 *			Exits if no memory avail.						  *
		 *																	  *
		 *																	  *
		 *****************************************************/


char *AllocMem(int size)
{

#ifdef CONSOLE_VERSION
	if ( size & 3 )
	{
		size |= 3;
		size++;
	}
#endif

 if(memused+size>MEMPOOLSIZE)
	getout("not enough mem");
 mempoolend_p+=size;								/* update free ptr */
 memused+=size;								   /* total allocated mem */
 return mempoolend_p-size;			  			/* return ptr to start of mem */
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Reserve all previously allocated memory	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void ReserveMem()
{
 memres=memused;					  				/* reserve all previously allocated mem */
}														/* (cannot be freed) */


  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Free allocated memory 							  *
		 *			(except reserved memory)						  *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void FreeMem()
{
 memused=memres;
 mempoolend_p=mempool_p+memres;
}

void FreeAll()
{
 free(mempool_p);
}

/************************************************************************/


  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Set reserved top 8 colours						  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void settop8cols(char *pal)
{int i;

 for(i=0;i<24;i++)
	pal[(248*3)+i]=upp8cols[i];
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *									  								  *
		 * 		Allocate memory and load a file 				  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/



char *LoadFile(char *fn,char *type)
{FILE *fp;
 char *mem;
 int n;

#ifdef PC_VERSION
 fp=fopen(fn,type);
 fseek(fp,0,SEEK_END);
 n=ftell(fp);
 fseek(fp,0,SEEK_SET);
 mem=AllocMem(n+1);
 fread(mem,1,n,fp);
 fclose(fp);
 mem[n]=255;
 return mem;
#else
 uint *ptr;
 uint length;

 length = read_length_from_wad(wad_handle, fn, NULL, wad_directory);
 if(!(mem=AllocMem(length) ))
	return NULL;
 mem = read_data_from_wad(wad_handle, fn, mem, wad_directory);
 return mem;

#endif
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *									  								  *
		 * 		Dump screen to video ram		 				  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/

void dump_vram()
{
 char mem[20];
 char c;
 static char script=1;

#ifdef PC_VERSION
#ifdef DEBUG_VERSION



 sprint("MISSION (F1) : ",10,10);
 sprintf(mem,"%d",game_data.mission);
 sprint(mem,120,10);
 sprint("EARSHOT SCRIPT(f5): ",10,20);
 sprintf(mem,"%d",earscript);
 sprint(mem,120,20);
 sprint("DTOUR SCRIPT(f6): ",10,30);
 sprintf(mem,"%d",dtscript);
 sprint(mem,120,30);
 sprint("DOGG SCRIPT(f7): ",10,40);
 sprintf(mem,"%d",dogscript);
 sprint(mem,120,40);
 sprint("NINE SCRIPT(f8): ",10,50);
 sprintf(mem,"%d",ninscript);
 sprint(mem,120,50);

 sprint("MONEY: ",10,60);
 sprintf(mem,"%d",game_data.money);
 sprint(mem,120,60);	  
 sprint("MAINSEL: ",10,70);
 sprintf(mem,"%d",mainsel);
 sprint(mem,120,70);	  
 sprint("ANIMFR: ",10,80);
 sprintf(mem,"%d",animfr);
 sprint(mem,120,80);	  

 if(keydeb(K_F1))
	{
	 if(++game_data.mission==26)
		game_data.mission=1;
	}
 if(keydeb(K_F5))
	{
	 if(++earscript==8)
		earscript=1;
	}
 if(keydeb(K_F6))
	{
	 if(++dtscript==18)
		dtscript=1;
	}
 if(keydeb(K_F7))
	{
	 if(++dogscript==14)
		dogscript=1;
	}
 if(keydeb(K_F8))
	{
	 if(++ninscript==10)
		ninscript=1;
	}
 if(keydeb(K_F3))
	{
	 game_data.money+=500;
	}

#endif
#endif
 dump_screen();
}

/****************** string / character handling functions **************/

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *									  								  *
		 * 		Calc width of font chars in pixels for 	  *
		 *			spacing and centering 							  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void calc_charwidths()
{
 char *src;
 int row,col,len,c,ncp;

 for(c=0;c<256;c++)
	{
	 if(c==0x20)
	    len=fontw-3;
	 else
		{
	 	 ecols=0;
 	 	 ncp=SCREEN_WIDTH/fontw;								// chars per line
 	 	 src=gfont+((c%ncp)*fontw)+((c/ncp)*fonth*SCREEN_WIDTH);
	 	 for(row=0;row<fontw;row++)
	 		{for(col=0;col<fonth;col++)
	 			{if(*(src+col))
	 		 	 ecols|=1<<col;
	 			}
	 	 	 src+=SCREEN_WIDTH;
	 		}
	 	 for(col=fontw-1;col>=0;--col)			// find rightmost edge of char
 		   if(ecols & (1<<col))
				break;
	    len=col+2;
		}
    char_widths[c]=len;
	}

}


  		/*****************************************************
		 *																	  *
		 *																	  *
		 *									  								  *
		 * 		Return length of a string in pixels 		  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


int stringlen(char *s)

{int len;
 char c;

 len=0;
 while(c=*s++)
	len+=char_widths[c];
 return len;
}


  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 	 	Set the current font 							  *
		 *									  								  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void setfont(struct font *f)

{
 gfont=f->chdata;
 fontw=f->w;
 fonth=f->h;
 calc_charwidths();
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Load an iff image font							  *
		 *									  								  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


int load_fontdata(char *f,struct font *fon)

{char *mem;

#ifdef PC_VERSION
 uint length;
 setfn(f);

 if(!(mem=(char *)load_file(fn,NULL) ))
	return FALSE;
 decomp_iff(mem,file_len);
 fon->chdata=ps.ptr;
 free_mem(mem);
 return TRUE;

#else
 uchar *bp_sav;
 uint length;

 setfn(f);
 bp_sav=baseptr;


 length = read_length_from_wad(wad_handle, fn, NULL, wad_directory);
 if(!(mem=AllocMem(length) ))
	return NULL;
 mem = read_data_from_wad(wad_handle, fn, mem, wad_directory);
 file_len = length;

 //if(!(mem=(char *)load_file(fn,NULL) ))
 //	return FALSE;
 decomp_iff(mem,file_len);
 fon->chdata=ps.ptr;
 baseptr = bp_sav;
 return TRUE;

#endif
}


  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Split up a string into smaller strings 	  *
		 *			of size or less 									  *
		 *									  								  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/



void split_string(char *ss,int size)
{int i,j,k,wlen;
 char *s,c;

 for(i=0;i<8;i++)
	strs[i][0]=0;
 nstrs=0;
 for(i=0;;)
	{
	 linelen=0;
	 k=0;
	 for(;;)
		{

/* get length of a word */

		 wlen=0;
		 s=ss;
		 for(;;)
			{
		 	 c=*s++;wlen++;
			 if(c==' ' || c=='\t' || !c)
				break;
			}

/* enough room left for word ? */

		 if((linelen+wlen)>=size)
			{strs[i][k]=0;
			 slens[i]=linelen;
			 goto nexts;
			}

/* yes - store word */

		 for(j=0;j<wlen;j++)
		 	{
		 	 strs[i][k]=*ss++;
			 if(!strs[i][k])
			 	{nstrs++;
				 return;}
			 k++;
   		   }
		 linelen+=wlen;
		}
nexts:
	i++;
   nstrs++;
	}
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Semi - trans text bar 							  *
		 *									  								  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/



void print_textbar(char *txt,int w,int y)
{int i;

 if(!txt)
	return;
 if(w<0)
 	i=stringlen(txt);
 else
	i=w;
 disp_transbox(160-(i/2)-8,y-1,i+16,11);
 set_col(255);
 sprint(txt,160-(i/2)+1,y);
}


  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Print a string  									  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/



void sprint(char *s,int x,int y)

{char c;

 while(c=*s++)
 	x+=print_char(x,y,c);
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Print in reverse 									  *
		 *									  								  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/



void sprint_rev(char *s,int x,int y)

{char c;
 int i;

 i=strlen(s)-1;
 for(;i>=0;--i)
	x-=print_char(x,y,s[i]);
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Print a number 									  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void printnum(int n,int x,int y)
{char s[40];

 sprintf(s,"%d",n);
 sprint(s,x,y);
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Print a number in reverse						  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void printnum_rev(int n,int x,int y)
{char s[40];

 sprintf(s,"%d",n);
 sprint_rev(s,x,y);
}

/*************************************************************************/



  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Test for point inside rect 					  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/



int box_test(RECT *r,int x,int y)

{if(x<r->x || x>r->x1 || y<r->y || y>r->y1)
 	return FALSE;
 return TRUE;
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Set graphics file path 							  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/



void setfn(char *s)

{
 strcpy(fn,gpath);
 strcat(fn,s);
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Load an iff image 								  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/



int load_iffimage(char *fn,struct img *im,char *pal)

{char *mem;

#ifdef PC_VERSION


 if(!(mem=(char *)load_file(fn,NULL) ))
	return FALSE;
 decomp_iff(mem,file_len);
 free_mem(mem);
 im->data=ps.ptr;
 im->w=ps.w;
 im->h=ps.h;
  im->x=im->y=0;
 if(im->pal=pal)
	 memcpy(pal,ps.pal,256*3);
 return TRUE;

#else
 uchar *bp_sav;
 uint length;

 bp_sav = baseptr;


 length = read_length_from_wad(wad_handle, fn, NULL, wad_directory);
 if(!(mem=AllocMem(length) ))
	return NULL;
 mem = read_data_from_wad(wad_handle, fn, mem, wad_directory);
 file_len = length;

 //if(!(mem=(char *)load_file(fn,NULL) ))
 //	return FALSE;
 decomp_iff(mem,file_len);
 baseptr = bp_sav;
 im->data=ps.ptr;
 im->w=ps.w;
 im->h=ps.h;
  im->x=im->y=0;
 if(im->pal=pal)
 {
	memcpy(pal,ps.pal,256*3);
	dump_pal(pal,0,256);
 }

 return TRUE;

#endif

}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Load sprite file	 								  *
		 *			(n,w,h (long ints)followed by raw data)	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/

/*

char *load_sprites(char *fn)

{FILE *fp;
 int nf;
 char *mem;

#ifdef PC_VERSION

 if(!(fp=fopen(fn,"rb") ))
	return NULL;
 fread(&nf,1,4,fp);
 fread(&sw,1,4,fp);
 fread(&sh,1,4,fp);
 if(!(mem=AllocMem(nf*sw*sh) ))
	return NULL;
 fread(mem,1,nf*sw*sh,fp);
 fclose(fp);
 return mem;

#else

 uint *ptr;
 uint length;

 length = read_length_from_wad(wad_handle, fn, NULL, wad_directory);
 if(!(mem=AllocMem(length) ))
	return NULL;
 mem = read_data_from_wad(wad_handle, fn, mem, wad_directory);
 ptr = (uint *)mem;
 nf = swap_lw(*ptr++);
 sw = swap_lw(*ptr++);
 sh = swap_lw(*ptr++);
 return (uchar *)ptr;

#endif

}
*/

  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Get random no from 0 to max 					  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/



int random(int max)
{int n;

 n=rand()&0x7fff;
 return ((n*(max+1))>>15);
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Get random no from 0 to max 					  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


/* get random number in range min to max */

int randomr(int min,int max)
{int n;

 n=rand()&0x7fff;
 return (n*(max-min+1)>>15)+min;
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Wait for nfr's										  *
		 *									  								  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void wait(int nfr)

{
 if(!nfr)
	 nfr=1;
 while(--nfr)
   ScreenWaitVbl();
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *  		Draw exit sprite 									  *
		 *									  								  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void dispexit()
{
 exsprs->img.x=280;
 exsprs->img.y=160;
 exsprs->img.w=38;
 exsprs->img.h=36;
// anim->img.data=exsprs+(36*34*(exfr/4));
 draw_anim_frame(exsprs,exfr/4);
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Animate exit sprite 								  *
		 *									  								  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void anim_exit()
{
	if(exanim)
		{exfr+=4;
		 if(exfr==48)
			{exfr=0;exanim=0;
          exitflg=TRUE;
			}
		}
}


void start_exanim()
{
 if(!exanim)
 	{exfr=0;
 	 exanim=1;
 	}
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Move cursor routines 							  *
		 *			Move cursor using vector equation of a		  *
		 *			line													  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void init_cursmove()
{

 if(curmov || noptions==1)
	return;
 dstmx=((opareas[mainsel].x1-opareas[mainsel].x)/2)+opareas[mainsel].x;
 dstmy=((opareas[mainsel].y1-opareas[mainsel].y)/2)+opareas[mainsel].y;
 mdx=dstmx-mx;	 										/* dx,dy */
 mdy=dstmy-my;
 mbx=mx;													/* start x,y */
 mby=my;
 mstep=0;												/* n ( varied from 0 to 32767) */
 curmov=1;
}


void move_cursor()
{int xadd,yadd;

 if(!curmov)
	return;
 xadd=(mstep*mdx)>>15;								/* x+=xs+n*dx */
 yadd=(mstep*mdy)>>15;
 mx=mbx+xadd;
 my=mby+yadd;
 my+=sintab[mstep/32]>>12;							/* 'curve it' man */
 mx+=sintab[mstep/32]>>12;
 mstep+=2048;
 if(mstep>32768)						 				/* done (n=1) */
	curmov=0;
}

void disp_cursor()
{

 if(mx>(SCREEN_WIDTH-cursim.w+1))
	mx=SCREEN_WIDTH-cursim.w+1;
 if(my>(SCREEN_HEIGHT-cursim.h))
	my=SCREEN_HEIGHT-cursim.h;
 cursim.x=mx;
 cursim.y=my;
 copy_spr(&cursim);

}


  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Initialise various variables					  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void init_vars()
{
 anim=0;
 frame=0;
 nstrs=0;
 scoff=0;
 ctrlval=0;
 animfr=0;
 selected=FALSE;
 exitflg=FALSE;
 exanim=exfr=0;
 mainsel=noptions-1;
 mx=((opareas[noptions-1].x1-opareas[noptions-1].x)/2)+opareas[noptions-1].x;
 my=((opareas[noptions-1].y1-opareas[noptions-1].y)/2)+opareas[noptions-1].y;
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Draw a box using line draw						  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void lbox(int x,int y,int x1,int y1,char hc,char c)

{
 if( ((x1-x)<=0) || ((y1-y)<=0) )
	return;
 hline(x,y,(x1-x)+1,hc);
 hline(x,y1,(x1-x)+1,c);
 vline(x,y,(y1-y)+1,hc);
 vline(x1,y,(y1-y)+1,c);
}


  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Draw '3d' transparent box						  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void disp_3d_transbox(int bx,int by,int bw,int bh)
{
 disp_transbox(bx,by,bw,bh);
 lbox(bx,by,bx+bw,by+bh,253,248);
}

void disp_pic()
{
 dispexit();
 disp_cursor();
 dump_vram();
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Menu box expansion functions 					  *
		 *			(width MUST be > height) 						  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void do_box_screen(void (*disp_func)(),int x,int y,int w,int h)
{
 memcpy(scrptr,backim.data,SCREEN_WIDTH*SCREEN_HEIGHT);
 if(disp_func)
 	disp_func();
 disp_transbox(x,y,w,h>>8);
 lbox(x,y,x+w,y+(h>>8),253,248);

#ifdef PC_VERSION
 dispexit();
 disp_cursor();
#endif
 dump_vram();
}

/* menu box expansion functions (width MUST be > height) */

void expand_3d_transbox(int bx,int by,int bw,int bh,void (*disp_func)())
{
// int x,y,w,h,frac;

// disp_pic();
// w=1;
// h=1;
// if(bw>bh)
//	{
//    h=h<<8;
//	 frac=(bh<<8)/bw;									/* h/w */
//	 for(;w<bw;w+=8)
//		{
// 		 x=bx+(bw/2)-(w/2);						 	/* position it */
// 		 y=by+(bh/2)-((h>>8)/2);
//		 do_box_screen(disp_func,x,y,w,h);
//		 h+=(frac*8);
//		}
//	}
// else
//	{
//	}

}

void contract_3d_transbox(int bx,int by,int bw,int bh,void (*disp_func)())
{
// int x,y,w,h,frac;
//
// 
// w=bw;
// h=bh;
// if(bw>bh)
//	{
//    h=h<<8;
//	 frac=(bh<<8)/bw;
//	 for(;w>=0;w-=8)
//		{
// 		 x=bx+(bw/2)-(w/2);
// 		 y=by+(bh/2)-((h>>8)/2);
//		 do_box_screen(disp_func,x,y,w,h);
//		 h-=(frac*8);
//		 if(h<0)h=0;
//		}
//	}
// else
//	{
//	}
//
//  do_box_screen(disp_func,x,y,0,0);

}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Animate a sequence of frames 					  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void animate(int strt,int end,int frate)
{int inc=1;

 if(end<strt)
	inc=-1;
 do
	{
	 if(exitflg==TRUE)
		return;
	 set_frame(strt);
	 wait_loop(frate);
	 strt+=inc;
	}while(strt!=end);
}

void animate1(int fr,int frate)
{
 set_frame(fr);
 wait_loop(frate);
}

  		/*****************************************************
		 *																	  *
		 *														  			  *
		 * 	Display a status bar						 			  *
		 * 	v1 - value to display (1 unit displayed		  *
		 *		represents a value of 8) from						  *
 	  	 * 	0 to v2 (v2 must be in units );					  *
 		 * 	maxv  - maximum value possible (in units )	  *
 		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void disp_statbar(int xp,int yp,int maxv,int v1,int v2)
{
 int i,x,c,nunits;

 nunits=v1/8;
 c=getcol();

 set_col(249);

 for(x=xp,i=0;i<maxv;i++,x+=8)
	print_char(x,yp,5);
 set_col(250);
 for(x=xp,i=0;i<v2;i++,x+=8)
	print_char(x,yp,5);
 set_col(252);
 x=xp;
 for(i=0;i<nunits;i++,x+=8)
	print_char(x,yp,14);
 print_char(x,yp,6+(v1%8));
 set_col(c);
}

  		/*****************************************************
		 *																	  *
		 *														  			  *
 		 *		Draw horizontal slider bar 						  *
 		 *		val (0-32760)											  *
 		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/



void disp_vslider(int xpos,int y,int val)
{int i,x;

 set_col(253);
 for(i=0,x=xpos;i<10;i++)
	{print_char(x,y,4);
    x+=8;
   }
 set_col(252);
  for(i=0,x=xpos;i<val;i++)
	{print_char(x,y,2);
    x+=8;
   }
}

		/*****************************************************
		 *																	  *
		 *																	  *
		 * 	Insert key value into ctrl array for 			  *
		 *		standard\dual-track setup in game_data			  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/

#ifdef PC_VERSION

/* insert key value into ctrl array */

int set_keyconfig(int func,char key)
{int i;
 char *p;

/* keys 1-6 reserved */

 if(key>=K_1 && key<=K_6)
	return -1;

/* key already used ? If so set as undefined (K_UNDEF) */

 p=game_data.ctrldev?game_data.dualksetup:game_data.normksetup;

/*********************** MODIFIED 12-1-96 ************************/

 for(i=0;i<NKEYSUSED;i++)

/*****************************************************************/
	{
    if(p[i]==key)
 		{p[i]=K_UNDEF;
		 break;
		}
	}
 p[func]=key;
 return 0;
}

#endif

		/*****************************************************
		 *																	  *
		 *			Load images that remain in memory all		  *
		 *			the time.											  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/

void load_resident_stuff()
{
 setfn("curs.bbm");
 load_iffimage(fn, &cursim, NULL);
 load_fontdata("font1.lbm",&font1);
 font1.w=8;
 font1.h=8;
 setfont(&font1);
 setfn("exit.cmp");
 exsprs=load_sprites(fn);
 exsprs->type=1;
 ReserveMem();
}

		/*****************************************************
		 *																	  *
		 *			screen update routine					  		  *															  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void main_display()

{struct img img;

 memcpy(scrptr,backg,SCREEN_WIDTH*SCREEN_HEIGHT);						/* background */
 if(animd)													/* copy a sprite */
  {
   animd->img.x=sprx;
   animd->img.y=spry;
	draw_anim_frame(animd,frame);
  }
 if(mainsel<noptions)						 			/* option text bar */
 	print_textbar(optxts[mainsel],-1,180);
 dispexit();					 							/* exit sprite */
 disp_cursor();
 dump_vram();
}


#ifdef PC_VERSION

int keydeb(int key)
{
 static int keydown;

 if(rawkey(key))
	{
	 if(key==keydown)
		return FALSE;
	 keydown=key;
	 return TRUE;	
	}
 if(keydown==key)
	keydown=0;
 return FALSE;
}

#endif


		/*****************************************************
		 *																	  *
		 *		 Wait for a number frames.							  *
		 *		 Updates the option selected,reads joypad,	  *
		 *		 moves the cursor.									  *
		 *		 Also calls user defined routine 				  *
		 *		 and screen update while waiting.				  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/

void wait_loop(int nfr)

{int i;
 int nf,n;

  nf=read_60hztimer();
  for(;;)
	{
    read_joypad();
	 if(noptions)
    	{
	  	 move_cursor();

/* next\previous screen selection area */

	  	 switch(ctrlval)
	 		{
	  	 	 case CTRL_LEFT:
	  	 	 case CTRL_UP:
	 			if(!curmov)
	 				{--mainsel;
	 		 		 if(mainsel<0)
	 	 				mainsel=noptions-1;
 	 		 		 init_cursmove();
	 				}
	 			break;
	  	 	 case CTRL_RIGHT:
	  	 	 case CTRL_DOWN:
	 			if(!curmov)
	 				{mainsel++;
	 		 		 if(mainsel>=noptions)
	 	 				mainsel=0;
        	 		 init_cursmove();
	 				}
	 			break;
	 		}
	  	}


#ifdef PC_VERSION

/* pc mouse code - tests if cursor is in a hangar area */

	 for(i=0;i<noptions;i++)
	 	{if(TRUE==box_test(&opareas[i],mx,my))
	 		{mainsel=i;											/* yep */
	     	 break;
	 		}
	 	}
	 if(i==noptions)									 		/* no, set to -1 */
	 	mainsel=-1;

#endif

	n=read_60hztimer();
	if(disp_func_p)
		disp_func_p();				 					 		/* screen update */
	framecnt=read_60hztimer()-n;
	ctrl_func_p();											 	/* background func */
	if(exitflg==TRUE)
		break;
	if(ctrlval==CTRL_CANCEL )
		{
		 exitflg=TRUE;
	 	 ctrlval=0;
	 	 break;
		}
 	if((read_60hztimer()-nf)>=nfr)
		break;

  }

#ifdef PC_VERSION

 CDLoopCheck();

#endif


}


/**************************************************************************/
/*************************                        *************************/
/************************* SCRIPT FILE PROCESSING *************************/
/*************************                        *************************/
/**************************************************************************/

		/*****************************************************
		 *																	  *
		 *																	  *
		 * 	Read a line from script file into linebuff	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/

/* read a line from script file into linebuff */

int get_line()
{uchar c;

 linelen=0;
 for(;;)
	{
	 c=(char)scriptmem[scoff++];							/* get char */
    if(c=='*' || c=='#')							/* commment - */
		{
		 for(;;)
			{
			 c=scriptmem[scoff++];					/* read to end of line */
			 if(c==0x0a || c==0x0d)
				{linebuff[linelen]=0;
				 return 0;
				}
			}
		}
	 else if(c==0x0a || c==0x0d)		  							/* eol ?*/
		break;
    linebuff[linelen++]=c;							/* add char to buff */
	}
 linebuff[linelen]=0;
 return 0;
}

		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Translate command string into command no.	  *
		 *			returns -1 if command is unknown.			  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


int interpret_command()
{char c;
 int j;

 for(linepos=0;;)										/* get end position of comm */
 	{c=linebuff[linepos];
	 if(c==' ' || c=='\t' || c==0)
		break;
     linepos++;
	 }

/* is comm valid ? */

 if(!linepos)return -1;
 for(j=0;j<nSCOMMS;j++)
 	{if(!memcmp(linebuff,commstrs[j],linepos))
		break;
	}
 if(j==nSCOMMS)
	return -1;
 return j;
}

		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Get a command line argument.					  *
		 *			(separated by spc's tab's or ,) 				  *																  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void get_commarg()
{char c;

/* skip leading spaces /tabs */

 for(;;linepos++)
 	{
	 c=linebuff[linepos];
 	 if(c!=' ' && c!='\t')
		break;
	}

/* get argument */

 for(arglen=0;;)
	{
	 c=linebuff[linepos];
	 if(c=='"')				  								/* read a string */
		{linepos++;
		 while((c=linebuff[linepos++])!='"')
			argbuff[arglen++]=c;
       argbuff[arglen]=0;
       return;
		}
    if(c==0 || c==' ' || c==',' || c=='\t')		/* done */
		{argbuff[arglen++]=0;linepos++;return;}
	 argbuff[arglen++]=c;							 	/* add char */
    linepos++;
	}
}
		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Load a script file into mem 					  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/



char *load_script_file(char *fn)
{
 char *mem;
 char filen[50];

#ifdef JAP_VERSION
 strcpy(filen,tpaths[3]);
#else
 strcpy(filen,tpaths[game_data.lang]);
#endif
 strcat(filen,fn);
 mem=LoadFile(filen,"r");
 scriptmem=mem;
 return mem;
}

		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Load a sample					 					  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/

void load_sample()
{char *fnp;

 get_commarg();
 strcpy(fn,spath);
#ifdef JAP_VERSION
 strcat(fn,tpaths[3]);
#else
 strcat(fn,tpaths[game_data.lang]);
#endif
 strcat(fn,argbuff);
 fnp=fn;
 SoundLoadSamples(&fnp,1);
 boff=0;
}

		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Read a line of text and split into 			  *
		 *			subtitle strings 									  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void get_subtitles()
{int i;
 char c;

 i=0;
 text[0]=0;

/* read in a line */

 for(;;)
	{c=linebuff[linepos++];
	 if(c==0x0a || c==0x0d)
		{text[i]=0;break;}
    if(i>=2048)
		break;
	 text[i++]=c;
	}

/* split it up strings of max. length maxsubw chars */

 split_string(text,maxsubw);
}

		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Display subtitle strings 		 			  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void disp_subs()
{int i,y,x,lenmax;

 if(!game_data.subtitl)
	return;
 set_col(255);
 if(nstrs==1)											/* 1 line */
 	 print_textbar(strs[0],-1,188);
 else
	{
	 lenmax=0;
    for(i=0;i<nstrs;i++)							/* find widest string */
		{
		 x=stringlen(strs[i]);
    	 if(x>lenmax)
			lenmax=x;
		}
 	 disp_transbox(160-(lenmax/2)-2,198-(nstrs*10),lenmax+4,nstrs*10);
 	 for(i=nstrs-1,y=188;i>=0;--i,y-=10)		/* print each string */
 		{
	 	 if(strs[i][0])
 	 		{
		 	 x=160-(stringlen(strs[i])/2);
		 	 if(x<0)
				{sprint("ERROR",x+100,y);return;}
	 	 	 sprint(strs[i],x,y);
			}
	   }
	}
}

/****************** speech script file select and  loaders ****************/

/* scan a sample for gaps in speech

void scan_sample(int s)
{SampleInfo si;
 short *p;
 int i,j,total,ingap;

 SoundGetSampleInfo(s,&si);
 p=(short *)si.pData;

 ingap=gapstart=scansizes[s]=0;
 nvolblks=si.dwBytes/1024;
 for(i=0;i<nvolblks;i++)
	{for(j=0,total=0;j<512;j++)
		total+=abs(*p++);
    if(total/512<50)
		{
		 if(!ingap)
			{ingap=1;
			 gapstart=i;
			}
		}
	 else
		{
		 if(ingap)
			{ingap=0;
			 scantbles[s][scansizes[s]].start=gapstart;
			 scantbles[s][scansizes[s]].size=i-gapstart;
			 scansizes[s]++;
			}
		}
	}
}


int gaptest(int samp)
{int i;

 for(i=0;i<scansizes[samp];i++)
	{if(boff/1024>=scantbles[samp][i].start && boff/1024 <=scantbles[samp][i].start+scantbles[samp][i].size)
  		return i;
	}
 return -1;
}
*/


/**********************************************************************/
/**********************                     ***************************/
/********************** CHARACTER ANIMATION ***************************/
/**********************                     ***************************/
/**********************************************************************/


		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Change the stance of a character			  *
		 *																	  *
		 *																	  *
		 *****************************************************/



void change_manpos()
{
 int j;

   switch(movem)
	 {
	 case 0:
		for(j=0;j<=3;j++)
			{boff=SoundSamplePosition(shandle)*4;
		 	 animate1(j,4);
			}
		movem=random(1)+1;stance=1;
		break;
 	 case 1:
		for(j=3;j>=0;--j)
			animate1(j,4);
		movem=stance=0;
			break;
	 case 2:
		for(j=3;j<=7;j++)
			animate1(j,4);
		movem=3;stance=2;
		break;
	 case 3:
		for(j=7;j>=3;--j)
			animate1(j,4);
		movem=random(1)+1;stance=1;
		break;
	}
}

		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Animate character's lips 					  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void animlips()
{int f;

  wait_loop(1);
  if(--animfc<0)
	{
	 animfc=6-framecnt;
	 if(animfc<=0)
	  	animfc=1;
 	 f=mouth_frms[animfr];
 	 if(f<4)
	 	set_frame(f+(stance*4)+8);
 	 else
		set_frame(stfrs[stance]);
 	 animfr++;
 	 if(animfr>=18)
 		animfr=0;
	}
}
  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Animate a man talking							  *
		 *																	  *
		 *																	  *
		 *****************************************************/



// In the foreign language versions there are no pauses in the speech
// and the subtitles don't match up too well


void mansay_foreign()
{int i,n,ptemp,nf,subtime;

 CDStop();
 load_sample();											/* load and play */
 shandle=SoundPlaySample(0,game_data.soundvol,100,0x8000);
 for(;;)
	{
    get_line();
	 if(linelen)
		{
		 n=interpret_command();
		 switch(n)
	 	 	{
			 case SCOM_CHARTXT:
		   	set_subtitle_width(52);					/* grab subtitles */
				get_subtitles();
				subtime=strlen(text)*4;
				nf= read_60hztimer();
				for(;;){				  		
					if(SoundIsDIGIInstalled() && !SoundSampleIsPlaying(shandle) )
						break;
					animlips();
					SoundStreamUpdate(shandle);
					if((read_60hztimer()-nf)>subtime)
						break;
					if(exitflg==TRUE)
						{SoundStopAllSamples();return;}
				  }
				break;
			 case SCOM_SAMPGAP:							/* if last arg 0 waits for end of sample */
				get_commarg();
				gpb=atoi(argbuff);
				get_commarg();
				gpe=atoi(argbuff);
				if(!gpe)
					{
					 for(;;)
					 	{animlips();
						 SoundStreamUpdate(shandle);
						 if(SoundIsDIGIInstalled())
							{if(!SoundSampleIsPlaying(shandle) )
								return;
							}
						 else
						 	return;
						 if(exitflg==TRUE)
						  {SoundStopAllSamples();return;}
						}
				  	}
			   break;
			}
		}
	}
}




void mansay()

{int n,ptemp;

#ifdef JAP_VERSION
 mansay_foreign();
 return;
#endif

 StopCDMusic();
 load_sample();											/* load and play */
 shandle=SoundPlaySample(0,game_data.soundvol,100,0x8000);
 for(;;)
	{
    get_line();
	 if(linelen)
		{
		 n=interpret_command();
		 switch(n)
	 	 	{
			 case SCOM_CHARTXT:
		   	set_subtitle_width(52);					/* grab subtitles */
				get_subtitles();
				break;
			 case SCOM_SAMPGAP:							/* wait for a gap and animate lips */
				get_commarg();
				gpb=atoi(argbuff);
				get_commarg();
				gpe=atoi(argbuff);
				do{
					get_sample_position();
					if(exitflg==TRUE)
						{SoundStopAllSamples();return;}
					animlips();
				  }while(boff<gpb);

   			ptemp=SoundPauseSample(shandle);
				change_manpos();							/* change stance */
				SoundUnpauseSample(shandle,ptemp);
				if(!gpe)
					 return;
				do{											/* wait for end of gap/sample */
					get_sample_position();
				  }while(boff<gpe && boff);
				break;
			}
		}
	}
}


		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Animate a character from script file	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void animate_man()
{

 get_line();
 interpret_command();
#ifdef CONSOLE_VERSION
 close_wad(wad_handle);
 mansay_foreign();
 close_cinepak();
 reinit_filesys();
#else
 if(game_data.lang)
	 mansay_foreign();
 else
	 mansay();
 return;
#endif
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Animation a conversation between	  			  *
		 *			2 characters while one character is			  *
		 *			talking.
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void animmouth()
{int f;

 if(--animfc<0)
	{
	 animfc=6-framecnt;
	 if(animfc<=0)
		animfc=1;
 	 f=mouth_frms[mindex]; 				/* get mouth frame */
 	 if(f==4)					  				/* 4- mouth closed frame */
 		*tlkfr_p=basefr;
 	 else
 		*tlkfr_p=tlkfrm1+f;				/* mouth frame 0-3 */
 	 if(++mindex==18)
 	 mindex=0;
	}
}

void  animate_conversation_foreign()
{int i,n,f,fc,noddel,subtime;

 shandle=SoundPlaySample(0,game_data.soundvol,100,0x8000);
 mindex=noddel=0;
 for(;;)
	{
    get_line();
	 if(linelen)
		{
		 n=interpret_command();
		 switch(n)
	 	 	{
			 case SCOM_CHARTXT:							/* grab subs */
		   	set_subtitle_width(52);					/* grab subtitles */
				get_subtitles();
				fc=read_60hztimer();
				subtime=strlen(text)*4;					/* subtitle on-screen time frig */
				for(;;)
				  {				  							
					SoundStreamUpdate(shandle);
					if(SoundIsDIGIInstalled() && !SoundSampleIsPlaying(shandle) )
						break;
	 				if(tlkanim!=4)			 				/* talking animation 0-none */
						 animmouth();
					else									 	/* no anim */
					 	*tlkfr_p=basefr;
   				wait_loop(1);
					if(exitflg==TRUE)
						{SoundStopAllSamples();return;}
					if((read_60hztimer()-fc)>subtime)
						break;
				  }
				break;
			 case SCOM_SAMPGAP:	 						/* animate during speech */
				get_commarg();
				gpb=atoi(argbuff);
				get_commarg();
				gpe=atoi(argbuff);
				if(!gpe)
					{for(;;)
						{
	 					 if(tlkanim!=4)			 					/* talking animation 0-none */
							 animmouth();
						 else									 	/* no anim */
						 	*tlkfr_p=basefr;
	 					 wait_loop(1);
						 if(exitflg==TRUE)
							{SoundStopAllSamples();return;}
						 SoundStreamUpdate(shandle);
						 if(SoundIsDIGIInstalled())
							{if(!SoundSampleIsPlaying(shandle) )
								{*tlkfr_p=basefr;return;}
							}
						 else
							return;
						}
				   }
			}
		}
	}
}



void  animate_conversation()
{int n,f,mindex,noddel,lsttimer;

#ifdef JAP_VERSION
animate_conversation_foreign();
 return;
#endif

 shandle=SoundPlaySample(0,game_data.soundvol,100,0x8000);
 mindex=noddel=lsttimer=0;
 for(;;)
	{
    get_line();
	 if(linelen)
		{
		 n=interpret_command();
		 switch(n)
	 	 	{
			 case SCOM_CHARTXT:							/* grab subs */
		   	set_subtitle_width(52);
				get_subtitles();
				break;
			 case SCOM_SAMPGAP:	 						/* animate during speech */
				get_commarg();
				gpb=atoi(argbuff);
				get_commarg();
				gpe=atoi(argbuff);
				do{
				   wait_loop(1);
					get_sample_position();	  			/* offset in sample  */
	 				if(tlkanim!=4)			 					/* talking animation 0-none */
				  		 animmouth();
					else									 	/* no anim */
						*tlkfr_p=basefr;
					if(++lsttimer==8)
						{lsttimer=0;
	 					if(lstanim==5 || !lstanim)			/* anim 0 or 5 - random movement of listener's head */
							{if(!random(15))
	 				 	  	 *lstfr_p=random(2)+8;
						 	}
						else if(lstanim==6)			 		/* 6 - nod animation */
							{if(!noddel)						/* gap between anims */
						 		{--(*lstfr_p);
						 	 	if(*lstfr_p<2)
						 			{*lstfr_p=4;noddel=random(25);}
								}
						 	else
								--noddel;
							}
						}
					if(exitflg==TRUE)
						{SoundStopAllSamples();return;}
			  		}while(boff<gpb);						/* ...until gap in sample */

				if(!gpe)								  		/* done */
					{*tlkfr_p=basefr;return;}
				do{											/* wait for end of gap */
					get_sample_position();
				  }while(boff<gpe && boff);
			}
		}
	}
}



  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Process the subtitles for						  *
		 *			the 'man' and dogg tag speech					  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void do_subs_foreign()
{int i,n,subtime,nf;

 for(;;)
	{
    get_line();
	 if(linelen)
		{
		 n=interpret_command();
		 switch(n)
	 	 	{
			 case SCOM_CHARTXT:		 					/* get and display subs */
		   	set_subtitle_width(52);
				get_subtitles();
				subtime=strlen(text)*4;					/* subtitle on-screen time frig */
				nf=read_60hztimer();
				for(;;)
				  {				  							
					SoundStreamUpdate(shandle);
					if((read_60hztimer()-nf)>subtime)
						break;
					if(exitflg==TRUE)
						{SoundStopAllSamples();return;}
					wait_loop(1);
				  }
				break;
			 case SCOM_SAMPGAP:						  	/* wait for a gap */
				get_commarg();
				gpb=atoi(argbuff);
				get_commarg();
				gpe=atoi(argbuff);
				if(!gpe)
					{
					 for(;;)
						{
						 if(exitflg==TRUE)
							{SoundStopAllSamples();return;}
						 SoundStreamUpdate(shandle);
						 if(SoundIsDIGIInstalled())
							{if(!SoundSampleIsPlaying(shandle) )
								return;
							}
						 else
							return;
						}
				  }
				break;
			}
		}
	}
}


void do_subs()
{int n;

#ifdef JAP_VERSION
 do_subs_foreign();
 return;
#endif

 for(;;)
	{
    get_line();
	 if(linelen)
		{
		 n=interpret_command();
		 switch(n)
	 	 	{
			 case SCOM_CHARTXT:		 					/* get and display subs */
		   	set_subtitle_width(52);
				get_subtitles();
 				briefing_disp();
				break;
			 case SCOM_SAMPGAP:						  	/* wait for a gap */
				get_commarg();
				gpb=atoi(argbuff);
				get_commarg();
				gpe=atoi(argbuff);
				do{
					wait_loop(1);
					if(exitflg==TRUE)
						{SoundStopAllSamples();return;}
					get_sample_position();
				  }while(boff<gpb);
				if(!gpe)
					return;
				break;
			}
		}
	}
}


/* get prop to say something from a script file (already loaded) */


void animmouth_props()
{
 if(--animfc<0)
	{
	 animfc=5-framecnt;
	 if(animfc<=0)
		animfc=1;
  	 set_frame(mouth_frms[animfr]+29);	/* get mouth frame */
  	 animfr++;
  	 if(animfr==18)
 	 	animfr=0;
 	}
}

void prop_says_foreign(int n)
{int i,nf,subtime;

 nstrs=0;scoff=0;
 scriptmem=prop_scripts[n];
 for(;;)
 	{
	 get_line();
 	 n=interpret_command();
 	 switch(n)
		{
		 case SCOM_CHARSAY:
			load_sample();
			shandle=SoundPlaySample(0,game_data.soundvol,100,0x8000);
			break;
		 case SCOM_CHARTXT:
			set_subtitle_width(42);	 						/* subtitles */
			get_subtitles();
			subtime=strlen(text)*4;					/* subtitle on-screen time frig */
			nf=read_60hztimer();
			for(;;)
				{				  		/* wait 150 frames */
				 if(SoundIsDIGIInstalled() && !SoundSampleIsPlaying(shandle) )
						break;
				 animmouth_props();
				 SoundStreamUpdate(shandle);
				 wait_loop(1);
				 if(exitflg==TRUE)
					{SoundStopAllSamples();return;}
				 if((read_60hztimer()-nf)>subtime)
				  break;
				 if(exitflg==TRUE && game_data.mission==1)
					return;									
			  }
			break;
		 case SCOM_SAMPGAP:
	  		get_commarg();
	  		gpb=atoi(argbuff);
	  		get_commarg();
	  		gpe=atoi(argbuff);
			if(!gpe)
				{
				 for(;;)						/* while talking */
	  			  {
					animmouth_props();
#ifdef CONSOLE_VERSION
					SoundStreamUpdate(shandle);
#endif
  					wait_loop(1);
					if(exitflg==TRUE)
					 	return;
					if(SoundIsDIGIInstalled() && !SoundSampleIsPlaying(shandle) )
						return;
 					if(ctrlval==CTRL_SELECT && mainsel==3)		/* exit sprite selected */
						{
			 			 sampno=3;
						 return;
						}
				   if(exitflg==TRUE && game_data.mission==1)
						return;									

				  }
			  	}
			break;
       case SCOM_BRIEFEND:
			return;
		}
	}
}


void prop_says(int n)
{

#ifdef JAP_VERSION
 prop_says_foreign(n);
 return;
#endif

 nstrs=0;scoff=0;
 scriptmem=prop_scripts[n];
 for(;;)
 	{get_line();
 	 n=interpret_command();
 	 switch(n)
		{
		 case SCOM_CHARSAY:
			load_sample();
			SoundPlaySample(0,game_data.soundvol,100,0x8000);
			break;
		 case SCOM_CHARTXT:
			set_subtitle_width(42);	 						/* subtitles */
			get_subtitles();
			break;
		 case SCOM_SAMPGAP:
	  		get_commarg();
	  		gpb=atoi(argbuff);
	  		get_commarg();
	  		gpe=atoi(argbuff);
	  		do{
				animmouth_props();													/* while talking */
	  			get_sample_position();
  				wait_loop(1);
				if(exitflg==TRUE)
					 return;
 				if(ctrlval==CTRL_SELECT && mainsel==3)		/* exit sprite selected */
					{
			 		 sampno=3;
					 return;
					}
			  }while(boff<gpb);
			if(!gpe)
				{nstrs=0;scoff=0;
				 return;
				}
			do{
				get_sample_position();					 	/* wait for end of sample */
			  }while(boff<gpe && boff);
			break;
       case SCOM_BRIEFEND:
			return;
		}
	}
}



/************************************************************************/
/***********************                            *********************/
/*********************** COMPRESSED SPRITE ROUTINES *********************/
/***********************                            *********************/
/************************************************************************/

struct anim *load_sprites(char *fn)
{
 char *mem;
 struct anim *anim;
 short *p;
 int i;

#ifdef PC_VERSION
 anim=(struct anim *)AllocMem(sizeof(struct anim));
 mem=(char *)LoadFile(fn,"rb");
 p=(short *)mem;
 anim->filemem=mem;
 anim->nf=p[4];
 anim->img.w=sw=p[2];
 anim->img.h=sh=p[3];
 anim->type=0;
 memcpy(anim->offtable,&p[8],256);
 anim->comp_data=&mem[16+(anim->nf*4)];
 return anim;
#else
 uint *ptr;
 uint length;
 uint ii;
 uint *ptr2;
 anim=(struct anim *)AllocMem(sizeof(struct anim));
 length = read_length_from_wad(wad_handle, fn, NULL, wad_directory);
 if(!(mem=AllocMem(length) ))
	return NULL;
 mem = read_data_from_wad(wad_handle, fn, mem, wad_directory);
 p=(short *)mem;
 anim->filemem=mem;
 anim->nf=swap_w(p[4]);
 anim->img.w=sw=swap_w(p[2]);
 anim->img.h=sh=swap_w(p[3]);
 anim->type=0;
 ptr2 = (uint *)&p[8];
 for ( ii=0; ii<anim->nf; ii++ )
 {
	*ptr2 = swap_lw(*ptr2);
	ptr2++;
 }
 memcpy(anim->offtable,&p[8],256);
 anim->comp_data=&mem[16+(anim->nf*4)];
 return anim;
#endif
}

//void draw_anim_frame(struct anim *anim,int fr)
//{
//
// if(fr)
// 	{
//	 unpack_bytes(anim->comp_data+anim->offtable[fr],packbuff,anim->img.w*anim->img.h);
// 	 eormem(anim->comp_data,packbuff,packbuff,anim->img.w*anim->img.h);	 /* restore sprite using ref. frame */
// 	 anim->img.data=packbuff;
//	}
// else	  												/* frame 0 - reference frame (uncompressed) */
//	anim->img.data=anim->comp_data;
// if(!anim->type)
// 	copy_image(&anim->img);
// else
//	copy_spr(&anim->img);
//}

void draw_anim_frame(struct anim *anim,int fr)
{
 char *src,*src1,*dst,c;
 int xc,yc;
 int height;
 int width;
 int adder;

 width=anim->img.w;
 height=anim->img.h;
 adder=SCREEN_WIDTH-width;
 if(anim->img.x+width>SCREEN_WIDTH)
	width=SCREEN_WIDTH-anim->img.x;
 if(anim->img.y+height>SCREEN_HEIGHT)
	height=SCREEN_HEIGHT-anim->img.y;

 if(fr)
 	{
	 unpack_bytes(anim->comp_data+anim->offtable[fr],packbuff,anim->img.w*anim->img.h);
//	 eormem(anim->comp_data,packbuff,packbuff,anim->img.w*anim->img.h);	 /* restore sprite using ref. frame */
 	 anim->img.data=packbuff;
 	 dst=scrptr+(SCREEN_WIDTH*anim->img.y)+anim->img.x;
 	 src=anim->comp_data;
	 src1=packbuff;

/* copy with eor of src and frame 0 data */

	 if(anim->type)									/* sprite */
 	 	{
		 for(yc=0;yc<height;yc++)
		 	{
		 	 for(xc=0;xc<width;xc++)
		 	 	{
		 		 if(c=*src++ ^ *src1++)
		 			*dst=c;
		 		 dst++;
		 		}
   	 	 	 dst+=adder;
 		 	}
		}
	 else
		{
		 #ifdef CONSOLE_VERSION
		 do_anim_dump(dst, src, src1, width, height, adder);
		 #else
		 for(yc=0;yc<height;yc++)
		 	{
   		 eormem(src,src1,dst,width);
			 src+=width;
			 src1+=width;
   	 	 dst+=SCREEN_WIDTH;
 		 	}
		 #endif
		}
	}
 else
    {	  												/* frame 0 - reference frame (uncompressed) */
	anim->img.data=anim->comp_data;
 	if(!anim->type)
 		copy_image(&anim->img);
 	else
		copy_spr(&anim->img);
    }
}

		/******************************************************
		 *																	  	*
		 *				  														*
		 *		eor 2 areas of memory								  	*
		 *																	  	*
		 *																	  	*
		 ******************************************************/


void eormem(long *lsrc,long *lsrc1,long *ldst,int len)
{int i;
 char c,c1,c2;
 char *src,*src1,*dst;

/* eor long words */

 for(i=0;i<(len>>2);i++)
	*ldst++= *lsrc++^*lsrc1++;

/* eor remaining bytes */

 src=(char *)lsrc;
 src1=(char *)lsrc1;
 dst=(char *)ldst;
 for(i=0;i<(len&3);i++)
	*dst++= *src++^*src1++;

}

		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Unpack run length encoded data 				  *
		 *			n - number of bytes expected after 			  *
		 *			unpacking.											  *
		 *																	  *
		 *																	  *
		 *****************************************************/


#ifdef PC_VERSION
void unpack_bytes(char *src,char *dest,int n)

{signed char c;
 unsigned char c1;
 unsigned int i;

 while(n>0)
 	{
	 if((c = *src++)<0)
		{
		 memcpy(dest,src,-c);
		 n+=c;
		 dest+=-c;
		 src+=-c;
		}
	 else												// repeat next byte c+1 times
	 	{
       c1=*src++;
		 memset(dest,c1,c+1);
		 n-=(c+1);
		 dest+=(c+1);
		}
	}
}
#endif
