#ifndef FRONTEND_HEADER
#define FRONTEND_HEADER



#define PC_VERSION
//#define JAP_VERSION
//#define SATURN_VERSION
//#define PSX_VERSION
#define NON_CONSOLE_VERSION
//#define CONSOLE_VERSION
//#define DEBUG_VERSION
#define US_MODIFIED_VERSION

/* controller defines for all versions */

#define	CTRL_UP			1
#define	CTRL_DOWN		2
#define  CTRL_LEFT		4
#define	CTRL_RIGHT		8
#define	CTRL_SELECT		16
#define	CTRL_CANCEL		32
#define	CTRL_SPECIAL	64

#define  SCREEN_WIDTH	320
#define 	SCREEN_HEIGHT	200
#define	YOFFSET			SCREEN_WIDTH*20
#define 	cos(x) sintab[((x)+512)&2047]
#define 	sin(x) sintab[(x)]
#define 	sgn(a) ( (a)<0 ? -1:1)
#define 	set_subtitle_width(a) (maxsubw=a)

enum { ENGLISH,GERMAN,FRENCH};
enum { CORE_SEQUENCE=0, DEATH_SEQUENCE, COMPLETION_SEQUENCE,
		 INTRO_SEQUENCE, INTRO_SEQUENCE1, GAME_OVER_SEQUENCE };


/* image/sprite struct */

struct img{
	short	x,y;
	unsigned short w,h;
	char	*data;
	char	*pal;
};

typedef struct{
	uword		ctrl_up;
	uword		ctrl_down;
	uword		ctrl_left;
	uword		ctrl_right;
	uword		ctrl_fire;
	uword		ctrl_weapon;
	uword		ctrl_target;
	uword		ctrl_tacmap;
}GAME_CONTROL;


/*************** MODIFIED 15-1 **************/

#define NKEYSUSED			11

/********************************************/

typedef struct{
	ubyte		flag;
	uword 	mission;
  uword		nextmiss;
	uword		larmlev;
	uword 	larmint;
	uword		armlev;
	uword		armint;
	uword		nsams;
	uword		mns;
	uword		imageint;
	uword		airsupp;
	uword		engupg;
	uword		trkupg;
	uword		relupg;
	uword		tarupg;
	uword		cgunupg;
	ulong		money;
	ulong		score;
	uword		hitacc;
	ulong		bodycount;
	uword		soundvol;
	uword 	musicvol;
	uword		music;
	uword		subtitl;
	uword		lang;
	uword		ctrldev;
	uword		missstatus;
  uword 	nstructs_dest;
	uword 	nairtarg_dest;
	uword 	ngrdtarg_dest;
	uword 	perc_trucks;
	uword		perc_host;
	uword 	perc_obj;
	uword 	crates_coll;
 	char		*miss_info;

/****************** MODIFIED 12-1-96 ********************/

	char		normksetup[NKEYSUSED];
  	char		dualksetup[NKEYSUSED];

/********************************************************/

}GAME_IOSTRUCT;



/****************** MODIFIED 12-1-96 ********************/


enum NORMAL_KEY_SETUP{
	NK_LEFT,
	NK_RIGHT,
	NK_ACCELERATE,
	NK_REVERSE,
	NK_ROTATETURR_LEFT,
	NK_ROTATETURR_RIGHT,
	NK_CENTERTURR,
	NK_FIRE,
	NK_SELECT,
	NK_RESELETTARG,
	NK_TACTICAL};

enum DUAL_KEY_SETUP{
	DK_LTRACK_FORWARD,
	DK_LTRACK_BACK,
	DK_RTRACK_FORWARD,
	DK_RTRACK_BACK,
	DK_ROTATETURR_LEFT,
	DK_ROTATETURR_RIGHT,
	DK_CENTERTURR,
	DK_FIRE,
	DK_SELECT,
	DK_RESELETTARG,
	DK_TACTICAL};


/********************************************************/


#define TANK_DESTROYED 	1
#define MISSION_FAILED	2
#define MISSION_SUCC		3

#define K_UNDEF		255
#define K_WAITINPUT 	254
#define TIMETo60Hz(a,b)	( (((a*60)+b)*60) )


#ifdef PC_VERSION

#define reset_60hztimer() (GdwClock=0)
#define read_60hztimer()	(GdwClock)

#else

#define reset_60hztimer() (frame_count=0)
#define read_60hztimer()	(frame_count)

#endif

#define set_col(a) (gcol=a)
#define getcol()  (gcol)
#define set_frame(a) (frame=a)
#define FADE_RATE		18
#define FADEOUT_RATE 18
#define SPEED 4

struct font{
	char	*chdata;					  	/* (320 width image ) */
	short w,h;							/* char size */
};

typedef struct{
	short x,y,x1,y1;
}RECT;

typedef struct{
 	short x,y;
}F_POINT;

typedef struct{
	short x,y;
	char **txt;
	char *key;							/* key string e.g. 'SPACE' to print */
	char flags;
}MENUITEM;

#define SELECTORBOX	1				/* has a [*] box */
#define SELECTED		2
#define DISABLED		4



/* shit simple menu */

typedef struct{
 	uword	nitems;
	short curritem;
	char **title;						/* array of text strings */
   uword tx,ty;						/* title pos */

/*********** MODIFIED 12-1-96 *************/

	MENUITEM items[15];

/******************************************/

  uword flags;
}MENU;



/* sequence of compressed frames */

struct anim{
	struct img img;
 	unsigned short nf;
	char 	flags;
 	char	type;							/* 0-image,1-sprite */
	char  *comp_data;				 	/* eor-rle compression */
	char	*filemem;
	int	offtable[64]; 		  		/* data offsets to each frame */

};

#define LOCKOUTUSER	1

#define DUNNOMISS					0
#define SEARCHMISS				1
#define HOSTAGEMISS 			(1<<1)
#define NIGHTMISS					(1<<2)
#define DEFENSIVEMISS 		(1<<3)
#define OFFENSIVEMISS			(1<<4)

#define AIRTARGS					1
#define TRUCKS						2


#define MEMPOOLSIZE		1024*1024
#define nSCOMMS 23

/* script file command id's */

enum{SCOM_DATELINE,
     SCOM_CHARFACE,SCOM_CHARAWAY,SCOM_SETANIM,SCOM_BRIEFSTART,SCOM_BRIEFEND,
	  SCOM_CHARSAY,SCOM_SHOWFRAME,
	  SCOM_PAUSEFRAME,SCOM_CHARTXT,SCOM_SETFACING,SCOM_SETAWAY,
  	  SCOM_SETMAP1,SCOM_SETMAP2,SCOM_SETMAN,SCOM_SETDOGG,SCOM_DOGGSAYC,
     SCOM_DOGGSAYM,SCOM_MAPSAY1,SCOM_MAPSAY2,SCOM_MANSAY,SCOM_SAMPGAP,
	  SCOM_SETDRAW
};

#define 	DOGGTAG_TRACK		7
#define	HANGAR_TRACK		8
#define 	WORKSHOP_TRACK		9
#define  CREDITS_TRACK		10
#define 	GUNSHOT_TRACK		11


/*************** MODIFIED 15-1 **************/

#define PASSWORD_SIZE 	16

/********************************************/

#define SUBTITLE_TIME	5*60
typedef unsigned bits;


struct EncodedGame{		 /* (80 bits or 16 chars) */

	bits	checksum:8;
   bits	level:5;
	bits 	score:16;
	bits	cashflow:16;
	bits	hitacc:7;
	bits	armint:5;
	bits	armlev:3;
	bits	sams:3;
	bits	mnsup:1;
	bits	reloadup:3;
	bits	targup:3;
	bits	engup:3;
	bits 	trkup:3;
	bits	nights:1;
	bits	cgunup:3;
	bits	fill:16;
};


/* PSX graphical butt  */


typedef struct{
	int x,y;
	int type;
	char *txt[3];
}Butt;

enum {
 PSX_CIRCLE_BUTT,PSX_CROSS_BUTT,PSX_SQUARE_BUTT,PSX_TRI_BUTT,
 PSX_LR_BUTTS,PSX_UD_BUTTS
};



#define	PAD_LEFT				 	1
#define  PAD_RIGHT				2
#define 	PAD_UP					3
#define 	PAD_DOWN					4
#define	PAD_REAR_LEFT			5
#define 	PAD_REAR_RIGHT			6
#define	PAD_X						7
#define	PAD_Y						8
#define	PAD_Z						9
#define	PAD_A						10
#define	PAD_B						11
#define 	PAD_C						12
#define 	PAD_WAIT_FOR_INPUT	-1

#endif
