/**************************************************************************




 	Program			:			Shellshock front end
 	Programmer		:			David Long
	Date				:
	Last modified	:			6-12-95  Added password entry system
									11-12-95 Debugging
	Comments			:
	Notes				:			See pc.c,frutils.c




***************************************************************************/


#include  "typedefs.h"
#include "frontend.h"
#include "iff.h"
#include <stdio.h>
#include "frontdef.h"

#ifdef PC_VERSION

#include "shell.h"
#include "types.h"
#include "rad.h"
#include "smack.h"
#include "dosext.h"
//#include "radmal.i"
#include "svga.h"
#include "timer.h"


#else

typedef struct
	{
	short	sc_width,sc_height;
	short	mx_sense,my_sense,ms_dthresh;
	void		*scrn_ptr;
	short	col_mode;
	short	dump_x,dump_y,dump_width,dump_height;
	}
	SETUP;

int mx,my;

SETUP game_setup;

#include "headers.h" /* Platform specific header files */
#include "chuck.h"

#endif


char *commstrs[nSCOMMS]={
"DATELINE",
"CHARFACE",
"CHARAWAY",
"SETANIM",
"BRIEFSTART",
"BRIEFEND",
"CHARSAY",
"SHOWFRAME",
"PAUSEFRAME",
"CHARTXT",
"SETFACING",
"SETAWAY",
"SETMAP1",
"SETMAP2",
"SETMAN",
"SETDOGG",
"DOGGSAYC",
"DOGGSAYM",
"MAPSAY1",
"MAPSAY2",
"MANSAY",
"SAMPGAP",
"SETDRAW"
};




/**************************************************************************/
/*********************** FRONTEND DATA SECTION  ***************************/
/**************************************************************************/

extern SETUP game_setup;
char installDir[32] = "";

uword	nextMissionTypes[26] =
{
	DUNNOMISS,
	SEARCHMISS,
	DUNNOMISS,
	SEARCHMISS|HOSTAGEMISS,
	DUNNOMISS,
	SEARCHMISS,
	SEARCHMISS|HOSTAGEMISS,
	DUNNOMISS,
	SEARCHMISS,
	NIGHTMISS,
 	SEARCHMISS,
	SEARCHMISS,
	SEARCHMISS,
	SEARCHMISS,
	DUNNOMISS,
	SEARCHMISS|HOSTAGEMISS,
	DUNNOMISS,
	SEARCHMISS,
	DUNNOMISS,
	DUNNOMISS,
	DEFENSIVEMISS,
	DEFENSIVEMISS,
	DEFENSIVEMISS,
	SEARCHMISS,
	SEARCHMISS|HOSTAGEMISS,
	SEARCHMISS|HOSTAGEMISS
};

uword MissionVehicles[26]={
	0,
	AIRTARGS,
	TRUCKS,
	0,
	TRUCKS,
	AIRTARGS,
	0,
	TRUCKS,
	AIRTARGS,
	0,
	AIRTARGS,
	AIRTARGS|TRUCKS,
	AIRTARGS,
	AIRTARGS|TRUCKS,
	AIRTARGS|TRUCKS
};

GAME_IOSTRUCT game_data={
	1,		/* Flag */
	1,    /* Mission (current) */
	2,		/* Next mission */
	3,		/* Last armour level */
	24, 	/* Last armour integrity */
	6,		/* Armour level */
	48, 	/* Armour integrity */

   0,		/* Number of sams */
	0,		/* mine utilizaition system */
	0,		/* Night sight */

	/* Upgrades */

	0,		/* Air support */
	0,		/* engine upgrade */
	0,		/* Track upgrade */
	0,		/* reload upgrade */
	0,		/* Track upgrade */
	0,		/* chain gun upgrade */

	1000000,		/* Money */

	0,		/* Score */

   0, 	/* Hit acc percent */
   0,		/* Body count */

   32760,   /* Sound vol */
   32760,		/* music vol */
   2,		/* music */
   0,		/* Subtitles */
	ENGLISH,		/* Language */

	0,		/* Control device */

	0,		/* Mission status */
	25,
	3,
	10,
	89,
	100,
	95,
	8,
	"",

#ifdef PC_VERSION

	/* Keys */

/******************* MODIFIED 12-1-96 ************************/

 	K_COMMA,					/* Left */
	K_DOT,			    	/* Right */
	K_Q,					  	/* Accelerate */
	K_A,				    	/* Reverse */
	K_J,K_L,K_K,
	K_SPACE,			  		/* Fire weapon */
	K_S,			      	/* Select weapon */
	K_T,				    	/* Reselect target */
	K_TAB,					/* Access tactical */

   K_A,					  	/* Left track forward */
	K_Z,					  	/* Left track backward */
	K_COLON,			  		/* Right track forward */
	K_DOT,				  	/* Right track back */
	K_J,K_L,K_K,
	K_SPACE,       	 	/* Fire weapon */
	K_RET,			    	/* Select weapon */
	K_T,			  		/* Reselect target */
	K_TAB,						/* Tactical map */


/*************************************************************/

#endif

 };



GAME_IOSTRUCT original_game_data={
	1,		/*Flag */
	1,    /* Mission (current) */
	2,		/* Next mission */
	3,		/* Last armour level */
	24,		/* Last armour integrity */
	3,		/* Armour level */
	24,	/* Armour integrity */

   0,		/* Number of sams */
	0,		/* mine utilizaition system */
	0,		/* Night sight */

	/* Upgrades */

	0,		/* Air support */
	0,		/* engine upgrade */
	0,		/* Track upgrade */
	0,		/* reload upgrade */
	0,		/* Track upgrade */
	0,		/* chain gun upgrade */

	0,		/* Money */

	0,		/* Score */

   0, 	/* Hit acc percent */
   0,		/* Body count */
   32760,   /* Sound vol */
   32760,		/* music vol */
   2,		/* music */
   0,		/* Subtitles */
	ENGLISH, 	/* Language */

	0,		/* Control device */

	0,		/* Mission status */

	/* Keys */

#ifdef PC_VERSION

/******************* MODIFIED 12-1-96 ************************/


 	K_COMMA,					/* Left */
	K_DOT,			    	/* Right */
	K_Q,					  	/* Accelerate */
	K_A,				    	/* Reverse */
	K_J,K_L,K_K,
	K_SPACE,			  	/* Fire weapon */
	K_S,			      	/* Select weapon */
	K_T,			    		/* Reselect target */
	K_TAB,						/* Access tactical */

   K_A,					  	/* Left track forward */
	K_Z,					  	/* Left track backward */
	K_COLON,			  		/* Right track forward */
	K_DOT,				  	/* Right track back */
	K_J,K_L,K_K,
	K_SPACE,        		/* Fire weapon */
	K_RET,			    	/* Select weapon */
	K_T,			  		/* Reselect target */
	K_TAB,						/* Tactical map */


/*************************************************************/

#endif

 };


/*************************** SOUND STUFF ********************************/


char mouth_frms[]={4,0,1,0,4,0,1,2,1,3,1,0,1,2,1,0,1,0};		  	/* mouth animation frames */
int nvolblks,boff,lastboff,gapstart,nops,shandle,sampno,gotalk;
//struct vgap{uword start;uword size;};
//struct vgap scantbles[5][64];
//uword	scansizes[5];
int gpb,gpe;													/* sample gap start,end */
uword stfrs[]={0,3,7};
uword dtscript,dogscript,earscript,ninscript,prpscript;  /* script files for talking chars */
char *prop_scripts[5];						  				/* props script file names */
int cdtrack,cdstarttime;
int tracktimes[]={
 0,0,
 TIMETo60Hz(5,9),
 TIMETo60Hz(4,0),
 TIMETo60Hz(3,38),
 TIMETo60Hz(3,37),
 TIMETo60Hz(4,8),
 TIMETo60Hz(2,35),
 TIMETo60Hz(1,40),
 TIMETo60Hz(2,46),
 TIMETo60Hz(4,6),
 TIMETo60Hz(2,41)
};

/* character speech script file names */

 char *DTOUR_fns[]={
	"",
   "dtour1.txt",
   "dtour2.txt",
   "dtour3.txt",
   "dtour4.txt",
   "dtour5.txt",
   "dtour6.txt",
   "dtour7.txt",
   "dtour8.txt",
   "dtour9.txt",
   "dtour10.txt",
   "dtour11.txt",
   "dtour12.txt",
   "dtour13.txt",
   "dtour14.txt",
   "dtour15.txt",
   "dtour16.txt",
   "dtour17.txt"
};

char *DOGGTAG_fns[]={
	"",
   "dogg1.txt",
   "dogg2.txt",
   "dogg3.txt",
   "dogg4.txt",
   "dogg5.txt",
   "dogg6.txt",
   "dogg7.txt",
   "dogg8.txt",
   "dogg9.txt",
   "dogg10.txt",
   "dogg11.txt",
   "dogg12.txt",
   "dogg13.txt"
};

char *EARSHOT_fns[]={
	"",
	"ear1.txt",
	"ear2.txt",
	"ear3.txt",
	"ear4.txt",
	"ear5.txt",
	"ear6.txt",
	"ear7.txt",
	"ear8.txt"
};

char *NINE_fns[]={
   "",
	"9111.txt",
	"9112.txt",
	"9113.txt",
	"9114.txt",
	"9115.txt",
	"9116.txt",
	"9117.txt",
	"9118.txt",
	"9119.txt"};


char *PROP_fns[]={
	"prop1.txt",
	"prop2.txt",
	"prop3.txt",
	"prop4.txt",
	"prop5.txt"
};


/***************************** MENUS *************************************/


/******************* PC LOAD/SAVE TEXT ***************/

char *gsavetxt[]={
"GAME SAVED!",
"GAME SAVED!",
"GAME SAVED!"};

char *gloadtxt[]={
"GAME LOADED!",
"GAME LOADED!",
"GAME LOADED!"};


/******************* PSX LOAD/SAVE TEXT ***************/

char *psx_slot1txt[][3]={
"Do you want to FORMAT CARD in SLOT ONE ?",
"Do you want to FORMAT CARD in SLOT ONE ?",
"Do you want to FORMAT CARD in SLOT ONE ?",

"Memcard in SLOT ONE successfully formatted!",
"Memcard in SLOT ONE successfully formatted!",
"Memcard in SLOT ONE successfully formatted!",

"DELETE Locker % data from card in SLOT ONE ?",
"DELETE Locker % data from card in SLOT ONE ?",
"DELETE Locker % data from card in SLOT ONE ?",

"Locker % data DELETED from memcard in SLOT ONE !",
"Locker % data DELETED from memcard in SLOT ONE !",
"Locker % data DELETED from memcard in SLOT ONE !",

"LOAD Locker % data from card in SLOT ONE ?",
"LOAD Locker % data from card in SLOT ONE ?",
"LOAD Locker % data from card in SLOT ONE ?",

"Locker % data LOADED into memcard in SLOT ONE !",
"Locker % data LOADED into memcard in SLOT ONE !",
"Locker % data LOADED into memcard in SLOT ONE !",

"SAVE Locker % DATA to memcard in SLOT ONE ?",
"SAVE Locker % DATA to memcard in SLOT ONE ?",
"SAVE Locker % DATA to memcard in SLOT ONE ?",

"Locker % data SAVED to memcard in SLOT ONE !",
"Locker % data SAVED to memcard in SLOT ONE !",
"Locker % data SAVED to memcard in SLOT ONE !",

};


char *psx_slot2txt[][3]={
"Do you want to FORMAT CARD in SLOT TWO ?",
"Do you want to FORMAT CARD in SLOT TWO ?",
"Do you want to FORMAT CARD in SLOT TWO ?",

"Memcard in SLOT TWO successfully formatted!",
"Memcard in SLOT TWO successfully formatted!",
"Memcard in SLOT TWO successfully formatted!",

"DELETE Locker % data from card in SLOT TWO ?",
"DELETE Locker % data from card in SLOT TWO ?",
"DELETE Locker % data from card in SLOT TWO ?",

"Locker % data DELETED from memcard in SLOT TWO !",
"Locker % data DELETED from memcard in SLOT TWO !",
"Locker % data DELETED from memcard in SLOT TWO !",

"LOAD Locker % data from card in SLOT TWO ?",
"LOAD Locker % data from card in SLOT TWO ?",
"LOAD Locker % data from card in SLOT TWO ?",

"Locker % data LOADED into memcard in SLOT TWO !",
"Locker % data LOADED into memcard in SLOT TWO !",
"Locker % data LOADED into memcard in SLOT TWO !",

"SAVE Locker % DATA to memcard in SLOT TWO ?",
"SAVE Locker % DATA to memcard in SLOT TWO ?",
"SAVE Locker % DATA to memcard in SLOT TWO ?",

"Locker % data SAVED to memcard in SLOT TWO !",
"Locker % data SAVED to memcard in SLOT TWO !",
"Locker % data SAVED to memcard in SLOT TWO !",

};

char *psx_msg3[]={
"No DATA",
"NO DATA",
"NO DATA"
};

char *psx_msg1[]={
"PLEASE INSERT MEMORY CARD !",
"PLEASE INSERT MEMORY CARD !",
"PLEASE INSERT MEMORY CARD !",
};
char *psx_msg2[][2]={
"PLEASE INSERT MEMORY CARD with at least ONE FREE Block of",
"space available into SLOT ONE or SLOT TWO !",
"PLEASE INSERT MEMORY CARD with at least ONE FREE Block of",
"space available into SLOT ONE or SLOT TWO !",
"PLEASE INSERT MEMORY CARD with at least ONE FREE Block of",
"space available into SLOT ONE or SLOT TWO !"
};

char *psx_msg4[]={
"MISSION",
"EINSATZ",
"MISSION"};

char *psxiotxt[][3]={
"LOAD",
"LOAD",
"LOAD",

"OVERWRITE",
"OVERWRITE",
"OVERWRITE",

"DELETE",
"DELETE",
"DELETE",

"SAVE",
"SAVE",
"SAVE",

"QUIT",
"QUIT",
"QUIT"

};

/*************** SATURN LOAD/SAVE TEXT **********/


char *satmsg1[][8]={
"Game backup memory is not ready for use.",
"Please initialise memory in the Memory",
"Manager	screen.",
"To access the Memory Manager screen,go to",
"the Systems Settings screen by holding down",
"the R or L button while pressing the POWER",
"or RESET button. Select the Memory Manager",
"option from that screen"
};


/************************************************/
/* misc. front end text */

char *tracktxts[3][8]={
"TRACK 1","TRACK 2","TRACK 3","TRACK 4","TRACK 5","TRACK 6","TRACK 7","TRACK 8",
"BANDE 1","BANDE 1","BANDE 3","BANDE 4","BANDE 5","BANDE 6","BANDE 7","BANDE 8",
"TITEL 1","TITEL 2","TITEL 3","TITEL 4","TITEL 5","TITEL 6","TITEL 7","TITEL 8"
};


char *entertxt[]={
"ENTER PASSWORD",
"PASSWORT EINGEBEN",
"ENTREZ UN MOT DE PASSE"};

char *passerrtxt[]={
"INVALID PASSWORD",
"PASSWORT UNGLTIG",
"MOT DE PASSE INVALIDE"};

char *passaccepttxt[]={
"PASSWORD ACCEPTED",
"PASSWORD BESTTIGT",
"MOT DE PASSE ACCEPTE"};

char *quittxt[]={
"ARE YOU SURE? (Y/N)",
"SIND SIE SICHER? (Y/N)",
"ETES-VOUS CERTAIN? (Y/N)"};


char *passtxt[]={
"PASSWORD",
"PASSWORT",
"MOT DE PASSE"};


/* keyboard config menus */

char *cm1txt0[]={
"     SELECT CONTROL TYPE",
"     STEUERUNGSART WHLEN",
"SELECTIONNER LE TYPE DE CONTROLE"
};
char *cm1txt1[]={
"KEYBOARD - STANDARD",
"TASTATUR - STANDARD",
"CLAVIER - STANDARD"
};
char *cm1txt2[]={
"KEYBOARD - DUAL TRACK",
"TASTATUR - EINZELKETTENSTEUERUNG",
"CLAVIER - DOUBLE PISTE"
};
char *cm1txt3[]={
"JOYSTICK",
"JOYSTICK",
"JOYSTICK"
};
char *cm1txt4[]={
"CUSTOMISE KEYBOARD",
"TASTATURBELEGUNG",
"PERSONNALISER CLAVIER"
};
char *cm1txt5[]={
"QUIT",
"BEENDEN",
"QUITTER"
};


// >>>>>>>>>>>>>>>>>>>>>>><<<<<<<<<<<<<<<<<<<<<

/******** control texts *******/

char *cm2txt0[]={
"         STANDARD CONTROL",
"        STANDARDSTEUERUNG",
"      LE CONTROLE STANDARD"
};
char *cm2txt1[]={
"ROTATE LEFT",
"NACH LINKS DREHEN",
"TOURNER A GAUCHE"
};
char *cm2txt2[]={
"ROTATE RIGHT",
"NACH RECHTS DREHEN",
"TOURNER A DROITE"};
char *cm2txt3[]={
"FORWARD",
"VORWRTS",
"AVANT"};
char *cm2txt4[]={
"REVERSE",
"RCKWRTS",
"ARRIERE"};
char *cm2txt5[]={
"FIRE WEAPON",
"WAFFE ABFEUERN",
"TIRER"};
char *cm2txt6[]={
"SELECT WEAPON",
"WAFFE WHLEN",
"SELECTIONNER ARME"};
char *cm2txt8[]={
"TACTICAL MAP",
"TAKTISCHE KARTE",
"CARTE TACTIQUE"};
char *cm2txt7[]={
"CHANGE TARGET",
"NEUES ZIEL",
"CHANGER DE CIBLE"};
char *cm2txt9[]={
"DONE",
"FERTIG",
"TERMINE"};

// >>>>>>>>> NOTE: UN-TRANSLATED TEXT <<<<<<<

char *cm2txt10[]={
"ROTATE TURRET LEFT",
"ROTATE TURRET LEFT",
"ROTATE TURRET LEFT"};
char *cm2txt11[]={
"ROTATE TURRET RIGHT",
"ROTATE TURRET RIGHT",
"ROTATE TURRET RIGHT"};
char *cm2txt12[]={
"CENTER TURRET",
"CENTER TURRET",
"CENTER TURRET"};
char *cm2txt13[]={
"ZOOM MAP IN",
"ZOOM MAP IN",
"ZOOM MAP IN"};
char *cm2txt14[]={
"ZOOM MAP OUT",
"ZOOM MAP OUT",
"ZOOM MAP OUT"};

char *cm2txt15[]={
"HANDBRAKE TURN",
"HANDBRAKE TURN",
"HANDBRAKE TURN"};

char *cm2txt16[]={
"CONFIGURE JOYPAD",
"CONFIGURE JOYPAD",
"CONFIGURE JOYPAD"};

// >>>>>>>>>>>>>>>>>>>>>>><<<<<<<<<<<<<<<<<<<<<

char *cm3txt0[]={
"        DUAL TRACK CONTROL",
"      EINZELKETTENSTEUERUNG",
"   CONTROLE DES DEUX CHENILLES"};
char *cm3txt1[]={
"LEFT TRACK FORWARD",
"LINKE KETTE VORWRTS",
"CHENILLE GAUCHE VERS L'AVANT"};
char *cm3txt2[]={
"LEFT TRACK REVERSE",
"LINKE KETTE VORWRTS",
"CHENILLE GAUCHE VERS L'ARRIERE"};
char *cm3txt3[]={
"RIGHT TRACK FORWARD",
"RECHTE KETTE VORWRTS",
"CHENILLE DROITE VERS L'AVANT"};
char *cm3txt4[]={
"RIGHT TRACK REVERSE",
"RECHTE KETTE RCKWRTS",
"CHENILLE DROITE VERS L'ARRIERE"};
char *cm3txt5[]={
"FIRE WEAPON",
"WAFFE ABFEUERN",
"TIRER"};
char *cm3txt6[]={
"SELECT WEAPON",
"WAFFE WHLEN",
"SELECTIONNER ARME"};
char *cm3txt8[]={
"TACTICAL MAP",
"TAKTISCHE KARTE",
"CARTE TACTIQUE"};
char *cm3txt7[]={
"CHANGE TARGET",
"NEUES ZIEL",
"CHANGER DE CIBLE"};



/****************  PC KEYBOARD MENU STRUCTS ***************/


/* select standard/dual */

MENU ctrlmenu1={
 5,0,
 cm1txt0,85,60,
 108,80,(char **)cm1txt1,0,SELECTORBOX+SELECTED,
 108,90,cm1txt2,0,SELECTORBOX,
 108,100,cm1txt3,0,SELECTORBOX,
 85,120,cm1txt4,0,0,
 85,130,cm1txt5,0,0
};


/* standard */

MENU ctrlmenu2={
 12,0,
 cm2txt0,70,30,
 70,50,cm2txt1,&game_data.normksetup[0],0,
 70,60,cm2txt2,&game_data.normksetup[1],0,
 70,70,cm2txt3,&game_data.normksetup[2],0,
 70,80,cm2txt4,&game_data.normksetup[3],0,

 70,90,cm2txt10,&game_data.normksetup[4],0,
 70,100,cm2txt11,&game_data.normksetup[5],0,
 70,110,cm2txt12,&game_data.normksetup[6],0,

 70,120,cm2txt5,&game_data.normksetup[7],0,
 70,130,cm2txt6,&game_data.normksetup[8],0,
 70,140,cm2txt7,&game_data.normksetup[9],0,
 70,150,cm2txt8,&game_data.normksetup[10],0,
 70,160,cm2txt9,0,0
};


/* dual */

MENU ctrlmenu3={
 12,0,
 cm3txt0,70,30,
 70,50,cm3txt1	,&game_data.dualksetup[0],0,
 70,60,cm3txt2	,&game_data.dualksetup[1],0,
 70,70,cm3txt3	,&game_data.dualksetup[2],0,
 70,80,cm3txt4	,&game_data.dualksetup[3],0,


 70,90,cm2txt10	,&game_data.dualksetup[4],0,
 70,100,cm2txt11	,&game_data.dualksetup[5],0,
 70,110,cm2txt12	,&game_data.dualksetup[6],0,


 70,120,cm3txt5	,&game_data.dualksetup[7],0,
 70,130,cm3txt6	,&game_data.dualksetup[8],0,
 70,140,cm3txt7	,&game_data.dualksetup[9],0,
 70,150,cm3txt8	,&game_data.dualksetup[10],0,
 70,160,cm2txt9   ,0,0

};


/*************************************************/


// >>>>>>>>> NOTE: UN-TRANSLATED TEXT <<<<<<<

char *PadTexts[][3]={
	"","","",

	"PAD LEFT",
	"PAD LEFT",
	"PAD LEFT",

	"PAD RIGHT",
	"PAD RIGHT",
	"PAD RIGHT",

	"PAD UP",
	"PAD UP",
	"PAD UP",

	"PAD DOWN",
	"PAD DOWN",
	"PAD DOWN",

	"PAD REAR LEFT",
	"PAD REAR LEFT",
	"PAD REAR LEFT",

	"PAD REAR RIGHT",
	"PAD REAR RIGHT",
	"PAD REAR RIGHT",

	"PAD X",
	"PAD X",
	"PAD X",

	"PAD Y",
	"PAD Y",
	"PAD Y",

	"PAD Z",
	"PAD Z",
	"PAD Z",

	"PAD A",
	"PAD A",
	"PAD A",

	"PAD B",
	"PAD B",
	"PAD B",

	"PAD C",
	"PAD C",
	"PAD C",
};


// >>>>>>>>>>>>>>>>>>>>>>><<<<<<<<<<<<<<<<<<<<<


/***************** CONSOLE PAD SETUP MENU ********/

unsigned short PadConfig[12]={
	PAD_LEFT,
	PAD_RIGHT,
	PAD_UP,
	PAD_DOWN,
	PAD_REAR_LEFT,
	PAD_REAR_RIGHT,
	PAD_X,
	PAD_Y,
	PAD_Z,
	PAD_A,
	PAD_B,
	PAD_C,
};

MENU PadMenu={
 13,0,
 cm2txt16,70,25,
 70,45,cm2txt1,&PadConfig[0],0,
 70,55,cm2txt2,&PadConfig[1],0,
 70,65,cm2txt3,&PadConfig[2],0,
 70,75,cm2txt4,&PadConfig[3],0,
 70,85,cm2txt10, &PadConfig[4],0,
 70,95,cm2txt11,&PadConfig[5],0,
 70,105,cm2txt8,&PadConfig[6],0,
 70,115,cm2txt13,&PadConfig[7],0,
 70,125,cm2txt14,&PadConfig[8],0,
 70,135,cm2txt5,&PadConfig[9],0,
 70,145,cm2txt6,&PadConfig[10],0,
 70,155,cm2txt15,&PadConfig[11],0,
 70,165,cm2txt9,0,0
};


char *cm3txt9[]={
"DONE",
"FERTIG",
"TERMINE"};


/* sound set up menu */

char *stertxt0[]={
"   CONFIGURE SOUND",
" SOUNDKONFIGURATION",
" CONFIGURER LE SON"};
char *stertxt1[]={
"SOUND EFFECTS VOLUME",
"LAUTSTRKE DER SOUNDEFFEKTE",
"VOLUME DES EFFETS SONORES"};
char *stertxt2[]={
"MUSIC VOLUME",
"LAUTSTRKE DER MUSIK",
"VOLUME DE LA MUSIQUE"};
char *stertxt3[]={
"SUBTITLES",
"UNTERTITEL",
"SOUS-TITRES"};
char *stertxt4[]={
"NEXT MISSION MUSIC",
"MUSIK FR NCHSTEN EINSATZ",
"MUSIQUE DE LA MISSION SUIVANTE"};
char *stertxt5[]={
"QUIT",
"BEENDEN",
"QUITTER"};


MENU stermenu={
 4,0,
 stertxt0,100,52,
 42,76,	stertxt1,0,0,
 42,88,	stertxt3,0,0,
 42,100,	stertxt4,0,0,
 42,112,	stertxt5,0,0
};

MENU *lockmen_p;		  								/* locker game empty/full menu */
MENU *ctrlmen_p; 										/* standard/dual menu */
MENU netmenu;	 										/* dave muir's */


/******************** MODIFIED 23-1 **********************/

char *locktxt0[]={
"LOAD GAME",
"SPIEL LADEN",
"CHARGER LE JEU"};
char *locktxt1[]={
"SAVE GAME",
"SPIEL SICHERN",
"SAUVEGARDER LE JEU"};

char *locktxt2[]={
"QUIT",
"BEENDEN",
"QUITTER"};


MENU lockmenu={
 3,0,
 NULL,0,0,
 130,120,locktxt0,0,0,
 130,130,locktxt1,0,0,
 130,140,locktxt2,0,0
};

/**********************************************************/

char *upgstateng[]={
"ARMOUR",
"ARMOUR",
"SAMS",
"RELOADING",
"TARGETING",
"ENGINE",
"TRACKS",
"AIR SUPPORT",
"C-GUN COOLANT"
};
char *upgstatger[]={
"PANZERUNG",
"PANZERUNG",
"SAMS",
"NACHLADEN",
"ZIELEN",
"MOTOR",
"KETTEN",
"LUFTUNTERSTTZUNG",
"MG-KHLSYSTEM"
};
char *upgstatfrn[]={
"BLINDAGE",
"BLINDAGE",
"MISSILES SOL-AIR",
"RECHARGEMENT",
"VISER",
"MOTEUR",
"CHENILLES",
"SOUTIEN AERIEN",
"SYSTEME CALOPORTEUR"
};
char **upgstattxts[]={upgstateng,upgstatger,upgstatfrn};

char *stinfoeng[]={"CASHFLOW:","HIT ACCURACY:","SCORE:","BODY COUNT:","DATELINE:"};
char *stinfoger[]={"BARGELD:","TREFFERGENAUIGKEIT:","PUNKTE:","VERLUSTE DES GEGNERS:","EINSATZDATEN:"};
char *stinfofrn[]={"RENTREES D'ARGENT:","PRECISION DU TIR:","SCORE:","VICTIMES:","DATE:"};
char **stinfotxt[]={stinfoeng,stinfoger,stinfofrn};

char *loadsaveeng[]={
" LOAD/SAVE GAME",
"MISSION:",
"CASHFLOW:",
"HIT ACCURACY:",

"SCORE:","BODY COUNT:","ARMOUR","EMPTY"};
char *loadsaveger[]={" SPIEL LADEN/SICHERN","EINSATZ:","BARGELD:","TREFFERGENAUIGKEIT:",
		"PUNKTE:","VERLUSTE DES GEGNERS:","PANZERUNG","LEER"};
char *loadsavefrn[]={" CHARGER/SAUVEGARDER LE JEU","MISSION:","RENTREES D'ARGENT:","PRECISION DU TIR:",
							"SCORE:","VICTIMES","BLINDAGE","VIDE"};

char **loadsavetxt[]={loadsaveeng,loadsaveger,loadsavefrn};

/* pen option texts */
char *mainengtxt[]={"GO TO TANK","GO TO BASKETBALL COURT","ENTER WORKSHOP AREA","ENTER BRIEFING AREA","LEAVE THE PEN",NULL};
char *maingertxt[]={"ZUM PANZER GEHEN","ZUM BASKETBALL-COURT GEHEN","IN DIE WERKSTATT GEHEN","IN DEN BESPRECHUNGSRAUM GEHEN","DEN KNAST VERLASSEN",NULL};
char *mainfrntxt[]={"ALLER AU CHAR","ACCEDER AU TERRAIN DE BASKET","ACCEDER A L'ATELIER","ACCEDER A LA SALLE DE BRIEFING","QUITTER LE MITARD",NULL};

#ifdef PC_VERSION

char *tnkengtxt[]={"TALK TO D-TOUR",
"CLIMB ABOARD TANK"
,"GO BACK TO ENTRANCE",NULL};
char *tnkgertxt[]={"MIT D-TOUR SPRECHEN","IN DEN PANZER STEIGEN","ZURCK ZUM EINGANG",NULL};
char *tnkfrntxt[]={"PARLER A D-TOUR","GRIMPER A BORD DU CHAR","RETOURNER A L'ENTREE",NULL};


#else

char *tnkengtxt[]={"TALK TO D-TOUR","GO BACK TO ENTRANCE",NULL};
char *tnkgertxt[]={"MIT D-TOUR SPRECHEN","ZURCK ZUM EINGANG",NULL};
char *tnkfrntxt[]={"PARLER A D-TOUR","RETOURNER A L'ENTREE",NULL};

#endif

char *bbengtxts[]={"ENTER SIMULATION ROOM","GO TO STEREO SYSTEM","RETURN TO ENTRANCE","TALK TO 9-1-1",NULL};
char *bbgertxts[]={"ZUM SIMULATIONSRAUM","STEREO-SYSTEM AUFRUFEN","ZURCK ZUM EINGANG","MIT 9-1-1 SPRECHEN",NULL};
char *bbfrntxts[]={"ENTRER DANS LA CHAMBRE DE SIMULATION","ACCEDER AU SYSTEME STEREO","RETOURNER A L' ENTREE","PARLER A 9-1-1",NULL};

#ifdef PC_VERSION
#ifdef JAP_VERSION
char *simengtxts[]={"TALK TO EARSHOT","LEAVE SIMULATOR",""};
char *simgertxts[]={"MIT EARSHOT SPRECHEN","SIMULATIONSRAUM VERLASSEN",""};
char *simfrntxts[]={"PARLER A EARSHOT","QUITTER LE SIMULATEUR",""};
#else
char *simengtxts[]={"START NETWORK GAME","TALK TO EARSHOT","LEAVE SIMULATOR",""};
char *simgertxts[]={"NETZWERKSPIEL STARTEN","MIT EARSHOT SPRECHEN","SIMULATIONSRAUM VERLASSEN",""};
char *simfrntxts[]={"COMMENCER JEU EN RESEAU","PARLER A EARSHOT","QUITTER LE SIMULATEUR",""};
#endif
#endif

char *tlkengtxts[]={"GO BACK TO ENTRANCE",""};
char *tlkgertxts[]={"ZURCK ZUM EINGANG",""};
char *tlkfrntxts[]={"RETOURNER A L'ENTREE",""};

char *wrkengtxts[]={"CHECK STATUS","TALK TO PROPS","RETURN TO ENTRANCE",""};
char *wrkgertxts[]={"ZUSTAND PRFEN","MIT PROPS SPRECHEN","ZURCK ZUM EINGANG",""};
char *wrkfrntxts[]={"VERIFIER STATUT","PARLER A PROPS","RETOURNER A L'ENTREE",""};



char *lockengtxts[]={
"OPEN LOCKER 1","OPEN LOCKER 2","OPEN LOCKER 3","OPEN LOCKER 4", "ENTER BRIEFING ROOM","TALK TO DOGG-TAG","RETURN TO MAIN HANGAR",""};
char *lockgertxts[]={
"SCHLIESSFACH FFNEN","SCHLIESSFACH FFNEN","SCHLIESSFACH FFNEN","SCHLIESSFACH FFNEN", "IN DEN BESPRECHUNGSRAUM GEHEN","MIT DOGG-TAG SPRECHEN","ZURCK ZUM HAUPTHANGAR",""};
char *lockfrntxts[]={
	"OUVRIR VESTIAIRE","OUVRIR VESTIAIRE","OUVRIR VESTIAIRE","OUVRIR VESTIAIRE",
	"ACCEDER A LA SALLE DE BRIEFING","PARLER A DOGG-TAG","RETOURNER AU HANGAR PRINCIPAL",""};


char *mstatengtxts[]={"GO TO HANGAR",""};
char *mstatgertxts[]={"ZUM HANGAR GEHEN",""};
char *mstatfrntxts[]={"RETOURNER AU HANGAR",""};

char **maintxts[]={mainengtxt,maingertxt,mainfrntxt};
char **tanktxts[]={tnkengtxt,tnkgertxt,tnkfrntxt};
char **bballtxts[]={bbengtxts,bbgertxts,bbfrntxts};
char **simtxts[]={simengtxts,simgertxts,simfrntxts};
char **tlktxts[]={tlkengtxts,tlkgertxts,tlkfrntxts};
char **locktxts[]={lockengtxts,lockgertxts,lockfrntxts}; char **wrktxts[]={wrkengtxts,wrkgertxts,wrkfrntxts};
char **mstattxts[]={mstatengtxts,mstatgertxts,mstatfrntxts};

/* mission status texts */

char *missstateng[]={
"MISSION DEBRIEFING ", "STRUCTURES DESTROYED:",
"AIR TARGETS DESTROYED:",
"GROUND TARGETS DESTROYED:",
"TRUCKS SURVIVED:",
"HOSTAGES RESCUED:",
"OBJECTIVES DESTROYED:",
"HIT ACCURACY:",
"SUPPLY CRATES COLLECTED:",
"SCORE:",
"CASHFLOW:"
};
char *missstatger[]={
"      EINSATZBEURTEILUNG ", "ZERSTRTE EINRICHTUNGEN:",
"ZERSTRTE LUFTZIELE:",
"ZERSTRTE BODENZIELE:",
"GERETTETE LASTWAGEN:",
"BEFREITE GEISELN:",
"ERFLLTE EINSATZZIELE:",
"TREFFERGENAUIGKEIT:",
"SICHERGESTELLTE NACHSCHUBKISTEN:",
"PUNKTE:",
"BARGELD:"
};

char *missstatfrn[]={
"      COMPTE-RENDU DE MISSION",
"STRUCTURES DETRUITES:",
"CIBLES AERIENNES DETRUITES:",
"CIBLES TERRESTRES DETRUITES:",
"CAMIONS RESTANTS:",
"OTAGES SAUVES:",
"OBJECTIFS DETRUITS:",
"PRECISION DU TIR:",
"CAISSES DE MUNITIONS RAMASSEES:",
"SCORE:",
"RENTREES D'ARGENT:"
};

char **missstattxt[]={missstateng,missstatger,missstatfrn};
char *upgrdseng[]={
"ARMOUR REPAIR",
"EXTRA ARMOUR",
"SAM",
"RELOAD MECHANISM",
"TARGETTING COMPUTER",
"ENGINE UPGRADE",
"TRACKS UPGRADE",
"AIR SUPPORT",
"CHAIN GUN COOLANT"
};
char *upgrdsger[]={
"REPARATUR DER PANZERUNG",
"EXTRAPANZERUNG",
"SAM",
"LADEMECHANISMUS",
"ZIELSUCH-COMPUTER",
"AUFWERTUNG DES MOTORS",
"AUFWERTUNG DER KETTEN",
"LUFTUNTERSTTZUNG",
"MG-KHLSYSTEM"
};
char *upgrdsfrn[]={
"REPARATION DU BLINDAGE",
"BLINDAGE SUPPLEMENTAIRE",
"MISSILE AIR-SOL",
"MECANISME DE RECHARGEMENT",
"ORDINATEUR DETECTEUR DE CIBLE",
"AMELIORATION DU MOTEUR",
"AMELIORATIONS DES CHENILLES",
"SOUTIEN AERIEN",
"SYSTEME CALOPORTEUR POUR MITRAILLEUSE"
};
char **upgrds[]={upgrdseng,upgrdsger,upgrdsfrn};
char *coststxt[]={"COSTS","KOSTEN","COSTS"};


/************************************************************************/

char *datelines[]={
	"",
	"7.1.97",
	"7.6.97",
	"7.9.97",
	"8.16.97",
	"8.19.97",
	"8.24.97",
	"8.27.97",
	"9.4.97",
	"9.8.97",
	"9.11.97",
	"9.18.97",
	"9.22.97",
	"9.25.97",
	"9.28.97",
	"10.5.97",
	"10.8.97",
	"10.13.97",
	"10.15.97",
	"10.18.97",
	"11.1.97",
	"11.4.97",
	"11.6.97",
	"11.14.97",
	"11.17.97",
	"11.20.97"
};

#define HIGHLIGHTED	1

enum {START_ANIM,FIDDLE_ANIM,PICKUP_ANIM,PUTDOWN_ANIM,FIDDLE2_ANIM,LOOKAWAY_ANIM};
enum {BB_START_ANIM,BB_LOOKUPR_ANIM,BB_HEAD_DR_ANIM,BB_LOOKUPL_ANIM,BB_HEAD_DL_ANIM,
		BB_LOOKUP1_ANIM,BB_LOOKUP2_ANIM,BB_LOOKR_ANIM,BB_LOOKL_ANIM,BB_SCRATCH_ANIM,
		BB_PUTDOWN_ANIM};
enum {SIM_F1,SIM_OTHER_ACT,SIM_LOOK_R,SIM_HES,SIM_LOOK_L,SIM_LOOK_U,SIM_LOOK_AR};
enum {ST_START,ST_WRITE,ST_LOOKUP,ST_HEADU,ST_HEADD,ST_LOOKR,ST_HEADDR,
      ST_HEADL,ST_LOOKL,ST_LOOKAR};
enum{STR_STANDSTILL,STR_LOOKR,STR_LOOKL,STR_CLIPBOARD,STR_TALK};
enum{STAT_START,STAT_LOOKR,STAT_LOOKL,STAT_LOOK_YOU,STAT_LOWER_CBRD,
	  STAT_CBRD,STAT_CBRD_LOOKR,STAT_CBRD_LOOKL,STAT_CBRD_RAISE};

int framecnt;
int selected;
char text[2048];				  						/* script line buffer */
PIC ps;
char *scrptr;
struct img frim,engim;
struct anim *mainsprs;
struct anim *exsprs;							  		/* exit symbol sprites */

/******** PSX STUFF ******/

struct img psx_buttsprs[6];

Butt butts1[]={
	10,182,PSX_LR_BUTTS,
	"Choose Pen Area",
	"Choose Pen Area",
	"Choose Pen Area",

	160,182,PSX_CROSS_BUTT,
	"Select",
	"Select",
	"Select"
};

Butt butts2[]={
	10,182,PSX_LR_BUTTS,
	"Choose",
	"Choose",
	"Choose",

	100,182,PSX_CROSS_BUTT,
	"Select",
	"Select",
	"Select"
};

int hangarea;

/******************************/

struct img ballim;
struct img shadsprs[3];
struct img netim;
char gpath[]="graph\\";						  		/* file paths */
char spath[]="*sound\\";
char *tpaths[]={"english\\","german\\","french\\","japanese\\"};
struct img backim,backim2;
char backpal[256*3];									/* background pal */
char transpal[256*3];						 		/* transparency */
char fadepal[256*3];							  		/* all 0's except top 8 cols */
char fn[50];
char sfn[50];											/* script file name */
char strs[16][80];										/* string split into these */
int slens[16];										  	/* lengths */
uword nstrs;											/* # split strings */
uword maxsubw=52;										/* max #chars in subtitle */
struct anim *con1sprs,*con2sprs,*con3sprs,*con4sprs;
char upp8cols[8*3]={									/* reserved top 9 cols */
	0x0f,0x0f,0x0f,
	0,0x0e,0,
	00,0x2b,0,
	0x3f,0,0,
	0x3f,0x3f,0,
 	0x24,0x24,0x24,
	0,0,0,
	0x3f,0x3f,0x3f};

/* next animation options */


/***************** MODIFIED 17-1 ****************/

char start_next[]={PICKUP_ANIM,FIDDLE_ANIM};
char fidd_next[]={FIDDLE_ANIM,FIDDLE2_ANIM};
char pick_frames[]={9,8,7,6,6,6,6,5,4};
char look_next[]={FIDDLE2_ANIM,LOOKAWAY_ANIM};
char fidd2_next[]={LOOKAWAY_ANIM,FIDDLE_ANIM,PUTDOWN_ANIM};
char st_startn[]={ST_WRITE,ST_LOOKUP,ST_LOOKL};


/************************************************/


char bb_startn[]={BB_LOOKUPR_ANIM,BB_LOOKUPL_ANIM,
						BB_LOOKUPR_ANIM,BB_LOOKUPL_ANIM,
						BB_LOOKUPR_ANIM,BB_LOOKUPL_ANIM,BB_SCRATCH_ANIM};
char bb_lookn[]={BB_LOOKUP1_ANIM,BB_HEAD_DR_ANIM};
char bb_lookupln[]={BB_LOOKUP2_ANIM,BB_HEAD_DL_ANIM};
char bb_lookup1n[]={BB_LOOKR_ANIM,BB_LOOKL_ANIM};
char bb_lookuprn[]={BB_LOOKUP1_ANIM,BB_HEAD_DR_ANIM};
char simnextf[9][3]={2,9,0, 3,1,0, 4,2,0, 5,3,0, 6,4,0, 7,5,0,
							8,6,8, 9,7,0, 1,8,0};
struct img cursim;			 						/* cursor */
short cursposx[]={24,141,208,288};			  	/* ? */
short cursposy[]={77,109,70,98};
short mainsel;											/* area in pen to go to */
short exitflg;											/* exit selected */
short exitgame;
uword draworder;				  						/* conversation - which one to draw first */
short frame,animfr,animfr1,animfc;				/* for animation */
uword backloaded=FALSE;
int selitem;

/* current font data */

char *gfont,gcol;
short	fontw,fonth;
struct font font1,font2;


/* upgrade costs */

char *costs[]={
	"cost: $2,000",
	"cost: $7,500",
	"cost: $4,000",
	"cost: $7,500",
   "cost: $5,000",
	"cost: $5,000",
	"cost: $5,000",
	"cost: $15,000",
   "cost: $4,000"};
ulong item_costs[]={
	2000,
	7500,
	4000,
	7500,
	5000,
	5000,
	5000,
	15000,
	4000};



short ecols;
struct anim *tanksprs;
int  sprx,spry,sprw,sprh,sw,sh;
char *backg;
int anim;
struct anim *animd;
int animhold;
int relflg;
int upgr,mfrct;
short tanksprnos[]={0,1,3,4,5,6,8};
short upgrsprnos[]={0,1,2,4,5,6,7,9,10};

int stance,movem;
int smackflg;


RECT mainareas[]={
	0,58,109,148,
	146,77,193,117,
	208,49,245,129,
	287,83,314,145,
	278,160,314,194};

#ifdef PC_VERSION

RECT tankareas[]={
	57,103,113,170,
	0,41,219,157,
	278,160,314,194};

#else

RECT tankareas[]={
	57,103,113,170,
	278,160,314,194};

#endif

RECT *opareas;
RECT bballareas[]={
	12,81,56,149,
	220,95,285,128,
	278,160,314,194,
	103,108,151,199
};
RECT exitarea[]={
	278,160,314,194};

#ifdef PC_VERSION
#ifdef JAP_VERSION

RECT simareas[]={
	44,92,92,145,
	278,160,314,194};

#else

RECT simareas[]={
	0,100,43,146,
	44,92,92,145,
	278,160,314,194};

#endif
#endif

RECT wrkareas[]={
	7,89,123,151,
	241,83,284,177,
	278,160,314,194};
RECT storareas[]={
   7,161,7+24,161+24,
	249,161,249+24,161+24,
   0,106,180,199,
	278,160,314,194};


RECT lockareas[]={
	0,61,55,199,
	56,73,93,199,
	94,79,119,179,
	162,85,187,154,
	193,80,246,150,
	255,99,306,141,
	278,160,314,194};

void (*ctrl_func_p)();
void (*disp_func_p)();
int noptions;
char **optxts;			  							/* pen area texts */
char *tank1txts[]={"",""};
char *confns[4]={"con1.cmp","con3.cmp","con4.cmp","con2.cmp"};
struct anim *consprs[4];
short ctrlys[7]={80,90,110};
short keyys[]={80,90,100,110,120,130,140,150,170};
short actys[]={80,90,100,120};
short confrms[3];
short confrdel[3];
 short conanimct[3];
short confrmct[3]={4,7,2};
short radfr,raddel;
F_POINT conpos[3]={56,132, 265,25, 234,137};
F_POINT consizes[3]={45,28, 55,81, 31,45};

int  ctrlsel,buttsel;

char *asckeyconv[]={
	"ESC","1","2","3","4","5","6","7","8","9",
	"0","-" , "+", "BSPC", "TAB" , "Q" , "W" , "E" , "R" , "T" ,
	 "Y" , "U" , "I","O" , "P" , "[" , "]" , "RET", "CTRL", "A",
	"S", "D", "F" , "G" ,"H" , "J" , "K" , "L" , ":" , "'" ,
	"#" ,"LSHFT" , "" ,"Z" , "X" , "C" , "V" , "B" , "N" , "M" ,
	"," , "." , "/" , "RSFT" ,"PRT", "ALT" , "SPC ", "CAPS" , "F1" ,"F2" ,
	"F3" , "F4" , "F5" , "F6" ,"F7","F8","F9","F10","NLCK","SLCK",
	"HOME","UP","PGUP","PAD-","LFT","PAD5","RGT","PAD+","END","DWN",
	"PDWN","INS","DEL","SREQ","","","F11","F12"};

char ascchars[256]={
	0,0,'1','2','3','4','5','6','7','8','9',
 	'0',0,0,0,0,'Q','W','E','R','T',
	'Y','U','I','O','P',0,0,0,0,'A',
	'S','D','F','G','H','J','K','L',0,0,
	0,0,0,'Z','X','C','V','B','N','M'};

short keysel,tscreen;
char key,ctrlval;
struct gadget *sgadget;
short sgadgetno;
struct anim *dtoursprs;
struct anim *bbalsprs;
char bbdone;
struct anim *simsprs;
struct anim *ninesprs;
struct anim *wksprs;
struct anim *propsprs,*upgsprs;
struct img larrim;
struct img rarrim;
struct img earim;
struct anim *earsprs;
struct img doggim;
struct anim *doggsprs;
struct anim *tssprs;
struct anim *brief1sprs,*brief2sprs;
char *mempool_p,*mempoolend_p;
int memused,memres;

struct anim *locksprs[5];
char *lockfns[5]={"lock1.cmp","lock2.cmp","lock3.cmp","lock4.cmp","lock5.cmp"};
short locksprx[]={33,83,108,166};
short lockspry[]={62,75,81,88};
short locksprw[]={68,45,33,20};
short locksprh[]={139,104,85,57};
short locker,lockanim,lockfr,lockflg;
short lockx,locky,lockw,lockh,lockdisp;
int mysgn,msy,curmov,dstmx,dstmy,mdx,mdy,mbx,mby,mstep;
uword linelen,linepos,arglen;
char linebuff[1024];
char *scriptmem;	  								/* script file mem */
char argbuff[128];				  				/* script command argument buffer */
int scoff;							  				/* script file position */
short *tlkfr_p,*lstfr_p;						/* talk/listening frames */
char charface[10];
char charaway[10];
uword basefr,tlkfrm1,lstanim,tlkanim;
short exanim,exfr;								/* for animating exit sprite */
int facsprx,facspry,facsprw,facsprh; 		/* character facing\away sprite dimensions */
int awsprx,awspry,awsprw,awsprh;
int manpic,briefdisp,backpic,mappic2,mappic1,facepic,awypic;
int doggpic;
char char_widths[256];
short buy;

char password[20];
short passlen,passchar,passerr,passaccept;
short curx,cury;
struct EncodedGame eg;

/* briefing script files */

char *BRIEFING_fns[]={
	"",
	"eng_br01.txt",
	"eng_br02.txt",
	"eng_br03.txt",
	"eng_br04.txt",
	"eng_br05.txt",
	"eng_br06.txt",
	"eng_br07.txt",
	"eng_br08.txt",
	"eng_br09.txt",
	"eng_br10.txt",
	"eng_br11.txt",
	"eng_br12.txt",
	"eng_br13.txt",
	"eng_br14.txt",
	"eng_br15.txt",
	"eng_br16.txt",
	"eng_br17.txt",
	"eng_br18.txt",
	"eng_br19.txt",
	"eng_br20.txt",
	"eng_br21.txt",
	"eng_br22.txt",
	"eng_br23.txt",
	"eng_br24.txt",
	"eng_br25.txt"
};

/* the man background pics */

char *MANPIC_fns[]={
	"",
	"brtv0002.lbm",
	"brtv0003.lbm",
	"brtv0004.lbm",
	"brtv0005.lbm",
	"brtv0006.lbm",
	"brtv0007.lbm",
	"brtv0008.lbm",
	"brtv0009.lbm"};

/* map pics */

char *MAPPIC_fns[]={
	"",
 	"brtv0010.lbm",
	"brtv0011.lbm",
	"brtv0012.lbm",
	"brtv0013.lbm",
	"brtv0014.lbm",
	"brtv0015.lbm",
	"brtv0016.lbm",
	"brtv0017.lbm",
	"brtv0018.lbm",
	"brtv0019.lbm",
	"brtv0020.lbm"};


/* dogg background and sprites */

char *DOGG1C_fns[]={
	"",
  	"dogg1c.cmp",
   "dogg2c.cmp",
	"dogg3c.cmp",
	"dogg4c.cmp",
	"dogg5c.cmp",
	"dogg6c.cmp"
};
char *DOGGCBACK_fns[]={
	"",
	"bd1c0001.lbm",
	"bd2c0001.lbm",
	"bd3c0001.lbm",
	"bd4c0001.lbm",
	"bd5c0001.lbm",
	"bd6c0001.lbm"
};
char *DOGG1M_fns[]={
	"",
  	"dogg1m.cmp",
   "dogg2m.cmp",
	"dogg3m.cmp",
	"dogg4m.cmp",
	"dogg5m.cmp",
	"dogg6m.cmp"
};
char *DOGGMBACK_fns[]={
	"",
	"bd1m0001.lbm",
	"bd2m0001.lbm",
	"bd3m0001.lbm",
	"bd4m0001.lbm",
	"bd5m0001.lbm",
	"bd6m0001.lbm"
};

/* x,y pos's of sprites
   (weren't included in sprite files as they should have been) */

short DOGGC_pos[]={
	0,0,
	91,35,89,28,108,51,125,44,109,52,107,56};
short DOGGM_pos[]={
	0,0,
	138,80,134,75,138,82,145,77,139,82,134,82};



/* character pics and  sprites */


char *BACK_fns[]={
	"",
	"brr10001.lbm",
	"brl10001.lbm",
	"brl20001.lbm",
	"brl30001.lbm",
   "brr20001.lbm",
   "brr30001.lbm"
};

char *CHARFACE_fns[]={
	"",
	"brr1_f.cmp",
	"brl1_f.cmp",
	"brl2_f.cmp",
	"brl3_f.cmp",
	"brr2_f.cmp",
   "brr3_f.cmp"
};

char *CHARAWAY_fns[]={
	"",
	"brr1_a.cmp",
	"brl1_a.cmp",
	"brl2_a.cmp",
	"brl3_a.cmp",
   "brr2_a.cmp",
   "brr3_a.cmp"
 };

short CHARFACE_pos[]={
	0,0,
   99,0,122,52,122,0,101,46,102,47,99,0};
short CHARAWAY_pos[]={
	0,0,
   202,18,20,56,15,56,15,57,202,18,202,32};



//#include "iff.c"
//#include "pc.c"

/************************************************************************/
/** Prototypes **/

void 	next_mission(void);
void 	reset_game(void);
void	mission_stats_screen(void);

/************************************************************************/


#ifdef  CONSOLE_VERSION
void init_scrn_ptr()
{
	game_setup.scrn_ptr = (char *)get_mem(320 * 200);
}

#else
void init_scrn_ptr()
{
}
#endif


/******************************
 * front end entry point 	 	*
 ******************************/

void dave_main()
{
	int i;

#ifdef PC_VERSION
 if(!SoundIsDIGIInstalled())
	game_data.subtitl=1;
 else
 	fade_out();
	smackflg=SMACKTRACKS;
#endif

 fmv(CORE_SEQUENCE);
 fmv(INTRO_SEQUENCE);
 fmv(INTRO_SEQUENCE1);
 InitMemAlloc();
 init_scrn_ptr();
 init_cdsys();

#ifdef CONSOLE_VERSION
 wad_handle = open_wad("k:\\satdata\\wads\\engwad.wad");
 load_wad_dir(wad_handle, wad_directory);	// WAD DIR IS NOW LOADED


#endif

 scrptr=game_setup.scrn_ptr;
 //language_selection();

 reset_game();
 reset_60hztimer();

 title_seq();
// language_selection();
 load_resident_stuff();
 load_games();

 select_character_scripts();

 main_hangar();
 getout("");
}

/************************************************************************/
/***********************                               ******************/
/*********************** Character script file loaders ******************/
/***********************                               ******************/
/************************************************************************/

/* load the appropriate speech script file for mission */

void select_character_scripts()
{
 select_dtour_script();
 select_dogg_script();
 select_earshot_script();

 select_911_script();
}

void select_dtour_script()
{
 switch(game_data.mission)
	{
	 case 1:
   	dtscript=1;
		return;
	 case 12:
   	dtscript=2;
		return;
	 case 24:
   	dtscript=3;
		return;
 	 case 25:
   	dtscript=4;
		return;
	}
  if((game_data.armint/8)==0)
   	dtscript=5;
  else if((game_data.armint/8)==1)
  		dtscript=6;
  else if((game_data.armint/8)==2 && game_data.armlev==3)
		dtscript=7;
  else if((game_data.armint/8)>5 && game_data.armlev==6)
		 dtscript=8;
  else if(game_data.nextmiss==0 && !game_data.imageint)
		 dtscript=9;
  else if(!game_data.nsams && game_data.mission>=8)
		 dtscript=10;
  else if(game_data.hitacc < 50)
 		{
	 	 if(game_data.relupg<4)
		 	dtscript=11;
	 	 else if(game_data.relupg==4 && game_data.tarupg<4)
		 	dtscript=12;
	 	 else if(game_data.relupg==4 && game_data.tarupg==4)
		 	dtscript=13;
		}
  else
	  {
	   if(game_data.engupg<4)
			dtscript=14;
		else if(game_data.engupg==4 && game_data.trkupg<4)
		 	dtscript=15;
  	 	else if(game_data.engupg==4 && game_data.trkupg==4)
			dtscript=16;
      else
			dtscript=17;
	  }
}

void select_dogg_script()
{int n,n1,mp,mp1,mp2;

 if(game_data.mission==1)
	dogscript=1;
 else if(game_data.mission==11)
	dogscript=2;
 else if(game_data.mission==25)
	dogscript=3;
 else
	{
    if(!(n1=game_data.armlev))
		n1=1;
	 mp =(game_data.mission*10)/(25*3);
	 mp1=game_data.hitacc;
	 mp2=((game_data.armint/8)*100)/(n1);
 	 n=mp+((mp1+mp2)/20);
    if(n<=1)
		dogscript=4;
	 else
		{if(n>10)
			n=10;
		 dogscript=n+3;
		}
	}
}

void select_earshot_script()
{
 if(game_data.mission==1)
	earscript=1;
 else if(game_data.mission==24)
	earscript=2;
 else if(game_data.mission==25)
	earscript=3;
 else if(game_data.nextmiss&SEARCHMISS)
	earscript=4;
 else if(game_data.nextmiss&HOSTAGEMISS)
	earscript=5;
 else if(game_data.nextmiss&NIGHTMISS)
	earscript=6;
 else if(game_data.nextmiss&DEFENSIVEMISS)
	earscript=7;
 else
	earscript=8;
}

void select_911_script()
{
 if(game_data.mission==1)
	ninscript=1;
 else if(game_data.mission==23)
	ninscript=2;
 else if(game_data.mission==25)
	ninscript=3;
 else if((game_data.nextmiss&HOSTAGEMISS) && game_data.hitacc<50)
	ninscript=4;
 else if((game_data.nextmiss&HOSTAGEMISS) && game_data.hitacc>=50)
	ninscript=5;
 else if(!game_data.airsupp)
	ninscript=6;
 else if(game_data.airsupp && (game_data.nextmiss&DEFENSIVEMISS))
	ninscript=7;
 else if(game_data.airsupp)
	ninscript=8;
}

void load_prop_scripts()
{
 int i;

 for(i=0;i<5;i++)
	 prop_scripts[i]=load_script_file(PROP_fns[i]);
}

/***************************************************************************/
/**********************                           **************************/
/********************** D-tour animation routines **************************/
/**********************                           **************************/
/***************************************************************************/

int start_anim()
{

 set_frame(0);
 wait_loop(randomr(50,100));
 return start_next[random(1)];
}

int fiddle_anim()
{
 set_frame(1);
 wait_loop(randomr(50,100));
 set_frame(2);
 wait_loop(randomr(50,100));
 set_frame(1);
 wait_loop(5);
 return fidd_next[random(1)];
}

/********************** MODIFIED 17-1 *********************/

int pickup_anim()
{
 animate(0,6,5);
 wait_loop(randomr(50,100));
 animate(6,10,5);
 return 0;
}
int putdown_anim()
{

 animate(0,6,5);
 wait_loop(randomr(50,100));
 animate(6,10,5);
 return 0;
}

/**********************************************************/

int fiddle2_anim()
{
 set_frame(9);
 wait_loop(randomr(50,100));
 set_frame(10);
 wait_loop(randomr(50,100));
 set_frame(11);
 wait_loop(randomr(50,100));
 set_frame(9);
 wait_loop(randomr(50,100));
 return fidd2_next[random(2)];

}
int lookaway_anim()
{
 set_frame(12);
 wait_loop(5);
 set_frame(13);
 wait_loop(5);
 set_frame(14);
 wait_loop(randomr(50,100));
 set_frame(15);
 wait_loop(5);
 set_frame(12);
 wait_loop(5);
 return look_next[random(1)];
}

/*******************************************************************/
/************************                    ***********************/
/************************ LANGUAGE SELECTION ***********************/
/************************                    ***********************/
/*******************************************************************/

void language_selection()
{
 uint i;

 setfn("picture2.lbm");
 load_iffimage(fn,&backim,backpal);
 setfn("english.bbm");
 load_iffimage(fn,&engim,NULL);
 engim.x=5;engim.y=81;
 setfn("french.bbm");
 load_iffimage(fn,&frim,NULL);
 frim.x=162;frim.y=81;
 clr_screen();

 dump_pal(fadepal,0,256);
 memcpy(scrptr,backim.data,320*200);
 copy_image(&engim);
 dump_screen();
 fade_to_pal(FADE_RATE,backpal);
 wait_fade();

 #ifdef CONSOLE_VERSION
 fade_in(backpal);
 #endif

 for(;;)
	{
	 memcpy(scrptr,backim.data,320*200);
	 if(!game_data.lang)
		copy_image(&engim);
	 else
		copy_image(&frim);
	 dump_screen();
	 read_joypad();
    switch(ctrlval)
		{
		 case CTRL_SELECT:
			goto done;
		 case CTRL_LEFT:
			game_data.lang=0;
			break;
		 case CTRL_RIGHT:
			game_data.lang=GERMAN;
			break;
		}
	}
done:
	fade_to_pal(FADE_RATE,fadepal);
	wait_fade();
	FreeMem();
}


/*******************************************************************/
/**************************                *************************/
/************************** TITLE SEQUENCE *************************/
/**************************                *************************/
/*******************************************************************/

void title_seq()

{char *mem,*pal;
 int i;
 struct anim *anim;

 StopCDMusic();
 clr_screen();
 dump_screen();
 settop8cols(fadepal);
 setfn("titl.cmp");
 anim=(struct anim *)load_sprites(fn);
 setfn("titl.pal");
 pal= LoadFile(fn,"rb");
 anim->img.x=54;
 anim->img.y=9;
 PlayCDTrack(GUNSHOT_TRACK);

#ifdef CONSOLE_VERSION
    dump_pal(pal,0,256);
    fade_in(pal);
#endif

 for(i=0;i<25;i++)
	{
	 clr_screen();
#ifdef PC_VERSION
    dump_pal(pal,0,256);
#endif
	 draw_anim_frame(anim,i);
	 dump_screen();
	 wait(5);
	}
 FreeMem();
 for(;;)
	{
	 read_joypad();
	 if(ctrlval==CTRL_SELECT || ctrlval==CTRL_CANCEL)
		break;
	 CDLoopCheck();
   }
#ifdef PC_VERSION
 memset(fadepal,0,256*3);
 clr_screen();
 dump_screen();
#else
 fade_out();
#endif
 disp_func_p=NULL;
 StopCDMusic();
}

/*************************************************************************/
/*******************                     *********************************/
/******************* MAIN HANGAR SECTION *********************************/
/*******************                     *********************************/
/*************************************************************************/

#ifdef PC_VERSION
int quit_to_dos_check()

{
 char c;

 set_col(255);
 memcpy(scrptr,backim.data,320*200);
 print_textbar(quittxt[game_data.lang],-1,90);
 dispexit();
 disp_cursor();
 dump_vram();


 for(;;)
	{
	 if(keydeb(K_Y))
		return 1;
 	 if(keydeb(K_N))
		return 0;
	}

}
#endif

void main_hangar_display()

{struct img img;

 hangarea=0;
 memcpy(scrptr,backg,320*200);						/* background */
 if(animd)													/* copy a sprite */
  {
   animd->img.x=sprx;
   animd->img.y=spry;
	draw_anim_frame(animd,frame);
  }
 if(mainsel>=0)						 			/* option text bar */
 	print_textbar(optxts[mainsel],-1,180);

#ifdef PC_VERSION

 dispexit();		/* exit sprite */

#endif

 disp_cursor();
 dump_vram();
}



/************************ MODIFIED 23-1 *********************************/

void main_ctrl()
{
 if(ctrlval==CTRL_SELECT && mainsel>=0)
  {
   selected=TRUE;
	exitflg=TRUE;
  }
}

/************************************************************************/

void init_main()
{


#ifdef CONSOLE_VERSION
 out_fade();
#endif

/* load main hangar graphics */

 StopCDMusic();
 FreeMem();
 set_col(253);
 setfn("main.cmp");
 mainsprs=(struct anim *)load_sprites(fn);
 if(game_data.mission==24)
	{
 	 setfn("main0017.lbm");
 	 load_iffimage(fn,&backim,backpal);
	}
 else
	{
 	 setfn("main0001.lbm");
 	 load_iffimage(fn,&backim,backpal);
	}
 settop8cols(backpal);
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();
 PlayCDTrack(HANGAR_TRACK);
 ctrl_func_p=main_ctrl;
 disp_func_p=main_hangar_display;
#ifdef PC_VERSION
 noptions=5;
#else
 noptions=4;
#endif
 optxts=maintxts[game_data.lang];
 opareas=mainareas;
 animd= mainsprs;
 sprx=27;
 spry=105;
 backg=(char *)backim.data;
 init_vars();
 gen_qtab(0,128,transpal,backpal);
 main_hangar_display();
 fade_in(backpal);
}


/************************ MODIFIED 23-1 *********************************/

void exitcheck()
{
 if(exitflg==TRUE)
  	{
 	 if(quit_to_dos_check())
 		{
 		 anim_exit_icon();
 		 main_display();
 		 StopCDMusic();
  		 getout("");
		}
	 else
		exitflg=FALSE;
	}

}

void anim_exit_icon()
{
 selected=exitflg=FALSE;
 start_exanim();
 while(exanim && mainsel>=0)
 	{
	 wait_loop(1);
 	 anim_exit();
 	}
}

void main_hangar()

{
 init_main();
 for(;;)
	{

/* animate d-tour (same animation in tank exterior) */

	 switch(anim)
		{
		 case START_ANIM:
			anim= start_anim();
			break;
		 case FIDDLE_ANIM:
			anim=fiddle_anim();
			break;
		 case PICKUP_ANIM:
			anim=pickup_anim();
			break;
		 case PUTDOWN_ANIM:
			anim=putdown_anim();
			break;
		 case FIDDLE2_ANIM:
			anim=fiddle2_anim();
			break;
		 case LOOKAWAY_ANIM:
			anim=lookaway_anim();
			break;
		}
    if(selected==TRUE)
    	{
		 switch(mainsel)
  			{
    	 	 case 0:
				FreeMem();
				SoundFreeSamples();
				tank_exterior();
				init_main();
				break;
		 	 case 1:
				FreeMem();
				SoundFreeSamples();
				bball_court();
				init_main();
				break;
		 	 case 2:
				workshop();
				init_main();
				break;
		 	 case 3:
				FreeMem();
				SoundFreeSamples();
				locker_room();
				init_main();
				break;

#ifdef PC_VERSION
	 	 	 case 4:
				exitcheck();
#endif
			}
	 	}
	 exitcheck();
	}

}

/************************************************************************/


/***********************************************************************/
/**************************                      ***********************/
/************************** Tank exterior screen ***********************/
/**************************                      ***********************/
/***********************************************************************/


/************************ MODIFIED 23-1 *********************************/


void tanksel()
{

  {
  if(ctrlval==CTRL_SELECT)
	 {selected=TRUE;exitflg=TRUE;}
  }
}



void init_tankext()

{
#ifdef CONSOLE_VERSION
 out_fade();
#endif

/* load tank graphics */

 StopCDMusic();
 setfn("tank.cmp");
 tanksprs=(struct anim *)load_sprites(fn);
 setfn("tank0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();
 PlayCDTrack(HANGAR_TRACK);
 sprx=61;
 spry=104;
 sprw=51;
 sprh=68;
 optxts=tanktxts[game_data.lang];
 opareas=tankareas;
#ifdef PC_VERSION
 noptions=3;
#else
 noptions=2;
#endif
 ctrl_func_p=tanksel;
 disp_func_p=main_display;
 animd=tanksprs;
 backg=(char *)backim.data;
 init_vars();
 gen_qtab(0,128,transpal,backpal);
 main_display();
 fade_in(backpal);
 exanim=exfr=0;
}

/************************ MODIFIED 23-1 *********************************/

void tank_exterior()
{

 set_col(253);
 init_tankext();
 fade_in(backpal);
 while(exitflg==FALSE)
	{
	 switch(anim)
		{
		 case START_ANIM:
			anim=start_anim();
			break;
		 case FIDDLE_ANIM:
			anim=fiddle_anim();
			break;
		 case PICKUP_ANIM:
			anim=pickup_anim();
			break;
		 case PUTDOWN_ANIM:
			anim=putdown_anim();
			break;
		 case FIDDLE2_ANIM:
			anim=fiddle2_anim();
			break;
		 case LOOKAWAY_ANIM:
			anim=lookaway_anim();
			break;
		}
    if(selected==TRUE)
		{
   	 exitflg=FALSE;
		 switch(mainsel)
			{
		 	 case 0:
				FreeMem();
				talk_to_dtour();
				init_tankext();
				break;
#ifdef PC_VERSION
  		 	case 1:
				FreeMem();
				tank_interior();
				init_tankext();
				break;
 	 	 	case 2:
				anim_exit_icon();
				break;
#else
 	 	 	case 1:
				anim_exit_icon();
				break;
#endif

			}
		}
	}
 main_display();
 FreeMem();
}

/********************************************************************/


/*************************************************************************/
/**************                             				  ******************/
/**************  TANK INTERIOR SCREEN 						  ******************/
/**************                             				  ******************/
/*************************************************************************/


/*************************************************************************/
/**************             PC VERSION             ***********************/
/*************************************************************************/


#ifdef NON_CONSOLE_VERSION

void tankint_disp()

{struct img img;
 int i;

 memcpy(scrptr,backim.data,320*200);

  consprs[3]->img.x=139;
  consprs[3]->img.y=133;
  draw_anim_frame(consprs[3],radfr);
  for(i=0;i<3;i++)
	{
	 consprs[i]->img.x=conpos[i].x;
	 consprs[i]->img.y=conpos[i].y;
  	 draw_anim_frame(consprs[i],confrms[i]);
	}

/********************* MODIFIED 12-1-96 **********************/

 if(!tscreen)
	{
 	 disp_3d_transbox(50,50,220,100);
	 print_menu(&ctrlmenu1);
	}
 else if(tscreen==1)
	{
 	 disp_3d_transbox(50,20,220,160);
	 print_menu(game_data.ctrldev?&ctrlmenu3:&ctrlmenu2);
	}

/*************************************************************/

 dispexit();
 disp_cursor();
 dump_vram();
}


void tankintsel()
{
 static int inpmode;
 int sflg,i;

   ctrlmen_p=game_data.ctrldev?&ctrlmenu3:&ctrlmenu2; 		/* set menu ptr to standard/dual-track control */
 	anim_exit();							 			/* animate exit sprite */


/************** MODIFIED 12-1-96 *****************/

 if(ctrlval==CTRL_SELECT && (mbut&1))					/* check for main menu exit */
		{
		 if(!mainsel)
			start_exanim();
		}

/*************************************************/

/* main menu */

 if(!exanim){
	if(!tscreen)
 	  {
		i=ctrlmenu1.curritem;
		sflg=menu_selector(&ctrlmenu1);			/* menu update */
		if(sflg==4)										/* quit */
			{exitflg=TRUE;return;}
      if(sflg>=0)
			{
			 selitem=ctrlmenu1.curritem;
   		 ctrlval=0;
			 if(selitem<3)							 	/* configure keyboard */
				 {
  				  ctrlmenu1.items[selitem].flags=1;
				  for(i=0;i<ctrlmenu1.nitems;i++)
 				  	ctrlmenu1.items[i].flags&=~SELECTED;
 				  ctrlmenu1.items[ctrlmenu1.curritem].flags|=SELECTED;
				  game_data.ctrldev=selitem;
				 }
			 else
				 tscreen=1;								/* display sub-menu */
			}
     }

/* sub-menu (std or dual) */

	else if(tscreen==1)
		{
		 sflg=menu_selector(ctrlmen_p);
		 if(!inpmode)								 	/* input mode ? */
		 	{
 			 if(sflg>=0)	  		   /* quit */
			 	{
				 if(ctrlmen_p->curritem==11 )
 				 	{
					 tscreen=0;						   /* back to main menu */
					 ctrlval=0;
					}
			 	 else	if(!(mbut & 1))
					{
					 inpmode=1;						 	/*  go to input mode */
	 	 		 	 set_keyconfig(ctrlmen_p->curritem,K_WAITINPUT);
					 ctrlmen_p->flags|=LOCKOUTUSER;
					}
				}
			 }
		 else										  		/* key selected */
	 		{if(key)
				{
			 	 if(!(set_keyconfig(ctrlmen_p->curritem,key)) )
				 	{ctrlmen_p->flags&=~LOCKOUTUSER;
	 	 	 	 	 inpmode=0;
					}
				}
			}
		}

	}
}


void tank_interior()
{
 int i;


 StopCDMusic();

 setfn("cpit0008.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 for(i=0;i<4;i++)
	{
	 setfn(confns[i]);
    consprs[i]=(struct anim *)load_sprites(fn);
	}
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();
 noptions=1;
 opareas=exitarea;
 optxts=tank1txts[game_data.lang];
 ctrl_func_p=tankintsel;
 disp_func_p=tankint_disp;
 exanim=exfr=0;
 init_vars();
 tscreen=0;

 PlayCDTrack(HANGAR_TRACK);

 gen_qtab(0,80,transpal,backpal);
 memcpy(scrptr,backim.data,320*200);
 tankint_disp();
// disp_pic();
 fade_in(backpal);
// expand_3d_transbox(50,30,220,140,NULL);


/* tank radar etc animations */

 while(exitflg==FALSE)
	{
	 if(--raddel<0)					 				/* radar */
		{raddel=10;
    	 if(--radfr<0)
			radfr=3;
		}
    for(i=0;i<3;i++)				 					/* computers */
		{
		 if(--confrdel[i]<0)	 						/* frame delay */
			{confrdel[i]=random(100);
			 --confrms[i];
			 if(--conanimct[i]<0)
				{confrms[i]=confrmct[i]-1;
				 conanimct[i]=random(confrmct[i]-1);
				}
			}
		}
	 wait_loop(1);
	}
 FreeMem();
 tankint_disp();
}

#else


/*************************************************************************/
/**************            CONSOLE VERSION         ***********************/
/*************************************************************************/

static int waititem;
static int inpmode;

int ReadPad()
{
 switch(key)
	{
	 case K_1:
		return PAD_LEFT;
	 case K_2:
		return PAD_RIGHT;
	 case K_3:
		return PAD_UP;
	 case K_4:
		return PAD_DOWN;
	}
 return 0;
}

void ConvertPadValues()
{

}


int SetPadConfig(int func,int butt)
{
 int i;

 for(i=0;i<12;i++)
	{
	 if(PadConfig[i]==butt)
		{
		 PadConfig[i]=PadConfig[func];
		 PadConfig[func]=butt;
		 return;
		}
	}
 PadConfig[func]=butt;
}

void PrintPadMenu()
{
 int i,y;
 uchar c,*s;

 set_col(252);

/* print title */

 if(PadMenu.title)
 	sprint(PadMenu.title[game_data.lang],PadMenu.tx,PadMenu.ty);
 y=45;
 for(i=0;i<PadMenu.nitems;i++,y+=10)
	{
	 if(i==PadMenu.curritem)
	 	set_col(255);
	 else
	 	set_col(253);
	 sprint(PadMenu.items[i].txt[game_data.lang],PadMenu.items[i].x,PadMenu.items[i].y);
	 set_col(i==PadMenu.curritem ? 255:253);
	 if(i<12)
	 	{
		 if(inpmode && waititem==i)
			sprint("  ?",180,y);
	 	 else
	 		sprint(PadTexts[PadConfig[i]][game_data.lang],180,y);
		}
	}
}


void tank_ctrl()
{
}

void tankintsel()
{
 int sflg,i,butt;

 anim_exit();							 			/* animate exit sprite */
 if(ctrlval==CTRL_SELECT && PadMenu.curritem==12)						/* check for main menu exit */
	{exitflg=TRUE;return;}
 sflg=menu_selector(&PadMenu);
 if(!inpmode)								 	/* input mode ? */
  		{
		 if(sflg>=0)
			{
	 	 	 inpmode=1;						 	/*  go to input mode */
	 	 	 waititem=PadMenu.curritem;
 	 	 	 PadMenu.flags|=LOCKOUTUSER;
			}
   	}
 else										  		/* key selected */
  		{
	 	 if(butt=ReadPad())
  			{
  	 	 	 inpmode=0;
  		 	 SetPadConfig(PadMenu.curritem,butt);
		 	 PadMenu.flags&=~LOCKOUTUSER;
  			}
  		}
}

void tankint_disp()

{
 int i;

 memcpy(scrptr,backim.data,320*200);

 consprs[3]->img.x=139;
 consprs[3]->img.y=133;
 draw_anim_frame(consprs[3],radfr);
 for(i=0;i<3;i++)
	{
	 consprs[i]->img.x=conpos[i].x;
	 consprs[i]->img.y=conpos[i].y;
  	 draw_anim_frame(consprs[i],confrms[i]);
	}
 disp_3d_transbox(50,15,220,170);
 PrintPadMenu();
 dump_vram();
}



void tank_interior()
{int i;

 StopCDMusic();

 setfn("cpit0008.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 for(i=0;i<4;i++)
	{
	 setfn(confns[i]);
    consprs[i]=(struct anim *)load_sprites(fn);
	}
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();
 noptions=1;
 opareas=exitarea;
 optxts=tank1txts[game_data.lang];
 ctrl_func_p=tank_ctrl;
 disp_func_p=tankint_disp;
 exanim=exfr=0;
 init_vars();
 PadMenu.curritem=0;

 PlayCDTrack(HANGAR_TRACK);
 gen_qtab(0,80,transpal,backpal);
 memcpy(scrptr,backim.data,320*200);
 tankint_disp();
 fade_in(backpal);

/* tank radar etc animations */

 while(exitflg==FALSE)
	{
	 if(--raddel<0)					 				/* radar */
		{raddel=10;
    	 if(--radfr<0)
			radfr=3;
		}
    for(i=0;i<3;i++)				 					/* computers */
		{
		 if(--confrdel[i]<0)	 						/* frame delay */
			{confrdel[i]=random(100);
			 --confrms[i];
			 if(--conanimct[i]<0)
				{confrms[i]=confrmct[i]-1;
				 conanimct[i]=random(confrmct[i]-1);
				}
			}
		}
 	 tankintsel();
	 wait_loop(1);
	}
 FreeMem();
}


#endif


/**************************************************************************/
/****************************               *******************************/
/**************************** D-tour screen *******************************/
/****************************               *******************************/
/**************************************************************************/

void dtour_ctrl()
{
 anim_exit();
 if(ctrlval==CTRL_SELECT && !mainsel)
	start_exanim();
}

void man_disp()
{struct img img;

 memcpy(scrptr,backg,320*200);
 animd->img.x=sprx;
 animd->img.y=spry;
 animd->img.w=sprw;
 animd->img.h=sprh;
// img.data=animd+(frame*sprw*sprh);
 draw_anim_frame(animd,frame);
 disp_subs();
 dump_vram();
}


void talk_to_dtour()

{

#ifdef CONSOLE_VERSION
 out_fade();
#endif

 StopCDMusic();
 setfn("dtor.cmp");
 dtoursprs=(struct anim *)load_sprites(fn);
 setfn("dtor0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 load_script_file(DTOUR_fns[dtscript]);
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();

 sprx=9;
 spry=32;
 sprw=143;
 sprh=168;
 animd=dtoursprs;
 backg=backim.data;

 noptions=1;
 init_vars();
 optxts=tlktxts[game_data.lang];
 opareas=exitarea;
 ctrl_func_p=dtour_ctrl;
 disp_func_p=man_disp;
 gen_qtab(0,80,transpal,backpal);
 man_disp();
 fade_in(backpal);
 animate_man();

 man_disp();
 FreeMem();
 SoundFreeSamples();
}

/***********************************************************************/
/***************                                   *********************/
/***************    BASKET BALL COURT SECTION      *********************/
/***************                                   *********************/
/***********************************************************************/


int bounce;
int bvel;
int xbvel;
int initvel;
int test_inityvel=-24;
int test_initxvel=10;
int test_damp=5;
int damp;
int *var_p;
int *var_str;
int innet;

#define 	GROUND_Y				162
#define 	INITIAL_Y_VEL 		-25
#define	COLLISION_MOMLOSS	10
#define	GROUND_MOMLOSS		5

char *testvar_strs[]={
	"INITIAL Y VELOCITY(F1): ",
	"INITIAL X VELOCITY(F2): ",
	"DAMPING(F3): ",
};



int InBasketDetection()
{
	innet=FALSE;
 	if(ballim.x < 298)
		return;
 	if(ballim.x > 318)
		return;
 	if(ballim.y < 19)
		return;
 	if(ballim.y > 35)
		return;
 	xbvel=0;
	xbvel-=5;
 	innet=TRUE;
}

void BallCollisionHandler()
{

// wall collision

 	if(ballim.x>300)
		{
	 		ballim.x=300;
			xbvel-=COLLISION_MOMLOSS;
	 		xbvel=-xbvel;
		}

// ground collision

 	if(ballim.y>GROUND_Y)
		{
	 		ballim.y=GROUND_Y;
	 		initvel+=GROUND_MOMLOSS;
	 		if(initvel>=0)
				bounce=0;
    		bvel=initvel;
		}

// top of screen collisiom

 	if(ballim.y<0)
		{
			ballim.y=0;
			bvel=-bvel;
		}

// 911 collision

 	if(ballim.x<140)
		{
	 		ballim.x=140;
	 		xbvel=-xbvel;
			xbvel-=COLLISION_MOMLOSS;
		}

// net rim collision




}


void StartBallBounce()
{
 	static int buttdwn_time=0;
 	static int buttdwn=FALSE;


 	if(!bounce)
	{
 		if((mbut & 1))
			{
 				if(buttdwn==FALSE)
					{
	 					buttdwn=TRUE;
	 					buttdwn_time=read_60hztimer();
					}
			}

 		else
			{
	 			if( 	ctrlval==CTRL_SELECT
					&& mx >= ballim.x
					&& mx < (ballim.x+ballim.w)
					&& my >= ballim.y
					&& my < (ballim.y+ballim.h) )
	  					{

			 				if(ballim.x != 194 || ballim.y != GROUND_Y)
 							{
				 				ballim.x = 194;
 								ballim.y = GROUND_Y;
								return;
							}

						initvel=INITIAL_Y_VEL;
						xbvel=mx-ballim.x;
	 					bvel=initvel;
	 					bounce=1;
	  					}
			}
	}
}


void BounceBall()
{
 return;
 if(bounce)
	{
	 ballim.x+=xbvel;
	 ballim.y+=bvel;
	 bvel+=2;
	}
 BallCollisionHandler();
 InBasketDetection();
}


/************************* MODIFIED 23-1 ********************/

void bball_ctrl()
{
 int i;
 static int del=0;

 if(ctrlval==CTRL_SELECT && mainsel>=0)
 	{
	 selected=TRUE;
	 exitflg=TRUE;
	}
 StartBallBounce();
 if(!(++del&3) )
 	BounceBall();
}


void bball_display()

{
	struct img img;
	int spr;
	char s[30];

 memcpy(scrptr,backg,SCREEN_WIDTH*SCREEN_HEIGHT);						/* background */
 if(animd)													/* copy a sprite */
  {
   animd->img.x=sprx;
   animd->img.y=spry;
	draw_anim_frame(animd,frame);
  }
 spr=(167-ballim.y)/20 ;
 shadsprs[spr].x=ballim.x+5;
 shadsprs[spr].y=GROUND_Y+16;
 if(spr>=0 && spr<3)
 	copy_spr(&shadsprs[spr]);
 copy_spr(&ballim);
 netim.x=297;
 netim.y=31;
 copy_spr(&netim);
 if(mainsel<noptions)						 			/* option text bar */
 	print_textbar(optxts[mainsel],-1,180);
 dispexit();					 							/* exit sprite */
 disp_cursor();

// sprint(var_str,10,10);
// sprintf(s,"%d",*var_p);
// sprint(s,200,10);
//
// if(keydeb(K_Q))
//	(*var_p)--;
// if(keydeb(K_W))
//	(*var_p)++;
// if(keydeb(K_F1))
//	{
//		var_p=&test_inityvel;
//		var_str=testvar_strs[0];
//  	}
// if(keydeb(K_F2))
//	{
//		var_p=&test_initxvel;
//		var_str=testvar_strs[1];
//  	}
// if(keydeb(K_F3))
//	{
//		var_p=&test_damp;
//		var_str=testvar_strs[2];
//  	}

 dump_vram();
}

/************************************************************/

void init_bballcourt()
{
 int i;
 static char *fns[]={
	"shad1.bbm",
	"shad2.bbm",
	"shad3.bbm"
	};

#ifdef CONSOLE_VERSION
 out_fade();
#endif

 bounce=0;
 var_p=&test_inityvel;
 var_str=testvar_strs[0];
 StopCDMusic();
 setfn("ball.bbm");
 load_iffimage(fn,&ballim,NULL);
 ballim.x = 194;
 ballim.y = GROUND_Y;
 setfn("net.bbm");
 load_iffimage(fn,&netim,NULL);
 for(i=0;i<3;i++)
	{
 	setfn(fns[i]);
	load_iffimage(fn,&shadsprs[i],NULL);
	}
 setfn("bbal.cmp");
 bbalsprs=(struct anim *)load_sprites(fn);
 setfn("bbal0038.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();
 PlayCDTrack(HANGAR_TRACK);

 if(game_data.mission==24)
   {noptions=3;
	 animd=NULL;
	}
 else
 	{noptions=4;
 	 animd=bbalsprs;
	}
 ctrl_func_p=bball_ctrl;
 optxts=bballtxts[game_data.lang];
 opareas=bballareas;
 disp_func_p=bball_display;
 sprx=103;
 spry=109;
 sprw=66;
 sprh=90;
 backg=(char *)backim.data;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 bball_display();
 fade_in((char *)backpal);
}

/********4***************** MODIFIED 23-1 ********************/


void bball_court()
{
 int i;

 init_bballcourt();
 anim=0;

/* 911 animation */

 while(exitflg==FALSE)
	{
	 switch(anim)
		{
		 case BB_START_ANIM:
			set_frame(0);
			wait_loop(randomr(50,100));
			anim=bb_startn[random(6)];
			break;
		 case BB_LOOKUPR_ANIM:
			set_frame(1);
			wait_loop(5);
			set_frame(2);
			wait_loop(5);
			set_frame(3);
			wait_loop(randomr(50,100));
	      anim=bb_lookuprn[random(1)];
			break;
		 case BB_HEAD_DR_ANIM:
			set_frame(2);
			wait_loop(5);
			set_frame(1);
			wait_loop(5);
			anim=BB_START_ANIM;
			break;
		 case BB_LOOKUPL_ANIM:
			set_frame(8);
			wait_loop(5);
			set_frame(7);
			wait_loop(5);
			set_frame(6);
			wait_loop(randomr(50,100));
			anim=bb_lookupln[random(1)];
			break;
		 case BB_HEAD_DL_ANIM:
			set_frame(7);
			 wait_loop(5);
			set_frame(8);
			wait_loop(5);
			anim=BB_START_ANIM;
			break;
		 case BB_LOOKUP1_ANIM:
			set_frame(4);
			wait_loop(randomr(50,100));
			anim=bb_lookup1n[random(1)];
			break;
		 case BB_LOOKUP2_ANIM:
 			set_frame(5);
			wait_loop(5);
			anim=BB_LOOKUP1_ANIM;
			break;
		 case BB_LOOKR_ANIM:
			set_frame(3);
			wait_loop(100);
			anim=BB_HEAD_DR_ANIM;
			break;
		 case BB_LOOKL_ANIM:
			set_frame(5);
			wait_loop(5);
			set_frame(6);
			wait_loop(randomr(50,100));
			anim=BB_HEAD_DL_ANIM;
			break;
		 case BB_SCRATCH_ANIM:
			animate(9,19,5);
			set_frame(20);
			wait_loop(randomr(50,100));
			animate(21,31,5);
			anim=BB_START_ANIM;
			break;
		}
	 if(selected==TRUE)
	 	{
		 selected=FALSE;
		 switch(mainsel)
			{

		 	 case 0:
				FreeMem();
				sim_room();
				init_bballcourt();
				break;
		 	 case 3:
				if(game_data.mission==24)
				break;
         	if(!anim)								/* make 911 stop and look at you */
			 		{
			  		 for(i=32;i<=36;i++)
						{set_frame(i);
					 	 main_display();
			    		 wait(5);
						}
			 		}
				FreeMem();
				talk_to_911();
				init_bballcourt();
				break;
		 	 case 1:
				FreeMem();
				sound_config();
				init_bballcourt();
				break;
		 	 case 2:
				anim_exit_icon();
				break;
			}
		}
	}

/************************************************************/

 bball_display();
 FreeMem();
}

/*************************************************************************/
/*************************              **********************************/
/************************* 9-1-1 screen **********************************/
/*************************              **********************************/
/*************************************************************************/


void nine_ctrl()
{
 anim_exit();
 if(ctrlval==CTRL_SELECT && !mainsel)
	start_exanim();
}

void talk_to_911()

{

#ifdef CONSOLE_VERSION
 out_fade();
#endif

 StopCDMusic();
 setfn("nine0001.lbm");
 load_iffimage(fn,&backim,(char *)backpal);
 settop8cols((char *)backpal);
 setfn("nine.cmp");
 ninesprs=(struct anim *)load_sprites(fn);
 load_script_file(NINE_fns[ninscript]);
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();

 sprx=10;
 spry=58;
 sprw=120;
 sprh=141;
 animd=ninesprs;
 backg=backim.data;

 noptions=1;
 init_vars();
 optxts=tlktxts[game_data.lang];
 opareas=exitarea;
 ctrl_func_p=nine_ctrl;
 disp_func_p=man_disp;
 gen_qtab(0,80,transpal,backpal);
 man_disp();
 fade_in(backpal);

/*********** MODIFIED 30-1-96 (removed main_display() *********/

 animate_man();

 man_disp();
 FreeMem();
 SoundFreeSamples();
}


/**********************************************************************/
/*************************                     ************************/
/************************* Sound config screen ************************/
/*************************                     ************************/
/**********************************************************************/


void ster_ctrl()
{
 static int mxold=0;

 anim_exit();
 if(ctrlval==CTRL_SELECT && !mainsel)
    start_exanim();
 if(3==menu_selector(&stermenu) && !exanim)			  			/* quit */
	 exitflg=TRUE;


#ifdef PC_VERSION

 if(mbut&1)
	{
	 if(mx>=192 && mx<280 && my >=76 && my<84 && stermenu.curritem==0)
		{
		 	{
			 game_data.soundvol=(((mx-200+8)/8)*3276);
		    if(game_data.soundvol<0)
				game_data.soundvol=0;
		    if(game_data.soundvol>32768)
				game_data.soundvol=32768;
			}
		}
	}
 if(ctrlval==CTRL_SELECT)
	{
	 if(mx>=220 && mx<250 && my >=88 && my<96 && stermenu.curritem==1)
			game_data.subtitl^=1;
	 if(mx>=210 && mx<260 && my >=100 && my<108 && stermenu.curritem==2)
				{if((++game_data.music)==7)
					game_data.music=2;
				}
	}




#endif

 switch(ctrlval)
	{
 	 case CTRL_LEFT:
		switch(stermenu.curritem)
		 	{
			 case 0:
				if(game_data.soundvol)game_data.soundvol-=3276;break;
			 case 1:
				game_data.subtitl^=1;break;
			 case 2:
				if((--game_data.music)==1)
					game_data.music=6;
 				PlayCDTrack(game_data.music);
				break;
			}
		break;
 	 case CTRL_RIGHT:
		switch(stermenu.curritem)
		 	{
			 case 0:
				if(game_data.soundvol<32760)game_data.soundvol+=3276;break;
			 case 1:
				game_data.subtitl^=1;break;
			 case 2:
				if((++game_data.music)==7)
					game_data.music=2;
 				PlayCDTrack(game_data.music);
				break;
			}
	}
}


void ster_disp()
{

 memcpy(scrptr,backim.data,320*200);
 disp_3d_transbox(30,40,261,113);
 print_menu(&stermenu);
 disp_vslider(200,76,game_data.soundvol/3276);
 set_col(stermenu.curritem==1?255:253);
 sprint(game_data.subtitl ? "ON":"OFF",230,88);
 set_col(stermenu.curritem==2?255:253);
 sprint(tracktxts[game_data.lang][game_data.music-2],220,100);
 if(!mainsel)
 	print_textbar(optxts[mainsel],-1,180);

#ifdef PC_VERSION

 dispexit();
 disp_cursor();

#endif

 dump_vram();
}

void sound_config()
{
#ifdef CONSOLE_VERSION
 out_fade();
#endif

 StopCDMusic();
 setfn("ster0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();
 PlayCDTrack(game_data.music);

 noptions=1;
 optxts=tlktxts[game_data.lang];
 opareas=exitarea;
 ctrl_func_p=ster_ctrl;
 disp_func_p=ster_disp;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 memcpy(scrptr,backim.data,320*200);
 ster_disp();
 fade_in(backpal);
 while(exitflg==FALSE)
	wait_loop(1);
 ster_disp();
 FreeMem();
 SoundSetMasterVolume(game_data.soundvol);
}


/*************************************************************************/
/**************************                    ***************************/
/************************** NETWORK GAME MENUS ***************************/
/**************************                    ***************************/
/*************************************************************************/

#ifdef PC_VERSION

char *net_menu[]={
	"Menu item 1",
	"Menu item 2",
	"Menu item 3",
	"Menu item 4",
	"Menu item 5",
	"Menu item 6",
	"Menu item 7",
	"Menu item 8",
	"Menu item 9",
	"Menu item 10"
};

void network_game_entry()
{
 setfn("isim0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();

 gen_qtab(0,80,transpal,backpal);
 memcpy(scrptr,backim.data,320*200);
 fade_in(backpal);

	if (gameMenu())
	{
		FreeAll();
		netit ();
  		reset_60hztimer();
		InitMemAlloc();
		load_resident_stuff();
	}

}

#endif

/*************************************************************************/
/**************************                    ***************************/
/************************** SIMULATION SECTION ***************************/
/**************************                    ***************************/
/*************************************************************************/

/************************* MODIFIED 23-1 ********************/

void sim_ctrl()
{
 if(ctrlval==CTRL_SELECT)
 	{
	 selected=TRUE;
	 exitflg=TRUE;
	}
}

void sim_room()
{int anim,fr,i;


 init_sim();
 anim=fr=0;
 while(exitflg==FALSE)
  {

/* animate earshot */

  switch(anim)
	{
    case SIM_OTHER_ACT:
		anim=random(2)+2;
		break;
	 case SIM_LOOK_R:
		animate(9,11,5);
		wait_loop(randomr(50,100));
		animate(12,13,5);
		anim=SIM_F1;
		break;
	 case SIM_HES:
		animate(14,19,5);
		wait_loop(randomr(50,100));
		animate(20,22,5);
		 anim=SIM_F1;
		break;
	 case SIM_LOOK_L:
		animate(23,24,5);
		wait_loop(randomr(50,100));
		animate1(23,5);
		anim=SIM_F1;
		break;
	 case SIM_LOOK_U:
		animate(25,26,5);
		animate1(27,randomr(50,100));
		animate(26,25,5);
		anim=SIM_F1;
		break;
	 case SIM_LOOK_AR:
		animate(28,31,5);
		anim=SIM_F1;
		break;
	 case SIM_F1:
		set_frame(fr);
      wait_loop(random(100));
		i=random(2);
		if(!(fr=simnextf[fr][i]))
			anim=SIM_OTHER_ACT;
		else
 			--fr;
 		break;
	}
 if(selected==TRUE)
 	{
	 selected=FALSE;
	 switch(mainsel)
		{
#ifdef PC_VERSION
#ifdef JAP_VERSION
		 case 0:
			FreeMem();
			talk_to_earshot();
			init_sim();
			break;
		 case 1:
	 		anim_exit_icon();
			break;
#else
		 case 1:
			FreeMem();
			talk_to_earshot();
			init_sim();
			break;
		 case 0:
			network_game_entry();
			break;
		 case 2:
	 		anim_exit_icon();
			break;
#endif
#else
		 case 0:
			FreeMem();
			talk_to_earshot();
			init_sim();
			break;
		 case 1:
	 		anim_exit_icon();
			break;
#endif

		}
	}
 }
  main_display();
  FreeMem();
}


/*****************************************************************/


void init_sim()
{
#ifdef CONSOLE_VERSION
 out_fade();
#endif

 StopCDMusic();
 setfn("simu.cmp");
 simsprs=(struct anim *)load_sprites(fn);
 setfn("simu0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols((char *)backpal);
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();
 PlayCDTrack(HANGAR_TRACK);

 optxts=simtxts[game_data.lang];
 opareas=simareas;

#ifdef PC_VERSION
#ifdef JAP_VERSION
 noptions=2;
#else
 noptions=3;
#endif
#else
 noptions=2;
#endif

 ctrl_func_p=sim_ctrl;
 disp_func_p=main_display;
 sprx=42;
 spry=88;
 sprw=53;
 sprh=60;
 backg=backim.data;
 animd=simsprs;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 main_display();
 fade_in(backpal);
}

/***************************************************************************/
/****************************                *******************************/
/**************************** Earshot screen *******************************/
/****************************                *******************************/
/***************************************************************************/

void earshot_ctrl()
{
 anim_exit();
 if(ctrlval==CTRL_SELECT && !mainsel)
	start_exanim();
}

void talk_to_earshot()

{

#ifdef CONSOLE_VERSION
 out_fade();
#endif

 StopCDMusic();
 setfn("esht.cmp");
 earsprs=(struct anim *)load_sprites(fn);
 setfn("esht0001.lbm");
 load_iffimage(fn,&earim,backpal);
 settop8cols(backpal);
 load_script_file(EARSHOT_fns[earscript]);
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();
 sprx=150;
 spry=35;
 sprw=128;
 sprh=165;
 animd=earsprs;
 backg=earim.data;

 noptions=1;
 init_vars();
 optxts=tlktxts[game_data.lang];
 opareas=exitarea;
 ctrl_func_p=earshot_ctrl;
 disp_func_p=man_disp;
 gen_qtab(0,80,transpal,backpal);
 man_disp();
 fade_in(backpal);
 animate_man();
 FreeMem();
 SoundFreeSamples();
}

/*************************************************************************/
/**************************                  *****************************/
/************************** WORKSHOP SECTION *****************************/
/**************************                  *****************************/
/*************************************************************************/



void wk_ctrl()
{int i;

 anim_exit();
 if(ctrlval==CTRL_SELECT)
	{
	 switch(mainsel)
		{
 		 case 0:
			status_screen();
			init_workshop();
			break;
		 case 1:
			if(!anim) 								/* make props putdown clipboard */
			  {
				for(i=42;i<=51;i++)
					{set_frame(i);
				 	 main_display();
				 	 wait(5);
					}
			  }
			stores();
			init_workshop();
			break;
		 case 2:
			start_exanim();
			break;
		}
	}
}

void init_workshop()
{
#ifdef CONSOLE_VERSION
 out_fade();
#endif

 StopCDMusic();
 setfn("stor.cmp");
 wksprs=(struct anim *)load_sprites(fn);
 setfn("stor0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();
 PlayCDTrack(WORKSHOP_TRACK);

 noptions=3;
 optxts=wrktxts[game_data.lang];
 opareas=wrkareas;
 ctrl_func_p=wk_ctrl;
 disp_func_p=main_display;
 sprx=242;
 spry=83;
 sprw=48;
 sprh=103;
 backg=backim.data;
 animd=wksprs;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 main_display();
 fade_in(backpal);
}

void workshop()

{

 init_workshop();
 anim=0;
 while(exitflg==FALSE)
  {

/* props animation */

   switch(anim)
	{
    case ST_START:
		animate1(0,randomr(50,100));
		anim=st_startn[random(2)];
		break;
	 case ST_WRITE:
		animate(1,9,5);
		wait_loop(randomr(100,200));
		animate(10,25,5);
		anim=ST_START;
		break;
	 case ST_LOOKUP:
		animate1(26,5);
		animate1(27,5);
	 case ST_HEADU:
		set_frame(28);
		wait_loop(randomr(50,100));
		anim=ST_HEADD+random(1);
		break;
	 case ST_HEADD:
		animate1(27,5);
		animate1(26,5);
		anim=START_ANIM;
		break;
	 case ST_LOOKR:
		animate1(29,5);
		animate1(30,5);
		wait_loop(randomr(50,100));
		anim= random(1) ? ST_HEADL:ST_HEADDR;
		break;
	 case ST_HEADDR:
		animate(32,35,5);
		anim=ST_START;
		break;
    case ST_HEADL:
		animate1(30,5);
		animate1(29,5);
		anim=ST_HEADU;
		break;
	 case ST_LOOKL:
		animate(36,41,5);
		wait_loop(randomr(50,100));
		animate(40,36,5);
		anim=ST_START;
		break;
	}
 }
 main_display();
 FreeMem();
}

/**************************************************************************/
/***************************               ********************************/
/*************************** STORES SCREEN ********************************/
/***************************               ********************************/
/**************************************************************************/


void stores_disp()
{
 struct img img;
 char s[40];
 int n;

/* prop frame */

 memcpy(scrptr,backim.data,320*200);
 propsprs->img.x=221;
 propsprs->img.y=43;
// propsprs->img.w=99;
// propsprs->img.h=157;
// img.data=propsprs+(frame*99*157);
 draw_anim_frame(propsprs,frame);

/* item frame */

 if(game_data.mission>1)
 	{
    upgsprs->img.x=0;
 	 upgsprs->img.y=44;
// 	 upgsprs->img.w=182;
// 	 upgsprs->img.h=156;
// 	 img.data=upgsprs+((upgr)*182*156);
 	 draw_anim_frame(upgsprs,upgrsprnos[upgr]);

/* display cashflow status */

 	disp_transbox(8,8,180,38);
 	sprint("CASHFLOW: $",20,16);
 	sprintf(s,"%d",game_data.money);
 	sprint(s,84,16);
 	disp_upgstat(upgr,20,28,255);

/* display item bar */

 	disp_transbox(7,161,270,24);
 	copy_image(&rarrim);
 	copy_image(&larrim);
 	n=stringlen(upgrds[game_data.lang][upgr]);
 	sprint(upgrds[game_data.lang][upgr],(142-(n/2)),163);
 	n=stringlen(costs[upgr]);
 	sprint(costs[upgr],(142-(n/2)),173);
  }

 disp_subs();

/********************** MODIFIED 12-1-96 **************************/

 if(game_data.mission>1){
 	dispexit();
 	disp_cursor();
	}
 dump_vram();
}

/******************************************************************/

/* atempt to buy an item - returns TRUE if item bought */

int buy_upgrade()
{

 if(game_data.money<item_costs[upgr])			/* not enough money */
	{sampno=1;											/* says this */
	 return FALSE;
	}

 switch(upgr)		  									/* buy it \got it */
	{

/****************** MODIFIED 12-1-96 *******************/

	 case 1:
		if(game_data.armlev==6)
			goto gotit;
		game_data.armlev+=1;
		game_data.armint+=8;
		break;
	 case 0:
		if(game_data.armint==game_data.armlev*8)
			goto gotit;
		game_data.armint+=8;
		if(game_data.armint>(game_data.armlev*8))
			game_data.armint=game_data.armlev*8;
	   break;
	 case 2:
		if(game_data.nsams==4)
			goto gotit;
		game_data.nsams++;
	   break;
//	 case 3:
//		if(game_data.mns)
//			goto gotit;
//		game_data.mns=1;
//	   break;
    case 3:
		if(game_data.relupg==4)
			goto gotit;
		game_data.relupg++;
	   break;
	 case 5:
		if(game_data.engupg==4)
			goto gotit;
		game_data.engupg++;
	   break;
	 case 6:
		if(game_data.trkupg==4)
			goto gotit;
		game_data.trkupg++;
		break;
	 case 4:
		if(game_data.tarupg==4)
			goto gotit;
		game_data.tarupg++;
	   break;
//	 case 6:
//		if(game_data.imageint)
//			goto gotit;
//		game_data.imageint=1;
//	   break;
	 case 7:
		if(game_data.airsupp)
			goto gotit;
		game_data.airsupp=1;
	   break;
	 case 8:
		if(game_data.cgunupg==4)
			goto gotit;
		game_data.cgunupg++;
	   break;

/************************************************************/


	}

 game_data.money-=item_costs[upgr];
 return TRUE;
gotit:
 sampno=4;
 return FALSE;
}

int get_sampleno()
{
 if(game_data.money>=item_costs[upgr])
		 return 2;
 else
		return 1;

}

void start_buyanim()
{
 if(TRUE==buy_upgrade()) 					/* bought it ? */
	 {
#ifdef CONSOLE_VERSION
		close_wad(wad_handle);
		prop_says_foreign(2);
		close_cinepak();
		reinit_filesys();
#else
		if(game_data.lang)
			prop_says_foreign(2);
		else
			prop_says(2);
#endif
	 }
 else 									  		/* nope - tough luck */
 	{
    anim=0;
	 frame=16;
  	 for(;frame<29;frame++)
	  	{if(frame==21)
	 		frame+=2;
		 wait_loop(5);
		}

	 start_props_speech(sampno);
 	}
}


void stores_ctrl()
{
}


void lookr_anim()
{

 if(--animfc<0)
 	{
 	 animfc=4;
	 frame--;
  	 if(frame<0)
		{
		 anim=0;
		 frame=0;
		 animhold=random(100);
		}
	}
}

void lookl_anim()
{

 if(--animfc<0)
	{animfc=4;
	 frame++;
 	 if(frame>=5)
		 {anim=STR_LOOKR;
		  animhold=random(100);
		 }
	}
}

void start_props_speech(int sampno)
{
#ifdef CONSOLE_VERSION
 close_wad(wad_handle);
 prop_says_foreign(sampno);
 close_cinepak();
 reinit_filesys();
#else
 if(game_data.lang)
	prop_says_foreign(sampno);
 else
	prop_says(sampno);
#endif
 frame=0;
}

void stores()
{

#ifdef CONSOLE_VERSION
 out_fade();
#endif

 FreeMem();
 StopCDMusic();
 setfn("wshp0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 setfn("wshp.cmp");
 propsprs=(struct anim *)load_sprites(fn);
 setfn("wshp1.cmp");
 upgsprs=(struct anim *)load_sprites(fn);
 setfn("larrow.bbm");
 load_iffimage(fn,&larrim,NULL);
 larrim.x=8;larrim.y=161;
 setfn("rarrow.bbm");
 load_iffimage(fn,&rarrim,NULL);
 rarrim.x=251;rarrim.y=161;
 load_prop_scripts();
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();
#ifdef PC_VERSION
 fade_out();
#endif

 noptions=4;
 buy=0;
 opareas=storareas;
 ctrl_func_p=stores_ctrl;
 disp_func_p=stores_disp;
 backg=backim.data;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 stores_disp();
 fade_in(backpal);
 anim=STR_STANDSTILL;
 animfc=5;animhold=gotalk=0;
 frame=ctrlval=0;

 if(game_data.mission==1)
	{
	 start_props_speech(0);
	 goto exit;
	}

 while(exitflg==FALSE)
	{
	 if(anim){
	  if(!animhold)					 					/* hold frame */
	 	{
		 switch(anim)
			{
		 	 case STR_LOOKL:
				lookl_anim();
				break;
		 	 case STR_LOOKR:
				lookr_anim();
				break;
			}
		}
	 else
			--animhold;
	}
 	 if(ctrlval==CTRL_SELECT)
		{
 	 	 if(mainsel==3)
			exitflg=TRUE;

	  	 else if(!mainsel && game_data.mission >1)
			{
			 if(++upgr==9)									  	/* next item */
				upgr=0;
			 if(!anim)
			 	anim=STR_LOOKL;
			}
	    else if(mainsel==1 && game_data.mission>1)
			{
			 if(--upgr<0)
				upgr=8;
			 	if(!anim)
			 		anim=STR_LOOKL;
			}
	    else if(mainsel==2 &&	game_data.mission>1)		/* buy the bugger ? */
 			{
			 if(anim==STR_LOOKL || anim==STR_LOOKR)
				{
				 while(anim)
				 	{lookr_anim();
					 wait_loop(1);
					}
				}
			 start_buyanim();
			 frame=0;
			}
	 	}
	 wait_loop(1);
 	}
 if(anim==STR_LOOKL || anim==STR_LOOKR)
	{
	 while(anim)
	 	{lookr_anim();
		 wait_loop(1);
		}
	}
 exitflg=FALSE;
 start_props_speech(3);
 anim_exit_icon();
 stores_disp();
exit:
 FreeMem();
 SoundStopAllSamples();
 SoundFreeSamples();
}


/***************************************************************************/
/***************************               *********************************/
/*************************** STATUS SCREEN *********************************/
/***************************               *********************************/
/***************************************************************************/


void stat_ctrl()
{int i,y;

 if(ctrlval==CTRL_SELECT)
  {
 	for(i=0,y=97;i<9;i++,y+=10)
		{
	 	if(mx>=20 && mx<=100 && my>=y && my< y+10)	/* MENU ????? */
			upgr=i;
		}
  }
 anim_exit();
 if(ctrlval==CTRL_SELECT)									/* quit */
	{
	 switch(mainsel)
		{
 		 case 0:
			start_exanim();
			break;
		}
	}
 switch(ctrlval)
	{
	 case CTRL_UP:
		if(--upgr<0)
			upgr=6;
		break;
	 case CTRL_DOWN:
		if(++upgr>6)
			upgr=0;
		break;
	}
}


/* display an upgrade status bar */

void disp_upgstat(int i,int x,int y,char txtcol)
{char **p;

 p=upgstattxts[game_data.lang];
 set_col(txtcol);
 switch(i){
 case 0:sprint(p[0],x,y);disp_statbar(x+100,y,6,game_data.armint,game_data.armlev);
 break;
 case 1:sprint(p[1],x,y);disp_statbar(x+100,y,6,game_data.armint,game_data.armlev);
 break;
 case 2:sprint(p[2],x,y);disp_statbar(x+100,y,4,game_data.nsams*8,game_data.nsams);
 break;
 case 3:sprint(p[3],x,y);disp_statbar(x+100,y,4,game_data.relupg*8,game_data.relupg);
 break;
 case 4:sprint(p[4],x,y);disp_statbar(x+100,y,4,game_data.tarupg*8,game_data.tarupg);
 break;
 case 5:sprint(p[5],x,y);disp_statbar(x+100,y,4,game_data.engupg*8,game_data.engupg);
 break;
 case 6:sprint(p[6],x,y);disp_statbar(x+100,y,4,game_data.trkupg*8,game_data.trkupg);
 break;
 case 7:sprint(p[7],x,y);disp_statbar(x+100,y,1,game_data.airsupp*8,game_data.airsupp);
 break;
 case 8:
	if(game_data.lang==FRENCH)
		{sprint(p[8],x,y);disp_statbar(x+125,y,4,game_data.cgunupg*8,game_data.cgunupg);}
	else
		{sprint(p[8],x,y);disp_statbar(x+100,y,4,game_data.cgunupg*8,game_data.cgunupg);}
 	break;
}
}



void stat_disp()

{struct img img;


 memcpy(scrptr,backim.data,320*200);


/* tank display */

 disp_3d_transbox(8,8,304,184);
 tssprs->img.x=20;
 tssprs->img.y=16;
 draw_anim_frame(tssprs,tanksprnos[upgr]);
 disp_upgstat(0,16,97,upgr==0?255:253);
 disp_upgstat(2,16,107,upgr==1?255:253);
 disp_upgstat(3,16,117,upgr==2?255:253);
 disp_upgstat(4,16,127,upgr==3?255:253);
 disp_upgstat(5,16,137,upgr==4?255:253);
 disp_upgstat(6,16,147,upgr==5?255:253);
 disp_upgstat(8,16,157,upgr==6?255:253);


 set_col(255);
 sprint(stinfotxt[game_data.lang][0],170,97);
 printnum_rev(game_data.money,300,97);
 sprint(stinfotxt[game_data.lang][1],170,107);
 printnum_rev(game_data.hitacc,300,107);
 sprint(stinfotxt[game_data.lang][2],170,117);
 printnum_rev(game_data.score,300,117);
 sprint(stinfotxt[game_data.lang][3],170,127);
 printnum_rev(game_data.bodycount,300,127);

 sprint(stinfotxt[game_data.lang][4],185,17);
 sprint(datelines[game_data.mission],265,17);

 dispexit();
 disp_cursor();
 dump_vram();
}



void status_screen()
{

/* load status screen stuff */

#ifdef CONSOLE_VERSION
 out_fade();
#endif

 StopCDMusic();
 setfn("stnk.cmp");
 tssprs=(struct anim *)load_sprites(fn);
 setfn("stat0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();
 PlayCDTrack(8);

 noptions=1;
 upgr=0;
 opareas=exitarea;
 ctrl_func_p=stat_ctrl;
 disp_func_p=stat_disp;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 memcpy(scrptr,backim.data,320*200);
 stat_disp();
 fade_in(backpal);

 while(exitflg==FALSE)
	wait_loop(1);

 stat_disp();
 FreeMem();
}


/***************************************************************************/
/***************************                     ***************************/
/*************************** LOCKER ROOM SECTION ***************************/
/***************************                     ***************************/
/***************************************************************************/

GAME_IOSTRUCT games[4];

enum{CHAR_DEL=37,CHAR_CLR,CHAR_OK};


  		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Animate open/close locker		 			  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void anim_locker()
{

/* open a menu */

 if(lockanim>0)
	{
    if(++lockfr==12)									/* done ? */
		{
		 noptions=0;
		 lockfr=11;
 		 if(!lockdisp)									/* expand meu */
			 {expand_3d_transbox(48,22,225,140,draw_lock_sprites);
			  lockdisp=1;
			 }
 		}
 	}

/* close */

 else if(lockanim<0)
	{
    if(--lockfr<0)
		{
		 lockanim=0;
		}
	}
}
void draw_lock_sprites()
{
 struct img img;

 locksprs[4]->img.x=263;
 locksprs[4]->img.y=100;
 draw_anim_frame(locksprs[4],frame);

 if(lockanim)
  {
 	locksprs[locker]->img.x=lockx;
	locksprs[locker]->img.y=locky;
   draw_anim_frame(locksprs[locker],lockfr/4);
  }
}


#ifndef NON_CONSOLE_VERSION

/***************************************************************************/
/******************               PSX CODE   				*******************/
/***************************************************************************/


#ifdef PSX_VERSION


/********************* DUMMY PSX MEM CARD FUNCS *****************/


void PSX_SaveGameData(int slot)
{
}

void PSX_DeleteGame(int slot)
{
}

void PSX_LoadGame(int slot)
{
}

int PSX_IsCardInSlot(int slot)
{

 return TRUE;
}

int PSX_IsCardFormatted(int slot)
{
 return TRUE;
}


void PSX_FormatCard(int slot)
{
}

int PSX_IsShokDataInCard(int slot)
{
 return TRUE;
}

int PSX_IsOneBlockFree(int slot)
{
 return TRUE;
}


void sprint_new(char *s,int num,int x,int y)
{
 char c;

 while(c=*s++)
 	{
	 if(c=='%')
		c=num+'0';
	 x+=print_char(x,y,c);
	}
}

void load_buttsprs()
{
 int i;
 static char *buttfns[]={
	"butt1.bbm",
	"butt2.bbm",
	"butt3.bbm",
	"butt4.bbm",
	"butt5.bbm",
	"butt6.bbm"
	};

 for(i=0;i<6;i++)
	{
	 setfn(buttfns[i]);
	 load_iffimage(fn,&psx_buttsprs[i],NULL);
	}

}

void print_message(char *txt,int num)
{
 int txtlen;

 copy_background();
 txtlen=stringlen(txt);
 disp_3d_transbox(160-(txtlen/2)-10,85,txtlen+20,30);
 set_col(255);
 sprint_new(txt,num,160-(txtlen/2),95);
 dispexit();
 disp_cursor();
 dump_screen();
}

void copy_background()
{
 memcpy(scrptr,backim.data,320*200);
 draw_lock_sprites();
}

void draw_button(int butt,char *txt,int x,int y)
{
 psx_buttsprs[butt].x=x;
 psx_buttsprs[butt].y=y;
 copy_spr(&psx_buttsprs[butt]);
 sprint(txt,x+30,y+2);
}


int PSX_Save(int slot)
{

 for(;;)
	{
 	 copy_background();
 	 disp_3d_transbox(80,70,160,70);
 	 sprint(psx_msg3[game_data.lang],140,82);
	 draw_button(PSX_CIRCLE_BUTT,psxiotxt[3][game_data.lang],140,100);
	 draw_button(PSX_CROSS_BUTT,psxiotxt[4][game_data.lang],140,118);
 	 dispexit();
 	 disp_cursor();
	 dump_screen();
 	 read_joypad();
 	 if(ctrlval==CTRL_SELECT)
		{
	 	 PSX_SaveGameData(slot);
	 	 for(;;)
 	 		{
	 	 	 print_message(slot?psx_slot2txt[7][game_data.lang]:psx_slot1txt[7][game_data.lang],locker+1);
		 	 read_joypad();
		 	 if(ctrlval)
				return TRUE;

			}
		}
 	 else	if(ctrlval==CTRL_CANCEL)
		return TRUE;
 	}
}


int PSX_MEMCardManager(int slot)
{
 if(TRUE==PSX_IsCardInSlot(slot))
	{
	 if(TRUE==PSX_IsCardFormatted(slot))
		{
		 if(FALSE==PSX_IsShokDataInCard(slot))
			{
			 if(FALSE==PSX_IsOneBlockFree(slot))
				{
				 if(slot==1)
					{
					}
				 return FALSE;
				}
			 else
				return PSX_Save(slot);
			}
		 else
			{
			 if(games[locker].flag)
				return PSX_Save(slot);
			 else
				{
		 	 		 copy_background();
 	 	 	 		 disp_3d_transbox(90,50,140,110);
	 	 		 	 sprint(psx_msg4[game_data.lang],138,60);
					 printnum(games[locker].mission,190,60);
	 				 draw_button(PSX_CIRCLE_BUTT,psxiotxt[0][game_data.lang],130,80);
	 				 draw_button(PSX_SQUARE_BUTT,psxiotxt[1][game_data.lang],130,98);
	 				 draw_button(PSX_TRI_BUTT,psxiotxt[2][game_data.lang],130,116);
	 				 draw_button(PSX_CROSS_BUTT,psxiotxt[4][game_data.lang],130,134);
 	 				 dispexit();
 	 				 disp_cursor();
	 		 		 dump_screen();
					 for(;;)
						{
		 	 		 	 read_joypad();
		 	 			 switch(ctrlval)
							{
						 	 case CTRL_SELECT:	 	// delete
							 	 print_message(slot?psx_slot2txt[2][game_data.lang]:psx_slot1txt[2][game_data.lang],locker+1);
								 for(;;)
									{
 	 								 read_joypad();
									 if(ctrlval==CTRL_SELECT)
										{
							 	 	 	 PSX_DeleteGame(slot);
										 print_message(slot?psx_slot2txt[3][game_data.lang]:psx_slot1txt[3][game_data.lang],locker+1);
										 do{read_joypad();}while(!ctrlval);
									 	 return TRUE;
										}
								 	else if(ctrlval==CTRL_CANCEL)
										return TRUE;
									}
							 	break;
						 	 case CTRL_UP:	 		// load
							 	 print_message(slot?psx_slot2txt[4][game_data.lang]:psx_slot1txt[4][game_data.lang],locker+1);
								 for(;;)
									{
 	 								 read_joypad();
									 if(ctrlval==CTRL_SELECT)
										{
							 	 	 	 PSX_LoadGame(slot);
										 print_message(slot?psx_slot2txt[5][game_data.lang]:psx_slot1txt[5][game_data.lang],locker+1);
									 	 do{read_joypad();}while(!ctrlval);
									 	 return TRUE;
										}
								 	else if(ctrlval==CTRL_CANCEL)
										return TRUE;
									}
							 	break;
						 	 case CTRL_DOWN:	 	// overwrite
							 	 print_message(slot?psx_slot2txt[6][game_data.lang]:psx_slot1txt[6][game_data.lang],locker+1);
	 	 	 					 for(;;)
									{
 	 								 read_joypad();
									 if(ctrlval==CTRL_SELECT)
										{
							 	 	 	 PSX_SaveGameData(slot);
							 		 	 print_message(slot?psx_slot2txt[7][game_data.lang]:psx_slot1txt[7][game_data.lang],locker+1);
									 	 do{read_joypad();}while(!ctrlval);
									 	 return TRUE;
										}
								 	else if(ctrlval==CTRL_CANCEL)
										return TRUE;
									}
							 	break;

							}
						}
				}

			}

		}
	}



}


void save_games()
{}
void load_games()
{}

void lock_disp()
{
 int i,j,x,y,c;

 memcpy(scrptr,backim.data,320*200);
 draw_lock_sprites();

 if(mainsel>=0 && !lockdisp)
 	print_textbar(optxts[mainsel],-1,180);
 dispexit();
 disp_cursor();
 dump_vram();
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Initialise						 			  	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void init_lock()
{int i;

#ifdef CONSOLE_VERSION
 out_fade();
#endif

 StopCDMusic();
 setfn("lock0001.lbm");
 load_iffimage(fn,&backim,backpal);
 load_buttsprs();
 settop8cols(backpal);
 for(i=0;i<5;i++)
	{setfn(lockfns[i]);
	 locksprs[i]=(struct anim *)load_sprites(fn);
	}
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();
 PlayCDTrack(DOGGTAG_TRACK);

 noptions=7;
 optxts=locktxts[game_data.lang];
 opareas=lockareas;
 ctrl_func_p=lock_ctrl;
 disp_func_p=lock_disp;
 backg=backim.data;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 lock_disp();
 fade_in(backpal);
 lockfr=lockanim=locker=lockdisp=0;
}

void lock_ctrl()
{
 if(ctrlval==CTRL_SELECT && !lockdisp)
	{

	 selected=TRUE;
	 exitflg=TRUE;
	}

}

void locker_room()
{
 init_lock();
 for(;;)
 	{
	 if(exitflg==TRUE && !lockdisp )
		break;
	 switch(anim)
		{
		 case 0:
			set_frame(0);
			wait_loop(randomr(50,100));
			anim=random(3)+1;
			break;
		 case 1:
			animate(1,3,5);
			wait_loop(randomr(50,100));
			animate1(2,5);
			animate1(1,5);
			anim=0;
			break;
		 case 2:
			animate(4,6,5);
			wait_loop(randomr(50,100));
			animate1(5,5);
			animate1(4,5);
			anim=0;
			break;
		 case 3:
			animate(8,14,5);
			wait_loop(randomr(100,200));
			animate(13,7,5);
			anim=0;
			break;
		 case 4:
			animate(15,19,5);
			wait_loop(randomr(100,200));
			animate(18,15,5);
			anim=0;
			break;
		}
 	if(selected==TRUE)
		{
	 	 selected=FALSE;
	 	 switch(mainsel)
			{
			 case 0:
			 case 1:
			 case 2:
			 case 3:
			 	lockdisp=0;
			 	lockanim=1;								/* init animation */
			 	lockfr=0;
			 	locker=mainsel;
			 	lockx=locksprx[locker];
			 	locky=lockspry[locker];
			 	lockw=locksprw[locker];
			 	lockh=locksprh[locker];
			 	lockmenu.items[0].flags&=~DISABLED;
			 	lockmenu.items[1].flags&=~DISABLED;
			 	lockmenu.curritem=2;
			 	while(!lockdisp)
					{
				 	 anim_locker();
				 	 wait_loop(5);
					}
				if(FALSE==PSX_MEMCardManager(0))
					PSX_MEMCardManager(1);
				lockanim=-1;
				while(lockanim)
					{
				 	 anim_locker();
				 	 wait_loop(5);
					}
				lockdisp=0;
 				noptions=7;
				exitflg=FALSE;
				break;
		 	 case 4:
		 		FreeMem();
		 		briefing_screen();
		 		disp_func_p=NULL;
		 		exitflg=TRUE;
				break;
		 	 case 5:
		 		talk_to_doggtag();
				init_lock();
				break;
			}
		}
	}

 if(disp_func_p)
 	lock_disp();
 FreeMem();
}


#endif

/***************************************************************************/
/******************        SATURN MEM CARD CODE 			*******************/
/***************************************************************************/

#ifdef SATURN_VERSION






#endif

#endif


/***************************************************************************/
/******************                  PC CODE  				*******************/
/***************************************************************************/

#ifdef NON_CONSOLE_VERSION

int save_games()
{
 FILE *fp;
 char fn[128];

 strcpy(fn,installDir);
 strcat(fn,"shock.gms");
 if(!(fp=fopen(fn,"wb") ))
	{
	 return -1;
	}
 fwrite(games,1,sizeof(GAME_IOSTRUCT)*4,fp);
 fclose(fp);
 return 0;


}


void load_games()
{


 FILE *fp;
 char fn[128];

 strcpy(fn,installDir);
 strcat(fn,"shock.gms");
 if(!(fp=fopen(fn,"rb") ))
	 return;
 fread(games,1,sizeof(games),fp);
 fclose(fp);


}


//void password_keyboard_entry()
//{
// char c;
//
// if(keydeb(K_BSP))
// 		{if(passlen)
// 		    {--passlen;
// 		     password[passlen]=0;
// 		    }
// 		}
// else if(keydeb(K_DELETE))
//		{password[0]=0;
//		 passlen=0;
//		}
// else if(keydeb(K_RET))
//		{
//		 if(passlen<PASSWORD_SIZE)
//			lockdisp=3;
//		 else
//			{
//			 if(!validate_password())
//		 		lockdisp=3;
//		 	 else
//		 		{lockdisp=2;			 						/* password o.k. */
// 				 select_character_scripts();
//				}
//			}
//		}
//
// else if(passlen<PASSWORD_SIZE)
//	{
//	 if(c=ascchars[key])
//    	{
//		 if(c>='A' && c<='Z')
//		 	password[passlen++]=c-'A';
//	 	 else if(c>='0' && c<='9')
//		 	password[passlen++]=c-'0'+26;
//		}
// 	}
//}
//#endif
//
//
//void password_accepted()
//{
//#ifdef PC_VERSION
// if(keydeb(K_SPACE) || ctrlval==CTRL_SELECT || ctrlval==CTRL_CANCEL)
//#else
// if(ctrlval==CTRL_SELECT || ctrlval==CTRL_CANCEL)
//#endif
//	 	{
//		 lockdisp=0;
//	 	 lockanim=-1;
//	 	 noptions=7;
//		 passlen=0;
//		}
//}
//
//void password_invalid()
//{
//#ifdef PC_VERSION
// if(keydeb(K_SPACE) || ctrlval==CTRL_SELECT || ctrlval==CTRL_CANCEL)
//#else
// if(ctrlval==CTRL_SELECT || ctrlval==CTRL_CANCEL)
//#endif
//	lockdisp=1;
//}
//
//void password_entry()
//{
//#ifdef PC_VERSION
// password_keyboard_entry();
//#endif
//
// switch(ctrlval)
//	{
//	 case CTRL_LEFT:
//		if((--curx)<0)curx=7;
//		break;
//	 case CTRL_RIGHT:
//		if((++curx)==8)curx=0;
//		break;
//	 case CTRL_UP:
//		if((--cury)<0)cury=4;
//		break;
//	 case CTRL_DOWN:
//		if((++cury)==5)cury=0;
//		break;
//	}
//#ifdef CONSOLE_VERSION
// if(ctrlval==CTRL_SELECT)
//#else
// if(keydeb(K_SPACE))
//#endif
//	{
//		if(passchar==CHAR_DEL)
//			{if(passlen)
//			    {--passlen;
//			     password[passlen]=0;
//			    }
//			}
//		else if(passchar==CHAR_CLR)
//			{password[0]=0;
//			 passlen=0;
//			}
//		else if(passchar==CHAR_OK)
//			{
//			 if(passlen<PASSWORD_SIZE)
//				lockdisp=3;
//			 else
//				{
//				 if(!validate_password())
//			 		lockdisp=3;
//			 	 else
//			 		lockdisp=2;
//				}
//			}
//		else
//			{
//			 if(passlen<PASSWORD_SIZE)
//			 	{
//				 password[passlen++]=passchar;
//			 	 password[passlen]=0;
//				}
//			}
//	}
// passchar=(8*cury)+curx;
//}
//
//void encode_game_data(char *password)
//
//{
// unsigned char b,cs;
// int i,j,bitn,byten;
// unsigned char *p;
//
// eg.level=game_data.mission;
// eg.score=game_data.score/500;
// eg.cashflow=game_data.money/500;
// eg.hitacc=game_data.hitacc;
// eg.armint=game_data.armint/8;
// eg.armlev=game_data.armlev;
// eg.sams=game_data.nsams;
// eg.mnsup=game_data.mns;
// eg.reloadup=game_data.relupg;
// eg.targup=game_data.tarupg;
// eg.engup=game_data.engupg;
// eg.trkup=game_data.trkupg;
// eg.nights=game_data.imageint;
// eg.cgunup=game_data.cgunupg;
// eg.checksum=0;
// eg.fill=0;
//
// cs=0x55;
// p=(unsigned char *)&eg;
//
///***************** MODIFIED 15-1 ******************/
//
// for(i=0;i<10;i++)  			  							// get checksum
//
///**************************************************/
//
//	cs^=p[i];
// eg.checksum=cs;
// bitn=byten=0;
// for(i=0;i<PASSWORD_SIZE;i++)							// encode -
//	{
//	 b=0;
//	 for(j=0;j<5;j++)								  		// encode 5 bits into a char
//		{
//		 if(p[byten]&(1<<bitn))
//			{
//		    b|=(1<<j);
//			}
//		 else
//			{
//			 b&=~(1<<j);
//			}
//		 if((++bitn)>7)				 					// next bit
//			{byten++;bitn=0;}
//		}
//	 *password++=b;
//	}
// passlen=PASSWORD_SIZE;
//}
//
//int decode_game_data(char *password)
//{
// unsigned char b,cs;
// int i,j,bitn,byten;
// unsigned char *p;
//
//
// p=(unsigned char *)&eg;
// bitn=byten=0;
// for(i=0;i<PASSWORD_SIZE;i++)							// decode
//	{
//	 for(j=0;j<5;j++)
//		{
//		 if(password[i]>31)
//			return 0;
//		 if(password[i]&(1<<j))
//			{
//			 p[byten]|=(1<<bitn);
//			}
//		 else
//			{
//			 p[byten]&=~(1<<bitn);
//			}
//		 if((++bitn)>7)
//			{bitn=0;byten++;}
//		}
//
//	}
// b=eg.checksum;
// eg.checksum=0;
// cs=0x55;
//
///***************** MODIFIED 15-1 ******************/
//
// for(i=0;i<10;i++)			  								// get checksum
//
///**************************************************/
//
//	cs^=p[i];
// if(cs!=b)												   // same ?
//	return 0;
// game_data.mission=eg.level;
// game_data.score=eg.score*500;
// game_data.money=eg.cashflow*500;
// game_data.hitacc=eg.hitacc;
// game_data.armint=eg.armint*8;
// game_data.armlev=eg.armlev;
// game_data.nsams=eg.sams;
// game_data.mns=eg.mnsup;
// game_data.relupg=eg.reloadup;
// game_data.tarupg=eg.targup;
// game_data.engupg=eg.engup;
// game_data.trkupg=eg.trkup;
// game_data.imageint=eg.nights;
// game_data.cgunupg=eg.cgunup;
// return 1;
//}
//
//
//int validate_password()
//{
//
// return decode_game_data(password);
//
//}
//
//void print_password(int x,int y)
//{char c;
// int i;
//
// for(i=0;i<passlen;i++)
//	{
//	 c=password[i];
//	 if(c==36)
//		{print_char(x,y,0);x+=7;}
//	 else if(c>=26)
//	 	x+=print_char(x,y,c-26+'0');
//	 else
//	  	x+=print_char(x,y,c+'A');
//	}
//}
//


  		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Screen update						 			  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void lock_disp()
{int i,j,x,y,c;

 memcpy(scrptr,backim.data,320*200);
 draw_lock_sprites();

// if(lockdisp==3)												/* 'invalid password */
//	{
//	 disp_3d_transbox(85,85,150,20);
//	 set_col(255);
//	 x=160-(stringlen(passerrtxt[game_data.lang])/2);
//	 sprint(passerrtxt[game_data.lang],x,92);
//	}																/* 'password accepted' */
// else if(lockdisp==2)
//	{
//	 disp_3d_transbox(85,85,150,20);
//	 set_col(255);
//	 x=160-(stringlen(passaccepttxt[game_data.lang])/2);
//	 sprint(passaccepttxt[game_data.lang],x,92);
//	}
// else if(lockdisp==1)					 					/* password entry */
//	{
//	 disp_3d_transbox(60,50,200,120);
//	 set_col(252);
//	 x=160-(stringlen(entertxt[game_data.lang])/2);
//	 sprint(entertxt[game_data.lang],x,58);
//	 set_col(255);
//	 print_password(90,75);
//	 lbox(82,72,236,85,248,253);
//
///* print char array */
//
//	 for(c=0,i=0,y=95;i<5;i++,y+=12)
//		{
//		 for(j=0,x=73;j<8;j++,x+=24)
//			{
//			 if(c==passchar)						  			/* highlight */
//				{
//				 lbox(x-4,y-2,x+11,y+10,251,251);
//				}
//			 set_col(c==passchar?255:253);
//			 if(c==36)
//				{print_char(x-2,y,21);
//				 print_char(x-2+8,y,22);
//				}
//			 else if(c>=37)
//				{print_char(x-2,y,((c-37)*2)+15);	 	/* ctrl chars (2 chars each) */
//				 print_char(x-2+8,y,((c-37)*2)+16);
//				}
//			 else if(c>=26)
//				print_char(x,y,c-26+'0');
//			 else
//			 	print_char(x,y,c+'A');
//			 c++;
//			}
//		}
//	}
//


 if(lockdisp==2)
	{
    i=stringlen(gsavetxt[game_data.lang]);
	 set_col(255);
	 disp_3d_transbox(160-(i/2)-10,90,i+20,30);
	 sprint(gsavetxt[game_data.lang],160-(i/2),100);
	}
 else if(lockdisp==3)
	{
    i=stringlen(gloadtxt[game_data.lang]);
	 set_col(255);
	 disp_3d_transbox(160-(i/2)-10,90,i+20,30);
	 sprint(gloadtxt[game_data.lang],160-(i/2),100);
	}
 else if(lockdisp==1)
	 {
	  disp_3d_transbox(45,50,230,110);
	  set_col(252);

// 	  sprint(loadsavetxt[game_data.lang][0],85,30);
//     print_char(215,30,locker+1+'0');


	 if(games[locker].flag)
	  {
	 	set_col(255);
	 	sprint(loadsavetxt[game_data.lang][1],85,60);
	 	printnum(games[locker].mission,215,60);

 	 	sprint(loadsavetxt[game_data.lang][2],85,70);
 	 	printnum(games[locker].money,215,70);

 	 	sprint(loadsavetxt[game_data.lang][3],85,80);
    	printnum(games[locker].hitacc,215,80);

 	 	sprint(loadsavetxt[game_data.lang][4],85,90);
 	 	printnum(games[locker].score,215,90);

	 	sprint(loadsavetxt[game_data.lang][6],85,100);
	 	disp_statbar(215,100,0,games[locker].armint,games[locker].armlev);

	  }

	 else
	  {
	 	set_col(253);
    	sprint(loadsavetxt[game_data.lang][7],150,95);
	  }
   print_menu(&lockmenu);
  }


 if(mainsel>=0 && !lockdisp)
 	print_textbar(optxts[mainsel],-1,180);
 dispexit();
 disp_cursor();
 dump_vram();
}


  		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Initialise						 			  	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void init_lock()
{int i;

#ifdef CONSOLE_VERSION
 out_fade();
#endif

 StopCDMusic();
 setfn("lock0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 for(i=0;i<5;i++)
	{setfn(lockfns[i]);
	 locksprs[i]=(struct anim *)load_sprites(fn);
	}
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();
 PlayCDTrack(DOGGTAG_TRACK);

 noptions=7;
 optxts=locktxts[game_data.lang];
 opareas=lockareas;
 ctrl_func_p=lock_ctrl;
 disp_func_p=lock_disp;
 backg=backim.data;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 lock_disp();
 fade_in(backpal);
 lockfr=lockanim=locker=lockdisp=0;
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Locker menu selection screen	 			  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void lock_ctrl()
{int i;

 anim_exit();

 anim_locker();

// if(lockdisp==1)
// 	password_entry();
// else if(lockdisp==2)
//	password_accepted();
// else if(lockdisp==3)
//	password_invalid();
//

 if(exitflg==TRUE && lockdisp)
		{
	 	 lockdisp=0;
	 	 lockanim=-1;
	 	 noptions=7;
		 exitflg=FALSE;
		 return;
	 	}

/* loaded/saved message exit test */

 if(lockdisp==2 || lockdisp==3)
	{
	 if(ctrlval==CTRL_SELECT | ctrlval==CTRL_CANCEL)
	 	{
		 lockdisp=0;
	 	 lockanim=-1;
	 	 noptions=7;
		 exitflg=FALSE;
		 return;
		}
	}

/* load /save game menu activated */


 if(lockdisp==1)
 	{

 	 if(exitflg==TRUE)
		{
	 	 lockdisp=0;
	 	 lockanim=-1;
	 	 noptions=7;
		 exitflg=FALSE;
		 return;
	 	}
 	 i=menu_selector(&lockmenu);
 	 if(i>=0)
		{
		 switch(i)
				{
		 	 	 case 0:
					game_data=games[locker];
					select_character_scripts();
					lockdisp=3;
					lock_disp();
					break;
			 	 case 1:
					games[locker]=game_data;
					games[locker].flag=1;
					save_games();
					lockdisp=2;
					lock_disp();
					break;
				 case 2:
 	 	 			lockdisp=0;
  	 	 			lockanim=-1;
 	 	 			noptions=7;
					break;
				}
    	}
	}


 if(ctrlval==CTRL_SELECT && !lockdisp)
	{

	 if(mainsel==6)
		start_exanim();


/* open up a locker */

	 else if(mainsel<4)
		{
		 if(!lockanim)									/* already open ?*/
			{
			 lockanim=1;								/* init animation */
			 lockfr=0;
			 locker=mainsel;
			 lockx=locksprx[locker];
			 locky=lockspry[locker];
			 lockw=locksprw[locker];
			 lockh=locksprh[locker];


			 lockmenu.items[0].flags&=~DISABLED;
			 lockmenu.items[1].flags&=~DISABLED;
			 lockmenu.curritem=2;

			 if(games[locker].flag)
				{
				 if(game_data.mission==1)
					lockmenu.items[1].flags|=DISABLED;
				}
			 else
				{
				 lockmenu.items[0].flags|=DISABLED;
				 if(game_data.mission==1)
					 lockmenu.items[1].flags|=DISABLED;
				}
			}
		}

/* enter briefing and GAME */

	 else if(mainsel==4 || mainsel==5)
		{
		 selected=TRUE;
		 exitflg=TRUE;
		}
	}
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Main animation loop 			 			  	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void locker_room()
{

 init_lock();
// password[0]=passlen=passerr=passaccept=0;
 for(;;)
 	{
	 if(exitflg==TRUE && !lockdisp )
		break;
	 switch(anim)
		{
		 case 0:
			set_frame(0);
			wait_loop(randomr(50,100));
			anim=random(3)+1;
			break;
		 case 1:
			animate(1,3,5);
			wait_loop(randomr(50,100));
			animate1(2,5);
			animate1(1,5);
			anim=0;
			break;
		 case 2:
			animate(4,6,5);
			wait_loop(randomr(50,100));
			animate1(5,5);
			animate1(4,5);
			anim=0;
			break;
		 case 3:
			animate(8,14,5);
			wait_loop(randomr(100,200));
			animate(13,7,5);
			anim=0;
			break;
		 case 4:
			animate(15,19,5);
			wait_loop(randomr(100,200));
			animate(18,15,5);
			anim=0;
			break;
		}
 if(selected)
	{
	 selected=FALSE;
	 switch(mainsel)
		{
		 case 4:
		 	FreeMem();
		 	briefing_screen();
		 	disp_func_p=NULL;
		 	exitflg=TRUE;
			break;
		 case 5:
		 	talk_to_doggtag();
			init_lock();
			break;
		}
	}
  }
 if(disp_func_p)
 	lock_disp();
 FreeMem();
}

#endif



/**************************************************************************/
/****************************                 *****************************/
/**************************** Dogg-tag screen *****************************/
/****************************                 *****************************/
/**************************************************************************/

void dogg_ctrl()
{
 anim_exit();
 if(ctrlval==CTRL_SELECT && !mainsel)
	start_exanim();
}


void talk_to_doggtag()

{

/* load dogg-tag graphics */

#ifdef CONSOLE_VERSION
 out_fade();
#endif

 StopCDMusic();
 setfn("dogg0001.lbm");
 load_iffimage(fn,&doggim,backpal);
 setfn("dogg.cmp");
 doggsprs=(struct anim *)load_sprites(fn);
 settop8cols(backpal);
 load_script_file(DOGGTAG_fns[dogscript]);
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();

 sprx=201;
 spry=49;
 sprw=119;
 sprh=151;
 animd=doggsprs;
 backg=doggim.data;

 noptions=1;
 init_vars();
 optxts=tlktxts[game_data.lang];
 opareas=exitarea;
 ctrl_func_p=dogg_ctrl;
 disp_func_p=man_disp;
 gen_qtab(0,80,transpal,backpal);
 man_disp();
 fade_in(backpal);
 animate_man();
/*
 for(i=1;i<=13;i++)
	{load_script_file(DOGGTAG_fns[i]);
	 animate_man();
	 FreeMem();
	}

*/

 man_disp();
 FreeMem();
 SoundFreeSamples();
}

/***************************************************************************/
/**************************                   ******************************/
/************************** MISSION BRIEFINGS ******************************/
/**************************                   ******************************/
/***************************************************************************/


  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			SETANIM command 	(name,frame) 			  	  *
		 *			Sets frame for given character				  *
		 *																	  *
		 *																	  *
		 *****************************************************/

void set_anim()
{


#ifndef US_MODIFIED_VERSION

 get_commarg();
 if(!strcmp(charface,argbuff))
	{get_commarg();
	 animfr=atoi(argbuff)-1;
	}
 else
	{get_commarg();
	 animfr1=atoi(argbuff)-1;
	}
#endif

}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Load animation graphics							  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void load_charsay_stuff()
{

 if(backloaded==FALSE)
	 {

#ifdef CONSOLE_VERSION
	  fade_out();
#endif
	  setfn(BACK_fns[facepic]);
	  load_iffimage(fn,&backim,backpal);

#ifndef US_MODIFIED_VERSION
	  setfn(CHARFACE_fns[facepic]);
	  brief1sprs=(struct anim *)load_sprites(fn);
	  facsprx=CHARFACE_pos[facepic*2];
	  facspry=CHARFACE_pos[(facepic*2)+1];
	  facsprw=sw;
	  facsprh=sh;
	  setfn(CHARAWAY_fns[awypic]);
	  brief2sprs=(struct anim *)load_sprites(fn);
#endif

#ifdef PC_VERSION
	  fade_out();
#endif
	  awsprx=CHARAWAY_pos[awypic*2];
	  awspry=CHARAWAY_pos[(awypic*2)+1];
	  awsprw=sw;
	  awsprh=sh;
	  backloaded=TRUE;
	  briefdisp=0;
     nstrs=0;
     gen_qtab(0,80,transpal,backpal);
 	  settop8cols(backpal);
#ifndef US_MODIFIED_VERSION
	  briefing_disp();
	  fade_in(backpal);
#endif
	 }
}


  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Set up frame pointer for talking anim		  *
		 *			(animfr is char facing )						  *
		 * 		tlkfr_p - talking animation pointer			  *
 		 * 		tlkfr1_p - listening								  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void init_talkanim()
{
 get_commarg();
 if(!strcmp(charface,argbuff))
	{tlkfr_p=&animfr;lstfr_p=&animfr1;}
 else
	{tlkfr_p=&animfr1;lstfr_p=&animfr;}
 get_commarg();
 tlkanim=atoi(argbuff);

/* set talking frames */

	{
	 if(tlkanim<=3)
 		{tlkanim=random(2)+1;
 	 	 switch(tlkanim)
 			{
 	  	 	 case 1:
 				basefr=8;tlkfrm1=24;
 				break;
 	  	 	 case 2:
 				basefr=9;tlkfrm1=28;
 				break;
 	  	 	 case 3:
 				basefr=10;tlkfrm1=32;
 				break;
			}
 	 	}
 	 else if(tlkanim==5)
		{
	 	 basefr=15;
	 	 tlkfrm1=36;
		}

	}

/* set up listening character animation  */

 get_commarg();
  lstanim=atoi(argbuff);
}


  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Scan script file an execute commands		  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


int charsay_loaded=FALSE;

int process_script_file()
{
 int i,n;
 uword scoffbs;


 i=0;scoff=0;
 backloaded=FALSE;
 charsay_loaded=FALSE;
 while(get_line()!=-1)
 {
  if(linelen){
    n=interpret_command();
    switch(n)
		{
		 case SCOM_SETDOGG: 									/* set dogg background */
			get_commarg();
			doggpic=atoi(argbuff);
			break;
	    case SCOM_DATELINE:									/* display dateline */
 			FreeMem();
			get_commarg();
			fade_out();
			load_script_file(sfn);
 			load_fontdata("font2.lbm",&font2);
 			font2.w=16;
 			font2.h=16;
 			setfont(&font2);
			set_col(1);
 			memset(backpal,0,256*3);			  			/* black pal */
		   backpal[4]=0x2b; 									/* text col */
 			memset(scrptr,0,320*200);
 			sprint(argbuff,8,90);							/* print dateline */
			 dump_screen();

#ifdef PC_VERSION
			fade_to_pal(FADEOUT_RATE,backpal);			/* fade in */
			wait_fade();
#else
			in_fade(backpal);
#endif
			for(i=0;i<300;i++)
				{ScreenWaitVbl();
				 read_joypad();
				 if(ctrlval==CTRL_SELECT || ctrlval==CTRL_CANCEL)
					break;

				}
#ifdef PC_VERSION
			fade_to_pal(FADEOUT_RATE,fadepal);
			wait_fade();
#else
//			fade_out();
#endif
			setfont(&font1);
			break;
	 	 case SCOM_SETMAN:			 						/* back pic */
			get_commarg();
			manpic=atoi(argbuff);
			break;
		 case SCOM_SETMAP1:									/* back pic */
			get_commarg();
			mappic1=atoi(argbuff);
			break;
		 case SCOM_SETMAP2:								   /* back pic */
			get_commarg();
			mappic2=atoi(argbuff);
			break;
	 	 case SCOM_SETFACING:								/* set name of char facing */
			get_commarg();
			strcpy(charface,argbuff);
			get_commarg();
			facepic=atoi(argbuff);
			break;
	 	 case SCOM_SETAWAY:
			get_commarg();
			strcpy(charaway,argbuff);
			get_commarg();
			awypic=atoi(argbuff);
			break;
	 	 case SCOM_SETANIM:	 								/* set character frame */
			set_anim();
			break;
		 case SCOM_SHOWFRAME:
			load_charsay_stuff();
			wait_loop(5);
			break;
		 case	SCOM_SETDRAW:								  	/* set draw order of sprites */
			get_commarg();
			draworder=atoi(argbuff);
			break;
	 	 case SCOM_BRIEFSTART:								/* start briefing */
			scoffbs=scoff;
			for(;;)
				{
				 if(exitflg==TRUE)
					return 0;
				 get_line();
				 if(linelen>1)
					{
				 	 n=interpret_command();
				 	 switch(n)
						{
						 case SCOM_PAUSEFRAME:
							get_commarg();
							wait_loop(atoi(argbuff));
							break;
		 			 	 case SCOM_SETANIM:
							set_anim();
					 		break;
				    	 case SCOM_SHOWFRAME:
 							load_charsay_stuff();
						 	wait_loop(5);
							break;
		 			 	 case SCOM_BRIEFEND:
							FreeMem();
							SoundFreeSamples();
							return 0;
						 case SCOM_CHARTXT:
							break;
						 case SCOM_MAPSAY1:
							nstrs=0;
							briefdisp=1;
							load_sample();
							setfn(MAPPIC_fns[mappic1]);
							goto doscr;
						 case SCOM_MAPSAY2:
							nstrs=0;
							briefdisp=1;
							load_sample();
							setfn(MAPPIC_fns[mappic2]);
							goto doscr;
						 case SCOM_MANSAY:
					   	FreeMem();
						   backloaded=FALSE;
							nstrs=0;
							briefdisp=1;
							load_sample();
							load_script_file(sfn);
							setfn(MANPIC_fns[manpic]);
doscr:
							charsay_loaded=FALSE;
							#ifdef PC_VERSION
							load_iffimage(fn,&backim,backpal);
							fade_out();
							#else
							fade_out();
							load_iffimage(fn,&backim,backpal);
							#endif
 							gen_qtab(0,80,transpal,backpal);
 							settop8cols(backpal);
							briefing_disp();
							fade_in(backpal);
							shandle=SoundPlaySample(0,game_data.soundvol,100,0x8000);
#ifdef CONSOLE_VERSION
 							close_wad(wad_handle);
	  						do_subs_foreign();
 							close_cinepak();
 							reinit_filesys();

							SoundFreeSamples();
#else
							if(game_data.lang)
	  							do_subs_foreign();
							else
								do_subs();
							SoundFreeSamples();
#endif
							break;
					    case SCOM_DOGGSAYC:
							FreeMem();
						   backloaded=FALSE;
							setfn(DOGG1C_fns[doggpic]);
							animd=(struct anim *)load_sprites(fn);
	   					setfn(DOGGCBACK_fns[doggpic]);
							#ifdef PC_VERSION
							load_iffimage(fn,&backim,backpal);
							fade_out();
							#else
							fade_out();
							load_iffimage(fn,&backim,backpal);
							#endif
							sprx=DOGGC_pos[doggpic*2];
							spry=DOGGC_pos[(doggpic*2)+1];
							goto mansay;
						 case SCOM_DOGGSAYM:
							FreeMem();
							setfn(DOGG1M_fns[doggpic]);
							animd=(struct anim *)load_sprites(fn);
							setfn(DOGGMBACK_fns[doggpic]);
							#ifdef PC_VERSION
							load_iffimage(fn,&backim,backpal);
							fade_out();
							#else
							fade_out();
							load_iffimage(fn,&backim,backpal);
							#endif
							sprx=DOGGM_pos[doggpic*2];
							spry=DOGGM_pos[(doggpic*2)+1];
mansay:
							charsay_loaded=FALSE;
							load_script_file(sfn);
							nstrs=0;
 							gen_qtab(0,80,transpal,backpal);
 							settop8cols(backpal);
							sprw=sw;
							sprh=sh;
						   backloaded=FALSE;
							briefdisp=2;
 							briefing_disp();
							fade_in(backpal);
#ifdef CONSOLE_VERSION
 							close_wad(wad_handle);
 							mansay_foreign();
 							close_cinepak();
 							reinit_filesys();
#else
		 					if(game_data.lang)
								mansay_foreign();
							else
								mansay();
#endif
							break;
		 			 	 case SCOM_CHARSAY:
#ifndef US_MODIFIED_VERSION
							if(charsay_loaded==FALSE)
								{FreeMem();
								 load_script_file(sfn);
 								 load_charsay_stuff();
								 charsay_loaded=TRUE;
								}

#ifdef CONSOLE_VERSION
							init_talkanim();
							load_sample();
 							close_wad(wad_handle);
							animate_conversation_foreign();
 							close_cinepak();
 							reinit_filesys();

#else
							init_talkanim();
							load_sample();
							if(game_data.lang)
								animate_conversation_foreign();
							else
								animate_conversation();
#endif
							SoundFreeSamples();
#endif
						 	break;
					   }
					}
				}
			break;
		}
	}
 i++;
 }
 return 0;
}

void draw_facspr()
{

 brief1sprs->img.x=facsprx;
 brief1sprs->img.y=facspry;
 draw_anim_frame(brief1sprs,animfr);
}

void draw_backspr()
{struct img img;

 brief2sprs->img.x=awsprx;
 brief2sprs->img.y=awspry;
 draw_anim_frame(brief2sprs,animfr1);
}

void briefing_disp()

{
 struct img img;

 memcpy(scrptr,backim.data,320*200);
 if(!briefdisp)
  {
#ifndef US_MODIFIED_VERSION
   if(!draworder)
		{draw_facspr();draw_backspr();}
	else
		{draw_backspr();draw_facspr();}
   disp_subs();
#endif
  }
  else	if(briefdisp==1)
   disp_subs();
 else
   {
 	 animd->img.x=sprx;
 	 animd->img.y=spry;
 	 draw_anim_frame(animd,frame);
	 disp_subs();
	}
 dump_vram();
}

void briefing_ctrl()
{
}

void briefing_screen()

{
#ifdef CONSOLE_VERSION
// out_fade();
#endif

 StopCDMusic();
 animfr=animfr1=0;
 noptions=1;
 optxts=tlktxts[game_data.lang];
 opareas=exitarea;
 ctrl_func_p=briefing_ctrl;
 disp_func_p=briefing_disp;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 strcpy(sfn,BRIEFING_fns[game_data.mission]);
 load_script_file(sfn);
 process_script_file();
 SoundStopAllSamples();
 SoundFreeSamples();

 FreeAll();
 my_main();

 #ifdef CONSOLE_VERSION
 	set_frontend_video();				/* Setup VDP2. */
 	clear_frontend_screens();
 #endif

 #ifdef PC_VERSION
 if(SoundIsDIGIInstalled())
	SoundDIGIEnable(TRUE);
 #endif

 reset_60hztimer();
 InitMemAlloc();
 load_resident_stuff();

 switch(game_data.missstatus)
	{
	 case TANK_DESTROYED:						/* Lost the plot */
			fmv(DEATH_SEQUENCE);
			fmv(GAME_OVER_SEQUENCE);
			reset_game();
			title_seq();
			break;

	 case MISSION_FAILED:						/* Chickened out */
			mission_failed();
			fmv(GAME_OVER_SEQUENCE);
			reset_game();
			title_seq();
			break;

	 case MISSION_SUCC:							/* Ride 'em cowboy! */
			if(game_data.mission==25)
			{
			 fmv(COMPLETION_SEQUENCE);
				title_seq();
				game_data.mission=1;			/* Start from the beginning again. */
				break;
			}
			game_data.mission++;
			if((++game_data.music)==7)
				game_data.music=2;

// 			encode_game_data(password);
			endmission_stats_screen();
 			select_character_scripts();
			next_mission();
			game_data.score+=10000;
			game_data.score+=1000*game_data.nairtarg_dest;
			game_data.score+=500*game_data.ngrdtarg_dest;
			game_data.score+=200*game_data.perc_host;
			game_data.score+=500*game_data.armint;
			break;
	}
 FreeMem();
}

/********************* MISSION FAILED SECTION *****************************/

void mission_failed()
{
#ifdef CONSOLE_VERSION
 out_fade();
#endif

 init_vars();
 setfn("fail0001.lbm");
 load_iffimage(fn,&backim,backpal);
 setfn("fail.cmp");
 doggsprs=(struct anim *)load_sprites(fn);
 settop8cols(backpal);
 load_script_file("fail.txt");
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();

 sprx=76;
 spry=16;
 sprw=244;
 sprh=184;
 animd=doggsprs;
 backg=backim.data;

 noptions=1;
 optxts=tlktxts[game_data.lang];
 opareas=exitarea;
 ctrl_func_p=dogg_ctrl;
 disp_func_p=man_disp;

 init_vars();
 gen_qtab(0,80,transpal,backpal);
 man_disp();
 fade_in(backpal);
 animate_man();
 wait_loop(50);
 FreeMem();
 SoundFreeSamples();
}


/********************** Mission Stats screen **********************/


void endmiss_display()
{struct img img;
 char **p;
 int y=48;


 p=missstattxt[game_data.lang];


 memcpy(scrptr,backim.data,320*200);
 disp_3d_transbox(13,10,220,160);

 set_col(252);
 sprint(p[0],22,22);

 set_col(255);
 sprint(p[1],22,y);

/* print out game performance info */

 printnum_rev(game_data.nstructs_dest,210,y);
 y+=10;

 if(MissionVehicles[game_data.mission] & AIRTARGS)		/* any air targets in mission ? */
 	{sprint(p[2],22,y);
 	 printnum_rev(game_data.nairtarg_dest,210,y);
    y+=10;
 	}

 sprint(p[3],22,y);
 printnum_rev(game_data.ngrdtarg_dest,210,y);
 y+=10;

 if(MissionVehicles[game_data.mission] & TRUCKS)
  	{
 	 sprint(p[4],22,y);
 	 printnum_rev(game_data.perc_trucks,210,y);
 	 sprint("%",198+24,y);
	 y+=10;
	}

 if(nextMissionTypes[game_data.mission] & HOSTAGEMISS)
 	{
 	 sprint(p[5],22,y);
 	 printnum_rev(game_data.perc_host,210,y);
 	 sprint("%",198+24,y);
	 y+=10;
	}

 sprint(p[6],22,y);
 printnum_rev(game_data.perc_obj,210,y);
 sprint("%",198+24,y);
 y+=10;

 sprint(p[7],22,y);
 printnum_rev(game_data.hitacc,210,y);
 sprint("%",198+24,y);
 y+=10;

 sprint(p[8],22,y);
 printnum_rev(game_data.crates_coll,210,y);
 y+=10;

 sprint(p[9],22,y);
 printnum_rev(game_data.score,210,y);
 y+=10;

 sprint(p[10],22,y);
 printnum_rev(game_data.money,210,y);

 tssprs->img.x=247;
 tssprs->img.y=80;
 draw_anim_frame(tssprs,frame);
 if(mainsel>=0)
 	print_textbar(optxts[mainsel],-1,188);
// if(passlen)
// 	{sprint(passtxt[game_data.lang],22,150);
// 	 print_password(120,150);
//	}
 dispexit();
 disp_cursor();
 dump_vram();
}

void endmiss_status_ctrl()
{
 anim_exit();
 if(ctrlval==CTRL_SELECT)
  {
    switch(mainsel)
  		{
	 	 case 0:
			start_exanim();
			return;
		}
  }
}

void	endmission_stats_screen()
{

/* load status screen stuff */


 setfn("mstat.cmp");
 tssprs=(struct anim *)load_sprites(fn);
 setfn("mstt0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 backg=backim.data;
 fade_to_pal(FADEOUT_RATE,fadepal);
 wait_fade();

 noptions=1;
 upgr=0;
 opareas=exitarea;
 optxts=mstattxts[game_data.lang];
 ctrl_func_p=endmiss_status_ctrl;
 disp_func_p=endmiss_display;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 memcpy(scrptr,backim.data,320*200);
 dump_vram();
 fade_in(backpal);
// expand_3d_transbox(13,10,220,160,NULL);
 endmiss_display();

 for(;;)
	{
	 if(exitflg==TRUE)
		goto msdone;
	 switch(anim)
		{
		 case STAT_START:
			animate1(0,randomr(100,200));
			anim=random(3)+STAT_LOOKR;
			break;
		 case STAT_LOOKR:
			animate(0,3,5);
			animate1(4,randomr(100,200));
			animate(3,0,5);
		   anim=STAT_START;
			break;
		 case STAT_LOOKL:
			animate1(0,5);
			animate(6,7,5);
			animate1(8,randomr(100,200));
			animate1(7,5);
			animate1(6,5);
			animate1(0,5);
		   anim=STAT_START;
			break;
		 case STAT_LOOK_YOU:
			animate1(0,5);
			animate(10,11,5);
			animate1(12,randomr(100,200));
			animate1(11,5);
			animate1(10,5);
			animate1(0,5);
		   anim=STAT_START;
			break;
		 case STAT_LOWER_CBRD:
			animate1(0,5);
			animate(13,19,5);
			anim=random(2)+STAT_CBRD_LOOKR;
			break;
		 case STAT_CBRD:
			animate1(19,randomr(100,200));
			anim=random(2)+STAT_CBRD_LOOKR;
			break;
		 case STAT_CBRD_LOOKR:
			animate1(19,5);
			animate(25,28,5);
			animate1(29,randomr(100,200));
			animate(28,25,5);
			animate1(19,randomr(100,200));
			anim=STAT_CBRD;
			break;
		 case STAT_CBRD_LOOKL:
			animate(19,23,5);
			animate1(24,randomr(100,200));
 			animate(23,19,5);
			anim=STAT_CBRD;
			break;
		 case STAT_CBRD_RAISE:
			animate(19,13,5);
			animate1(0,5);
			anim=STAT_START;
			break;
		}
	}

msdone:
 contract_3d_transbox(13,10,224,160,NULL);
 FreeMem();
}


/********************** Reset mission vars ***********************/

void reset_game(void)
{
	game_data.mission=1;
	game_data.nextmiss = nextMissionTypes[game_data.mission];

	game_data.larmlev = original_game_data.larmlev;
	game_data.larmint = original_game_data.larmint;
	game_data.armlev = original_game_data.armlev;
	game_data.armint = original_game_data.armint;
	game_data.nsams = original_game_data.nsams;
	game_data.mns = original_game_data.mns;
	game_data.imageint = original_game_data.imageint;
	game_data.airsupp = original_game_data.airsupp;
	game_data.engupg = original_game_data.engupg;
	game_data.trkupg = original_game_data.trkupg;
	game_data.relupg = original_game_data.relupg;
	game_data.tarupg = original_game_data.tarupg;
	game_data.cgunupg = original_game_data.cgunupg;
	game_data.money = original_game_data.money;
	game_data.score = original_game_data.score;
	game_data.hitacc = original_game_data.hitacc;
	game_data.bodycount = original_game_data.bodycount;
   select_character_scripts();
}


/********************** Move onto next mission *******************/

void next_mission(void)
{
	game_data.nextmiss = nextMissionTypes[game_data.mission];

	game_data.larmlev = game_data.armlev;
	game_data.larmint = game_data.armint;
}


//void my_main()
//{
// game_data.missstatus=MISSION_FAILED;
//}


/********************** More psx specific stuff - aggggghhhhhhh ! *************/


#ifdef PSX_VERSION

void PSX_ShowButtonFuncs(Butt *butts,int n)
{
 int i;

 disp_transbox(0,180,320,20);
 for(i=0;i<n;i++)
	{
 	 psx_buttsprs[butts[i].type].x=butts[i].x;
 	 psx_buttsprs[butts[i].type].y=butts[i].y;
 	 copy_spr(&psx_buttsprs[butts[i].type]);
 	 sprint(butts[i].txt[game_data.lang],butts[i].x+psx_buttsprs[butts[i].type].w+10,butts[i].y+2);
	}
}

#endif
