#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <stdarg.h>
#include <time.h>



/*-----------------14/11/95 10:15-------------------
 wad functions
--------------------------------------------------*/

typedef unsigned char uchar;
typedef unsigned int uint;

void	debug_msg(char *format, ...);
void	reset_msg_file(void);

uchar	*open_wad_file(char *wadFilename);
void* load_wad_file(char *filename, void *buffer);
void	close_wad_file(void);

#define get_mem malloc

#define MAX_NAME_LENGTH				48

typedef	struct header_info
{
	uint	size;
	uint	offset;
	char	filename[MAX_NAME_LENGTH];
}HEADER_INFO;

uint	numWadFiles = 0;
uint	wadTotalSize = 0;
HEADER_INFO	*wadHeaderBlock, *currentHeaderItem;
uint	currentHeaderItemNumber=0;

char	headerbuffer[64000];

uchar	*wadd_pointer;
uchar	*wadd_data;
FILE	*wadFile=NULL;


uint	extractLength=0;

/*********************************************************/


uchar	*open_wad_file(char *wadFilename)
{
	if ( wadFile!=NULL )
	{
		debug_msg("Can't have multiple wad files!\n");
		exit(0);
	}

	debug_msg("Opening WAD file %s\n",wadFilename);

	wadFile = fopen(wadFilename, "rb");

	if ( wadFile == NULL )
	{
		debug_msg("Error - Wad file '%s' not found\n", wadFilename);
		exit(0);
	}

	fread(&numWadFiles, 1, sizeof(uint), wadFile);		// get the number of files in the wad
	fread(&wadTotalSize, 1, sizeof(uint), wadFile);		// get the total size of wad data

	debug_msg("Wad header loaded.\n");

	currentHeaderItemNumber=0;

	// use the screen buffer as temp work space for the header info
	currentHeaderItem = wadHeaderBlock = (HEADER_INFO*)headerbuffer;

	// get the header info into workspace
	fread(wadHeaderBlock, sizeof(HEADER_INFO), numWadFiles, wadFile);

	debug_msg("Wad internal directory loaded.\n");

	// allocate room for wadd
	wadd_pointer = get_mem((wadTotalSize+8));
	debug_msg("Wad data allocated successfully.\n");

	if ( wadd_pointer==NULL )
	{
		debug_msg("Error - couldn't allocate memory for wad file:\n");
		debug_msg("Wad size = %d\n",wadTotalSize+8);
		exit(0);
	}

	memset(wadd_pointer, 0XFE, (wadTotalSize+8));
	debug_msg("Wadd memory cleared out.\n");

	wadd_data = wadd_pointer;

	// allign the wadd on a long word boundary
	while( ((uint)wadd_data&3) )
		wadd_data++;

	debug_msg("Wadd pointer alligned.\n");

	// read in wadd data
	fread(wadd_data, sizeof(char), wadTotalSize, wadFile);
	debug_msg("Wadd data loaded successfully.\n");


	// check that the wad didn't write beyond its allocated space
	if ( *(wadd_data+wadTotalSize)!=0XFE )
	{
		debug_msg("The wad fucked up.\n");
		exit(0);
	}

	debug_msg("The wad loaded successfully.\n");
	return (wadd_pointer);
}

/*********************************************************/



void* load_wad_file(char *filename, void *buffer)
{
	void	*retval;


	/** first check if the current header item is the one required **/

	while ( 1 )
	{
		if ( strcmp(currentHeaderItem->filename, filename)==0 )
		{
			debug_msg("wad component file %s (offset:%d) (size:%d) loaded\n", filename, currentHeaderItem->offset, currentHeaderItem->size);

			extractLength = currentHeaderItem->size;

			retval = wadd_data + currentHeaderItem->offset;
			currentHeaderItem++;
			currentHeaderItemNumber++;

			return (retval);
		}
		else
		{
			currentHeaderItem++;
			currentHeaderItemNumber++;
			if ( currentHeaderItemNumber>numWadFiles )
			{
				debug_msg("Couldnt find file in wad");
				exit(0);
			}
		}
	}
}


/*********************************************************/


void	close_wad_file(void)
{
	fclose(wadFile);

	wadFile = NULL;
}


char debugFilename[256];

void	reset_msg_file(void)
{
	FILE *fp;
	time_t	time_of_day;

	time_of_day = time(NULL);

	sprintf(debugFilename,"extract.txt");

	fp = fopen(debugFilename, "w");
	fprintf(fp, "Wad extraction debug file\n%s\n\n", ctime( &time_of_day));
	fclose(fp);
}


void	debug_msg(char *format, ...)
{
	FILE *fp;
	va_list	argptr;
	char	debugMessageString[640];

	va_start(argptr, format);
	vsprintf(debugMessageString, format, argptr);

	fp = fopen(debugFilename, "a+");
	fprintf(fp, "%s\n", debugMessageString);
	printf("%s\n", debugMessageString);
	fclose(fp);
}


char	wadiname[320];
char	extractName[320];
char	*extractData;


void main(int argc , char *argv[])
{
	char	*loadedWad;
	FILE *extractFile;

	reset_msg_file();

	sprintf(wadiname,"%s",argv[1]);
	sprintf(extractName,"%s",argv[2]);

	loadedWad	= open_wad_file(wadiname);

	extractData = load_wad_file(extractName, NULL);

	debug_msg("Opening %s for writing", extractName);
	extractFile = fopen(extractName,"wb");
	fwrite(extractData, 1, extractLength, extractFile);
	fclose(extractFile);
	debug_msg("Done!!!");

	close_wad_file();

}

