
/********************************************/
/** dels handy sprite routine (C) 1995 del **/
/********************************************/

/*** shade = 0-32 ***/
/*** flip = 0-1 **/
/** def = sprnum **/
/** scale... $10000 = 1:1 **/
/** gfx = gfx pointer **/
/** net = net pointer (takes PC or PSX netfile) **/



#include "delspr.h"
#include "headers.h"			/* Platform specific header files */
#include "chuck.h"
#include "psxbits.h"




/** scaled sprite routine (just like da pc) **/
/** except it handles psx & pc net files and handles DMA downloading of shite if needed **/
/** now updated to handle multi-nets ok.. (a little wobble just like the saturn) **/
/** hmm.. transparent works... (check the lines!!) **/
/** kewlner... sorted depth cue... **/


void	DEL_plot_sprite(int xpos,int ypos,int scale,int def, uchar shade,uchar flip, uchar trans, uchar *gfx, uchar *net)
{
char *netme;
char *netme2;
char *gfxme;

POLY_FT4 *polyme;

PSXSPR *psxsprite;

int	offset;
int	sprxorg;
int	spryorg;
int	xsize;
int	ysize;
int	sprxsize;
int	sprysize;


int	uoff;
int	voff;
int	tpageme;
int	cnt;
int numnets;


int	xinc;
int	yinc;


int	slot;
int	dataoff;

int	tx,ty;

int	res;

	netme = net;

	if ( shade>7 )
		shade=8;							/* max brightness */
	else
		shade=7-shade;				/* depth-cued 0-7 */


/** is it a psx net file? **/
	if ( *(ulong *)(netme) == ( ('N'<<24) | ('X'<<16) | ('S'<<8) | ('P') ) )
	{

		net += 4;			 		 		 	 			/* skip the 'PSXN' ID */
		netme = net;
		netme += (def*2)+2;			 	 	 		/* + sprite number */
		offset = *(short *)(netme);		/* get net offset */

		netme2 = net+offset;

		numnets = *(short *)(netme2);	/* get number of nets */
		netme2+=2;


		tx = xpos;
		ty = ypos;




		for ( cnt=0; cnt<(numnets+1); cnt++,netme2 += sizeof(PSXSPR) )
		{


			xpos = tx;
			ypos = ty;

			psxsprite = (PSXSPR *)netme2;

			sprxorg = psxsprite->netoffx;
			spryorg = psxsprite->netoffy;
			sprxsize = psxsprite->sprwid;
			sprysize = psxsprite->sprhei;
			uoff = psxsprite->spruoff;
			voff = psxsprite->sprvoff;

			tpageme = psxsprite->sprtpage;

			xsize = (sprxsize << 16) / scale;	/* xloop*/
			ysize = (sprysize << 16) / scale;  /* yloop*/

			if (xsize<=0 || ysize<=0)
				continue;


			if (scale < 0x2aab )	/* Greater than x6 or less than /6 ? */
				continue;



			if ( flip == 0 )
 				xpos += (sprxorg*xsize)/sprxsize;
 			else
 				xpos += ((-(sprxsize+sprxorg))*xsize)/sprxsize;


			ypos += (spryorg<<16 ) / scale;


			if (xpos >= 320 || ypos >= 128) /*x/y clip */
 				continue;

			if (xpos + xsize <= 0 || ypos + ysize <= 0)
 				continue;


/*			xsize = (sprxsize << 16) / (scale-0x200);	/* xloop*/
/*			ysize = (sprysize << 16) / (scale-0x200);  /* yloop*/

			polyme = (POLY_FT4 *)cur_primlist;

/** primitive length = 9 **/
			setlen(polyme,9);

			if ( trans==0 )
 				setcode(polyme,( ((0x02c)&~2)|1)  );		/** primitive code (polyFT4,not trans, no shadetex) **/
			else
 				setcode(polyme,( ((0x02c)|2)|1)  );		/** primitive code (polyFT4,transparent, no shadetex) **/

			polyme->tpage = sprtexture[tpageme];
			polyme->clut  = wallclutdc[shade];

			if ( flip==0 )
				setUV4(polyme, uoff, voff, uoff+(sprxsize-1), voff, uoff, voff+(sprysize-1), uoff+(sprxsize-1), voff+(sprysize-1) );
			else
				setUV4(polyme, uoff+(sprxsize-1), voff, uoff, voff, uoff+(sprxsize-1), voff+(sprysize-1), uoff, voff+(sprysize-1) );

			setXYWH(polyme, xpos, ypos, xsize+1, ysize+1);
			AddPrim(&cur_ot[otcnt++], (u_long *)polyme);
			cur_primlist += 10;										/* 10 longs per polyFT4 */

		}

	}
	else
	{
/** this is a PC netfile (ARGGGHHHHH...) **/


		netme = net;
		netme += (def*2)+2;			 	 		/* + sprite number */
		offset = *(short *)(netme);		/* get net offset */

		netme = net+offset;

		numnets = *(short *)(netme);	/* get number of nets */
		netme+=2;


		tx = xpos;
		ty = ypos;


		for ( cnt=0; cnt<(numnets+1); cnt++ )
		{

			xpos = tx;
			ypos = ty;

			gfxme = gfx;





			sprxorg = *(short *)(netme);
			netme += 2;
			spryorg = *(short *)(netme);
			netme += 2;

/*
this should work... BUT... Unluccckkkyy...!

			dataoff = *(int *)(netme);
			netme +=4;

*/

			dataoff = (uint)*(ushort *)(netme);
			netme+=2;
			dataoff |= (uint)*(ushort *)(netme)<<16;
			netme+=2;


			gfxme = gfxme+dataoff;

			sprxsize = *(short *)(gfxme);
			gfxme += 2;
			sprysize = *(short *)(gfxme);
			gfxme += 2;


			if ( sprxsize > SLOT_XSIZE  )
			{
/*				printf("xsize too big...(%d)\n",sprxsize);*/
				return;
			}

			if ( sprysize > SLOT_YSIZE  )
			{
/*				printf("ysize too big...(%d)\n,sprysize");*/
				return;
			}


			xsize = (sprxsize << 16) / scale;	/* xloop*/
			ysize = (sprysize << 16) / scale;  /* yloop*/

			if (xsize<=0 || ysize<=0)
				return;


			if (scale < 0x2aab )	/* Greater than x6 or less than /6 ? */
				return;

			if ( flip == 0 )
 				xpos += (sprxorg*xsize)/sprxsize;
 			else
 				xpos += ((-(sprxsize+sprxorg))*xsize)/sprxsize;

			ypos += (spryorg * ysize) / sprysize;

			if (xpos >= 320 || ypos >= 128)					 /* x/y clip */
 				return;

			if (xpos + xsize <= 0 || ypos + ysize <= 0)
 				return;


/** download it VRAM **/

			slot = put_something_in_slot_list(gfxme,sprxsize,sprysize);
			if ( slot == -1 )
				return;				/* no slots :( */


			uoff = slot_list[slot].slot_uoff;
			voff = slot_list[slot].slot_voff;
			tpageme = slot_list[slot].slot_tpage;




			polyme=(POLY_FT4 *)cur_primlist;

/** primitive length = 9 **/
			setlen(polyme,9);

			if ( trans==0 )
 				setcode(polyme,( ((0x02c)&~2)|1)  );		/** primitive code (polyFT4,not trans, no shadetex) */
			else
 				setcode(polyme,( ((0x02c)|2)|1)  );		/** primitive code (polyFT4,transparent, no shadetex) */


			polyme->tpage = slottextures[tpageme];
			polyme->clut  = wallclutdc[shade];

			if ( flip==0 )
				setUV4(polyme,uoff, voff, uoff+(sprxsize-1), voff, uoff, voff+(sprysize-1), uoff+(sprxsize-1), voff+(sprysize-1) );
			else
				setUV4(polyme, uoff+(sprxsize-1), voff, uoff, voff, uoff+(sprxsize-1), voff+(sprysize-1), uoff, voff+(sprysize-1) );

			setXYWH(polyme, xpos, ypos, xsize, ysize);
			AddPrim(&cur_ot[otcnt++], (u_long *)polyme);
			cur_primlist += 10;										/* 10 longs per polyFT4 */

		}

 	}

	return;

};









/** this is a routine to plot sprites as their normal size **/
/** no flipping or anything fancy **/
/** oh yeah! and it only takes PSX netfiles... WEAR IT! **/
/** wants a CLUT ID **/



void	DEL_draw_sprite(int xpos, int ypos, int def, uchar *gfx, uchar *net,ushort clutid)
{
char *netme;
char *netme2;
char *gfxme;

PSXSPR *psxsprite;

int	offset;
int	sprxorg;
int	spryorg;
int	sprxsize;
int	sprysize;


int	uoff;
int	voff;
int	tpageme;
int	cnt;
int numnets;

int	tx,ty;

POLY_FT4 *polyme;

	netme = net;

/** is it a psx net file? **/
	if ( *(ulong *)(netme) == ( ('N'<<24) | ('X'<<16) | ('S'<<8) | ('P') ) )
	{

		net += 4;			 		 		 	 			/* skip the 'PSXN' ID */
		netme = net;
		netme += (def*2)+2;			 	 		/* + sprite number */
		offset = *(short *)(netme);		/* get net offset */

		netme2 = net+offset;

		numnets = *(short *)(netme2);	/* get number of nets */
		netme2+=2;


		tx = xpos;
		ty = ypos;


		for ( cnt=0; cnt<(numnets+1); cnt++ )
		{

			psxsprite = (PSXSPR *)netme2;

			sprxorg = psxsprite->netoffx;
			spryorg = psxsprite->netoffy;
			sprxsize = psxsprite->sprwid;
			sprysize = psxsprite->sprhei;

			uoff = psxsprite->spruoff;
			voff = psxsprite->sprvoff;
			tpageme = psxsprite->sprtpage;

			xpos = tx+sprxorg;
			ypos = ty+spryorg;

 			polyme=(POLY_FT4 *)cur_primlist;

			/** primitive length = 9 **/
			setlen(polyme,9);

 			setcode(polyme,( ((0x02c)&~2)|1)  );		/** primitive code (polyFT4,not trans, no shadetex) */

			polyme->tpage = sprtexture[tpageme];
			polyme->clut  = clutid; /*clut[5];*/
			setUV4(polyme, uoff, voff, uoff+sprxsize, voff, uoff, voff+(sprysize), uoff+sprxsize, voff+(sprysize) );
			setXYWH(polyme, xpos, ypos, sprxsize, sprysize);
			AddPrim(&cur_ot[otcnt++], (u_long *)polyme);
			cur_primlist += 10;										/* 10 longs per polyFT4 */

			netme2 += sizeof(PSXSPR);		/* next net please */

		}

	}

	return;
};


















