

WB_Y_TXT_ADD		EQU	0
WB_X_TXT		EQU	4
WB_Y_SCREEN		EQU	8
WB_HEIGHT		EQU	12
WB_Y_TXT		EQU	16
WB_DC_TABLE		EQU	20

WALLBUFFER_ELEMENT_SIZE EQU	24

	.386


	.MODEL	flat,stdcall

	.DATA

STRTX		DWORD	0           	; pointer to top of columns on screen
XLOOP		DWORD	0		; Xloop counter
BUFFPTR		DWORD	0



EXTERN C SCR_PTR:PTR			; The 'screen'
EXTERN C ODEPTHS:PTR			; Points to the depth cue table for objects


_DATA	ENDS


	.CODE

;******************************************************************************
;				Dump Wall Buffer To Screen
; 		On Entry..
; 		EAX  startx
; 		EDX  width of wall
; 		EBX  pointer to Buffer
;******************************************************************************

dump_wall_buffer_	PROC C PUBLIC

	pushad
	ADD	EAX,SCR_PTR		; add on SCR_PTR to startx
;	add	eax,1280

	mov	XLOOP,edx		; save width of wall
	mov	STRTX,eax               ; save start pointer

@@Xloop2:
	mov	esi,[ebx+WB_X_TXT]	; get pointer to correct column in texture
	mov	edx,[ebx+WB_Y_SCREEN]	; get Ystart
	dec	edx			; decrement by one to allow for preadd
	sal	edx,6
	lea	edx,[edx+4*edx]		; multiply by 320.....ie 64*5
	add	edx,STRTX               ; and add on start x + screen.ptr
	mov	ecx,[ebx+WB_HEIGHT]	; Holds the height count..
	mov	edi,[ebx+WB_Y_TXT_ADD]	; edi holds the fractional adder
	or	ecx,ecx
	mov	ebp,[ebx+WB_Y_TXT]	; ebp holds the starting fractional y offset into source data
	js	@@nextcol  		; if count<0 then skip column draw..

@@Yloop2:
	mov	eax,ebp			; copy EBP to eax
	add	edx,320			; Update the destination address
	shr	eax,16			; Get the integer part of fractional address
	add	ebp,edi			; Update the fractional source address

	mov	al,BYTE PTR [eax+esi]	; get texture Byte
	mov	BYTE PTR [edx],al       ; Put it into Screen Mem...

@@nextpix:
	dec	ecx
	jns	@@Yloop2                ; loop until column done...

@@nextcol:
	inc	STRTX                   ; increment start x
	add	ebx,WALLBUFFER_ELEMENT_SIZE ; Point to next wall buffer element
	dec	XLOOP                   ; Finish All Columns
	jns	@@Xloop2

	popad
	ret

dump_wall_buffer_	ENDP





dump_wall_buffer_dc_	PROC C PUBLIC

	pushad
	ADD	EAX,SCR_PTR		; add on SCR_PTR to startx
;	add	eax,1280


	mov	XLOOP,edx		; save width of wall
	MOV	STRTX,EAX               ; save start pointer


@@Xloop2:
	mov	esi,[ebx+WB_X_TXT]	; get pointer to correct column in texture
	mov	edx,[ebx+WB_Y_SCREEN]	; get Ystart
	dec	edx			; decrement by one to allow for preadd
	sal	edx,6
	lea	edx,[edx+4*edx]		; multiply by 320.....ie 64*5
	add	edx,STRTX               ; and add on start x + screen.ptr
	mov	ecx,[ebx+WB_HEIGHT]	; Holds the height count..
	mov	edi,[ebx+WB_Y_TXT_ADD]	; edi holds the fractional adder
	or	ecx,ecx
	mov	ebp,[ebx+WB_Y_TXT]	; ebp holds the starting fractional y offset into source data
	js	short @@nextcol		; if count<0 then skip column draw..

	MOV	BUFFPTR,EBX		; Save the pointer to the current collumn data
	mov	ebx,[ebx+WB_DC_TABLE]	; Get the depth cue table value

	OR	EBX,EBX
	jns	short @@dc_collumn

@@Yloop1:
	mov	eax,ebp			; copy EBP to eax
	add	edx,320			; Update the destination address
	shr	eax,16			; Get the integer part of fractional address
	add	ebp,edi			; Update the fractional source address

	mov	al,BYTE PTR [eax+esi]	; get texture Byte
	mov	BYTE PTR [edx],al       ; Put it into Screen Mem...

	dec	ecx
	JNS	@@YLOOP1                ; loop until column done...

	MOV	EBX,BUFFPTR		; restore buffer pointer

@@nextcol:
	inc	STRTX                   ; increment start x
	add	ebx,WALLBUFFER_ELEMENT_SIZE ; Point to next wall buffer element
	dec	XLOOP                   ; Finish All Columns
	jns	@@Xloop2

	popad
	ret

; Dump a depth cued collumn

@@DC_COLLUMN:
	add	ebx,odepths		; Point to actual depth cue table

@@YLOOP2:
	mov	eax,ebp			; copy EBP to eax
	add	edx,320			; Update the destination address
	shr	eax,16			; Get the integer part of fractional address
	add	ebp,edi			; Update the fractional source address

	MOV	AL,BYTE PTR [EAX+ESI]	; get texture Byte
	XLATB				; Get depth cued byte

	mov	BYTE PTR [edx],al       ; Put it into Screen Mem...

	dec	ecx
	JNS	@@YLOOP2                ; loop until column done...

	MOV	EBX,BUFFPTR		; restore buffer pointer

	inc	STRTX                   ; increment start x
	add	ebx,WALLBUFFER_ELEMENT_SIZE ; Point to next wall buffer element
	dec	XLOOP                   ; Finish All Columns
	jns	@@Xloop2

	popad
	ret

dump_wall_buffer_dc_	ENDP






dump_transparent_wall_buffer_	PROC C PUBLIC

	pushad
	add	eax,SCR_PTR		; add on SCR_PTR to startx
;	ADD	EAX,1280

	mov	XLOOP,edx		; save width of wall
	mov	STRTX,eax               ; save start pointer

@@Xloop2:
	mov	esi,[ebx+WB_X_TXT]	; get pointer to correct column in texture
	mov	edx,[ebx+WB_Y_SCREEN]	; get Ystart
	dec	edx			; decrement by one to allow for preadd
	sal	edx,6
	lea	edx,[edx+4*edx]		; multiply by 320.....ie 64*5
	add	edx,STRTX               ; and add on start x + screen.ptr
	mov	ecx,[ebx+WB_HEIGHT]	; Holds the height count..
	mov	edi,[ebx+WB_Y_TXT_ADD]	; edi holds the fractional adder
	or	ecx,ecx
	mov	ebp,[ebx+WB_Y_TXT]	; ebp holds the starting fractional y offset into source data
	js	short @@nextcol  	; if count<0 then skip column draw..

@@Yloop2:
	mov	eax,ebp			; copy EBP to eax
	add	edx,320			; Update the destination address
	shr	eax,16			; Get the integer part of fractional address
	add	ebp,edi			; Update the fractional source address

	mov	al,BYTE PTR [eax+esi]	; get texture Byte
	or	al,al
	je      @@nextpix               ; skip pixel if zero....
	mov	BYTE PTR [edx],al       ; Put it into Screen Mem...

@@nextpix:
	dec	ecx
	jns	@@Yloop2                ; loop until column done...

@@nextcol:
	inc	STRTX                   ; increment start x
	add	ebx,WALLBUFFER_ELEMENT_SIZE
	dec	XLOOP                   ; Finish All Columns
	jns	@@Xloop2

	popad
	ret

dump_transparent_wall_buffer_	ENDP





dump_transparent_wall_buffer_dc_	PROC C PUBLIC

	pushad
	ADD	EAX,SCR_PTR		; add on SCR_PTR to startx
;	ADD	EAX,1280


	mov	XLOOP,edx		; save width of wall
	mov	STRTX,eax               ; save start pointer

@@Xloop2:
	mov	esi,[ebx+WB_X_TXT]	; get pointer to correct column in texture
	mov	edx,[ebx+WB_Y_SCREEN]	; get Ystart
	dec	edx			; decrement by one to allow for preadd
	sal	edx,6
	lea	edx,[edx+4*edx]		; multiply by 320.....ie 64*5
	add	edx,STRTX               ; and add on start x + screen.ptr
	mov	ecx,[ebx+WB_HEIGHT]	; Holds the height count..
	mov	edi,[ebx+WB_Y_TXT_ADD]	; edi holds the fractional adder
	or	ecx,ecx
	mov	ebp,[ebx+WB_Y_TXT]	; ebp holds the starting fractional y offset into source data
	js	short @@nextcol  		; if count<0 then skip column draw..

;check for a depth cued collumn

	MOV	BUFFPTR,EBX		; Save the pointer to the current collumn data
	mov	ebx,[ebx+WB_DC_TABLE]	; Get the depth cue table value

	OR	EBX,EBX
	jns	short @@dc_collumn

@@Yloop1:
	mov	eax,ebp			; copy EBP to eax
	add	edx,320			; Update the destination address
	shr	eax,16			; Get the integer part of fractional address
	add	ebp,edi			; Update the fractional source address

	mov	al,BYTE PTR [eax+esi]	; get texture Byte
	or	al,al
	je      @@nextpix               ; skip pixel if zero....
	mov	BYTE PTR [edx],al       ; Put it into Screen Mem...

@@nextpix:
	dec	ecx
	jns	@@Yloop1                ; loop until column done...

	MOV	EBX,BUFFPTR		; restore buffer pointer

@@nextcol:
	inc	STRTX                   ; increment start x
	add	ebx,WALLBUFFER_ELEMENT_SIZE
	dec	XLOOP                   ; Finish All Columns
	jns	@@Xloop2

	popad
	ret

; Dump a depth cued collumn

@@DC_COLLUMN:
	add	ebx,odepths		; Point to actual depth cue table

@@Yloop2:
	mov	eax,ebp			; copy EBP to eax
	add	edx,320			; Update the destination address
	shr	eax,16			; Get the integer part of fractional address
	add	ebp,edi			; Update the fractional source address

	mov	al,BYTE PTR [eax+esi]	; get texture Byte
	or	al,al
	JE      @@NEXTPIX2              ; skip pixel if zero....

	XLATB				; Get depth cued colour


	mov	BYTE PTR [edx],al       ; Put it into Screen Mem...

@@nextpix2:
	dec	ecx
	jns	@@Yloop2                ; loop until column done...

	MOV	EBX,BUFFPTR		; restore buffer pointer


	inc	STRTX                   ; increment start x
	add	ebx,WALLBUFFER_ELEMENT_SIZE
	dec	XLOOP                   ; Finish All Columns
	jns	@@Xloop2

	POPAD
	ret

dump_transparent_wall_buffer_dc_	ENDP






dump_ragged_wall_buffer_	PROC C PUBLIC

	pushad
	ADD	EAX,SCR_PTR		; add on SCR_PTR to startx

	mov	XLOOP,edx		; save width of wall
	mov	STRTX,eax               ; save start pointer

@@Xloop2:
	mov	esi,[ebx+WB_X_TXT]	; get pointer to correct column in texture
	mov	edx,[ebx+WB_Y_SCREEN]	; get Ystart
	dec	edx			; decrement by one to allow for preadd
	sal	edx,6
	lea	edx,[edx+4*edx]		; multiply by 320.....ie 64*5
	add	edx,STRTX               ; and add on start x + screen.ptr
	mov	ecx,[ebx+WB_HEIGHT]	; Holds the height count..
	mov	edi,[ebx+WB_Y_TXT_ADD]	; edi holds the fractional adder
	or	ecx,ecx
	mov	ebp,[ebx+WB_Y_TXT]	; ebp holds the starting fractional y offset into source data
	js	@@nextcol  		; if count<0 then skip column draw..

@@Yloop1:
	mov	eax,ebp			; copy EBP to eax
	add	edx,320			; Update the destination address
	shr	eax,16			; Get the integer part of fractional address
	add	ebp,edi			; Update the fractional source address

	mov	al,BYTE PTR [eax+esi]	; get texture Byte
	or	al,al
	je      @@nextpix               ; skip pixel if zero....
	MOV	BYTE PTR [EDX],AL       ; Put it into Screen Mem...
	jmp	short @@startsolidwall	; skip to solid wall loop

@@nextpix:
	dec	ecx
	JNS	@@YLOOP1                ; loop until column done...
	jmp	@@nextcol		; if reached end of collumn and was all transparent skip solid collumn bit

@@STARTSOLIDWALL:

	dec	ecx
	JNS	short @@solidwall             ; loop until column done...
	jmp	short @@nextcol		; if reached end of collumn and was all transparent skip solid collumn bit


@@SOLIDWALL:
	mov	eax,ebp			; copy EBP to eax
	add	edx,320			; Update the destination address
	shr	eax,16			; Get the integer part of fractional address
	add	ebp,edi			; Update the fractional source address

	MOV	AL,BYTE PTR [EAX+ESI]	; get texture Byte
	mOV	BYTE PTR [EDX],AL       ; Put it into Screen Mem...

	dec	ecx
	jns	@@solidwall             ; loop until column done...

@@nextcol:
	inc	STRTX                   ; increment start x
	add	ebx,WALLBUFFER_ELEMENT_SIZE
	dec	XLOOP                   ; Finish All Columns
	jns	@@Xloop2

	popad
	ret

dump_ragged_wall_buffer_	ENDP






dump_ragged_wall_buffer_dc_	PROC C PUBLIC

	pushad
	ADD	EAX,SCR_PTR		; add on SCR_PTR to startx
;	add	eax,1280

	mov	XLOOP,edx		; save width of wall
	mov	STRTX,eax               ; save start pointer

@@Xloop2:
	mov	esi,[ebx+WB_X_TXT]	; get pointer to correct column in texture
	mov	edx,[ebx+WB_Y_SCREEN]	; get Ystart
	dec	edx			; decrement by one to allow for preadd
	sal	edx,6
	lea	edx,[edx+4*edx]		; multiply by 320.....ie 64*5
	add	edx,STRTX               ; and add on start x + screen.ptr
	mov	ecx,[ebx+WB_HEIGHT]	; Holds the height count..
	mov	edi,[ebx+WB_Y_TXT_ADD]	; edi holds the fractional adder
	or	ecx,ecx
	mov	ebp,[ebx+WB_Y_TXT]	; ebp holds the starting fractional y offset into source data
	JS	@@NEXTCOL  		; if count<0 then skip column draw..

;check for a depth cued collumn

	MOV	BUFFPTR,EBX		; Save the pointer to the current collumn data
	mov	ebx,[ebx+WB_DC_TABLE]	; Get the depth cue table value

	OR	EBX,EBX
	jns	short @@dc_collumn

@@Yloop1:
	mov	eax,ebp			; copy EBP to eax
	add	edx,320			; Update the destination address
	shr	eax,16			; Get the integer part of fractional address
	add	ebp,edi			; Update the fractional source address

	mov	al,BYTE PTR [eax+esi]	; get texture Byte
	or	al,al
	je      short @@nextpix               ; skip pixel if zero....
	MOV	BYTE PTR [EDX],AL       ; Put it into Screen Mem...
	jmp	short @@startsolidwall	; skip to solid wall loop

@@nextpix:
	dec	ecx
	JNS	@@YLOOP1                ; loop until column done...

	MOV	EBX,BUFFPTR
	jmp	short @@nextcol		; if reached end of collumn and was all transparent skip solid collumn bit

@@STARTSOLIDWALL:

	dec	ecx
	JNS	short @@SOLIDWALL       ; loop until column done...

	MOV	EBX,BUFFPTR
	jmp	short @@nextcol		; if reached end of collumn and was all transparent skip solid collumn bit


@@SOLIDWALL:
	mov	eax,ebp			; copy EBP to eax
	add	edx,320			; Update the destination address
	shr	eax,16			; Get the integer part of fractional address
	add	ebp,edi			; Update the fractional source address

	MOV	AL,BYTE PTR [EAX+ESI]	; get texture Byte
	mOV	BYTE PTR [EDX],AL       ; Put it into Screen Mem...

	dec	ecx
	jns	@@solidwall             ; loop until column done...

	mov	ebx,buffptr		; restore ebx

@@nextcol:
	inc	STRTX                   ; increment start x
	add	ebx,WALLBUFFER_ELEMENT_SIZE
	dec	XLOOP                   ; Finish All Columns
	jns	@@Xloop2

	popad
	ret


@@dc_collumn:
	add	ebx,odepths		; Point to actual depth cue table

@@Yloop2:
	mov	eax,ebp			; copy EBP to eax
	add	edx,320			; Update the destination address
	shr	eax,16			; Get the integer part of fractional address
	add	ebp,edi			; Update the fractional source address

	mov	al,BYTE PTR [eax+esi]	; get texture Byte
	or	al,al
	JE      short @@NEXTPIX_dc               ; skip pixel if zero....

	xlatb


	MOV	BYTE PTR [EDX],AL       ; Put it into Screen Mem...
	jmp	short @@startsolidwall_dc; skip to solid wall loop

@@nextpix_dc:
	dec	ecx
	JNS	@@YLOOP2                ; loop until column done...

	mov	ebx,buffptr		; restore ebx

	jmp	@@nextcol		; if reached end of collumn and was all transparent skip solid collumn bit

@@STARTSOLIDWALL_dc:

	dec	ecx
	JNS	short @@SOLIDWALL_dc    ; loop until column done...

	mov	ebx,buffptr		; restore ebx

	jmp	@@nextcol		; if reached end of collumn and was all transparent skip solid collumn bit


@@SOLIDWALL_dc:
	mov	eax,ebp			; copy EBP to eax
	add	edx,320			; Update the destination address
	shr	eax,16			; Get the integer part of fractional address
	add	ebp,edi			; Update the fractional source address

	MOV	AL,BYTE PTR [EAX+ESI]	; get texture Byte

	xlatb


	mOV	BYTE PTR [EDX],AL       ; Put it into Screen Mem...

	dec	ecx
	jns	@@solidwall_dc          ; loop until column done...

	mov	ebx,buffptr		; restore ebx

	inc	STRTX                   ; increment start x
	add	ebx,WALLBUFFER_ELEMENT_SIZE
	dec	XLOOP                   ; Finish All Columns
	jns	@@Xloop2

	popad
	ret
dump_ragged_wall_buffer_dc_	ENDP




FAST_MEMSET_		PROC C PUBLIC

		PUSHAD

		cld

		MOV	EDI,EAX
		MOV	DH,DL
		MOV	AX,DX
		ror	EAX,16
		MOV	AX,DX

		MOV	ECX,EBX

		shr	ecx,2

		REP	STOSD

		MOV	ECX,EBX
		AND	ECX,3

		JNZ	@@A_LITTLE_BIT_MORE

		POPAD
		RET

@@A_LITTLE_BIT_MORE:
		REP	STOSB

		POPAD
		RET

fast_memset_	ENDP



_TEXT	ENDS

END




