UNIT detect;

INTERFACE

USES blocks;

  FUNCTION check_piece(row,column:byte; apiece:piece_type):BOOLEAN;
  FUNCTION check_bottom(num,row,column:byte):BOOLEAN;
  FUNCTION check_left(num,row,column:byte):BOOLEAN;
  FUNCTION check_right(num,row,column:byte):BOOLEAN;

IMPLEMENTATION

FUNCTION check_piece(row,column:byte; apiece:piece_type):BOOLEAN;

VAR xpos,ypos:byte;

BEGIN
  check_piece:=true;
  FOR xpos:=1 TO 4 DO
  FOR ypos:=1 TO 4 DO
  BEGIN
    IF (board[ypos+column-1,xpos+row-1]=TRUE) and
       (apiece[xpos,ypos]=TRUE) THEN check_piece:=FALSE;
    IF (apiece[xpos,ypos]=TRUE) AND (column+ypos-1>15) THEN
    check_piece:=false;
    IF (apiece[xpos,ypos]=TRUE) AND (row+xpos-1>10) THEN
    check_piece:=false;
    IF (apiece[xpos,ypos]=TRUE) AND (row+xpos-1<1) THEN
    check_piece:=false;
  END;
END;

PROCEDURE init_temp_piece(VAR apiece:piece_type);

VAR row,column:byte;

BEGIN
  FOR row:=1 TO 4 DO
  FOR column:=1 TO 4 DO
    apiece[row,column]:=false;
END;


FUNCTION check_bottom(num,row,column:byte):BOOLEAN;

VAR r,c:byte;
    found:boolean;
    apiece:piece_type;

BEGIN
  init_temp_piece(apiece);
  FOR c:=1 TO 4 DO
  BEGIN
    found:=false;
    r:=4;
    WHILE NOT(found) AND (r>0) DO
    BEGIN
       IF piece[num,c,r]=true THEN
       BEGIN
         apiece[c,r]:=TRUE;
         found:=true;
       END;
       DEC(r);
   END;
 END;
  check_bottom:=check_piece(row,column,apiece);
END;

FUNCTION check_left(num,row,column:byte):BOOLEAN;

VAR r,c:byte;
    found:boolean;
    apiece:piece_type;

BEGIN
  init_temp_piece(apiece);
  FOR c:=1 TO 4 DO
  BEGIN
    found:=false;
    r:=1;
    WHILE NOT(found) AND (r<5) DO
    BEGIN
       IF piece[num,r,c]=true THEN
       BEGIN
         apiece[r,c]:=TRUE;
         found:=true;
       END;
       INC(r);
   END;
 END;
   check_left:=check_piece(row,column,apiece);
END;

FUNCTION check_right(num,row,column:byte):BOOLEAN;

VAR r,c:byte;
    found:boolean;
    apiece:piece_type;

BEGIN
  init_temp_piece(apiece);
  FOR c:=1 TO 4 DO
  BEGIN
    found:=false;
    r:=4;
    WHILE NOT(found) AND (r>0) DO
    BEGIN
       IF piece[num,r,c]=true THEN
       BEGIN
         apiece[r,c]:=TRUE;
         found:=true;
       END;
       DEC(r);
   END;
 END;
   check_right:=check_piece(row,column,apiece);
END;

BEGIN
END.