'**********************************************************
'
' POKER SQUARES -- A Solitare Game
'
'  (c) Copyright 1989-95 by Randy Rasa
'                           18215 Troost
'                           Olathe, KS 66062
'
'   Command Line Syntax:  PSQUARES [/Q][/M]
'           /Q = quiet mode -- most noises will be stifled
'           /M = mono mode -- black and white video
'           /NM = don't use mouse even if one is available
'
'  Notice: This source code is provided for reference and educational
'          purposes only, and is protected under United States Copyright
'          Law.  In other words, you may look this over, learn from it,
'          and play with it, but not steal it.  Questions, comments, and
'          suggestions are encouraged, and may be sent to the author at
'          the above address.
'
'********************************************************************
'
'   Revision History
'
' Revision   Date   Description
' -------- -------- ---------------------------------------
'   1.00   12-15-88 Not released to public
'   1.10   03-28-89 Added mouse support, boss switch
'   1.20   04-22-89 Added QuickPak Professional library
'   1.21   05-29-89 optimization
'          05-29-89 Released to public
'   1.22   10-20-89 Get rid of encrypted data files
'                   optimization
'   1.23   10-22-89 Add option for English scoring
'   1.24   03-14-90 Don't allow number keys if mouse is enabled.
'                   Add F1=Help, B=Blank.
'   1.25   09-01-90 Make sure program runs in 25-line mode.
'                   Fix row numbers when displaying score.
'                   Do not make score files "read-only".
'   1.26   06-27-91 Let mouse roam full-screen.
'                   Allow mouse to select "Help" and "Quit".
'                   Make middle mouse button (or Esc) blank the screen.
'                   Add "No Mouse" (/NM) flag.
'   1.27   09-25-91 Don't display card numbers if using mouse.
'   1.28   02-04-95 Updated for freeware release.
'
'********************************************************************

    DEFINT A-Z
    CONST false = 0
    CONST TRUE = NOT false
'
' QuickPak Professional routines
'
    DECLARE SUB Box0 (ULRow%, ULCol%, LRRow%, LRCol%, Char%, colr%)
    DECLARE SUB Pause (Ticks%)
    DECLARE SUB GetCursor (x%, y%, Button%)
    DECLARE SUB HideCursor ()
    DECLARE SUB InitMouse (There%)
    DECLARE SUB MouseTrap (ULRow%, ULCol%, LRRow%, LRCol%)
    DECLARE SUB SetCursor (x%, y%)
    DECLARE SUB ShowCursor ()
    DECLARE SUB TextCursor (FG%, BG%)
    DECLARE SUB QPrint0 (x$, colr%)
    DECLARE SUB ScrnSave0 (ULRow%, ULCol%, LRRow%, LRCol%, SEG Element%)
    DECLARE SUB ScrnRest0 (ULRow%, ULCol%, LRRow%, LRCol%, SEG Element%)
    DECLARE FUNCTION WriteTest% (Drive$)
    DECLARE SUB SetAttr (FileName$, Attribute%)
'
' RAR's routines
'
    DECLARE SUB BlankScreen ()
    DECLARE SUB MorK (key$, x%, y%)
    DECLARE SUB card2pos (card%, x%, y%)
    DECLARE SUB compute.score (pos1, pos2, pos3, pos4, pos5, hand.played)
    DECLARE SUB GetCard (value%, crd$, card.color%, Suit%)
   
    REDIM scrn1(2000) AS INTEGER                    'arrays to save screens
    REDIM Scrn2(2000) AS INTEGER
    REDIM Scrn3(2000) AS INTEGER
    CALL ScrnSave0(1, 1, 25, 80, SEG scrn1(0))      'save calling screen

    RANDOMIZE TIMER
    cmnd$ = UCASE$(COMMAND$)
    IF INSTR(cmnd$, "/Q") <> 0 THEN quiet% = 1 ELSE quiet% = 0   'check for quiet mode
    IF INSTR(cmnd$, "/NM") <> 0 THEN NoMouse = 1 ELSE NoMouse = 0   'check for no-mouse flag
    IF INSTR(cmnd$, "/M") <> 0 THEN
        video = &HB4
    ELSE
        DEF SEG = 0
        video = PEEK(&H463)                 'check for color card
    END IF

    IF video = &HB4 THEN
        foreground = 7          'mono
        background = 0
        highlight = 15
        norm = 7: hl = 15: inv = 112: FlashColor = 135
    ELSE                        'color
        foreground = 0          ' black foreground
        background = 3          ' cyan background
        highlight = 1           ' blue highlight
        norm = 48: hl = 49: inv = 3: FlashColor = 176
    END IF
    'norm = OneColor(foreground, background)
    'hl = OneColor(highlight, background)
    'inv = OneColor(background, foreground)
    'FlashColor = OneColor(foreground + 16, background)

    IF NoMouse = 0 THEN
        CALL InitMouse(mouse%)        'check for mouse (0=NO,1=YES)
    ELSE
        mouse% = 0
    END IF
    '
    ' Opening Screen
    '
Titles:
    SCREEN 0
    WIDTH 80, 25
    COLOR foreground, background: CLS
    row = 3: colr = hl
    txt$ = "Ŀ     Ŀ     Ŀ": GOSUB dspc
    txt$ = " P Ŀ K Ŀ R ": GOSUB dspc1
    txt$ = "    O     E    ": GOSUB dspc1
    txt$ = "ٳ   ٳ   ": GOSUB dspc1
    txt$ = "     ": GOSUB dspc1
    txt$ = "Ŀ     Ŀ     Ŀ": GOSUB dspc1
    txt$ = "Ŀ Q Ŀ A Ŀ E Ŀ": GOSUB dspc1
    txt$ = " S     U     R     S ": GOSUB dspc1
    txt$ = "   ٳ   ٳ   ٳ   ": GOSUB dspc1
    txt$ = "               ": GOSUB dspc1
    row = row + 1
    txt$ = "A Game Of Solitaire": GOSUB dspc1
    txt$ = "Version 1.28": GOSUB dspc1
    row = 18: colr = norm
    txt$ = "By Randy Rasa": GOSUB dspc
    txt$ = "18215 Troost": GOSUB dspc1
    txt$ = "Olathe, KS 66062-9208": GOSUB dspc1
    row = row + 1
    txt$ = "(C) Copyright 1989-95 by Randy Rasa": GOSUB dspc1
ask1:
    txt$ = "Instructions, American play, or English play (I/A/E)?": GOSUB dspc25
    IF mouse% THEN
        CALL TextCursor(-2, -2)
        CALL MouseTrap(25, 60, 25, 64)
        CALL SetCursor(64, 25)
        CALL MorK(ans$, x, y)
    ELSE
        LOCATE 25, 68, 1
        ans$ = UCASE$(INPUT$(1))
    END IF
    IF x = 62 OR ans$ = "A" THEN game$ = "A": GOTO start
    IF x = 64 OR ans$ = "E" THEN game$ = "E": GOTO start
    IF x <> 60 AND ans$ <> "I" THEN
        SOUND 550, .5
        GOTO ask1
    ELSE
        GOSUB Help
    END IF
    GOTO Titles
    '
    ' Instructions
    '
Help:
    COLOR foreground, background: CLS
    CALL Box0(1, 1, 24, 80, 1, norm)
    row = 1: colr = inv: txt$ = " P O K E R   S Q U A R E S ": GOSUB dspc
    row = 3: col = 3: colr = norm
    txt$ = "Poker Squares is a one-deck solitaire in which 25 cards are drawn from the": GOSUB dsp
    txt$ = "deck one by one, and placed to best advantage on a table of five rows of": GOSUB dsp1
    txt$ = "five cards each.  The object is to make as high a score as possible in the": GOSUB dsp1
    txt$ = "ten poker hands formed by the five rows and five columns.  For your": GOSUB dsp1
    txt$ = "convenience, a chart is displayed in the 'Scoring' box which shows the": GOSUB dsp1
    txt$ = "points given for each possible poker hand.": GOSUB dsp1
    row = row + 1
    txt$ = "There are two scoring methods: the American system, which is based on the": GOSUB dsp1
    txt$ = "relative likelihood of the hands in regular poker, and the English system,": GOSUB dsp1
    txt$ = "which is based on the the relative difficulty of forming the hands in Poker": GOSUB dsp1
    txt$ = "Squares.  You may choose the scoring method from the main screen.": GOSUB dsp1
    row = row + 1
    txt$ = "During play, you are shown 25 cards (the deck), of which only the top card": GOSUB dsp1
    txt$ = "is visible.  On the right side of the screen is the table of possible card": GOSUB dsp1
    txt$ = "positions (1-25).  If you are using a mouse, position the cursor over the": GOSUB dsp1
    txt$ = "desired card position and press the left mouse button.  If you don't have a": GOSUB dsp1
    txt$ = "mouse, type a number from 1 to 25 and press Enter.  You may also press 'Q'": GOSUB dsp1
    txt$ = "to quit, Esc (the 'boss switch') to bring up a (hopefully) safe screen, or": GOSUB dsp1
    txt$ = "'B' or the right mouse button to blank the screen.": GOSUB dsp1
    
    txt$ = "Press any key ...": GOSUB dspc25
    IF mouse% THEN
        CALL MouseTrap(25, 32, 25, 48)
        CALL SetCursor(25, 48)
        CALL MorK(ans$, x, y)
    ELSE
        LOCATE 25, 50, 1
        ans$ = INPUT$(1)
    END IF
    RETURN
    '
    ' Start the game
    '
start:
    COLOR foreground, background: CLS
    '
    ' Initialize the card deck
    '
    REDIM card(53)
    FOR x = 1 TO 52
        card(x) = x
    NEXT
    REDIM position(25)
    REDIM Card.Value(5)
    REDIM hand$(10)
    REDIM value(10)
    RESTORE hand.array      'point to start of scoring table
    FOR x = 1 TO 10
        READ hand$(x)
        READ value(x)
        IF game$ = "E" THEN READ value(x) ELSE READ junk
    NEXT
    REDIM score(10)
hand.array: 'Hand ,American Score, English score
    DATA    "  Royal Flush  ",100,30
    DATA    "Straight Flush ",75,30
    DATA    "Four Of A Kind ",50,16
    DATA    "  Full House   ",25,10
    DATA    "     Flush     ",20,5
    DATA    "   Straight    ",15,12
    DATA    "Three Of A Kind",10,6
    DATA    "   Two Pairs   ",5,3
    DATA    "   One Pair    ",2,1
    DATA    "    Nothing    ",0,0
start.over:
    row = 1: colr = inv: txt$ = " P O K E R   S Q U A R E S ": GOSUB dspc
    LOCATE 1, 1: PRINT "F1 = Help";
    LOCATE 1, 73: PRINT "Q = Quit";
    CALL Box0(2, 1, 7, 40, 1, norm)
    LOCATE 2, 3: PRINT "[ The Deck ]"
    CALL Box0(2, 41, 23, 80, 1, norm)
    LOCATE 2, 43: PRINT "[ The Table ]"
    CALL Box0(8, 1, 23, 40, 1, norm)
    LOCATE 8, 3: PRINT "[ Scoring (";
    IF game$ = "A" THEN PRINT "American) ]" ELSE PRINT "English) ]"
    GOSUB dsp.hand.values
    GOSUB dsp.card.positions
    GOSUB shuffle
    GOSUB dsp.init.deck
    GOSUB dsp.deck
    IF mouse% THEN
        CALL MouseTrap(1, 1, 25, 80)
        CALL SetCursor(47 * 8 - 8, 4 * 8 - 8)
    END IF

    FOR card.num = 25 TO 1 STEP -1
get.pos:
        GOSUB clrlin25
        COLOR highlight, background
        colr = hl
        IF NOT mouse THEN
            txt$ = "Where do you want to put the top card (Position 1-25)? ": GOSUB dspc25
        ELSE
            txt$ = "Where do you want to put the top card? ": GOSUB dspc25
        END IF
        LOCATE 25, 67, 0
        IF mouse% THEN
            CALL MorK(Place$, mx, my)
            IF mx <> 0 THEN
                SELECT CASE mx
                    CASE 45 TO 49: cc = 1
                    CASE 52 TO 56: cc = 2
                    CASE 59 TO 63: cc = 3
                    CASE 66 TO 70: cc = 4
                    CASE 73 TO 77: cc = 5
                    CASE ELSE: cc = 0
                END SELECT
                SELECT CASE my
                    CASE 1
                        IF mx < 10 THEN
                            Place$ = CHR$(0) + CHR$(59) 'F1
                            GOTO GotAKey
                        END IF
                        IF mx > 72 THEN
                            Place$ = "Q"
                            GOTO GotAKey
                        END IF
                        cc = 0
                    CASE 3 TO 6: cr = 0
                    CASE 7 TO 10: cr = 5
                    CASE 11 TO 14: cr = 10
                    CASE 15 TO 18: cr = 15
                    CASE 19 TO 22: cr = 20
                    CASE ELSE: cr = 25
                END SELECT
                IF cc = 0 OR cr = 25 THEN Place = 0 ELSE Place = cc + cr
                Place$ = STR$(Place)
                LOCATE 25, 67, 0
                COLOR highlight, background
                PRINT Place$;
            ELSE
                IF Place$ >= "0" AND Place$ <= "9" THEN Place$ = ""
            END IF
        ELSE
            LOCATE 25, 68, 1
            Place$ = ""
            DO
get.pos.2:
                DO: ans$ = UCASE$(INKEY$): LOOP UNTIL ans$ <> ""
                IF ans$ = CHR$(27) OR ans$ = "Q" OR ans$ = CHR$(0) + CHR$(59) THEN Place$ = ans$: EXIT DO'Esc or Q
                IF ans$ = CHR$(8) AND LEN(Place$) > 0 THEN          'backspace
                    Place$ = LEFT$(Place$, LEN(Place$) - 1)
                    LOCATE , POS(0) - 1: PRINT " "; : LOCATE , POS(0) - 1
                    GOTO get.pos.2
                END IF
                IF ans$ = CHR$(13) THEN                             'Enter
                    IF LEN(Place$) > 0 THEN EXIT DO
                END IF
                IF ans$ < "0" OR ans$ > "9" OR LEN(Place$) = 2 THEN
                    SOUND 550, .5
                    GOTO get.pos.2
                ELSE
                    PRINT ans$;
                    Place$ = Place$ + ans$
                    GOTO get.pos.2
                END IF
            LOOP
        END IF
GotAKey:
        IF Place$ = CHR$(27) THEN   '"B" or Esc = Blank
            CALL BlankScreen
        END IF
        IF Place$ = "Q" THEN GOTO ask2          ' quit
        IF Place$ = CHR$(0) + CHR$(59) OR Place$ = "?" THEN
            CALL ScrnSave0(1, 1, 25, 80, SEG Scrn2(0))
            GOSUB Help
            CALL ScrnRest0(1, 1, 25, 80, SEG Scrn2(0))
            CALL MouseTrap(1, 1, 25, 80)
            'CALL MouseTrap(3, 45, 22, 77)
            CALL SetCursor(47 * 8 - 8, 4 * 8 - 8)
            GOTO get.pos
        END IF
        Place = VAL(Place$)
        IF Place < 1 OR Place > 25 THEN
            SOUND 550, .5
            GOTO get.pos
        END IF
        IF position(Place) <> 0 THEN
            colr = norm: txt$ = "That position is already taken.": GOSUB dspc25
            BEEP
            SLEEP 1
            GOTO get.pos
        END IF
        position(Place) = card(card.num)
        IF quiet% = 0 THEN                      '"Placing Card" sound
            FOR s = 100 TO 1000 STEP 100
                SOUND s, .05
                SOUND 20000, .05
            NEXT
        END IF
        GOSUB dsp.placed.card
        COLOR foreground, background
        card(card.num) = 0
        GOSUB dsp.deck
    NEXT
    row = 3: col = 5: colr = norm
    txt$ = "Ŀ ": GOSUB dsp
    txt$ = " ": GOSUB dsp1: GOSUB dsp1
    txt$ = " ": GOSUB dsp1
    GOSUB dsp.scores
    colr = FlashColor
    txt$ = "Computing Scores ...": GOSUB dspc25
    COLOR foreground, background

    total.score = 0
    FOR row = 1 TO 5
        offset = (row - 1) * 5
        CALL compute.score(position(offset + 1), position(offset + 2), position(offset + 3), position(offset + 4), position(offset + 5), hand.played)
        LOCATE 10 + row, 14: PRINT hand$(hand.played);
        LOCATE , 34: PRINT USING "###"; value(hand.played);
        total.score = total.score + value(hand.played)
    NEXT

    FOR col = 1 TO 5
        CALL compute.score(position(col + 0), position(col + 5), position(col + 10), position(col + 15), position(col + 20), hand.played)  ' row 1
        LOCATE 15 + col, 14: PRINT hand$(hand.played);
        LOCATE , 34: PRINT USING "###"; value(hand.played);
        total.score = total.score + value(hand.played)
    NEXT

    LOCATE 21, 32: PRINT "-------";
    LOCATE 22, 19: PRINT "Total Score:";
    LOCATE , 34: PRINT USING "###"; total.score;

    IF game$ = "A" THEN data.file$ = "psquares.sca" ELSE data.file$ = "psquares.sce"
    CALL SetAttr(data.file$, 0)             'turn off all attributes
    OPEN data.file$ FOR APPEND AS #1        ' create file if it does not exist
    CLOSE #1

    OPEN data.file$ FOR INPUT AS #1         ' read data from file
    REDIM name$(10), dat$(10), score(10)
    x = 1
    DO UNTIL EOF(1)
            INPUT #1, name$(x), dat$(x), score(x)
            IF LEN(name$(x)) > 15 THEN name$(x) = LEFT$(name$(x), 15)
            IF LEN(dat$(x)) > 10 THEN dat$(x) = LEFT$(dat$(x), 10)
            IF score(x) > 999 THEN score(x) = 999
            x = x + 1
    LOOP
    CLOSE #1

    IF total.score >= score(10) THEN
getnam: GOSUB clrlin25
        COLOR highlight, background
        PRINT "Your score is in the top 10.  Please enter your name: ";
        LOCATE , POS(0) - 14, 1: INPUT ; "", pnam$
        IF LEN(pnam$) < 1 OR LEN(pnam$) > 14 THEN BEEP: GOTO getnam
        name$(10) = pnam$
        dat$(10) = DATE$
        score(10) = total.score
        limit = 10
        DO                          ' sort scores
            ok = false
            FOR x = 1 TO (limit - 1)
                ' Two adjacent elements are out of order, so swap their values
                IF score(x) < score(x + 1) THEN
                    SWAP name$(x), name$(x + 1)
                    SWAP dat$(x), dat$(x + 1)
                    SWAP score(x), score(x + 1)
                    ok = x
                END IF
            NEXT
            ' Sort on next pass only to where the last switch was made:
            limit = ok
        LOOP WHILE ok

tstdrv:
        ok = WriteTest("")      'check to see if the current default drive is ready for writing
        IF NOT ok THEN
            SOUND 100, 3
            COLOR highlight + 15, back
            LOCATE 24, 29: PRINT "The drive is not ready!";
            colr = hl: txt$ = "Press any key to retry, or Esc to continue without saving scores to disk.": GOSUB dspc25
            COLOR fore, back
            ans$ = INPUT$(1)
            LOCATE 24, 25: PRINT SPACE$(40); : GOSUB clrlin25
            IF ans$ <> CHR$(27) THEN GOTO tstdrv
        END IF

        IF ok THEN
            OPEN data.file$ FOR OUTPUT AS #1            ' write new scores to file
            FOR x = 1 TO 10
                WRITE #1, name$(x), dat$(x), score(x)
            NEXT
            CLOSE #1
        END IF
    ELSE
        SOUND 100, 5
        colr = norm: txt$ = "Sorry, your score did not make the top 10.": GOSUB dspc25
        SLEEP 2
        txt$ = "Press any key to see the high scores.": GOSUB dspc25
        IF mouse% THEN
            CALL MouseTrap(25, 22, 25, 58)
            CALL SetCursor(48, 25)
            CALL MorK(ans$, x, y)
        ELSE
            LOCATE 25, 60, 1
            ans$ = INPUT$(1)
        END IF
    END IF

    CALL ClearScr0(9, 2, 22, 39, norm)      'clear scoring area
    COLOR foreground, background
    LOCATE 10, 11: PRINT "H I G H   S C O R E S"
    LOCATE 11, 3: PRINT "------------------------------------";
    FOR x = 1 TO 10
        IF score(x) = total.score AND dat$(x) = DATE$ AND name$(x) = pnam$ THEN
            COLOR highlight + 16, background
        ELSE
            COLOR foreground, background
        END IF
        LOCATE 11 + x, 3: PRINT USING "##."; x;
        PRINT " "; name$(x);
        LOCATE , 23: PRINT dat$(x);
        LOCATE , 35: PRINT USING "###"; score(x);
    NEXT
   
ask2:
    colr = norm
    txt$ = "Play Again (Y/N)?": GOSUB dspc25
    IF mouse% THEN
        CALL MouseTrap(25, 44, 25, 46)
        CALL SetCursor(44, 25)
        CALL MorK(ans$, x, y)
    ELSE
        LOCATE 25, 50, 1
        ans$ = UCASE$(INPUT$(1))
    END IF
    IF x = 44 OR ans$ = "Y" THEN GOTO Titles
    IF x <> 46 AND ans$ <> "N" THEN SOUND 550, .5: GOTO ask2
    COLOR 7, 0
    CALL ScrnRest0(1, 1, 25, 80, SEG scrn1(0))
    END
'
'************** End Of Main Program ******************
'-------------- Start Of Subroutines -----------------
'
' SHUFFLE the deck
'
shuffle:
    colr = FlashColor
    txt$ = "Shuffling": GOSUB dspc25
    FOR i = 1 TO 156           ' go thru the deck 3 times
        x = INT(RND * 52) + 1
        y = INT(RND * 52) + 1
        SWAP card(x), card(y)
        IF quiet = 0 THEN SOUND 200, .05: SOUND 50, .05
        IF i MOD 5 = 0 THEN CALL Pause(1)
    NEXT i
    GOSUB clrlin25
    RETURN
'
' Display hand values table
'
dsp.hand.values:
    CALL ClearScr0(9, 2, 22, 39, norm)      'clear scoring area
    row = 9: col = 19: colr = norm
    txt$ = "Hand          Score": GOSUB dsp
    col = 12: txt$ = "------------------- -------": GOSUB dsp1
    col = 14
    DO
        txt$ = hand$(row - 9): GOSUB dsp1
        LOCATE row, 34
        PRINT USING "###"; value(row - 10);
    LOOP UNTIL row = 20
    RETURN
'
' Display score table
'
dsp.scores:
    CALL ClearScr0(11, 2, 22, 39, norm)      'clear scoring area
    row = 9: col = 3: colr = norm
    txt$ = "Position": GOSUB dsp
    txt$ = "--------": GOSUB dsp1
    col = col + 1
    FOR row = 11 TO 20
        IF row < 16 THEN
            txt$ = "Row" + STR$(row - 10)
        ELSE
            txt$ = "Col" + STR$(row - 15)
        END IF
        GOSUB dsp
    NEXT
    RETURN
'
' Display card positions
'
dsp.card.positions:
    FOR i = 1 TO 25
        CALL card2pos(i, x, y)
        CALL Box0(y, x, y + 3, x + 4, 1, norm)  'draw card
        IF NOT mouse THEN
            LOCATE y + 1, x + 1: PRINT USING "##"; i;
        END IF
    NEXT
    RETURN
'
' Display placed card
'
dsp.placed.card:
    CALL card2pos(Place, x, y)
    value = (position(Place) - 1) MOD 13 + 2
    Suit = ((position(Place) - 1) \ 13) + 3
    CALL GetCard(value, crd$, card.color, Suit)
    CALL Box0(y, x, y + 3, x + 4, 2, norm)  'draw card
    COLOR card.color, background
    LOCATE y + 1, x + 1: PRINT crd$;
    LOCATE y + 2, x + 2: PRINT CHR$(Suit);
    COLOR foreground, background
    RETURN
'
' display the deck
'
dsp.deck:
    FOR i = 25 TO 1 STEP -1
        IF card(i) <> 0 THEN
            value = (card(i) - 1) MOD 13 + 2
            Suit = ((card(i) - 1) \ 13) + 3
            CALL GetCard(value, crd$, card.color, Suit)
            row = 3: col = i + 5: colr = norm
            txt$ = "Ŀ ": GOSUB dsp
            txt$ = "    ": GOSUB dsp1: GOSUB dsp1
            txt$ = " ": GOSUB dsp1
            COLOR card.color, background
            LOCATE 4, col + 1: PRINT crd$;
            LOCATE 5, col + 2: PRINT CHR$(Suit);
            COLOR foreground, background
            RETURN
        END IF
    NEXT
    RETURN
'
' display initial deck
'
dsp.init.deck:
    row = 3: col = 5: colr = norm
    txt$ = "Ŀ": GOSUB dsp
    txt$ = "   ": GOSUB dsp1: GOSUB dsp1
    txt$ = "" ': GOSUB dsp1
    'RETURN         '***Note: this takes advantage of "dsp1" being the next
                    '         routine.  If any routines come between, the
                    '         GOSUB and RETURN will be necessary.
'
'   Display a string
'
dsp1:
    row = row + 1   'automatically increment row
dsp:
    LOCATE row, col, 0
    CALL QPrint0(txt$, colr)
    RETURN
'
'   display a string (centered)
'
dspc25:
    GOSUB clrlin25
    row = 24
dspc1:
    row = row + 1
dspc:
    col = 40 - LEN(txt$) \ 2
    GOTO dsp
'
' clear line 25 (status line)
'
clrlin25:
    LOCATE 25, 1
    CALL QPrint0(SPACE$(80), norm)
    RETURN

SUB BlankScreen

    SHARED Scrn3() AS INTEGER

    CALL HideCursor
    CALL ScrnSave0(1, 1, 25, 80, SEG Scrn3(0))
    COLOR 0, 0
    CLS
    LOCATE , , 0
    DO
         CALL GetCursor(x, y, Button)      'wait until all mouse buttons are released
    LOOP UNTIL Button = 0
    DO
         CALL GetCursor(x, y, Button)
         IF Button <> 0 OR INKEY$ <> "" THEN Switch = TRUE ELSE Switch = false
    LOOP UNTIL Switch = TRUE
    CALL ScrnRest0(1, 1, 25, 80, SEG Scrn3(0))

END SUB

SUB card2pos (card, x, y)

    x = card MOD 5
    IF x = 0 THEN x = 73 ELSE x = 38 + x * 7
    y = ((card - 1) \ 5) * 4 + 3

END SUB

SUB compute.score (pos1, pos2, pos3, pos4, pos5, hand.played)

SHARED Card.Value()

    Card.Value(1) = (pos1 - 1) MOD 13 + 2
    'suit1 = INT((pos1 - 1) / 13) + 3
    suit1 = ((pos1 - 1) \ 13) + 3
    Card.Value(2) = (pos2 - 1) MOD 13 + 2
    suit2 = ((pos2 - 1) \ 13) + 3
    Card.Value(3) = (pos3 - 1) MOD 13 + 2
    suit3 = ((pos3 - 1) \ 13) + 3
    Card.Value(4) = (pos4 - 1) MOD 13 + 2
    suit4 = ((pos4 - 1) \ 13) + 3
    Card.Value(5) = (pos5 - 1) MOD 13 + 2
    suit5 = ((pos5 - 1) \ 13) + 3

'    CALL SortI(SEG Card.Value(1), 5, 0)
'
' sort values in ascending order (bubble sort)
'
    limit = 5
    DO
        Switch = false
        FOR row = 1 TO (limit - 1)
            ' Two adjacent elements are out of order, so swap their values
            IF Card.Value(row) > Card.Value(row + 1) THEN
                SWAP Card.Value(row), Card.Value(row + 1)
                Switch = row
            END IF
        NEXT row
        ' Sort on next pass only to where the last switch was made:
        limit = Switch
    LOOP WHILE Switch

    dif12 = ABS(Card.Value(1) - Card.Value(2))
    dif23 = ABS(Card.Value(2) - Card.Value(3))
    dif34 = ABS(Card.Value(3) - Card.Value(4))
    dif45 = ABS(Card.Value(4) - Card.Value(5))
 

    IF suit1 = suit2 AND suit2 = suit3 AND suit3 = suit4 AND suit4 = suit5 THEN
        '
        ' if all suits are the same, then we have at least a flush
        '
        IF dif12 = 1 AND dif23 = 1 AND dif34 = 1 AND dif45 = 1 THEN
            '
            ' if values differ by one each, then we have at least a straight flush
            '
            IF Card.Value(5) = 14 THEN
                '
                ' if the high card is an Ace, then we have a royal flush
                '
                hand.played = 1     ' royal flush
            ELSE
                hand.played = 2     ' straight flush
            END IF
        ELSE
            hand.played = 5         ' flush
        END IF
        EXIT SUB
    END IF

    IF dif12 = 1 AND dif23 = 1 AND dif34 = 1 AND dif45 = 1 THEN
        hand.played = 6     ' straight
        EXIT SUB
    END IF

    IF (dif12 = 0 AND dif23 = 0 AND dif34 = 0) OR (dif23 = 0 AND dif34 = 0 AND dif45 = 0) THEN
        hand.played = 3     ' four of a kind
        EXIT SUB
    END IF

    IF (dif12 = 0 AND dif23 = 0) OR (dif23 = 0 AND dif34 = 0) OR (dif34 = 0 AND dif45 = 0) THEN
        IF (dif12 = 0 AND dif23 = 0 AND dif45 = 0) OR (dif12 = 0 AND dif34 = 0 AND dif45 = 0) THEN
            hand.played = 4     ' full house
        ELSE
            hand.played = 7     ' three of a kind
        END IF
        EXIT SUB
    END IF

    IF dif12 = 0 OR dif23 = 0 OR dif34 = 0 OR dif45 = 0 THEN
        IF (dif12 = 0 AND dif34 = 0) OR (dif23 = 0 AND dif45 = 0) OR (dif12 = 0 AND dif45 = 0) THEN
            hand.played = 8     ' two pairs
        ELSE
            hand.played = 9     ' one pair
        END IF
        EXIT SUB
    END IF

    hand.played = 10    ' default to hand 10 (nothing,0)

END SUB

SUB GetCard (value, crd$, card.color, Suit)
'
' convert card number to label and color
'
SHARED video

    SELECT CASE value
        CASE 2 TO 9: crd$ = STR$(value)
        CASE 10: crd$ = "10"
        CASE 11: crd$ = " J"
        CASE 12: crd$ = " Q"
        CASE 13: crd$ = " K"
        CASE 14: crd$ = " A"
        CASE ELSE
    END SELECT
    IF video = &HB4 THEN
        card.color = 7          'mono
    ELSE
        IF Suit = 3 OR Suit = 4 THEN
            card.color = 4      'red for hearts or diamonds
        ELSE
            card.color = 0      'black for clubs or spades
        END IF
    END IF

END SUB

SUB MorK (ky$, x, y)
'
'   get mouse or keyboard input
'
'   Inputs: none
'   Outputs: key$ -- key pressed ("" if no key pressed)
'            x,y -- mouse position when button was pressed
'                   x = text col, y = text row
'                   0,0 if mouse button not pressed
'
    DO
        CALL ShowCursor
        Button = 1
        DO UNTIL Button = 0
            CALL GetCursor(x, y, Button)      'wait until all mouse buttons are released
        LOOP
        ky$ = "": Button = 0
        DO UNTIL Button <> 0 OR ky$ <> ""
            ky$ = UCASE$(INKEY$)
            CALL GetCursor(x, y, Button)      'wait for mouse button to be pressed
        LOOP
        IF Button THEN
            IF Button AND 4 THEN
                CALL BlankScreen
                'ky$ = "B"
                'x = 0: y = 0
            ELSE
                IF Button AND 1 THEN
                    x = x \ 8 + 1
                    y = y \ 8 + 1
                    EXIT DO
                END IF
            END IF
        ELSE
            IF ky$ = CHR$(27) THEN      'Esc
                CALL BlankScreen
            ELSE
                x = 0: y = x
                EXIT DO
            END IF
        END IF
    LOOP
    CALL HideCursor

END SUB

