uses crt;
const nulo=chr(0);       {varias teclas}
      escape=chr(27);
      enter=chr(13);
      retroceso=chr(8);
      izquierda='K';
      derecha='M';
      arriba='H';
      abajo='P';
      repag='I';
      avpag='Q';
      max_opc=10;{nmero mximo de opciones de un men}
type
    t_menu=array[1..max_opc] of string[20];{tipo para los menus}
var opc:byte;
    menu:t_menu;
    s_device,m_device:byte;
    tec:array[0..1,1..6] of byte;



procedure ventana(x1,y1,x2,y2,c1,c2:byte);
{dibuja una ventana en la pantalla. Necesita la esquina sup. izq. y la
inf. der., adems de los colores de primer plano y fondo. Adems, al salir,
los colores activos son c1 y c2, y el cursor est al principio de la ventana.}
var i,j:byte;{auxiliares}
begin
 textcolor(c1);{prepearamos colores}
 textbackground(c2);

 gotoxy(x1,y1);write('');{esquina sup.izq.}
 for i:=x1+1 to x2-1 do write('');{linea superior}
 write('');{esquina sup.der.}
 for i:=y1+1 to y2-1 do begin {cada linea horizontal}
    gotoxy(x1,i);
    write('');{carcter a la izquierda de la ventana}
    for j:=x1+1 to x2-1 do write(' ');{relleno de la ventana}
    write('');{carcter a la derecha de la ventana}
 end;
 gotoxy(x1,y2);write('');{esquina inf.izq.}
 for i:=x1+1 to x2-1 do write('');{lnea inferior}
 write('');{esquina inf der}
 gotoxy(x1+1,y1+1) {al principio de la ventana}
end;




function opcion(var menu:t_menu;max,x1,y1,c1,c2:byte):byte;
{Dibuja un menu con las opciones pasadas en la variable 'menu', y devuelve
la lnea seleccionada (Si se pulsa escape, devuelve 0).
En la entrada, el array 'menu' debe contenter en cada componente una opcin.
'max' indica el nmero de opciones.}

var selec:byte; {ndice a la lnea resaltada del menu}
    c:char; {para leer tecla}

procedure escribe_opciones(var menu:t_menu;max,selec,x1,y1,c1,c2:byte);
{Escribe las 'max' primeras opciones de 'menu', con colores c1 y c2, a partir
de (x1,y1), coordenadas de la ventana del menu. Adems invierte los colores en
la lnea 'selec'.}
var i:byte;{auxiliar}
begin
for i:=1 to max do begin
    gotoxy(x1+1,y1+i);{se posiciona}
    if i=selec then begin {si la lnea es la seleccionada}
       textcolor(c2); {colores invertidos}
       textbackground(c1);
    end
    else begin {sino es la seleccionada}
      textcolor(c1); {colores normales}
      textbackground(c2);
    end;
    write(menu[i]); {escribe la opcion}
end;
end;{fin de escribe opciones}


begin {de opciones}
ventana(x1,y1,x1+20+1,y1+max+1,blue,lightgray); {dibuja ventana}
selec:=1;{al principio, la opcin resaltada es la primera}
escribe_opciones(menu,max,selec,x1,y1,c1,c2);{escribe las opciones}
repeat
   c:=readkey;{lee tecla}
   case c of
      arriba:if selec>1 then selec:=selec-1 {si se pulsa arriba}
			else selec:=max;
      abajo:if selec<max then selec:=selec+1 {si se pulsa abajo}
			 else selec:=1;
   end;
   escribe_opciones(menu,max,selec,x1,y1,c1,c2); {actualiza la linea resaltada}
until c in [enter,escape]; {hasta que se acepte con enter, o se aborte con esc}
if c=escape then opcion:=0 {si se abort, opcion es 0}
	    else opcion:=selec; {sino, la opcion elegida es la resaltada}
end;{fin de opciones}





procedure limpia;
var i:byte;
begin
gotoxy(1,1);
textcolor(15);
textbackground(1);
clrscr;
for i:=1 to 8*24 do
    write('');
gotoxy(10,2);write('');
gotoxy(10,3);write('');
gotoxy(10,4);write('');
gotoxy(10,5);write('');
gotoxy(1,24);
write('Configuracin de HORM. Pablo Romero Casas 1995');
end;



procedure pide_tecla(nom:string;cual:byte);
begin
  gotoxy(26,9+opc+cual); write(nom);
  repeat until port[$60]>128;
  repeat until port[$60]<128; tec[opc-3,cual]:=port[$60];
end;



function correcto:boolean;
var i,j,k,l:byte;
    c:byte;
begin
   c:=0;
   if not s_device in [0,1,2] then c:=1;
   if not m_device in [0,1] then c:=2;
   for i:=0 to 1 do
     for j:=1 to 6 do begin
       if tec[i,j] in [1,68] then c:=3;
       for k:=0 to 1 do
         for l:=1 to 6 do
           if (tec[i,j]=tec[k,l]) and ((i<>k) or (j<>l)) then c:=3;
     end;

   if c<>0 then begin
     sound(440);
     delay(50);
     nosound;
     ventana(10,20,60,22,1,15);
     case c of
       1:write(' La configuracin del sonido es incorrecta');
       2:write(' La configuracin de la msica es incorrecta');
       3:write(' Alguna tecla se repite en la redefinicin');
     end;
     repeat until readkey<>'';
   end;
   correcto:=(c=0);
end;




procedure graba_config;
var f:file of byte;
    t:text;
    i,j:byte;
begin
assign(f,'Horm.cfg');
{$i-}
rewrite(f);
{$i+}
if ioresult<>0 then writeln('Error al grabar la configuracin')
else begin
  for i:=0 to 1 do
    for j:=1 to 6 do write(f,tec[i,j]);
  write(f,s_device,m_device);
  close(f);
  assign(t,'Hormi.bat');
  rewrite(t);
  writeln(t,'@echo off');
  if m_device=1 then writeln(t,'lh sbfmdrv >nul');
  writeln(t,'horm %1 %2 %3 %4');
  if m_device=1 then writeln(t,'lh sbfmdrv /u >nul');
  close(t);
  writeln('Ahora ejecuta HORMI.BAT');
end;
end;



procedure carga_config;
var f:file of byte;
    i,j:byte;
begin
assign(f,'Horm.cfg');
{$i-}
reset(f);
{$i+}
if ioresult=0 then begin
  for i:=0 to 1 do
    for j:=1 to 6 do read(f,tec[i,j]);
  read(f,s_device,m_device);
  close(f);
end
else begin
  tec[0,1]:=72;tec[0,2]:=80;tec[0,3]:=75;
  tec[0,4]:=77;tec[0,5]:=28;tec[0,6]:=54;
  tec[1,1]:=17;tec[1,2]:=45;tec[1,3]:=30;
  tec[1,4]:=32;tec[1,5]:=42;tec[1,6]:=29;
  s_device:=0; m_device:=0;
end;
end;





begin
carga_config;
clrscr;
repeat
repeat
  limpia;
  menu[1]:='Efectos Sonoros';
  menu[2]:='Msica';
  menu[3]:='Control Jugador 1';
  menu[4]:='Control Jugador 2';
  menu[5]:='Salir y grabar';
  opc:=opcion(menu,5,10,7,1,15);
  case opc of
   1:begin
     menu[1]:='Sin sonido';
     menu[2]:='Sound Blaster';
     menu[3]:='PC Speaker';
     opc:=opcion(menu,3,25,10,1,15);
     if opc=0 then opc:=1
     else s_device:=opc-1;
     end;
   2:begin
     menu[1]:='Sin msica';
     menu[2]:='Sound Blaster';
     opc:=opcion(menu,2,25,11,1,15);
     if opc=0 then opc:=1
     else m_device:=opc-1;
     end;
   3,4:begin
     ventana(25,9+opc,40,16+opc,1,15);
     pide_tecla('Arriba',1);
     pide_tecla('Abajo',2);
     pide_tecla('Izquierda',3);
     pide_tecla('Derecha',4);
     pide_tecla('Disparo',5);
     pide_tecla('Salto',6);
     end;
   end;
until opc in[0,5];
until (opc=0) or correcto;
textcolor(7);
textbackground(0);
clrscr;
if opc=5 then graba_config;
end.