unit psoft1;


interface
type t_color=record
                 red,green,blue:byte;
              end;
     t_paleta=array[0..255] of t_color;
const vga256=10;
      p_vga:pointer=ptr($a000,0);
      camino_usual='c:\lenguaje\tp7\bgi';
      size_lbm=65144;
      rat_izquierdo=1;
      rat_derecho=2;
      rat_ambos=3;
      rat_cualquiera=100;
      nulo=chr(0);       {varias teclas}
      escape=chr(27);
      enter=chr(13);
      retroceso=chr(8);
      f1=';';
      f2='<';
      f3='=';
      f4='>';
      f5='?';
      f6='@';
      f7='A';
      f8='B';
      f9='C';
      f10='D';
      izquierda='K';
      derecha='M';
      arriba='H';
      abajo='P';
      repag='I';
      avpag='Q';
      inicio='G';
      fin='O';
      ins='R';
      supr='S';

function existe(camino:string):boolean;
function se_puede_escribir(camino:string):boolean;
function optimizado(p:pointer):pointer;
function modo_grafico(gd,gm:integer;camino:string):integer;
function abre_fichero(var f:file):integer;
procedure carga_bloque(var f:file;p:pointer;l:word);
procedure graba_bloque(var f:file;p:pointer;l:word);
procedure transforma_lbm(p:pointer);
procedure mueve_mem(po,pd:pointer;l:word);
procedure inserta_espacio_mem(ini:pointer;tamano:word;fint:pointer);
procedure paleta_de_lbm(p:pointer;var pal:t_paleta);
procedure carga_lbm(nom:string;p:pointer;var q:pointer);
procedure pon_pal(paleta:t_paleta;ini,fin:word);
procedure dame_pal(var paleta:t_paleta;ini,fin:word);
procedure borra_pal(var paleta:t_paleta;ini,fin:word);
procedure abre_pal(paleta:t_paleta;vel:word;ini,fin:word);
procedure funde_pal(paleta:t_paleta;vel,ini,fin:word);
procedure carga_pal(nom:string;i:word;var pal:t_paleta);
procedure pon_imagen(x,y,modo:integer;po,pd:pointer);
procedure pon_image(x,y:integer;po,pd:pointer;dir:boolean);
procedure coge_imagen(x,y,x2,y2:integer;pd,po:pointer);
procedure rellena(p:pointer;l,atr:word);
function hay_raton:boolean;
procedure pon_cursor_de_raton;
procedure quita_cursor_de_raton;
function boton_presionado(boton:byte):boolean;
procedure espera_pulsar_boton(boton:byte);
function x_raton:word;
function xv_raton:word;
function y_raton:word;
function raton_en_ventana(x1,y1,x2,y2:word):boolean;
function ratonv_en_ventana(x1,y1,x2,y2:word):boolean;
function tamano_imagen(x1,y1,x2,y2:word):word;

implementation
uses windos,crt,graph;


function existe;
var f:file;
begin
assign(f,camino);
{$i-}
reset(f);
{$i+}
if ioresult=0
   then begin
      existe:=true;
      close(f);
   end
   else existe:=false;
end;


function se_puede_escribir;
{camino es la ruta de directorios acabada en '\'}
var f:file;
begin
assign(f,camino+'$%&#&.!');
{$i-}
rewrite(f);
{$i+}
if ioresult=0
   then begin
      se_puede_escribir:=true;
      close(f);
      erase(f);
   end
   else se_puede_escribir:=false;
end;


function optimizado;
begin
optimizado:=ptr(seg(p^)+ofs(p^) div 16,ofs(p^) mod 16);
end;

function modo_grafico;
begin
initgraph(gd,gm,camino);
modo_grafico:=gd;
end;

function abre_fichero;
begin
{$i-}
reset(f,1);
{$i+}
abre_fichero:=ioresult;
end;


procedure carga_bloque;
var h,s,o:word;
    q:^word;
    reg:tregisters;
begin
q:=ptr(seg(f),ofs(f));
reg.ah:=$3f;
reg.bx:=q^;
reg.cx:=l;
reg.ds:=seg(p^);
reg.dx:=ofs(p^);
intr($21,reg);
end;


procedure graba_bloque;
var h,s,o:word;
    q:^word;
    reg:tregisters;
begin
q:=ptr(seg(f),ofs(f));
reg.ah:=$40;
reg.bx:=q^;
reg.cx:=l;
reg.ds:=seg(p^);
reg.dx:=ofs(p^);
intr($21,reg);
end;



procedure transforma_lbm;
var segm,ofse:word;
begin
segm:=seg(p^);
ofse:=ofs(p^);
asm
      cld
      push ax
      push bx
      push cx
      push dx
      push si
      push di
      push ds
      push es

      mov ax,segm
      mov ds,ax   {ds=lbm}
      mov bx,ofse

{cargar el fichero empezando por atrs}
      mov di,64823  {di=puntero al fichero lbm}
      mov si,64000  {si=y}
@rep1: sub si,320   {este es el bucle de las lneas}
          mov al,128  {al=co}
          mov dh,0  {dh=bc}
          mov bx,320
          mov cx,0
      @forx: mov [bx+si+1142],cx
                dec bx
                dec bx
             jnz @forx
   @for1: mov bx,320  {este es el bucle de los 320 puntos de una linea}
             mov ch,0  {ch=bp}
      @for2: mov ah,1  {ah=un} {este es el bucle de los 40 bytes de un color}
             mov dl,[di] {este es el bucle que recorre los un byte}
           @for3:  mov cl,dl
                   and cl,ah
                   jz @sal1 {decide si aplicar el color}
                      or [bx+si+1143],al {aplica el color}
                   @sal1:dec bx
                add ah,ah
                jnz @for3
                dec di
                cmp bx,0
             jne @for2
             shr al,1
             inc dh
             cmp dh,8
          jne @for1
          cmp si,0
      jne @rep1

      pop es
      pop ds
      pop di
      pop si
      pop dx
      pop cx
      pop bx
      pop ax
end;
end;



procedure mueve_mem;
{l se da en bytes}
var s_o,o_o,s_d,o_d:word;
    alante:boolean;
begin
po:=optimizado(po);
pd:=optimizado(pd);
if seg(po^)<seg(pd^) then alante:=false
   else if seg(po^)>seg(pd^) then alante:=true
   else if ofs(po^)<ofs(pd^) then alante:=false
   else alante:=true;
o_o:=ofs(po^);
s_o:=seg(po^);
o_d:=ofs(pd^);
s_d:=seg(pd^);
asm
      push cx
      push ds
      push es
      push di
      push si

      mov cx,s_o
      mov ds,cx
      mov si,o_o
      mov cx,s_d
      mov es,cx
      mov di,o_d
      mov cx,l
      cld

      cmp alante,0
      jne  @ala
                 {instrucciones previas si el movimiento}
      add si,cx  {se debe hacer hacia atras}
      add di,cx
      std
      test cx,1 {ltimo de hacia atrs}
      jz @sin
      dec si
      dec di
      movsb

@sin: sub si,2
      sub di,2

@ala: test cx,1 {primero de hacia alante}
      jz @cop
      movsb
@cop:
      shr cx,1
      jcxz  @uno {si se copia un byte, no se debe ejecutar ningn movsw}
      rep
      movsw  {copia un nmero par de bytes}

@uno: cmp alante,0
      jne @fin

@fin: pop si
      pop di
      pop es
      pop ds
      pop cx
      cld
end;
end;



procedure inserta_espacio_mem;
{entre ini+tamano y fint no debe haber ms de 64k}
var hasta_fin:word;
    fin:pointer;
begin
ini:=optimizado(ini);
fin:=optimizado(ptr(seg(ini^),ofs(ini^)+tamano));
fint:=optimizado(fint);
hasta_fin:=(seg(fint^)-seg(fin^))*16+ofs(fint^)-ofs(fin^);
if tamano>0 then mueve_mem(ini,fin,hasta_fin);
end;



procedure pon_imagen;
var s_o,o_o,s_d,o_d:word;
begin
po:=optimizado(po);
pd:=optimizado(pd);
o_o:=ofs(po^);
s_o:=seg(po^);
o_d:=ofs(pd^);
s_d:=seg(pd^);
asm
        push ax
        push bx
        push cx
        push dx
        push ds
        push es
        push bp
        push si
        push di

        mov ax,s_o
        mov es,ax  {es=segmento de imagen}
        mov di,o_o  {di=desplazamiento}

        mov ax,s_d
        mov ds,ax

        mov dx,es:[di]  {dx contiene long_x}
        add dx,x          {dx contiene ahora x2+1}

        mov bx,y
        mov ax,0
        cmp bx,0
        jz  @@3  {caso y=0}
@@2:    add ax,320
        dec bx
        jnz @@2
@@3:    mov y,ax  {y contiene y1*320}

        mov bx,es:[di+2]  {bx contiene long_y (no puede ser 0)}
        mov ax,0
@@1:    add ax,320
        dec bx
        jnz @@1
        add ax,y          {ax contiene y2*320+320}
        add di,4
        mov si,y
        add si,o_d
        add ax,o_d

        cmp modo,0
        je  @modoput
        cmp modo,1
        je  @modoswap
        cmp modo,2
        je  @modoput0

@modoswap0:
@iory:  mov bx,x
@iorx:  mov cl,es:[di]
        and cl,cl
        jz  @talta
        xchg ds:[bx+si],cl
        mov es:[di],cl
@talta: inc di
        inc bx
        cmp bx,dx
        jne @iorx
        add si,320
        cmp si,ax
        jne @iory
        jmp @fin

@modoput0:
@hory:  mov bx,x
@horx:  mov cl,es:[di]
        and cl,cl
        jz  @salta
        mov ds:[bx+si],cl
@salta: inc di
        inc bx
        cmp bx,dx
        jne @horx
        add si,320
        cmp si,ax
        jne @hory
        jmp @fin

@modoswap:
@gory:  mov bx,x
@gorx:  mov cl,es:[di]
        xchg ds:[bx+si],cl
        mov es:[di],cl
        inc di
        inc bx
        cmp bx,dx
        jne @gorx
        add si,320
        cmp si,ax
        jne @gory
        jmp @fin

@modoput:
@fory:  mov bx,x
@forx:  mov cl,es:[di]
        mov ds:[bx+si],cl
        inc di
        inc bx
        cmp bx,dx
        jne @forx
        add si,320
        cmp si,ax
        jne @fory

@fin:   pop di
        pop si
        pop bp
        pop es
        pop ds
        pop dx
        pop cx
        pop bx
        pop ax
end;
end;

procedure pon_image;
var s_o,o_o,s_d,o_d:word;
    lx,ly,y2:integer;
begin
po:=optimizado(po);
pd:=optimizado(pd);
o_o:=ofs(po^);
s_o:=seg(po^);
o_d:=ofs(pd^);
s_d:=seg(pd^);
asm
        push ax
        push bx
        push cx
        push dx
        push ds
        push es
        push bp
        push si
        push di

        mov ax,s_o
        mov es,ax  {es=segmento de imagen}
        mov di,o_o  {di=desplazamiento}

        mov ax,s_d
        mov ds,ax {ds pantalla}

        mov ax,es:[di]
        mov lx,ax
        mov ax,es:[di+2]
        mov ly,ax
        add di,4 {donde comienzan los pixels}

{ahora ajustaremos por arriba y abajo}
        mov bx,y
        cmp bx,0
        jnl  @n_arr {comprueba si se sale por arriba}
        add ly,bx
@arr:   add di,lx {los datos comienzan ms alante}
        inc bx
        jnz @arr

        mov y,0
        cmp ly,0
        jle @fin {si y2<0 (y2+1<=0) esta encima de la pantalla}
        jmp @n_aba
@n_arr:
        cmp y,199
        jg  @fin {si y1>199  esta debajo de la pantalla}
        mov bx,y
        add bx,ly
        cmp bx,200
        jng @n_aba {si y1+ly>200 no cabe entero}
        sub bx,200
        sub ly,bx {disminuye ly}

{ahora ajustaremos y's a punteros(*320)}
@n_aba: mov bx,y
        mov ax,0
        cmp bx,0
        jz  @@3  {caso y=0}
@@2:    add ax,320
        dec bx
        jnz @@2
@@3:    mov y,ax  {y contiene y1*320}

        mov bx,ly
        mov ly,bx  {bx contiene long_y (no puede ser 0)}
        mov ax,0
@@1:    add ax,320
        dec bx
        jnz @@1
        add ax,y          {ax contiene y2*320+320}
        mov si,y

        add si,o_d {si=y1*320}
        add ax,o_d
        mov y2,ax  {y2=(y2+1)*320}

{ahora ajustaremos a izquierda y derecha}
        xor ax,ax
        cmp x,0
        jnl @n_izq {no se sale por la izquierda}
        sub ax,x {diferencia por izq}
        mov x,0
        sub lx,ax {lx(ancho en pant)+ax(ancho fuera de pant)=ancho real}
        jle @fin {si ancho en pant<=0 est a la izq de pantalla}
        cmp dir,0
        jne @n_der
        sub di,ax
        jmp @n_der

@n_izq: mov ax,x
        add ax,lx
        sub ax,320
        jg  @s_der {se sale por la derecha}
        xor ax,ax
        jmp @n_der
@s_der: sub lx,ax
        jle @fin {x1>319 est a la derecha}
        cmp dir,0
        je @n_der
        sub di,ax


@n_der: cmp dir,0
        je @modoputi

@modoputd:
        mov dx,lx          {dx contiene long_x}
        add dx,x          {dx contiene ahora x2+1}
@hory:  mov bx,x
        add di,ax
@horx:  mov cl,es:[di]
        and cl,cl
        jz  @salta
        mov ds:[bx+si],cl
@salta: inc di
        inc bx
        cmp bx,dx
        jne @horx
        add si,320
        cmp si,y2 {ax=(y2+1)*320}
        jne @hory
        jmp @fin

@modoputi:
        mov dx,x
        dec dx          {dx contiene x1-1}
@fory:  mov bx,lx
        add bx,x
        dec bx            {bx contiene ahora x2}
        add di,ax
@forx:  mov cl,es:[di]
        and cl,cl
        jz  @talta
        mov ds:[bx+si],cl
@talta: inc di
        dec bx
        cmp bx,dx
        jne @forx
        add si,320
        cmp si,y2
        jne @fory

@fin:   pop di
        pop si
        pop bp
        pop es
        pop ds
        pop dx
        pop cx
        pop bx
        pop ax
end;
end;


procedure coge_imagen;
var s_o,o_o,s_d,o_d,lx,ly:word;
begin
po:=optimizado(po);
pd:=optimizado(pd);
o_o:=ofs(po^);
s_o:=seg(po^);
o_d:=ofs(pd^);
s_d:=seg(pd^);
lx:=abs(x2-x)+1; ly:=abs(y2-y)+1;
if x>x2 then x:=x2; if y>y2 then y:=y2;
asm
        push ax
        push bx
        push cx
        push dx
        push ds
        push es
        push bp
        push si
        push di

        mov ax,s_o
        mov es,ax  {es=segmento de imagen}
        mov di,o_o  {di=desplazamiento}

        mov ax,s_d
        mov ds,ax

        mov dx,lx
        mov es:[di],dx  {dx contiene long_x}
        add dx,x          {dx contiene ahora x2+1}

        mov bx,y
        mov ax,0
        cmp bx,0
        jz  @@3  {caso y=0}
@@2:    add ax,320
        dec bx
        jnz @@2
@@3:    mov y,ax  {y contiene y1*320}

        mov bx,ly
        mov es:[di+2],bx  {bx contiene long_y (no puede ser 0)}
        mov ax,0
@@1:    add ax,320
        dec bx
        jnz @@1
        add ax,y          {ax contiene y2*320+320}
        add di,4
        mov si,y
        add si,o_d
        add ax,o_d

@iory:  mov bx,x
@iorx:  mov cl,ds:[bx+si]
        mov es:[di],cl
@talta: inc di
        inc bx
        cmp bx,dx
        jne @iorx
        add si,320
        cmp si,ax
        jne @iory

@fin:   pop di
        pop si
        pop bp
        pop es
        pop ds
        pop dx
        pop cx
        pop bx
        pop ax
end;
end;





procedure paleta_de_lbm;
type dibu=record
                bla:array[0..47] of byte;
                pa:t_paleta;
          end;
var s,o:word;
    q:^dibu;
    i:byte;
begin
q:=p;
for i:=0 to 255 do begin
   pal[i].red:=q^.pa[i].red div 4;
   pal[i].green:=q^.pa[i].green div 4;
   pal[i].blue:=q^.pa[i].blue div 4;
end;
end;


procedure pon_pal;
var reg:tregisters;
begin
reg.es:=seg(paleta);
reg.dx:=ofs(paleta)+ini*3;
reg.bx:=ini;
reg.ax:=$1012;
reg.cx:=fin-ini+1;
intr($10,reg);
end;


procedure dame_pal;
var reg:tregisters;
begin
reg.es:=seg(paleta);
reg.dx:=ofs(paleta)+ini+ini+ini;
reg.bx:=ini;
reg.ax:=$1017;
reg.cx:=fin-ini+1;
intr($10,reg);
end;


procedure borra_pal;
var i:byte;
var reg:tregisters;
begin
   for i:=ini to fin do with paleta[i] do begin
      red:=0;blue:=0;green:=0;
   end;
end;


procedure funde_pal;
var i,c:byte;
var reg:tregisters;
begin
for c:=0 to 63 do begin
   delay(vel);
   for i:=ini to fin do with paleta[i] do begin
      if red<>0 then dec(red);
      if green<>0 then dec(green);
      if blue<>0 then dec(blue);
   end;
   pon_pal(paleta,ini,fin);
end;
end;


procedure abre_pal;
var i,c:byte;
    pal_aux:t_paleta;
var reg:tregisters;
begin
borra_pal(pal_aux,ini,fin);
for c:=63 downto 0 do begin
   delay(vel);
   for i:=ini to fin do with pal_aux[i] do begin
      if c<paleta[i].red then inc(red);
      if c<paleta[i].green then inc(green);
      if c<paleta[i].blue then inc(blue)
   end;
   pon_pal(pal_aux,ini,fin);
end;
end;


procedure carga_pal;
{devuleve pal[0].red:=111 si hubo error}
var f:file;
    p:pointer;
begin
assign(f,nom);
p:=ptr(seg(pal),ofs(pal));
if abre_fichero(f)=0 then begin
   if filesize(f)>=i*sizeof(t_paleta) then begin
      seek(f,(i-1)*sizeof(t_paleta));
      carga_bloque(f,p,sizeof(t_paleta));
      close(f);
   end
   else pal[0].red:=111;
end
else pal[0].red:=111;;
end;


procedure carga_lbm;
{devuleve nil si hubo error al abrir el archivo}
var f:file;
begin
assign(f,nom);
if abre_fichero(f)=0 then
if filesize(f)=64824 then begin
   p:=optimizado(p);
   carga_bloque(f,p,64824);
   transforma_lbm(p);
   q:=ptr(seg(p^),ofs(p^)+1144);
   q:=optimizado(q);
   close(f);
end
else q:=nil
else q:=nil;
end;


procedure rellena;
{l en bytes}
var s,o:word;
begin
o:=ofs(p^);
s:=seg(p^);
asm
      cli
        push ds
        push ax
        push bx
        push cx

        mov ax,atr
        mov cx,s
        mov ds,cx
        mov bx,o
        mov cx,l

        cmp cx,1 {caso de un byte}
        je  @uno

        shr cx,1 {de bytes a words}
@lazo:  mov [bx],ax
        add bx,2
        loop @lazo

        and l,1 {si l era impar, ahora l es 1}
        jz  @par
@uno:   mov [bx],al
@par:
        pop cx
        pop bx
        pop ax
        pop ds
end;
end;

function hay_raton;
var reg:tregisters;
begin
reg.ax:=0;
reg.bx:=0;
intr($33,reg);
if reg.ax=$ffff then hay_raton:=true
else hay_raton:=false;
end;


procedure pon_cursor_de_raton;
var reg:tregisters;
begin
reg.ax:=1;
intr($33,reg);
end;

procedure quita_cursor_de_raton;
var reg:tregisters;
begin
reg.ax:=2;
intr($33,reg);
end;

function boton_presionado;
var reg:tregisters;
begin
reg.ax:=3;
intr($33,reg);
if (boton=rat_cualquiera) and (reg.bx<>0) then boton_presionado:=true
   else if boton=rat_ambos then boton_presionado:=boton=reg.bx
   else boton_presionado:=(boton and reg.bx)<>0;
end;

procedure espera_pulsar_boton;
begin
repeat
   while keypressed do readkey
until not boton_presionado(boton);
repeat
   while keypressed do readkey
until boton_presionado(boton);
end;

function x_raton;
var reg:tregisters;
begin
reg.ax:=3;
intr($33,reg);
x_raton:=reg.cx
end;

function xv_raton;
var reg:tregisters;
begin
reg.ax:=3;
intr($33,reg);
xv_raton:=reg.cx div 2
end;

function y_raton;
var reg:tregisters;
begin
reg.ax:=3;
intr($33,reg);
y_raton:=reg.dx;
end;


function raton_en_ventana;
begin
raton_en_ventana:=(x_raton>=x1) and (x_raton<=x2) and
                  (y_raton>=y1) and (y_raton<=y2);
end;

function ratonv_en_ventana;
begin
ratonv_en_ventana:=(xv_raton>=x1) and (xv_raton<=x2) and
                  (y_raton>=y1) and (y_raton<=y2);
end;

function tamano_imagen;
begin
tamano_imagen:=(abs(x2-x1)+1)*(abs(y2-y1)+1)+4;
end;

end.