UNIT CMFTool;
{
 ********************************************************************
 * Unit para controlar la tarjeta Sound Blaster en Borland Pascal   *
 *              empleando el controlador SBFMDRV.COM.               *
 ********************************************************************
 *                 (C) 1994 Data Becker GmbH & Co.                  *
 *                          MARCOMBO S.A.                           *
 *                    Autor : Axel Stolz                            *
 ********************************************************************
}

INTERFACE

USES Dos;

TYPE
  CMFFileTyp = FILE;
  CMFDataTyp = Pointer;
  CMFHeader = RECORD  { Estructur de un CMF-File-Header }
    CMFFileID         : ARRAY[0..3] OF CHAR;  { CMF file ID = 'CTMF'     }
    CMFVersion        : WORD;                 { N de versin            }
    CMFInstrBlockOfs  : WORD;                 { Offset para instrumentos }
    CMFMusicBlockOfs  : WORD;                 { Offset para datos musical}
    CMFTickPerBeat    : WORD;                 { "Ticks" por Beat         }
    CMFClockTicksPS   : WORD;                 { Timer-Clock-Rate         }
    CMFFileTitleOfs   : WORD;                 { Offset Ttulo msica     }
    CMFComposerOfs    : WORD;                 { Offset Music composer    }
    CMFMusicRemarkOfs : WORD;                 { Offset Comentarios msica}
    CMFChannelsUsed   : ARRAY[0..15] OF CHAR; { N canales empleados     }
    CMFInstrNumber    : WORD;                 { N de instrumentos       }
    CMFBasicTempo     : WORD;                 { Tempo  fundamental       }
  END;

CONST
   CMFToolVersion       = 'v1.0';

VAR
   CMFStatusByte      : BYTE;       { Variable para estado CMF      }
   CMFErrStat         : WORD;       { Variable para n error CMF    }
   CMFDriverInstalled : BOOLEAN;    { Flag, si control. instalado   }
   CMFDriverIRQ       : WORD;       { N de la IRQ empleada         }
   CMFSongPaused      : BOOLEAN;    { Flag, si cancin parada       }
   OldExitProc        : Pointer;    { Puntero al antiguo  ExitProc  }
   CMFSongbuffer      : Pointer;

PROCEDURE PrintCMFErrMessage;
FUNCTION  CMFGetSongBuffer(VAR CMFBuffer : Pointer; CMFFile : STRING):BOOLEAN;
FUNCTION  CMFFreeSongBuffer (VAR CMFBuffer : Pointer):BOOLEAN;
FUNCTION  CMFInitDriver : BOOLEAN;
FUNCTION  CMFGetVersion : WORD;
PROCEDURE CMFSetStatusByte;
FUNCTION  CMFSetInstruments(VAR CMFBuffer : Pointer):BOOLEAN;
FUNCTION  CMFSetSingleInstruments(VAR CMFInstrument:Pointer; No:WORD):BOOLEAN;
PROCEDURE CMFSetSysClock(Frequency : WORD);
PROCEDURE CMFSetDriverClock(Frequency : WORD);
PROCEDURE CMFSetTransposeOfs (Offset : INTEGER);
FUNCTION  CMFPlaySong(VAR CMFBuffer : Pointer) : BOOLEAN;
FUNCTION  CMFStopSong : BOOLEAN;
FUNCTION  CMFResetDriver:BOOLEAN;
FUNCTION  CMFPauseSong : BOOLEAN;
FUNCTION  CMFContinueSong : BOOLEAN;

IMPLEMENTATION

TYPE
   TypeCastTyp = ARRAY [0..6000] of Char;

VAR
   Regs : Registers;
   CMFIntern : ^CMFHeader; { Puntero interno a la estructura CMF  }

FUNCTION CMFStopSong : BOOLEAN;
{
 * ENTRADA  : ninguna
 * SALIDA   : TRUE/FALSE, segn xito al parar
 * FUNCION  : Intenta parar una cancin.
}

BEGIN
   Regs.BX := 07;
   Intr(CMFDriverIRQ, Regs);
   IF Regs.AX = 0 THEN begin
      CMFStopSong := TRUE;
      CMFSongbuffer:=nil;
   end
   ELSE BEGIN
      CMFStopSong := FALSE;
      CMFErrStat  := 510;
      END;
   END;

PROCEDURE PrintCMFErrMessage;
{
 * ENTRADA  : ninguna
 * SALIDA   : ninguna
 * FUNCION  : Visualiza el error SB en la pantalla como texto, sin modificar
 *            el estado de error.
}
BEGIN
   CASE CMFErrStat OF
      100 : Write(' No se encontr controlador SBFMDRV ');
      110 : Write(' Reset del controlador sin xito ');

      200 : Write(' No se encuentra archivo CMF ');
      210 : Write(' no hay memoria libre para archivo CMF ');
      220 : Write(' Archivo no es formato CMF ');

      300 : Write(' Error de asignacin de memoria ');

      400 : Write(' demasiados instrumentos definidos ');

      500 : Write(' No se pudieron reproducir los datos CMF ');
      510 : Write(' No se pudieron parar los datos CMF ');
      520 : Write(' No se pudieron detener los datos CMF ');
      530 : Write(' No se pudieron continuar los datos CMF ');
      END;
   END;

FUNCTION Exists (Filename : STRING):BOOLEAN;
{
 * ENTRADA  : Nombre de archivo como String
 * SALIDA   : TRUE, si el archivo existe, sino FALSE
 * FUNCION  : Comprueba si un archivo ya existe, y devuelve una expresin
              booleana en funcin de ello.
}
VAR
   F : File;
BEGIN
   Assign(F,Filename);
{$I-}
   Reset(F);
   Close(F);
{$I+}
   Exists := (IoResult = 0) AND (Filename <> '');
   END;

PROCEDURE AllocateMem (VAR Pt : Pointer; Size : LongInt);
{
 * ENTRADA  : Variable para bfer como puntero,
              Tamao del bfer como LongInt
 * SALIDA   : Puntero al bfer en variable, o NIL
 * FUNCION  : Reserva tantos bytes como indica SIZE, y coloca un
              puntero a ellos en la variable Pt. Si no hay memoria
              suficiente, Pt apunta a NIL
}
VAR
   SizeIntern : WORD;     { Tamao del bfer para clculo interno }
BEGIN
   Inc(Size,15);                 { Aumentar tamao del bfer en 15 }
   SizeIntern := (Size shr 4);   { y dividir por 16.               }
   Regs.AH := $48;               { Cargar funcin MS-DOS $48 en AH }
   Regs.BX := SizeIntern;        { Cargar tamao interno en BX     }
   MsDos(Regs);                  { Reservar memoria                }
   IF (Regs.BX <> SizeIntern) THEN Pt := NIL
   ELSE Pt := Ptr(Regs.AX,0);
   END;

FUNCTION  CheckFreeMem (VAR CMFBuffer : Pointer; CMFSize : LongInt):BOOLEAN;
{
 * ENTRADA  : Variable para bfer como puntero, tamao deseado como LongInt
 * SALIDA   : Puntero a bfer, TRUE/FALSE, segn AllocateMem
 * FUNCION  : Comprueba si se puede ocupar memoria suficiente para el archivo CMF
}
BEGIN
   AllocateMem(CMFBuffer,CMFSize);
   CheckFreeMem := CMFBuffer <> NIL;
   END;

FUNCTION  CMFGetSongBuffer(VAR CMFBuffer : Pointer; CMFFile : STRING):BOOLEAN;
{
 * ENTRADA  : Variable para bfer como puntero, nombre de archivo como String
 * SALIDA   : Puntero a bfer con datos CMF, TRUE/FALSE
 * FUNCION  : Carga un archivo en memoria, y devuelve TRUE en caso de xito,
              sino FALSE.
}
CONST
   FileCheck : STRING[4] = 'CTMF';
VAR
   CMFFileSize : LongInt;
   FPresent    : BOOLEAN;
   VFile       : CMFFileTyp;
   Segs        : WORD;
   Read        : WORD;
   Checkcount  : BYTE;

BEGIN
   FPresent := Exists(CMFFile);

{ El archivo CMF no se encontr }
   IF Not(FPresent) THEN BEGIN
      CMFGetSongBuffer := FALSE;
      CMFErrStat   := 200;
      EXIT
      END;

   Assign(VFile,CMFFile);
   Reset(VFile,1);
   CMFFileSize := Filesize(VFile);
   AllocateMem(CMFBuffer,CMFFileSize);

{ No hay memoria suficiente para el archivo CMF }
   IF (CMFBuffer = NIL) THEN BEGIN
      Close(VFile);
      CMFGetSongBuffer := FALSE;
      CMFErrStat   := 210;
      EXIT;
      END;

   Segs := 0;
   REPEAT
      Blockread(VFile,Ptr(seg(CMFBuffer^)+4096*Segs,Ofs(CMFBuffer^))^,$FFFF,Read);
      Inc(Segs);
      UNTIL Read = 0;
   Close(VFile);

{ El archivo no es de formato CMF }
   CMFIntern := CMFBuffer;
   CheckCount := 1;
   REPEAT
      IF FileCheck[CheckCount] = CMFIntern^.CMFFileID[CheckCount-1]
         THEN Inc(CheckCount)
         ELSE CheckCount := $FF;
      UNTIL CheckCount >= 3;
   IF NOT(CheckCount = 3) THEN BEGIN
      CMFGetSongBuffer := FALSE;
      CMFErrStat   := 220;
      EXIT;
      END;

{ La carga ha tenido xito }
   CMFGetSongBuffer := TRUE;
   CMFErrStat   := 0;
   END;

FUNCTION CMFFreeSongBuffer (VAR CMFBuffer : Pointer):BOOLEAN;
{
 * ENTRADA  : Puntero a bfer como Pointer
 * SALIDA   : ninguna
 * FUNCION  : Devuelve la memoria ocupada por los datos CMF
}
BEGIN
   if cmfstatusbyte<>0 then cmfstopsong;
   Regs.AH := $49;              { Cargar funcin MS-DOS $49 en AH   }
   Regs.ES := seg(CMFBuffer^);  { Segmento de memoria en ES         }
   MsDos(Regs);                 { Volver a liberar memoria          }
   CMFFreeSongBuffer := TRUE;
   IF (Regs.AX = 7) OR (Regs.AX = 9) THEN BEGIN
      CMFFreeSongBuffer := FALSE;
      CMFErrStat := 300         { al liberar ha ocurrido un error   }
      END;                      { de DOS.                           }
   END;

FUNCTION CMFInitDriver : BOOLEAN;
{
 * ENTRADA  : ninguna
 * SALIDA   : TRUE, si se encontr e inicializ el controlador, si no FALSE
 * FUNCION  : Comprueba si SBFMDRV.COM est residente en memoria, y
              a continuacin lo inicializa
}

CONST
   DriverCheck :STRING[5] = 'FMDRV'; { cadena buscada en SBFMDRV }
VAR
   ScanIRQ,
   CheckCount  : BYTE;
   IRQPtr,
   DummyPtr    : Pointer;

BEGIN
{ Interrupciones posibles para SBFMDRV son las de $80 a $BF }
   FOR ScanIRQ := $80 TO $BF DO BEGIN
      GetIntVec(ScanIRQ, IRQPtr);
      DummyPtr := Ptr(Seg(IRQPtr^), $102);

{ Comprueba si en el programa de interrupciones se encuentra la }
{ cadena FMDRV, slo entonces se puede tratar de SBFMDRV        }
      CheckCount := 1;
      REPEAT
         IF DriverCheck[CheckCount] = TypeCastTyp(DummyPtr^)[CheckCount]
            THEN Inc(CheckCount)
            ELSE CheckCount := $FF;
         UNTIL CheckCount >= 5;

      IF (CheckCount = 5) THEN BEGIN
{ La cadena se encontr. Se realiza la inicializacin }
         Regs.BX := 08;
         CMFDriverIRQ := ScanIRQ;
         Intr(CMFDriverIRQ, Regs);
         IF Regs.AX = 0 THEN
            CMFInitDriver := TRUE
         ELSE BEGIN
            CMFInitDriver := FALSE;
            CMFErrStat    := 110;
            END;
         Exit;
         END
      ELSE BEGIN
{ La cadena no se encontr }
         CMFInitDriver := FALSE;
         CMFErrStat := 100;
         END;
      END;
   END;

FUNCTION CMFGetVersion : WORD;
{
 * ENTRADA  : ninguna
 * SALIDA   : N versin principal en byte alto, secundario en byte bajo
 * FUNCION  : Lee el n de versin del controlador SBFMDRV
}

BEGIN
   Regs.BX := 0;
   Intr(CMFDriverIRQ,Regs);
   CMFGetVersion := Regs.AX;
   END;


PROCEDURE CMFSetStatusByte;
{
 * ENTRADA  : ninguna
 * SALIDA   : ninguna
 * FUNCION  : Colocar valor de estado del controlador en CMFStatusByte.
}

BEGIN
   Regs.BX:= 1;
   Regs.DX:= Seg(CMFStatusByte);
   Regs.AX:= Ofs(CMFStatusByte);
   Intr(CMFDriverIRQ, Regs);
   END;

FUNCTION CMFSetInstruments(VAR CMFBuffer : Pointer):BOOLEAN;
{
 * ENTRADA  : Bfer de los datos CMF como Pointer
 * SALIDA   : TRUE/FALSE, despus de asignar los instrumentos
 * FUNCION  : Ajusta los registros FM de la tarjeta SB a los valores
              de los instrumentos que se encuentran en el archivo CMF
}

BEGIN
    CMFIntern := CMFBuffer;
    IF CMFIntern^.CMFInstrNumber > 128 THEN BEGIN
       CMFErrStat := 400;
       CMFSetInstruments := FALSE;
       Exit;
       END;
    Regs.BX := 02;
    Regs.CX := CMFIntern^.CMFInstrNumber;
    Regs.DX := Seg(CMFBuffer^);
    Regs.AX := Ofs(CMFBuffer^)+CMFIntern^.CMFInstrBlockOfs;
    Intr(CMFDriverIRQ, Regs);
    CMFSetInstruments := TRUE;
   END;

FUNCTION CMFSetSingleInstruments(VAR CMFInstrument:Pointer; No:WORD):BOOLEAN;
{
 * ENTRADA  : Bfer de los datos de instrumentos CMF como Pointer,
              N de instrumentos como WORD
 * SALIDA   : TRUE/FALSE, despus de asignar los instrumentos
 * FUNCION  : Asigna los registros FM de la tarjeta SB a los valores
              en funcin de la estructura de datos que se oculta detrs
              del puntero CMFInstrument.
}

BEGIN
    IF No > 128 THEN BEGIN
       CMFErrStat := 400;
       CMFSetSingleInstruments := FALSE;
       Exit;
       END;
    Regs.BX := 02;
    Regs.CX := No;
    Regs.DX := Seg(CMFInstrument^);
    Regs.AX := Ofs(CMFInstrument^);
    Intr(CMFDriverIRQ, Regs);
    CMFSetSingleInstruments := TRUE;
   END;

PROCEDURE CMFSetSysClock(Frequency : WORD);
{
 * ENTRADA  : System-Timer-Clock-Rate como WORD
 * SALIDA   : ninguna
 * FUNCION  : Asigna el valor estndar del Timer 0 al nuevo valor.
}

BEGIN
   Regs.BX := 03;
   Regs.AX := (1193180 DIV Frequency);
   Intr(CMFDriverIRQ, Regs);
   END;

PROCEDURE CMFSetDriverClock(Frequency : WORD);
{
 * ENTRADA  : Timer-Clock-Rate como WORD
 * SALIDA   : ninguna
 * FUNCION  : Asigna la frecuencia del timer para controladores a un nuevo valor.
}

BEGIN
   Regs.BX := 04;
   Regs.AX := (1193180 DIV Frequency);
   Intr(CMFDriverIRQ, Regs);
   END;

PROCEDURE CMFSetTransposeOfs (Offset : INTEGER);
{
 * ENTRADA  : Offset como WORD. El valor indica cuntos semitonos se han de
              transponer las notas.
 * SALIDA   : ninguna
 * FUNCION  : Transpone todas las notas que se reproducen, por un "Offset"
}

BEGIN
   Regs.BX := 05;
   Regs.AX := Offset;
   Intr(CMFDriverIRQ, Regs);
   END;

FUNCTION CMFPlaySong(VAR CMFBuffer : Pointer) : BOOLEAN;
{
 * ENTRADA  : Puntero a los datos del tema
 * SALIDA   : TRUE, si inicio correcto, sino FALSE
 * FUNCION  : Inicializa todos los parmetros importantes y comienza la reproduccin.
}

VAR
   Check : BOOLEAN;
BEGIN
   CMFIntern := CMFBuffer;
{ Asignar la frecuencia de reloj del controlador }
   CMFSetDriverClock(CMFIntern^.CMFClockTicksPS);
{ Asignar los instrumentos }
   Check := CMFSetInstruments(CMFBuffer);
   IF Not(Check) THEN Exit;
   Regs.BX := 06;
   Regs.DX := Seg(CMFIntern^);
   Regs.AX := Ofs(CMFIntern^)+CMFIntern^.CMFMusicBlockOfs;
   Intr(CMFDriverIRQ, Regs);

   IF Regs.AX = 0 THEN BEGIN
      CMFPlaySong := TRUE;
      CMFSongPaused := FALSE;
      END
   ELSE BEGIN
      CMFPlaySong := FALSE;
      CMFErrStat := 500;
      END;
   END;


FUNCTION CMFResetDriver:BOOLEAN;
{
 * ENTRADA  : ninguna
 * SALIDA   : ninguna
 * FUNCION  : Reinicializa el controlador a su estado primitivo.
}

BEGIN
   Regs.BX := 08;
   Intr(CMFDriverIRQ, Regs);
   IF Regs.AX = 0 THEN
      CMFResetDriver := TRUE
   ELSE BEGIN
      CMFResetDriver := FALSE;
      CMFErrStat    := 110;
      END;
   END;

FUNCTION CMFPauseSong : BOOLEAN;
{
 * ENTRADA  : ninguna
 * SALIDA   : TRUE/FALSE, segn xito al detener
 * FUNCION  : Intenta detener una cancin. Si es posible, se coloca la
              variable global CMFSongPaused a TRUE.
}

BEGIN
   Regs.BX := 09;
   Intr(CMFDriverIRQ, Regs);
   IF Regs.AX = 0 THEN BEGIN
      CMFPauseSong  := TRUE;
      CMFSongPaused := TRUE;
      END
   ELSE BEGIN
      CMFPauseSong := FALSE;
      CMFErrStat   := 520;
      END;
   END;

FUNCTION CMFContinueSong : BOOLEAN;
{
 * ENTRADA  : ninguna
 * SALIDA   : TRUE/FALSE, segn xito al continuar
 * FUNCION  : intenta continuar una cancin. Si es posible, la variable
              global CMFSongPaused pasa a FALSE
}

BEGIN
   Regs.BX := 10;
   Intr(CMFDriverIRQ, Regs);
   IF Regs.AX = 0 THEN BEGIN
      CMFContinueSong  := TRUE;
      CMFSongPaused    := FALSE;
      END
   ELSE BEGIN
      CMFContinueSong := FALSE;
      CMFErrStat      := 530;
      END;
   END;

{$F+}
PROCEDURE CMFToolsExitProc;
{$F-}
{
 * ENTRADA  : ninguna
 * SALIDA   : ninguna
 * FUNCION  : Reponer la direccin del byte de estado para que no se
              escriba en zonas de memoria cualesquiera despus de terminar
              el controlador.
}
BEGIN
   Regs.BX:= 1;
   Regs.DX:= 0;
   Regs.AX:= 0;
   Intr(CMFDriverIRQ, Regs);
   ExitProc := OldExitProc;
   END;


BEGIN
{ Reubicar la ExitProc antigua a la de la nueva Tool-Unit }
   OldExitProc := ExitProc;
   ExitProc := @CMFToolsExitProc;
{ Inicializacin de las variables }
   CMFErrStat := 0;
   CMFSongPaused := FALSE;
{ Inicializacin del controlador }
   CMFDriverInstalled := CMFInitDriver;
   IF CMFDriverInstalled THEN BEGIN
      CMFStatusByte := 0;
      CMFSetStatusByte;
      END;
   END.
