Program CMFDemo;
{
 *************************************************************************
 *   Programa de demostracin de la Unit CMFTOOL, (W) en Borland Pascal  *
 *************************************************************************
 *                     (C) 1994 DATA BECKER GmbH & Co.                   *
 *                            MARCOMBO S.A.                              *
 *                         Autor : Axel Stolz                            *
 *************************************************************************
 * El lmite superior de memoria del programa principal se ha de bajar,  *
 * de lo contrario el programa ocupar toda la memoria disponible. De    *
 * modo que no quedar memoria libre para los datos CMF deseados. Los    *
 * parmetros de memoria se han de adaptar segn el programa principal.  *
 *************************************************************************
}


{$M 16384,0,65535}

Uses CMFTool,Crt;

VAR
   Check      : BOOLEAN;    { Variable boolenana de uso variado    }
   SongName   : String;     { String para nombre del archivo CMF   }
   SongBuffer : CMFDataTyp; { Bfer para el archivo CMF            }

PROCEDURE Error;
{
 * ENTRADA  : ninguna, los datos proceden de la variable global CMFErrStat
 * SALIDA   : ninguna
 * FUNCION  : Visualiza el error SB ocurrido como texto en la pantalla,
              incluyendo el nmero de error, y termina el programa con el
              Errorlevel, que correponde el error.
}
BEGIN
   Write(' Error #',CMFErrStat:3,' =');
   PrintCMFErrMessage;
   WriteLn;
   HALT(CMFErrStat);
   END;

BEGIN
   ClrScr;
{ Si no est instalado el controlador SBFMDRV, error }
   IF Not (CMFDriverInstalled) THEN Error;

{
 Si no se ha especificado un nombre de tema como lnea de comandos,
 se busca un nombre fijo.
}
   IF ParamCount = 0 THEN SongName := 'STARFM.CMF'
                     ELSE SongName := ParamStr(1);

{ Visualizar el nmero principal y secundario de versin del controlador }
   GotoXY(25,5);
   Write  (' SBFMDRV Versin ',Hi(CMFGetVersion):2,'.');
   WriteLn(Lo(CMFGetVersion):2,' ha sido cargado.');

{ Visualizar el n de interrupcin empleado }
   GotoXY(15,10);
   Write  ('El controlador emplea la interrupcin de sistema n ');
   WriteLn(CMFDriverIRQ:3);
   GotoXY(37,15);
   WriteLn('Estado del tema');
   GotoXY(37,23);
   WriteLn(SongName);

{ Cargar el archivo deseado }
   Check := CMFGetSongBuffer(SongBuffer,SongName);
   IF NOT(Check) THEN Error;

{
 Aqu puede trasponer la cancin (tema) cargada hacia arriba o abajo, segn
 si indica un valor positivo o negativo. Con 0 la cancin se reproduce con
 el tono original.
}
   CMFSetTransposeOfs(0); { Aqu puede experimentar con los valores }

{ Reproducir la cancin }
   Check := CMFPlaySong(SongBuffer);
   IF NOT(Check) THEN Error;

{ Durante la reproduccin de la cancin se visualiza el byte de estado }
   REPEAT
      GotoXY(41,17);Write(CMFStatusByte:3);
      UNTIL (KeyPressed OR (CMFStatusByte = 0));

{ Si se pulsa una tecla, se interrumpe la cancin }
   IF KeyPressed THEN BEGIN
      Check := CMFStopSong;
      IF NOT(Check) THEN Error;
      END;

{ Volver el controlador al estado original }
   Check := CMFResetDriver;
   IF NOT(Check) THEN Error;

{ Volver a liberar la memoria de la cancin }
   Check := CMFFreeSongBuffer(SongBuffer);
   IF NOT(Check) THEN Error;
   END.
