	PAGE	59,130
;MOVIMAGE.ASM	SEP-29-94
;--Loren Blaney

cseg	segment dword public 'code'
	assume cs:cseg

;----------------------------------------------------------------------
;MovImage(X0, Y0, X1, Y1, W, H);
;Routine to move a rectangular image of width W and height H from X0,Y0
; to X1,Y1. All arguments are in pixels. Width W, X0 and X1 are assumed
; to be multiples of 8.
;
fieldwidth equ	80		;width of field in bytes

	public	_movimage
_movimage:
	mov	dx,3ceh		;set write mode 1
	mov	ax,0105h	;3ce(5):= 1
	out	dx,ax

	pop	bx		;get return address
	pop	cx

	pop	bp		;get height (in pixels) and save in bp

	pop	si		;get width (in pixels)
	add	si,7		;calculate width in bytes
	shr	si,1		;byte width = (width + 7) /8
	shr	si,1
	shr	si,1		;save in width in si for now

	pop	dx		;get destination line, Y1
	mov	ax,fieldwidth	;set up destination pointer
	mul	dx		;di:= Y1 * fieldwidth + X1/8
	pop	dx
	shr	dx,1
	shr	dx,1
	shr	dx,1
	add	ax,dx
	mov	di,ax

	pop	ax		;set up source pointer
	mov	dx,fieldwidth	;si:= Y0 * fieldwidth + X0/8
	mul	dx
	pop	dx
	shr	dx,1
	shr	dx,1
	shr	dx,1
	add	ax,dx
	xchg	si,ax		;ax:= width in bytes

	push	cx		;restore return address
	push	bx

	push	ds		;save registers
	push	es

	mov	bx,0a000h	;point segment registers to display memory
	mov	es,bx
	mov	ds,bx

	mov	bx,fieldwidth	;modulo: amount to add to right side of image
	sub	bx,ax		; to reach left side on next scan line down

;Register usage:
; ax = width of image in bytes
; bx = modulo (= field width in bytes - image width in bytes)
; cx = counter for width in bytes
; si = pointer to image source (X0,Y0)
; di = pointer to image destination (X1,Y1)
; bp = height of image in pixels (or scan lines)

	cld
mi10:	mov	cx,ax		;reset counter for width of image in bytes
	rep movsb		;move a scan line   es:di++ := ds:si++  cx--
	add	si,bx		;point to beginning of next scan line in image
	add	di,bx
	dec	bp		;decrement image height counter
	jne	mi10

	mov	dx,3ceh		;restore write mode back to 0
	mov	ax,0005h	;3ce(5):= 0
	out	dx,ax

	pop	es		;restore registers
	pop	ds
	retf

cseg	ends
	end
