echo off
REM	Written/Analyzed by Wayne Sikes, K&W Computer Works.
REM
REM	This file is part of the DOOMEZ package.  It lets you play ANY
REM	DOOM episode/mission with special powers and weapons YOU want by
REM	performing the following functions. Note that this file runs DOOM in
REM	single-player mode and no editing is done on modem players.  See the
REM	readme.doc file for info on editing modem save files.
REM		1)  DOOM is called and setup for running in developmental mode.
REM		    You must pass into this batch file the episode, mission, 
REM		    and skill level as command line parameters.  Episodes are
REM		    numbered 1-3, missions 1-9, and skill levels 1-5 for DOOM1.2
REM		    and 1-4 for DOOM1.1. These parms are passed into the first 
REM	 	    run of DOOM via the developmental -wart E M and -skill S 
REM		    command line switches. 
REM		    This will force DOOM to load your specified episode and 
REM		    mission and will also setup for the passed-in skill level. 
REM		    When DOOM finishes the initial game setup and you are given 
REM		    the play screen, SAVE THE MISSION (via the F2 key) IN THE 
REM		    TOP SAVE SLOT.  This will force the mission to be saved in 
REM		    file doomsav0.dsg.
REM		2)  Control will be passed to the DOOMFIX routine.  DOOMFIX will
REM	 	    open the doomsav0.dsg file and will edit it using the 
REM		    DOOMFIX.CFG file commands.  See the readme.doc file that
REM		    came with the DOOMEZ package for more info on customizing
REM		    the DOOMFIX run. DOOMFIX can edit MANY save file parameters.
REM		    DOOMFIX will tell you the save file parameters that have
REM		    been changed.  When DOOMFIX is done, your doomsav0.dsg file
REM		    will have been edited and you are ready to play DOOM.  Note
REM		    that DOOMFIX.EXE and DOOMFIX.CFG MUST be in your \doomdata
REM		    area if you are playing DOOM version 1.1.  If playing DOOM
REM		    version 1.2, the DOOMFIX files must be in your \doom area.
REM		3)  Lastly, DOOM will be called again, and the doomsav0.dsg file
REM		    will be passed to it via the developmental mode command line
REM		    switches.  Play DOOM normally from here on.  Notice that 
REM		    you have lots of extra ammunition, health, etc!  The only 
REM		    time you'll need to rerun this batch file is when you want
REM		    to begin a new episode/mission that is out-of-series with
REM		    the missions you've just been playing. 
REM	
REM	Because of the MANY save file setups for missions, the user is forced
REM	to do this type of save file manipulation in order to play a custom
REM	DOOM game while at the same time getting lots of neat extra goodies.
REM	Of course, you can warp to any DOOM mission using the development modes,
REM	and using the in-game cheat switches (iddqd, idbehold, etc.) you can get
REM	special powers and ammo, but you still won't be able to make the
REM	special changes required for getting the capability that DOOMFIX gives
REM	you!
REM
REM
echo     Custom DEVELOPMENTAL MODE setup for DOOM 
if "%1" == "" goto USAGE
if "%2" == "" goto USAGE
if "%3" == "" goto USAGE
cls
cd \doom
echo     Calling DOOM to setup episode, mission, skill level...
echo     This initial DOOM run sets up the mission parameters. Let the game
echo     load and then SAVE the setup without playing the game.  Save to
echo     the TOP SAVE SLOT in the game!
pause
DOOM  -devparm -wart %1 %2  -skill %3
cls
echo     Ready for DOOMFIX editing on DOOMSAV0.DSG, abort here if needed...
pause
REM	#####################################################################
REM	##  Comment out the next line if you are playing DOOM 1.2.  Leave ###
REM	##  it active if playing DOOM 1.1. Add a REM statement to the line###
REM	##  beginning, i.e., REM cd \doomdata, to comment it out.	  ###
REM	#####################################################################
cd \doomdata
doomfix
echo     Ready to run DOOM using DOOMSAV0.DSG, abort here if needed...
pause
cls
cd \doom
DOOM -devparm -loadgame 0
cls
echo	End custom DOOM run...
goto EXIT

:USAGE
cls
echo    USAGE:     playdoom   episode[1-3]  mission[1-9]  skill[1-5 or 1-4] 
echo    Enter command line arguments to specify the episode, mission, and
echo    skill level you want.  For example, "playdoom 1 3 4" will run this
echo    routine for episode 1, mission 3, and skill level 4.
goto EXIT


:EXIT
REM	END OF PLAYDOOM.BAT		
