.model tiny
.code
_QEMM_ = 1
_hlt macro
     local $$test
     ifndef _QEMM_
       hlt
       exitm
     else
      push ax
      cli
      in al,21H
      mov ah,al
      or al,3
      out 21H,al

      mov al,0aH
      out 20H,al
$$test:
      in al,20H
      test al,3
      jz $$test
      mov al,ah
      out 21H,al
      sti
      pop ax
      endif
endm

xsize = 10
ysize = 20
count = 21
line  = 29
scr_end  =  11*10


start_X         equ      23h
start_Y         equ      8
size_of_string  equ      8
shape_counter = 7
        org 100h
start:
        jmp main
copy_r  db 0dh,0ah,0dh,0ah,"Free!!! Tiny Tetris. Copyright (C) Red Rat 1991. Moscow.",0dh,0ah,"Programing by AlexQ & A.Lochm.",0dh,0ah,0dh,0ah
copy_size = $-offset copy_r
extension db 'scr',0
msg0    db '   Press 0-9 to',0,'  select  level.',0,'<ESC>-quit to DOS',0,'  Control keys:',0
        db ' 4 -Left move',0,' 6 -Right move',0,' 2 -Move Down',0,' Space -Drop',0,' + -Next level',0,' - -Prev. level',0
        db ' 0 -Extended game',0,' * -Show next',0,' . -Pause game',0
msg1    db '   Game paused.',0,'  Press <ESC> to',0,'  Continue Game.',0
msg2    db '  Enter you Name:',0
msg3    db ' Name   Point Lev.',0

msgtmp  db 8 dup(20h)
scrtmp  db 5 dup(20h)
spctmp  db 3 dup(20h)
scrlv   db 2 dup(20h)
end_sc  db 0

keys    label word
        db 20H,'2','4','5','6',1bh,'0','+','-','*','.'
keys_length = $ - keys

key_table label word
        dw offset drop_shape
        dw offset move_down
        dw offset move_left
        dw offset rotate
        dw offset move_right
        dw offset check_you_score
        dw offset extended_play
        dw offset increase_level
        dw offset decrease_level
        dw offset show_hide_next
        dw offset pause

vga_font label word
 db 07Fh,0C0h,0A0h,09Fh,09Fh,09Fh,09Fh,09Fh,09Fh,09Fh,09Fh,09Fh,09Fh,0A0h,0C0h,07Fh; 0E1
 db 0FEh,003h,005h,0F9h,0F9h,0F9h,0F9h,0F9h,0F9h,0F9h,0F9h,0F9h,0F9h,005h,003h,0FEh; 0E2
ega_font label word
 db 07Fh,0C0h,0A0h,09Fh,09Fh,09Fh,09Fh,09Fh,09Fh,09Fh,09Fh,0A0h,0C0h,07Fh; 0E1
 db 0FEh,003h,005h,0F9h,0F9h,0F9h,0F9h,0F9h,0F9h,0F9h,0F9h,005h,003h,0FEh; 0E2
font_ptr    dw 0
font_length dw 0
second_char db 0e1H
cga         db 0
cup_offset  dw 0  ;pointer  to screen cup
glass1      dw 0  ;pointer  to cup object
row         dw 0  ;pointer  to row table
buffer db       'Score:'
for_space db    '     '
end_of_buffer label word
db ' '
db 0
level_poster db 'Level:'
for_lev      db '    ',0
hndl          dw 0ffffh
side          dw 0    ;size of dropping matrix side
xd            dw 0
yd            dw 0

window_def      label byte
w_x0             db 0
w_y0             db 0
w_lx             db 0
w_ly             db 0
cur_x            db 1
cur_y            db 1

window_border  dw 0cdch,0cdch,04dch,0cdbh,04f20h,04b1h,0cdbh,04b1h,04b1h

cursor			dw	0
length_of_string	dw	0
string			db	size_of_string + 1 dup (0)

vseg          dw 0b800H
v_mode        db 0
current_shape db 0
current_color db 0
next_shape    db 0
next_color    db 0
drop          db 0
counter       db count
speed         db 0
score         dw 0
level         db 1
lines         db line
max_shape     dw shape_counter
show_next_shape db 0
std_atr       db 4fh
scr_ptr       dw 0
shape0 label byte
       db 3
       db 0fH,0fH,0fH
       db 0  ,0fH,0
       db 0  ,0  ,0
shape1 label byte
       db 3
       db 0  , 0 ,0
       db 0fh, 0 ,0
       db 0fh,0fh,0fh
shape2 label byte
       db 3
       db 0  ,0  ,0
       db 0  ,0  ,0fh
       db 0fh,0fh,0fh
shape3 label byte
       db 2
       db 0fh,0fh
       db 0fh,0fh
shape4 label byte
       db 3
       db 0  ,0fh,0
       db 0  ,0fh,0fh
       db 0  ,0  ,0fh
shape5 label byte
       db 3
       db 0  ,0fh,0
       db 0fh,0fh,0
       db 0fh,0  ,0
shape6 label byte
       db 4
       db 0,0,0,0
       db 0fh,0fh,0fh,0fh
       db 0,0,0,0
       db 0,0,0,0
shape7 label byte
       db 3
       db 0fh,0,0
       db 0,0fh,0
       db 0,0,0fh
shape8 db 3
       db 0,0,0
       db 0fh,0,0fh
       db 0,0,0
shape9 db 3
       db 0h,0,0h
       db 0fh,0,0fh
       db 0fh,0fh,0fh
shape10 db 3
       db 0,0,0
       db 0,0fh,0
       db 0fh,0,0fh
shape11 db 3
       db 0,0fh,0
       db 0,0fh,0
       db 0fh,0,0fh
shape12 db 3
       db 0  ,0   ,0fh
       db 0  ,0fh ,0fh
       db 0fh,0fh ,0fh
shape13 db 4
       db 0  ,0  ,0,  0
       db 0  ,0  ,0,  0
       db 0  ,0  ,0  ,0fh
       db 0fh,0fh,0fh,0
shape14 db 4
       db 0  ,0  ,0,  0
       db 0,0,0,0
       db 0fh,0,0,0
       db 0,0fh,0fh,0fh
shape15 db 2
       db 0  ,0fh
       db 0fh,0fh

shape_table label word
       dw offset shape0
       dw offset shape6
       dw offset shape2
       dw offset shape3
       dw offset shape4
       dw offset shape5
       dw offset shape1
       dw offset shape7
       dw offset shape8
       dw offset shape9
       dw offset shape10
       dw offset shape11
       dw offset shape12
       dw offset shape13
       dw offset shape14
       dw offset shape15
tshape label word
       db 3
       db 0fH,0fH,0fH
       db 0  ,0fH,0
       db 0  ,0  ,0
       db 16 dup (0)
tmpshape db 0,5 dup(5 dup (0))
deltax dw 0
deltas dw 0
deltay dw 0

main:
     call  init_game
     sti
     _hlt
again:
     mov byte ptr drop,0
     mov ax,offset tshape
     push ax
     call init_shape
     add sp,2
     call display_score
key_loop:
     cmp byte ptr drop,1
     je again
     call getch
     or ax,ax
     je no_key
     mov di,offset keys
     cld
     mov cx,keys_length
repne scasb
     jne no_key
     dec di
     sub di,offset keys
     mov bx,di
     shl bx,1
     add bx,offset key_table
     call word ptr [bx]
no_key:
     sti
     _hlt
     cmp byte ptr drop,1
     je  again
     dec byte ptr counter
     jnz key_loop
     mov al,level
     sub al,11
     neg al
     shl al,1
     shl al,1
     shl al,1
     add al,7
     mov byte ptr counter,al

     call move_down
     jmp key_loop

drop_shape proc near
     cmp byte ptr drop,1
     je ds_ret
     call move_down
     jmp drop_shape
ds_ret:
     ret
endp
show_cup proc near
       push es
       mov ax,vseg
       mov es,ax
       mov di,cup_offset

       mov si,glass1
       mov cx,ysize+1
       mov ah,20h
       cld
outher_loop:
       push cx
       push di
       mov cx,xsize+4
inner_loop:
       lodsb
       cmp al,44h
       jne cont_n0
       add di,4
       jmp inn_c0
cont_n0:

       and al,0fH
       jnz _loc_0
       call out_space
       jmp  short inn_c0
_loc_0:
       mov  ah,second_char
       xchg ah,al
       stosw
       inc  al
       stosw
       xchg ah,al
inn_c0:
       loop inner_loop
       pop di
       add di,160
       pop cx
       loop outher_loop
       pop es
       ret
endp

out_space proc near
          xor  ax,ax
          stosw
          stosw
          ret
endp
rotate proc near
;si = pointer on rotated shape
       push cs
       pop ds
       mov si,offset tshape
       cld
       xor ah,ah
       lodsb
       mov side,ax
       mov di,offset tmpshape
       stosb
       push di
       mov cx,25
       mov al,0
       rep stosb
       pop di
       add si,side
       dec si

       mov cx,side
loop_2:
       push cx
       push si
       mov cx,side
loop_1:
       lodsb
       dec si
       add si,side
       stosb
       loop loop_1
       pop si
       dec si
       pop cx
       loop loop_2
       xor ax,ax
       mov deltaX,ax
       mov deltaY,ax
       mov deltaS,ax
       mov ax,yd
       push ax
       mov ax,xd
       push ax
       mov ax,offset tmpshape
       push ax
       call check_place
       add sp,6
       or al,al
       jnz dont_rotate
       mov di,offset tshape
       mov si,offset tmpshape
       cld
       mov cx,25
       rep movsb
       call drawing
dont_rotate:
       ret
endp
show_box proc near
;bp+4 == x
;bp+6 == y
       push bp
       mov bp,sp
       push es
       push bx
       push di
       mov ax,vseg
       mov es,ax
       mov di,cup_offset
       mov ax,[bp+6]
       mov bl,0a0H
       mul bl
       add di,ax
       mov ax,[bp+4]
       shl ax,1
       shl ax,1
       add di,ax
       mov ah,current_color
       mov al,second_char
       cld
       stosw
       inc al
       stosw
       pop di
       pop bx
       pop es
       pop bp
       ret
endp
clear_box proc near
       push bp
       mov bp,sp
       push es
       push bx
       push di
       mov ax,vseg
       mov es,ax
       mov di,cup_offset
       mov ax,[bp+6]
       mov bl,0a0H
       mul bl
       add di,ax
       mov ax,[bp+4] ;x coords
       shl ax,1
       shl ax,1
       add di,ax
       mov ah,0
       mov al,' '
       cld
       stosw
       stosw
       pop di
       pop bx
       pop es
       pop bp
       ret
endp
check_place proc near
;bp+4 == pointer to shape
x_place = [bp+6]
y_place = [bp+8]
	push bp
	mov bp,sp
        call xor_put
        or ax,ax
        jz cp_right
        call xor_put
        mov ax,1
cp_right:
	pop bp
        ret
endp
xor_put proc near
;bp+4 == pointer to shape
x_place = [bp+6]
y_place = [bp+8]
      mov si,[bp+4]
      xor dx,dx
      cld
      lodsb
      xor ah,ah
      mov side,ax
      mov bx,y_place
      push bx
      shl bx,1
      add bx,row
      mov bx,[bx]
      add bx,glass1
      mov di,x_place
      mov cx,side
entry:
      push cx
      mov cx,side

xp2:
      lodsb
      or al,al
      jz not_add
      or al,80H
not_add:
      xor [bx+di],al
      mov al,[bx+di]
      and al,0c0H
      cmp al,0c0H
      jne not_override
      inc dx
not_override:
      inc di
      loop xp2

      pop cx
      pop bx
      inc bx
      push bx
      shl bx,1
      add bx,row
      mov bx,[bx]
      add bx,glass1
      mov di,x_place
      loop entry
      pop bx
      mov ax,dx
      ret
endp

redraw proc near
;bp+4 == pointer on shape
x_place = [bp+6]
y_place = [bp+8]
        push bp
        mov bp,sp
        mov si,[bp+4]
        cld
        lodsb
        xor ah,ah
        add ax,deltaS   ;correct size
        mov side,ax
        mov ax,deltaX
        sub x_place,ax   ;correct x coord.
        mov ax,deltaY
        sub y_place,ax   ;correct y coord.
        mov bx,y_place

        shl bx,1
        add bx,row
        mov bx,[bx]
        add bx,glass1
        mov cx,side
        add cx,deltaY
r1:

        push cx
	mov di,x_place
        mov cx,side
r2:
        mov al,[bx+di]
        test al,40H
        jnz background
        test al,80H
        jnz draw_or_stay
        test al,0fH
        jz background    ;must be cleared
        mov ax,y_place
        push ax
        push di
        call clear_box
        add sp,4
        mov byte ptr [bx+di],0  ;cleared
        jmp background
draw_or_stay:
        test al,0fH
        jnz draw
        mov al,current_color
        or al,80H
        xor [bx+di],al
        jmp background
draw:
        mov ax,y_place
        push ax
        push di
        call show_box
        add sp,4
        xor byte ptr [bx+di],80H
background:
        inc di
        loop r2
        inc word ptr y_place
        mov bx,y_place
        shl bx,1
        add bx,row
        mov bx,[bx]
        add bx,glass1
        pop cx
        loop r1
        pop bp
        ret
endp
move_left proc near
       dec word ptr xd
       xor ax,ax
       mov deltaY,ax
       mov deltaX,ax
       inc ax
       mov deltaS,ax
       mov ax,yd
       push ax
       mov ax,xd
       push ax
       mov ax,offset tshape
       push ax
       call check_place
       add sp,6
       or ax,ax
       jnz ml_failure
       call drawing
       jmp ml_ret
ml_failure:
       inc word ptr xd
ml_ret:
       ret
endp
move_right proc near
       inc word ptr xd
       xor ax,ax
       mov deltaY,ax
       inc ax
       mov deltaX,ax
       mov deltaS,ax
       mov ax,yd
       push ax
       mov ax,xd
       push ax
       mov ax,offset tshape
       push ax
       call check_place
       add sp,6
       or ax,ax
       jnz mr_failure
       call drawing
       jmp mr_ret
mr_failure:
       dec word ptr xd
mr_ret:
       ret
endp
move_down proc near
       inc byte ptr yd
       xor ax,ax
       mov deltaX,ax
       mov deltaS,ax
       inc ax
       mov deltaY,ax
       mov ax,yd
       push ax
       mov ax,xd
       push ax
       mov ax,offset tshape
       push ax
       call check_place
       add sp,6
       or ax,ax
       jnz md_failure
       call drawing
       jmp md_ret
md_failure:
       call into_back
       mov byte ptr drop,1
       call scan_line
md_ret:
       ret

endp
dummy_move proc near
       ret
endp
init_shape proc near
; bp+04 tmp shape pointer
           push bp
           mov  bp,sp

           mov  si,offset next_shape
           mov  di,offset current_shape

           call generate_next

           mov  al,current_shape
           xor  ah,ah

           push ax
           cmp byte ptr show_next_shape,1
           je dont_add
           add ax,3
dont_add:
           add score,ax
           pop ax
           shl  ax,1
           mov  bx,ax
           mov  di,[bp+04]
           mov  si,shape_table[bx]
           cld
           lodsb
           stosb
           mov  cl,al
           mul  cl
           mov  cl,al
           xor  ch,ch
      rep  movsb
           mov  si,[bp+04]
           mov  di,si
           cld
           lodsb
           xor  ah,ah
           mov  side,ax
           stosb
           mov  cl,al
           mul  cl
           mov  cx,ax
           mov  ah,current_color
i_s_0:
           lodsb
           and  al,ah
           stosb
           loop i_s_0
           mov  ax,xsize
           shr  ax,1
           mov  cs:xd,ax
           xor  bx,bx
           mov  yd,bx
           push bx
           push ax
           mov  ax,[bp+4]
           push ax
           call check_place
           add  sp,6
           or   ax,ax
           jz   ok
           call check_you_score
ok:
           mov  ax,0a10h
           call show_next
           call drawing
           pop  bp
           ret
endp
into_back proc near
           dec word ptr yd
           mov si,offset tshape
           cld
           lodsb
           xor ah,ah
           mov side,ax
           mov cx,ax
ib1:
           push cx
           mov bx,yd
           shl bx,1
           add bx,row
           mov bx,[bx]
           mov di,xd
           add bx,glass1

           mov cx,side
ib3:
           mov al,[bx+di]
           test al,0fH
           jz ib2
           and al,0fH
	   or al,40H
           mov [bx+di],al
ib2:
           inc di
           loop ib3
           inc yd
           pop cx
           loop ib1
           ret
endp
drawing proc near
     mov ax,yd
     push ax
     mov ax,xd
     push ax
     mov ax,offset tshape
     push ax
     call redraw
     add sp,6
     ret
endp
getch proc near
     mov ah,1
     int 16H
     jz extended
     mov ah,0
     int 16H
     or al,al
     jz extended
     xor ah,ah
     ret
extended:
     xor ax,ax
     ret
endp
exit proc near
     push cs
     pop  ds

     cmp byte ptr cga,1
     je set_old_mode
     mov dx,3c4H
     mov al,3
     out dx,al
     inc dx
     xor al,al
     out dx,al
set_old_mode:
     mov  al,v_mode
     xor  ah,ah
     int  10h
     xor ax,ax
     mov ds,ax
     xor byte ptr ds:[417H],20H
     push cs
     pop  ds
     call save_score
     mov al,0
;*********************************
     out 40H,al
     out 40H,al
;*********************************
     int 20H
endp
scan_line proc near
     mov yd,ysize-1    ;from 14th rows
     mov xd,ysize-1
     mov cx,ysize
sl2:
     push cx
     mov bx,yd
     shl bx,1
     add bx,row
     mov bx,[bx]
     add bx,glass1
     mov cx,ysize
     mov di,2

     mov cx,10
     xor ah,ah
sl1:
     mov al,[bx+di]
     and al,40H
     shr al,1
     shr al,1
     add ah,al
     inc di
     loop sl1
     or ah,ah
     pop cx
     je end_scan
     push cx
     dec word ptr yd
     pop cx
     loop sl2
end_scan:
     mov ax,yd
     inc ax
     jnz sl3
     mov yd,ax
sl3:

     mov cx,ysize
     sub cx,yd
sl5:
     push cx
     mov bx,xd
     shl bx,1
     add bx,row
     mov bx,[bx]
     add bx,glass1
     mov di,2

     mov cx,10
     xor ah,ah
sl4:
     mov al,[bx+di]
     and al,40H
     shr al,1
     shr al,1
     add ah,al
     inc di
     loop sl4
     cmp ah,0a0H
     jne sl6      ;next line will checked
     call video_scroll
     call glass_scroll
     inc word ptr yd
     mov ax,yd
     cmp ax,xd
     jne not_bonus
     add word ptr score,100
not_bonus:
     cmp byte ptr show_next_shape,1
     jne normal_line_score
     add word ptr score,6
     jmp cont_adding
normal_line_score:
     add word ptr score,10
cont_adding:
     dec byte ptr lines
     jns curr_level
     mov byte ptr lines,line
     cmp byte ptr level,10
     je curr_level
     inc byte ptr level
curr_level:
     call display_score
sl7:
     pop cx
     loop sl5
     jmp sl8     ;end of scan
sl6:
     dec word ptr xd
     jmp sl7
sl8:
     ret
endp
display_score proc near

     mov ax,score
     xor dx,dx
     mov si,offset end_of_buffer
     mov cx,10
     call bin_to_asc

     mov al,level
     aam
     add ax,3030H
     mov bx,ax
     mov al,ah
     mov ah,std_atr
     push es
     mov es,word ptr vseg
     mov si,offset level_poster
     mov di,10+160*9
     push di
     push ax
     cld
leve:
     lodsb
     or al,al
     je show_score
     stosw
     jmp leve
show_score:
     pop ax
     stosw
     mov al,bl
     stosw
     pop di
     add di,160
     mov si,offset buffer
scor:
     lodsb
     or al,al
     je end_of_show
     stosw
     jmp scor
end_of_show:
     pop es
     ret
endp
video_scroll proc near
     mov cx,yd
     xchg ch,cl
     add ch,4
     mov cl,80-xsize*2
     shr cl,1
     mov dx,cx
     add dl,xsize*2-1
     mov ax,xd
     sub ax,yd
     add dh,al
     mov ax,701H
     mov bh,0
     int 10H
     ret
endp
glass_scroll proc near
     mov bx,xd
     shl bx,1
     add bx,row
     mov di,[bx]
     add di,glass1
     mov si,di
     dec si
     add di,13
     std
     mov ax,xd
     sub ax,yd
     mov cl,ysize
     mul cl
     mov cx,ax
     rep movsb
     ret
endp
;
;      ax - interval
;      AX - random number in interval
random proc near
       push ds
       push si
       cmp  ax,7
       ja   _4_bits_mask
       mov  ax,07h
       jmp  short _get_time
_4_bits_mask:
       mov  ax,0fh
_get_time:
       push ax
       xor  ax,ax
       mov  ds,ax
       mov  si,046ch
       cld
       lodsw
       pop  si
       and  ax,si
       pop  si
       pop  ds
       ret
random endp

init_game proc near
      call copyright
      call get_display
      cmp al,3
      je ega
      cmp al,7
      jae ega
;cga or monochrome
      sub byte ptr second_char,30H
      mov byte ptr cga,1
      jmp init_video
ega:
      mov ah,1
      cmp al,7
      jb eg1
      mov ah,4
      mov word ptr font_ptr,offset vga_font
      mov word ptr font_length,16
      jmp set_font
eg1:
      mov word ptr font_ptr,offset ega_font
      mov word ptr font_length,14
set_font:
      mov al,ah
      mov ah,11h
      mov bl,1
      int 10H
      mov ax,1201H
      mov bl,30H
      int 10H
      call char_gen

;*******************
;      mov dx,3c4H
;      mov al,1
;      out dx,al
;      inc dx
;      out dx,al
;;******************

init_video:
     mov  ah,0fh
     int  10h
     cmp  al,07
     jne  color
     sub  vseg,800h
color:
     mov ah,0
     int 10h
     mov v_mode,al

      mov dx,3c4H
      mov al,3
      out dx,al
      inc dx
      mov al,101B
      out dx,al

     xor ax,ax
     mov ds,ax
     or byte ptr ds:[417H],20H
     push cs
     pop ds
     call decompress
     mov  ax,1c04h
     mov  bh,xsize
     mov  bl,ysize
     mov  cl,4
     call init_cup
     call load_score
     call show_cup
     call start_msg
     call show_cup

     call display_score
     mov  si,offset next_shape
     mov  di,si
     call generate_next
;*****************************
     mov al,0
     out 40H,al
     mov al,16H
     out 40H,al
;*****************************
     ret
init_game endp

; Call with  DX:AX = signed 32 bit value
;	     CX    = radix
;            SI    = last byte of area to store resulting string
;	             (make sure enough room is available to store
;		      the string in the radix you have selected.)
;
; Destroys AX, BX, CX, DX, and SI.
;
bin_to_asc proc near
	mov	byte ptr [si],'0'
        or      dx,dx
        pushf
        jns     bin1
        not     dx
        not     ax
        add     ax,1
        adc     dx,0
bin1:


        mov     bx,ax
        or      bx,dx
        jz      bin3
        call    divide
        add     bl,'0'
        cmp     bl,'9'
        jle     bin2
        add     bl,'A'-'9'-1
bin2:   mov     [si],bl
        dec     si
        jmp     bin1
bin3:
        popf
        jns     bin4

	mov	byte ptr [si],'-'
bin4:   ret
bin_to_asc endp
;
;
; General purpose 32 bit by 16 bit unsigned divide.
; This must be used instead of the plain machine unsigned divide
; for cases where the quotient may overflow 16 bits (for example,
; dividing 100,000 by 2).  If called with a zero divisor, this
; routine returns the dividend unchanged and gives no warning.
;
; Call with DX:AX = 32 bit dividend
;           CX    = divisor
;
; Returns   DX:AX = quotient
;           BX    = remainder
;	    CX    = divisor (unchanged)
;
divide  proc    near
        jcxz    div1
        push    ax
        mov     ax,dx
        xor     dx,dx
        div     cx
        mov     bx,ax
        pop     ax
        div     cx
        xchg    bx,dx
div1:   ret
divide  endp

char_gen        proc near
        push    es
        push    ds
        push    di
        push    si

        ;--- enable memory for write into plane 2

        mov     dx,03c4h                ; sequencer enable map 2 for write
        mov     al,2
        out     dx,al
        inc     dx
        mov     al,4
        out     dx,al

        dec     dx                      ; sequencer no chaining
        mov     al,4
        out     dx,al
        inc     dx
        mov     al,6
        out     dx,al

        mov     dx,03ceh                ; graphics use data from processor
        mov     al,1
        out     dx,al
        inc     dx
        mov     al,0
        out     dx,al

        dec     dx                      ; graphics read and write modes
        mov     al,5
        out     dx,al
        inc     dx
        mov     al,0
        out     dx,al

        dec     dx                      ; graphics address mapped to a000
        mov     al,6
        out     dx,al
        inc     dx
        mov     al,05h
        out     dx,al

        dec     dx                      ; graphics enable 8 bits per write
        mov     al,8
        out     dx,al
        inc     dx
        mov     al,0ffh
        out     dx,al

        ;--- load the character generator into plane 2

        mov     ax,0a000h               ;point to segment a000
        mov     es,ax
        mov     ax,0e1H                 ;compute offset into char gen plane
        mov     cl,5                    ;as index * bytes_per_char
        shl     ax,cl                   ;which is index * 32
        mov     di,ax                   ;copy offset in char gen plane into di
	add 	di,4000H
        mov     si,font_ptr             ;fetch pointer to new characters
        mov     cx,2                    ;fetch number of characters to copy
fill_plane:
	push 	cx
        mov     cx,font_length
        cld
        rep     movsb                   ;copy the data
	mov	al,0
        mov     cx,32
        sub     cx,font_length
	rep	stosb
	pop 	cx
	loop 	fill_plane

        ;--- restore sequencer and graphics controller

        mov     dx,03c4h                ; enable plane 0 & 1 for write
        mov     al,2
        out     dx,al
        inc     dx
        mov     al,03h
        out     dx,al

        dec     dx                      ; sequencer even/odd & text
        mov     al,4
        out     dx,al
        inc     dx
        mov     al,3
        out     dx,al

        mov     dx,3ceh                 ; graphics read and write modes
        mov     al,5
        out     dx,al
        inc     dx
        mov     al,10h
        out     dx,al
        dec     dx

        xor     ax,ax
        mov     es,ax
        test    byte ptr es:[487H],2
        jnz     wcg_set_b000

        mov     dx,3ceh                 ;map display buffer to b800
        mov     al,6
        out     dx,al
        inc     dx
        mov     al,0eh
        out     dx,al
        jmp     wcg_done
wcg_set_b000:
        mov     dx,3ceh                 ;map display buffer to b000
        mov     al,6
        out     dx,al
        inc     dx
        mov     al,0ah
        out     dx,al

        ;--- clean up and exit
wcg_done:
        pop     si
        pop     di
        pop     ds
        pop     es
        ret
endp
;************************************************************************
; Using BIOS to determine display type, and save type in AX             *
; Exit: AX - Display type                                               *
;       0 => None                                                       *
;       3 => Enhanced Display (or Multi-scan)                           *
;       4 => Color Display                                              *
;       5 => Monochrome Display                                         *
;       7 => VGA Monochrome                                             *
;       8 => VGA Color (or Multi-scan)                                  *
;************************************************************************

get_display proc near
        mov     ax,1a00h                ;first look for vga by trying fn=1a
        int     10h
        cmp     al,1ah                  ;there is no vga if al not 1a
        jne     vga_not_in              ;...so go look for ega
        mov     al,bl                   ;return primary display info
        jmp     type_found

vga_not_in:
        mov     ah,12h                  ;select function 12hex
        mov     bl,10h                  ;       subfunction 10hex
        int     10h                     ;call bios to get display type
        mov     al,5                    ;assume that mono is attached
        or      bh,bh                   ;was display mono (bh = 1)?
        jnz     type_found              ;...yes, we are done
                                        ;...no, must look at switches
        mov     al,3                    ;assume enhanced display
        cmp     cl,9h                   ;is switch 'off on on off'?
        je      type_found              ;...yes, we are done
        cmp     cl,3                    ;is switch 'off off on on'?
        je      type_found              ;...yes, we are done
        mov     al,4                    ;...no, must be color display
type_found:
        xor     ah,ah                   ;clear ah
        ret
endp
;    enter
;        ax - cup offset in to scrreen ah-x,al-y
;        bx - cup size                 bh-x,bl-y
;        cl - max matrix size
;
init_cup proc near
         push ax
         push bx
         push cx

         mov  dx,ax
         xor  ah,ah
         mov  ch,160
         mul  ch

         mov  ch,dh
         shl  ch,1

         add  al,ch
         adc  ah,0
         sub  cl,2
         mov  ch,cl
         shl  ch,1
         sub  al,ch
         sbb  ah,0
         mov  cup_offset,ax  ;save cup offset into screen
         mov  ax,dx
         mov  dx,offset last_code
         mov  di,dx
         add  dl,ch
         add  dl,bh
         adc  dh,0
         mov  glass1,dx      ;save offset to work cup
         xor  ch,ch
         call init_one_line

         mov  dx,cx
         mov  cl,bl
         xor  ch,ch
init_l0:                ; init standart  glass space
         push cx
         mov  cx,dx
         call init_one_line
         pop  cx
         loop init_l0
         mov  cx,dx
init_l1:                ; init last lines
         push cx
         mov  cx,dx
         shl  cx,1
         add  cl,bh
         adc  ch,0
         cld
         mov  al,44h
     rep stosb
         pop  cx
         loop init_l1
         mov  row,di
         mov  ax,0
         mov  cx,dx
         push dx
         shl  cx,1
         add  cl,bh
         adc  ch,0
         mov  dx,cx
         pop  cx
         add  cl,bl
init_l2:
         stosw
         add  ax,dx
         loop init_l2
         mov  scr_ptr,di
         pop  ax
         pop  bx
         pop  cx
         ret
init_cup endp

init_one_line proc near
              push cx
              cld
              mov  al,44h
          rep stosb
              mov  cl,bh
              push ax
              xor  al,al
          rep stosb
              pop  ax
              pop  cx
              push cx
          rep stosb
              pop  cx
              ret
init_one_line endp
decompress proc near
        push es
        mov ax,0501H
        int 10H
        mov ax,vseg
        mov es,ax
        mov di,1
        mov si,offset attrib
        mov cx,644
        call decomp
        mov di,0
        mov cx,797
        mov si,offset char
        call decomp
        mov ax,0500H
        int 10H
        pop es
        ret
endp
decomp proc near
        jcxz end_decomp
        lodsb
        cmp al,80H
        jne one_char
        lodsb           ;counter
        push cx
	xor ah,ah
        mov cx,ax
        lodsb           ;char
aa1:
         stosb
        inc di
        loop aa1
        pop cx
        sub cx,3
        jmp decomp
one_char:
        stosb
        inc di
        dec cx
        jmp decomp
end_decomp:
        ret
endp
;
;  si   - offset to next number
;  di   - offset to current number
;
generate_next proc near

           cld
           movsw
           sub  si,2
           mov  ax,max_shape
           call random
           cmp  ax,max_shape
           jne  init_cnt0
           dec  ax
init_cnt0:
           mov  byte ptr [si],al
           inc  si
           mov  ax,7
           call random
           cmp  ax,0
           jne  init_cnt
           inc  ax
init_cnt:
           xor  al,8h
           mov  byte ptr [si],al
           ret
endp
;
;  ah - x,al - y
;
;
show_next proc near
          push es
          mov  bx,vseg
          mov  es,bx
          mov  bh,ah
          xor  ah,ah
          mov  bl,160
          mul  bl
          shl  bh,1
          add  al,bh  ; ax - pointer to screen
          adc  ah,0
          push ax
          mov  bl,next_shape
          xor  bh,bh
          shl  bx,1
          mov  si,shape_table[bx]
          cld
          lodsb
          xor  ah,ah
          mov  bl,next_color
          mov  cx,ax
          pop  di
          call clear_prev
          cmp byte ptr show_next_shape,1
          je do_it
          jmp sn_ret
do_it:
          mov  dx,cx
out_0:
          push cx
          mov  cx,dx
out_1:
          lodsb
          cmp  al,0
          je   out_std
          mov  ah,bl
          mov  al,second_char
          stosw
          inc  al
          stosw
          jmp  cont_loop
out_std:
          mov  ah,std_atr
          xor  al,al
          stosw
          stosw
cont_loop:
          loop out_1
          mov  cx,dx
          shl  cx,1
          shl  cx,1
          sub  di,cx
          add  di,160
          pop  cx
          loop out_0
sn_ret:
          pop  es
          ret
show_next endp

clear_prev proc near
           push di
           push cx
           push ax
           push dx

           mov  cx,4
           mov  ah,std_atr
           xor  al,al
           mov  dx,cx
clear_0:
           push cx
           mov  cx,dx

           shl  cx,1
      rep  stosw
           mov  cx,dx
           shl  cx,1
           shl  cx,1
           sub  di,cx
           add  di,160
           pop  cx
           loop clear_0

           pop  dx
           pop  ax
           pop  cx
           pop  di
           ret
clear_prev endp
extended_play proc near
         cmp word ptr max_shape,15
         je set_normal
         mov word ptr max_shape,15
         ret
set_normal:
         mov word ptr max_shape,7
         ret
endp
increase_level proc near
     inc byte ptr level
     cmp byte ptr level,10
     jbe ok_level
     dec byte ptr level
ok_level:
     call display_score
     ret
endp
decrease_level proc near
     dec byte ptr level
     jnz ok_dec_level
     inc byte ptr level
ok_dec_level:
     call display_score
     ret
endp
show_hide_next proc near
     xor byte ptr show_next_shape,1
     mov ax,0a10H
     call show_next
yes_it_need:
     ret
endp

;  si - pointer to messages
;
;
out_msg          proc near
                 push es
                 mov  al,w_y0
                 mov  ah,0
                 mov  cl,160
                 mul  cl
                 mov  cl,w_x0
                 xor  ch,ch
                 shl  cl,1
                 add  ax,cx

                 push ax
                 mov  al,cur_y
                 xor  ah,ah
                 mov  cl,160
                 mul  cl
                 mov  cl,cur_x
                 shl  cx,1
                 add  ax,cx
                 pop  di

                 add  di,ax
                 mov  cl,w_lx
                 xor  ch,ch
                 sub  cl,cur_x
                 dec  cx
                 cld
                 mov  es,word ptr vseg
out_loop:
                 lodsb
                 cmp  al,0
                 je   all
                 mov  ah,std_atr
                 stosw
                 loop out_loop
all:
                 inc  byte ptr cur_y
                 mov  byte ptr cur_x,1

                 pop  es
                 ret
out_msg          endp
;
;  ah,al - x0,y0
;  bh,bl - lx,ly
;
open_window     proc near
                mov  es,word ptr vseg
                mov  w_x0,ah
                mov  w_y0,al
                mov  w_lx,bh
                mov  w_ly,bl
                mov  cur_x,1
                mov  cur_y,1
                push ax
                xor  ah,ah
                mov  cl,160
                mul  cl
                pop  cx
                xchg ch,cl
                xor  ch,ch
                shl  cl,1
                add  ax,cx     ; offset to window start
                mov  di,ax
                mov  si,offset window_border
                mov  dl,bl
                mov  cl,bh
                xor  dh,dh
                xor  ch,ch
                mov  bx,cx
                cld

                call out_up
                mov  cx,dx
                sub  cx,2

                push bp
                mov  bp,sp
                lodsw
                push  ax  ;[bp-2]
                lodsw
                push  ax  ;[bp-4]
                lodsw
                push  ax  ;[bp-6]

lll:
                push  cx
                mov   ax,[bp-2]
                stosw
                mov   cx,bx
                sub   cx,2
                mov   ax,[bp-4]
           rep  stosw
                mov   ax,[bp-6]
                stosw
                pop   cx
                add   di,160
                sub   di,bx
                sub   di,bx
                loop lll

                add  sp,6
                pop  bp
                call out_up
                push cs
                pop  es
                ret
open_window     endp
out_up          proc
                mov  cx,bx
                sub  cx,2
                lodsw
                stosw
                lodsw
                rep  stosw
                lodsw
                stosw
                add  di,160
                sub  di,bx
                sub  di,bx
                ret
out_up          endp
line_editor	proc
        mov     bl,std_atr
	mov	dx,start_Y * 256 + start_X
	mov	di,offset string
set_edit_position:
	mov	ah,2
	inc	dl
	int	10H
ask_next_cha:
	xor	ax,ax
	int	16H
	or	al,al
	jne	no_control_cha
	mov	al,ah
	jmp	control_cha
no_control_cha:
	cmp	al,0DH
	jne	no_enter
	mov	dx,(start_Y + 1) * 256 + start_X
	mov	si,offset string
        jmp     short for_return
no_enter:
	cmp	al,1BH
	jne	no_escape
for_return:
        xor      bx,bx
        mov      dh,25
        mov      dl,0
        mov      ah,02h
        int      10h
	ret
no_escape:
	cmp	al,8
	jne	no_backspace
	mov	ax,word ptr cursor
	or	ax,ax
	je	ask_next_cha
	cmp	ax,word ptr length_of_string
	jne	move_other_cha
	mov	ah,2
	mov	cx,1
	dec	dl
	int	10H
	mov	ax,920H
	int	10H
	dec	word ptr cursor
	dec	word ptr length_of_string
	dec	di
	mov	byte ptr [di],0
	jmp	ask_next_cha
move_other_cha:
	mov	cx,word ptr length_of_string
	sub	cx,word ptr cursor
	mov	si,di
	dec	di
	push	di
	rep	movsb
	mov	word ptr [di],20h
	pop	di
	mov	si,di
	dec	dl
	dec	dl
	call	output_string
	dec	length_of_string
	dec	cursor
	mov	dl,start_X
	add	dl,byte ptr cursor
	jmp	set_edit_position
no_backspace:
	mov	si,word ptr cursor
	cmp	si,word ptr length_of_string
	je	no_insert_cha
	inc	si
	sub	si,size_of_string
	je	no_insert_cha
	mov	cx,word ptr length_of_string
	sub	cx,word ptr cursor
	neg	si
	cmp	si,cx
	jnb	move_all_cha
	mov	cx,si
move_all_cha:
	add	di,cx
	mov	byte ptr [di+1],0
	mov	si,di
	dec	si
	std
	rep	movsb
	cld
	mov	byte ptr [di],al
	mov	si,di
	dec	dl
	call	output_string
	mov	dl,start_X
	inc	word ptr cursor
	inc	di
	add	dl,byte ptr cursor
	mov	ax,word ptr length_of_string
	cmp	ax,size_of_string
	je	to_edit_position
	inc	word ptr length_of_string
to_edit_position:
	jmp	set_edit_position
no_insert_cha:
	mov	byte ptr [di],al
	dec	dl
	mov	si,size_of_string
	cmp	si,word ptr length_of_string
	je	whole_length
	inc	word ptr length_of_string
whole_length:
	cmp	si,word ptr length_of_string
	jbe	last_cha_in_string
	inc	byte ptr cursor
	inc	di
	inc	dl
last_cha_in_string:
	mov	ah,9
	mov	cx,1
	int	10H
	jmp	set_edit_position
control_cha:
	cmp	al,4BH
	jne	no_left
	cmp	word ptr cursor,0
	je	ask_next_character
	dec	word ptr cursor
	dec	di
	dec	dl
	dec	dl
	jmp	set_edit_position
no_left:
	cmp	al,4DH
	jne	no_right
	mov	ax,word ptr cursor
	cmp	ax,word ptr length_of_string
	je	ask_next_character
	inc	ax
	cmp	ax,size_of_string
	jnb	ask_next_character
	inc	word ptr cursor
	inc	di
	jmp	set_edit_position
no_right:
	cmp	al,47H
	jne	no_home
	mov	di,offset string
	mov	word ptr cursor,0
	mov	dl,start_X
	jmp	set_edit_position
no_home:
	cmp	al,4FH
	jne	no_end
	mov	di,word ptr length_of_string
	cmp	di,size_of_string
	jne	no_to_last_cha_in_string
	dec	di
no_to_last_cha_in_string:
	mov	word ptr cursor,di
	mov	dl,start_X
	add	dx,di
	add	di,offset string
	jmp	set_edit_position
ask_next_character:
	jmp	ask_next_cha
no_end:
	cmp	al,53H
	jne	ask_next_character
	mov	cx,word ptr cursor
	dec	cx
	cmp	cx,size_of_string
	jne	no_last_cha_deleted
	mov	word ptr [di],20H
	jmp	last_cha_deleted
no_last_cha_deleted:
	mov	cx,word ptr length_of_string
	sub	cx,word ptr cursor
	je	ask_next_character
	push	di
	lea	si,[di+1]
	dec	cx
	rep	movsb
	mov	word ptr [di],20H
	pop	di
last_cha_deleted:
	mov	si,di
	dec	dl
	call	output_string
	dec	length_of_string
	mov	dl,start_X
	add	dl,byte ptr cursor
	jmp	set_edit_position
line_editor	endp

output_string	proc
	mov	cx,1
output_next_cha_of_string:
	mov	ah,2
	inc	dl
	int	10H
	lodsb
	or	al,al
	je	all_string_cha
	mov	ah,9
	int	10H
	jmp	output_next_cha_of_string
all_string_cha:
	ret
output_string	endp
start_msg proc near
          mov  ax,1e04h
          mov  bh,xsize
          shl  bh,1
          mov  bl,19
          call open_window
          inc  byte ptr cur_y
          mov  si,offset msg0
          mov  cx,4
cc_ll_0:
          push cx
          call out_msg
          pop  cx
          loop cc_ll_0
          inc  byte ptr cur_y
          inc  byte ptr cur_y
          mov  cx,9
cc_ll_1:

          push cx
          call out_msg
          pop  cx
          loop cc_ll_1

get_next:
          call getch
          or ax,ax
          je get_next
          cmp al,1bH
          jne sm1
          call exit
sm1:
          cmp al,20H
          jne sm2
          ret
sm2:
          cmp al,'0'
          jb get_next
          cmp al,'9'
          ja get_next
          sub  al,30h
          inc  al
          mov  level,al
          ret
start_msg endp
restart_game proc near
             call start_msg
             mov  ax,1c04h
             mov  bh,xsize
             mov  bl,ysize
             mov  cl,4
             call init_cup
             call show_cup
             mov  score,0
             mov  al,line
             mov  lines,al
             cld
             mov  al,20h
             mov  di,offset for_space
             mov  cx,6
         rep stosb
             mov  di,offset for_lev
             mov  cx,4
         rep stosb
             call display_score
             mov  si,offset next_shape
             mov  di,si
             call generate_next
             mov  ax,0a10h
             call show_next
             pop  ax
             jmp  again
             ret
restart_game endp
pause        proc near
             mov  ax,1e04h
             mov  bh,xsize
             shl  bh,1
             mov  bl,7
             call open_window
             inc  byte ptr cur_y
             mov  cx,3
             mov  si,offset msg1
pause_l:
             push cx
             call out_msg
             pop  cx
             loop pause_l
get_next_p:
             call getch
             or ax,ax
             je get_next_p
             cmp  al,1bh
             jne  get_next_p
             call show_cup
             ret
pause        endp
check_you_score proc near
                call display_score
                call check_score_table
                or   ax,ax
                jnz  not_records
                push dx
                call ask_name
                pop  dx
                call sort_score
                call out_score
not_records:
                pop  ax
                call restart_game
check_you_score endp
;
;    dl - number moving line
;
;
;
sort_score    proc near
              xor  dh,dh
              cmp  dl,9
              je   dont_move
              mov  di,scr_ptr
              add  di,scr_end
              mov  si,di
              sub  si,11
              mov  cx,10
              sub  cl,dl
              dec  cl
              mov  ax,11
              mul  cl
              xchg ax,cx
              inc  cx
              std
         rep  movsb      ;move score table
dont_move:
              mov  ax,11
              mul  dl
              add  ax,scr_ptr
              push ax
              mov  di,ax
              mov  al,0h
              cld
              mov  cx,11 ;clear score place
         rep  stosb
              pop  di
              mov  ax,score
              stosw     ;move point in score table
              mov  al,level
              stosb     ;move level in score table
              mov  si,offset string
              mov  cx,8
move_name:
              lodsb
              or   al,al
              jz   all_moving
              stosb
              loop move_name
all_moving:
              ret
endp

ask_name        proc near
                mov  ax,1e04h
                mov  bh,xsize
                shl  bh,1
                mov  bl,7
                call open_window
                inc  byte ptr cur_y
                mov  si,offset msg2
                call out_msg
                mov  di,offset cursor
                mov  cx,size_of_string+5
                xor  al,al
                cld
            rep stosb
                call line_editor
                mov si,offset string
                mov cx,size_of_string
                mov di,si
                cld
delete_zero:
                lodsb
                or al,al
                jnz not_clear
                mov al,20H
not_clear:
                stosb
                loop delete_zero
                ret
endp
;
load_score      proc near
                push cs
                pop  es
                mov  bx,word ptr es:[2ch]
                mov  es,bx
                xor  di,di
                mov  cx,32000
                mov  al,1
                mov  si,offset extension
                cld
          repne scasb
                je   found_name
ab:
                call exit
found_name:
                scasb
                mov  dx,di  ; pointer to file name
                mov  al,0
          repne scasb
                jne  ab
                mov  cx,4
                sub  di,4
            rep movsb        ; creat new extension
                push es
                pop  ds
                mov  ax,4301h  ;set file mode
                mov  cx,20h
                int  21h
                jnc   file_found
                jmp   file_not_found
file_found:
                mov  ax,3d12h
                int  21h
                jc   ab
cc_open:
                push cs
                pop  bx
                mov  es,bx
                mov  ds,bx
                push ax
                mov  di,scr_ptr
                push cs
                pop  es
                mov  cx,110
                xor  al,al
            rep stosb
                pop  ax
                mov  bx,ax
                mov  hndl,ax
                mov  dx,scr_ptr
                mov  cx,110
                mov  ah,3fh
                int  21h
                ret
file_not_found:
                mov  cx,20h
                mov  ah,3ch
                int  21h
                jc   ab
                jmp  cc_open
load_score      endp
;
save_score      proc near
                mov  bx,hndl
                xor  cx,cx
                xor  dx,dx
                mov  ax,4200h
                int  21h
                mov  cx,110
                mov  dx,scr_ptr
                mov  ah,40h
                int  21h
                mov  ah,3eh
                int  21h
                ret
save_score      endp
;
out_score       proc
                mov  ax,1e04h
                mov  bh,xsize
                shl  bh,1
                mov  bl,15
                call open_window
                inc  byte ptr cur_y
                mov  si,offset msg3
                call out_msg
                inc  byte ptr cur_y
                xor  bl,bl

                mov  cx,10
out_loop_0:
                push cx
                mov  di,offset msgtmp
                push di
                mov  al,20h
                cld
                mov  cx,12h
            rep stosb
                pop  di
                mov  si,scr_ptr
                mov  al,bl
                xor  ah,ah
                mov  bh,11
                mul  bh
                add  si,ax
                mov  bp,si
                add  si,3
                mov  cx,8
fill_name:
                lodsb
                cmp  al,0
                je   cont_fill
                stosb
                loop fill_name
cont_fill:
                cmp  cx,8
                jne  dd_cont
                jmp  last_line
dd_cont:
                mov  si,bp
                lodsw
                mov  bp,si
                mov  si,offset spctmp
                dec  si
                mov  cx,10
                xor  dx,dx
                push bx
                call bin_to_asc
                pop  bx
                mov  si,bp
                lodsb
                mov  si,offset end_sc
                mov  cx,10
                xor  dx,dx
                xor  ah,ah
                dec  si
                dec  si
                push bx
                call bin_to_asc
                pop  bx
                mov  si,offset msgtmp
                call out_msg
                inc  bl
                pop  cx
                loop out_loop_0
                jmp  short not_last
last_line:
                pop  ax
not_last:
                xor  ah,ah
                int  16h
                ret
out_score       endp

check_score_table proc near
                  mov  cx,10
                  xor  dl,dl
                  mov  dh,11
                  mov  bx,score
                  mov  si,scr_ptr
                  cld
check_0:
                  lodsw
                  cmp ax,bx
                  jl  found_line
                  inc dl
                  sub si,2
                  mov  al,dh
                  xor  ah,ah
                  add  si,ax
                  loop check_0

                  mov  ax,1
                  ret
found_line:
                  xor  ax,ax
                  ret
check_score_table endp
copyright proc near
        mov si,offset copy_r
        xor ah,ah
        cld
        mov cx,copy_size
scan_summ:
        lodsb
        add ah,al
        loop scan_summ
        mov di,offset attrib
        mov si,di
        mov cx,644+797
xor_loop:
        lodsb
        xor al,ah
        stosb
        loop xor_loop
        ret
endp
attrib label word
       org 644+offset attrib
char label word
       org 797+offset char
last_code label byte
end start
