      call get_display
      cmp al,3
      je ega
      cmp al,7
      jae ega

ega:
      mov ah,1
      cmp al,8
      jne eg1_
      mov ah,4
eg1_: 
      mov al,ah
      mov ah,11h
      mov bl,1
      int 10H

      call char_gen
      mov ax,3
      int 10H

      mov dx,3c4H
      mov al,3
      out dx,al
      inc dx
      mov al,101B
      out dx,al




char_gen        proc near
        push    es
        push    ds
        push    di
        push    si

        ;--- enable memory for write into plane 2

        mov     dx,03c4h                ; sequencer enable map 2 for write
        mov     al,2
        out     dx,al
        inc     dx
        mov     al,4
        out     dx,al

        dec     dx                      ; sequencer no chaining
        mov     al,4
        out     dx,al
        inc     dx
        mov     al,6
        out     dx,al

        mov     dx,03ceh                ; graphics use data from processor
        mov     al,1
        out     dx,al
        inc     dx
        mov     al,0
        out     dx,al

        dec     dx                      ; graphics read and write modes
        mov     al,5
        out     dx,al
        inc     dx
        mov     al,0
        out     dx,al

        dec     dx                      ; graphics address mapped to a000
        mov     al,6
        out     dx,al
        inc     dx
        mov     al,05h
        out     dx,al

        dec     dx                      ; graphics enable 8 bits per write
        mov     al,8
        out     dx,al
        inc     dx
        mov     al,0ffh
        out     dx,al

        ;--- load the character generator into plane 2

        mov     ax,0a000h               ;point to segment a000
        mov     es,ax
        mov     ax,0                    ;compute offset into char gen plane
        mov     cl,5                    ;as index * bytes_per_char
        shl     ax,cl                   ;which is index * 32
        mov     di,ax                   ;copy offset in char gen plane into di
	add 	di,4000H
        mov     si,ptr_cg               ;fetch pointer to new characters
        mov     cx,count                ;fetch number of characters to copy
fill_plane:
	push 	cx
	mov 	cx,14
        cld
        rep     movsb                   ;copy the data
	mov	al,0
	mov 	cx,18
	rep	stosb
	pop 	cx
	loop 	fill_plane

        ;--- restore sequencer and graphics controller

        mov     dx,03c4h                ; enable plane 0 & 1 for write
        mov     al,2
        out     dx,al
        inc     dx
        mov     al,03h
        out     dx,al

        dec     dx                      ; sequencer even/odd & text
        mov     al,4
        out     dx,al
        inc     dx
        mov     al,3
        out     dx,al

        mov     dx,3ceh                 ; graphics read and write modes
        mov     al,5
        out     dx,al
        inc     dx
        mov     al,10h
        out     dx,al
        dec     dx

        xor     ax,ax
        mov     es,ax
        test    byte ptr es:[487H],2
        jnz     wcg_set_b000

        mov     dx,3ceh                 ;map display buffer to b800
        mov     al,6
        out     dx,al
        inc     dx
        mov     al,0eh
        out     dx,al
        jmp     wcg_done
wcg_set_b000:
        mov     dx,3ceh                 ;map display buffer to b000
        mov     al,6
        out     dx,al
        inc     dx
        mov     al,0ah
        out     dx,al

        ;--- clean up and exit
wcg_done:
        pop     si
        pop     di
        pop     ds
        pop     es
        ret
endp

get_display proc near
        mov     ax,1a00h                ;first look for vga by trying fn=1a
        int     10h
        cmp     al,1ah                  ;there is no vga if al not 1a
        jne     vga_not_in              ;...so go look for ega
        mov     al,bl                   ;return primary display info
        jmp     type_found

vga_not_in:
        mov     ah,12h                  ;select function 12hex
        mov     bl,10h                  ;       subfunction 10hex
        int     10h                     ;call bios to get display type
        mov     al,5                    ;assume that mono is attached
        or      bh,bh                   ;was display mono (bh = 1)?
        jnz     type_found              ;...yes, we are done
                                        ;...no, must look at switches
        mov     al,3                    ;assume enhanced display
        cmp     cl,9h                   ;is switch 'off on on off'?
        je      type_found              ;...yes, we are done
        cmp     cl,3                    ;is switch 'off off on on'?
        je      type_found              ;...yes, we are done
        mov     al,4                    ;...no, must be color display
type_found:
        xor     ah,ah                   ;clear ah
        ret
 endp







