
;
; Convert 32 bit binary value to ASCII string.
; Copyright (C) 1985 Ray Duncan
;
; Call with  DX:AX = signed 32 bit value
;	     CX    = radix
;            SI    = last byte of area to store resulting string
;	             (make sure enough room is available to store
;		      the string in the radix you have selected.)
;
; Destroys AX, BX, CX, DX, and SI.
;
bin_to_asc proc	near		;convert DX:AX to ASCII.
				;force storage of at least 1 digit.
	mov	byte ptr [si],'0' 
	or	dx,dx		;test sign of 32 bit value,
	pushf			;and save sign on stack.
	jns	bin1		;jump if it was positive.
	not	dx		;it was negative, take 2's complement
	not	ax		;of the value. 
	add	ax,1
	adc	dx,0
bin1:				;divide the 32 bit value by the radix 
				;to extract the next digit for the
				;forming string.
	mov	bx,ax		;is the value zero yet?
	or	bx,dx
	jz	bin3		;yes, we are done converting.
	call	divide		;no, divide by radix.
	add	bl,'0'		;convert the remainder to an ASCII digit.
	cmp	bl,'9'		;we might be converting to hex ASCII,
	jle	bin2		;jump if in range 0-9,
	add	bl,'A'-'9'-1	;correct it if in range A-F.
bin2:	mov	[si],bl		;store this character into string.
	dec	si		;back up through string,
	jmp	bin1		;and do it again.
bin3:				;restore sign flag,
	popf			;was original value negative?
	jns	bin4		;no, jump
				;yes,store sign into output string.
	mov	byte ptr [si],'-'
bin4:	ret			;back to caller.
bin_to_asc endp
;
;
; General purpose 32 bit by 16 bit unsigned divide.
; This must be used instead of the plain machine unsigned divide
; for cases where the quotient may overflow 16 bits (for example,
; dividing 100,000 by 2).  If called with a zero divisor, this
; routine returns the dividend unchanged and gives no warning.
;
; Call with DX:AX = 32 bit dividend
;           CX    = divisor
;
; Returns   DX:AX = quotient
;           BX    = remainder
;	    CX    = divisor (unchanged)
;
divide	proc	near		; Divide DX:AX by CX
	jcxz	div1		; exit if divide by zero
	push	ax		; 0:dividend_upper/divisor
	mov	ax,dx
	xor	dx,dx
	div	cx
	mov	bx,ax		; BX = quotient1
	pop	ax		; remainder1:dividend_lower/divisor
	div	cx
	xchg	bx,dx		; DX:AX = quotient1:quotient2
div1:	ret			; BX = remainder2
divide	endp
;
