CLS
LOCATE 25,1
PRINT "MAD MAD MAD MAZES!   Copyright 1989 Frederick Volking   Version: 1.0";

LOCATE 13,20 : PRINT "         <C> = Color Graphics Adapter (CGA)";
LOCATE 14,20 : PRINT "         <E> = Enhanced Graphics Adapter (EGA)";
LOCATE 15,20 : PRINT "         <V> = Video Graphics Adapter (VGA)";
LOCATE 11,20 : PRINT "Which Graphics Adapter? : ";
DO : GMode$ = INKEY$ : LOOP WHILE (GMODE$ = "")
IF GMode$ = "" THEN END
GMode$ = UCASE$(GMode$)
IF INSTR("CEV",Gmode$) = 0 THEN END
IF GMode$ = "C" THEN GMode% = 2
IF GMode$ = "E" THEN GMode% = 8
IF GMode$ = "V" THEN GMode% = 12
'================================== Initialize Hardware & Random Seed Generator
Screen GMode%
ScoreFile$ = "MAZESCOR.DAT"
DEFINT A-Z
K% = VAL(MID$(DATE$,4,2))+VAL(RIGHT$(TIME$,2))+VAL(LEFT$(TIME$,2))+VAL(MID$(TIME$,4,2))
Randomize K%
'============================================ Define Static Substitution Macros
%FALSE  = 0
%TRUE   = 1
%UP     = 1
%LEFT   = 2
%DOWN   = 3
%RIGHT  = 4

%OUP    = 1
%ORIGHT = 2
%ODOWN  = 4
%OLEFT  = 8
%TUP    = 16
%TRIGHT = 32
%TDOWN  = 64
%TLEFT  = 128
'====================================================== Define Default settings
IF GMode% = 2 THEN
   Xaxis% = 191 : Yaxis% = 639
END IF
IF GMode% = 8 THEN
   Xaxis% = 191 : Yaxis% = 639 : PcolorON% = 3
END IF
IF GMode% = 12 THEN
   Xaxis% = 380 : Yaxis% = 639 : PcolorON% = 3
END IF
DIM STATIC HighTimes&(10),Whose(10)
IF GMode% = 2 THEN
   TokenColor% = 1
   CrumbColor% = 1
   WallColor% = 1
ELSE
   TokenColor% = 12
   CrumbColor% = 11
   WallColor%  = 7
   GOSUB SetUpColors
END IF
Cmd$ = UCASE$(COMMAND$)
CountDown% = %TRUE
'===================================================== Main Program Loop Begins
Cycle% = 1
WHILE (Cycle% < 11)
   CLS
   SELECT CASE Cycle%
      CASE =  1 : CellSize% = 30
      CASE =  2 : CellSize% = 25
      CASE =  3 : CellSize% = 20
      CASE =  4 : CellSize% = 15
      CASE =  5 : CellSize% = 12
      CASE =  6 : CellSize% = 9
      CASE =  7 : CellSize% = 7
      CASE =  8 : CellSize% = 5
      CASE =  9 : CellSize% = 3
      CASE = 10 : CellSize% = 2
   END SELECT
   GOSUB PrintLine25
   '=========================================== Calculate global default values
   CellsTall%   = ( FIX(Xaxis% / CellSize%))
   CellsWide%   = ( FIX((Yaxis% / CellSize%) / 2 ))
   FrameBottom% = (CellsTall% * CellSize%)
   FrameRight%  = (CellsWide% * (CellSize% * 2))
   WallsToDraw% = ((CellsTall%+1) * (CellsWide%+1)) - ((CellsTall%+CellsWide%) * 2 )
   '============================================== Dimension appropriate arrays
   DIM DYNAMIC Walls%(CellsTall%,CellsWide%)
   '=================================================== Initialize array values
   FOR C% = 0 to CellsWide%
      Walls%(0,C%) = 1
      Walls%(CellsTall%,C%) = 1
   NEXT
   FOR C% = 0 to CellsTall%
      Walls%(C%,0) = 1
      Walls%(C%,CellsWide%) = 1
   NEXT
   '================================================================= Draw maze
   GOSUB DrawMaze
   ERASE Walls%
   DIM DYNAMIC Pfield%(CellsTall%+1,CellsWide%+1)
   '============================================================ One Maze Cycle
   DoorOut% = (FnR%(CellsTall%-2))+1
   LINE (0,DoorOut%*CellSize%) - (0,(DoorOut%*CellSize%)+(CellSize%)), 0
   OriginX% = (FnR%(CellsTall%-2))+1
   CurX% = OriginX%
   CurY% = CellsWide%
   LastCurX% = CurX%
   LastCurY% = CurY%
   IF Cmd$ = "DEMO"  THEN
      KeepGoing% = %FALSE
      AutoSolve% = %TRUE
   ELSE
      KeepGoing% = %TRUE
      AutoSolve% = %FALSE
   END IF
   INCR DoorOut%
   MazeIsDrawn% = %TRUE
   BeginTimer! = TIMER
   WHILE (KeepGoing%)
      IF PField%(CurX%,CurY%) = 1 THEN
         CALL DrawPiece(LastCurX%,LastCurY%,0,0)
         PField%(LastCurX%,LastCurY%) = 0
      ELSE
         CALL DrawPiece(LastCurX%,LastCurY%,TokenColor%,1)
      END IF
      CALL DrawPiece(CurX%,CurY%,TokenColor%,0)
      PField%(CurX%,CurY%) = 1
      LastCurX% = CurX%
      LastCurY% = CurY%
      DO
         K$ = INKEY$
         GOSUB ShowElapsed
      LOOP WHILE (K$ = "")
      IF (LEN(K$) = 2) THEN K% = 1000 ELSE K% = 0
      K% = K% + ASC(RIGHT$(K$,1))
      Xnext% = CurX%
      Ynext% = CurY%
      SELECT CASE K%
         CASE 1072 : DECR Xnext%           ' Up
         CASE 1077 : INCR Ynext%           ' Right
         CASE 1080 : INCR Xnext%           ' Down
         CASE 1075 : DECR Ynext%           ' Left
         CASE   27 : GOSUB ExitRequested   ' ESC
      END SELECT
      IF ((Xnext% = DoorOut%) AND (Ynext% = 0)) THEN
         KeepGoing% = %FALSE
      ELSE
         IF FnBlocked%(CurX%,CurY%,XNext%,Ynext%) THEN
            XNext% = CurX%
            YNext% = CurY%
         END IF
      END IF
      CurX% = Xnext%
      CurY% = Ynext%
   WEND
   MazeIsDrawn% = %FALSE
   IF AutoSolve% THEN
      BeginTimer! = TIMER
      GOSUB YouDoIt
      GOSUB ShowTotalMazeTime
      IF Cmd$ = "DEMO" THEN
         W% = FnStartTimer%(10)
         WHILE FnSecondsElapsed%(25,70) > 0
            IF INKEY$ > "" THEN GOSUB ExitRequested
         WEND
      ELSE
         LOCATE 25,1 : PRINT SPACE$(79);
         LOCATE 25,21 : PRINT "Press <ANY KEY> to return to DOS";
         WHILE INKEY$ = "" : WEND
         CLS
         END
     END IF
   ELSE
      GOSUB ShowTotalMazeTime
   END IF
   ERASE Pfield%
   INCR Cycle%
   IF Cmd$ = "DEMO" THEN
      IF Cycle% = 11 THEN Cycle% = 1
   END IF
WEND
LOCATE 25,1 : PRINT SPACE$(79);
LOCATE 25,21 : PRINT "Press <ANY KEY> to return to DOS";
WHILE INKEY$ = "" : WEND
END 'of main program loop
'==============================================================================
'===================== Functions & Subroutines Begin ==========================
'==============================================================================
'================================================ Define Random Number Function
DEF FnR%(X%) = INT(RND * X%) + 1
'=================================================== Automatically solve a maze
YouDoIt:
   '========================================= Erase old path & return to origin
   KeepBacking% = %True
   WHILE KeepBacking%
      PField%(CurX%,CurY%) = 0
      CALL DrawPiece(CurX%,CurY%,0,0)
      IF ((CurX% = OriginX%) AND (CurY% = CellsWide%)) THEN
         KeepBacking% = %FALSE
      ELSE
         Trim% = 0
         IF FnBlocked%(CurX%,CurY%,CurX%-1,CurY%  ) = %FALSE THEN _
            IF (PField%(CurX%-1,CurY%  ) = 1) THEN Trim% = %UP
         IF FnBlocked%(CurX%,CurY%,CurX%  ,CurY%-1) = %FALSE THEN _
            IF (PField%(CurX%  ,CurY%-1) = 1) THEN Trim% = %LEFT
         IF FnBlocked%(CurX%,CurY%,CurX%+1,CurY%  ) = %FALSE THEN _
            IF (PField%(CurX%+1,CurY%  ) = 1) THEN Trim% = %DOWN
         IF FnBlocked%(CurX%,CurY%,CurX%  ,CurY%+1) = %FALSE THEN _
            IF (PField%(CurX%  ,CurY%+1) = 1) THEN Trim% = %RIGHT
         SELECT CASE Trim%
            CASE %UP    : DECR CurX%
            CASE %LEFT  : DECR CurY%
            CASE %DOWN  : INCR CurX%
            CASE %RIGHT : INCR CurY%
         END SELECT
      END IF
   WEND
   '================================================================ Solve Maze
   AllTested% = %TUP + %TRIGHT + %TDOWN + %TLEFT
   PField%(CurX%,CurY%) = %ORIGHT + %TRIGHT
   NotFoundYet% = %TRUE
   MazeIsDrawn% = %FALSE
   IF Cmd$ = "DEMO" THEN
      CALL DrawPiece(CurX%,CurY%,TokenColor%,0)
      W% = FnStartTimer%(10)
      WHILE FnSecondsElapsed%(25,70) > 0
         IF INKEY$ > "" THEN GOSUB ExitRequested
      WEND
   END IF
   DO
      IF INKEY$ > "" THEN GOSUB ExitRequested
      GOSUB ShowElapsed
      IF ((PField%(LastCurX%,LastCurY%) AND AllTested) = AllTested) THEN _
         CALL DrawPiece(LastCurX%,LastCurY%,0,0) _
      ELSE CALL DrawPiece(LastCurX%,LastCurY%,TokenColor%,1)
      CALL DrawPiece(CurX%,CurY%,TokenColor%,0)
      LastCurX% = CurX%
      LastCurY% = CurY%

      IF ((PField%(CurX%,CurY%) AND %TUP) <> %TUP) THEN
         IF FnBlocked%(CurX%,CurY%,CurX%-1,CurY%) = %TRUE THEN
            PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TUP
         ELSE
            IF ((PField%(CurX%-1,CurY%) AND AllTested%) = AllTested%) THEN _
               PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TUP
         END IF
      END IF

      IF ((PField%(CurX%,CurY%) AND %TDOWN) <> %TDOWN) THEN
         IF FnBlocked%(CurX%,CurY%,CurX%+1,CurY%) = %TRUE THEN
            PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TDOWN
         ELSE
            IF ((PField%(CurX%+1,CurY%) AND AllTested%) = AllTested%) THEN _
               PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TDOWN
         END IF
      END IF

      IF ((PField%(CurX%,CurY%) AND %TLEFT) <> %TLEFT) THEN
         IF FnBlocked%(CurX%,CurY%,CurX%,CurY%-1) = %TRUE THEN
            PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TLEFT
         ELSE
            IF ((PField%(CurX%,CurY%-1) AND AllTested%) = AllTested%) THEN _
               PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TLEFT
         END IF
      END IF

      IF ((PField%(CurX%,CurY%) AND %TRIGHT) <> %TRIGHT) THEN
         IF FnBlocked%(CurX%,CurY%,CurX%,CurY%+1) = %TRUE THEN
            PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TRIGHT
         ELSE
            IF ((PField%(CurX%,CurY%+1) AND AllTested%) = AllTested%) THEN _
               PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TRIGHT
         END IF
      END IF

      IF ((PField%(CurX%,CurY%) AND AllTested) = AllTested) THEN
         IF ((PField%(CurX%,CurY%) AND %ORIGHT) = %ORIGHT) THEN
            INCR CurY%
            PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TLEFT
         ELSE
            IF ((PField%(CurX%,CurY%) AND %OLEFT) = %OLEFT) THEN
               DECR CurY%
               PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TRIGHT
            ELSE
               IF ((PField%(CurX%,CurY%) AND %OUP) = %OUP) THEN
                  DECR CurX%
                  PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TDOWN
               ELSE
                  INCR CurX%
                  PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TUP
               END IF
            END IF
         END IF
      ELSE
         IF ((PField%(CurX%,CurY%) AND %TRIGHT) <> %TRIGHT) THEN
            INCR CurY%
            PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TLEFT + %OLEFT
         ELSE
            IF ((PField%(CurX%,CurY%) AND %TLEFT) <> %TLEFT) THEN
               DECR CurY%
               PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TRIGHT + %ORIGHT
            ELSE
               IF ((PField%(CurX%,CurY%) AND %TUP) <> %TUP) THEN
                  DECR CurX%
                  PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TDOWN + %ODOWN
               ELSE
                  INCR CurX%
                  PField%(CurX%,CurY%) = PField%(CurX%,CurY%) + %TUP + %OUP
               END IF
            END IF
         END IF
      END IF
      IF ((CurX% = DoorOut%) AND (CurY% = 1)) THEN NotFoundYet% = %FALSE
   LOOP WHILE (NotFoundYet% = %TRUE)
   CALL DrawPiece(LastCurX%,LastCurY%,TokenColor%,1)
   CALL DrawPiece(CurX%,CurY%,TokenColor%,0)
   IF Cmd$ <> "DEMO" THEN SOUND 500,10
RETURN
'=========================================== Determine if XY to XY move is Okay
DEF FnBlocked%(OldX%,OldY%,NewX%,NewY%)
   SHARED CellSize%,CellsTall%,CellsWide%
   LOCAL TestDirect%,XPoint%,YPoint%
   IF ((NewX%<1) OR (NewX%>CellsTall%) OR _
       (NewY%<1) OR (NewY%>CellsWide%)) THEN
      FnBlocked% = %TRUE
   ELSE
      IF OldX% = NewX% THEN
         IF OldY% > NewY% THEN TestDirect% = %LEFT ELSE TestDirect% = %RIGHT
      ELSE
         IF OldX% > NewX% THEN TestDirect% = %Up ELSE TestDirect% = %DOWN
      END IF
      Xpoint% = ((CurX% - 1) *  CellSize%) + 1
      Ypoint% = ((CurY% - 1) * (CellSize% * 2)) + 1
      SELECT CASE TestDirect%
         CASE %UP    : DECR Xpoint%                      ' Up
         CASE %RIGHT : Ypoint%=Ypoint%+((CellSize%*2)-1) ' Right
         CASE %DOWN  : Xpoint%=Xpoint%+(CellSize%-1)     ' Down
         CASE %LEFT  : DECR Ypoint%                      ' Left
      END SELECT
      IF POINT(Ypoint%,Xpoint%) THEN FnBlocked% = %TRUE ELSE FnBlocked% = %FALSE
   END IF
END DEF
'==================================================================== Draw Maze
DrawMaze:
   LINE (0,0) - (FrameRight%, FrameBottom%), WallColor%, B
   HalfWallsToDraw% = int(WallsToDraw% / 2)
   WHILE (WallsToDraw% > HalfWallsToDraw%)
      IF INKEY$>"" THEN GOSUB ExitRequested
      DO
         MostX% = FnR%(CellsTall%)
         MostY% = FnR%(CellsWide%)
      LOOP WHILE (Walls%(MostX%,MostY%) = 1)
      GOSUB DrawWall
   WEND
   CyclicMostX% = 1
   CyclicMostY% = 1
   WHILE (WallsToDraw% > 0)
      IF INKEY$>"" THEN GOSUB ExitRequested
      DO
         INCR CyclicMostY%
         IF CyclicMostY% = CellsWide% THEN
            CyclicMostY% = 1
            INCR CyclicMostX%
            IF CyclicMostX% = CellsTall% THEN CyclicMostX% = 1
         END IF
      LOOP WHILE (Walls%(CyclicMostX%,CyclicMostY%) = 1)
      MostX% = CyclicMostX%
      MostY% = CyclicMostY%
      GOSUB DrawWall
   WEND
RETURN
'=========================================================== Draw players piece
SUB DrawPiece(AtX%, AtY%, UseColor%, DroppingMark%)
   LOCAL  TopXcoord%,TopYcoord%,BotXcoord%,BotYCoord%,CenterY%,CenterX%,Rads%
   SHARED CellSize%, PColorON%, CrumbColor%
   TopXcoord% = ((AtX% - 1) *  CellSize%) + 1
   TopYcoord% = ((AtY% - 1) * (CellSize% * 2)) + 1
   BotXcoord% = (TopXcoord% + CellSize%) - 2
   BotYcoord% = (TopYcoord% + (CellSize% * 2)) - 2
   IF DroppingMark% THEN
      LINE (TopYcoord%, TopXcoord%) - (BotYcoord%, BotXcoord%), 0, BF
      CenterY% = TopYcoord%+CellSize%
      CenterX% = TopXcoord%+FIX(CellSize%/2)
      Rads% = INT(CellSize% / 3)
      IF CellSize% = 2 THEN
         PSET (TopYcoord%+1, TopXCoord%), CrumbColor%
      ELSE
         IF Rads% < 3 THEN
            PSET (CenterY%, CenterX%), CrumbColor%
         ELSE
            CIRCLE (CenterY%, CenterX%), Rads%, CrumbColor%
         END IF
      END IF
   ELSE
      LINE (TopYcoord%, TopXcoord%) - (BotYcoord%, BotXcoord%), UseColor%, BF
   END IF
END SUB
'================================================== Print Title & Current Level
PrintLine25:
   LOCATE 25,1
   PRINT SPACE$(79);
   LOCATE 25,1
   PRINT "MAD MAZES!  Copyright 1989 Frederick Volking  V:1.0  Level: ";
   PRINT USING "## of 10";Cycle%;
RETURN
'==================================================================== Draw Wall
DrawWall:
      FOR Which% = 1 TO 0 STEP (-1)
         Direc% = FnR%(4)
         InitMostX% = MostX%
         InitMostY% = MostY%
         WHILE (Walls%(MostX%,MostY%) = Which%)
            SELECT CASE Direc%
               CASE = 1 : DECR MostX%  'Up
               CASE = 2 : INCR MostY%  'Right
               CASE = 3 : INCR MostX%  'Down
               CASE = 4 : DECR MostY%  'Left
            END SELECT
            IF ((MostX% < 0) OR (MostX% > CellsTall%) OR _
                (MostY% < 0) OR (MostY% > CellsWide%)) THEN
                IF Direc% = 4 THEN Direc% = 1 _
                   ELSE INCR Direc%
                MostX% = InitMostX%
                MostY% = InitMostY%
             END IF
         WEND
      NEXT
      SELECT CASE Direc%
         CASE = 1 : LastDirec% = 3  'Up
         CASE = 2 : LastDirec% = 4  'Right
         CASE = 3 : LastDirec% = 1  'Down
         CASE = 4 : LastDirec% = 2  'Left
      END SELECT
      LastX% = MostX% * CellSize%
      LastY% = (MostY% * 2) * CellSize%
      DeadEndReached% = %FALSE
      DO
         Cycles% = 0
         KeepLooking% = %TRUE
         DO
            INCR Cycles%
            NewX% = LastX%
            NewY% = LastY%
            Direc% = LastDirec%
            Turn% = (FnR%(3)-2)
            IF Turn%<>0 THEN
               Direc% = Direc% + Turn%
               IF Direc% > 4 THEN Direc% = 1
               IF Direc% < 1 THEN Direc% = 4
            END IF
            SELECT CASE Direc%
               CASE = 1 : NewX% = LastX% -  CellSize%       'up
               CASE = 2 : NewY% = LastY% + (CellSize% * 2)  'right
               CASE = 3 : NewX% = LastX% +  CellSize%       'down
               CASE = 4 : NewY% = LastY% - (CellSize% * 2)  'left
            END SELECT
            IF Cycles% < 10 THEN
               IF ((NewX% => FrameBottom%) OR (NewX% <= 0) OR _
                   (NewY% => FrameRight% ) OR (NewY% <= 0) ) THEN
                  KeepLooking% = %TRUE
               ELSE
                  XC% = FIX(NewX% / CellSize%)
                  YC% = FIX(NewY% / (CellSize% * 2))
                  IF Walls%(XC%,YC%) = 0 THEN KeepLooking% = %FALSE _
                     ELSE KeepLooking% = %TRUE
               END IF
            ELSE
               KeepLooking% = %FALSE
            END IF
         LOOP WHILE (KeepLooking% = %TRUE)
         IF Cycles% < 10 THEN
            LINE (LastY%,LastX%) - (NewY%,NewX%), WallColor%
            Walls%(XC%,YC%) = 1
            DECR WallsToDraw%
            LastX% = NewX%
            LastY% = NewY%
            LastDirec% = Direc%
            DeadEndReached% = %FALSE
         ELSE
            DeadEndReached% = %TRUE
         END IF
      LOOP WHILE (DeadEndReached% = %FALSE)
RETURN
'============================================================== Exit Requested?
ExitRequested:
   LOCATE 25,1 : PRINT SPACE$(79);
   LOCATE 25,34
   PRINT "Quit? (Y/N) : ";
   DO
      K$ = UCASE$(INKEY$)
   LOOP WHILE ((K$ <> "Y") AND (K$ <> "N") AND (K$ <> CHR$(27)))
   IF K$ = "Y" THEN
      IF MazeIsDrawn% = %TRUE THEN
         LOCATE 25,1 : PRINT SPACE$(79);
         LOCATE 25,25
         PRINT "Shall I Solve It? (Y/N) : ";
         DO
            K$ = UCASE$(INKEY$)
         LOOP WHILE ((K$ <> "Y") AND (K$ <> "N") AND (K$ <> CHR$(27)))
         IF K$ = "N" THEN
            SCREEN 0,0
            CLS
            END
         END IF
         IF K$ = "Y" THEN
            AutoSolve% = %TRUE
            KeepGoing% = %FALSE
         END IF
      ELSE
         SCREEN 0,0
         CLS
         END
      END IF
   END IF
   GOSUB PrintLine25
RETURN
'============================= Display Total elapsed playing time for this maze
ShowElapsed:
   TimerNow! = TIMER
   TotTime! = TimerNow! - BeginTimer!
   Minutes% = FIX(TotTime! / 60)
   Seconds% = INT(TotTime! - (Minutes% * 60))
   IF Seconds% <> LastSeconds% THEN
      LOCATE 25, 73, 0
      PRINT USING "###";Minutes%;
      PRINT ":";
      PRINT RIGHT$(STR$(Seconds%+100),2);
      LastSeconds% = Seconds%
   END IF
RETURN
'======================================= Display Time required to complete maze
ShowTotalMazeTime:
      TimerNow! = TIMER
      TotTime!  = TimerNow! - BeginTimer!
      Minutes%  = FIX(TotTime! / 60)
      LSeconds! = TotTime! - (Minutes% * 60)
      LOCATE 25,1 : PRINT SPACE$(79);
      LOCATE 25,1
      IF AutoSolve% = %TRUE THEN PRINT "COMPUTER's "; _
         ELSE PRINT "Your ";
      PRINT "time to complete level";Cycle%;"was: ";
      IF Minutes% > 0 THEN PRINT Minutes%; "Minute(s) ";
      PRINT USING "##.# Seconds  - Press <ANY KEY>";LSeconds!;
      IF Cmd$ <> "DEMO" THEN
         WHILE INKEY$ = "" : WEND
      END IF
RETURN
'====================================================== ReDefine and Set Colors
SetUpColors:
   CLS
   DIM DYNAMIC TempColor%(3)
   TempColor%(1) = WallColor%
   TempColor%(2) = TokenColor%
   TempColor%(3) = CrumbColor%
   FOR C% = 1 to 15
      LINE (29+(c%*32),30) - (29+(C%*32)+20,70), C%, BF
      LOCATE 10, (c%*4)+5
      PRINT USING "##";C%;
   NEXT
   LOCATE 14,20 : PRINT "Color for Maze Walls     : ";
   LOCATE 16,20 : PRINT "Color for Player's Token : ";
   LOCATE 18,20 : PRINT "Color for Bread Crumbs   : ";
   LOCATE 21,20 : PRINT "Press - <Up> & <Down> to Select";
   LOCATE 22,20 : PRINT "      - <Left> & <Right> to change color";
   LOCATE 2,20 : PRINT "       <ENTER> when finished";
   CurLine% = 1
   DO
      IF CurLine% < 1 THEN CurLine% = 3
      IF CurLine% > 3 THEN CurLine% = 1
      FOR C% = 1 to 3
         IF TempColor%(C%) <  1 THEN TempColor%(C%)= 15
         IF TempColor%(C%) > 15 THEN TempColor%(C%) = 1
         LOCATE ((C% - 1) * 2) + 14, 47
         PRINT USING "##     ";TempColor%(C%);
      NEXT
      LOCATE ((CurLine% - 1) * 2) + 14, 50
      PRINT "<--";
      DO
         KeyChoice$ = INKEY$
      LOOP WHILE KeyChoice$ = ""
      Choice% = ASC(RIGHT$(KeyChoice$,1))
      SELECT CASE Choice%
         CASE 72 : DECR CurLine%             ' Up
         CASE 80 : INCR CurLine%             ' Down
         CASE 77 : INCR TempColor%(CurLine%) ' Right
         CASE 75 : DECR TempColor%(CurLine%) ' Left
         CASE 27 : GOSUB ExitRequested
      END SELECT
   LOOP WHILE (KeyChoice$ <> CHR$(13))
   CLS
   WallColor% = TempColor%(1)
   TokenColor% = TempColor%(2)
   CrumbColor% = TempColor%(3)
   ERASE TempColor%
RETURN
'=============================================================================
DEF FnStartTimer%(Long%)
   SHARED Elapsed&,CountDown%
   IF Long% = 0 THEN
      CountDown% = %FALSE
      Elapsed& = 0
   ELSE
      CountDown% = %TRUE
      Elapsed& = (CLNG(Long%)) * 997564
   END IF
   MTIMER
END DEF
'=============================================================================
DEF FnSecondsElapsed%(TUR%,TUC%)
   SHARED Elapsed&,CountDown%
   LOCAL TimeSinceLast&, K%
   TimeSinceLast&=MTIMER
   MTIMER
   Elapsed& = Elapsed& - TimeSinceLast&
   IF Elapsed& < 0 THEN Elapsed& = 0
   K% = FnShowTime(Elapsed&)
   FnSecondsElapsed% = K%
END DEF
'=============================================================================
DEF FnShowTime%(HowMuch&)
   SHARED LastSecond%,CountDown%
   LOCAL Minutes%, HoldSeconds%
   HoldSeconds%=INT(FIX(HowMuch&/997564))
   Minutes%=INT(FIX(HowMuch&/59853831))
   HowMuch&=HowMuch&-(CLNG(Minutes%) * 59853831)
   Seconds%=INT(FIX(HowMuch&/997564))
   IF LastSecond%<>HoldSeconds% THEN
      LOCATE 25,73
      PRINT USING "###";Minutes%;
      PRINT ":";
      PRINT RIGHT$(STR$(Seconds%+100),2);
      LastSecond%=HoldSeconds%
   END IF
   FnShowTime%=HoldSeconds%
END DEF
'=========================================================== End Of Programming

