PROGRAM Sort;
CONST
  LSize = 40;
TYPE
  List = ARRAY[1..LSize] of INTEGER;
VAR
  AList: List;
  Count: INTEGER;

PROCEDURE ShellSort(
  VAR L  { List to be sorted }
    :List;
  N      { No. of items to be sorted }
    :INTEGER
   );

VAR
  Distance, StageNo, Loc : INTEGER;
  StageOver: BOOLEAN;

PROCEDURE Swap( VAR X, Y : INTEGER );
VAR Temp:INTEGER;
BEGIN
  Temp := X;
  X := Y;
  Y := Temp
END;

BEGIN              { ShellSort }
  Distance := N DIV 2;
  WHILE Distance > 0  DO
    BEGIN
      FOR StageNo := Distance TO N-1  DO
        BEGIN
          StageOver := False;
          Loc := StageNo+1;
          WHILE (Loc-Distance>0) AND NOT StageOver DO
            BEGIN
              IF L[Loc] < L[Loc-Distance]
                 THEN Swap( L[Loc],L[Loc-Distance] )
                 ELSE StageOver := True;
              Loc := Loc - Distance
            END
        END;
      Distance := Distance DIV 2
    END
END;              { ShellSort }

BEGIN              { Try }
  FOR Count := 1 TO LSize DO
    AList[Count] := TRUNC(RANDOM*900);
  ShellSort( AList, LSize );
  FOR Count := 1 TO LSize DO
    Write( AList[Count]:4 )
END.