/* advfio.c - file i/o routines for the adventure compiler */
/*
	Copyright (c) 1986, by David Michael Betz
	All rights reserved
*/

#define BSIZE	8192

/* global variables */
long ad_foff;

/* local variables */
static char buf[BSIZE];
static int boff;
static int fd;

ad_create(name)
  char *name;
{
    /* create the file */
    if (!advcreate(name,&fd))
	advfatal("can't create output file");
	
    /* initialize the buffer and file offset */
    ad_foff = 0L;
    boff = 0;
}

ad_close()
{
    ad_flush();
    if (!advclose(fd))
	advfatal("error closing output file");
}

ad_putc(ch)
  int ch;
{
    buf[boff++] = ch; ad_foff++;
    if (boff >= BSIZE)
	ad_flush();
}

ad_seek(pos)
  long pos;
{
    ad_flush();
    if (!advseek(fd,pos,0))
	advfatal("error positioning output file");
    ad_foff = pos;
}

ad_flush()
{
    if (boff) {
	if (!advwrite(fd,buf,boff))
	    advfatal("error writing to output file");
	boff = 0;
    }
}
