(*-------------------------------------------------------*)
(*   THIS CODE IS THE PROPERTY OF A.I.SOFTWARE, IT MAY   *)
(*   NOT BE PUBLICLY DISTRIBUTED IN ANY FORM AND IT      *)
(*   MAY ONLY BE COPIED AND/OR MODIFIED FOR PERSONAL USE *)
(*-------------------------------------------------------*)
(* Chester, the intelligent chinese checkers program.    *)
(*                                                       *)
(* (C) Copyright 1985 A.I.SOFTWARE                       *)
(*                                                       *)
(* ------------------------------------------------------*)
(*                    Search module.                     *)
(*-------------------------------------------------------*)


  PROCEDURE INIT1_LAND_NODES;
  BEGIN

    LNSP1                := 0 ;
    LAND1_NODES[0].ND    := 0;
    LAND1_NODES[0].LNGTH := 0;

  END; (* INIT1_LAND_NODES *)

  PROCEDURE PUSH_LN1(N,L:BYTE);
  BEGIN

    IF LNSP1 < 100 THEN BEGIN

      LNSP1                     := LNSP1 + 1;
      LAND1_NODES[LNSP1].ND     := N;
      LAND1_NODES[LNSP1].LNGTH  := L;

    END;

  END; (* PUSH_LN1 *)

  PROCEDURE POP_LN1(VAR N,L:BYTE);
  BEGIN

    N := LAND1_NODES[LNSP1].ND;
    L := LAND1_NODES[LNSP1].LNGTH;
    IF LNSP1 > 0 THEN LNSP1 := LNSP1 - 1 ;

  END; (* POP_LN1 *)


  PROCEDURE INIT2_LAND_NODES;
  BEGIN

    LNSP2          := 0;
    LAND2_NODES[0] := 0;

  END; (* INIT2_LAND_NODES *)

  PROCEDURE PUSH_LN2(N:BYTE);
  BEGIN

    IF LNSP2 < 100 THEN BEGIN

      LNSP2              := LNSP2 + 1;
      LAND2_NODES[LNSP2] := N;

    END;

  END; (* PUSH_LN2 *)

  PROCEDURE POP_LN2(VAR N:BYTE);
  BEGIN

    N := LAND2_NODES[LNSP2];
    IF LNSP2 > 0 THEN LNSP2 := LNSP2 - 1 ;

  END; (* POP_LN2 *)


PROCEDURE SEARCH_BOARD(PSH,LOOK_BACK:BOOLEAN; ST,CURR,J,MDE:BYTE ;
                  VAR
                    FROM_ND,
                    TO_ND,
                    LOC,
                    LNG,
                    DEST    :BYTE);
TYPE

  ND = RECORD
         NEIGHBOR :BYTE;
         FATHER_ND:BYTE;
         LENGTH_ND:BYTE;
         CAME_FROM:BYTE;
       END;
VAR

  STACK  :ARRAY[0..300] OF ND;
  SP     :BYTE;
  CUR    :BYTE;
  LTH    :BYTE;
  FATH   :BYTE;
  BACK   :BOOLEAN;
  SIDE   :BOOLEAN;
  CYCLES :BOOLEAN;
  HOLE   :BYTE;
  VISITED:SET OF BYTE;
  JMP    :BYTE;



  PROCEDURE INIT_STACK;
  BEGIN

    SP:=0;
    STACK[0].NEIGHBOR :=0;
    STACK[0].FATHER_ND:=0;
    STACK[0].LENGTH_ND:=100;
    STACK[0].CAME_FROM:=0;

  END; (* INIT_STACK *)

  PROCEDURE PUSH(NBR,LNTH,FATH,CF:BYTE);
  BEGIN

    IF SP <= 299 THEN BEGIN
      SP:=SP+1;
      STACK[SP].NEIGHBOR :=NBR;
      STACK[SP].FATHER_ND:=FATH;
      STACK[SP].LENGTH_ND:=LNTH;
      STACK[SP].CAME_FROM:=CF;
    END;

  END; (* PUSH *)

  PROCEDURE POP(VAR N,L,F,C:BYTE);
  BEGIN

    N:=STACK[SP].NEIGHBOR;
    F:=STACK[SP].FATHER_ND;
    L:=STACK[SP].LENGTH_ND;
    C:=STACK[SP].CAME_FROM;
    IF SP > 0 THEN SP:=SP-1;

  END; (* POP *)

  PROCEDURE CHECK_NEIGHBORS(CURRENT_ND,LNGTH:BYTE);
  VAR
    BK           :BOOLEAN;
    I,X,NEIGHB   :BYTE;
  BEGIN

    FOR I:=1 TO 6 DO BEGIN
      NEIGHB:= 0;
      BK    := FALSE;
      CASE ST OF
       1 :CASE I OF
            1:NEIGHB:=BOARD[CURRENT_ND].SE;
            2:NEIGHB:=BOARD[CURRENT_ND].SW;
            3:NEIGHB:=BOARD[CURRENT_ND].CR;
            4:NEIGHB:=BOARD[CURRENT_ND].CL;
            5:IF LOOK_BACK THEN BEGIN
                BK     := TRUE;
                NEIGHB := BOARD[CURRENT_ND].NW;
              END;
            6:IF LOOK_BACK THEN BEGIN
                BK     := TRUE;
                NEIGHB := BOARD[CURRENT_ND].NE;
              END;
           END;
       2 :CASE I OF
            1:NEIGHB:=BOARD[CURRENT_ND].CL;
            2:NEIGHB:=BOARD[CURRENT_ND].SW;
            3:NEIGHB:=BOARD[CURRENT_ND].NW;
            4:NEIGHB:=BOARD[CURRENT_ND].SE;
            5:IF LOOK_BACK THEN BEGIN
                BK     := TRUE;
                NEIGHB := BOARD[CURRENT_ND].CR;
              END;
            6:IF LOOK_BACK THEN BEGIN
                BK     := TRUE;
                NEIGHB := BOARD[CURRENT_ND].NE;
              END;
          END;
       3 :CASE I OF
            1:NEIGHB:=BOARD[CURRENT_ND].CL;
            2:NEIGHB:=BOARD[CURRENT_ND].NW;
            3:NEIGHB:=BOARD[CURRENT_ND].SW;
            4:NEIGHB:=BOARD[CURRENT_ND].NE;
            5:IF LOOK_BACK THEN BEGIN
                BK     := TRUE;
                NEIGHB := BOARD[CURRENT_ND].SE;
              END;
            6:IF LOOK_BACK THEN BEGIN
                BK     := TRUE;
                NEIGHB := BOARD[CURRENT_ND].CR;
              END;
          END;
       4 :CASE I OF
            1:NEIGHB:=BOARD[CURRENT_ND].NE;
            2:NEIGHB:=BOARD[CURRENT_ND].NW;
            3:NEIGHB:=BOARD[CURRENT_ND].CR;
            4:NEIGHB:=BOARD[CURRENT_ND].CL;
            5:IF LOOK_BACK THEN BEGIN
                BK     := TRUE;
                NEIGHB := BOARD[CURRENT_ND].SW;
              END;
            6:IF LOOK_BACK THEN BEGIN
                BK     := TRUE;
                NEIGHB := BOARD[CURRENT_ND].SE;
              END;
           END;
        5 :CASE I OF
            1:NEIGHB:=BOARD[CURRENT_ND].CR;
            2:NEIGHB:=BOARD[CURRENT_ND].NE;
            3:NEIGHB:=BOARD[CURRENT_ND].NW;
            4:NEIGHB:=BOARD[CURRENT_ND].SE;
            5:IF LOOK_BACK THEN BEGIN
                BK     := TRUE;
                NEIGHB := BOARD[CURRENT_ND].CL;
              END;
            6:IF LOOK_BACK THEN BEGIN
                BK     := TRUE;
                NEIGHB := BOARD[CURRENT_ND].SW;
              END;
           END;
       6 :CASE I OF
            1:NEIGHB:=BOARD[CURRENT_ND].CR;
            2:NEIGHB:=BOARD[CURRENT_ND].SE;
            3:NEIGHB:=BOARD[CURRENT_ND].SW;
            4:NEIGHB:=BOARD[CURRENT_ND].NE;
            5:IF LOOK_BACK THEN BEGIN
                BK     := TRUE;
                NEIGHB := BOARD[CURRENT_ND].NW;
              END;
            6:IF LOOK_BACK THEN BEGIN
                BK     := TRUE;
                NEIGHB := BOARD[CURRENT_ND].CL;
              END;
          END;

      END;
      IF NEIGHB <> 0 THEN BEGIN

      (* Checking for illegal moves by opponent      *)

          IF (CURRENT_ND = FROM_ND)AND(BOARD[NEIGHB].COLOR = 7)
             AND(NEIGHB = TO_ND)
          THEN CHEAT:=FALSE;

          FOR X := 1 TO NUM_SETS DO
            IF (BOARD[NEIGHB].COLOR = PLAY_SETS[X].CT)
            OR (BOARD[NEIGHB].COLOR = PLAY_SETS[X].OP)
            THEN PUSH(NEIGHB,LNGTH,I,CURRENT_ND);

      END;

    END;

  END; (* CHECK_NEIGHBOR *)

BEGIN (* SEARCH_BOARD *)

  INIT_STACK;
  LNG     := 100;
  CHECK_NEIGHBORS(CURR,100);
  VISITED := [];
  POP(CUR,LTH,FATH,JMP);
  WHILE CUR <> 0 DO BEGIN

    SIDE := FALSE;
    BACK := FALSE;
    HOLE := 255;
    CASE ST OF
      1  :CASE FATH OF
            1:IF BOARD[CUR].SE <> 0 THEN HOLE := BOARD[CUR].SE;

            2:IF BOARD[CUR].SW <> 0 THEN HOLE := BOARD[CUR].SW;

            3:IF BOARD[CUR].CR <> 0 THEN BEGIN

                HOLE := BOARD[CUR].CR;
                SIDE := TRUE;

              END;
            4:IF BOARD[CUR].CL <> 0 THEN BEGIN

                HOLE := BOARD[CUR].CL;
                SIDE := TRUE;

              END;
            5:IF BOARD[CUR].NW <> 0 THEN BEGIN

                HOLE := BOARD[CUR].NW;
                BACK := TRUE;

              END;
            6:IF BOARD[CUR].NE <> 0 THEN BEGIN

                HOLE := BOARD[CUR].NE;
                BACK := TRUE;

              END;
          END;
      2  :CASE FATH OF
            1:IF BOARD[CUR].CL <> 0 THEN HOLE := BOARD[CUR].CL;

            2:IF BOARD[CUR].SW <> 0 THEN HOLE := BOARD[CUR].SW;

            3:IF BOARD[CUR].NW <> 0 THEN BEGIN

                HOLE := BOARD[CUR].NW;
                SIDE := TRUE;

              END;
            4:IF BOARD[CUR].SE <> 0 THEN BEGIN

                HOLE := BOARD[CUR].SE;
                SIDE := TRUE;

              END;
            5:IF BOARD[CUR].CR <> 0 THEN BEGIN

                HOLE := BOARD[CUR].CR;
                BACK := TRUE;

              END;
            6:IF BOARD[CUR].NE <> 0 THEN BEGIN

                HOLE := BOARD[CUR].NE;
                BACK := TRUE;

              END;
          END;
      3  :CASE FATH OF
            1:IF BOARD[CUR].CL <> 0 THEN HOLE := BOARD[CUR].CL;

            2:IF BOARD[CUR].NW <> 0 THEN HOLE := BOARD[CUR].NW;

            3:IF BOARD[CUR].SW <> 0 THEN BEGIN

                HOLE := BOARD[CUR].SW;
                SIDE := TRUE;

              END;
            4:IF BOARD[CUR].NE <> 0 THEN BEGIN

                HOLE := BOARD[CUR].NE;
                SIDE := TRUE;

              END;
            5:IF BOARD[CUR].SE <> 0 THEN BEGIN

                HOLE := BOARD[CUR].SE;
                BACK := TRUE;

              END;
            6:IF BOARD[CUR].CR <> 0 THEN BEGIN

                HOLE := BOARD[CUR].CR;
                BACK := TRUE;

              END;
          END;
      4  :CASE FATH OF
            1:IF BOARD[CUR].NE <> 0 THEN HOLE := BOARD[CUR].NE;

            2:IF BOARD[CUR].NW <> 0 THEN HOLE := BOARD[CUR].NW;

            3:IF BOARD[CUR].CR <> 0 THEN BEGIN

                HOLE := BOARD[CUR].CR;
                SIDE := TRUE;

              END;
            4:IF BOARD[CUR].CL <> 0 THEN BEGIN

                HOLE := BOARD[CUR].CL;
                SIDE := TRUE;

              END;
            5:IF BOARD[CUR].SW <> 0 THEN BEGIN

                HOLE := BOARD[CUR].SW;
                BACK := TRUE;

              END;
            6:IF BOARD[CUR].SE <> 0 THEN BEGIN

                HOLE := BOARD[CUR].SE;
                BACK := TRUE;

              END;
          END;
      5  :CASE FATH OF
            1:IF BOARD[CUR].CR <> 0 THEN HOLE := BOARD[CUR].CR;

            2:IF BOARD[CUR].NE <> 0 THEN HOLE := BOARD[CUR].NE;

            3:IF BOARD[CUR].NW <> 0 THEN BEGIN

                HOLE := BOARD[CUR].NW;
                SIDE := TRUE;

              END;
            4:IF BOARD[CUR].SE <> 0 THEN BEGIN

                HOLE := BOARD[CUR].SE;
                SIDE := TRUE;

              END;
            5:IF BOARD[CUR].CL <> 0 THEN BEGIN

                HOLE := BOARD[CUR].CL;
                BACK := TRUE;

              END;
            6:IF BOARD[CUR].SW <> 0 THEN BEGIN

                HOLE := BOARD[CUR].SW;
                BACK := TRUE;

              END;
          END;
      6  :CASE FATH OF
            1:IF BOARD[CUR].CR <> 0 THEN HOLE := BOARD[CUR].CR;

            2:IF BOARD[CUR].SE <> 0 THEN HOLE := BOARD[CUR].SE;

            3:IF BOARD[CUR].SW <> 0 THEN BEGIN

                HOLE := BOARD[CUR].SW;
                SIDE := TRUE;

              END;
            4:IF BOARD[CUR].NE <> 0 THEN BEGIN

                HOLE := BOARD[CUR].NE;
                SIDE := TRUE;

              END;
            5:IF BOARD[CUR].NW <> 0 THEN BEGIN

                HOLE := BOARD[CUR].NW;
                BACK := TRUE;

              END;
            6:IF BOARD[CUR].CL <> 0 THEN BEGIN

                HOLE := BOARD[CUR].CL;
                BACK := TRUE;

              END;
          END;
    END;  (* Case to determine relative location and status of node *)

    IF HOLE <> 255 THEN BEGIN
      (* Service to legality  check *)

      IF (HOLE = TO_ND)AND(BOARD[HOLE].COLOR = 7)
      THEN CHEAT := FALSE;

      (* Check for cycles *)

      CYCLES:=FALSE;
      IF HOLE IN VISITED
      THEN CYCLES  := TRUE
      ELSE VISITED := VISITED + [ HOLE ] ;

      (* backtracking is done inside following IF *)

      IF (BOARD[HOLE].COLOR = 7) AND ( NOT CYCLES) THEN BEGIN

        CASE SIDE OF
          TRUE :IF LTH > LNG THEN BEGIN
                  LNG  := LTH;
                  DEST := HOLE;
                END;
          FALSE:BEGIN
                  IF BACK THEN LTH:= LTH - 1
                  ELSE         LTH:= LTH + 1;
                  IF LTH > LNG THEN BEGIN
                     LNG   := LTH;
                     DEST  := HOLE;
                  END;
                END;
        END;(* Case side of *)

        PATH[ HOLE ] := JMP;
        IF PSH AND (NOT BACK) AND (LTH >= LNG) THEN  PUSH_LN1(HOLE,LTH);
        IF PLAN_END AND (NOT BACK) AND (LTH >= LNG) THEN PUSH_LN2(HOLE);
        CHECK_NEIGHBORS(HOLE,LTH);

      END;  (* If hole empty and not cycle - backtracking *)

    END;    (* If hole <> 255 *)
    POP(CUR,LTH,FATH,JMP);

  END; (* While there are nodes to check *)

END; (* SEARCH_BOARD *)


PROCEDURE FIND_LONGEST_MOVE(PSH:BOOLEAN;MDE:BYTE;
                            VAR
                              FROM_ND,
                              TO_ND,
                              LOC,
                              LONGEST,
                              TOT_LEN  :BYTE);
VAR

  I       :BYTE;
  LNG     :BYTE;
  CURR    :BYTE;
  DEST    :BYTE;
  ST      :BYTE;

BEGIN

  CASE MDE OF
    1:ST := CHESTER_SET;
    2:ST := OPPONENT_SET;
  END;

  TOT_LEN      := 0;
  FROM_ND      := 0;
  LONGEST      := 100;
  FOR I:= 1 TO 10 DO BEGIN

    SEARCH_BOARD(PSH,TRUE,ST,PLAYERS[ST][I],I,MDE,
                 FROM_ND,TO_ND,LOC,LNG,DEST);
    IF LNG > 100
    THEN TOT_LEN := TOT_LEN + (BOARD[PLAYERS[ST][I]].DIST[ST]
                            -  BOARD[DEST          ].DIST[ST]);
    IF LONGEST < LNG THEN BEGIN

      FROM_ND  := PLAYERS[ST][I] ;
      TO_ND    := DEST;
      LOC      := I;
      LONGEST  := LNG;

    END; (* remember longest move for this set *)

  END;

END; (* FIND_LONGEST_MOVE *)


PROCEDURE BEFORE_AFTER(MD,W:BYTE; VAR BL,AL,TF,ST,TL,ND,LCT:BYTE);
VAR
  I,TPOP,TPCT,TTL:BYTE;
  TT,TLC,L ,TTF  :BYTE;
BEGIN

  IF NUM_PLAYERS = 0 THEN BEGIN

    TPCT := CHESTER_SET;
    TPOP := OPPONENT_SET;
    CASE W OF
      1:BEGIN BL := 0; TTF := TF; END;
      2:BEGIN AL := 0; TL  := 0;  END;
    END;
    FOR I:= 1 TO NUM_SETS DO BEGIN

      CHESTER_SET  := PLAY_SETS[I].CT;
      OPPONENT_SET := PLAY_SETS[I].OP;
      FIND_LONGEST_MOVE(FALSE,MD,TF,TT,TLC,L,TTL);
      IF L > 100 THEN L:= L - 100 ELSE L :=0;
      CASE W OF
        1:BEGIN
            IF BL  <= L THEN BL := L;
            TF := TTF;
          END;
        2:IF AL  <= L THEN BEGIN
            TL  := TTL;
            AL  := L;
            ND  := TT;
            LCT := TLC;
            CASE MD OF
              1:ST := CHESTER_SET;
              2:ST := OPPONENT_SET;
            END;
          END;
      END;

    END;
    CHESTER_SET  := TPCT;
    OPPONENT_SET := TPOP;
  END
  ELSE BEGIN

    OPPONENT_SET  := ST;
    IF ST = 3 THEN CHESTER_SET := 6
    ELSE CHESTER_SET := (ST + 3) MOD 6;
    FIND_LONGEST_MOVE(FALSE,MD,TF,ND,LCT,AL,TTL);
    IF AL > 100 THEN AL := AL - 100 ELSE AL := 0;

  END;

END; (* BEFORE_AFTER *)


PROCEDURE GET_PATH(ST,FROM_NODE,TO_NODE:BYTE);
VAR

  J,I,
  T1,T2,
  T3,T4,T5,
  LOC      :BYTE;

BEGIN

  LOC := 1;
  WHILE PLAYERS[ST][LOC] <> TO_NODE DO LOC := LOC + 1;
  IF ((BOARD[FROM_NODE].DIST[ST] - BOARD[TO_NODE].DIST[ST]) > 1)
  THEN BEGIN

    FOR J:= 1 TO 121 DO PATH[J] := 0;
    SEARCH_BOARD(FALSE,TRUE,ST,FROM_NODE,LOC,1, T1,T2,T3,T4,T5);
    PATH_LENGTH            := 1;
    MOVE_PATH[PATH_LENGTH] := TO_NODE;
    WHILE MOVE_PATH[PATH_LENGTH] <> FROM_NODE DO BEGIN

      PATH_LENGTH            := PATH_LENGTH + 1;
      MOVE_PATH[PATH_LENGTH] := PATH[MOVE_PATH[PATH_LENGTH - 1]];

    END;
  END
  ELSE BEGIN

    PATH_LENGTH                := 2;
    MOVE_PATH[PATH_LENGTH - 1] := TO_NODE;
    MOVE_PATH[PATH_LENGTH    ] := FROM_NODE;

  END;

END; (* GET_PATH *)


